--
-- PostgreSQL database dump
--

-- Dumped from database version 15.3 (Debian 15.3-1.pgdg120+1)
-- Dumped by pg_dump version 16.1 (Ubuntu 16.1-1.pgdg22.04+1)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: pg_trgm; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS pg_trgm WITH SCHEMA public;


--
-- Name: EXTENSION pg_trgm; Type: COMMENT; Schema: -; Owner: -
--

COMMENT ON EXTENSION pg_trgm IS 'text similarity measurement and index searching based on trigrams';


SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: auth_totp_device; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.auth_totp_device (
    id integer NOT NULL,
    name character varying NOT NULL,
    user_id integer NOT NULL,
    scope character varying,
    index character varying(8),
    key character varying,
    create_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'utc'::text),
    CONSTRAINT auth_totp_device_index_check CHECK ((char_length((index)::text) = 8))
);


--
-- Name: auth_totp_device_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.auth_totp_device_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: auth_totp_device_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.auth_totp_device_id_seq OWNED BY public.auth_totp_device.id;


--
-- Name: auth_totp_wizard; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.auth_totp_wizard (
    id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    secret character varying NOT NULL,
    url character varying,
    code character varying(7),
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    qrcode bytea
);


--
-- Name: TABLE auth_totp_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.auth_totp_wizard IS '2-Factor Setup Wizard';


--
-- Name: COLUMN auth_totp_wizard.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.auth_totp_wizard.user_id IS 'User';


--
-- Name: COLUMN auth_totp_wizard.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.auth_totp_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN auth_totp_wizard.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.auth_totp_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auth_totp_wizard.secret; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.auth_totp_wizard.secret IS 'Secret';


--
-- Name: COLUMN auth_totp_wizard.url; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.auth_totp_wizard.url IS 'Url';


--
-- Name: COLUMN auth_totp_wizard.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.auth_totp_wizard.code IS 'Verification Code';


--
-- Name: COLUMN auth_totp_wizard.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.auth_totp_wizard.create_date IS 'Created on';


--
-- Name: COLUMN auth_totp_wizard.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.auth_totp_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN auth_totp_wizard.qrcode; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.auth_totp_wizard.qrcode IS 'Qrcode';


--
-- Name: auth_totp_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.auth_totp_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: auth_totp_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.auth_totp_wizard_id_seq OWNED BY public.auth_totp_wizard.id;


--
-- Name: base_cache_signaling_assets; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_cache_signaling_assets
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_cache_signaling_default; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_cache_signaling_default
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_cache_signaling_routing; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_cache_signaling_routing
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_cache_signaling_templates; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_cache_signaling_templates
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_document_layout; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_document_layout (
    id integer NOT NULL,
    company_id integer NOT NULL,
    report_layout_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_document_layout; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_document_layout IS 'Company Document Layout';


--
-- Name: COLUMN base_document_layout.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_document_layout.company_id IS 'Company';


--
-- Name: COLUMN base_document_layout.report_layout_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_document_layout.report_layout_id IS 'Report Layout';


--
-- Name: COLUMN base_document_layout.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_document_layout.create_uid IS 'Created by';


--
-- Name: COLUMN base_document_layout.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_document_layout.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_document_layout.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_document_layout.create_date IS 'Created on';


--
-- Name: COLUMN base_document_layout.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_document_layout.write_date IS 'Last Updated on';


--
-- Name: base_document_layout_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_document_layout_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_document_layout_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_document_layout_id_seq OWNED BY public.base_document_layout.id;


--
-- Name: base_enable_profiling_wizard; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_enable_profiling_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    duration character varying,
    expiration timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_enable_profiling_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_enable_profiling_wizard IS 'Enable profiling for some time';


--
-- Name: COLUMN base_enable_profiling_wizard.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN base_enable_profiling_wizard.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_enable_profiling_wizard.duration; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.duration IS 'Enable profiling for';


--
-- Name: COLUMN base_enable_profiling_wizard.expiration; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.expiration IS 'Enable profiling until';


--
-- Name: COLUMN base_enable_profiling_wizard.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.create_date IS 'Created on';


--
-- Name: COLUMN base_enable_profiling_wizard.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.write_date IS 'Last Updated on';


--
-- Name: base_enable_profiling_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_enable_profiling_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_enable_profiling_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_enable_profiling_wizard_id_seq OWNED BY public.base_enable_profiling_wizard.id;


--
-- Name: base_import_import; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_import_import (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    file_name character varying,
    file_type character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    file bytea
);


--
-- Name: TABLE base_import_import; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_import_import IS 'Base Import';


--
-- Name: COLUMN base_import_import.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_import.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_import.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_import.res_model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_import.res_model IS 'Model';


--
-- Name: COLUMN base_import_import.file_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_import.file_name IS 'File Name';


--
-- Name: COLUMN base_import_import.file_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_import.file_type IS 'File Type';


--
-- Name: COLUMN base_import_import.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_import.create_date IS 'Created on';


--
-- Name: COLUMN base_import_import.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_import.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_import_import.file; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_import.file IS 'File';


--
-- Name: base_import_import_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_import_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_import_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_import_import_id_seq OWNED BY public.base_import_import.id;


--
-- Name: base_import_mapping; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_import_mapping (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    column_name character varying,
    field_name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_import_mapping; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_import_mapping IS 'Base Import Mapping';


--
-- Name: COLUMN base_import_mapping.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_mapping.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_mapping.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_mapping.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_mapping.res_model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_mapping.res_model IS 'Res Model';


--
-- Name: COLUMN base_import_mapping.column_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_mapping.column_name IS 'Column Name';


--
-- Name: COLUMN base_import_mapping.field_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_mapping.field_name IS 'Field Name';


--
-- Name: COLUMN base_import_mapping.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_mapping.create_date IS 'Created on';


--
-- Name: COLUMN base_import_mapping.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_mapping.write_date IS 'Last Updated on';


--
-- Name: base_import_mapping_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_import_mapping_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_import_mapping_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_import_mapping_id_seq OWNED BY public.base_import_mapping.id;


--
-- Name: base_import_module; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_import_module (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    state character varying,
    import_message text,
    modules_dependencies text,
    force boolean,
    with_demo boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    module_file bytea NOT NULL
);


--
-- Name: TABLE base_import_module; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_import_module IS 'Import Module';


--
-- Name: COLUMN base_import_module.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_module.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_module.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_module.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_module.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_module.state IS 'Status';


--
-- Name: COLUMN base_import_module.import_message; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_module.import_message IS 'Import Message';


--
-- Name: COLUMN base_import_module.modules_dependencies; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_module.modules_dependencies IS 'Modules Dependencies';


--
-- Name: COLUMN base_import_module.force; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_module.force IS 'Force init';


--
-- Name: COLUMN base_import_module.with_demo; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_module.with_demo IS 'Import demo data of module';


--
-- Name: COLUMN base_import_module.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_module.create_date IS 'Created on';


--
-- Name: COLUMN base_import_module.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_module.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_import_module.module_file; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_import_module.module_file IS 'Module .ZIP file';


--
-- Name: base_import_module_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_import_module_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_import_module_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_import_module_id_seq OWNED BY public.base_import_module.id;


--
-- Name: base_language_export; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_language_export (
    id integer NOT NULL,
    model_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    lang character varying NOT NULL,
    format character varying NOT NULL,
    export_type character varying NOT NULL,
    domain character varying,
    state character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    data bytea
);


--
-- Name: TABLE base_language_export; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_language_export IS 'Language Export';


--
-- Name: COLUMN base_language_export.model_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_export.model_id IS 'Model to Export';


--
-- Name: COLUMN base_language_export.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_export.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_export.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_export.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_export.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_export.name IS 'File Name';


--
-- Name: COLUMN base_language_export.lang; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_export.lang IS 'Language';


--
-- Name: COLUMN base_language_export.format; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_export.format IS 'File Format';


--
-- Name: COLUMN base_language_export.export_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_export.export_type IS 'Export Type';


--
-- Name: COLUMN base_language_export.domain; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_export.domain IS 'Model Domain';


--
-- Name: COLUMN base_language_export.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_export.state IS 'State';


--
-- Name: COLUMN base_language_export.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_export.create_date IS 'Created on';


--
-- Name: COLUMN base_language_export.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_export.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_language_export.data; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_export.data IS 'File';


--
-- Name: base_language_export_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_language_export_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_language_export_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_language_export_id_seq OWNED BY public.base_language_export.id;


--
-- Name: base_language_import; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_language_import (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying(6) NOT NULL,
    filename character varying NOT NULL,
    overwrite boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    data bytea NOT NULL
);


--
-- Name: TABLE base_language_import; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_language_import IS 'Language Import';


--
-- Name: COLUMN base_language_import.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_import.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_import.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_import.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_import.name IS 'Language Name';


--
-- Name: COLUMN base_language_import.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_import.code IS 'ISO Code';


--
-- Name: COLUMN base_language_import.filename; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_import.filename IS 'File Name';


--
-- Name: COLUMN base_language_import.overwrite; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_import.overwrite IS 'Overwrite Existing Terms';


--
-- Name: COLUMN base_language_import.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_import.create_date IS 'Created on';


--
-- Name: COLUMN base_language_import.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_import.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_language_import.data; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_import.data IS 'File';


--
-- Name: base_language_import_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_language_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_language_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_language_import_id_seq OWNED BY public.base_language_import.id;


--
-- Name: base_language_install; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_language_install (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    overwrite boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_language_install; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_language_install IS 'Install Language';


--
-- Name: COLUMN base_language_install.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_install.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_install.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_install.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_install.overwrite; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_install.overwrite IS 'Overwrite Existing Terms';


--
-- Name: COLUMN base_language_install.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_install.create_date IS 'Created on';


--
-- Name: COLUMN base_language_install.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_language_install.write_date IS 'Last Updated on';


--
-- Name: base_language_install_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_language_install_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_language_install_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_language_install_id_seq OWNED BY public.base_language_install.id;


--
-- Name: base_module_uninstall; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_module_uninstall (
    id integer NOT NULL,
    module_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    show_all boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_module_uninstall; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_module_uninstall IS 'Module Uninstall';


--
-- Name: COLUMN base_module_uninstall.module_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_uninstall.module_id IS 'Module';


--
-- Name: COLUMN base_module_uninstall.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_uninstall.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_uninstall.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_uninstall.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_uninstall.show_all; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_uninstall.show_all IS 'Show All';


--
-- Name: COLUMN base_module_uninstall.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_uninstall.create_date IS 'Created on';


--
-- Name: COLUMN base_module_uninstall.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_uninstall.write_date IS 'Last Updated on';


--
-- Name: base_module_uninstall_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_module_uninstall_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_module_uninstall_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_module_uninstall_id_seq OWNED BY public.base_module_uninstall.id;


--
-- Name: base_module_update; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_module_update (
    id integer NOT NULL,
    updated integer,
    added integer,
    create_uid integer,
    write_uid integer,
    state character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_module_update; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_module_update IS 'Update Module';


--
-- Name: COLUMN base_module_update.updated; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_update.updated IS 'Number of modules updated';


--
-- Name: COLUMN base_module_update.added; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_update.added IS 'Number of modules added';


--
-- Name: COLUMN base_module_update.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_update.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_update.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_update.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_update.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_update.state IS 'Status';


--
-- Name: COLUMN base_module_update.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_update.create_date IS 'Created on';


--
-- Name: COLUMN base_module_update.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_update.write_date IS 'Last Updated on';


--
-- Name: base_module_update_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_module_update_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_module_update_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_module_update_id_seq OWNED BY public.base_module_update.id;


--
-- Name: base_module_upgrade; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_module_upgrade (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    module_info text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_module_upgrade; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_module_upgrade IS 'Upgrade Module';


--
-- Name: COLUMN base_module_upgrade.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_upgrade.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_upgrade.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_upgrade.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_upgrade.module_info; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_upgrade.module_info IS 'Apps to Update';


--
-- Name: COLUMN base_module_upgrade.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_upgrade.create_date IS 'Created on';


--
-- Name: COLUMN base_module_upgrade.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_module_upgrade.write_date IS 'Last Updated on';


--
-- Name: base_module_upgrade_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_module_upgrade_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_module_upgrade_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_module_upgrade_id_seq OWNED BY public.base_module_upgrade.id;


--
-- Name: base_partner_merge_automatic_wizard; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_partner_merge_automatic_wizard (
    id integer NOT NULL,
    number_group integer,
    current_line_id integer,
    dst_partner_id integer,
    maximum_group integer,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    group_by_email boolean,
    group_by_name boolean,
    group_by_is_company boolean,
    group_by_vat boolean,
    group_by_parent_id boolean,
    exclude_contact boolean,
    exclude_journal_item boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_partner_merge_automatic_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_partner_merge_automatic_wizard IS 'Merge Partner Wizard';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.number_group; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.number_group IS 'Group of Contacts';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.current_line_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.current_line_id IS 'Current Line';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.dst_partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.dst_partner_id IS 'Destination Contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.maximum_group; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.maximum_group IS 'Maximum of Group of Contacts';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.state IS 'State';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_email; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_email IS 'Email';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_name IS 'Name';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_is_company; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_is_company IS 'Is Company';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_vat; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_vat IS 'VAT';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_parent_id IS 'Parent Company';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.exclude_contact; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.exclude_contact IS 'A user associated to the contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.exclude_journal_item; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.exclude_journal_item IS 'Journal Items associated to the contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.create_date IS 'Created on';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.write_date IS 'Last Updated on';


--
-- Name: base_partner_merge_automatic_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_partner_merge_automatic_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_partner_merge_automatic_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_partner_merge_automatic_wizard_id_seq OWNED BY public.base_partner_merge_automatic_wizard.id;


--
-- Name: base_partner_merge_automatic_wizard_res_partner_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_partner_merge_automatic_wizard_res_partner_rel (
    base_partner_merge_automatic_wizard_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


--
-- Name: TABLE base_partner_merge_automatic_wizard_res_partner_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_partner_merge_automatic_wizard_res_partner_rel IS 'RELATION BETWEEN base_partner_merge_automatic_wizard AND res_partner';


--
-- Name: base_partner_merge_line; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.base_partner_merge_line (
    id integer NOT NULL,
    wizard_id integer,
    min_id integer,
    create_uid integer,
    write_uid integer,
    aggr_ids character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE base_partner_merge_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.base_partner_merge_line IS 'Merge Partner Line';


--
-- Name: COLUMN base_partner_merge_line.wizard_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_line.wizard_id IS 'Wizard';


--
-- Name: COLUMN base_partner_merge_line.min_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_line.min_id IS 'MinID';


--
-- Name: COLUMN base_partner_merge_line.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_line.create_uid IS 'Created by';


--
-- Name: COLUMN base_partner_merge_line.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_partner_merge_line.aggr_ids; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_line.aggr_ids IS 'Ids';


--
-- Name: COLUMN base_partner_merge_line.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_line.create_date IS 'Created on';


--
-- Name: COLUMN base_partner_merge_line.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.base_partner_merge_line.write_date IS 'Last Updated on';


--
-- Name: base_partner_merge_line_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_partner_merge_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: base_partner_merge_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.base_partner_merge_line_id_seq OWNED BY public.base_partner_merge_line.id;


--
-- Name: base_registry_signaling; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.base_registry_signaling
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: bus_bus; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.bus_bus (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    channel character varying,
    message character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE bus_bus; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.bus_bus IS 'Communication Bus';


--
-- Name: COLUMN bus_bus.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.bus_bus.create_uid IS 'Created by';


--
-- Name: COLUMN bus_bus.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.bus_bus.write_uid IS 'Last Updated by';


--
-- Name: COLUMN bus_bus.channel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.bus_bus.channel IS 'Channel';


--
-- Name: COLUMN bus_bus.message; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.bus_bus.message IS 'Message';


--
-- Name: COLUMN bus_bus.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.bus_bus.create_date IS 'Created on';


--
-- Name: COLUMN bus_bus.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.bus_bus.write_date IS 'Last Updated on';


--
-- Name: bus_bus_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.bus_bus_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: bus_bus_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.bus_bus_id_seq OWNED BY public.bus_bus.id;


--
-- Name: bus_presence; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.bus_presence (
    id integer NOT NULL,
    user_id integer,
    status character varying,
    last_poll timestamp without time zone,
    last_presence timestamp without time zone
);


--
-- Name: TABLE bus_presence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.bus_presence IS 'User Presence';


--
-- Name: COLUMN bus_presence.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.bus_presence.user_id IS 'Users';


--
-- Name: COLUMN bus_presence.status; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.bus_presence.status IS 'IM Status';


--
-- Name: COLUMN bus_presence.last_poll; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.bus_presence.last_poll IS 'Last Poll';


--
-- Name: COLUMN bus_presence.last_presence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.bus_presence.last_presence IS 'Last Presence';


--
-- Name: bus_presence_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.bus_presence_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: bus_presence_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.bus_presence_id_seq OWNED BY public.bus_presence.id;


--
-- Name: change_password_own; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.change_password_own (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    new_password character varying,
    confirm_password character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE change_password_own; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.change_password_own IS 'User, change own password wizard';


--
-- Name: COLUMN change_password_own.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_password_own.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_own.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_password_own.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_own.new_password; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_password_own.new_password IS 'New Password';


--
-- Name: COLUMN change_password_own.confirm_password; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_password_own.confirm_password IS 'New Password (Confirmation)';


--
-- Name: COLUMN change_password_own.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_password_own.create_date IS 'Created on';


--
-- Name: COLUMN change_password_own.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_password_own.write_date IS 'Last Updated on';


--
-- Name: change_password_own_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.change_password_own_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: change_password_own_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.change_password_own_id_seq OWNED BY public.change_password_own.id;


--
-- Name: change_password_user; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.change_password_user (
    id integer NOT NULL,
    wizard_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    user_login character varying,
    new_passwd character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE change_password_user; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.change_password_user IS 'User, Change Password Wizard';


--
-- Name: COLUMN change_password_user.wizard_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_password_user.wizard_id IS 'Wizard';


--
-- Name: COLUMN change_password_user.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_password_user.user_id IS 'User';


--
-- Name: COLUMN change_password_user.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_password_user.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_user.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_password_user.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_user.user_login; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_password_user.user_login IS 'User Login';


--
-- Name: COLUMN change_password_user.new_passwd; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_password_user.new_passwd IS 'New Password';


--
-- Name: COLUMN change_password_user.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_password_user.create_date IS 'Created on';


--
-- Name: COLUMN change_password_user.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_password_user.write_date IS 'Last Updated on';


--
-- Name: change_password_user_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.change_password_user_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: change_password_user_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.change_password_user_id_seq OWNED BY public.change_password_user.id;


--
-- Name: change_password_wizard; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.change_password_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE change_password_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.change_password_wizard IS 'Change Password Wizard';


--
-- Name: COLUMN change_password_wizard.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_password_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_wizard.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_password_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_wizard.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_password_wizard.create_date IS 'Created on';


--
-- Name: COLUMN change_password_wizard.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.change_password_wizard.write_date IS 'Last Updated on';


--
-- Name: change_password_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.change_password_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: change_password_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.change_password_wizard_id_seq OWNED BY public.change_password_wizard.id;


--
-- Name: decimal_precision; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.decimal_precision (
    id integer NOT NULL,
    digits integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE decimal_precision; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.decimal_precision IS 'Decimal Precision';


--
-- Name: COLUMN decimal_precision.digits; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.decimal_precision.digits IS 'Digits';


--
-- Name: COLUMN decimal_precision.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.decimal_precision.create_uid IS 'Created by';


--
-- Name: COLUMN decimal_precision.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.decimal_precision.write_uid IS 'Last Updated by';


--
-- Name: COLUMN decimal_precision.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.decimal_precision.name IS 'Usage';


--
-- Name: COLUMN decimal_precision.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.decimal_precision.create_date IS 'Created on';


--
-- Name: COLUMN decimal_precision.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.decimal_precision.write_date IS 'Last Updated on';


--
-- Name: decimal_precision_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.decimal_precision_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: decimal_precision_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.decimal_precision_id_seq OWNED BY public.decimal_precision.id;


--
-- Name: iap_account; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.iap_account (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    service_name character varying,
    account_token character varying(43),
    show_token boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE iap_account; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.iap_account IS 'IAP Account';


--
-- Name: COLUMN iap_account.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.iap_account.create_uid IS 'Created by';


--
-- Name: COLUMN iap_account.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.iap_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN iap_account.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.iap_account.name IS 'Name';


--
-- Name: COLUMN iap_account.service_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.iap_account.service_name IS 'Service Name';


--
-- Name: COLUMN iap_account.account_token; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.iap_account.account_token IS 'Account Token';


--
-- Name: COLUMN iap_account.show_token; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.iap_account.show_token IS 'Show Token';


--
-- Name: COLUMN iap_account.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.iap_account.create_date IS 'Created on';


--
-- Name: COLUMN iap_account.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.iap_account.write_date IS 'Last Updated on';


--
-- Name: iap_account_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.iap_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: iap_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.iap_account_id_seq OWNED BY public.iap_account.id;


--
-- Name: iap_account_info; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.iap_account_info (
    id integer NOT NULL,
    account_id integer,
    create_uid integer,
    write_uid integer,
    account_token character varying,
    account_uuid_hashed character varying,
    service_name character varying,
    description character varying,
    warning_email character varying,
    unit_name character varying,
    balance numeric,
    warn_me boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    warning_threshold double precision
);


--
-- Name: TABLE iap_account_info; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.iap_account_info IS 'IAP Account Info';


--
-- Name: COLUMN iap_account_info.account_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.iap_account_info.account_id IS 'IAP Account';


--
-- Name: COLUMN iap_account_info.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.iap_account_info.create_uid IS 'Created by';


--
-- Name: COLUMN iap_account_info.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.iap_account_info.write_uid IS 'Last Updated by';


--
-- Name: COLUMN iap_account_info.account_token; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.iap_account_info.account_token IS 'Account Token';


--
-- Name: COLUMN iap_account_info.account_uuid_hashed; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.iap_account_info.account_uuid_hashed IS 'Account UUID';


--
-- Name: COLUMN iap_account_info.service_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.iap_account_info.service_name IS 'Related Service';


--
-- Name: COLUMN iap_account_info.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.iap_account_info.description IS 'Description';


--
-- Name: COLUMN iap_account_info.warning_email; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.iap_account_info.warning_email IS 'Warning Email';


--
-- Name: COLUMN iap_account_info.unit_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.iap_account_info.unit_name IS 'Unit Name';


--
-- Name: COLUMN iap_account_info.balance; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.iap_account_info.balance IS 'Balance';


--
-- Name: COLUMN iap_account_info.warn_me; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.iap_account_info.warn_me IS 'Warn me';


--
-- Name: COLUMN iap_account_info.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.iap_account_info.create_date IS 'Created on';


--
-- Name: COLUMN iap_account_info.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.iap_account_info.write_date IS 'Last Updated on';


--
-- Name: COLUMN iap_account_info.warning_threshold; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.iap_account_info.warning_threshold IS 'Threshold';


--
-- Name: iap_account_info_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.iap_account_info_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: iap_account_info_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.iap_account_info_id_seq OWNED BY public.iap_account_info.id;


--
-- Name: iap_account_res_company_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.iap_account_res_company_rel (
    iap_account_id integer NOT NULL,
    res_company_id integer NOT NULL
);


--
-- Name: TABLE iap_account_res_company_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.iap_account_res_company_rel IS 'RELATION BETWEEN iap_account AND res_company';


--
-- Name: ir_actions; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_actions (
    id integer NOT NULL,
    binding_model_id integer,
    create_uid integer,
    write_uid integer,
    type character varying NOT NULL,
    binding_type character varying NOT NULL,
    binding_view_types character varying,
    name jsonb NOT NULL,
    help jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: COLUMN ir_actions.binding_model_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_actions.binding_model_id IS 'Binding Model';


--
-- Name: COLUMN ir_actions.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_actions.create_uid IS 'Created by';


--
-- Name: COLUMN ir_actions.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_actions.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_actions.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_actions.type IS 'Action Type';


--
-- Name: COLUMN ir_actions.binding_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_actions.binding_type IS 'Binding Type';


--
-- Name: COLUMN ir_actions.binding_view_types; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_actions.binding_view_types IS 'Binding View Types';


--
-- Name: COLUMN ir_actions.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_actions.name IS 'Action Name';


--
-- Name: COLUMN ir_actions.help; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_actions.help IS 'Action Description';


--
-- Name: COLUMN ir_actions.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_actions.create_date IS 'Created on';


--
-- Name: COLUMN ir_actions.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_actions.write_date IS 'Last Updated on';


--
-- Name: ir_act_client; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_act_client (
    tag character varying NOT NULL,
    target character varying,
    res_model character varying,
    context character varying NOT NULL,
    params_store bytea
)
INHERITS (public.ir_actions);


--
-- Name: COLUMN ir_act_client.tag; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_client.tag IS 'Client action tag';


--
-- Name: COLUMN ir_act_client.target; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_client.target IS 'Target Window';


--
-- Name: COLUMN ir_act_client.res_model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_client.res_model IS 'Destination Model';


--
-- Name: COLUMN ir_act_client.context; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_client.context IS 'Context Value';


--
-- Name: COLUMN ir_act_client.params_store; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_client.params_store IS 'Params storage';


--
-- Name: ir_act_report_xml; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_act_report_xml (
    paperformat_id integer,
    model character varying NOT NULL,
    report_type character varying NOT NULL,
    report_name character varying NOT NULL,
    report_file character varying,
    attachment character varying,
    print_report_name jsonb,
    multi boolean,
    attachment_use boolean
)
INHERITS (public.ir_actions);


--
-- Name: COLUMN ir_act_report_xml.paperformat_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_report_xml.paperformat_id IS 'Paper Format';


--
-- Name: COLUMN ir_act_report_xml.model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_report_xml.model IS 'Model Name';


--
-- Name: COLUMN ir_act_report_xml.report_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_report_xml.report_type IS 'Report Type';


--
-- Name: COLUMN ir_act_report_xml.report_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_report_xml.report_name IS 'Template Name';


--
-- Name: COLUMN ir_act_report_xml.report_file; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_report_xml.report_file IS 'Report File';


--
-- Name: COLUMN ir_act_report_xml.attachment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_report_xml.attachment IS 'Save as Attachment Prefix';


--
-- Name: COLUMN ir_act_report_xml.print_report_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_report_xml.print_report_name IS 'Printed Report Name';


--
-- Name: COLUMN ir_act_report_xml.multi; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_report_xml.multi IS 'On Multiple Doc.';


--
-- Name: COLUMN ir_act_report_xml.attachment_use; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_report_xml.attachment_use IS 'Reload from Attachment';


--
-- Name: ir_act_server; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_act_server (
    sequence integer,
    model_id integer NOT NULL,
    crud_model_id integer,
    link_field_id integer,
    update_field_id integer,
    update_related_model_id integer,
    selection_value integer,
    usage character varying NOT NULL,
    state character varying NOT NULL,
    model_name character varying,
    update_path character varying,
    update_m2m_operation character varying,
    update_boolean_value character varying,
    evaluation_type character varying,
    resource_ref character varying,
    webhook_url character varying,
    code text,
    value text
)
INHERITS (public.ir_actions);


--
-- Name: COLUMN ir_act_server.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_server.sequence IS 'Sequence';


--
-- Name: COLUMN ir_act_server.model_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_server.model_id IS 'Model';


--
-- Name: COLUMN ir_act_server.crud_model_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_server.crud_model_id IS 'Record to Create';


--
-- Name: COLUMN ir_act_server.link_field_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_server.link_field_id IS 'Link Field';


--
-- Name: COLUMN ir_act_server.update_field_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_server.update_field_id IS 'Field to Update';


--
-- Name: COLUMN ir_act_server.update_related_model_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_server.update_related_model_id IS 'Update Related Model';


--
-- Name: COLUMN ir_act_server.selection_value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_server.selection_value IS 'Custom Value';


--
-- Name: COLUMN ir_act_server.usage; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_server.usage IS 'Usage';


--
-- Name: COLUMN ir_act_server.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_server.state IS 'Type';


--
-- Name: COLUMN ir_act_server.model_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_server.model_name IS 'Model Name';


--
-- Name: COLUMN ir_act_server.update_path; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_server.update_path IS 'Field to Update Path';


--
-- Name: COLUMN ir_act_server.update_m2m_operation; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_server.update_m2m_operation IS 'Many2many Operations';


--
-- Name: COLUMN ir_act_server.update_boolean_value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_server.update_boolean_value IS 'Boolean Value';


--
-- Name: COLUMN ir_act_server.evaluation_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_server.evaluation_type IS 'Value Type';


--
-- Name: COLUMN ir_act_server.resource_ref; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_server.resource_ref IS 'Record';


--
-- Name: COLUMN ir_act_server.webhook_url; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_server.webhook_url IS 'Webhook URL';


--
-- Name: COLUMN ir_act_server.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_server.code IS 'Python Code';


--
-- Name: COLUMN ir_act_server.value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_server.value IS 'Value';


--
-- Name: ir_act_server_group_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_act_server_group_rel (
    act_id integer NOT NULL,
    gid integer NOT NULL
);


--
-- Name: TABLE ir_act_server_group_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_act_server_group_rel IS 'RELATION BETWEEN ir_act_server AND res_groups';


--
-- Name: ir_act_server_webhook_field_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_act_server_webhook_field_rel (
    server_id integer NOT NULL,
    field_id integer NOT NULL
);


--
-- Name: TABLE ir_act_server_webhook_field_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_act_server_webhook_field_rel IS 'RELATION BETWEEN ir_act_server AND ir_model_fields';


--
-- Name: ir_act_url; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_act_url (
    target character varying NOT NULL,
    url text NOT NULL
)
INHERITS (public.ir_actions);


--
-- Name: COLUMN ir_act_url.target; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_url.target IS 'Action Target';


--
-- Name: COLUMN ir_act_url.url; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_url.url IS 'Action URL';


--
-- Name: ir_act_window; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_act_window (
    view_id integer,
    res_id integer,
    "limit" integer,
    search_view_id integer,
    domain character varying,
    context character varying NOT NULL,
    res_model character varying NOT NULL,
    target character varying,
    view_mode character varying NOT NULL,
    mobile_view_mode character varying,
    usage character varying,
    filter boolean
)
INHERITS (public.ir_actions);


--
-- Name: COLUMN ir_act_window.view_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_window.view_id IS 'View Ref.';


--
-- Name: COLUMN ir_act_window.res_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_window.res_id IS 'Record ID';


--
-- Name: COLUMN ir_act_window."limit"; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_window."limit" IS 'Limit';


--
-- Name: COLUMN ir_act_window.search_view_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_window.search_view_id IS 'Search View Ref.';


--
-- Name: COLUMN ir_act_window.domain; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_window.domain IS 'Domain Value';


--
-- Name: COLUMN ir_act_window.context; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_window.context IS 'Context Value';


--
-- Name: COLUMN ir_act_window.res_model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_window.res_model IS 'Destination Model';


--
-- Name: COLUMN ir_act_window.target; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_window.target IS 'Target Window';


--
-- Name: COLUMN ir_act_window.view_mode; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_window.view_mode IS 'View Mode';


--
-- Name: COLUMN ir_act_window.mobile_view_mode; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_window.mobile_view_mode IS 'Mobile View Mode';


--
-- Name: COLUMN ir_act_window.usage; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_window.usage IS 'Action Usage';


--
-- Name: COLUMN ir_act_window.filter; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_window.filter IS 'Filter';


--
-- Name: ir_act_window_group_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_act_window_group_rel (
    act_id integer NOT NULL,
    gid integer NOT NULL
);


--
-- Name: TABLE ir_act_window_group_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_act_window_group_rel IS 'RELATION BETWEEN ir_act_window AND res_groups';


--
-- Name: ir_act_window_view; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_act_window_view (
    id integer NOT NULL,
    sequence integer,
    view_id integer,
    act_window_id integer,
    create_uid integer,
    write_uid integer,
    view_mode character varying NOT NULL,
    multi boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE ir_act_window_view; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_act_window_view IS 'Action Window View';


--
-- Name: COLUMN ir_act_window_view.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_window_view.sequence IS 'Sequence';


--
-- Name: COLUMN ir_act_window_view.view_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_window_view.view_id IS 'View';


--
-- Name: COLUMN ir_act_window_view.act_window_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_window_view.act_window_id IS 'Action';


--
-- Name: COLUMN ir_act_window_view.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_window_view.create_uid IS 'Created by';


--
-- Name: COLUMN ir_act_window_view.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_window_view.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_act_window_view.view_mode; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_window_view.view_mode IS 'View Type';


--
-- Name: COLUMN ir_act_window_view.multi; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_window_view.multi IS 'On Multiple Doc.';


--
-- Name: COLUMN ir_act_window_view.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_window_view.create_date IS 'Created on';


--
-- Name: COLUMN ir_act_window_view.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_act_window_view.write_date IS 'Last Updated on';


--
-- Name: ir_act_window_view_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_act_window_view_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_act_window_view_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_act_window_view_id_seq OWNED BY public.ir_act_window_view.id;


--
-- Name: ir_actions_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_actions_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_actions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_actions_id_seq OWNED BY public.ir_actions.id;


--
-- Name: ir_actions_todo; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_actions_todo (
    id integer NOT NULL,
    action_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE ir_actions_todo; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_actions_todo IS 'Configuration Wizards';


--
-- Name: COLUMN ir_actions_todo.action_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_actions_todo.action_id IS 'Action';


--
-- Name: COLUMN ir_actions_todo.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_actions_todo.sequence IS 'Sequence';


--
-- Name: COLUMN ir_actions_todo.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_actions_todo.create_uid IS 'Created by';


--
-- Name: COLUMN ir_actions_todo.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_actions_todo.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_actions_todo.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_actions_todo.state IS 'Status';


--
-- Name: COLUMN ir_actions_todo.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_actions_todo.name IS 'Name';


--
-- Name: COLUMN ir_actions_todo.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_actions_todo.create_date IS 'Created on';


--
-- Name: COLUMN ir_actions_todo.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_actions_todo.write_date IS 'Last Updated on';


--
-- Name: ir_actions_todo_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_actions_todo_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_actions_todo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_actions_todo_id_seq OWNED BY public.ir_actions_todo.id;


--
-- Name: ir_asset; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_asset (
    id integer NOT NULL,
    sequence integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    bundle character varying NOT NULL,
    directive character varying,
    path character varying NOT NULL,
    target character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE ir_asset; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_asset IS 'Asset';


--
-- Name: COLUMN ir_asset.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_asset.sequence IS 'Sequence';


--
-- Name: COLUMN ir_asset.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_asset.create_uid IS 'Created by';


--
-- Name: COLUMN ir_asset.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_asset.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_asset.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_asset.name IS 'Name';


--
-- Name: COLUMN ir_asset.bundle; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_asset.bundle IS 'Bundle name';


--
-- Name: COLUMN ir_asset.directive; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_asset.directive IS 'Directive';


--
-- Name: COLUMN ir_asset.path; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_asset.path IS 'Path (or glob pattern)';


--
-- Name: COLUMN ir_asset.target; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_asset.target IS 'Target';


--
-- Name: COLUMN ir_asset.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_asset.active IS 'active';


--
-- Name: COLUMN ir_asset.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_asset.create_date IS 'Created on';


--
-- Name: COLUMN ir_asset.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_asset.write_date IS 'Last Updated on';


--
-- Name: ir_asset_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_asset_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_asset_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_asset_id_seq OWNED BY public.ir_asset.id;


--
-- Name: ir_attachment; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_attachment (
    id integer NOT NULL,
    res_id integer,
    company_id integer,
    file_size integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    res_model character varying,
    res_field character varying,
    type character varying NOT NULL,
    url character varying(1024),
    access_token character varying,
    store_fname character varying,
    checksum character varying(40),
    mimetype character varying,
    description text,
    index_content text,
    public boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    db_datas bytea,
    original_id integer
);


--
-- Name: TABLE ir_attachment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_attachment IS 'Attachment';


--
-- Name: COLUMN ir_attachment.res_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_attachment.res_id IS 'Resource ID';


--
-- Name: COLUMN ir_attachment.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_attachment.company_id IS 'Company';


--
-- Name: COLUMN ir_attachment.file_size; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_attachment.file_size IS 'File Size';


--
-- Name: COLUMN ir_attachment.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_attachment.create_uid IS 'Created by';


--
-- Name: COLUMN ir_attachment.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_attachment.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_attachment.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_attachment.name IS 'Name';


--
-- Name: COLUMN ir_attachment.res_model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_attachment.res_model IS 'Resource Model';


--
-- Name: COLUMN ir_attachment.res_field; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_attachment.res_field IS 'Resource Field';


--
-- Name: COLUMN ir_attachment.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_attachment.type IS 'Type';


--
-- Name: COLUMN ir_attachment.url; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_attachment.url IS 'Url';


--
-- Name: COLUMN ir_attachment.access_token; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_attachment.access_token IS 'Access Token';


--
-- Name: COLUMN ir_attachment.store_fname; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_attachment.store_fname IS 'Stored Filename';


--
-- Name: COLUMN ir_attachment.checksum; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_attachment.checksum IS 'Checksum/SHA1';


--
-- Name: COLUMN ir_attachment.mimetype; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_attachment.mimetype IS 'Mime Type';


--
-- Name: COLUMN ir_attachment.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_attachment.description IS 'Description';


--
-- Name: COLUMN ir_attachment.index_content; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_attachment.index_content IS 'Indexed Content';


--
-- Name: COLUMN ir_attachment.public; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_attachment.public IS 'Is public document';


--
-- Name: COLUMN ir_attachment.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_attachment.create_date IS 'Created on';


--
-- Name: COLUMN ir_attachment.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_attachment.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_attachment.db_datas; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_attachment.db_datas IS 'Database Data';


--
-- Name: COLUMN ir_attachment.original_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_attachment.original_id IS 'Original (unoptimized, unresized) attachment';


--
-- Name: ir_attachment_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_attachment_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_attachment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_attachment_id_seq OWNED BY public.ir_attachment.id;


--
-- Name: ir_config_parameter; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_config_parameter (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    key character varying NOT NULL,
    value text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE ir_config_parameter; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_config_parameter IS 'System Parameter';


--
-- Name: COLUMN ir_config_parameter.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_config_parameter.create_uid IS 'Created by';


--
-- Name: COLUMN ir_config_parameter.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_config_parameter.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_config_parameter.key; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_config_parameter.key IS 'Key';


--
-- Name: COLUMN ir_config_parameter.value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_config_parameter.value IS 'Value';


--
-- Name: COLUMN ir_config_parameter.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_config_parameter.create_date IS 'Created on';


--
-- Name: COLUMN ir_config_parameter.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_config_parameter.write_date IS 'Last Updated on';


--
-- Name: ir_config_parameter_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_config_parameter_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_config_parameter_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_config_parameter_id_seq OWNED BY public.ir_config_parameter.id;


--
-- Name: ir_cron; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_cron (
    id integer NOT NULL,
    ir_actions_server_id integer NOT NULL,
    user_id integer NOT NULL,
    interval_number integer,
    numbercall integer,
    priority integer,
    create_uid integer,
    write_uid integer,
    cron_name character varying,
    interval_type character varying,
    active boolean,
    doall boolean,
    nextcall timestamp without time zone NOT NULL,
    lastcall timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE ir_cron; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_cron IS 'Scheduled Actions';


--
-- Name: COLUMN ir_cron.ir_actions_server_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_cron.ir_actions_server_id IS 'Server action';


--
-- Name: COLUMN ir_cron.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_cron.user_id IS 'Scheduler User';


--
-- Name: COLUMN ir_cron.interval_number; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_cron.interval_number IS 'Interval Number';


--
-- Name: COLUMN ir_cron.numbercall; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_cron.numbercall IS 'Number of Calls';


--
-- Name: COLUMN ir_cron.priority; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_cron.priority IS 'Priority';


--
-- Name: COLUMN ir_cron.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_cron.create_uid IS 'Created by';


--
-- Name: COLUMN ir_cron.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_cron.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_cron.cron_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_cron.cron_name IS 'Name';


--
-- Name: COLUMN ir_cron.interval_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_cron.interval_type IS 'Interval Unit';


--
-- Name: COLUMN ir_cron.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_cron.active IS 'Active';


--
-- Name: COLUMN ir_cron.doall; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_cron.doall IS 'Repeat Missed';


--
-- Name: COLUMN ir_cron.nextcall; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_cron.nextcall IS 'Next Execution Date';


--
-- Name: COLUMN ir_cron.lastcall; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_cron.lastcall IS 'Last Execution Date';


--
-- Name: COLUMN ir_cron.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_cron.create_date IS 'Created on';


--
-- Name: COLUMN ir_cron.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_cron.write_date IS 'Last Updated on';


--
-- Name: ir_cron_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_cron_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_cron_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_cron_id_seq OWNED BY public.ir_cron.id;


--
-- Name: ir_cron_trigger; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_cron_trigger (
    id integer NOT NULL,
    cron_id integer,
    create_uid integer,
    write_uid integer,
    call_at timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE ir_cron_trigger; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_cron_trigger IS 'Triggered actions';


--
-- Name: COLUMN ir_cron_trigger.cron_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_cron_trigger.cron_id IS 'Cron';


--
-- Name: COLUMN ir_cron_trigger.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_cron_trigger.create_uid IS 'Created by';


--
-- Name: COLUMN ir_cron_trigger.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_cron_trigger.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_cron_trigger.call_at; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_cron_trigger.call_at IS 'Call At';


--
-- Name: COLUMN ir_cron_trigger.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_cron_trigger.create_date IS 'Created on';


--
-- Name: COLUMN ir_cron_trigger.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_cron_trigger.write_date IS 'Last Updated on';


--
-- Name: ir_cron_trigger_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_cron_trigger_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_cron_trigger_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_cron_trigger_id_seq OWNED BY public.ir_cron_trigger.id;


--
-- Name: ir_default; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_default (
    id integer NOT NULL,
    field_id integer NOT NULL,
    user_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    condition character varying,
    json_value character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE ir_default; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_default IS 'Default Values';


--
-- Name: COLUMN ir_default.field_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_default.field_id IS 'Field';


--
-- Name: COLUMN ir_default.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_default.user_id IS 'User';


--
-- Name: COLUMN ir_default.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_default.company_id IS 'Company';


--
-- Name: COLUMN ir_default.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_default.create_uid IS 'Created by';


--
-- Name: COLUMN ir_default.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_default.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_default.condition; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_default.condition IS 'Condition';


--
-- Name: COLUMN ir_default.json_value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_default.json_value IS 'Default Value (JSON format)';


--
-- Name: COLUMN ir_default.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_default.create_date IS 'Created on';


--
-- Name: COLUMN ir_default.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_default.write_date IS 'Last Updated on';


--
-- Name: ir_default_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_default_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_default_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_default_id_seq OWNED BY public.ir_default.id;


--
-- Name: ir_demo; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_demo (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE ir_demo; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_demo IS 'Demo';


--
-- Name: COLUMN ir_demo.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_demo.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_demo.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_demo.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_demo.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_demo_failure (
    id integer NOT NULL,
    module_id integer NOT NULL,
    wizard_id integer,
    create_uid integer,
    write_uid integer,
    error character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE ir_demo_failure; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_demo_failure IS 'Demo failure';


--
-- Name: COLUMN ir_demo_failure.module_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_demo_failure.module_id IS 'Module';


--
-- Name: COLUMN ir_demo_failure.wizard_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_demo_failure.wizard_id IS 'Wizard';


--
-- Name: COLUMN ir_demo_failure.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_demo_failure.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo_failure.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_demo_failure.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo_failure.error; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_demo_failure.error IS 'Error';


--
-- Name: COLUMN ir_demo_failure.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_demo_failure.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo_failure.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_demo_failure.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_demo_failure_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_demo_failure_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_demo_failure_id_seq OWNED BY public.ir_demo_failure.id;


--
-- Name: ir_demo_failure_wizard; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_demo_failure_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE ir_demo_failure_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_demo_failure_wizard IS 'Demo Failure wizard';


--
-- Name: COLUMN ir_demo_failure_wizard.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo_failure_wizard.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo_failure_wizard.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo_failure_wizard.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_demo_failure_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_demo_failure_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_demo_failure_wizard_id_seq OWNED BY public.ir_demo_failure_wizard.id;


--
-- Name: ir_demo_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_demo_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_demo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_demo_id_seq OWNED BY public.ir_demo.id;


--
-- Name: ir_exports; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_exports (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    resource character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE ir_exports; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_exports IS 'Exports';


--
-- Name: COLUMN ir_exports.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_exports.create_uid IS 'Created by';


--
-- Name: COLUMN ir_exports.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_exports.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_exports.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_exports.name IS 'Export Name';


--
-- Name: COLUMN ir_exports.resource; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_exports.resource IS 'Resource';


--
-- Name: COLUMN ir_exports.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_exports.create_date IS 'Created on';


--
-- Name: COLUMN ir_exports.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_exports.write_date IS 'Last Updated on';


--
-- Name: ir_exports_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_exports_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_exports_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_exports_id_seq OWNED BY public.ir_exports.id;


--
-- Name: ir_exports_line; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_exports_line (
    id integer NOT NULL,
    export_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE ir_exports_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_exports_line IS 'Exports Line';


--
-- Name: COLUMN ir_exports_line.export_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_exports_line.export_id IS 'Export';


--
-- Name: COLUMN ir_exports_line.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_exports_line.create_uid IS 'Created by';


--
-- Name: COLUMN ir_exports_line.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_exports_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_exports_line.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_exports_line.name IS 'Field Name';


--
-- Name: COLUMN ir_exports_line.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_exports_line.create_date IS 'Created on';


--
-- Name: COLUMN ir_exports_line.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_exports_line.write_date IS 'Last Updated on';


--
-- Name: ir_exports_line_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_exports_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_exports_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_exports_line_id_seq OWNED BY public.ir_exports_line.id;


--
-- Name: ir_filters; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_filters (
    id integer NOT NULL,
    user_id integer,
    action_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    model_id character varying NOT NULL,
    domain text NOT NULL,
    context text NOT NULL,
    sort text NOT NULL,
    is_default boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE ir_filters; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_filters IS 'Filters';


--
-- Name: COLUMN ir_filters.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_filters.user_id IS 'User';


--
-- Name: COLUMN ir_filters.action_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_filters.action_id IS 'Action';


--
-- Name: COLUMN ir_filters.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_filters.create_uid IS 'Created by';


--
-- Name: COLUMN ir_filters.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_filters.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_filters.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_filters.name IS 'Filter Name';


--
-- Name: COLUMN ir_filters.model_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_filters.model_id IS 'Model';


--
-- Name: COLUMN ir_filters.domain; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_filters.domain IS 'Domain';


--
-- Name: COLUMN ir_filters.context; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_filters.context IS 'Context';


--
-- Name: COLUMN ir_filters.sort; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_filters.sort IS 'Sort';


--
-- Name: COLUMN ir_filters.is_default; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_filters.is_default IS 'Default Filter';


--
-- Name: COLUMN ir_filters.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_filters.active IS 'Active';


--
-- Name: COLUMN ir_filters.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_filters.create_date IS 'Created on';


--
-- Name: COLUMN ir_filters.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_filters.write_date IS 'Last Updated on';


--
-- Name: ir_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_filters_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_filters_id_seq OWNED BY public.ir_filters.id;


--
-- Name: ir_logging; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_logging (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    type character varying NOT NULL,
    dbname character varying,
    level character varying,
    path character varying NOT NULL,
    func character varying NOT NULL,
    line character varying NOT NULL,
    message text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE ir_logging; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_logging IS 'Logging';


--
-- Name: COLUMN ir_logging.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_logging.create_uid IS 'Created by';


--
-- Name: COLUMN ir_logging.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_logging.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_logging.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_logging.name IS 'Name';


--
-- Name: COLUMN ir_logging.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_logging.type IS 'Type';


--
-- Name: COLUMN ir_logging.dbname; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_logging.dbname IS 'Database Name';


--
-- Name: COLUMN ir_logging.level; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_logging.level IS 'Level';


--
-- Name: COLUMN ir_logging.path; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_logging.path IS 'Path';


--
-- Name: COLUMN ir_logging.func; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_logging.func IS 'Function';


--
-- Name: COLUMN ir_logging.line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_logging.line IS 'Line';


--
-- Name: COLUMN ir_logging.message; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_logging.message IS 'Message';


--
-- Name: COLUMN ir_logging.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_logging.create_date IS 'Created on';


--
-- Name: COLUMN ir_logging.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_logging.write_date IS 'Last Updated on';


--
-- Name: ir_logging_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_logging_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_logging_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_logging_id_seq OWNED BY public.ir_logging.id;


--
-- Name: ir_mail_server; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_mail_server (
    id integer NOT NULL,
    smtp_port integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    from_filter character varying,
    smtp_host character varying,
    smtp_authentication character varying NOT NULL,
    smtp_user character varying,
    smtp_pass character varying,
    smtp_encryption character varying NOT NULL,
    smtp_debug boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    smtp_ssl_certificate bytea,
    smtp_ssl_private_key bytea
);


--
-- Name: TABLE ir_mail_server; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_mail_server IS 'Mail Server';


--
-- Name: COLUMN ir_mail_server.smtp_port; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_mail_server.smtp_port IS 'SMTP Port';


--
-- Name: COLUMN ir_mail_server.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_mail_server.sequence IS 'Priority';


--
-- Name: COLUMN ir_mail_server.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_mail_server.create_uid IS 'Created by';


--
-- Name: COLUMN ir_mail_server.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_mail_server.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_mail_server.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_mail_server.name IS 'Name';


--
-- Name: COLUMN ir_mail_server.from_filter; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_mail_server.from_filter IS 'FROM Filtering';


--
-- Name: COLUMN ir_mail_server.smtp_host; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_mail_server.smtp_host IS 'SMTP Server';


--
-- Name: COLUMN ir_mail_server.smtp_authentication; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_mail_server.smtp_authentication IS 'Authenticate with';


--
-- Name: COLUMN ir_mail_server.smtp_user; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_mail_server.smtp_user IS 'Username';


--
-- Name: COLUMN ir_mail_server.smtp_pass; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_mail_server.smtp_pass IS 'Password';


--
-- Name: COLUMN ir_mail_server.smtp_encryption; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_mail_server.smtp_encryption IS 'Connection Encryption';


--
-- Name: COLUMN ir_mail_server.smtp_debug; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_mail_server.smtp_debug IS 'Debugging';


--
-- Name: COLUMN ir_mail_server.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_mail_server.active IS 'Active';


--
-- Name: COLUMN ir_mail_server.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_mail_server.create_date IS 'Created on';


--
-- Name: COLUMN ir_mail_server.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_mail_server.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_mail_server.smtp_ssl_certificate; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_mail_server.smtp_ssl_certificate IS 'SSL Certificate';


--
-- Name: COLUMN ir_mail_server.smtp_ssl_private_key; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_mail_server.smtp_ssl_private_key IS 'SSL Private Key';


--
-- Name: ir_mail_server_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_mail_server_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_mail_server_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_mail_server_id_seq OWNED BY public.ir_mail_server.id;


--
-- Name: ir_model; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_model (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    model character varying NOT NULL,
    "order" character varying NOT NULL,
    state character varying,
    name jsonb NOT NULL,
    info text,
    transient boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE ir_model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_model IS 'Models';


--
-- Name: COLUMN ir_model.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model.model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model.model IS 'Model';


--
-- Name: COLUMN ir_model."order"; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model."order" IS 'Order';


--
-- Name: COLUMN ir_model.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model.state IS 'Type';


--
-- Name: COLUMN ir_model.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model.name IS 'Model Description';


--
-- Name: COLUMN ir_model.info; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model.info IS 'Information';


--
-- Name: COLUMN ir_model.transient; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model.transient IS 'Transient Model';


--
-- Name: COLUMN ir_model.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model.create_date IS 'Created on';


--
-- Name: COLUMN ir_model.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model.write_date IS 'Last Updated on';


--
-- Name: ir_model_access; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_model_access (
    id integer NOT NULL,
    model_id integer NOT NULL,
    group_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    active boolean,
    perm_read boolean,
    perm_write boolean,
    perm_create boolean,
    perm_unlink boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE ir_model_access; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_model_access IS 'Model Access';


--
-- Name: COLUMN ir_model_access.model_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_access.model_id IS 'Model';


--
-- Name: COLUMN ir_model_access.group_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_access.group_id IS 'Group';


--
-- Name: COLUMN ir_model_access.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_access.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_access.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_access.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_access.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_access.name IS 'Name';


--
-- Name: COLUMN ir_model_access.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_access.active IS 'Active';


--
-- Name: COLUMN ir_model_access.perm_read; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_access.perm_read IS 'Read Access';


--
-- Name: COLUMN ir_model_access.perm_write; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_access.perm_write IS 'Write Access';


--
-- Name: COLUMN ir_model_access.perm_create; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_access.perm_create IS 'Create Access';


--
-- Name: COLUMN ir_model_access.perm_unlink; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_access.perm_unlink IS 'Delete Access';


--
-- Name: COLUMN ir_model_access.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_access.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_access.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_access.write_date IS 'Last Updated on';


--
-- Name: ir_model_access_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_model_access_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_model_access_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_model_access_id_seq OWNED BY public.ir_model_access.id;


--
-- Name: ir_model_constraint; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_model_constraint (
    id integer NOT NULL,
    model integer NOT NULL,
    module integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    definition character varying,
    type character varying(1) NOT NULL,
    message jsonb,
    write_date timestamp without time zone,
    create_date timestamp without time zone
);


--
-- Name: TABLE ir_model_constraint; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_model_constraint IS 'Model Constraint';


--
-- Name: COLUMN ir_model_constraint.model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_constraint.model IS 'Model';


--
-- Name: COLUMN ir_model_constraint.module; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_constraint.module IS 'Module';


--
-- Name: COLUMN ir_model_constraint.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_constraint.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_constraint.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_constraint.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_constraint.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_constraint.name IS 'Constraint';


--
-- Name: COLUMN ir_model_constraint.definition; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_constraint.definition IS 'Definition';


--
-- Name: COLUMN ir_model_constraint.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_constraint.type IS 'Constraint Type';


--
-- Name: COLUMN ir_model_constraint.message; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_constraint.message IS 'Message';


--
-- Name: COLUMN ir_model_constraint.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_constraint.write_date IS 'Write Date';


--
-- Name: COLUMN ir_model_constraint.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_constraint.create_date IS 'Create Date';


--
-- Name: ir_model_constraint_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_model_constraint_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_model_constraint_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_model_constraint_id_seq OWNED BY public.ir_model_constraint.id;


--
-- Name: ir_model_data; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_model_data (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'UTC'::text),
    write_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'UTC'::text),
    write_uid integer,
    res_id integer,
    noupdate boolean DEFAULT false,
    name character varying NOT NULL,
    module character varying NOT NULL,
    model character varying NOT NULL,
    CONSTRAINT ir_model_data_name_nospaces CHECK (((name)::text !~~ '%% %%'::text))
);


--
-- Name: CONSTRAINT ir_model_data_name_nospaces ON ir_model_data; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT ir_model_data_name_nospaces ON public.ir_model_data IS 'CHECK(name NOT LIKE ''%% %%'')';


--
-- Name: ir_model_data_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_model_data_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_model_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_model_data_id_seq OWNED BY public.ir_model_data.id;


--
-- Name: ir_model_fields; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_model_fields (
    id integer NOT NULL,
    relation_field_id integer,
    model_id integer NOT NULL,
    related_field_id integer,
    size integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    complete_name character varying,
    model character varying NOT NULL,
    relation character varying,
    relation_field character varying,
    ttype character varying NOT NULL,
    related character varying,
    state character varying NOT NULL,
    on_delete character varying,
    domain character varying,
    relation_table character varying,
    column1 character varying,
    column2 character varying,
    depends character varying,
    currency_field character varying,
    field_description jsonb NOT NULL,
    help jsonb,
    compute text,
    copied boolean,
    required boolean,
    readonly boolean,
    index boolean,
    translate boolean,
    group_expand boolean,
    selectable boolean,
    store boolean,
    sanitize boolean,
    sanitize_overridable boolean,
    sanitize_tags boolean,
    sanitize_attributes boolean,
    sanitize_style boolean,
    sanitize_form boolean,
    strip_style boolean,
    strip_classes boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_model_fields_name_manual_field CHECK ((((state)::text <> 'manual'::text) OR ((name)::text ~~ 'x\_%%'::text))),
    CONSTRAINT ir_model_fields_size_gt_zero CHECK ((size >= 0))
);


--
-- Name: TABLE ir_model_fields; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_model_fields IS 'Fields';


--
-- Name: COLUMN ir_model_fields.relation_field_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.relation_field_id IS 'Relation field';


--
-- Name: COLUMN ir_model_fields.model_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.model_id IS 'Model';


--
-- Name: COLUMN ir_model_fields.related_field_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.related_field_id IS 'Related field';


--
-- Name: COLUMN ir_model_fields.size; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.size IS 'Size';


--
-- Name: COLUMN ir_model_fields.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_fields.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_fields.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.name IS 'Field Name';


--
-- Name: COLUMN ir_model_fields.complete_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.complete_name IS 'Complete Name';


--
-- Name: COLUMN ir_model_fields.model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.model IS 'Model Name';


--
-- Name: COLUMN ir_model_fields.relation; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.relation IS 'Related Model';


--
-- Name: COLUMN ir_model_fields.relation_field; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.relation_field IS 'Relation Field';


--
-- Name: COLUMN ir_model_fields.ttype; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.ttype IS 'Field Type';


--
-- Name: COLUMN ir_model_fields.related; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.related IS 'Related Field';


--
-- Name: COLUMN ir_model_fields.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.state IS 'Type';


--
-- Name: COLUMN ir_model_fields.on_delete; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.on_delete IS 'On Delete';


--
-- Name: COLUMN ir_model_fields.domain; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.domain IS 'Domain';


--
-- Name: COLUMN ir_model_fields.relation_table; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.relation_table IS 'Relation Table';


--
-- Name: COLUMN ir_model_fields.column1; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.column1 IS 'Column 1';


--
-- Name: COLUMN ir_model_fields.column2; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.column2 IS 'Column 2';


--
-- Name: COLUMN ir_model_fields.depends; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.depends IS 'Dependencies';


--
-- Name: COLUMN ir_model_fields.currency_field; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.currency_field IS 'Currency field';


--
-- Name: COLUMN ir_model_fields.field_description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.field_description IS 'Field Label';


--
-- Name: COLUMN ir_model_fields.help; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.help IS 'Field Help';


--
-- Name: COLUMN ir_model_fields.compute; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.compute IS 'Compute';


--
-- Name: COLUMN ir_model_fields.copied; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.copied IS 'Copied';


--
-- Name: COLUMN ir_model_fields.required; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.required IS 'Required';


--
-- Name: COLUMN ir_model_fields.readonly; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.readonly IS 'Readonly';


--
-- Name: COLUMN ir_model_fields.index; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.index IS 'Indexed';


--
-- Name: COLUMN ir_model_fields.translate; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.translate IS 'Translatable';


--
-- Name: COLUMN ir_model_fields.group_expand; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.group_expand IS 'Expand Groups';


--
-- Name: COLUMN ir_model_fields.selectable; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.selectable IS 'Selectable';


--
-- Name: COLUMN ir_model_fields.store; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.store IS 'Stored';


--
-- Name: COLUMN ir_model_fields.sanitize; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.sanitize IS 'Sanitize HTML';


--
-- Name: COLUMN ir_model_fields.sanitize_overridable; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_overridable IS 'Sanitize HTML overridable';


--
-- Name: COLUMN ir_model_fields.sanitize_tags; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_tags IS 'Sanitize HTML Tags';


--
-- Name: COLUMN ir_model_fields.sanitize_attributes; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_attributes IS 'Sanitize HTML Attributes';


--
-- Name: COLUMN ir_model_fields.sanitize_style; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_style IS 'Sanitize HTML Style';


--
-- Name: COLUMN ir_model_fields.sanitize_form; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_form IS 'Sanitize HTML Form';


--
-- Name: COLUMN ir_model_fields.strip_style; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.strip_style IS 'Strip Style Attribute';


--
-- Name: COLUMN ir_model_fields.strip_classes; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.strip_classes IS 'Strip Class Attribute';


--
-- Name: COLUMN ir_model_fields.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_fields.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_model_fields_name_manual_field ON ir_model_fields; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT ir_model_fields_name_manual_field ON public.ir_model_fields IS 'CHECK (state != ''manual'' OR name LIKE ''x\_%%'')';


--
-- Name: CONSTRAINT ir_model_fields_size_gt_zero ON ir_model_fields; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT ir_model_fields_size_gt_zero ON public.ir_model_fields IS 'CHECK (size>=0)';


--
-- Name: ir_model_fields_group_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_model_fields_group_rel (
    field_id integer NOT NULL,
    group_id integer NOT NULL
);


--
-- Name: TABLE ir_model_fields_group_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_model_fields_group_rel IS 'RELATION BETWEEN ir_model_fields AND res_groups';


--
-- Name: ir_model_fields_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_model_fields_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_model_fields_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_model_fields_id_seq OWNED BY public.ir_model_fields.id;


--
-- Name: ir_model_fields_selection; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_model_fields_selection (
    id integer NOT NULL,
    field_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    value character varying NOT NULL,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE ir_model_fields_selection; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_model_fields_selection IS 'Fields Selection';


--
-- Name: COLUMN ir_model_fields_selection.field_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields_selection.field_id IS 'Field';


--
-- Name: COLUMN ir_model_fields_selection.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields_selection.sequence IS 'Sequence';


--
-- Name: COLUMN ir_model_fields_selection.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields_selection.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_fields_selection.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields_selection.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_fields_selection.value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields_selection.value IS 'Value';


--
-- Name: COLUMN ir_model_fields_selection.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields_selection.name IS 'Name';


--
-- Name: COLUMN ir_model_fields_selection.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields_selection.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_fields_selection.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_fields_selection.write_date IS 'Last Updated on';


--
-- Name: ir_model_fields_selection_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_model_fields_selection_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_model_fields_selection_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_model_fields_selection_id_seq OWNED BY public.ir_model_fields_selection.id;


--
-- Name: ir_model_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_model_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_model_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_model_id_seq OWNED BY public.ir_model.id;


--
-- Name: ir_model_inherit; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_model_inherit (
    id integer NOT NULL,
    model_id integer NOT NULL,
    parent_id integer NOT NULL,
    parent_field_id integer
);


--
-- Name: TABLE ir_model_inherit; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_model_inherit IS 'Model Inheritance Tree';


--
-- Name: COLUMN ir_model_inherit.model_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_inherit.model_id IS 'Model';


--
-- Name: COLUMN ir_model_inherit.parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_inherit.parent_id IS 'Parent';


--
-- Name: COLUMN ir_model_inherit.parent_field_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_inherit.parent_field_id IS 'Parent Field';


--
-- Name: ir_model_inherit_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_model_inherit_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_model_inherit_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_model_inherit_id_seq OWNED BY public.ir_model_inherit.id;


--
-- Name: ir_model_relation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_model_relation (
    id integer NOT NULL,
    model integer NOT NULL,
    module integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    write_date timestamp without time zone,
    create_date timestamp without time zone
);


--
-- Name: TABLE ir_model_relation; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_model_relation IS 'Relation Model';


--
-- Name: COLUMN ir_model_relation.model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_relation.model IS 'Model';


--
-- Name: COLUMN ir_model_relation.module; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_relation.module IS 'Module';


--
-- Name: COLUMN ir_model_relation.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_relation.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_relation.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_relation.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_relation.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_relation.name IS 'Relation Name';


--
-- Name: COLUMN ir_model_relation.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_relation.write_date IS 'Write Date';


--
-- Name: COLUMN ir_model_relation.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_model_relation.create_date IS 'Create Date';


--
-- Name: ir_model_relation_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_model_relation_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_model_relation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_model_relation_id_seq OWNED BY public.ir_model_relation.id;


--
-- Name: ir_module_category; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_module_category (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer,
    parent_id integer,
    name jsonb NOT NULL,
    sequence integer,
    description jsonb,
    visible boolean,
    exclusive boolean
);


--
-- Name: COLUMN ir_module_category.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_module_category.sequence IS 'Sequence';


--
-- Name: COLUMN ir_module_category.description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_module_category.description IS 'Description';


--
-- Name: COLUMN ir_module_category.visible; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_module_category.visible IS 'Visible';


--
-- Name: COLUMN ir_module_category.exclusive; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_module_category.exclusive IS 'Exclusive';


--
-- Name: ir_module_category_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_module_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_module_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_module_category_id_seq OWNED BY public.ir_module_category.id;


--
-- Name: ir_module_module; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_module_module (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer,
    website character varying,
    summary jsonb,
    name character varying NOT NULL,
    author character varying,
    icon character varying,
    state character varying(16),
    latest_version character varying,
    shortdesc jsonb,
    category_id integer,
    description jsonb,
    application boolean DEFAULT false,
    demo boolean DEFAULT false,
    web boolean DEFAULT false,
    license character varying(32),
    sequence integer DEFAULT 100,
    auto_install boolean DEFAULT false,
    to_buy boolean DEFAULT false,
    maintainer character varying,
    published_version character varying,
    url character varying,
    contributors text,
    menus_by_module text,
    reports_by_module text,
    views_by_module text,
    module_type character varying,
    imported boolean
);


--
-- Name: COLUMN ir_module_module.maintainer; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_module_module.maintainer IS 'Maintainer';


--
-- Name: COLUMN ir_module_module.published_version; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_module_module.published_version IS 'Published Version';


--
-- Name: COLUMN ir_module_module.url; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_module_module.url IS 'URL';


--
-- Name: COLUMN ir_module_module.contributors; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_module_module.contributors IS 'Contributors';


--
-- Name: COLUMN ir_module_module.menus_by_module; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_module_module.menus_by_module IS 'Menus';


--
-- Name: COLUMN ir_module_module.reports_by_module; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_module_module.reports_by_module IS 'Reports';


--
-- Name: COLUMN ir_module_module.views_by_module; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_module_module.views_by_module IS 'Views';


--
-- Name: COLUMN ir_module_module.module_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_module_module.module_type IS 'Module Type';


--
-- Name: COLUMN ir_module_module.imported; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_module_module.imported IS 'Imported Module';


--
-- Name: ir_module_module_dependency; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_module_module_dependency (
    id integer NOT NULL,
    name character varying,
    module_id integer,
    auto_install_required boolean DEFAULT true
);


--
-- Name: ir_module_module_dependency_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_module_module_dependency_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_module_module_dependency_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_module_module_dependency_id_seq OWNED BY public.ir_module_module_dependency.id;


--
-- Name: ir_module_module_exclusion; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_module_module_exclusion (
    id integer NOT NULL,
    module_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE ir_module_module_exclusion; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_module_module_exclusion IS 'Module exclusion';


--
-- Name: COLUMN ir_module_module_exclusion.module_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_module_module_exclusion.module_id IS 'Module';


--
-- Name: COLUMN ir_module_module_exclusion.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_module_module_exclusion.create_uid IS 'Created by';


--
-- Name: COLUMN ir_module_module_exclusion.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_module_module_exclusion.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_module_module_exclusion.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_module_module_exclusion.name IS 'Name';


--
-- Name: COLUMN ir_module_module_exclusion.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_module_module_exclusion.create_date IS 'Created on';


--
-- Name: COLUMN ir_module_module_exclusion.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_module_module_exclusion.write_date IS 'Last Updated on';


--
-- Name: ir_module_module_exclusion_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_module_module_exclusion_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_module_module_exclusion_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_module_module_exclusion_id_seq OWNED BY public.ir_module_module_exclusion.id;


--
-- Name: ir_module_module_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_module_module_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_module_module_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_module_module_id_seq OWNED BY public.ir_module_module.id;


--
-- Name: ir_profile; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_profile (
    id integer NOT NULL,
    sql_count integer,
    entry_count integer,
    session character varying,
    name character varying,
    init_stack_trace text,
    sql text,
    traces_async text,
    traces_sync text,
    qweb text,
    create_date timestamp without time zone,
    duration double precision
);


--
-- Name: TABLE ir_profile; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_profile IS 'Profiling results';


--
-- Name: COLUMN ir_profile.sql_count; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_profile.sql_count IS 'Queries Count';


--
-- Name: COLUMN ir_profile.entry_count; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_profile.entry_count IS 'Entry count';


--
-- Name: COLUMN ir_profile.session; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_profile.session IS 'Session';


--
-- Name: COLUMN ir_profile.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_profile.name IS 'Description';


--
-- Name: COLUMN ir_profile.init_stack_trace; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_profile.init_stack_trace IS 'Initial stack trace';


--
-- Name: COLUMN ir_profile.sql; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_profile.sql IS 'Sql';


--
-- Name: COLUMN ir_profile.traces_async; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_profile.traces_async IS 'Traces Async';


--
-- Name: COLUMN ir_profile.traces_sync; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_profile.traces_sync IS 'Traces Sync';


--
-- Name: COLUMN ir_profile.qweb; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_profile.qweb IS 'Qweb';


--
-- Name: COLUMN ir_profile.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_profile.create_date IS 'Creation Date';


--
-- Name: COLUMN ir_profile.duration; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_profile.duration IS 'Duration';


--
-- Name: ir_profile_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_profile_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_profile_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_profile_id_seq OWNED BY public.ir_profile.id;


--
-- Name: ir_property; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_property (
    id integer NOT NULL,
    company_id integer,
    fields_id integer NOT NULL,
    value_integer integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    res_id character varying,
    value_reference character varying,
    type character varying NOT NULL,
    value_text text,
    value_datetime timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    value_float double precision,
    value_binary bytea
);


--
-- Name: TABLE ir_property; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_property IS 'Company Property';


--
-- Name: COLUMN ir_property.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_property.company_id IS 'Company';


--
-- Name: COLUMN ir_property.fields_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_property.fields_id IS 'Field';


--
-- Name: COLUMN ir_property.value_integer; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_property.value_integer IS 'Value Integer';


--
-- Name: COLUMN ir_property.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_property.create_uid IS 'Created by';


--
-- Name: COLUMN ir_property.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_property.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_property.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_property.name IS 'Name';


--
-- Name: COLUMN ir_property.res_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_property.res_id IS 'Resource';


--
-- Name: COLUMN ir_property.value_reference; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_property.value_reference IS 'Value Reference';


--
-- Name: COLUMN ir_property.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_property.type IS 'Type';


--
-- Name: COLUMN ir_property.value_text; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_property.value_text IS 'Value Text';


--
-- Name: COLUMN ir_property.value_datetime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_property.value_datetime IS 'Value Datetime';


--
-- Name: COLUMN ir_property.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_property.create_date IS 'Created on';


--
-- Name: COLUMN ir_property.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_property.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_property.value_float; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_property.value_float IS 'Value Float';


--
-- Name: COLUMN ir_property.value_binary; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_property.value_binary IS 'Value Binary';


--
-- Name: ir_property_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_property_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_property_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_property_id_seq OWNED BY public.ir_property.id;


--
-- Name: ir_rule; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_rule (
    id integer NOT NULL,
    model_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    domain_force text,
    active boolean,
    perm_read boolean,
    perm_write boolean,
    perm_create boolean,
    perm_unlink boolean,
    global boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_rule_no_access_rights CHECK (((perm_read <> false) OR (perm_write <> false) OR (perm_create <> false) OR (perm_unlink <> false)))
);


--
-- Name: TABLE ir_rule; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_rule IS 'Record Rule';


--
-- Name: COLUMN ir_rule.model_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_rule.model_id IS 'Model';


--
-- Name: COLUMN ir_rule.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_rule.create_uid IS 'Created by';


--
-- Name: COLUMN ir_rule.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_rule.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_rule.name IS 'Name';


--
-- Name: COLUMN ir_rule.domain_force; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_rule.domain_force IS 'Domain';


--
-- Name: COLUMN ir_rule.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_rule.active IS 'Active';


--
-- Name: COLUMN ir_rule.perm_read; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_rule.perm_read IS 'Read';


--
-- Name: COLUMN ir_rule.perm_write; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_rule.perm_write IS 'Write';


--
-- Name: COLUMN ir_rule.perm_create; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_rule.perm_create IS 'Create';


--
-- Name: COLUMN ir_rule.perm_unlink; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_rule.perm_unlink IS 'Delete';


--
-- Name: COLUMN ir_rule.global; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_rule.global IS 'Global';


--
-- Name: COLUMN ir_rule.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_rule.create_date IS 'Created on';


--
-- Name: COLUMN ir_rule.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_rule.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_rule_no_access_rights ON ir_rule; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT ir_rule_no_access_rights ON public.ir_rule IS 'CHECK (perm_read!=False or perm_write!=False or perm_create!=False or perm_unlink!=False)';


--
-- Name: ir_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_rule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_rule_id_seq OWNED BY public.ir_rule.id;


--
-- Name: ir_sequence; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_sequence (
    id integer NOT NULL,
    number_next integer NOT NULL,
    number_increment integer NOT NULL,
    padding integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying,
    implementation character varying NOT NULL,
    prefix character varying,
    suffix character varying,
    active boolean,
    use_date_range boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE ir_sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_sequence IS 'Sequence';


--
-- Name: COLUMN ir_sequence.number_next; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_sequence.number_next IS 'Next Number';


--
-- Name: COLUMN ir_sequence.number_increment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_sequence.number_increment IS 'Step';


--
-- Name: COLUMN ir_sequence.padding; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_sequence.padding IS 'Sequence Size';


--
-- Name: COLUMN ir_sequence.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_sequence.company_id IS 'Company';


--
-- Name: COLUMN ir_sequence.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_sequence.create_uid IS 'Created by';


--
-- Name: COLUMN ir_sequence.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_sequence.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_sequence.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_sequence.name IS 'Name';


--
-- Name: COLUMN ir_sequence.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_sequence.code IS 'Sequence Code';


--
-- Name: COLUMN ir_sequence.implementation; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_sequence.implementation IS 'Implementation';


--
-- Name: COLUMN ir_sequence.prefix; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_sequence.prefix IS 'Prefix';


--
-- Name: COLUMN ir_sequence.suffix; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_sequence.suffix IS 'Suffix';


--
-- Name: COLUMN ir_sequence.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_sequence.active IS 'Active';


--
-- Name: COLUMN ir_sequence.use_date_range; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_sequence.use_date_range IS 'Use subsequences per date_range';


--
-- Name: COLUMN ir_sequence.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_sequence.create_date IS 'Created on';


--
-- Name: COLUMN ir_sequence.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_sequence.write_date IS 'Last Updated on';


--
-- Name: ir_sequence_date_range; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_sequence_date_range (
    id integer NOT NULL,
    sequence_id integer NOT NULL,
    number_next integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date_from date NOT NULL,
    date_to date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE ir_sequence_date_range; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_sequence_date_range IS 'Sequence Date Range';


--
-- Name: COLUMN ir_sequence_date_range.sequence_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_sequence_date_range.sequence_id IS 'Main Sequence';


--
-- Name: COLUMN ir_sequence_date_range.number_next; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_sequence_date_range.number_next IS 'Next Number';


--
-- Name: COLUMN ir_sequence_date_range.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_sequence_date_range.create_uid IS 'Created by';


--
-- Name: COLUMN ir_sequence_date_range.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_sequence_date_range.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_sequence_date_range.date_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_sequence_date_range.date_from IS 'From';


--
-- Name: COLUMN ir_sequence_date_range.date_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_sequence_date_range.date_to IS 'To';


--
-- Name: COLUMN ir_sequence_date_range.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_sequence_date_range.create_date IS 'Created on';


--
-- Name: COLUMN ir_sequence_date_range.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_sequence_date_range.write_date IS 'Last Updated on';


--
-- Name: ir_sequence_date_range_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_sequence_date_range_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_sequence_date_range_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_sequence_date_range_id_seq OWNED BY public.ir_sequence_date_range.id;


--
-- Name: ir_sequence_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_sequence_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_sequence_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_sequence_id_seq OWNED BY public.ir_sequence.id;


--
-- Name: ir_ui_menu; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_ui_menu (
    id integer NOT NULL,
    sequence integer,
    parent_id integer,
    create_uid integer,
    write_uid integer,
    parent_path character varying,
    web_icon character varying,
    action character varying,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE ir_ui_menu; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_ui_menu IS 'Menu';


--
-- Name: COLUMN ir_ui_menu.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_menu.sequence IS 'Sequence';


--
-- Name: COLUMN ir_ui_menu.parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_menu.parent_id IS 'Parent Menu';


--
-- Name: COLUMN ir_ui_menu.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_menu.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_menu.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_menu.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_menu.parent_path; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_menu.parent_path IS 'Parent Path';


--
-- Name: COLUMN ir_ui_menu.web_icon; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_menu.web_icon IS 'Web Icon File';


--
-- Name: COLUMN ir_ui_menu.action; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_menu.action IS 'Action';


--
-- Name: COLUMN ir_ui_menu.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_menu.name IS 'Menu';


--
-- Name: COLUMN ir_ui_menu.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_menu.active IS 'Active';


--
-- Name: COLUMN ir_ui_menu.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_menu.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_menu.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_menu.write_date IS 'Last Updated on';


--
-- Name: ir_ui_menu_group_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_ui_menu_group_rel (
    menu_id integer NOT NULL,
    gid integer NOT NULL
);


--
-- Name: TABLE ir_ui_menu_group_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_ui_menu_group_rel IS 'RELATION BETWEEN ir_ui_menu AND res_groups';


--
-- Name: ir_ui_menu_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_ui_menu_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_ui_menu_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_ui_menu_id_seq OWNED BY public.ir_ui_menu.id;


--
-- Name: ir_ui_view; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_ui_view (
    id integer NOT NULL,
    priority integer NOT NULL,
    inherit_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    model character varying,
    key character varying,
    type character varying,
    arch_fs character varying,
    mode character varying NOT NULL,
    arch_db jsonb,
    arch_prev text,
    arch_updated boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_ui_view_inheritance_mode CHECK ((((mode)::text <> 'extension'::text) OR (inherit_id IS NOT NULL))),
    CONSTRAINT ir_ui_view_qweb_required_key CHECK ((((type)::text <> 'qweb'::text) OR (key IS NOT NULL)))
);


--
-- Name: TABLE ir_ui_view; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_ui_view IS 'View';


--
-- Name: COLUMN ir_ui_view.priority; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_view.priority IS 'Sequence';


--
-- Name: COLUMN ir_ui_view.inherit_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_view.inherit_id IS 'Inherited View';


--
-- Name: COLUMN ir_ui_view.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_view.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_view.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_view.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_view.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_view.name IS 'View Name';


--
-- Name: COLUMN ir_ui_view.model; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_view.model IS 'Model';


--
-- Name: COLUMN ir_ui_view.key; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_view.key IS 'Key';


--
-- Name: COLUMN ir_ui_view.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_view.type IS 'View Type';


--
-- Name: COLUMN ir_ui_view.arch_fs; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_view.arch_fs IS 'Arch Filename';


--
-- Name: COLUMN ir_ui_view.mode; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_view.mode IS 'View inheritance mode';


--
-- Name: COLUMN ir_ui_view.arch_db; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_view.arch_db IS 'Arch Blob';


--
-- Name: COLUMN ir_ui_view.arch_prev; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_view.arch_prev IS 'Previous View Architecture';


--
-- Name: COLUMN ir_ui_view.arch_updated; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_view.arch_updated IS 'Modified Architecture';


--
-- Name: COLUMN ir_ui_view.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_view.active IS 'Active';


--
-- Name: COLUMN ir_ui_view.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_view.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_view.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_view.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_ui_view_inheritance_mode ON ir_ui_view; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT ir_ui_view_inheritance_mode ON public.ir_ui_view IS 'CHECK (mode != ''extension'' OR inherit_id IS NOT NULL)';


--
-- Name: CONSTRAINT ir_ui_view_qweb_required_key ON ir_ui_view; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT ir_ui_view_qweb_required_key ON public.ir_ui_view IS 'CHECK (type != ''qweb'' OR key IS NOT NULL)';


--
-- Name: ir_ui_view_custom; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_ui_view_custom (
    id integer NOT NULL,
    ref_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    arch text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE ir_ui_view_custom; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_ui_view_custom IS 'Custom View';


--
-- Name: COLUMN ir_ui_view_custom.ref_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_view_custom.ref_id IS 'Original View';


--
-- Name: COLUMN ir_ui_view_custom.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_view_custom.user_id IS 'User';


--
-- Name: COLUMN ir_ui_view_custom.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_view_custom.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_view_custom.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_view_custom.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_view_custom.arch; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_view_custom.arch IS 'View Architecture';


--
-- Name: COLUMN ir_ui_view_custom.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_view_custom.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_view_custom.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.ir_ui_view_custom.write_date IS 'Last Updated on';


--
-- Name: ir_ui_view_custom_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_ui_view_custom_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_ui_view_custom_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_ui_view_custom_id_seq OWNED BY public.ir_ui_view_custom.id;


--
-- Name: ir_ui_view_group_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.ir_ui_view_group_rel (
    view_id integer NOT NULL,
    group_id integer NOT NULL
);


--
-- Name: TABLE ir_ui_view_group_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.ir_ui_view_group_rel IS 'RELATION BETWEEN ir_ui_view AND res_groups';


--
-- Name: ir_ui_view_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.ir_ui_view_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: ir_ui_view_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.ir_ui_view_id_seq OWNED BY public.ir_ui_view.id;


--
-- Name: rel_modules_langexport; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.rel_modules_langexport (
    wiz_id integer NOT NULL,
    module_id integer NOT NULL
);


--
-- Name: TABLE rel_modules_langexport; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.rel_modules_langexport IS 'RELATION BETWEEN base_language_export AND ir_module_module';


--
-- Name: rel_server_actions; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.rel_server_actions (
    server_id integer NOT NULL,
    action_id integer NOT NULL
);


--
-- Name: TABLE rel_server_actions; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.rel_server_actions IS 'RELATION BETWEEN ir_act_server AND ir_act_server';


--
-- Name: report_layout; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.report_layout (
    id integer NOT NULL,
    view_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    image character varying,
    pdf character varying,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE report_layout; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.report_layout IS 'Report Layout';


--
-- Name: COLUMN report_layout.view_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.report_layout.view_id IS 'Document Template';


--
-- Name: COLUMN report_layout.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.report_layout.sequence IS 'Sequence';


--
-- Name: COLUMN report_layout.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.report_layout.create_uid IS 'Created by';


--
-- Name: COLUMN report_layout.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.report_layout.write_uid IS 'Last Updated by';


--
-- Name: COLUMN report_layout.image; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.report_layout.image IS 'Preview image src';


--
-- Name: COLUMN report_layout.pdf; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.report_layout.pdf IS 'Preview pdf src';


--
-- Name: COLUMN report_layout.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.report_layout.name IS 'Name';


--
-- Name: COLUMN report_layout.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.report_layout.create_date IS 'Created on';


--
-- Name: COLUMN report_layout.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.report_layout.write_date IS 'Last Updated on';


--
-- Name: report_layout_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.report_layout_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: report_layout_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.report_layout_id_seq OWNED BY public.report_layout.id;


--
-- Name: report_paperformat; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.report_paperformat (
    id integer NOT NULL,
    page_height integer,
    page_width integer,
    header_spacing integer,
    dpi integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    format character varying,
    orientation character varying,
    "default" boolean,
    header_line boolean,
    disable_shrinking boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    margin_top double precision,
    margin_bottom double precision,
    margin_left double precision,
    margin_right double precision
);


--
-- Name: TABLE report_paperformat; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.report_paperformat IS 'Paper Format Config';


--
-- Name: COLUMN report_paperformat.page_height; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.report_paperformat.page_height IS 'Page height (mm)';


--
-- Name: COLUMN report_paperformat.page_width; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.report_paperformat.page_width IS 'Page width (mm)';


--
-- Name: COLUMN report_paperformat.header_spacing; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.report_paperformat.header_spacing IS 'Header spacing';


--
-- Name: COLUMN report_paperformat.dpi; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.report_paperformat.dpi IS 'Output DPI';


--
-- Name: COLUMN report_paperformat.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.report_paperformat.create_uid IS 'Created by';


--
-- Name: COLUMN report_paperformat.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.report_paperformat.write_uid IS 'Last Updated by';


--
-- Name: COLUMN report_paperformat.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.report_paperformat.name IS 'Name';


--
-- Name: COLUMN report_paperformat.format; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.report_paperformat.format IS 'Paper size';


--
-- Name: COLUMN report_paperformat.orientation; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.report_paperformat.orientation IS 'Orientation';


--
-- Name: COLUMN report_paperformat."default"; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.report_paperformat."default" IS 'Default paper format?';


--
-- Name: COLUMN report_paperformat.header_line; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.report_paperformat.header_line IS 'Display a header line';


--
-- Name: COLUMN report_paperformat.disable_shrinking; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.report_paperformat.disable_shrinking IS 'Disable smart shrinking';


--
-- Name: COLUMN report_paperformat.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.report_paperformat.create_date IS 'Created on';


--
-- Name: COLUMN report_paperformat.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.report_paperformat.write_date IS 'Last Updated on';


--
-- Name: COLUMN report_paperformat.margin_top; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.report_paperformat.margin_top IS 'Top Margin (mm)';


--
-- Name: COLUMN report_paperformat.margin_bottom; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.report_paperformat.margin_bottom IS 'Bottom Margin (mm)';


--
-- Name: COLUMN report_paperformat.margin_left; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.report_paperformat.margin_left IS 'Left Margin (mm)';


--
-- Name: COLUMN report_paperformat.margin_right; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.report_paperformat.margin_right IS 'Right Margin (mm)';


--
-- Name: report_paperformat_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.report_paperformat_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: report_paperformat_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.report_paperformat_id_seq OWNED BY public.report_paperformat.id;


--
-- Name: res_bank; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_bank (
    id integer NOT NULL,
    state integer,
    country integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    street character varying,
    street2 character varying,
    zip character varying,
    city character varying,
    email character varying,
    phone character varying,
    bic character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE res_bank; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.res_bank IS 'Bank';


--
-- Name: COLUMN res_bank.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_bank.state IS 'Fed. State';


--
-- Name: COLUMN res_bank.country; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_bank.country IS 'Country';


--
-- Name: COLUMN res_bank.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_bank.create_uid IS 'Created by';


--
-- Name: COLUMN res_bank.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_bank.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_bank.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_bank.name IS 'Name';


--
-- Name: COLUMN res_bank.street; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_bank.street IS 'Street';


--
-- Name: COLUMN res_bank.street2; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_bank.street2 IS 'Street2';


--
-- Name: COLUMN res_bank.zip; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_bank.zip IS 'Zip';


--
-- Name: COLUMN res_bank.city; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_bank.city IS 'City';


--
-- Name: COLUMN res_bank.email; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_bank.email IS 'Email';


--
-- Name: COLUMN res_bank.phone; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_bank.phone IS 'Phone';


--
-- Name: COLUMN res_bank.bic; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_bank.bic IS 'Bank Identifier Code';


--
-- Name: COLUMN res_bank.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_bank.active IS 'Active';


--
-- Name: COLUMN res_bank.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_bank.create_date IS 'Created on';


--
-- Name: COLUMN res_bank.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_bank.write_date IS 'Last Updated on';


--
-- Name: res_bank_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.res_bank_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_bank_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.res_bank_id_seq OWNED BY public.res_bank.id;


--
-- Name: res_company; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_company (
    id integer NOT NULL,
    name character varying NOT NULL,
    partner_id integer NOT NULL,
    currency_id integer NOT NULL,
    sequence integer,
    create_date timestamp without time zone,
    parent_path character varying,
    parent_id integer,
    paperformat_id integer,
    external_report_layout_id integer,
    create_uid integer,
    write_uid integer,
    email character varying,
    phone character varying,
    mobile character varying,
    font character varying,
    primary_color character varying,
    secondary_color character varying,
    layout_background character varying NOT NULL,
    report_header jsonb,
    report_footer jsonb,
    company_details jsonb,
    active boolean,
    uses_default_logo boolean,
    write_date timestamp without time zone,
    logo_web bytea
);


--
-- Name: COLUMN res_company.parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.parent_id IS 'Parent Company';


--
-- Name: COLUMN res_company.paperformat_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.paperformat_id IS 'Paper format';


--
-- Name: COLUMN res_company.external_report_layout_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.external_report_layout_id IS 'Document Template';


--
-- Name: COLUMN res_company.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.create_uid IS 'Created by';


--
-- Name: COLUMN res_company.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_company.email; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.email IS 'Email';


--
-- Name: COLUMN res_company.phone; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.phone IS 'Phone';


--
-- Name: COLUMN res_company.mobile; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.mobile IS 'Mobile';


--
-- Name: COLUMN res_company.font; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.font IS 'Font';


--
-- Name: COLUMN res_company.primary_color; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.primary_color IS 'Primary Color';


--
-- Name: COLUMN res_company.secondary_color; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.secondary_color IS 'Secondary Color';


--
-- Name: COLUMN res_company.layout_background; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.layout_background IS 'Layout Background';


--
-- Name: COLUMN res_company.report_header; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.report_header IS 'Company Tagline';


--
-- Name: COLUMN res_company.report_footer; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.report_footer IS 'Report Footer';


--
-- Name: COLUMN res_company.company_details; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.company_details IS 'Company Details';


--
-- Name: COLUMN res_company.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.active IS 'Active';


--
-- Name: COLUMN res_company.uses_default_logo; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.uses_default_logo IS 'Uses Default Logo';


--
-- Name: COLUMN res_company.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_company.logo_web; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_company.logo_web IS 'Logo Web';


--
-- Name: res_company_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.res_company_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_company_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.res_company_id_seq OWNED BY public.res_company.id;


--
-- Name: res_company_users_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_company_users_rel (
    cid integer NOT NULL,
    user_id integer NOT NULL
);


--
-- Name: TABLE res_company_users_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.res_company_users_rel IS 'RELATION BETWEEN res_company AND res_users';


--
-- Name: res_config; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_config (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE res_config; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.res_config IS 'Config';


--
-- Name: COLUMN res_config.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config.create_uid IS 'Created by';


--
-- Name: COLUMN res_config.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_config.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config.create_date IS 'Created on';


--
-- Name: COLUMN res_config.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config.write_date IS 'Last Updated on';


--
-- Name: res_config_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.res_config_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.res_config_id_seq OWNED BY public.res_config.id;


--
-- Name: res_config_installer; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_config_installer (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE res_config_installer; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.res_config_installer IS 'Config Installer';


--
-- Name: COLUMN res_config_installer.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_installer.create_uid IS 'Created by';


--
-- Name: COLUMN res_config_installer.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_installer.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_config_installer.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_installer.create_date IS 'Created on';


--
-- Name: COLUMN res_config_installer.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_installer.write_date IS 'Last Updated on';


--
-- Name: res_config_installer_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.res_config_installer_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_config_installer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.res_config_installer_id_seq OWNED BY public.res_config_installer.id;


--
-- Name: res_config_settings; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_config_settings (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    web_app_name character varying,
    company_id integer NOT NULL,
    user_default_rights boolean,
    module_base_import boolean,
    module_google_calendar boolean,
    module_microsoft_calendar boolean,
    module_mail_plugin boolean,
    module_auth_oauth boolean,
    module_auth_ldap boolean,
    module_account_inter_company_rules boolean,
    module_voip boolean,
    module_web_unsplash boolean,
    module_partner_autocomplete boolean,
    module_base_geolocalize boolean,
    module_google_recaptcha boolean,
    module_website_cf_turnstile boolean,
    group_multi_currency boolean,
    show_effect boolean,
    module_product_images boolean,
    profiling_enabled_until timestamp without time zone,
    unsplash_access_key character varying,
    unsplash_app_id character varying
);


--
-- Name: TABLE res_config_settings; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.res_config_settings IS 'Config Settings';


--
-- Name: COLUMN res_config_settings.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.create_uid IS 'Created by';


--
-- Name: COLUMN res_config_settings.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_config_settings.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.create_date IS 'Created on';


--
-- Name: COLUMN res_config_settings.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_config_settings.web_app_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.web_app_name IS 'Web App Name';


--
-- Name: COLUMN res_config_settings.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.company_id IS 'Company';


--
-- Name: COLUMN res_config_settings.user_default_rights; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.user_default_rights IS 'Default Access Rights';


--
-- Name: COLUMN res_config_settings.module_base_import; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_base_import IS 'Allow users to import data from CSV/XLS/XLSX/ODS files';


--
-- Name: COLUMN res_config_settings.module_google_calendar; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_google_calendar IS 'Allow the users to synchronize their calendar  with Google Calendar';


--
-- Name: COLUMN res_config_settings.module_microsoft_calendar; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_microsoft_calendar IS 'Allow the users to synchronize their calendar with Outlook Calendar';


--
-- Name: COLUMN res_config_settings.module_mail_plugin; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_mail_plugin IS 'Allow integration with the mail plugins';


--
-- Name: COLUMN res_config_settings.module_auth_oauth; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_auth_oauth IS 'Use external authentication providers (OAuth)';


--
-- Name: COLUMN res_config_settings.module_auth_ldap; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_auth_ldap IS 'LDAP Authentication';


--
-- Name: COLUMN res_config_settings.module_account_inter_company_rules; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_account_inter_company_rules IS 'Manage Inter Company';


--
-- Name: COLUMN res_config_settings.module_voip; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_voip IS 'Asterisk (VoIP)';


--
-- Name: COLUMN res_config_settings.module_web_unsplash; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_web_unsplash IS 'Unsplash Image Library';


--
-- Name: COLUMN res_config_settings.module_partner_autocomplete; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_partner_autocomplete IS 'Partner Autocomplete';


--
-- Name: COLUMN res_config_settings.module_base_geolocalize; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_base_geolocalize IS 'GeoLocalize';


--
-- Name: COLUMN res_config_settings.module_google_recaptcha; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_google_recaptcha IS 'reCAPTCHA';


--
-- Name: COLUMN res_config_settings.module_website_cf_turnstile; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_website_cf_turnstile IS 'Cloudflare Turnstile';


--
-- Name: COLUMN res_config_settings.group_multi_currency; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.group_multi_currency IS 'Multi-Currencies';


--
-- Name: COLUMN res_config_settings.show_effect; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.show_effect IS 'Show Effect';


--
-- Name: COLUMN res_config_settings.module_product_images; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.module_product_images IS 'Get product pictures using barcode';


--
-- Name: COLUMN res_config_settings.profiling_enabled_until; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.profiling_enabled_until IS 'Profiling enabled until';


--
-- Name: COLUMN res_config_settings.unsplash_access_key; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.unsplash_access_key IS 'Access Key';


--
-- Name: COLUMN res_config_settings.unsplash_app_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_config_settings.unsplash_app_id IS 'Application ID';


--
-- Name: res_config_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.res_config_settings_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_config_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.res_config_settings_id_seq OWNED BY public.res_config_settings.id;


--
-- Name: res_country; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_country (
    id integer NOT NULL,
    address_view_id integer,
    currency_id integer,
    phone_code integer,
    create_uid integer,
    write_uid integer,
    code character varying(2) NOT NULL,
    name_position character varying,
    name jsonb NOT NULL,
    vat_label jsonb,
    address_format text,
    state_required boolean,
    zip_required boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE res_country; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.res_country IS 'Country';


--
-- Name: COLUMN res_country.address_view_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_country.address_view_id IS 'Input View';


--
-- Name: COLUMN res_country.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_country.currency_id IS 'Currency';


--
-- Name: COLUMN res_country.phone_code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_country.phone_code IS 'Country Calling Code';


--
-- Name: COLUMN res_country.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_country.create_uid IS 'Created by';


--
-- Name: COLUMN res_country.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_country.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_country.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_country.code IS 'Country Code';


--
-- Name: COLUMN res_country.name_position; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_country.name_position IS 'Customer Name Position';


--
-- Name: COLUMN res_country.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_country.name IS 'Country Name';


--
-- Name: COLUMN res_country.vat_label; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_country.vat_label IS 'Vat Label';


--
-- Name: COLUMN res_country.address_format; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_country.address_format IS 'Layout in Reports';


--
-- Name: COLUMN res_country.state_required; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_country.state_required IS 'State Required';


--
-- Name: COLUMN res_country.zip_required; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_country.zip_required IS 'Zip Required';


--
-- Name: COLUMN res_country.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_country.create_date IS 'Created on';


--
-- Name: COLUMN res_country.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_country.write_date IS 'Last Updated on';


--
-- Name: res_country_group; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_country_group (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE res_country_group; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.res_country_group IS 'Country Group';


--
-- Name: COLUMN res_country_group.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_country_group.create_uid IS 'Created by';


--
-- Name: COLUMN res_country_group.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_country_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_country_group.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_country_group.name IS 'Name';


--
-- Name: COLUMN res_country_group.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_country_group.create_date IS 'Created on';


--
-- Name: COLUMN res_country_group.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_country_group.write_date IS 'Last Updated on';


--
-- Name: res_country_group_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.res_country_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_country_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.res_country_group_id_seq OWNED BY public.res_country_group.id;


--
-- Name: res_country_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.res_country_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_country_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.res_country_id_seq OWNED BY public.res_country.id;


--
-- Name: res_country_res_country_group_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_country_res_country_group_rel (
    res_country_id integer NOT NULL,
    res_country_group_id integer NOT NULL
);


--
-- Name: TABLE res_country_res_country_group_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.res_country_res_country_group_rel IS 'RELATION BETWEEN res_country AND res_country_group';


--
-- Name: res_country_state; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_country_state (
    id integer NOT NULL,
    country_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE res_country_state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.res_country_state IS 'Country state';


--
-- Name: COLUMN res_country_state.country_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_country_state.country_id IS 'Country';


--
-- Name: COLUMN res_country_state.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_country_state.create_uid IS 'Created by';


--
-- Name: COLUMN res_country_state.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_country_state.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_country_state.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_country_state.name IS 'State Name';


--
-- Name: COLUMN res_country_state.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_country_state.code IS 'State Code';


--
-- Name: COLUMN res_country_state.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_country_state.create_date IS 'Created on';


--
-- Name: COLUMN res_country_state.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_country_state.write_date IS 'Last Updated on';


--
-- Name: res_country_state_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.res_country_state_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_country_state_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.res_country_state_id_seq OWNED BY public.res_country_state.id;


--
-- Name: res_currency; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_currency (
    id integer NOT NULL,
    name character varying NOT NULL,
    symbol character varying NOT NULL,
    decimal_places integer,
    create_uid integer,
    write_uid integer,
    full_name character varying,
    "position" character varying,
    currency_unit_label character varying,
    currency_subunit_label character varying,
    rounding numeric,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT res_currency_rounding_gt_zero CHECK ((rounding > (0)::numeric))
);


--
-- Name: COLUMN res_currency.decimal_places; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_currency.decimal_places IS 'Decimal Places';


--
-- Name: COLUMN res_currency.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_currency.create_uid IS 'Created by';


--
-- Name: COLUMN res_currency.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_currency.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_currency.full_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_currency.full_name IS 'Name';


--
-- Name: COLUMN res_currency."position"; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_currency."position" IS 'Symbol Position';


--
-- Name: COLUMN res_currency.currency_unit_label; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_currency.currency_unit_label IS 'Currency Unit';


--
-- Name: COLUMN res_currency.currency_subunit_label; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_currency.currency_subunit_label IS 'Currency Subunit';


--
-- Name: COLUMN res_currency.rounding; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_currency.rounding IS 'Rounding Factor';


--
-- Name: COLUMN res_currency.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_currency.active IS 'Active';


--
-- Name: COLUMN res_currency.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_currency.create_date IS 'Created on';


--
-- Name: COLUMN res_currency.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_currency.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT res_currency_rounding_gt_zero ON res_currency; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT res_currency_rounding_gt_zero ON public.res_currency IS 'CHECK (rounding>0)';


--
-- Name: res_currency_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.res_currency_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_currency_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.res_currency_id_seq OWNED BY public.res_currency.id;


--
-- Name: res_currency_rate; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_currency_rate (
    id integer NOT NULL,
    currency_id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    name date NOT NULL,
    rate numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT res_currency_rate_currency_rate_check CHECK ((rate > (0)::numeric))
);


--
-- Name: TABLE res_currency_rate; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.res_currency_rate IS 'Currency Rate';


--
-- Name: COLUMN res_currency_rate.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_currency_rate.currency_id IS 'Currency';


--
-- Name: COLUMN res_currency_rate.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_currency_rate.company_id IS 'Company';


--
-- Name: COLUMN res_currency_rate.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_currency_rate.create_uid IS 'Created by';


--
-- Name: COLUMN res_currency_rate.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_currency_rate.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_currency_rate.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_currency_rate.name IS 'Date';


--
-- Name: COLUMN res_currency_rate.rate; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_currency_rate.rate IS 'Technical Rate';


--
-- Name: COLUMN res_currency_rate.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_currency_rate.create_date IS 'Created on';


--
-- Name: COLUMN res_currency_rate.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_currency_rate.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT res_currency_rate_currency_rate_check ON res_currency_rate; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT res_currency_rate_currency_rate_check ON public.res_currency_rate IS 'CHECK (rate>0)';


--
-- Name: res_currency_rate_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.res_currency_rate_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_currency_rate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.res_currency_rate_id_seq OWNED BY public.res_currency_rate.id;


--
-- Name: res_groups; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_groups (
    id integer NOT NULL,
    name jsonb NOT NULL,
    category_id integer,
    color integer,
    create_uid integer,
    write_uid integer,
    comment jsonb,
    share boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: COLUMN res_groups.category_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_groups.category_id IS 'Application';


--
-- Name: COLUMN res_groups.color; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_groups.color IS 'Color Index';


--
-- Name: COLUMN res_groups.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_groups.create_uid IS 'Created by';


--
-- Name: COLUMN res_groups.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_groups.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_groups.comment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_groups.comment IS 'Comment';


--
-- Name: COLUMN res_groups.share; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_groups.share IS 'Share Group';


--
-- Name: COLUMN res_groups.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_groups.create_date IS 'Created on';


--
-- Name: COLUMN res_groups.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_groups.write_date IS 'Last Updated on';


--
-- Name: res_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.res_groups_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.res_groups_id_seq OWNED BY public.res_groups.id;


--
-- Name: res_groups_implied_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_groups_implied_rel (
    gid integer NOT NULL,
    hid integer NOT NULL
);


--
-- Name: TABLE res_groups_implied_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.res_groups_implied_rel IS 'RELATION BETWEEN res_groups AND res_groups';


--
-- Name: res_groups_report_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_groups_report_rel (
    uid integer NOT NULL,
    gid integer NOT NULL
);


--
-- Name: TABLE res_groups_report_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.res_groups_report_rel IS 'RELATION BETWEEN ir_act_report_xml AND res_groups';


--
-- Name: res_groups_users_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_groups_users_rel (
    gid integer NOT NULL,
    uid integer NOT NULL
);


--
-- Name: TABLE res_groups_users_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.res_groups_users_rel IS 'RELATION BETWEEN res_groups AND res_users';


--
-- Name: res_lang; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_lang (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying NOT NULL,
    iso_code character varying,
    url_code character varying NOT NULL,
    direction character varying NOT NULL,
    date_format character varying NOT NULL,
    time_format character varying NOT NULL,
    week_start character varying NOT NULL,
    "grouping" character varying NOT NULL,
    decimal_point character varying NOT NULL,
    thousands_sep character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE res_lang; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.res_lang IS 'Languages';


--
-- Name: COLUMN res_lang.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_lang.create_uid IS 'Created by';


--
-- Name: COLUMN res_lang.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_lang.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_lang.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_lang.name IS 'Name';


--
-- Name: COLUMN res_lang.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_lang.code IS 'Locale Code';


--
-- Name: COLUMN res_lang.iso_code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_lang.iso_code IS 'ISO code';


--
-- Name: COLUMN res_lang.url_code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_lang.url_code IS 'URL Code';


--
-- Name: COLUMN res_lang.direction; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_lang.direction IS 'Direction';


--
-- Name: COLUMN res_lang.date_format; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_lang.date_format IS 'Date Format';


--
-- Name: COLUMN res_lang.time_format; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_lang.time_format IS 'Time Format';


--
-- Name: COLUMN res_lang.week_start; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_lang.week_start IS 'First Day of Week';


--
-- Name: COLUMN res_lang."grouping"; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_lang."grouping" IS 'Separator Format';


--
-- Name: COLUMN res_lang.decimal_point; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_lang.decimal_point IS 'Decimal Separator';


--
-- Name: COLUMN res_lang.thousands_sep; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_lang.thousands_sep IS 'Thousands Separator';


--
-- Name: COLUMN res_lang.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_lang.active IS 'Active';


--
-- Name: COLUMN res_lang.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_lang.create_date IS 'Created on';


--
-- Name: COLUMN res_lang.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_lang.write_date IS 'Last Updated on';


--
-- Name: res_lang_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.res_lang_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_lang_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.res_lang_id_seq OWNED BY public.res_lang.id;


--
-- Name: res_lang_install_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_lang_install_rel (
    language_wizard_id integer NOT NULL,
    lang_id integer NOT NULL
);


--
-- Name: TABLE res_lang_install_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.res_lang_install_rel IS 'RELATION BETWEEN base_language_install AND res_lang';


--
-- Name: res_partner; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_partner (
    id integer NOT NULL,
    company_id integer,
    create_date timestamp without time zone,
    name character varying,
    title integer,
    parent_id integer,
    user_id integer,
    state_id integer,
    country_id integer,
    industry_id integer,
    color integer,
    commercial_partner_id integer,
    create_uid integer,
    write_uid integer,
    complete_name character varying,
    ref character varying,
    lang character varying,
    tz character varying,
    vat character varying,
    company_registry character varying,
    website character varying,
    function character varying,
    type character varying,
    street character varying,
    street2 character varying,
    zip character varying,
    city character varying,
    email character varying,
    phone character varying,
    mobile character varying,
    commercial_company_name character varying,
    company_name character varying,
    date date,
    comment text,
    partner_latitude numeric,
    partner_longitude numeric,
    active boolean,
    employee boolean,
    is_company boolean,
    partner_share boolean,
    write_date timestamp without time zone,
    CONSTRAINT res_partner_check_name CHECK (((((type)::text = 'contact'::text) AND (name IS NOT NULL)) OR ((type)::text <> 'contact'::text)))
);


--
-- Name: COLUMN res_partner.title; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.title IS 'Title';


--
-- Name: COLUMN res_partner.parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.parent_id IS 'Related Company';


--
-- Name: COLUMN res_partner.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.user_id IS 'Salesperson';


--
-- Name: COLUMN res_partner.state_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.state_id IS 'State';


--
-- Name: COLUMN res_partner.country_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.country_id IS 'Country';


--
-- Name: COLUMN res_partner.industry_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.industry_id IS 'Industry';


--
-- Name: COLUMN res_partner.color; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.color IS 'Color Index';


--
-- Name: COLUMN res_partner.commercial_partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.commercial_partner_id IS 'Commercial Entity';


--
-- Name: COLUMN res_partner.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner.complete_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.complete_name IS 'Complete Name';


--
-- Name: COLUMN res_partner.ref; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.ref IS 'Reference';


--
-- Name: COLUMN res_partner.lang; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.lang IS 'Language';


--
-- Name: COLUMN res_partner.tz; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.tz IS 'Timezone';


--
-- Name: COLUMN res_partner.vat; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.vat IS 'Tax ID';


--
-- Name: COLUMN res_partner.company_registry; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.company_registry IS 'Company ID';


--
-- Name: COLUMN res_partner.website; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.website IS 'Website Link';


--
-- Name: COLUMN res_partner.function; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.function IS 'Job Position';


--
-- Name: COLUMN res_partner.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.type IS 'Address Type';


--
-- Name: COLUMN res_partner.street; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.street IS 'Street';


--
-- Name: COLUMN res_partner.street2; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.street2 IS 'Street2';


--
-- Name: COLUMN res_partner.zip; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.zip IS 'Zip';


--
-- Name: COLUMN res_partner.city; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.city IS 'City';


--
-- Name: COLUMN res_partner.email; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.email IS 'Email';


--
-- Name: COLUMN res_partner.phone; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.phone IS 'Phone';


--
-- Name: COLUMN res_partner.mobile; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.mobile IS 'Mobile';


--
-- Name: COLUMN res_partner.commercial_company_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.commercial_company_name IS 'Company Name Entity';


--
-- Name: COLUMN res_partner.company_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.company_name IS 'Company Name';


--
-- Name: COLUMN res_partner.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.date IS 'Date';


--
-- Name: COLUMN res_partner.comment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.comment IS 'Notes';


--
-- Name: COLUMN res_partner.partner_latitude; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.partner_latitude IS 'Geo Latitude';


--
-- Name: COLUMN res_partner.partner_longitude; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.partner_longitude IS 'Geo Longitude';


--
-- Name: COLUMN res_partner.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.active IS 'Active';


--
-- Name: COLUMN res_partner.employee; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.employee IS 'Employee';


--
-- Name: COLUMN res_partner.is_company; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.is_company IS 'Is a Company';


--
-- Name: COLUMN res_partner.partner_share; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.partner_share IS 'Share Partner';


--
-- Name: COLUMN res_partner.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT res_partner_check_name ON res_partner; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON CONSTRAINT res_partner_check_name ON public.res_partner IS 'CHECK( (type=''contact'' AND name IS NOT NULL) or (type!=''contact'') )';


--
-- Name: res_partner_bank; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_partner_bank (
    id integer NOT NULL,
    partner_id integer NOT NULL,
    bank_id integer,
    sequence integer,
    currency_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    acc_number character varying NOT NULL,
    sanitized_acc_number character varying,
    acc_holder_name character varying,
    active boolean,
    allow_out_payment boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE res_partner_bank; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.res_partner_bank IS 'Bank Accounts';


--
-- Name: COLUMN res_partner_bank.partner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_bank.partner_id IS 'Account Holder';


--
-- Name: COLUMN res_partner_bank.bank_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_bank.bank_id IS 'Bank';


--
-- Name: COLUMN res_partner_bank.sequence; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_bank.sequence IS 'Sequence';


--
-- Name: COLUMN res_partner_bank.currency_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_bank.currency_id IS 'Currency';


--
-- Name: COLUMN res_partner_bank.company_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_bank.company_id IS 'Company';


--
-- Name: COLUMN res_partner_bank.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_bank.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_bank.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_bank.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_bank.acc_number; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_bank.acc_number IS 'Account Number';


--
-- Name: COLUMN res_partner_bank.sanitized_acc_number; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_bank.sanitized_acc_number IS 'Sanitized Account Number';


--
-- Name: COLUMN res_partner_bank.acc_holder_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_bank.acc_holder_name IS 'Account Holder Name';


--
-- Name: COLUMN res_partner_bank.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_bank.active IS 'Active';


--
-- Name: COLUMN res_partner_bank.allow_out_payment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_bank.allow_out_payment IS 'Send Money';


--
-- Name: COLUMN res_partner_bank.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_bank.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_bank.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_bank.write_date IS 'Last Updated on';


--
-- Name: res_partner_bank_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.res_partner_bank_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_partner_bank_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.res_partner_bank_id_seq OWNED BY public.res_partner_bank.id;


--
-- Name: res_partner_category; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_partner_category (
    id integer NOT NULL,
    color integer,
    parent_id integer,
    create_uid integer,
    write_uid integer,
    parent_path character varying,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE res_partner_category; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.res_partner_category IS 'Partner Tags';


--
-- Name: COLUMN res_partner_category.color; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_category.color IS 'Color';


--
-- Name: COLUMN res_partner_category.parent_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_category.parent_id IS 'Parent Category';


--
-- Name: COLUMN res_partner_category.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_category.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_category.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_category.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_category.parent_path; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_category.parent_path IS 'Parent Path';


--
-- Name: COLUMN res_partner_category.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_category.name IS 'Tag Name';


--
-- Name: COLUMN res_partner_category.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_category.active IS 'Active';


--
-- Name: COLUMN res_partner_category.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_category.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_category.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_category.write_date IS 'Last Updated on';


--
-- Name: res_partner_category_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.res_partner_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_partner_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.res_partner_category_id_seq OWNED BY public.res_partner_category.id;


--
-- Name: res_partner_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.res_partner_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_partner_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.res_partner_id_seq OWNED BY public.res_partner.id;


--
-- Name: res_partner_industry; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_partner_industry (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name jsonb,
    full_name jsonb,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE res_partner_industry; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.res_partner_industry IS 'Industry';


--
-- Name: COLUMN res_partner_industry.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_industry.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_industry.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_industry.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_industry.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_industry.name IS 'Name';


--
-- Name: COLUMN res_partner_industry.full_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_industry.full_name IS 'Full Name';


--
-- Name: COLUMN res_partner_industry.active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_industry.active IS 'Active';


--
-- Name: COLUMN res_partner_industry.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_industry.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_industry.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_industry.write_date IS 'Last Updated on';


--
-- Name: res_partner_industry_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.res_partner_industry_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_partner_industry_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.res_partner_industry_id_seq OWNED BY public.res_partner_industry.id;


--
-- Name: res_partner_res_partner_category_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_partner_res_partner_category_rel (
    category_id integer NOT NULL,
    partner_id integer NOT NULL
);


--
-- Name: TABLE res_partner_res_partner_category_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.res_partner_res_partner_category_rel IS 'RELATION BETWEEN res_partner_category AND res_partner';


--
-- Name: res_partner_title; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_partner_title (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    shortcut jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE res_partner_title; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.res_partner_title IS 'Partner Title';


--
-- Name: COLUMN res_partner_title.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_title.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_title.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_title.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_title.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_title.name IS 'Title';


--
-- Name: COLUMN res_partner_title.shortcut; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_title.shortcut IS 'Abbreviation';


--
-- Name: COLUMN res_partner_title.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_title.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_title.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_partner_title.write_date IS 'Last Updated on';


--
-- Name: res_partner_title_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.res_partner_title_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_partner_title_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.res_partner_title_id_seq OWNED BY public.res_partner_title.id;


--
-- Name: res_users; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_users (
    id integer NOT NULL,
    company_id integer NOT NULL,
    partner_id integer NOT NULL,
    active boolean DEFAULT true,
    create_date timestamp without time zone,
    login character varying NOT NULL,
    password character varying,
    action_id integer,
    create_uid integer,
    write_uid integer,
    signature text,
    share boolean,
    write_date timestamp without time zone,
    totp_secret character varying
);


--
-- Name: COLUMN res_users.action_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_users.action_id IS 'Home Action';


--
-- Name: COLUMN res_users.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_users.create_uid IS 'Created by';


--
-- Name: COLUMN res_users.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_users.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users.signature; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_users.signature IS 'Email Signature';


--
-- Name: COLUMN res_users.share; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_users.share IS 'Share User';


--
-- Name: COLUMN res_users.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_users.write_date IS 'Last Updated on';


--
-- Name: res_users_apikeys; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_users_apikeys (
    id integer NOT NULL,
    name character varying NOT NULL,
    user_id integer NOT NULL,
    scope character varying,
    index character varying(8),
    key character varying,
    create_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'utc'::text),
    CONSTRAINT res_users_apikeys_index_check CHECK ((char_length((index)::text) = 8))
);


--
-- Name: res_users_apikeys_description; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_users_apikeys_description (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE res_users_apikeys_description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.res_users_apikeys_description IS 'API Key Description';


--
-- Name: COLUMN res_users_apikeys_description.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_users_apikeys_description.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_apikeys_description.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_users_apikeys_description.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_apikeys_description.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_users_apikeys_description.name IS 'Description';


--
-- Name: COLUMN res_users_apikeys_description.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_users_apikeys_description.create_date IS 'Created on';


--
-- Name: COLUMN res_users_apikeys_description.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_users_apikeys_description.write_date IS 'Last Updated on';


--
-- Name: res_users_apikeys_description_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.res_users_apikeys_description_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_users_apikeys_description_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.res_users_apikeys_description_id_seq OWNED BY public.res_users_apikeys_description.id;


--
-- Name: res_users_apikeys_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.res_users_apikeys_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_users_apikeys_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.res_users_apikeys_id_seq OWNED BY public.res_users_apikeys.id;


--
-- Name: res_users_deletion; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_users_deletion (
    id integer NOT NULL,
    user_id integer,
    user_id_int integer,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE res_users_deletion; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.res_users_deletion IS 'Users Deletion Request';


--
-- Name: COLUMN res_users_deletion.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_users_deletion.user_id IS 'User';


--
-- Name: COLUMN res_users_deletion.user_id_int; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_users_deletion.user_id_int IS 'User Id';


--
-- Name: COLUMN res_users_deletion.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_users_deletion.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_deletion.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_users_deletion.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_deletion.state; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_users_deletion.state IS 'State';


--
-- Name: COLUMN res_users_deletion.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_users_deletion.create_date IS 'Created on';


--
-- Name: COLUMN res_users_deletion.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_users_deletion.write_date IS 'Last Updated on';


--
-- Name: res_users_deletion_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.res_users_deletion_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_users_deletion_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.res_users_deletion_id_seq OWNED BY public.res_users_deletion.id;


--
-- Name: res_users_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.res_users_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_users_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.res_users_id_seq OWNED BY public.res_users.id;


--
-- Name: res_users_identitycheck; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_users_identitycheck (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    request character varying,
    password character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE res_users_identitycheck; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.res_users_identitycheck IS 'Password Check Wizard';


--
-- Name: COLUMN res_users_identitycheck.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_users_identitycheck.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_identitycheck.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_users_identitycheck.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_identitycheck.request; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_users_identitycheck.request IS 'Request';


--
-- Name: COLUMN res_users_identitycheck.password; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_users_identitycheck.password IS 'Password';


--
-- Name: COLUMN res_users_identitycheck.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_users_identitycheck.create_date IS 'Created on';


--
-- Name: COLUMN res_users_identitycheck.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_users_identitycheck.write_date IS 'Last Updated on';


--
-- Name: res_users_identitycheck_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.res_users_identitycheck_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_users_identitycheck_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.res_users_identitycheck_id_seq OWNED BY public.res_users_identitycheck.id;


--
-- Name: res_users_log; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_users_log (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE res_users_log; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.res_users_log IS 'Users Log';


--
-- Name: COLUMN res_users_log.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_users_log.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_log.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_users_log.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_log.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_users_log.create_date IS 'Created on';


--
-- Name: COLUMN res_users_log.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_users_log.write_date IS 'Last Updated on';


--
-- Name: res_users_log_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.res_users_log_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_users_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.res_users_log_id_seq OWNED BY public.res_users_log.id;


--
-- Name: res_users_settings; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.res_users_settings (
    id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE res_users_settings; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.res_users_settings IS 'User Settings';


--
-- Name: COLUMN res_users_settings.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_users_settings.user_id IS 'User';


--
-- Name: COLUMN res_users_settings.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_users_settings.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_settings.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_users_settings.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_settings.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_users_settings.create_date IS 'Created on';


--
-- Name: COLUMN res_users_settings.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.res_users_settings.write_date IS 'Last Updated on';


--
-- Name: res_users_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.res_users_settings_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: res_users_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.res_users_settings_id_seq OWNED BY public.res_users_settings.id;


--
-- Name: reset_view_arch_wizard; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.reset_view_arch_wizard (
    id integer NOT NULL,
    view_id integer,
    compare_view_id integer,
    create_uid integer,
    write_uid integer,
    reset_mode character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE reset_view_arch_wizard; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.reset_view_arch_wizard IS 'Reset View Architecture Wizard';


--
-- Name: COLUMN reset_view_arch_wizard.view_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.reset_view_arch_wizard.view_id IS 'View';


--
-- Name: COLUMN reset_view_arch_wizard.compare_view_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.reset_view_arch_wizard.compare_view_id IS 'Compare To View';


--
-- Name: COLUMN reset_view_arch_wizard.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.reset_view_arch_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN reset_view_arch_wizard.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.reset_view_arch_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN reset_view_arch_wizard.reset_mode; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.reset_view_arch_wizard.reset_mode IS 'Reset Mode';


--
-- Name: COLUMN reset_view_arch_wizard.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.reset_view_arch_wizard.create_date IS 'Created on';


--
-- Name: COLUMN reset_view_arch_wizard.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.reset_view_arch_wizard.write_date IS 'Last Updated on';


--
-- Name: reset_view_arch_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.reset_view_arch_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: reset_view_arch_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.reset_view_arch_wizard_id_seq OWNED BY public.reset_view_arch_wizard.id;


--
-- Name: rule_group_rel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.rule_group_rel (
    rule_group_id integer NOT NULL,
    group_id integer NOT NULL
);


--
-- Name: TABLE rule_group_rel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.rule_group_rel IS 'RELATION BETWEEN ir_rule AND res_groups';


--
-- Name: web_editor_converter_test; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.web_editor_converter_test (
    id integer NOT NULL,
    "integer" integer,
    many2one integer,
    create_uid integer,
    write_uid integer,
    "char" character varying,
    selection_str character varying,
    date date,
    html text,
    text text,
    "numeric" numeric,
    datetime timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    "float" double precision,
    "binary" bytea
);


--
-- Name: TABLE web_editor_converter_test; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.web_editor_converter_test IS 'Web Editor Converter Test';


--
-- Name: COLUMN web_editor_converter_test."integer"; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.web_editor_converter_test."integer" IS 'Integer';


--
-- Name: COLUMN web_editor_converter_test.many2one; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.web_editor_converter_test.many2one IS 'Many2One';


--
-- Name: COLUMN web_editor_converter_test.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.web_editor_converter_test.create_uid IS 'Created by';


--
-- Name: COLUMN web_editor_converter_test.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.web_editor_converter_test.write_uid IS 'Last Updated by';


--
-- Name: COLUMN web_editor_converter_test."char"; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.web_editor_converter_test."char" IS 'Char';


--
-- Name: COLUMN web_editor_converter_test.selection_str; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.web_editor_converter_test.selection_str IS 'Lorsqu''un pancake prend l''avion à destination de Toronto et qu''il fait une escale technique à St Claude, on dit:';


--
-- Name: COLUMN web_editor_converter_test.date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.web_editor_converter_test.date IS 'Date';


--
-- Name: COLUMN web_editor_converter_test.html; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.web_editor_converter_test.html IS 'Html';


--
-- Name: COLUMN web_editor_converter_test.text; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.web_editor_converter_test.text IS 'Text';


--
-- Name: COLUMN web_editor_converter_test."numeric"; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.web_editor_converter_test."numeric" IS 'Numeric';


--
-- Name: COLUMN web_editor_converter_test.datetime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.web_editor_converter_test.datetime IS 'Datetime';


--
-- Name: COLUMN web_editor_converter_test.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.web_editor_converter_test.create_date IS 'Created on';


--
-- Name: COLUMN web_editor_converter_test.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.web_editor_converter_test.write_date IS 'Last Updated on';


--
-- Name: COLUMN web_editor_converter_test."float"; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.web_editor_converter_test."float" IS 'Float';


--
-- Name: COLUMN web_editor_converter_test."binary"; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.web_editor_converter_test."binary" IS 'Binary';


--
-- Name: web_editor_converter_test_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.web_editor_converter_test_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: web_editor_converter_test_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.web_editor_converter_test_id_seq OWNED BY public.web_editor_converter_test.id;


--
-- Name: web_editor_converter_test_sub; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.web_editor_converter_test_sub (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE web_editor_converter_test_sub; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.web_editor_converter_test_sub IS 'Web Editor Converter Subtest';


--
-- Name: COLUMN web_editor_converter_test_sub.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.web_editor_converter_test_sub.create_uid IS 'Created by';


--
-- Name: COLUMN web_editor_converter_test_sub.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.web_editor_converter_test_sub.write_uid IS 'Last Updated by';


--
-- Name: COLUMN web_editor_converter_test_sub.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.web_editor_converter_test_sub.name IS 'Name';


--
-- Name: COLUMN web_editor_converter_test_sub.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.web_editor_converter_test_sub.create_date IS 'Created on';


--
-- Name: COLUMN web_editor_converter_test_sub.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.web_editor_converter_test_sub.write_date IS 'Last Updated on';


--
-- Name: web_editor_converter_test_sub_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.web_editor_converter_test_sub_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: web_editor_converter_test_sub_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.web_editor_converter_test_sub_id_seq OWNED BY public.web_editor_converter_test_sub.id;


--
-- Name: web_tour_tour; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.web_tour_tour (
    id integer NOT NULL,
    user_id integer,
    name character varying NOT NULL
);


--
-- Name: TABLE web_tour_tour; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.web_tour_tour IS 'Tours';


--
-- Name: COLUMN web_tour_tour.user_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.web_tour_tour.user_id IS 'Consumed by';


--
-- Name: COLUMN web_tour_tour.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.web_tour_tour.name IS 'Tour name';


--
-- Name: web_tour_tour_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.web_tour_tour_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: web_tour_tour_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.web_tour_tour_id_seq OWNED BY public.web_tour_tour.id;


--
-- Name: wizard_ir_model_menu_create; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.wizard_ir_model_menu_create (
    id integer NOT NULL,
    menu_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


--
-- Name: TABLE wizard_ir_model_menu_create; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.wizard_ir_model_menu_create IS 'Create Menu Wizard';


--
-- Name: COLUMN wizard_ir_model_menu_create.menu_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.menu_id IS 'Parent Menu';


--
-- Name: COLUMN wizard_ir_model_menu_create.create_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.create_uid IS 'Created by';


--
-- Name: COLUMN wizard_ir_model_menu_create.write_uid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.write_uid IS 'Last Updated by';


--
-- Name: COLUMN wizard_ir_model_menu_create.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.name IS 'Menu Name';


--
-- Name: COLUMN wizard_ir_model_menu_create.create_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.create_date IS 'Created on';


--
-- Name: COLUMN wizard_ir_model_menu_create.write_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.write_date IS 'Last Updated on';


--
-- Name: wizard_ir_model_menu_create_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.wizard_ir_model_menu_create_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: wizard_ir_model_menu_create_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.wizard_ir_model_menu_create_id_seq OWNED BY public.wizard_ir_model_menu_create.id;


--
-- Name: auth_totp_device id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.auth_totp_device ALTER COLUMN id SET DEFAULT nextval('public.auth_totp_device_id_seq'::regclass);


--
-- Name: auth_totp_wizard id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.auth_totp_wizard ALTER COLUMN id SET DEFAULT nextval('public.auth_totp_wizard_id_seq'::regclass);


--
-- Name: base_document_layout id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.base_document_layout ALTER COLUMN id SET DEFAULT nextval('public.base_document_layout_id_seq'::regclass);


--
-- Name: base_enable_profiling_wizard id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.base_enable_profiling_wizard ALTER COLUMN id SET DEFAULT nextval('public.base_enable_profiling_wizard_id_seq'::regclass);


--
-- Name: base_import_import id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.base_import_import ALTER COLUMN id SET DEFAULT nextval('public.base_import_import_id_seq'::regclass);


--
-- Name: base_import_mapping id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.base_import_mapping ALTER COLUMN id SET DEFAULT nextval('public.base_import_mapping_id_seq'::regclass);


--
-- Name: base_import_module id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.base_import_module ALTER COLUMN id SET DEFAULT nextval('public.base_import_module_id_seq'::regclass);


--
-- Name: base_language_export id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.base_language_export ALTER COLUMN id SET DEFAULT nextval('public.base_language_export_id_seq'::regclass);


--
-- Name: base_language_import id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.base_language_import ALTER COLUMN id SET DEFAULT nextval('public.base_language_import_id_seq'::regclass);


--
-- Name: base_language_install id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.base_language_install ALTER COLUMN id SET DEFAULT nextval('public.base_language_install_id_seq'::regclass);


--
-- Name: base_module_uninstall id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.base_module_uninstall ALTER COLUMN id SET DEFAULT nextval('public.base_module_uninstall_id_seq'::regclass);


--
-- Name: base_module_update id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.base_module_update ALTER COLUMN id SET DEFAULT nextval('public.base_module_update_id_seq'::regclass);


--
-- Name: base_module_upgrade id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.base_module_upgrade ALTER COLUMN id SET DEFAULT nextval('public.base_module_upgrade_id_seq'::regclass);


--
-- Name: base_partner_merge_automatic_wizard id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.base_partner_merge_automatic_wizard ALTER COLUMN id SET DEFAULT nextval('public.base_partner_merge_automatic_wizard_id_seq'::regclass);


--
-- Name: base_partner_merge_line id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.base_partner_merge_line ALTER COLUMN id SET DEFAULT nextval('public.base_partner_merge_line_id_seq'::regclass);


--
-- Name: bus_bus id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.bus_bus ALTER COLUMN id SET DEFAULT nextval('public.bus_bus_id_seq'::regclass);


--
-- Name: bus_presence id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.bus_presence ALTER COLUMN id SET DEFAULT nextval('public.bus_presence_id_seq'::regclass);


--
-- Name: change_password_own id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.change_password_own ALTER COLUMN id SET DEFAULT nextval('public.change_password_own_id_seq'::regclass);


--
-- Name: change_password_user id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.change_password_user ALTER COLUMN id SET DEFAULT nextval('public.change_password_user_id_seq'::regclass);


--
-- Name: change_password_wizard id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.change_password_wizard ALTER COLUMN id SET DEFAULT nextval('public.change_password_wizard_id_seq'::regclass);


--
-- Name: decimal_precision id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.decimal_precision ALTER COLUMN id SET DEFAULT nextval('public.decimal_precision_id_seq'::regclass);


--
-- Name: iap_account id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.iap_account ALTER COLUMN id SET DEFAULT nextval('public.iap_account_id_seq'::regclass);


--
-- Name: iap_account_info id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.iap_account_info ALTER COLUMN id SET DEFAULT nextval('public.iap_account_info_id_seq'::regclass);


--
-- Name: ir_act_client id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_act_client ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_report_xml id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_act_report_xml ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_server id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_act_server ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_url id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_act_url ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_window id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_act_window ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_window_view id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_act_window_view ALTER COLUMN id SET DEFAULT nextval('public.ir_act_window_view_id_seq'::regclass);


--
-- Name: ir_actions id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_actions ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_actions_todo id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_actions_todo ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_todo_id_seq'::regclass);


--
-- Name: ir_asset id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_asset ALTER COLUMN id SET DEFAULT nextval('public.ir_asset_id_seq'::regclass);


--
-- Name: ir_attachment id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_attachment ALTER COLUMN id SET DEFAULT nextval('public.ir_attachment_id_seq'::regclass);


--
-- Name: ir_config_parameter id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_config_parameter ALTER COLUMN id SET DEFAULT nextval('public.ir_config_parameter_id_seq'::regclass);


--
-- Name: ir_cron id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_cron ALTER COLUMN id SET DEFAULT nextval('public.ir_cron_id_seq'::regclass);


--
-- Name: ir_cron_trigger id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_cron_trigger ALTER COLUMN id SET DEFAULT nextval('public.ir_cron_trigger_id_seq'::regclass);


--
-- Name: ir_default id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_default ALTER COLUMN id SET DEFAULT nextval('public.ir_default_id_seq'::regclass);


--
-- Name: ir_demo id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_demo ALTER COLUMN id SET DEFAULT nextval('public.ir_demo_id_seq'::regclass);


--
-- Name: ir_demo_failure id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_demo_failure ALTER COLUMN id SET DEFAULT nextval('public.ir_demo_failure_id_seq'::regclass);


--
-- Name: ir_demo_failure_wizard id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_demo_failure_wizard ALTER COLUMN id SET DEFAULT nextval('public.ir_demo_failure_wizard_id_seq'::regclass);


--
-- Name: ir_exports id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_exports ALTER COLUMN id SET DEFAULT nextval('public.ir_exports_id_seq'::regclass);


--
-- Name: ir_exports_line id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_exports_line ALTER COLUMN id SET DEFAULT nextval('public.ir_exports_line_id_seq'::regclass);


--
-- Name: ir_filters id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_filters ALTER COLUMN id SET DEFAULT nextval('public.ir_filters_id_seq'::regclass);


--
-- Name: ir_logging id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_logging ALTER COLUMN id SET DEFAULT nextval('public.ir_logging_id_seq'::regclass);


--
-- Name: ir_mail_server id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_mail_server ALTER COLUMN id SET DEFAULT nextval('public.ir_mail_server_id_seq'::regclass);


--
-- Name: ir_model id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_model ALTER COLUMN id SET DEFAULT nextval('public.ir_model_id_seq'::regclass);


--
-- Name: ir_model_access id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_model_access ALTER COLUMN id SET DEFAULT nextval('public.ir_model_access_id_seq'::regclass);


--
-- Name: ir_model_constraint id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_model_constraint ALTER COLUMN id SET DEFAULT nextval('public.ir_model_constraint_id_seq'::regclass);


--
-- Name: ir_model_data id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_model_data ALTER COLUMN id SET DEFAULT nextval('public.ir_model_data_id_seq'::regclass);


--
-- Name: ir_model_fields id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_model_fields ALTER COLUMN id SET DEFAULT nextval('public.ir_model_fields_id_seq'::regclass);


--
-- Name: ir_model_fields_selection id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_model_fields_selection ALTER COLUMN id SET DEFAULT nextval('public.ir_model_fields_selection_id_seq'::regclass);


--
-- Name: ir_model_inherit id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_model_inherit ALTER COLUMN id SET DEFAULT nextval('public.ir_model_inherit_id_seq'::regclass);


--
-- Name: ir_model_relation id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_model_relation ALTER COLUMN id SET DEFAULT nextval('public.ir_model_relation_id_seq'::regclass);


--
-- Name: ir_module_category id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_module_category ALTER COLUMN id SET DEFAULT nextval('public.ir_module_category_id_seq'::regclass);


--
-- Name: ir_module_module id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_module_module ALTER COLUMN id SET DEFAULT nextval('public.ir_module_module_id_seq'::regclass);


--
-- Name: ir_module_module_dependency id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_module_module_dependency ALTER COLUMN id SET DEFAULT nextval('public.ir_module_module_dependency_id_seq'::regclass);


--
-- Name: ir_module_module_exclusion id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_module_module_exclusion ALTER COLUMN id SET DEFAULT nextval('public.ir_module_module_exclusion_id_seq'::regclass);


--
-- Name: ir_profile id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_profile ALTER COLUMN id SET DEFAULT nextval('public.ir_profile_id_seq'::regclass);


--
-- Name: ir_property id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_property ALTER COLUMN id SET DEFAULT nextval('public.ir_property_id_seq'::regclass);


--
-- Name: ir_rule id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_rule ALTER COLUMN id SET DEFAULT nextval('public.ir_rule_id_seq'::regclass);


--
-- Name: ir_sequence id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_sequence ALTER COLUMN id SET DEFAULT nextval('public.ir_sequence_id_seq'::regclass);


--
-- Name: ir_sequence_date_range id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_sequence_date_range ALTER COLUMN id SET DEFAULT nextval('public.ir_sequence_date_range_id_seq'::regclass);


--
-- Name: ir_ui_menu id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_ui_menu ALTER COLUMN id SET DEFAULT nextval('public.ir_ui_menu_id_seq'::regclass);


--
-- Name: ir_ui_view id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_ui_view ALTER COLUMN id SET DEFAULT nextval('public.ir_ui_view_id_seq'::regclass);


--
-- Name: ir_ui_view_custom id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.ir_ui_view_custom ALTER COLUMN id SET DEFAULT nextval('public.ir_ui_view_custom_id_seq'::regclass);


--
-- Name: report_layout id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.report_layout ALTER COLUMN id SET DEFAULT nextval('public.report_layout_id_seq'::regclass);


--
-- Name: report_paperformat id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.report_paperformat ALTER COLUMN id SET DEFAULT nextval('public.report_paperformat_id_seq'::regclass);


--
-- Name: res_bank id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.res_bank ALTER COLUMN id SET DEFAULT nextval('public.res_bank_id_seq'::regclass);


--
-- Name: res_company id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.res_company ALTER COLUMN id SET DEFAULT nextval('public.res_company_id_seq'::regclass);


--
-- Name: res_config id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.res_config ALTER COLUMN id SET DEFAULT nextval('public.res_config_id_seq'::regclass);


--
-- Name: res_config_installer id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.res_config_installer ALTER COLUMN id SET DEFAULT nextval('public.res_config_installer_id_seq'::regclass);


--
-- Name: res_config_settings id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.res_config_settings ALTER COLUMN id SET DEFAULT nextval('public.res_config_settings_id_seq'::regclass);


--
-- Name: res_country id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.res_country ALTER COLUMN id SET DEFAULT nextval('public.res_country_id_seq'::regclass);


--
-- Name: res_country_group id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.res_country_group ALTER COLUMN id SET DEFAULT nextval('public.res_country_group_id_seq'::regclass);


--
-- Name: res_country_state id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.res_country_state ALTER COLUMN id SET DEFAULT nextval('public.res_country_state_id_seq'::regclass);


--
-- Name: res_currency id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.res_currency ALTER COLUMN id SET DEFAULT nextval('public.res_currency_id_seq'::regclass);


--
-- Name: res_currency_rate id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.res_currency_rate ALTER COLUMN id SET DEFAULT nextval('public.res_currency_rate_id_seq'::regclass);


--
-- Name: res_groups id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.res_groups ALTER COLUMN id SET DEFAULT nextval('public.res_groups_id_seq'::regclass);


--
-- Name: res_lang id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.res_lang ALTER COLUMN id SET DEFAULT nextval('public.res_lang_id_seq'::regclass);


--
-- Name: res_partner id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.res_partner ALTER COLUMN id SET DEFAULT nextval('public.res_partner_id_seq'::regclass);


--
-- Name: res_partner_bank id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.res_partner_bank ALTER COLUMN id SET DEFAULT nextval('public.res_partner_bank_id_seq'::regclass);


--
-- Name: res_partner_category id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.res_partner_category ALTER COLUMN id SET DEFAULT nextval('public.res_partner_category_id_seq'::regclass);


--
-- Name: res_partner_industry id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.res_partner_industry ALTER COLUMN id SET DEFAULT nextval('public.res_partner_industry_id_seq'::regclass);


--
-- Name: res_partner_title id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.res_partner_title ALTER COLUMN id SET DEFAULT nextval('public.res_partner_title_id_seq'::regclass);


--
-- Name: res_users id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.res_users ALTER COLUMN id SET DEFAULT nextval('public.res_users_id_seq'::regclass);


--
-- Name: res_users_apikeys id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.res_users_apikeys ALTER COLUMN id SET DEFAULT nextval('public.res_users_apikeys_id_seq'::regclass);


--
-- Name: res_users_apikeys_description id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.res_users_apikeys_description ALTER COLUMN id SET DEFAULT nextval('public.res_users_apikeys_description_id_seq'::regclass);


--
-- Name: res_users_deletion id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.res_users_deletion ALTER COLUMN id SET DEFAULT nextval('public.res_users_deletion_id_seq'::regclass);


--
-- Name: res_users_identitycheck id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.res_users_identitycheck ALTER COLUMN id SET DEFAULT nextval('public.res_users_identitycheck_id_seq'::regclass);


--
-- Name: res_users_log id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.res_users_log ALTER COLUMN id SET DEFAULT nextval('public.res_users_log_id_seq'::regclass);


--
-- Name: res_users_settings id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.res_users_settings ALTER COLUMN id SET DEFAULT nextval('public.res_users_settings_id_seq'::regclass);


--
-- Name: reset_view_arch_wizard id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.reset_view_arch_wizard ALTER COLUMN id SET DEFAULT nextval('public.reset_view_arch_wizard_id_seq'::regclass);


--
-- Name: web_editor_converter_test id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.web_editor_converter_test ALTER COLUMN id SET DEFAULT nextval('public.web_editor_converter_test_id_seq'::regclass);


--
-- Name: web_editor_converter_test_sub id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.web_editor_converter_test_sub ALTER COLUMN id SET DEFAULT nextval('public.web_editor_converter_test_sub_id_seq'::regclass);


--
-- Name: web_tour_tour id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.web_tour_tour ALTER COLUMN id SET DEFAULT nextval('public.web_tour_tour_id_seq'::regclass);


--
-- Name: wizard_ir_model_menu_create id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.wizard_ir_model_menu_create ALTER COLUMN id SET DEFAULT nextval('public.wizard_ir_model_menu_create_id_seq'::regclass);


--
-- Data for Name: auth_totp_device; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.auth_totp_device (id, name, user_id, scope, index, key, create_date) FROM stdin;
\.


--
-- Data for Name: auth_totp_wizard; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.auth_totp_wizard (id, user_id, create_uid, write_uid, secret, url, code, create_date, write_date, qrcode) FROM stdin;
\.


--
-- Data for Name: base_document_layout; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.base_document_layout (id, company_id, report_layout_id, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_enable_profiling_wizard; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.base_enable_profiling_wizard (id, create_uid, write_uid, duration, expiration, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_import; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.base_import_import (id, create_uid, write_uid, res_model, file_name, file_type, create_date, write_date, file) FROM stdin;
\.


--
-- Data for Name: base_import_mapping; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.base_import_mapping (id, create_uid, write_uid, res_model, column_name, field_name, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_module; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.base_import_module (id, create_uid, write_uid, state, import_message, modules_dependencies, force, with_demo, create_date, write_date, module_file) FROM stdin;
\.


--
-- Data for Name: base_language_export; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.base_language_export (id, model_id, create_uid, write_uid, name, lang, format, export_type, domain, state, create_date, write_date, data) FROM stdin;
\.


--
-- Data for Name: base_language_import; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.base_language_import (id, create_uid, write_uid, name, code, filename, overwrite, create_date, write_date, data) FROM stdin;
\.


--
-- Data for Name: base_language_install; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.base_language_install (id, create_uid, write_uid, overwrite, create_date, write_date) FROM stdin;
1	1	1	t	2024-01-07 05:20:57.526545	2024-01-07 05:20:57.526545
\.


--
-- Data for Name: base_module_uninstall; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.base_module_uninstall (id, module_id, create_uid, write_uid, show_all, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_module_update; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.base_module_update (id, updated, added, create_uid, write_uid, state, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_module_upgrade; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.base_module_upgrade (id, create_uid, write_uid, module_info, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_partner_merge_automatic_wizard; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.base_partner_merge_automatic_wizard (id, number_group, current_line_id, dst_partner_id, maximum_group, create_uid, write_uid, state, group_by_email, group_by_name, group_by_is_company, group_by_vat, group_by_parent_id, exclude_contact, exclude_journal_item, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_partner_merge_automatic_wizard_res_partner_rel; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.base_partner_merge_automatic_wizard_res_partner_rel (base_partner_merge_automatic_wizard_id, res_partner_id) FROM stdin;
\.


--
-- Data for Name: base_partner_merge_line; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.base_partner_merge_line (id, wizard_id, min_id, create_uid, write_uid, aggr_ids, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: bus_bus; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.bus_bus (id, create_uid, write_uid, channel, message, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: bus_presence; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.bus_presence (id, user_id, status, last_poll, last_presence) FROM stdin;
\.


--
-- Data for Name: change_password_own; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.change_password_own (id, create_uid, write_uid, new_password, confirm_password, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: change_password_user; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.change_password_user (id, wizard_id, user_id, create_uid, write_uid, user_login, new_passwd, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: change_password_wizard; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.change_password_wizard (id, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: decimal_precision; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.decimal_precision (id, digits, create_uid, write_uid, name, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: iap_account; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.iap_account (id, create_uid, write_uid, name, service_name, account_token, show_token, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: iap_account_info; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.iap_account_info (id, account_id, create_uid, write_uid, account_token, account_uuid_hashed, service_name, description, warning_email, unit_name, balance, warn_me, create_date, write_date, warning_threshold) FROM stdin;
\.


--
-- Data for Name: iap_account_res_company_rel; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.iap_account_res_company_rel (iap_account_id, res_company_id) FROM stdin;
\.


--
-- Data for Name: ir_act_client; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.ir_act_client (id, binding_model_id, create_uid, write_uid, type, binding_type, binding_view_types, name, help, create_date, write_date, tag, target, res_model, context, params_store) FROM stdin;
2	\N	1	1	ir.actions.client	action	list,form	{"en_US": "Open Settings Menu"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	reload	current	\N	{}	\\x7b276d656e755f6964273a20317d
\.


--
-- Data for Name: ir_act_report_xml; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.ir_act_report_xml (id, binding_model_id, create_uid, write_uid, type, binding_type, binding_view_types, name, help, create_date, write_date, paperformat_id, model, report_type, report_name, report_file, attachment, print_report_name, multi, attachment_use) FROM stdin;
36	3	1	1	ir.actions.report	report	list,form	{"en_US": "Model Overview"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	ir.model	qweb-pdf	base.report_irmodeloverview	base.report_irmodeloverview	\N	\N	\N	\N
41	66	1	1	ir.actions.report	report	list,form	{"en_US": "Technical guide"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	ir.module.module	qweb-pdf	base.report_irmodulereference	base.report_irmodulereference	\N	\N	\N	\N
77	94	1	1	ir.actions.report	report	list,form	{"en_US": "Preview Internal Report"}	\N	2024-01-07 05:20:57.526545	2024-01-07 05:20:57.526545	\N	res.company	qweb-pdf	web.preview_internalreport	web.preview_internalreport	\N	\N	\N	\N
78	94	1	1	ir.actions.report	report	list,form	{"en_US": "Preview External Report"}	\N	2024-01-07 05:20:57.526545	2024-01-07 05:20:57.526545	\N	res.company	qweb-pdf	web.preview_externalreport	web.preview_externalreport	\N	\N	\N	\N
79	94	1	1	ir.actions.report	report	list,form	{"en_US": "Report Layout Preview"}	\N	2024-01-07 05:20:57.526545	2024-01-07 05:20:57.526545	\N	res.company	qweb-pdf	web.preview_layout_report	web.preview_layout_report	\N	\N	\N	\N
\.


--
-- Data for Name: ir_act_server; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.ir_act_server (id, binding_model_id, create_uid, write_uid, type, binding_type, binding_view_types, name, help, create_date, write_date, sequence, model_id, crud_model_id, link_field_id, update_field_id, update_related_model_id, selection_value, usage, state, model_name, update_path, update_m2m_operation, update_boolean_value, evaluation_type, resource_ref, webhook_url, code, value) FROM stdin;
11	\N	1	1	ir.actions.server	action	list,form	{"en_US": "Config: Run Remaining Action Todo"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	5	89	\N	\N	\N	\N	\N	ir_actions_server	code	res.config	\N	add	true	value	\N	\N	\nconfig = model.next() or {}\nif config.get('type') not in ('ir.actions.act_window_close',):\n    action = config\n	\N
34	\N	1	1	ir.actions.server	action	list,form	{"en_US": "Base: Auto-vacuum internal data"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	5	38	\N	\N	\N	\N	\N	ir_cron	code	ir.autovacuum	\N	add	true	value	\N	\N	model._run_vacuum_cleaner()	\N
35	\N	1	1	ir.actions.server	action	list,form	{"en_US": "Base: Portal Users Deletion"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	5	106	\N	\N	\N	\N	\N	ir_cron	code	res.users.deletion	\N	add	true	value	\N	\N	model._gc_portal_users()	\N
50	\N	1	1	ir.actions.server	action	list,form	{"en_US": "Failed to install demo data for some modules, demo disabled"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	5	71	\N	\N	\N	\N	\N	ir_actions_server	code	ir.demo_failure.wizard	\N	add	true	value	\N	\N	\nfailures = env['ir.demo_failure'].search([\n    ('wizard_id', '=', False),\n])\nrecord = model.create({\n    'failure_ids': [Command.set(failures.ids)],\n})\naction = {\n    'type': 'ir.actions.act_window',\n    'res_id': record.id,\n    'res_model': 'ir.demo_failure.wizard',\n    'target': 'new',\n    'views': [(env.ref('base.demo_failures_dialog').id, 'form')],\n}\n        	\N
81	85	1	1	ir.actions.server	action	form,list	{"en_US": "Download (vCard)"}	\N	2024-01-07 05:20:57.526545	2024-01-07 05:20:57.526545	5	85	\N	\N	\N	\N	\N	ir_actions_server	code	res.partner	\N	add	true	value	\N	\N	\n            action = {\n                'type': 'ir.actions.act_url',\n                'url': '/web/partner/vcard?partner_ids=' + ','.join(map(str, records.ids)),\n                'target': 'download',\n            }\n        	\N
82	97	1	1	ir.actions.server	action	list,form	{"en_US": "Disable two-factor authentication"}	\N	2024-01-07 05:21:10.845793	2024-01-07 05:21:10.845793	5	97	\N	\N	\N	\N	\N	ir_actions_server	code	res.users	\N	add	true	value	\N	\N	\n            action = records.action_totp_disable()\n        	\N
\.


--
-- Data for Name: ir_act_server_group_rel; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.ir_act_server_group_rel (act_id, gid) FROM stdin;
82	2
\.


--
-- Data for Name: ir_act_server_webhook_field_rel; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.ir_act_server_webhook_field_rel (server_id, field_id) FROM stdin;
\.


--
-- Data for Name: ir_act_url; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.ir_act_url (id, binding_model_id, create_uid, write_uid, type, binding_type, binding_view_types, name, help, create_date, write_date, target, url) FROM stdin;
3	\N	1	1	ir.actions.act_url	action	list,form	{"en_US": "Home Menu"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	self	/web
39	\N	1	1	ir.actions.act_url	action	list,form	{"en_US": "Third-Party Apps"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	new	https://apps.odoo.com/apps/modules
40	\N	1	1	ir.actions.act_url	action	list,form	{"en_US": "Theme Store"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	new	https://apps.odoo.com/apps/themes
\.


--
-- Data for Name: ir_act_window; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.ir_act_window (id, binding_model_id, create_uid, write_uid, type, binding_type, binding_view_types, name, help, create_date, write_date, view_id, res_id, "limit", search_view_id, domain, context, res_model, target, view_mode, mobile_view_mode, usage, filter) FROM stdin;
1	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Load demo data"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	\N	80	\N	\N	{}	ir.demo	new	form	kanban	\N	\N
4	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Decimal Accuracy"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	\N	80	\N	\N	{}	decimal.precision	current	tree,form	kanban	\N	\N
5	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Actions"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	7	\N	80	8	\N	{}	ir.actions.actions	current	tree,form	kanban	\N	\N
6	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Reports"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	10	\N	80	11	\N	{}	ir.actions.report	current	tree,form	kanban	\N	\N
7	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Window Actions"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	\N	80	15	\N	{}	ir.actions.act_window	current	tree,form	kanban	\N	\N
8	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Client Actions"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	16	\N	80	\N	\N	{}	ir.actions.client	current	tree,form	kanban	\N	\N
9	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Server Actions"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	18	\N	80	19	\N	{'key':'server_action'}	ir.actions.server	current	tree,form	kanban	\N	\N
10	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Configuration Wizards"}	{"en_US": "<p>The configuration wizards are used to help you configure a new instance of Odoo. They are launched during the installation of new modules, but you can choose to restart some wizards manually from this menu.</p>"}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	20	\N	80	\N	\N	{}	ir.actions.todo	current	tree,form	kanban	\N	\N
12	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Assets"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	24	\N	80	\N	\N	{'search_default_active': 1}	ir.asset	current	tree,form	kanban	\N	\N
13	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "System Parameters"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	\N	80	\N	\N	{}	ir.config_parameter	current	tree,form	kanban	\N	\N
14	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Scheduled Actions"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	30	\N	80	\N	\N	{'search_default_all': 1}	ir.cron	current	tree,form,calendar	kanban	\N	\N
15	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Scheduled Actions Triggers"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	\N	80	\N	\N	{}	ir.cron.trigger	current	tree,form	kanban	\N	\N
16	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "User-defined Filters"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	\N	80	\N	\N	{}	ir.filters	current	tree,form	kanban	\N	\N
17	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Outgoing Mail Servers"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	40	\N	80	41	\N	{}	ir.mail_server	current	tree,form	kanban	\N	\N
18	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Create Menu"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	\N	80	\N	\N	{'model_id': active_id}	wizard.ir.model.menu.create	new	form	kanban	\N	\N
19	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Models"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	44	\N	80	\N	\N	{}	ir.model	current	tree,form	kanban	\N	\N
20	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Fields"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	47	\N	80	\N	\N	{}	ir.model.fields	current	tree,form	kanban	\N	\N
21	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Fields Selection"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	50	\N	80	\N	\N	{}	ir.model.fields.selection	current	tree,form	kanban	\N	\N
22	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "External Identifiers"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	53	\N	80	\N	\N	{}	ir.model.data	current	tree,form	kanban	\N	\N
23	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Model Constraints"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	56	\N	80	57	\N	{}	ir.model.constraint	current	tree,form	kanban	\N	\N
24	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "ManyToMany Relations"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	59	\N	80	\N	\N	{}	ir.model.relation	current	tree,form	kanban	\N	\N
25	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Access Rights"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	61	\N	80	63	\N	{}	ir.model.access	current	tree,form	kanban	\N	\N
26	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Attachments"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    Create a new document\\n                </p>\\n                <p>\\n                    Also you will find here all the related documents and download it by clicking on any individual document.\\n                </p>\\n            "}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	\N	80	66	\N	{}	ir.attachment	current	tree,form	kanban	\N	\N
27	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Record Rules"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	68	\N	80	69	\N	{}	ir.rule	current	tree,form	kanban	\N	\N
28	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Sequences"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	71	\N	80	\N	\N	{'active_test': False}	ir.sequence	current	tree,form	kanban	\N	\N
29	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Menu Items"}	{"en_US": "<p>Manage and customize the items available and displayed in your Odoo system menu. You can delete an item by clicking on the box at the beginning of each line and then delete it through the button that appeared. Items can be assigned to specific groups in order to make them accessible to some users within the system.</p>"}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	74	\N	80	75	\N	{'ir.ui.menu.full_list':True}	ir.ui.menu	current	tree,form	kanban	\N	\N
30	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Views"}	{"en_US": "<p>Views allows you to personalize each view of Odoo. You can add new fields, move fields, rename them or delete the ones that you do not need.</p>"}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	77	\N	80	\N	\N	{'search_default_active': 1}	ir.ui.view	current	tree,form	kanban	\N	\N
31	16	1	1	ir.actions.act_window	action	form,list	{"en_US": "Compare/Reset"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	\N	80	\N	\N	{}	reset.view.arch.wizard	new	form	kanban	\N	\N
32	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Customized Views"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">Create a customized view</p><p>Customized views are used when users reorganize the content of their dashboard views (via web client)</p>"}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	\N	80	\N	\N	{}	ir.ui.view.custom	current	tree,form	kanban	\N	\N
33	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "User-defined Defaults"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	\N	80	85	\N	{}	ir.default	current	tree,form	kanban	\N	\N
37	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Logging"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	\N	80	89	\N	{}	ir.logging	current	tree,form	kanban	\N	\N
38	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Apps"}	{"en_US": "<p class=\\"o_view_nocontent_empty_folder\\">\\n                No module found!\\n              </p><p>\\n                You should try other search criteria.\\n              </p>\\n            "}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	\N	80	94	\N	{'search_default_app':1}	ir.module.module	current	kanban,tree,form	kanban	\N	\N
42	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Module Update"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	\N	80	\N	\N	{}	base.module.update	new	form	kanban	\N	\N
43	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Add Languages"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	\N	80	\N	\N	{}	base.language.install	new	form	kanban	\N	\N
44	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Import Translation"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	\N	80	\N	\N	{}	base.language.import	new	form	kanban	\N	\N
45	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Apply Schedule Upgrade"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	\N	80	\N	\N	{}	base.module.upgrade	new	form	kanban	\N	\N
46	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Module Upgrade Install"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	104	\N	80	\N	\N	{}	base.module.upgrade	new	form	kanban	\N	\N
47	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Export Translation"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	\N	80	\N	\N	{}	base.language.export	new	form	kanban	\N	\N
48	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Deduplicate Contacts"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	\N	80	\N	\N	{'active_test': False}	base.partner.merge.automatic.wizard	new	form	kanban	\N	\N
49	85	1	1	ir.actions.act_window	action	list	{"en_US": "Merge"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	\N	80	\N	\N	{}	base.partner.merge.automatic.wizard	new	form	kanban	\N	\N
51	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Ir profile"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	\N	80	\N	\N	{'search_default_group_session': 1}	ir.profile	current	tree,form	kanban	\N	\N
52	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Companies"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a new company\\n              </p><p>\\n                Create and manage the companies that will be managed by Odoo from here. Shops or subsidiaries can be created and maintained from here.\\n              </p>\\n            "}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	\N	80	\N	[('parent_id', '=', False)]	{}	res.company	current	tree,kanban,form	kanban	\N	\N
53	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Languages"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	\N	80	119	\N	{'active_test': False}	res.lang	current	tree,form	kanban	\N	\N
54	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Contact Titles"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    Create a Title\\n                </p><p>\\n                    Manage Contact Titles as well as their abbreviations (e.g. \\"Mr.\\", \\"Mrs.\\", etc).\\n                </p>\\n            "}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	\N	80	\N	[]	{}	res.partner.title	current	tree,form	kanban	\N	\N
55	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Customers"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a Contact in your address book\\n              </p><p>\\n                Odoo helps you track all activities related to your contacts.\\n              </p>\\n            "}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	\N	80	127	\N	{'res_partner_search_mode': 'customer'}	res.partner	current	kanban,tree,form	kanban	\N	\N
56	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Customers"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a new customer in your address book\\n              </p><p>\\n                Odoo helps you easily track all activities related to a customer.\\n              </p>\\n            "}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	\N	80	\N	[]	{'res_partner_search_mode': 'customer', 'default_is_company': True}	res.partner	current	kanban,tree,form	kanban	\N	t
57	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Vendors"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a new vendor in your address book\\n              </p><p>\\n                Odoo helps you easily track all activities related to a vendor.\\n              </p>\\n            "}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	\N	80	\N	[]	{'res_partner_search_mode': 'supplier', 'default_is_company': True}	res.partner	current	kanban,tree,form	kanban	\N	t
58	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Contact Tags"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a Contact Tag\\n              </p><p>\\n                Assign tags to your contacts to organize, filter and track them.\\n              </p>\\n            "}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	\N	80	131	\N	{}	res.partner.category	current	tree,form	kanban	\N	\N
59	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Industries"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create an Industry\\n              </p><p>\\n                Specify industries to classify your contacts and draw up reports.\\n              </p>\\n            "}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	\N	80	134	\N	{}	res.partner.industry	current	tree,form	kanban	\N	\N
60	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Banks"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a Bank\\n              </p><p>\\n                Banks are the financial institutions at which you and your contacts have their accounts.\\n              </p>\\n            "}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	\N	80	137	\N	{}	res.bank	current	tree,form	kanban	\N	\N
61	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Bank Accounts"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a Bank Account\\n              </p><p>\\n                From here you can manage all bank accounts linked to you and your contacts.\\n              </p>\\n            "}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	\N	80	\N	\N	{}	res.partner.bank	current	tree,form	kanban	\N	\N
62	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Countries"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    No Country Found!\\n                </p><p>\\n                    Manage the list of countries that can be set on your contacts.\\n                </p>\\n            "}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	\N	80	\N	\N	{}	res.country	current	tree,form	kanban	\N	\N
63	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Country Group"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    Create a Country Group\\n                </p><p>\\n                    Use groups to organize countries that are frequently selected together (e.g. \\"LATAM\\", \\"BeNeLux\\", \\"ASEAN\\").\\n                </p>\\n            "}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	\N	80	\N	\N	{}	res.country.group	current	tree,form	kanban	\N	\N
64	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Fed. States"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    Create a State\\n                </p><p>\\n                    Federal States belong to countries and are part of your contacts' addresses.\\n                </p>\\n            "}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	146	\N	80	\N	\N	{}	res.country.state	current	tree,form	kanban	\N	\N
65	92	1	1	ir.actions.act_window	action	form	{"en_US": "Show Currency Rates"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	150	\N	80	\N	[('currency_id','=', active_id)]	{'default_currency_id': active_id}	res.currency.rate	current	tree,form	kanban	\N	\N
66	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Currencies"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	\N	80	152	\N	{'active_test': False}	res.currency	current	tree,kanban,form	kanban	\N	\N
67	97	1	1	ir.actions.act_window	action	list,form	{"en_US": "Change Password"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	\N	80	\N	\N	{}	change.password.wizard	new	form	kanban	\N	\N
68	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Groups"}	{"en_US": "<p>A group is a set of functional areas that will be assigned to the user in order to give them access and rights to specific applications and tasks in the system. You can create custom groups or edit the ones existing by default in order to customize the view of the menu that users will be able to see. Whether they can have a read, write, create and delete access right can be managed from here.</p>"}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	\N	80	\N	\N	{'search_default_filter_no_share': 1}	res.groups	current	tree,form	kanban	\N	\N
69	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Users"}	{"en_US": "<p>Create and manage users that will connect to the system. Users can be deactivated should there be a period of time during which they will/should not connect to the system. You can assign them groups in order to give them specific access to the applications they need to use in the system.</p>"}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	163	\N	80	165	\N	{'search_default_filter_no_share': 1, 'show_user_group_warning': True}	res.users	current	tree,kanban,form	kanban	\N	\N
70	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "API Key: description input wizard"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	\N	80	\N	\N	{}	res.users.apikeys.description	new	form	kanban	\N	\N
71	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Change My Preferences"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	\N	80	\N	\N	{}	res.users	new	form	kanban	\N	\N
72	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "API Keys Listing"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	170	\N	80	\N	\N	{}	res.users.apikeys	current	tree	kanban	\N	\N
73	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Company Properties"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	175	\N	80	\N	\N	{}	ir.property	current	tree,form	kanban	\N	\N
74	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Settings"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	\N	80	\N	\N	{}	res.config.settings	inline	form	kanban	\N	\N
75	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Paper Format General Configuration"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	\N	80	\N	\N	{}	report.paperformat	current	tree,form	kanban	\N	\N
76	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Reports"}	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	\N	80	\N	\N	{}	ir.actions.report	current	tree,form	kanban	\N	\N
80	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Configure your document layout"}	\N	2024-01-07 05:20:57.526545	2024-01-07 05:20:57.526545	210	\N	80	\N	\N	{}	base.document.layout	new	form	kanban	\N	\N
83	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Import Module"}	\N	2024-01-07 05:21:24.595842	2024-01-07 05:21:24.595842	\N	\N	80	\N	\N	{}	base.import.module	new	form	kanban	\N	\N
84	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Settings"}	\N	2024-01-07 05:21:27.729604	2024-01-07 05:21:27.729604	\N	\N	80	\N	\N	{'module' : 'general_settings', 'bin_size': False}	res.config.settings	inline	form	kanban	\N	\N
85	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Tours"}	\N	2024-01-07 05:21:31.348048	2024-01-07 05:21:31.348048	226	\N	80	227	\N	{}	web_tour.tour	current	tree,form	kanban	\N	\N
86	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "IAP Account"}	\N	2024-01-07 05:21:33.025685	2024-01-07 05:21:33.025685	\N	\N	80	\N	\N	{}	iap.account	current	tree,form	kanban	\N	\N
\.


--
-- Data for Name: ir_act_window_group_rel; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.ir_act_window_group_rel (act_id, gid) FROM stdin;
72	4
\.


--
-- Data for Name: ir_act_window_view; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.ir_act_window_view (id, sequence, view_id, act_window_id, create_uid, write_uid, view_mode, multi, create_date, write_date) FROM stdin;
1	1	13	7	1	1	tree	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
2	2	14	7	1	1	form	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
3	0	128	55	1	1	kanban	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
4	2	125	55	1	1	form	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
5	1	122	55	1	1	tree	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
6	1	128	56	1	1	kanban	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
7	2	122	56	1	1	tree	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
8	3	125	56	1	1	form	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
9	1	128	57	1	1	kanban	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
10	2	122	57	1	1	tree	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
11	3	125	57	1	1	form	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
12	10	163	69	1	1	tree	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
13	20	162	69	1	1	form	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
14	10	169	71	1	1	form	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
\.


--
-- Data for Name: ir_actions; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.ir_actions (id, binding_model_id, create_uid, write_uid, type, binding_type, binding_view_types, name, help, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_actions_todo; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.ir_actions_todo (id, action_id, sequence, create_uid, write_uid, state, name, create_date, write_date) FROM stdin;
1	2	100	1	1	done	Open Menu	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
2	50	1	1	1	done	Demo Failure Notification	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
\.


--
-- Data for Name: ir_asset; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.ir_asset (id, sequence, create_uid, write_uid, name, bundle, directive, path, target, active, create_date, write_date) FROM stdin;
1	16	1	1	13 0 color system support primary variables SCSS	web._assets_primary_variables	append	web_editor/static/src/scss/13_0_color_system_support_primary_variables.scss	\N	f	2024-01-07 05:21:36.556385	2024-01-07 05:21:36.556385
\.


--
-- Data for Name: ir_attachment; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.ir_attachment (id, res_id, company_id, file_size, create_uid, write_uid, name, res_model, res_field, type, url, access_token, store_fname, checksum, mimetype, description, index_content, public, create_date, write_date, db_datas, original_id) FROM stdin;
1	3	1	23980	1	1	flag_image	res.lang	flag_image	binary	\N	\N	fd/fdffc45cba0e31dd34423b54f06fd48e9824192c	fdffc45cba0e31dd34423b54f06fd48e9824192c	image/png	\N	image	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	\N
2	64	1	15497	1	1	flag_image	res.lang	flag_image	binary	\N	\N	4d/4df107d37b0e444ee9fdf7f6c2dd4231c4c60e49	4df107d37b0e444ee9fdf7f6c2dd4231c4c60e49	image/png	\N	image	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	\N
3	1	1	15310	1	1	image_1920	res.partner	image_1920	binary	\N	\N	d5/d5cce68bf4bb4ab57beaf766f3fb775cf8df0c83	d5cce68bf4bb4ab57beaf766f3fb775cf8df0c83	image/png	\N	image	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	\N
4	1	1	15310	1	1	image_1024	res.partner	image_1024	binary	\N	\N	d5/d5cce68bf4bb4ab57beaf766f3fb775cf8df0c83	d5cce68bf4bb4ab57beaf766f3fb775cf8df0c83	image/png	\N	image	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	\N
5	1	1	15310	1	1	image_512	res.partner	image_512	binary	\N	\N	d5/d5cce68bf4bb4ab57beaf766f3fb775cf8df0c83	d5cce68bf4bb4ab57beaf766f3fb775cf8df0c83	image/png	\N	image	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	\N
6	1	1	12509	1	1	image_256	res.partner	image_256	binary	\N	\N	77/7712910ea66effcd74ee140f5d145fe30000aa57	7712910ea66effcd74ee140f5d145fe30000aa57	image/png	\N	image	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	\N
7	1	1	5421	1	1	image_128	res.partner	image_128	binary	\N	\N	e0/e0d4b5b2f41d6a523b47d17100558bf3084c67b1	e0d4b5b2f41d6a523b47d17100558bf3084c67b1	image/png	\N	image	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	\N
8	1	1	2063	1	1	web_icon_data	ir.ui.menu	web_icon_data	binary	\N	\N	b7/b73a9deb85def8a1a00e4d545c4f79747d78f487	b73a9deb85def8a1a00e4d545c4f79747d78f487	image/png	\N	image	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	\N
9	15	1	2282	1	1	web_icon_data	ir.ui.menu	web_icon_data	binary	\N	\N	3d/3d7a7360fe4a73a90dd3b4ba554a9254ed61e864	3d7a7360fe4a73a90dd3b4ba554a9254ed61e864	image/png	\N	image	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	\N
10	16	1	4667	1	1	web_icon_data	ir.ui.menu	web_icon_data	binary	\N	\N	1c/1c2a8239bc7e06429116c40bc1d1334c621ca379	1c2a8239bc7e06429116c40bc1d1334c621ca379	image/png	\N	image	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	\N
11	\N	1	\N	1	1	placeholder.png	\N	\N	url	/web/static/img/placeholder.png	\N	\N	\N	image/png	\N	\N	t	2024-01-07 05:20:57.526545	2024-01-07 05:20:57.526545	\N	\N
12	\N	1	702	1	1	res.company.scss	\N	\N	binary	web/static/asset_styles_company_report.scss	\N	b1/b1625102d5ee020412d2d01015690c7778c38a8a	b1625102d5ee020412d2d01015690c7778c38a8a	text/scss	\N	                .o_company_1_layout {\n                font-family: Lato;\n                &.o_report_layout_standard {\n                    h2 {\n                        color: black;\n                    }\n                    #informations strong {\n                        color: black;\n                    }\n                    #total strong{\n                        color: black;\n                    }\n                    .totals_taxes_company_currency strong{\n                        color: black;\n                    }\n                    table {\n                        thead {\n                            color: black;\n                        }\n                    }\n                }\n            }	\N	2024-01-07 05:20:57.526545	2024-01-07 05:20:57.526545	\N	\N
13	0	1	8011	1	1	web.assets_frontend_minimal.min.js	ir.ui.view	\N	binary	/web/assets/695f68d/web.assets_frontend_minimal.min.js	\N	1f/1f89e5f9d4fd483c52bb5dcee9d13ec018d71d08	1f89e5f9d4fd483c52bb5dcee9d13ec018d71d08	application/javascript	\N	application	t	2024-01-07 05:21:53.886323	2024-01-07 05:21:53.886323	\N	\N
14	0	1	487224	1	1	web.assets_frontend.min.css	ir.ui.view	\N	binary	/web/assets/11aa15c/web.assets_frontend.min.css	\N	d4/d47ede3a3c94c57531c0a4eab91099b429febd55	d47ede3a3c94c57531c0a4eab91099b429febd55	text/css	\N	/* <inline asset> */\n@charset "UTF-8"; \n/* /web/static/lib/bootstrap/scss/_functions.scss */\n/* /web/static/lib/bootstrap/scss/_mixins.scss */\n/* /web/static/src/scss/functions.scss */\n/* /web/static/src/scss/mixins_forwardport.scss */\n/* /web/static/src/scss/bs_mixins_overrides.scss */\n .o_cc5 h1, .o_colored_level .o_cc5 h1, .o_cc4 h1, .o_colored_level .o_cc4 h1, .o_cc3 h1, .o_colored_level .o_cc3 h1, .o_cc2 h1, .o_colored_level .o_cc2 h1, .o_cc1 h1, .o_colored_level .o_cc1 h1, .bg-o-color-5 h1, .o_colored_level .bg-o-color-5 h1, .bg-o-color-4 h1, .o_colored_level .bg-o-color-4 h1, .bg-o-color-3 h1, .o_colored_level .bg-o-color-3 h1, .bg-o-color-2 h1, .o_colored_level .bg-o-color-2 h1, .bg-o-color-1 h1, .o_colored_level .bg-o-color-1 h1, .bg-white h1, .o_colored_level .bg-white h1, .bg-black h1, .o_colored_level .bg-black h1, .bg-black-50 h1, .o_colored_level .bg-black-50 h1, .bg-black-75 h1, .o_colored_level .bg-black-75 h1, .bg-white-50 h1, .o_colored_level .bg-white-50 h1, .bg-white-75 h1, .o_colored_level .bg-white-75 h1, .bg-white-85 h1, .o_colored_level .bg-white-85 h1, .bg-900 h1, .o_colored_level .bg-900 h1, .bg-800 h1, .o_colored_level .bg-800 h1, .bg-700 h1, .o_colored_level .bg-700 h1, .bg-600 h1, .o_colored_level .bg-600 h1, .bg-500 h1, .o_colored_level .bg-500 h1, .bg-400 h1, .o_colored_level .bg-400 h1, .bg-300 h1, .o_colored_level .bg-300 h1, .bg-200 h1, .o_colored_level .bg-200 h1, .bg-100 h1, .o_colored_level .bg-100 h1, .toast-body h1, .o_colored_level .toast-body h1, .card-body h1, .o_colored_level .card-body h1, .o_cc5 .h1, .o_colored_level .o_cc5 .h1, .o_cc4 .h1, .o_colored_level .o_cc4 .h1, .o_cc3 .h1, .o_colored_level .o_cc3 .h1, .o_cc2 .h1, .o_colored_level .o_cc2 .h1, .o_cc1 .h1, .o_colored_level .o_cc1 .h1, .bg-o-color-5 .h1, .o_colored_level .bg-o-color-5 .h1, .bg-o-color-4 .h1, .o_colored_level .bg-o-color-4 .h1, .bg-o-color-3 .h1, .o_colored_level .bg-o-color-3 .h1, .bg-o-color-2 .h1, .o_colored_level .bg-o-color-2 .h1, .bg-o-color-1 .h1, .o_colored_level .bg-o-color-1 .h1, .bg-white .h1, .o_colored_level .bg-white .h1, .bg-black .h1, .o_colored_level .bg-black .h1, .bg-black-50 .h1, .o_colored_level .bg-black-50 .h1, .bg-black-75 .h1, .o_colored_level .bg-black-75 .h1, .bg-white-50 .h1, .o_colored_level .bg-white-50 .h1, .bg-white-75 .h1, .o_colored_level .bg-white-75 .h1, .bg-white-85 .h1, .o_colored_level .bg-white-85 .h1, .bg-900 .h1, .o_colored_level .bg-900 .h1, .bg-800 .h1, .o_colored_level .bg-800 .h1, .bg-700 .h1, .o_colored_level .bg-700 .h1, .bg-600 .h1, .o_colored_level .bg-600 .h1, .bg-500 .h1, .o_colored_level .bg-500 .h1, .bg-400 .h1, .o_colored_level .bg-400 .h1, .bg-300 .h1, .o_colored_level .bg-300 .h1, .bg-200 .h1, .bg-100 .h1, .toast-body .h1, .card-body .h1, .o_cc5 h2, .o_colored_level .o_cc5 h2, .o_cc4 h2, .o_colored_level .o_cc4 h2, .o_cc3 h2, .o_colored_level .o_cc3 h2, .o_cc2 h2, .o_colored_level .o_cc2 h2, .o_cc1 h2, .o_colored_level .o_cc1 h2, .bg-o-color-5 h2, .o_colored_level .bg-o-color-5 h2, .bg-o-color-4 h2, .o_colored_level .bg-o-color-4 h2, .bg-o-color-3 h2, .o_colored_level .bg-o-color-3 h2, .bg-o-color-2 h2, .o_colored_level .bg-o-color-2 h2, .bg-o-color-1 h2, .o_colored_level .bg-o-color-1 h2, .bg-white h2, .o_colored_level .bg-white h2, .bg-black h2, .o_colored_level .bg-black h2, .bg-black-50 h2, .o_colored_level .bg-black-50 h2, .bg-black-75 h2, .o_colored_level .bg-black-75 h2, .bg-white-50 h2, .o_colored_level .bg-white-50 h2, .bg-white-75 h2, .o_colored_level .bg-white-75 h2, .bg-white-85 h2, .o_colored_level .bg-white-85 h2, .bg-900 h2, .o_colored_level .bg-900 h2, .bg-800 h2, .o_colored_level .bg-800 h2, .bg-700 h2, .o_colored_level .bg-700 h2, .bg-600 h2, .o_colored_level .bg-600 h2, .bg-500 h2, .o_colored_level .bg-500 h2, .bg-400 h2, .o_colored_level .bg-400 h2, .bg-300 h2, .o_colored_level .bg-300 h2, .bg-200 h2, .o_colored_level .bg-200 h2, .bg-100 h2, .o_colored_level .bg-100 h2, .toast-body h2, .o_colored_level .toast-body h2, .card-body h2, .o_colored_level .card-body h2, .o_cc5 .h2, .o_colored_level .o_cc5 .h2, .o_cc4 .h2, .o_colored_level .o_cc4 .h2, .o_cc3 .h2, .o_colored_level .o_cc3 .h2, .o_cc2 .h2, .o_colored_level .o_cc2 .h2, .o_cc1 .h2, .o_colored_level .o_cc1 .h2, .bg-o-color-5 .h2, .o_colored_level .bg-o-color-5 .h2, .bg-o-color-4 .h2, .o_colored_level .bg-o-color-4 .h2, .bg-o-color-3 .h2, .o_colored_level .bg-o-color-3 .h2, .bg-o-color-2 .h2, .o_colored_level .bg-o-color-2 .h2, .bg-o-color-1 .h2, .o_colored_level .bg-o-color-1 .h2, .bg-white .h2, .o_colored_level .bg-white .h2, .bg-black .h2, .o_colored_level .bg-black .h2, .bg-black-50 .h2, .o_colored_level .bg-black-50 .h2, .bg-black-75 .h2, .o_colored_level .bg-black-75 .h2, .bg-white-50 .h2, .o_colored_level .bg-white-50 .h2, .bg-white-75 .h2, .o_colored_level .bg-white-75 .h2, .bg-white-85 .h2, .o_colored_level .bg-white-85 .h2, .bg-900 .h2, .o_colored_level .bg-900 .h2, .bg-800 .h2, .o_colored_level .bg-800 .h2, .bg-700 .h2, .o_colored_level .bg-700 .h2, .bg-600 .h2, .o_colored_level .bg-600 .h2, .bg-500 .h2, .o_colored_level .bg-500 .h2, .bg-400 .h2, .o_colored_level .bg-400 .h2, .bg-300 .h2, .o_colored_level .bg-300 .h2, .bg-200 .h2, .bg-100 .h2, .toast-body .h2, .card-body .h2, .o_cc5 h3, .o_colored_level .o_cc5 h3, .o_cc4 h3, .o_colored_level .o_cc4 h3, .o_cc3 h3, .o_colored_level .o_cc3 h3, .o_cc2 h3, .o_colored_level .o_cc2 h3, .o_cc1 h3, .o_colored_level .o_cc1 h3, .bg-o-color-5 h3, .o_colored_level .bg-o-color-5 h3, .bg-o-color-4 h3, .o_colored_level .bg-o-color-4 h3, .bg-o-color-3 h3, .o_colored_level .bg-o-color-3 h3, .bg-o-color-2 h3, .o_colored_level .bg-o-color-2 h3, .bg-o-color-1 h3, .o_colored_level .bg-o-color-1 h3, .bg-white h3, .o_colored_level .bg-white h3, .bg-black h3, .o_colored_level .bg-black h3, .bg-black-50 h3, .o_colored_level .bg-black-50 h3, .bg-black-75 h3, .o_colored_level .bg-black-75 h3, .bg-white-50 h3, .o_colored_level .bg-white-50 h3, .bg-white-75 h3, .o_colored_level .bg-white-75 h3, .bg-white-85 h3, .o_colored_level .bg-white-85 h3, .bg-900 h3, .o_colored_level .bg-900 h3, .bg-800 h3, .o_colored_level .bg-800 h3, .bg-700 h3, .o_colored_level .bg-700 h3, .bg-600 h3, .o_colored_level .bg-600 h3, .bg-500 h3, .o_colored_level .bg-500 h3, .bg-400 h3, .o_colored_level .bg-400 h3, .bg-300 h3, .o_colored_level .bg-300 h3, .bg-200 h3, .o_colored_level .bg-200 h3, .bg-100 h3, .o_colored_level .bg-100 h3, .toast-body h3, .o_colored_level .toast-body h3, .card-body h3, .o_colored_level .card-body h3, .o_cc5 .h3, .o_colored_level .o_cc5 .h3, .o_cc4 .h3, .o_colored_level .o_cc4 .h3, .o_cc3 .h3, .o_colored_level .o_cc3 .h3, .o_cc2 .h3, .o_colored_level .o_cc2 .h3, .o_cc1 .h3, .o_colored_level .o_cc1 .h3, .bg-o-color-5 .h3, .o_colored_level .bg-o-color-5 .h3, .bg-o-color-4 .h3, .o_colored_level .bg-o-color-4 .h3, .bg-o-color-3 .h3, .o_colored_level .bg-o-color-3 .h3, .bg-o-color-2 .h3, .o_colored_level .bg-o-color-2 .h3, .bg-o-color-1 .h3, .o_colored_level .bg-o-color-1 .h3, .bg-white .h3, .o_colored_level .bg-white .h3, .bg-black .h3, .o_colored_level .bg-black .h3, .bg-black-50 .h3, .o_colored_level .bg-black-50 .h3, .bg-black-75 .h3, .o_colored_level .bg-black-75 .h3, .bg-white-50 .h3, .o_colored_level .bg-white-50 .h3, .bg-white-75 .h3, .o_colored_level .bg-white-75 .h3, .bg-white-85 .h3, .o_colored_level .bg-white-85 .h3, .bg-900 .h3, .o_colored_level .bg-900 .h3, .bg-800 .h3, .o_colored_level .bg-800 .h3, .bg-700 .h3, .o_colored_level .bg-700 .h3, .bg-600 .h3, .o_colored_level .bg-600 .h3, .bg-500 .h3, .o_colored_level .bg-500 .h3, .bg-400 .h3, .o_colored_level .bg-400 .h3, .bg-300 .h3, .o_colored_level .bg-300 .h3, .bg-200 .h3, .bg-100 .h3, .toast-body .h3, .card-body .h3, .o_cc5 h4, .o_colored_level .o_cc5 h4, .o_cc4 h4, .o_colored_level .o_cc4 h4, .o_cc3 h4, .o_colored_level .o_cc3 h4, .o_cc2 h4, .o_colored_level .o_cc2 h4, .o_cc1 h4, .o_colored_level .o_cc1 h4, .bg-o-color-5 h4, .o_colored_level .bg-o-color-5 h4, .bg-o-color-4 h4, .o_colored_level .bg-o-color-4 h4, .bg-o-color-3 h4, .o_colored_level .bg-o-color-3 h4, .bg-o-color-2 h4, .o_colored_level .bg-o-color-2 h4, .bg-o-color-1 h4, .o_colored_level .bg-o-color-1 h4, .bg-white h4, .o_colored_level .bg-white h4, .bg-black h4, .o_colored_level .bg-black h4, .bg-black-50 h4, .o_colored_level .bg-black-50 h4, .bg-black-75 h4, .o_colored_level .bg-black-75 h4, .bg-white-50 h4, .o_colored_level .bg-white-50 h4, .bg-white-75 h4, .o_colored_level .bg-white-75 h4, .bg-white-85 h4, .o_colored_level .bg-white-85 h4, .bg-900 h4, .o_colored_level .bg-900 h4, .bg-800 h4, .o_colored_level .bg-800 h4, .bg-700 h4, .o_colored_level .bg-700 h4, .bg-600 h4, .o_colored_level .bg-600 h4, .bg-500 h4, .o_colored_level .bg-500 h4, .bg-400 h4, .o_colored_level .bg-400 h4, .bg-300 h4, .o_colored_level .bg-300 h4, .bg-200 h4, .o_colored_level .bg-200 h4, .bg-100 h4, .o_colored_level .bg-100 h4, .toast-body h4, .o_colored_level .toast-body h4, .card-body h4, .o_colored_level .card-body h4, .o_cc5 .h4, .o_colored_level .o_cc5 .h4, .o_cc4 .h4, .o_colored_level .o_cc4 .h4, .o_cc3 .h4, .o_colored_level .o_cc3 .h4, .o_cc2 .h4, .o_colored_level .o_cc2 .h4, .o_cc1 .h4, .o_colored_level .o_cc1 .h4, .bg-o-color-5 .h4, .o_colored_level .bg-o-color-5 .h4, .bg-o-color-4 .h4, .o_colored_level .bg-o-color-4 .h4, .bg-o-color-3 .h4, .o_colored_level .bg-o-color-3 .h4, .bg-o-color-2 .h4, .o_colored_level .bg-o-color-2 .h4, .bg-o-color-1 .h4, .o_colored_level .bg-o-color-1 .h4, .bg-white .h4, .o_colored_level .bg-white .h4, .bg-black .h4, .o_colored_level .bg-black .h4, .bg-black-50 .h4, .o_colored_level .bg-black-50 .h4, .bg-black-75 .h4, .o_colored_level .bg-black-75 .h4, .bg-white-50 .h4, .o_colored_level .bg-white-50 .h4, .bg-white-75 .h4, .o_colored_level .bg-white-75 .h4, .bg-white-85 .h4, .o_colored_level .bg-white-85 .h4, .bg-900 .h4, .o_colored_level .bg-900 .h4, .bg-800 .h4, .o_colored_level .bg-800 .h4, .bg-700 .h4, .o_colored_level .bg-700 .h4, .bg-600 .h4, .o_colored_level .bg-600 .h4, .bg-500 .h4, .o_colored_level .bg-500 .h4, .bg-400 .h4, .o_colored_level .bg-400 .h4, .bg-300 .h4, .o_colored_level .bg-300 .h4, .bg-200 .h4, .bg-100 .h4, .toast-body .h4, .card-body .h4, .o_cc5 h5, .o_colored_level .o_cc5 h5, .o_cc4 h5, .o_colored_level .o_cc4 h5, .o_cc3 h5, .o_colored_level .o_cc3 h5, .o_cc2 h5, .o_colored_level .o_cc2 h5, .o_cc1 h5, .o_colored_level .o_cc1 h5, .bg-o-color-5 h5, .o_colored_level .bg-o-color-5 h5, .bg-o-color-4 h5, .o_colored_level .bg-o-color-4 h5, .bg-o-color-3 h5, .o_colored_level .bg-o-color-3 h5, .bg-o-color-2 h5, .o_colored_level .bg-o-color-2 h5, .bg-o-color-1 h5, .o_colored_level .bg-o-color-1 h5, .bg-white h5, .o_colored_level .bg-white h5, .bg-black h5, .o_colored_level .bg-black h5, .bg-black-50 h5, .o_colored_level .bg-black-50 h5, .bg-black-75 h5, .o_colored_level .bg-black-75 h5, .bg-white-50 h5, .o_colored_level .bg-white-50 h5, .bg-white-75 h5, .o_colored_level .bg-white-75 h5, .bg-white-85 h5, .o_colored_level .bg-white-85 h5, .bg-900 h5, .o_colored_level .bg-900 h5, .bg-800 h5, .o_colored_level .bg-800 h5, .bg-700 h5, .o_colored_level .bg-700 h5, .bg-600 h5, .o_colored_level .bg-600 h5, .bg-500 h5, .o_colored_level .bg-500 h5, .bg-400 h5, .o_colored_level .bg-400 h5, .bg-300 h5, .o_colored_level .bg-300 h5, .bg-200 h5, .o_colored_level .bg-200 h5, .bg-100 h5, .o_colored_level .bg-100 h5, .toast-body h5, .o_colored_level .toast-body h5, .card-body h5, .o_colored_level .card-body h5, .o_cc5 .h5, .o_colored_level .o_cc5 .h5, .o_cc4 .h5, .o_colored_level .o_cc4 .h5, .o_cc3 .h5, .o_colored_level .o_cc3 .h5, .o_cc2 .h5, .o_colored_level .o_cc2 .h5, .o_cc1 .h5, .o_colored_level .o_cc1 .h5, .bg-o-color-5 .h5, .o_colored_level .bg-o-color-5 .h5, .bg-o-color-4 .h5, .o_colored_level .bg-o-color-4 .h5, .bg-o-color-3 .h5, .o_colored_level .bg-o-color-3 .h5, .bg-o-color-2 .h5, .o_colored_level .bg-o-color-2 .h5, .bg-o-color-1 .h5, .o_colored_level .bg-o-color-1 .h5, .bg-white .h5, .o_colored_level .bg-white .h5, .bg-black .h5, .o_colored_level .bg-black .h5, .bg-black-50 .h5, .o_colored_level .bg-black-50 .h5, .bg-black-75 .h5, .o_colored_level .bg-black-75 .h5, .bg-white-50 .h5, .o_colored_level .bg-white-50 .h5, .bg-white-75 .h5, .o_colored_level .bg-white-75 .h5, .bg-white-85 .h5, .o_colored_level .bg-white-85 .h5, .bg-900 .h5, .o_colored_level .bg-900 .h5, .bg-800 .h5, .o_colored_level .bg-800 .h5, .bg-700 .h5, .o_colored_level .bg-700 .h5, .bg-600 .h5, .o_colored_level .bg-600 .h5, .bg-500 .h5, .o_colored_level .bg-500 .h5, .bg-400 .h5, .o_colored_level .bg-400 .h5, .bg-300 .h5, .o_colored_level .bg-300 .h5, .bg-200 .h5, .bg-100 .h5, .toast-body .h5, .card-body .h5, .o_cc5 h6, .o_colored_level .o_cc5 h6, .o_cc4 h6, .o_colored_level .o_cc4 h6, .o_cc3 h6, .o_colored_level .o_cc3 h6, .o_cc2 h6, .o_colored_level .o_cc2 h6, .o_cc1 h6, .o_colored_level .o_cc1 h6, .bg-o-color-5 h6, .o_colored_level .bg-o-color-5 h6, .bg-o-color-4 h6, .o_colored_level .bg-o-color-4 h6, .bg-o-color-3 h6, .o_colored_level .bg-o-color-3 h6, .bg-o-color-2 h6, .o_colored_level .bg-o-color-2 h6, .bg-o-color-1 h6, .o_colored_level .bg-o-color-1 h6, .bg-white h6, .o_colored_level .bg-white h6, .bg-black h6, .o_colored_level .bg-black h6, .bg-black-50 h6, .o_colored_level .bg-black-50 h6, .bg-black-75 h6, .o_colored_level .bg-black-75 h6, .bg-white-50 h6, .o_colored_level .bg-white-50 h6, .bg-white-75 h6, .o_colored_level .bg-white-75 h6, .bg-white-85 h6, .o_colored_level .bg-white-85 h6, .bg-900 h6, .o_colored_level .bg-900 h6, .bg-800 h6, .o_colored_level .bg-800 h6, .bg-700 h6, .o_colored_level .bg-700 h6, .bg-600 h6, .o_colored_level .bg-600 h6, .bg-500 h6, .o_colored_level .bg-500 h6, .bg-400 h6, .o_colored_level .bg-400 h6, .bg-300 h6, .o_colored_level .bg-300 h6, .bg-200 h6, .o_colored_level .bg-200 h6, .bg-100 h6, .o_colored_level .bg-100 h6, .toast-body h6, .o_colored_level .toast-body h6, .card-body h6, .o_colored_level .card-body h6, .o_cc5 .h6, .o_colored_level .o_cc5 .h6, .o_cc4 .h6, .o_colored_level .o_cc4 .h6, .o_cc3 .h6, .o_colored_level .o_cc3 .h6, .o_cc2 .h6, .o_colored_level .o_cc2 .h6, .o_cc1 .h6, .o_colored_level .o_cc1 .h6, .bg-o-color-5 .h6, .o_colored_level .bg-o-color-5 .h6, .bg-o-color-4 .h6, .o_colored_level .bg-o-color-4 .h6, .bg-o-color-3 .h6, .o_colored_level .bg-o-color-3 .h6, .bg-o-color-2 .h6, .o_colored_level .bg-o-color-2 .h6, .bg-o-color-1 .h6, .o_colored_level .bg-o-color-1 .h6, .bg-white .h6, .o_colored_level .bg-white .h6, .bg-black .h6, .o_colored_level .bg-black .h6, .bg-black-50 .h6, .o_colored_level .bg-black-50 .h6, .bg-black-75 .h6, .o_colored_level .bg-black-75 .h6, .bg-white-50 .h6, .o_colored_level .bg-white-50 .h6, .bg-white-75 .h6, .o_colored_level .bg-white-75 .h6, .bg-white-85 .h6, .o_colored_level .bg-white-85 .h6, .bg-900 .h6, .o_colored_level .bg-900 .h6, .bg-800 .h6, .o_colored_level .bg-800 .h6, .bg-700 .h6, .o_colored_level .bg-700 .h6, .bg-600 .h6, .o_colored_level .bg-600 .h6, .bg-500 .h6, .o_colored_level .bg-500 .h6, .bg-400 .h6, .o_colored_level .bg-400 .h6, .bg-300 .h6, .o_colored_level .bg-300 .h6, .bg-200 .h6, .bg-100 .h6, .toast-body .h6, .card-body .h6{color: inherit;}\n/* /web/static/src/scss/utils.scss */\n .modal:not(.o_legacy_dialog) .o_select_media_dialog .o_we_existing_attachments .o_existing_attachment_cell.o_we_image .o_we_media_dialog_img_wrapper, .o_colorpicker_widget .o_opacity_slider, .o_colorpicker_widget .o_color_preview{position: relative; z-index: 0;}.modal:not(.o_legacy_dialog) .o_select_media_dialog .o_we_existing_attachments .o_existing_attachment_cell.o_we_image .o_we_media_dialog_img_wrapper::before, .o_colorpicker_widget .o_opacity_slider::before, .o_colorpicker_widget .o_color_preview::before{content: ""; position: absolute; top: 0; left: 0; bottom: 0; right: 0; z-index: -1; background-image: url("/web/static/img/transparent.png"); background-size: 10px auto; border-radius: inherit;}.modal:not(.o_legacy_dialog) .o_select_media_dialog .o_we_existing_attachments .o_existing_attachment_cell.o_we_image .o_we_media_dialog_img_wrapper::after, .o_colorpicker_widget .o_opacity_slider::after, .o_colorpicker_widget .o_color_preview::after{content: ""; position: absolute; top: 0; left: 0; bottom: 0; right: 0; z-index: -1; background: inherit; border-radius: inherit;}.o_nocontent_help .o_empty_folder_image:before{content: ""; display: block; margin: auto; background-size: cover;}.o_nocontent_help .o_empty_folder_image:before{width: 120px; height: 80px; margin-top: 30px; margin-bottom: 30px; background: transparent url(/web/static/img/empty_folder.svg) no-repeat center;}\n/* /web/static/src/scss/primary_variables.scss */\n/* /web/static/src/core/avatar/avatar.variables.scss */\n/* /web/static/src/core/notifications/notification.variables.scss */\n/* /web/static/src/search/control_panel/control_panel.variables.scss */\n/* /web/static/src/search/search_panel/search_panel.variables.scss */\n/* /web/static/src/views/fields/statusbar/statusbar_field.variables.scss */\n/* /web/static/src/views/form/form.variables.scss */\n/* /web/static/src/views/kanban/kanban.variables.scss */\n/* /web/static/src/webclient/burger_menu/burger_menu.variables.scss */\n/* /web/static/src/webclient/navbar/navbar.variables.scss */\n .o_main_navbar .o_menu_brand, .o_main_navbar .o_navbar_apps_menu .dropdown-toggle, .o_main_navbar .o_nav_entry, .o_main_navbar .dropdown-toggle{position: relative; display: -webkit-box; display: -webkit-flex; display: flex; align-items: center; width: auto; height: calc(var(--o-navbar-height) - 0px); border-radius: 0; user-select: none; background: transparent; font-size: 1em; color: var(--NavBar-entry-color, rgba(255, 255, 255, 0.9));}.o_main_navbar .o_menu_brand:hover, .o_main_navbar .o_nav_entry:hover, .o_main_navbar .dropdown-toggle:hover, .o_main_navbar .o_menu_brand:focus, .o_main_navbar .o_nav_entry:focus, .o_main_navbar .dropdown-toggle:focus, .o_main_navbar .focus.o_menu_brand, .o_main_navbar .focus.o_nav_entry, .o_main_navbar .focus.dropdown-toggle{color: var(--NavBar-entry-color--hover, #FFFFFF);}.o_main_navbar .o_menu_brand, .o_main_navbar .o_nav_entry, .o_main_navbar .dropdown-toggle{margin: 0; margin-left: var(--NavBar-entry-margin-left, 0); margin-right: var(--NavBar-entry-margin-right, 0); padding: 0; padding-left: var(--NavBar-entry-padding-left, 0.63em); padding-right: var(--NavBar-entry-padding-right, 0.63em); line-height: calc(var(--o-navbar-height) - 0px);}\n/* /web_editor/static/src/scss/web_editor.variables.scss */\n/* /web_editor/static/src/scss/wysiwyg.variables.scss */\n/* /web/static/src/scss/secondary_variables.scss */\n/* /web_editor/static/src/scss/secondary_variables.scss */\n/* /web_editor/static/src/scss/bootstrap_overridden.scss */\n/* /web/static/src/scss/bootstrap_overridden_frontend.scss */\n/* /web/static/src/scss/pre_variables.scss */\n/* /web/static/lib/bootstrap/scss/_variables.scss */\n/* /web/static/src/scss/import_bootstrap.scss */\n :root{--bs-blue: #0d6efd; --bs-indigo: #6610f2; --bs-purple: #6f42c1; --bs-pink: #d63384; --bs-red: #dc3545; --bs-orange: #fd7e14; --bs-yellow: #ffc107; --bs-green: #198754; --bs-teal: #20c997; --bs-cyan: #0dcaf0; --bs-white: #FFFFFF; --bs-gray: #6C757D; --bs-gray-dark: #343A40; --bs-o-cc5-btn-secondary-border: ; --bs-o-cc5-btn-secondary: #F3F2F2; --bs-o-cc5-btn-primary-border: ; --bs-o-cc5-btn-primary: ; --bs-o-cc5-link: ; --bs-o-cc5-h6: ; --bs-o-cc5-h5: ; --bs-o-cc5-h4: ; --bs-o-cc5-h3: ; --bs-o-cc5-h2: ; --bs-o-cc5-headings: #FFFFFF; --bs-o-cc5-text: ; --bs-o-cc5-bg: #111827; --bs-o-cc4-btn-secondary-border: ; --bs-o-cc4-btn-secondary: #F3F2F2; --bs-o-cc4-btn-primary-border: ; --bs-o-cc4-btn-primary: #111827; --bs-o-cc4-link: #111827; --bs-o-cc4-h6: ; --bs-o-cc4-h5: ; --bs-o-cc4-h4: ; --bs-o-cc4-h3: ; --bs-o-cc4-h2: ; --bs-o-cc4-headings: ; --bs-o-cc4-text: ; --bs-o-cc4-bg: #714B67; --bs-o-cc3-btn-secondary-border: ; --bs-o-cc3-btn-secondary: #F3F2F2; --bs-o-cc3-btn-primary-border: ; --bs-o-cc3-btn-primary: ; --bs-o-cc3-link: ; --bs-o-cc3-h6: ; --bs-o-cc3-h5: ; --bs-o-cc3-h4: ; --bs-o-cc3-h3: ; --bs-o-cc3-h2: ; --bs-o-cc3-headings: ; --bs-o-cc3-text: ; --bs-o-cc3-bg: #8595A2; --bs-o-cc2-btn-secondary-border: ; --bs-o-cc2-btn-secondary: ; --bs-o-cc2-btn-primary-border: ; --bs-o-cc2-btn-primary: ; --bs-o-cc2-link: ; --bs-o-cc2-h6: ; --bs-o-cc2-h5: ; --bs-o-cc2-h4: ; --bs-o-cc2-h3: ; --bs-o-cc2-h2: ; --bs-o-cc2-headings: #111827; --bs-o-cc2-text: ; --bs-o-cc2-bg: #F3F2F2; --bs-o-cc1-btn-secondary-border: ; --bs-o-cc1-btn-secondary: ; --bs-o-cc1-btn-primary-border: ; --bs-o-cc1-btn-primary: ; --bs-o-cc1-link: ; --bs-o-cc1-h6: ; --bs-o-cc1-h5: ; --bs-o-cc1-h4: ; --bs-o-cc1-h3: ; --bs-o-cc1-h2: ; --bs-o-cc1-headings: ; --bs-o-cc1-text: ; --bs-o-cc1-bg: #FFFFFF; --bs-o-color-5: #111827; --bs-o-color-4: #FFFFFF; --bs-o-color-3: #F3F2F2; --bs-o-color-2: #8595A2; --bs-o-color-1: #714B67; --bs-gray-100: #F8F9FA; --bs-gray-200: #E9ECEF; --bs-gray-300: #DEE2E6; --bs-gray-400: #CED4DA; --bs-gray-500: #ADB5BD; --bs-gray-600: #6C757D; --bs-gray-700: #495057; --bs-gray-800: #343A40; --bs-gray-900: #212529; --bs-gray-white-85: rgba(255, 255, 255, 0.85); --bs-gray-white-75: rgba(255, 255, 255, 0.75); --bs-gray-white-50: rgba(255, 255, 255, 0.5); --bs-gray-white-25: rgba(255, 255, 255, 0.25); --bs-gray-black-75: rgba(0, 0, 0, 0.75); --bs-gray-black-50: rgba(0, 0, 0, 0.5); --bs-gray-black-25: rgba(0, 0, 0, 0.25); --bs-gray-black-15: rgba(0, 0, 0, 0.15); --bs-gray-black: #000000; --bs-gray-white: #FFFFFF; --bs-primary: #714B67; --bs-secondary: #8595A2; --bs-success: #198754; --bs-info: #0dcaf0; --bs-warning: #ffc107; --bs-danger: #dc3545; --bs-light: #F8F9FA; --bs-dark: #212529; --bs-primary-rgb: 113, 75, 103; --bs-secondary-rgb: 133, 149, 162; --bs-success-rgb: 25, 135, 84; --bs-info-rgb: 13, 202, 240; --bs-warning-rgb: 255, 193, 7; --bs-danger-rgb: 220, 53, 69; --bs-light-rgb: 248, 249, 250; --bs-dark-rgb: 33, 37, 41; --bs-white-rgb: 255, 255, 255; --bs-black-rgb: 0, 0, 0; --bs-body-color-rgb: 33, 37, 41; --bs-body-bg-rgb: 255, 255, 255; --bs-font-sans-serif: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Ubuntu, "Noto Sans", Arial, "Odoo Unicode Support Noto", sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol", "Noto Color Emoji"; --bs-font-monospace: SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace; --bs-gradient: linear-gradient(180deg, rgba(255, 255, 255, 0.15), rgba(255, 255, 255, 0)); --bs-body-font-family: var(--bs-font-sans-serif); --bs-body-font-size: 0.875rem; --bs-body-font-weight: 400; --bs-body-line-height: 1.5; --bs-body-color: #212529; --bs-body-bg: #FFFFFF;}*, *::before, *::after{box-sizing: border-box;}@media (prefers-reduced-motion: no-preference){:root{scroll-behavior: smooth;}}body{margin: 0; font-family: var(--bs-body-font-family); font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight); line-height: var(--bs-body-line-height); color: var(--bs-body-color); text-align: var(--bs-body-text-align); background-color: var(--bs-body-bg); -webkit-text-size-adjust: 100%; -webkit-tap-highlight-color: rgba(0, 0, 0, 0);}hr{margin: 1rem 0; color: inherit; background-color: currentColor; border: 0; opacity: 0.25;}hr:not([size]){height: 1px;}h6, .h6, h5, .h5, h4, .h4, h3, .h3, h2, .h2, h1, .h1{margin-top: 0; margin-bottom: 0.5rem; font-weight: 500; line-height: 1.2;}h1, .h1{font-size: calc(1.34375rem + 1.125vw);}@media (min-width: 1200px){h1, .h1{font-size: 2.1875rem;}}h2, .h2{font-size: calc(1.3rem + 0.6vw);}@media (min-width: 1200px){h2, .h2{font-size: 1.75rem;}}h3, .h3{font-size: calc(1.278125rem + 0.3375vw);}@media (min-width: 1200px){h3, .h3{font-size: 1.53125rem;}}h4, .h4{font-size: calc(1.25625rem + 0.075vw);}@media (min-width: 1200px){h4, .h4{font-size: 1.3125rem;}}h5, .h5{font-size: 1.09375rem;}h6, .h6{font-size: 0.875rem;}p{margin-top: 0; margin-bottom: 1rem;}abbr[title], abbr[data-bs-original-title]{text-decoration: underline dotted; cursor: help; text-decoration-skip-ink: none;}address{margin-bottom: 1rem; font-style: normal; line-height: inherit;}ol, ul{padding-left: 2rem;}ol, ul, dl{margin-top: 0; margin-bottom: 1rem;}ol ol, ul ul, ol ul, ul ol{margin-bottom: 0;}dt{font-weight: 700;}dd{margin-bottom: .5rem; margin-left: 0;}blockquote{margin: 0 0 1rem;}b, strong{font-weight: bolder;}small, .small{font-size: 0.875em;}mark, .mark{padding: 0.2em; background-color: #fcf8e3;}sub, sup{position: relative; font-size: 0.75em; line-height: 0; vertical-align: baseline;}sub{bottom: -.25em;}sup{top: -.5em;}a{color: #714B67; text-decoration: none;}a:hover{color: #5a3c52;}a:not([href]):not([class]), a:not([href]):not([class]):hover{color: inherit; text-decoration: none;}pre, code, kbd, samp{font-family: var(--bs-font-monospace); font-size: 1em; direction: ltr ; unicode-bidi: bidi-override;}pre{display: block; margin-top: 0; margin-bottom: 1rem; overflow: auto; font-size: 0.875em;}pre code{font-size: inherit; color: inherit; word-break: normal;}code{font-size: 0.875em; color: #d63384; word-wrap: break-word;}a > code{color: inherit;}kbd{padding: 0.2rem 0.4rem; font-size: 0.875em; color: #FFFFFF; background-color: #212529; border-radius: 0.2rem;}kbd kbd{padding: 0; font-size: 1em; font-weight: 700;}figure{margin: 0 0 1rem;}img, svg{vertical-align: middle;}table{caption-side: bottom; border-collapse: collapse;}caption{padding-top: 0.5rem; padding-bottom: 0.5rem; color: #6C757D; text-align: left;}th{text-align: inherit; text-align: -webkit-match-parent;}thead, tbody, tfoot, tr, td, th{border-color: inherit; border-style: solid; border-width: 0;}label{display: inline-block;}button{border-radius: 0;}button:focus:not(:focus-visible){outline: 0;}input, button, select, optgroup, textarea{margin: 0; font-family: inherit; font-size: inherit; line-height: inherit;}button, select{text-transform: none;}[role="button"]{cursor: pointer;}select{word-wrap: normal;}select:disabled, select.o_wysiwyg_loader{opacity: 1;}[list]::-webkit-calendar-picker-indicator{display: none;}button, [type="button"], [type="reset"], [type="submit"]{-webkit--webkit-appearance: button; -moz-appearance: button; appearance: button;}button:not(:disabled):not(.o_wysiwyg_loader), [type="button"]:not(:disabled):not(.o_wysiwyg_loader), [type="reset"]:not(:disabled):not(.o_wysiwyg_loader), [type="submit"]:not(:disabled):not(.o_wysiwyg_loader){cursor: pointer;}::-moz-focus-inner{padding: 0; border-style: none;}textarea{resize: vertical;}fieldset{min-width: 0; padding: 0; margin: 0; border: 0;}legend{float: left; width: 100%; padding: 0; margin-bottom: 0.5rem; font-size: calc(1.275rem + 0.3vw); line-height: inherit;}@media (min-width: 1200px){legend{font-size: 1.5rem;}}legend + *{clear: left;}::-webkit-datetime-edit-fields-wrapper, ::-webkit-datetime-edit-text, ::-webkit-datetime-edit-minute, ::-webkit-datetime-edit-hour-field, ::-webkit-datetime-edit-day-field, ::-webkit-datetime-edit-month-field, ::-webkit-datetime-edit-year-field{padding: 0;}::-webkit-inner-spin-button{height: auto;}[type="search"]{outline-offset: -2px; -webkit--webkit-appearance: textfield; -moz-appearance: textfield; appearance: textfield;}::-webkit-search-decoration{-webkit--webkit-appearance: none; -moz-appearance: none; appearance: none;}::-webkit-color-swatch-wrapper{padding: 0;}::file-selector-button{font: inherit;}::-webkit-file-upload-button{font: inherit; -webkit--webkit-appearance: button; -moz-appearance: button; appearance: button;}output{display: inline-block;}iframe{border: 0;}summary{display: list-item; cursor: pointer;}progress{vertical-align: baseline;}[hidden]{display: none !important;}.lead{font-size: 1.09375rem; font-weight: 300;}.display-1{font-size: calc(1.625rem + 4.5vw); font-weight: 300; line-height: 1.2;}@media (min-width: 1200px){.display-1{font-size: 5rem;}}.display-2{font-size: calc(1.575rem + 3.9vw); font-weight: 300; line-height: 1.2;}@media (min-width: 1200px){.display-2{font-size: 4.5rem;}}.display-3{font-size: calc(1.525rem + 3.3vw); font-weight: 300; line-height: 1.2;}@media (min-width: 1200px){.display-3{font-size: 4rem;}}.display-4{font-size: calc(1.475rem + 2.7vw); font-weight: 300; line-height: 1.2;}@media (min-width: 1200px){.display-4{font-size: 3.5rem;}}.display-5{font-size: calc(1.425rem + 2.1vw); font-weight: 300; line-height: 1.2;}@media (min-width: 1200px){.display-5{font-size: 3rem;}}.display-6{font-size: calc(1.375rem + 1.5vw); font-weight: 300; line-height: 1.2;}@media (min-width: 1200px){.display-6{font-size: 2.5rem;}}.list-unstyled{padding-left: 0; list-style: none;}.list-inline{padding-left: 0; list-style: none;}.list-inline-item{display: inline-block;}.list-inline-item:not(:last-child){margin-right: 0.5rem;}.initialism{font-size: 0.875em; text-transform: uppercase;}.blockquote{margin-bottom: 1rem; font-size: 1.09375rem;}.blockquote > :last-child{margin-bottom: 0;}.blockquote-footer{margin-top: -1rem; margin-bottom: 1rem; font-size: 0.875em; color: #6C757D;}.blockquote-footer::before{content: "\\2014\\00A0";}.img-fluid{max-width: 100%; height: auto;}.img-thumbnail{padding: 0.25rem; background-color: #FFFFFF; border: 1px solid #DEE2E6; border-radius: 0.25rem; max-width: 100%; height: auto;}.figure{display: inline-block;}.figure-img{margin-bottom: 0.5rem; line-height: 1;}.figure-caption{font-size: 0.875em; color: inherit;}.container, .o_container_small, .container-fluid, .container-xxl, .container-xl, .container-lg, .container-md, .container-sm{width: 100%; padding-right: var(--bs-gutter-x, 0.75rem); padding-left: var(--bs-gutter-x, 0.75rem); margin-right: auto; margin-left: auto;}@media (min-width: 576px){.container-sm, .container, .o_container_small{max-width: 540px;}}@media (min-width: 768px){.container-md, .container-sm, .container, .o_container_small{max-width: 720px;}}@media (min-width: 992px){.container-lg, .container-md, .container-sm, .container, .o_container_small{max-width: 960px;}}@media (min-width: 1200px){.container-xl, .container-lg, .container-md, .container-sm, .container, .o_container_small{max-width: 1140px;}}@media (min-width: 1400px){.container-xxl, .container-xl, .container-lg, .container-md, .container-sm, .container, .o_container_small{max-width: 1320px;}}.row{--bs-gutter-x: 1.5rem; --bs-gutter-y: 0; display: -webkit-box; display: -webkit-flex; display: flex; -webkit-flex-wrap: wrap; flex-wrap: wrap; margin-top: calc(-1 * var(--bs-gutter-y)); margin-right: calc(-.5 * var(--bs-gutter-x)); margin-left: calc(-.5 * var(--bs-gutter-x));}.row > *{flex-shrink: 0; width: 100%; max-width: 100%; padding-right: calc(var(--bs-gutter-x) * .5); padding-left: calc(var(--bs-gutter-x) * .5); margin-top: var(--bs-gutter-y);}.col{flex: 1 0 0%;}.row-cols-auto > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: auto;}.row-cols-1 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 100%;}.row-cols-2 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 50%;}.row-cols-3 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 33.33333333%;}.row-cols-4 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 25%;}.row-cols-5 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 20%;}.row-cols-6 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 16.66666667%;}.col-auto{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: auto;}.col-1{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 8.33333333%;}.col-2{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 16.66666667%;}.col-3{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 25%;}.col-4{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 33.33333333%;}.col-5{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 41.66666667%;}.col-6{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 50%;}.col-7{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 58.33333333%;}.col-8{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 66.66666667%;}.col-9{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 75%;}.col-10{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 83.33333333%;}.col-11{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 91.66666667%;}.col-12{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 100%;}.offset-1{margin-left: 8.33333333%;}.offset-2{margin-left: 16.66666667%;}.offset-3{margin-left: 25%;}.offset-4{margin-left: 33.33333333%;}.offset-5{margin-left: 41.66666667%;}.offset-6{margin-left: 50%;}.offset-7{margin-left: 58.33333333%;}.offset-8{margin-left: 66.66666667%;}.offset-9{margin-left: 75%;}.offset-10{margin-left: 83.33333333%;}.offset-11{margin-left: 91.66666667%;}.g-0, .gx-0{--bs-gutter-x: 0;}.g-0, .gy-0{--bs-gutter-y: 0;}.g-1, .gx-1{--bs-gutter-x: 0.25rem;}.g-1, .gy-1{--bs-gutter-y: 0.25rem;}.g-2, .gx-2{--bs-gutter-x: 0.5rem;}.g-2, .gy-2{--bs-gutter-y: 0.5rem;}.g-3, .gx-3{--bs-gutter-x: 1rem;}.g-3, .gy-3{--bs-gutter-y: 1rem;}.g-4, .gx-4{--bs-gutter-x: 1.5rem;}.g-4, .gy-4{--bs-gutter-y: 1.5rem;}.g-5, .gx-5{--bs-gutter-x: 3rem;}.g-5, .gy-5{--bs-gutter-y: 3rem;}@media (min-width: 576px){.col-sm{flex: 1 0 0%;}.row-cols-sm-auto > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: auto;}.row-cols-sm-1 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 100%;}.row-cols-sm-2 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 50%;}.row-cols-sm-3 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 33.33333333%;}.row-cols-sm-4 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 25%;}.row-cols-sm-5 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 20%;}.row-cols-sm-6 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 16.66666667%;}.col-sm-auto{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: auto;}.col-sm-1{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 8.33333333%;}.col-sm-2{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 16.66666667%;}.col-sm-3{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 25%;}.col-sm-4{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 33.33333333%;}.col-sm-5{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 41.66666667%;}.col-sm-6{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 50%;}.col-sm-7{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 58.33333333%;}.col-sm-8{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 66.66666667%;}.col-sm-9{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 75%;}.col-sm-10{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 83.33333333%;}.col-sm-11{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 91.66666667%;}.col-sm-12{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 100%;}.offset-sm-0{margin-left: 0;}.offset-sm-1{margin-left: 8.33333333%;}.offset-sm-2{margin-left: 16.66666667%;}.offset-sm-3{margin-left: 25%;}.offset-sm-4{margin-left: 33.33333333%;}.offset-sm-5{margin-left: 41.66666667%;}.offset-sm-6{margin-left: 50%;}.offset-sm-7{margin-left: 58.33333333%;}.offset-sm-8{margin-left: 66.66666667%;}.offset-sm-9{margin-left: 75%;}.offset-sm-10{margin-left: 83.33333333%;}.offset-sm-11{margin-left: 91.66666667%;}.g-sm-0, .gx-sm-0{--bs-gutter-x: 0;}.g-sm-0, .gy-sm-0{--bs-gutter-y: 0;}.g-sm-1, .gx-sm-1{--bs-gutter-x: 0.25rem;}.g-sm-1, .gy-sm-1{--bs-gutter-y: 0.25rem;}.g-sm-2, .gx-sm-2{--bs-gutter-x: 0.5rem;}.g-sm-2, .gy-sm-2{--bs-gutter-y: 0.5rem;}.g-sm-3, .gx-sm-3{--bs-gutter-x: 1rem;}.g-sm-3, .gy-sm-3{--bs-gutter-y: 1rem;}.g-sm-4, .gx-sm-4{--bs-gutter-x: 1.5rem;}.g-sm-4, .gy-sm-4{--bs-gutter-y: 1.5rem;}.g-sm-5, .gx-sm-5{--bs-gutter-x: 3rem;}.g-sm-5, .gy-sm-5{--bs-gutter-y: 3rem;}}@media (min-width: 768px){.col-md{flex: 1 0 0%;}.row-cols-md-auto > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: auto;}.row-cols-md-1 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 100%;}.row-cols-md-2 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 50%;}.row-cols-md-3 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 33.33333333%;}.row-cols-md-4 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 25%;}.row-cols-md-5 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 20%;}.row-cols-md-6 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 16.66666667%;}.col-md-auto{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: auto;}.col-md-1{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 8.33333333%;}.col-md-2{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 16.66666667%;}.col-md-3{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 25%;}.col-md-4{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 33.33333333%;}.col-md-5{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 41.66666667%;}.col-md-6{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 50%;}.col-md-7{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 58.33333333%;}.col-md-8{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 66.66666667%;}.col-md-9{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 75%;}.col-md-10{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 83.33333333%;}.col-md-11{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 91.66666667%;}.col-md-12{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 100%;}.offset-md-0{margin-left: 0;}.offset-md-1{margin-left: 8.33333333%;}.offset-md-2{margin-left: 16.66666667%;}.offset-md-3{margin-left: 25%;}.offset-md-4{margin-left: 33.33333333%;}.offset-md-5{margin-left: 41.66666667%;}.offset-md-6{margin-left: 50%;}.offset-md-7{margin-left: 58.33333333%;}.offset-md-8{margin-left: 66.66666667%;}.offset-md-9{margin-left: 75%;}.offset-md-10{margin-left: 83.33333333%;}.offset-md-11{margin-left: 91.66666667%;}.g-md-0, .gx-md-0{--bs-gutter-x: 0;}.g-md-0, .gy-md-0{--bs-gutter-y: 0;}.g-md-1, .gx-md-1{--bs-gutter-x: 0.25rem;}.g-md-1, .gy-md-1{--bs-gutter-y: 0.25rem;}.g-md-2, .gx-md-2{--bs-gutter-x: 0.5rem;}.g-md-2, .gy-md-2{--bs-gutter-y: 0.5rem;}.g-md-3, .gx-md-3{--bs-gutter-x: 1rem;}.g-md-3, .gy-md-3{--bs-gutter-y: 1rem;}.g-md-4, .gx-md-4{--bs-gutter-x: 1.5rem;}.g-md-4, .gy-md-4{--bs-gutter-y: 1.5rem;}.g-md-5, .gx-md-5{--bs-gutter-x: 3rem;}.g-md-5, .gy-md-5{--bs-gutter-y: 3rem;}}@media (min-width: 992px){.col-lg{flex: 1 0 0%;}.row-cols-lg-auto > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: auto;}.row-cols-lg-1 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 100%;}.row-cols-lg-2 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 50%;}.row-cols-lg-3 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 33.33333333%;}.row-cols-lg-4 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 25%;}.row-cols-lg-5 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 20%;}.row-cols-lg-6 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 16.66666667%;}.col-lg-auto{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: auto;}.col-lg-1{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 8.33333333%;}.col-lg-2{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 16.66666667%;}.col-lg-3{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 25%;}.col-lg-4{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 33.33333333%;}.col-lg-5{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 41.66666667%;}.col-lg-6{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 50%;}.col-lg-7{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 58.33333333%;}.col-lg-8{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 66.66666667%;}.col-lg-9{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 75%;}.col-lg-10{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 83.33333333%;}.col-lg-11{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 91.66666667%;}.col-lg-12{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 100%;}.offset-lg-0{margin-left: 0;}.offset-lg-1{margin-left: 8.33333333%;}.offset-lg-2{margin-left: 16.66666667%;}.offset-lg-3{margin-left: 25%;}.offset-lg-4{margin-left: 33.33333333%;}.offset-lg-5{margin-left: 41.66666667%;}.offset-lg-6{margin-left: 50%;}.offset-lg-7{margin-left: 58.33333333%;}.offset-lg-8{margin-left: 66.66666667%;}.offset-lg-9{margin-left: 75%;}.offset-lg-10{margin-left: 83.33333333%;}.offset-lg-11{margin-left: 91.66666667%;}.g-lg-0, .gx-lg-0{--bs-gutter-x: 0;}.g-lg-0, .gy-lg-0{--bs-gutter-y: 0;}.g-lg-1, .gx-lg-1{--bs-gutter-x: 0.25rem;}.g-lg-1, .gy-lg-1{--bs-gutter-y: 0.25rem;}.g-lg-2, .gx-lg-2{--bs-gutter-x: 0.5rem;}.g-lg-2, .gy-lg-2{--bs-gutter-y: 0.5rem;}.g-lg-3, .gx-lg-3{--bs-gutter-x: 1rem;}.g-lg-3, .gy-lg-3{--bs-gutter-y: 1rem;}.g-lg-4, .gx-lg-4{--bs-gutter-x: 1.5rem;}.g-lg-4, .gy-lg-4{--bs-gutter-y: 1.5rem;}.g-lg-5, .gx-lg-5{--bs-gutter-x: 3rem;}.g-lg-5, .gy-lg-5{--bs-gutter-y: 3rem;}}@media (min-width: 1200px){.col-xl{flex: 1 0 0%;}.row-cols-xl-auto > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: auto;}.row-cols-xl-1 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 100%;}.row-cols-xl-2 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 50%;}.row-cols-xl-3 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 33.33333333%;}.row-cols-xl-4 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 25%;}.row-cols-xl-5 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 20%;}.row-cols-xl-6 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 16.66666667%;}.col-xl-auto{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: auto;}.col-xl-1{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 8.33333333%;}.col-xl-2{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 16.66666667%;}.col-xl-3{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 25%;}.col-xl-4{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 33.33333333%;}.col-xl-5{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 41.66666667%;}.col-xl-6{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 50%;}.col-xl-7{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 58.33333333%;}.col-xl-8{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 66.66666667%;}.col-xl-9{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 75%;}.col-xl-10{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 83.33333333%;}.col-xl-11{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 91.66666667%;}.col-xl-12{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 100%;}.offset-xl-0{margin-left: 0;}.offset-xl-1{margin-left: 8.33333333%;}.offset-xl-2{margin-left: 16.66666667%;}.offset-xl-3{margin-left: 25%;}.offset-xl-4{margin-left: 33.33333333%;}.offset-xl-5{margin-left: 41.66666667%;}.offset-xl-6{margin-left: 50%;}.offset-xl-7{margin-left: 58.33333333%;}.offset-xl-8{margin-left: 66.66666667%;}.offset-xl-9{margin-left: 75%;}.offset-xl-10{margin-left: 83.33333333%;}.offset-xl-11{margin-left: 91.66666667%;}.g-xl-0, .gx-xl-0{--bs-gutter-x: 0;}.g-xl-0, .gy-xl-0{--bs-gutter-y: 0;}.g-xl-1, .gx-xl-1{--bs-gutter-x: 0.25rem;}.g-xl-1, .gy-xl-1{--bs-gutter-y: 0.25rem;}.g-xl-2, .gx-xl-2{--bs-gutter-x: 0.5rem;}.g-xl-2, .gy-xl-2{--bs-gutter-y: 0.5rem;}.g-xl-3, .gx-xl-3{--bs-gutter-x: 1rem;}.g-xl-3, .gy-xl-3{--bs-gutter-y: 1rem;}.g-xl-4, .gx-xl-4{--bs-gutter-x: 1.5rem;}.g-xl-4, .gy-xl-4{--bs-gutter-y: 1.5rem;}.g-xl-5, .gx-xl-5{--bs-gutter-x: 3rem;}.g-xl-5, .gy-xl-5{--bs-gutter-y: 3rem;}}@media (min-width: 1400px){.col-xxl{flex: 1 0 0%;}.row-cols-xxl-auto > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: auto;}.row-cols-xxl-1 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 100%;}.row-cols-xxl-2 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 50%;}.row-cols-xxl-3 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 33.33333333%;}.row-cols-xxl-4 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 25%;}.row-cols-xxl-5 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 20%;}.row-cols-xxl-6 > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 16.66666667%;}.col-xxl-auto{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: auto;}.col-xxl-1{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 8.33333333%;}.col-xxl-2{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 16.66666667%;}.col-xxl-3{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 25%;}.col-xxl-4{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 33.33333333%;}.col-xxl-5{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 41.66666667%;}.col-xxl-6{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 50%;}.col-xxl-7{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 58.33333333%;}.col-xxl-8{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 66.66666667%;}.col-xxl-9{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 75%;}.col-xxl-10{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 83.33333333%;}.col-xxl-11{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 91.66666667%;}.col-xxl-12{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto; width: 100%;}.offset-xxl-0{margin-left: 0;}.offset-xxl-1{margin-left: 8.33333333%;}.offset-xxl-2{margin-left: 16.66666667%;}.offset-xxl-3{margin-left: 25%;}.offset-xxl-4{margin-left: 33.33333333%;}.offset-xxl-5{margin-left: 41.66666667%;}.offset-xxl-6{margin-left: 50%;}.offset-xxl-7{margin-left: 58.33333333%;}.offset-xxl-8{margin-left: 66.66666667%;}.offset-xxl-9{margin-left: 75%;}.offset-xxl-10{margin-left: 83.33333333%;}.offset-xxl-11{margin-left: 91.66666667%;}.g-xxl-0, .gx-xxl-0{--bs-gutter-x: 0;}.g-xxl-0, .gy-xxl-0{--bs-gutter-y: 0;}.g-xxl-1, .gx-xxl-1{--bs-gutter-x: 0.25rem;}.g-xxl-1, .gy-xxl-1{--bs-gutter-y: 0.25rem;}.g-xxl-2, .gx-xxl-2{--bs-gutter-x: 0.5rem;}.g-xxl-2, .gy-xxl-2{--bs-gutter-y: 0.5rem;}.g-xxl-3, .gx-xxl-3{--bs-gutter-x: 1rem;}.g-xxl-3, .gy-xxl-3{--bs-gutter-y: 1rem;}.g-xxl-4, .gx-xxl-4{--bs-gutter-x: 1.5rem;}.g-xxl-4, .gy-xxl-4{--bs-gutter-y: 1.5rem;}.g-xxl-5, .gx-xxl-5{--bs-gutter-x: 3rem;}.g-xxl-5, .gy-xxl-5{--bs-gutter-y: 3rem;}}.table{--bs-table-bg: transparent; --bs-table-accent-bg: transparent; --bs-table-striped-color: inherit; --bs-table-striped-bg: rgba(0, 0, 0, 0.05); --bs-table-active-color: inherit; --bs-table-active-bg: rgba(0, 0, 0, 0.1); --bs-table-hover-color: inherit; --bs-table-hover-bg: rgba(0, 0, 0, 0.075); width: 100%; margin-bottom: 1rem; color: inherit; vertical-align: top; border-color: #DEE2E6;}.table > :not(caption) > * > *{padding: 0.5rem 0.5rem; background-color: var(--bs-table-bg); border-bottom-width: 1px; box-shadow: inset 0 0 0 9999px var(--bs-table-accent-bg);}.table > tbody{vertical-align: inherit;}.table > thead{vertical-align: bottom;}.table > :not(:first-child){border-top: 2px solid currentColor;}.caption-top{caption-side: top;}.table-sm > :not(caption) > * > *{padding: 0.25rem 0.25rem;}.table-bordered > :not(caption) > *{border-width: 1px 0;}.table-bordered > :not(caption) > * > *{border-width: 0 1px;}.table-borderless > :not(caption) > * > *{border-bottom-width: 0;}.table-borderless > :not(:first-child){border-top-width: 0;}.table-striped > tbody > tr:nth-of-type(odd) > *{--bs-table-accent-bg: var(--bs-table-striped-bg); color: var(--bs-table-striped-color);}.table-active{--bs-table-accent-bg: var(--bs-table-active-bg); color: var(--bs-table-active-color);}.table-hover > tbody > tr:hover > *{--bs-table-accent-bg: var(--bs-table-hover-bg); color: var(--bs-table-hover-color);}.table-primary{--bs-table-bg: #e3dbe1; --bs-table-striped-bg: #d8d0d6; --bs-table-striped-color: #000000; --bs-table-active-bg: #ccc5cb; --bs-table-active-color: #000000; --bs-table-hover-bg: #d2cbd0; --bs-table-hover-color: #000000; color: #000000; border-color: #ccc5cb;}.table-secondary{--bs-table-bg: #e7eaec; --bs-table-striped-bg: #dbdee0; --bs-table-striped-color: #000000; --bs-table-active-bg: #d0d3d4; --bs-table-active-color: #000000; --bs-table-hover-bg: #d6d8da; --bs-table-hover-color: #000000; color: #000000; border-color: #d0d3d4;}.table-success{--bs-table-bg: #d1e7dd; --bs-table-striped-bg: #c7dbd2; --bs-table-striped-color: #000000; --bs-table-active-bg: #bcd0c7; --bs-table-active-color: #000000; --bs-table-hover-bg: #c1d6cc; --bs-table-hover-color: #000000; color: #000000; border-color: #bcd0c7;}.table-info{--bs-table-bg: #cff4fc; --bs-table-striped-bg: #c5e8ef; --bs-table-striped-color: #000000; --bs-table-active-bg: #badce3; --bs-table-active-color: #000000; --bs-table-hover-bg: #bfe2e9; --bs-table-hover-color: #000000; color: #000000; border-color: #badce3;}.table-warning{--bs-table-bg: #fff3cd; --bs-table-striped-bg: #f2e7c3; --bs-table-striped-color: #000000; --bs-table-active-bg: #e6dbb9; --bs-table-active-color: #000000; --bs-table-hover-bg: #ece1be; --bs-table-hover-color: #000000; color: #000000; border-color: #e6dbb9;}.table-danger{--bs-table-bg: #f8d7da; --bs-table-striped-bg: #eccccf; --bs-table-striped-color: #000000; --bs-table-active-bg: #dfc2c4; --bs-table-active-color: #000000; --bs-table-hover-bg: #e5c7ca; --bs-table-hover-color: #000000; color: #000000; border-color: #dfc2c4;}.table-light{--bs-table-bg: #F8F9FA; --bs-table-striped-bg: #ecedee; --bs-table-striped-color: #000000; --bs-table-active-bg: #dfe0e1; --bs-table-active-color: #000000; --bs-table-hover-bg: #e5e6e7; --bs-table-hover-color: #000000; color: #000000; border-color: #dfe0e1;}.table-dark{--bs-table-bg: #212529; --bs-table-striped-bg: #2c3034; --bs-table-striped-color: #FFFFFF; --bs-table-active-bg: #373b3e; --bs-table-active-color: #FFFFFF; --bs-table-hover-bg: #323539; --bs-table-hover-color: #FFFFFF; color: #FFFFFF; border-color: #373b3e;}.table-responsive{overflow-x: auto; -webkit-overflow-scrolling: touch;}@media (max-width: 575.98px){.table-responsive-sm{overflow-x: auto; -webkit-overflow-scrolling: touch;}}@media (max-width: 767.98px){.table-responsive-md{overflow-x: auto; -webkit-overflow-scrolling: touch;}}@media (max-width: 991.98px){.table-responsive-lg{overflow-x: auto; -webkit-overflow-scrolling: touch;}}@media (max-width: 1199.98px){.table-responsive-xl{overflow-x: auto; -webkit-overflow-scrolling: touch;}}@media (max-width: 1399.98px){.table-responsive-xxl{overflow-x: auto; -webkit-overflow-scrolling: touch;}}.form-label{margin-bottom: 0.5rem;}.col-form-label{padding-top: calc(0.375rem + 1px); padding-bottom: calc(0.375rem + 1px); margin-bottom: 0; font-size: inherit; line-height: 1.5;}.col-form-label-lg{padding-top: calc(0.5rem + 1px); padding-bottom: calc(0.5rem + 1px); font-size: 1.09375rem;}.col-form-label-sm{padding-top: calc(0.25rem + 1px); padding-bottom: calc(0.25rem + 1px); font-size: 0.765625rem;}.form-text{margin-top: 0.25rem; font-size: 0.875em; color: #6C757D;}.form-control{display: block; width: 100%; padding: 0.375rem 0.75rem; font-size: 0.875rem; font-weight: 400; line-height: 1.5; color: #212529; background-color: #FFFFFF; background-clip: padding-box; border: 1px solid #CED4DA; -webkit-appearance: none; -moz-appearance: none; appearance: none; border-radius: 0.25rem; transition: background-color 0.05s ease-in-out, border-color 0.05s ease-in-out, box-shadow 0.05s ease-in-out;}@media (prefers-reduced-motion: reduce){.form-control{transition: none;}}.form-control[type="file"]{overflow: hidden;}.form-control[type="file"]:not(:disabled):not(.o_wysiwyg_loader):not([readonly]){cursor: pointer;}.form-control:focus{color: #212529; background-color: #FFFFFF; border-color: #b8a5b3; outline: 0; box-shadow: 0 0 0 0.25rem rgba(113, 75, 103, 0.25);}.form-control::-webkit-date-and-time-value{height: 1.5em;}.form-control::placeholder{color: #6C757D; opacity: 1;}.form-control:disabled, .form-control.o_wysiwyg_loader, .form-control[readonly]{background-color: #E9ECEF; opacity: 1;}.form-control::file-selector-button{padding: 0.375rem 0.75rem; margin: -0.375rem -0.75rem; margin-inline-end: 0.75rem; color: #212529; background-color: #E9ECEF; pointer-events: none; border-color: inherit; border-style: solid; border-width: 0; border-inline-end-width: 1px; border-radius: 0; transition: color 0.15s ease-in-out, background-color 0.15s ease-in-out, border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;}@media (prefers-reduced-motion: reduce){.form-control::file-selector-button{transition: none;}}.form-control:hover:not(:disabled):not(.o_wysiwyg_loader):not([readonly])::file-selector-button{background-color: #dde0e3;}.form-control::-webkit-file-upload-button{padding: 0.375rem 0.75rem; margin: -0.375rem -0.75rem; margin-inline-end: 0.75rem; color: #212529; background-color: #E9ECEF; pointer-events: none; border-color: inherit; border-style: solid; border-width: 0; border-inline-end-width: 1px; border-radius: 0; transition: color 0.15s ease-in-out, background-color 0.15s ease-in-out, border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;}@media (prefers-reduced-motion: reduce){.form-control::-webkit-file-upload-button{transition: none;}}.form-control:hover:not(:disabled):not(.o_wysiwyg_loader):not([readonly])::-webkit-file-upload-button{background-color: #dde0e3;}.form-control-plaintext{display: block; width: 100%; padding: 0.375rem 0; margin-bottom: 0; line-height: 1.5; color: #212529; background-color: transparent; border: solid transparent; border-width: 1px 0;}.form-control-plaintext.form-control-sm, .form-control-plaintext.form-control-lg{padding-right: 0; padding-left: 0;}.form-control-sm{min-height: calc(1.5em + 0.5rem + 2px); padding: 0.25rem 0.5rem; font-size: 0.765625rem; border-radius: 0.2rem;}.form-control-sm::file-selector-button{padding: 0.25rem 0.5rem; margin: -0.25rem -0.5rem; margin-inline-end: 0.5rem;}.form-control-sm::-webkit-file-upload-button{padding: 0.25rem 0.5rem; margin: -0.25rem -0.5rem; margin-inline-end: 0.5rem;}.form-control-lg{min-height: calc(1.5em + 1rem + 2px); padding: 0.5rem 1rem; font-size: 1.09375rem; border-radius: 0.3rem;}.form-control-lg::file-selector-button{padding: 0.5rem 1rem; margin: -0.5rem -1rem; margin-inline-end: 1rem;}.form-control-lg::-webkit-file-upload-button{padding: 0.5rem 1rem; margin: -0.5rem -1rem; margin-inline-end: 1rem;}textarea.form-control{min-height: calc(1.5em + 0.75rem + 2px);}textarea.form-control-sm{min-height: calc(1.5em + 0.5rem + 2px);}textarea.form-control-lg{min-height: calc(1.5em + 1rem + 2px);}.form-control-color{width: 3rem; height: auto; padding: 0.375rem;}.form-control-color:not(:disabled):not(.o_wysiwyg_loader):not([readonly]){cursor: pointer;}.form-control-color::-moz-color-swatch{height: 1.5em; border-radius: 0.25rem;}.form-control-color::-webkit-color-swatch{height: 1.5em; border-radius: 0.25rem;}.form-select{display: block; width: 100%; padding: 0.375rem 2.25rem 0.375rem 0.75rem; -moz-padding-start: calc(0.75rem - 3px); font-size: 0.875rem; font-weight: 400; line-height: 1.5; color: #212529; background-color: #FFFFFF; background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3e%3cpath fill='none' stroke='%23343A40' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='M2 5l6 6 6-6'/%3e%3c/svg%3e"); background-repeat: no-repeat; background-position: right 0.75rem center; background-size: 16px 12px; border: 1px solid #CED4DA; border-radius: 0.25rem; transition: background-color 0.05s ease-in-out, border-color 0.05s ease-in-out, box-shadow 0.05s ease-in-out; -webkit-appearance: none; -moz-appearance: none; appearance: none;}@media (prefers-reduced-motion: reduce){.form-select{transition: none;}}.form-select:focus{border-color: #b8a5b3; outline: 0; box-shadow: 0 0 0 0.25rem rgba(113, 75, 103, 0.25);}.form-select[multiple], .form-select[size]:not([size="1"]){padding-right: 0.75rem; background-image: none;}.form-select:disabled, .form-select.o_wysiwyg_loader{background-color: #E9ECEF;}.form-select:-moz-focusring{color: transparent; text-shadow: 0 0 0 #212529;}.form-select-sm{padding-top: 0.25rem; padding-bottom: 0.25rem; padding-left: 0.5rem; font-size: 0.765625rem; border-radius: 0.2rem;}.form-select-lg{padding-top: 0.5rem; padding-bottom: 0.5rem; padding-left: 1rem; font-size: 1.09375rem; border-radius: 0.3rem;}.form-check{display: block; min-height: 1.3125rem; padding-left: 1.5em; margin-bottom: 0.125rem;}.form-check .form-check-input{float: left; margin-left: -1.5em;}.form-check-input{width: 1em; height: 1em; margin-top: 0.25em; vertical-align: top; background-color: #FFFFFF; background-repeat: no-repeat; background-position: center; background-size: contain; border: 1px solid #CED4DA; -webkit-appearance: none; -moz-appearance: none; appearance: none; color-adjust: exact;}.form-check-input[type="checkbox"]{border-radius: 0;}.form-check-input[type="radio"]{border-radius: 50%;}.form-check-input:active{filter: brightness(90%);}.form-check-input:focus{border-color: #b8a5b3; outline: 0; box-shadow: 0 0 0 0.25rem rgba(113, 75, 103, 0.25);}.form-check-input:checked{background-color: #714B67; border-color: #714B67;}.form-check-input:checked[type="checkbox"]{background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 20 20'%3e%3cpath fill='none' stroke='%23FFFFFF' stroke-linecap='round' stroke-linejoin='round' stroke-width='3' d='M6 10l3 3l6-6'/%3e%3c/svg%3e");}.form-check-input:checked[type="radio"]{background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='-4 -4 8 8'%3e%3ccircle r='2' fill='%23FFFFFF'/%3e%3c/svg%3e");}.form-check-input[type="checkbox"]:indeterminate{background-color: #714B67; border-color: #714B67; background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 20 20'%3e%3cpath fill='none' stroke='%23FFFFFF' stroke-linecap='round' stroke-linejoin='round' stroke-width='3' d='M6 10h8'/%3e%3c/svg%3e");}.form-check-input:disabled, .form-check-input.o_wysiwyg_loader{pointer-events: none; filter: none; opacity: 0.5;}.form-check-input[disabled] ~ .form-check-label, .form-check-input:disabled ~ .form-check-label, .form-check-input.o_wysiwyg_loader ~ .form-check-label{opacity: 0.5;}.form-switch{padding-left: 2.5em;}.form-switch .form-check-input{width: 2em; margin-left: -2.5em; background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='-4 -4 8 8'%3e%3ccircle r='3' fill='rgba%280, 0, 0, 0.25%29'/%3e%3c/svg%3e"); background-position: left center; border-radius: 2em; transition: background-position 0.15s ease-in-out;}@media (prefers-reduced-motion: reduce){.form-switch .form-check-input{transition: none;}}.form-switch .form-check-input:focus{background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='-4 -4 8 8'%3e%3ccircle r='3' fill='%23b8a5b3'/%3e%3c/svg%3e");}.form-switch .form-check-input:checked{background-position: right center; background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='-4 -4 8 8'%3e%3ccircle r='3' fill='%23FFFFFF'/%3e%3c/svg%3e");}.form-check-inline{display: inline-block; margin-right: 1rem;}.btn-check{position: absolute; clip: rect(0, 0, 0, 0); pointer-events: none;}.btn-check[disabled] + .btn, .btn-check:disabled + .btn, .btn-check.o_wysiwyg_loader + .btn{pointer-events: none; filter: none; opacity: 0.65;}.form-range{width: 100%; height: 1.5rem; padding: 0; background-color: transparent; -webkit-appearance: none; -moz-appearance: none; appearance: none;}.form-range:focus{outline: 0;}.form-range:focus::-webkit-slider-thumb{box-shadow: 0 0 0 1px #FFFFFF, 0 0 0 0.25rem rgba(113, 75, 103, 0.25);}.form-range:focus::-moz-range-thumb{box-shadow: 0 0 0 1px #FFFFFF, 0 0 0 0.25rem rgba(113, 75, 103, 0.25);}.form-range::-moz-focus-outer{border: 0;}.form-range::-webkit-slider-thumb{width: 1rem; height: 1rem; margin-top: -0.45rem; background-color: #FFFFFF; border: 1px solid #714B67; border-radius: 1rem; transition: background-color 0.15s ease-in-out, border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out; -webkit-appearance: none; -moz-appearance: none; appearance: none;}@media (prefers-reduced-motion: reduce){.form-range::-webkit-slider-thumb{transition: none;}}.form-range::-webkit-slider-thumb:active{background-color: #714B67;}.form-range::-webkit-slider-runnable-track{width: 100%; height: 0.1rem; color: transparent; cursor: pointer; background-color: #DEE2E6; border-color: transparent; border-radius: 1rem;}.form-range::-moz-range-thumb{width: 1rem; height: 1rem; background-color: #FFFFFF; border: 1px solid #714B67; border-radius: 1rem; transition: background-color 0.15s ease-in-out, border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out; -webkit-appearance: none; -moz-appearance: none; appearance: none;}@media (prefers-reduced-motion: reduce){.form-range::-moz-range-thumb{transition: none;}}.form-range::-moz-range-thumb:active{background-color: #714B67;}.form-range::-moz-range-track{width: 100%; height: 0.1rem; color: transparent; cursor: pointer; background-color: #DEE2E6; border-color: transparent; border-radius: 1rem;}.form-range:disabled, .form-range.o_wysiwyg_loader{pointer-events: none;}.form-range:disabled::-webkit-slider-thumb, .form-range.o_wysiwyg_loader::-webkit-slider-thumb{background-color: #ADB5BD;}.form-range:disabled::-moz-range-thumb, .form-range.o_wysiwyg_loader::-moz-range-thumb{background-color: #ADB5BD;}.form-floating{position: relative;}.form-floating > .form-control, .form-floating > .form-select{height: calc(3.5rem + 2px); line-height: 1.25;}.form-floating > label{position: absolute; top: 0; left: 0; height: 100%; padding: 1rem 0.75rem; pointer-events: none; border: 1px solid transparent; transform-origin: 0 0; transition: opacity 0.1s ease-in-out, transform 0.1s ease-in-out;}@media (prefers-reduced-motion: reduce){.form-floating > label{transition: none;}}.form-floating > .form-control{padding: 1rem 0.75rem;}.form-floating > .form-control::placeholder{color: transparent;}.form-floating > .form-control:focus, .form-floating > .form-control:not(:placeholder-shown){padding-top: 1.625rem; padding-bottom: 0.625rem;}.form-floating > .form-control:-webkit-autofill{padding-top: 1.625rem; padding-bottom: 0.625rem;}.form-floating > .form-select{padding-top: 1.625rem; padding-bottom: 0.625rem;}.form-floating > .form-control:focus ~ label, .form-floating > .form-control:not(:placeholder-shown) ~ label, .form-floating > .form-select ~ label{opacity: 0.65; transform: scale(0.85) translateY(-0.5rem) translateX(0.15rem);}.form-floating > .form-control:-webkit-autofill ~ label{opacity: 0.65; transform: scale(0.85) translateY(-0.5rem) translateX(0.15rem);}.input-group{position: relative; display: -webkit-box; display: -webkit-flex; display: flex; -webkit-flex-wrap: wrap; flex-wrap: wrap; align-items: stretch; width: 100%;}.input-group > .form-control, .input-group > .form-select{position: relative; -webkit-box-flex: 1; -webkit-flex: 1 1 auto; flex: 1 1 auto; width: 1%; min-width: 0;}.input-group > .form-control:focus, .input-group > .form-select:focus{z-index: 3;}.input-group .btn{position: relative; z-index: 2;}.input-group .btn:focus{z-index: 3;}.input-group-text{display: -webkit-box; display: -webkit-flex; display: flex; align-items: center; padding: 0.375rem 0.75rem; font-size: 0.875rem; font-weight: 400; line-height: 1.5; color: #212529; text-align: center; white-space: nowrap; background-color: #E9ECEF; border: 1px solid #CED4DA; border-radius: 0.25rem;}.input-group-lg > .form-control, .input-group-lg > .form-select, .input-group-lg > .input-group-text, .input-group-lg > .btn{padding: 0.5rem 1rem; font-size: 1.09375rem; border-radius: 0.3rem;}.input-group-sm > .form-control, .input-group-sm > .form-select, .input-group-sm > .input-group-text, .input-group-sm > .btn{padding: 0.25rem 0.5rem; font-size: 0.765625rem; border-radius: 0.2rem;}.input-group-lg > .form-select, .input-group-sm > .form-select{padding-right: 3rem;}.input-group:not(.has-validation) > :not(:last-child):not(.dropdown-toggle):not(.dropdown-menu), .input-group:not(.has-validation) > .dropdown-toggle:nth-last-child(n + 3){border-top-right-radius: 0; border-bottom-right-radius: 0;}.input-group.has-validation > :nth-last-child(n + 3):not(.dropdown-toggle):not(.dropdown-menu), .input-group.has-validation > .dropdown-toggle:nth-last-child(n + 4){border-top-right-radius: 0; border-bottom-right-radius: 0;}.input-group > :not(:first-child):not(.dropdown-menu):not(.valid-tooltip):not(.valid-feedback):not(.invalid-tooltip):not(.invalid-feedback){margin-left: -1px; border-top-left-radius: 0; border-bottom-left-radius: 0;}.valid-feedback{display: none; width: 100%; margin-top: 0.25rem; font-size: 0.875em; color: #198754;}.valid-tooltip{position: absolute; top: 100%; z-index: 5; display: none; max-width: 100%; padding: 0.25rem 0.5rem; margin-top: .1rem; font-size: 0.765625rem; color: #FFFFFF; background-color: rgba(25, 135, 84, 0.9); border-radius: 0.25rem;}.was-validated :valid ~ .valid-feedback, .was-validated :valid ~ .valid-tooltip, .is-valid ~ .valid-feedback, .is-valid ~ .valid-tooltip{display: block;}.was-validated .form-control:valid, .form-control.is-valid{border-color: #198754; padding-right: calc(1.5em + 0.75rem); background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 8 8'%3e%3cpath fill='%23198754' d='M2.3 6.73L.6 4.53c-.4-1.04.46-1.4 1.1-.8l1.1 1.4 3.4-3.8c.6-.63 1.6-.27 1.2.7l-4 4.6c-.43.5-.8.4-1.1.1z'/%3e%3c/svg%3e"); background-repeat: no-repeat; background-position: right calc(0.375em + 0.1875rem) center; background-size: calc(0.75em + 0.375rem) calc(0.75em + 0.375rem);}.was-validated .form-control:valid:focus, .form-control.is-valid:focus{border-color: #198754; box-shadow: 0 0 0 0.25rem rgba(25, 135, 84, 0.25);}.was-validated textarea.form-control:valid, textarea.form-control.is-valid{padding-right: calc(1.5em + 0.75rem); background-position: top calc(0.375em + 0.1875rem) right calc(0.375em + 0.1875rem);}.was-validated .form-select:valid, .form-select.is-valid{border-color: #198754;}.was-validated .form-select:valid:not([multiple]):not([size]), .was-validated .form-select:valid:not([multiple])[size="1"], .form-select.is-valid:not([multiple]):not([size]), .form-select.is-valid:not([multiple])[size="1"]{padding-right: 4.125rem; background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3e%3cpath fill='none' stroke='%23343A40' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='M2 5l6 6 6-6'/%3e%3c/svg%3e"), url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 8 8'%3e%3cpath fill='%23198754' d='M2.3 6.73L.6 4.53c-.4-1.04.46-1.4 1.1-.8l1.1 1.4 3.4-3.8c.6-.63 1.6-.27 1.2.7l-4 4.6c-.43.5-.8.4-1.1.1z'/%3e%3c/svg%3e"); background-position: right 0.75rem center, center right 2.25rem; background-size: 16px 12px, calc(0.75em + 0.375rem) calc(0.75em + 0.375rem);}.was-validated .form-select:valid:focus, .form-select.is-valid:focus{border-color: #198754; box-shadow: 0 0 0 0.25rem rgba(25, 135, 84, 0.25);}.was-validated .form-check-input:valid, .form-check-input.is-valid{border-color: #198754;}.was-validated .form-check-input:valid:checked, .form-check-input.is-valid:checked{background-color: #198754;}.was-validated .form-check-input:valid:focus, .form-check-input.is-valid:focus{box-shadow: 0 0 0 0.25rem rgba(25, 135, 84, 0.25);}.was-validated .form-check-input:valid ~ .form-check-label, .form-check-input.is-valid ~ .form-check-label{color: #198754;}.form-check-inline .form-check-input ~ .valid-feedback{margin-left: .5em;}.was-validated .input-group .form-control:valid, .input-group .form-control.is-valid, .was-validated .input-group .form-select:valid, .input-group .form-select.is-valid{z-index: 1;}.was-validated .input-group .form-control:valid:focus, .input-group .form-control.is-valid:focus, .was-validated .input-group .form-select:valid:focus, .input-group .form-select.is-valid:focus{z-index: 3;}.invalid-feedback{display: none; width: 100%; margin-top: 0.25rem; font-size: 0.875em; color: #dc3545;}.invalid-tooltip{position: absolute; top: 100%; z-index: 5; display: none; max-width: 100%; padding: 0.25rem 0.5rem; margin-top: .1rem; font-size: 0.765625rem; color: #FFFFFF; background-color: rgba(220, 53, 69, 0.9); border-radius: 0.25rem;}.was-validated :invalid ~ .invalid-feedback, .was-validated :invalid ~ .invalid-tooltip, .is-invalid ~ .invalid-feedback, .is-invalid ~ .invalid-tooltip{display: block;}.was-validated .form-control:invalid, .form-control.is-invalid{border-color: #dc3545; padding-right: calc(1.5em + 0.75rem); background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 12 12' width='12' height='12' fill='none' stroke='%23dc3545'%3e%3ccircle cx='6' cy='6' r='4.5'/%3e%3cpath stroke-linejoin='round' d='M5.8 3.6h.4L6 6.5z'/%3e%3ccircle cx='6' cy='8.2' r='.6' fill='%23dc3545' stroke='none'/%3e%3c/svg%3e"); background-repeat: no-repeat; background-position: right calc(0.375em + 0.1875rem) center; background-size: calc(0.75em + 0.375rem) calc(0.75em + 0.375rem);}.was-validated .form-control:invalid:focus, .form-control.is-invalid:focus{border-color: #dc3545; box-shadow: 0 0 0 0.25rem rgba(220, 53, 69, 0.25);}.was-validated textarea.form-control:invalid, textarea.form-control.is-invalid{padding-right: calc(1.5em + 0.75rem); background-position: top calc(0.375em + 0.1875rem) right calc(0.375em + 0.1875rem);}.was-validated .form-select:invalid, .form-select.is-invalid{border-color: #dc3545;}.was-validated .form-select:invalid:not([multiple]):not([size]), .was-validated .form-select:invalid:not([multiple])[size="1"], .form-select.is-invalid:not([multiple]):not([size]), .form-select.is-invalid:not([multiple])[size="1"]{padding-right: 4.125rem; background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3e%3cpath fill='none' stroke='%23343A40' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='M2 5l6 6 6-6'/%3e%3c/svg%3e"), url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 12 12' width='12' height='12' fill='none' stroke='%23dc3545'%3e%3ccircle cx='6' cy='6' r='4.5'/%3e%3cpath stroke-linejoin='round' d='M5.8 3.6h.4L6 6.5z'/%3e%3ccircle cx='6' cy='8.2' r='.6' fill='%23dc3545' stroke='none'/%3e%3c/svg%3e"); background-position: right 0.75rem center, center right 2.25rem; background-size: 16px 12px, calc(0.75em + 0.375rem) calc(0.75em + 0.375rem);}.was-validated .form-select:invalid:focus, .form-select.is-invalid:focus{border-color: #dc3545; box-shadow: 0 0 0 0.25rem rgba(220, 53, 69, 0.25);}.was-validated .form-check-input:invalid, .form-check-input.is-invalid{border-color: #dc3545;}.was-validated .form-check-input:invalid:checked, .form-check-input.is-invalid:checked{background-color: #dc3545;}.was-validated .form-check-input:invalid:focus, .form-check-input.is-invalid:focus{box-shadow: 0 0 0 0.25rem rgba(220, 53, 69, 0.25);}.was-validated .form-check-input:invalid ~ .form-check-label, .form-check-input.is-invalid ~ .form-check-label{color: #dc3545;}.form-check-inline .form-check-input ~ .invalid-feedback{margin-left: .5em;}.was-validated .input-group .form-control:invalid, .input-group .form-control.is-invalid, .was-validated .input-group .form-select:invalid, .input-group .form-select.is-invalid{z-index: 2;}.was-validated .input-group .form-control:invalid:focus, .input-group .form-control.is-invalid:focus, .was-validated .input-group .form-select:invalid:focus, .input-group .form-select.is-invalid:focus{z-index: 3;}.btn{display: inline-block; font-weight: 400; line-height: 1.5; color: #212529; text-align: center; vertical-align: middle; cursor: pointer; user-select: none; background-color: transparent; border: 1px solid transparent; padding: 0.375rem 0.75rem; font-size: 0.875rem; border-radius: 0.25rem; transition: color 0.15s ease-in-out, background-color 0.15s ease-in-out, border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;}@media (prefers-reduced-motion: reduce){.btn{transition: none;}}.btn:hover{color: #212529;}.btn-check:focus + .btn, .btn:focus{outline: 0; box-shadow: 0 0 0 0.25rem rgba(113, 75, 103, 0.25);}.btn:disabled, .btn.o_wysiwyg_loader, .btn.disabled, fieldset:disabled .btn, fieldset.o_wysiwyg_loader .btn{pointer-events: none; opacity: 0.65;}.btn-link{font-weight: 400; color: #714B67; text-decoration: none;}.btn-link:hover{color: #5a3c52;}.btn-link:disabled, .btn-link.o_wysiwyg_loader, .btn-link.disabled{color: #6C757D;}.btn-lg, .btn-group-lg > .btn{padding: 0.5rem 1rem; font-size: 1.09375rem; border-radius: 0.3rem;}.btn-sm, .btn-group-sm > .btn{padding: 0.25rem 0.5rem; font-size: 0.765625rem; border-radius: 0.2rem;}.fade{transition: opacity 0.15s linear;}@media (prefers-reduced-motion: reduce){.fade{transition: none;}}.fade:not(.show){opacity: 0;}.collapse:not(.show){display: none;}.collapsing{height: 0; overflow: hidden; transition: height 0.35s ease;}@media (prefers-reduced-motion: reduce){.collapsing{transition: none;}}.collapsing.collapse-horizontal{width: 0; height: auto; transition: width 0.35s ease;}@media (prefers-reduced-motion: reduce){.collapsing.collapse-horizontal{transition: none;}}.dropup, .dropend, .dropdown, .dropstart{position: relative;}.dropdown-toggle{white-space: nowrap;}.dropdown-toggle::after{display: inline-block; margin-left: 0.255em; vertical-align: 0.255em; content: ""; border-top: 0.3em solid; border-right: 0.3em solid transparent; border-bottom: 0; border-left: 0.3em solid transparent;}.dropdown-toggle:empty::after{margin-left: 0;}.dropdown-menu{position: absolute; z-index: 1000; display: none; min-width: 10rem; padding: 0.5rem 0; margin: 0; font-size: 0.875rem; color: #212529; text-align: left; list-style: none; background-color: #FFFFFF; background-clip: padding-box; border: 1px solid rgba(0, 0, 0, 0.15); border-radius: 0.25rem;}.dropdown-menu[data-bs-popper]{top: 100%; left: 0; margin-top: 0.125rem;}.dropdown-menu-start{--bs-position: start;}.dropdown-menu-start[data-bs-popper]{right: auto; left: 0;}.dropdown-menu-end{--bs-position: end;}.dropdown-menu-end[data-bs-popper]{right: 0; left: auto;}@media (min-width: 576px){.dropdown-menu-sm-start{--bs-position: start;}.dropdown-menu-sm-start[data-bs-popper]{right: auto; left: 0;}.dropdown-menu-sm-end{--bs-position: end;}.dropdown-menu-sm-end[data-bs-popper]{right: 0; left: auto;}}@media (min-width: 768px){.dropdown-menu-md-start{--bs-position: start;}.dropdown-menu-md-start[data-bs-popper]{right: auto; left: 0;}.dropdown-menu-md-end{--bs-position: end;}.dropdown-menu-md-end[data-bs-popper]{right: 0; left: auto;}}@media (min-width: 992px){.dropdown-menu-lg-start{--bs-position: start;}.dropdown-menu-lg-start[data-bs-popper]{right: auto; left: 0;}.dropdown-menu-lg-end{--bs-position: end;}.dropdown-menu-lg-end[data-bs-popper]{right: 0; left: auto;}}@media (min-width: 1200px){.dropdown-menu-xl-start{--bs-position: start;}.dropdown-menu-xl-start[data-bs-popper]{right: auto; left: 0;}.dropdown-menu-xl-end{--bs-position: end;}.dropdown-menu-xl-end[data-bs-popper]{right: 0; left: auto;}}@media (min-width: 1400px){.dropdown-menu-xxl-start{--bs-position: start;}.dropdown-menu-xxl-start[data-bs-popper]{right: auto; left: 0;}.dropdown-menu-xxl-end{--bs-position: end;}.dropdown-menu-xxl-end[data-bs-popper]{right: 0; left: auto;}}.dropup .dropdown-menu[data-bs-popper]{top: auto; bottom: 100%; margin-top: 0; margin-bottom: 0.125rem;}.dropup .dropdown-toggle::after{display: inline-block; margin-left: 0.255em; vertical-align: 0.255em; content: ""; border-top: 0; border-right: 0.3em solid transparent; border-bottom: 0.3em solid; border-left: 0.3em solid transparent;}.dropup .dropdown-toggle:empty::after{margin-left: 0;}.dropend .dropdown-menu[data-bs-popper]{top: 0; right: auto; left: 100%; margin-top: 0; margin-left: 0.125rem;}.dropend .dropdown-toggle::after{display: inline-block; margin-left: 0.255em; vertical-align: 0.255em; content: ""; border-top: 0.3em solid transparent; border-right: 0; border-bottom: 0.3em solid transparent; border-left: 0.3em solid;}.dropend .dropdown-toggle:empty::after{margin-left: 0;}.dropend .dropdown-toggle::after{vertical-align: 0;}.dropstart .dropdown-menu[data-bs-popper]{top: 0; right: 100%; left: auto; margin-top: 0; margin-right: 0.125rem;}.dropstart .dropdown-toggle::after{display: inline-block; margin-left: 0.255em; vertical-align: 0.255em; content: "";}.dropstart .dropdown-toggle::after{display: none;}.dropstart .dropdown-toggle::before{display: inline-block; margin-right: 0.255em; vertical-align: 0.255em; content: ""; border-top: 0.3em solid transparent; border-right: 0.3em solid; border-bottom: 0.3em solid transparent;}.dropstart .dropdown-toggle:empty::after{margin-left: 0;}.dropstart .dropdown-toggle::before{vertical-align: 0;}.dropdown-divider{height: 0; margin: 0.5rem 0; overflow: hidden; border-top: 1px solid rgba(0, 0, 0, 0.15);}.dropdown-item{display: block; width: 100%; padding: 0.25rem 1rem; clear: both; font-weight: 400; color: #212529; text-align: inherit; white-space: nowrap; background-color: transparent; border: 0;}.dropdown-item:hover, .dropdown-item:focus{color: #1e2125; background-color: #E9ECEF;}.dropdown-item.active, .dropdown-item:active{color: #FFFFFF; text-decoration: none; background-color: #714B67;}.dropdown-item.disabled, .dropdown-item:disabled, .dropdown-item.o_wysiwyg_loader{color: #ADB5BD; pointer-events: none; background-color: transparent;}.dropdown-menu.show{display: block;}.dropdown-header{display: block; padding: 0.5rem 1rem; margin-bottom: 0; font-size: 0.765625rem; color: #6C757D; white-space: nowrap;}.dropdown-item-text{display: block; padding: 0.25rem 1rem; color: #212529;}.dropdown-menu-dark{color: #DEE2E6; background-color: #343A40; border-color: rgba(0, 0, 0, 0.15);}.dropdown-menu-dark .dropdown-item{color: #DEE2E6;}.dropdown-menu-dark .dropdown-item:hover, .dropdown-menu-dark .dropdown-item:focus{color: #FFFFFF; background-color: rgba(255, 255, 255, 0.15);}.dropdown-menu-dark .dropdown-item.active, .dropdown-menu-dark .dropdown-item:active{color: #FFFFFF; background-color: #714B67;}.dropdown-menu-dark .dropdown-item.disabled, .dropdown-menu-dark .dropdown-item:disabled, .dropdown-menu-dark .dropdown-item.o_wysiwyg_loader{color: #ADB5BD;}.dropdown-menu-dark .dropdown-divider{border-color: rgba(0, 0, 0, 0.15);}.dropdown-menu-dark .dropdown-item-text{color: #DEE2E6;}.dropdown-menu-dark .dropdown-header{color: #ADB5BD;}.btn-group, .btn-group-vertical{position: relative; display: -webkit-inline-box; display: -webkit-inline-flex; display: inline-flex; vertical-align: middle;}.btn-group > .btn, .btn-group-vertical > .btn{position: relative; -webkit-box-flex: 1; -webkit-flex: 1 1 auto; flex: 1 1 auto;}.btn-group > .btn-check:checked + .btn, .btn-group > .btn-check:focus + .btn, .btn-group > .btn:hover, .btn-group > .btn:focus, .btn-group > .btn:active, .btn-group > .btn.active, .btn-group-vertical > .btn-check:checked + .btn, .btn-group-vertical > .btn-check:focus + .btn, .btn-group-vertical > .btn:hover, .btn-group-vertical > .btn:focus, .btn-group-vertical > .btn:active, .btn-group-vertical > .btn.active{z-index: 1;}.btn-toolbar{display: -webkit-box; display: -webkit-flex; display: flex; -webkit-flex-wrap: wrap; flex-wrap: wrap; -webkit-box-pack: start; justify-content: flex-start;}.btn-toolbar .input-group{width: auto;}.btn-group > .btn:not(:first-child), .btn-group > .btn-group:not(:first-child){margin-left: -1px;}.btn-group > .btn:not(:last-child):not(.dropdown-toggle), .btn-group > .btn-group:not(:last-child) > .btn{border-top-right-radius: 0; border-bottom-right-radius: 0;}.btn-group > .btn:nth-child(n + 3), .btn-group > :not(.btn-check) + .btn, .btn-group > .btn-group:not(:first-child) > .btn{border-top-left-radius: 0; border-bottom-left-radius: 0;}.dropdown-toggle-split{padding-right: 0.5625rem; padding-left: 0.5625rem;}.dropdown-toggle-split::after, .dropup .dropdown-toggle-split::after, .dropend .dropdown-toggle-split::after{margin-left: 0;}.dropstart .dropdown-toggle-split::before{margin-right: 0;}.btn-sm + .dropdown-toggle-split, .btn-group-sm > .btn + .dropdown-toggle-split{padding-right: 0.375rem; padding-left: 0.375rem;}.btn-lg + .dropdown-toggle-split, .btn-group-lg > .btn + .dropdown-toggle-split{padding-right: 0.75rem; padding-left: 0.75rem;}.btn-group-vertical{-webkit-box-orient: vertical; -webkit-box-direction: normal; -webkit-flex-direction: column; flex-direction: column; align-items: flex-start; justify-content: center;}.btn-group-vertical > .btn, .btn-group-vertical > .btn-group{width: 100%;}.btn-group-vertical > .btn:not(:first-child), .btn-group-vertical > .btn-group:not(:first-child){margin-top: -1px;}.btn-group-vertical > .btn:not(:last-child):not(.dropdown-toggle), .btn-group-vertical > .btn-group:not(:last-child) > .btn{border-bottom-right-radius: 0; border-bottom-left-radius: 0;}.btn-group-vertical > .btn ~ .btn, .btn-group-vertical > .btn-group:not(:first-child) > .btn{border-top-left-radius: 0; border-top-right-radius: 0;}.nav{display: -webkit-box; display: -webkit-flex; display: flex; -webkit-flex-wrap: wrap; flex-wrap: wrap; padding-left: 0; margin-bottom: 0; list-style: none;}.nav-link{display: block; padding: 0.5rem 1rem; color: #714B67; transition: color 0.15s ease-in-out, background-color 0.15s ease-in-out, border-color 0.15s ease-in-out;}@media (prefers-reduced-motion: reduce){.nav-link{transition: none;}}.nav-link:hover, .nav-link:focus{color: #5a3c52;}.nav-link.disabled{color: #6C757D; pointer-events: none; cursor: default;}.nav-tabs{border-bottom: 1px solid #DEE2E6;}.nav-tabs .nav-link{margin-bottom: -1px; background: none; border: 1px solid transparent; border-top-left-radius: 0.25rem; border-top-right-radius: 0.25rem;}.nav-tabs .nav-link:hover, .nav-tabs .nav-link:focus{border-color: #E9ECEF #E9ECEF #DEE2E6; isolation: isolate;}.nav-tabs .nav-link.disabled{color: #6C757D; background-color: transparent; border-color: transparent;}.nav-tabs .nav-link.active, .nav-tabs .nav-item.show .nav-link{color: #495057; background-color: #FFFFFF; border-color: #DEE2E6 #DEE2E6 #FFFFFF;}.nav-tabs .dropdown-menu{margin-top: -1px; border-top-left-radius: 0; border-top-right-radius: 0;}.nav-pills .nav-link{background: none; border: 0; border-radius: 0.25rem;}.nav-pills .nav-link.active, .nav-pills .show > .nav-link{color: #FFFFFF; background-color: #714B67;}.nav-fill > .nav-link, .nav-fill .nav-item{-webkit-box-flex: 1; -webkit-flex: 1 1 auto; flex: 1 1 auto; text-align: center;}.nav-justified > .nav-link, .nav-justified .nav-item{flex-basis: 0; flex-grow: 1; text-align: center;}.nav-fill .nav-item .nav-link, .nav-justified .nav-item .nav-link{width: 100%;}.tab-content > .tab-pane{display: none;}.tab-content > .active{display: block;}.navbar{position: relative; display: -webkit-box; display: -webkit-flex; display: flex; -webkit-flex-wrap: wrap; flex-wrap: wrap; align-items: center; justify-content: space-between; padding-top: 0.5rem; padding-bottom: 0.5rem;}.navbar > .container, .navbar > .o_container_small, .navbar > .container-fluid, .navbar > .container-sm, .navbar > .container-md, .navbar > .container-lg, .navbar > .container-xl, .navbar > .container-xxl{display: -webkit-box; display: -webkit-flex; display: flex; -webkit-flex-wrap: inherit; flex-wrap: inherit; align-items: center; justify-content: space-between;}.navbar-brand{padding-top: 0.3359375rem; padding-bottom: 0.3359375rem; margin-right: 1rem; font-size: 1.09375rem; white-space: nowrap;}.navbar-nav{display: -webkit-box; display: -webkit-flex; display: flex; -webkit-box-orient: vertical; -webkit-box-direction: normal; -webkit-flex-direction: column; flex-direction: column; padding-left: 0; margin-bottom: 0; list-style: none;}.navbar-nav .nav-link{padding-right: 0; padding-left: 0;}.navbar-nav .dropdown-menu{position: static;}.navbar-text{padding-top: 0.5rem; padding-bottom: 0.5rem;}.navbar-collapse{flex-basis: 100%; flex-grow: 1; align-items: center;}.navbar-toggler{padding: 0.25rem 0.75rem; font-size: 1.09375rem; line-height: 1; background-color: transparent; border: 1px solid transparent; border-radius: 0.25rem; transition: box-shadow 0.15s ease-in-out;}@media (prefers-reduced-motion: reduce){.navbar-toggler{transition: none;}}.navbar-toggler:hover{text-decoration: none;}.navbar-toggler:focus{text-decoration: none; outline: 0; box-shadow: 0 0 0 0.25rem;}.navbar-toggler-icon{display: inline-block; width: 1.5em; height: 1.5em; vertical-align: middle; background-repeat: no-repeat; background-position: center; background-size: 100%;}.navbar-nav-scroll{max-height: var(--bs-scroll-height, 75vh); overflow-y: auto;}@media (min-width: 576px){.navbar-expand-sm{-webkit-flex-wrap: nowrap; flex-wrap: nowrap; -webkit-box-pack: start; justify-content: flex-start;}.navbar-expand-sm .navbar-nav{flex-direction: row;}.navbar-expand-sm .navbar-nav .dropdown-menu{position: absolute;}.navbar-expand-sm .navbar-nav .nav-link{padding-right: 0.5rem; padding-left: 0.5rem;}.navbar-expand-sm .navbar-nav-scroll{overflow: visible;}.navbar-expand-sm .navbar-collapse{display: -webkit-box !important; display: -webkit-flex !important; display: flex !important; flex-basis: auto;}.navbar-expand-sm .navbar-toggler{display: none;}.navbar-expand-sm .offcanvas-header{display: none;}.navbar-expand-sm .offcanvas{position: inherit; bottom: 0; z-index: 1000; flex-grow: 1; visibility: visible !important; background-color: transparent; border-right: 0; border-left: 0; transition: none; transform: none;}.navbar-expand-sm .offcanvas-top, .navbar-expand-sm .offcanvas-bottom{height: auto; border-top: 0; border-bottom: 0;}.navbar-expand-sm .offcanvas-body{display: -webkit-box; display: -webkit-flex; display: flex; flex-grow: 0; padding: 0; overflow-y: visible;}}@media (min-width: 768px){.navbar-expand-md{-webkit-flex-wrap: nowrap; flex-wrap: nowrap; -webkit-box-pack: start; justify-content: flex-start;}.navbar-expand-md .navbar-nav{flex-direction: row;}.navbar-expand-md .navbar-nav .dropdown-menu{position: absolute;}.navbar-expand-md .navbar-nav .nav-link{padding-right: 0.5rem; padding-left: 0.5rem;}.navbar-expand-md .navbar-nav-scroll{overflow: visible;}.navbar-expand-md .navbar-collapse{display: -webkit-box !important; display: -webkit-flex !important; display: flex !important; flex-basis: auto;}.navbar-expand-md .navbar-toggler{display: none;}.navbar-expand-md .offcanvas-header{display: none;}.navbar-expand-md .offcanvas{position: inherit; bottom: 0; z-index: 1000; flex-grow: 1; visibility: visible !important; background-color: transparent; border-right: 0; border-left: 0; transition: none; transform: none;}.navbar-expand-md .offcanvas-top, .navbar-expand-md .offcanvas-bottom{height: auto; border-top: 0; border-bottom: 0;}.navbar-expand-md .offcanvas-body{display: -webkit-box; display: -webkit-flex; display: flex; flex-grow: 0; padding: 0; overflow-y: visible;}}@media (min-width: 992px){.navbar-expand-lg{-webkit-flex-wrap: nowrap; flex-wrap: nowrap; -webkit-box-pack: start; justify-content: flex-start;}.navbar-expand-lg .navbar-nav{flex-direction: row;}.navbar-expand-lg .navbar-nav .dropdown-menu{position: absolute;}.navbar-expand-lg .navbar-nav .nav-link{padding-right: 0.5rem; padding-left: 0.5rem;}.navbar-expand-lg .navbar-nav-scroll{overflow: visible;}.navbar-expand-lg .navbar-collapse{display: -webkit-box !important; display: -webkit-flex !important; display: flex !important; flex-basis: auto;}.navbar-expand-lg .navbar-toggler{display: none;}.navbar-expand-lg .offcanvas-header{display: none;}.navbar-expand-lg .offcanvas{position: inherit; bottom: 0; z-index: 1000; flex-grow: 1; visibility: visible !important; background-color: transparent; border-right: 0; border-left: 0; transition: none; transform: none;}.navbar-expand-lg .offcanvas-top, .navbar-expand-lg .offcanvas-bottom{height: auto; border-top: 0; border-bottom: 0;}.navbar-expand-lg .offcanvas-body{display: -webkit-box; display: -webkit-flex; display: flex; flex-grow: 0; padding: 0; overflow-y: visible;}}@media (min-width: 1200px){.navbar-expand-xl{-webkit-flex-wrap: nowrap; flex-wrap: nowrap; -webkit-box-pack: start; justify-content: flex-start;}.navbar-expand-xl .navbar-nav{flex-direction: row;}.navbar-expand-xl .navbar-nav .dropdown-menu{position: absolute;}.navbar-expand-xl .navbar-nav .nav-link{padding-right: 0.5rem; padding-left: 0.5rem;}.navbar-expand-xl .navbar-nav-scroll{overflow: visible;}.navbar-expand-xl .navbar-collapse{display: -webkit-box !important; display: -webkit-flex !important; display: flex !important; flex-basis: auto;}.navbar-expand-xl .navbar-toggler{display: none;}.navbar-expand-xl .offcanvas-header{display: none;}.navbar-expand-xl .offcanvas{position: inherit; bottom: 0; z-index: 1000; flex-grow: 1; visibility: visible !important; background-color: transparent; border-right: 0; border-left: 0; transition: none; transform: none;}.navbar-expand-xl .offcanvas-top, .navbar-expand-xl .offcanvas-bottom{height: auto; border-top: 0; border-bottom: 0;}.navbar-expand-xl .offcanvas-body{display: -webkit-box; display: -webkit-flex; display: flex; flex-grow: 0; padding: 0; overflow-y: visible;}}@media (min-width: 1400px){.navbar-expand-xxl{-webkit-flex-wrap: nowrap; flex-wrap: nowrap; -webkit-box-pack: start; justify-content: flex-start;}.navbar-expand-xxl .navbar-nav{flex-direction: row;}.navbar-expand-xxl .navbar-nav .dropdown-menu{position: absolute;}.navbar-expand-xxl .navbar-nav .nav-link{padding-right: 0.5rem; padding-left: 0.5rem;}.navbar-expand-xxl .navbar-nav-scroll{overflow: visible;}.navbar-expand-xxl .navbar-collapse{display: -webkit-box !important; display: -webkit-flex !important; display: flex !important; flex-basis: auto;}.navbar-expand-xxl .navbar-toggler{display: none;}.navbar-expand-xxl .offcanvas-header{display: none;}.navbar-expand-xxl .offcanvas{position: inherit; bottom: 0; z-index: 1000; flex-grow: 1; visibility: visible !important; background-color: transparent; border-right: 0; border-left: 0; transition: none; transform: none;}.navbar-expand-xxl .offcanvas-top, .navbar-expand-xxl .offcanvas-bottom{height: auto; border-top: 0; border-bottom: 0;}.navbar-expand-xxl .offcanvas-body{display: -webkit-box; display: -webkit-flex; display: flex; flex-grow: 0; padding: 0; overflow-y: visible;}}.navbar-expand{-webkit-flex-wrap: nowrap; flex-wrap: nowrap; -webkit-box-pack: start; justify-content: flex-start;}.navbar-expand .navbar-nav{flex-direction: row;}.navbar-expand .navbar-nav .dropdown-menu{position: absolute;}.navbar-expand .navbar-nav .nav-link{padding-right: 0.5rem; padding-left: 0.5rem;}.navbar-expand .navbar-nav-scroll{overflow: visible;}.navbar-expand .navbar-collapse{display: -webkit-box !important; display: -webkit-flex !important; display: flex !important; flex-basis: auto;}.navbar-expand .navbar-toggler{display: none;}.navbar-expand .offcanvas-header{display: none;}.navbar-expand .offcanvas{position: inherit; bottom: 0; z-index: 1000; flex-grow: 1; visibility: visible !important; background-color: transparent; border-right: 0; border-left: 0; transition: none; transform: none;}.navbar-expand .offcanvas-top, .navbar-expand .offcanvas-bottom{height: auto; border-top: 0; border-bottom: 0;}.navbar-expand .offcanvas-body{display: -webkit-box; display: -webkit-flex; display: flex; flex-grow: 0; padding: 0; overflow-y: visible;}.navbar-light .navbar-brand{color: rgba(0, 0, 0, 0.9);}.navbar-light .navbar-brand:hover, .navbar-light .navbar-brand:focus{color: rgba(0, 0, 0, 0.9);}.navbar-light .navbar-nav .nav-link{color: rgba(0, 0, 0, 0.55);}.navbar-light .navbar-nav .nav-link:hover, .navbar-light .navbar-nav .nav-link:focus{color: rgba(0, 0, 0, 0.7);}.navbar-light .navbar-nav .nav-link.disabled{color: rgba(0, 0, 0, 0.3);}.navbar-light .navbar-nav .show > .nav-link, .navbar-light .navbar-nav .nav-link.active{color: rgba(0, 0, 0, 0.9);}.navbar-light .navbar-toggler{color: rgba(0, 0, 0, 0.55); border-color: rgba(0, 0, 0, 0.1);}.navbar-light .navbar-toggler-icon{background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 30 30'%3e%3cpath stroke='rgba%280, 0, 0, 0.55%29' stroke-linecap='round' stroke-miterlimit='10' stroke-width='2' d='M4 7h22M4 15h22M4 23h22'/%3e%3c/svg%3e");}.navbar-light .navbar-text{color: rgba(0, 0, 0, 0.55);}.navbar-light .navbar-text a, .navbar-light .navbar-text a:hover, .navbar-light .navbar-text a:focus{color: rgba(0, 0, 0, 0.9);}.navbar-dark .navbar-brand{color: #FFFFFF;}.navbar-dark .navbar-brand:hover, .navbar-dark .navbar-brand:focus{color: #FFFFFF;}.navbar-dark .navbar-nav .nav-link{color: rgba(255, 255, 255, 0.55);}.navbar-dark .navbar-nav .nav-link:hover, .navbar-dark .navbar-nav .nav-link:focus{color: rgba(255, 255, 255, 0.75);}.navbar-dark .navbar-nav .nav-link.disabled{color: rgba(255, 255, 255, 0.25);}.navbar-dark .navbar-nav .show > .nav-link, .navbar-dark .navbar-nav .nav-link.active{color: #FFFFFF;}.navbar-dark .navbar-toggler{color: rgba(255, 255, 255, 0.55); border-color: rgba(255, 255, 255, 0.1);}.navbar-dark .navbar-toggler-icon{background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 30 30'%3e%3cpath stroke='rgba%28255, 255, 255, 0.55%29' stroke-linecap='round' stroke-miterlimit='10' stroke-width='2' d='M4 7h22M4 15h22M4 23h22'/%3e%3c/svg%3e");}.navbar-dark .navbar-text{color: rgba(255, 255, 255, 0.55);}.navbar-dark .navbar-text a, .navbar-dark .navbar-text a:hover, .navbar-dark .navbar-text a:focus{color: #FFFFFF;}.card{position: relative; display: -webkit-box; display: -webkit-flex; display: flex; -webkit-box-orient: vertical; -webkit-box-direction: normal; -webkit-flex-direction: column; flex-direction: column; min-width: 0; word-wrap: break-word; background-color: #FFFFFF; background-clip: border-box; border: 1px solid rgba(0, 0, 0, 0.125); border-radius: 0.25rem;}.card > hr{margin-right: 0; margin-left: 0;}.card > .list-group{border-top: inherit; border-bottom: inherit;}.card > .list-group:first-child{border-top-width: 0; border-top-left-radius: calc(0.25rem - 1px); border-top-right-radius: calc(0.25rem - 1px);}.card > .list-group:last-child{border-bottom-width: 0; border-bottom-right-radius: calc(0.25rem - 1px); border-bottom-left-radius: calc(0.25rem - 1px);}.card > .card-header + .list-group, .card > .list-group + .card-footer{border-top: 0;}.card-body{-webkit-box-flex: 1; -webkit-flex: 1 1 auto; flex: 1 1 auto; padding: 1rem 1rem;}.card-title{margin-bottom: 0.5rem;}.card-subtitle{margin-top: -0.25rem; margin-bottom: 0;}.card-text:last-child{margin-bottom: 0;}.card-link + .card-link{margin-left: 1rem;}.card-header{padding: 0.5rem 1rem; margin-bottom: 0; background-color: rgba(0, 0, 0, 0.03); border-bottom: 1px solid rgba(0, 0, 0, 0.125);}.card-header:first-child{border-radius: calc(0.25rem - 1px) calc(0.25rem - 1px) 0 0;}.card-footer{padding: 0.5rem 1rem; background-color: rgba(0, 0, 0, 0.03); border-top: 1px solid rgba(0, 0, 0, 0.125);}.card-footer:last-child{border-radius: 0 0 calc(0.25rem - 1px) calc(0.25rem - 1px);}.card-header-tabs{margin-right: -0.5rem; margin-bottom: -0.5rem; margin-left: -0.5rem; border-bottom: 0;}.card-header-pills{margin-right: -0.5rem; margin-left: -0.5rem;}.card-img-overlay{position: absolute; top: 0; right: 0; bottom: 0; left: 0; padding: 1rem; border-radius: calc(0.25rem - 1px);}.card-img, .card-img-top, .card-img-bottom{width: 100%;}.card-img, .card-img-top{border-top-left-radius: calc(0.25rem - 1px); border-top-right-radius: calc(0.25rem - 1px);}.card-img, .card-img-bottom{border-bottom-right-radius: calc(0.25rem - 1px); border-bottom-left-radius: calc(0.25rem - 1px);}.card-group > .card{margin-bottom: 0.75rem;}@media (min-width: 576px){.card-group{display: -webkit-box; display: -webkit-flex; display: flex; -webkit-flex-flow: row wrap; flex-flow: row wrap;}.card-group > .card{flex: 1 0 0%; margin-bottom: 0;}.card-group > .card + .card{margin-left: 0; border-left: 0;}.card-group > .card:not(:last-child){border-top-right-radius: 0; border-bottom-right-radius: 0;}.card-group > .card:not(:last-child) .card-img-top, .card-group > .card:not(:last-child) .card-header{border-top-right-radius: 0;}.card-group > .card:not(:last-child) .card-img-bottom, .card-group > .card:not(:last-child) .card-footer{border-bottom-right-radius: 0;}.card-group > .card:not(:first-child){border-top-left-radius: 0; border-bottom-left-radius: 0;}.card-group > .card:not(:first-child) .card-img-top, .card-group > .card:not(:first-child) .card-header{border-top-left-radius: 0;}.card-group > .card:not(:first-child) .card-img-bottom, .card-group > .card:not(:first-child) .card-footer{border-bottom-left-radius: 0;}}.accordion-button{position: relative; display: -webkit-box; display: -webkit-flex; display: flex; align-items: center; width: 100%; padding: 1rem 1.25rem; font-size: 0.875rem; color: #212529; text-align: left; background-color: #FFFFFF; border: 0; border-radius: 0; overflow-anchor: none; transition: color 0.15s ease-in-out, background-color 0.15s ease-in-out, border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out, border-radius 0.15s ease;}@media (prefers-reduced-motion: reduce){.accordion-button{transition: none;}}.accordion-button:not(.collapsed){color: #66445d; background-color: #f1edf0; box-shadow: inset 0 -1px 0 rgba(0, 0, 0, 0.125);}.accordion-button:not(.collapsed)::after{background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16' fill='%2366445d'%3e%3cpath fill-rule='evenodd' d='M1.646 4.646a.5.5 0 0 1 .708 0L8 10.293l5.646-5.647a.5.5 0 0 1 .708.708l-6 6a.5.5 0 0 1-.708 0l-6-6a.5.5 0 0 1 0-.708z'/%3e%3c/svg%3e"); transform: rotate(-180deg);}.accordion-button::after{flex-shrink: 0; width: 1.25rem; height: 1.25rem; margin-left: auto; content: ""; background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16' fill='%23212529'%3e%3cpath fill-rule='evenodd' d='M1.646 4.646a.5.5 0 0 1 .708 0L8 10.293l5.646-5.647a.5.5 0 0 1 .708.708l-6 6a.5.5 0 0 1-.708 0l-6-6a.5.5 0 0 1 0-.708z'/%3e%3c/svg%3e"); background-repeat: no-repeat; background-size: 1.25rem; transition: transform 0.2s ease-in-out;}@media (prefers-reduced-motion: reduce){.accordion-button::after{transition: none;}}.accordion-button:hover{z-index: 2;}.accordion-button:focus{z-index: 3; border-color: #b8a5b3; outline: 0; box-shadow: 0 0 0 0.25rem rgba(113, 75, 103, 0.25);}.accordion-header{margin-bottom: 0;}.accordion-item{background-color: #FFFFFF; border: 1px solid rgba(0, 0, 0, 0.125);}.accordion-item:first-of-type{border-top-left-radius: 0.25rem; border-top-right-radius: 0.25rem;}.accordion-item:first-of-type .accordion-button{border-top-left-radius: calc(0.25rem - 1px); border-top-right-radius: calc(0.25rem - 1px);}.accordion-item:not(:first-of-type){border-top: 0;}.accordion-item:last-of-type{border-bottom-right-radius: 0.25rem; border-bottom-left-radius: 0.25rem;}.accordion-item:last-of-type .accordion-button.collapsed{border-bottom-right-radius: calc(0.25rem - 1px); border-bottom-left-radius: calc(0.25rem - 1px);}.accordion-item:last-of-type .accordion-collapse{border-bottom-right-radius: 0.25rem; border-bottom-left-radius: 0.25rem;}.accordion-body{padding: 1rem 1.25rem;}.accordion-flush .accordion-collapse{border-width: 0;}.accordion-flush .accordion-item{border-right: 0; border-left: 0; border-radius: 0;}.accordion-flush .accordion-item:first-child{border-top: 0;}.accordion-flush .accordion-item:last-child{border-bottom: 0;}.accordion-flush .accordion-item .accordion-button{border-radius: 0;}.breadcrumb{display: -webkit-box; display: -webkit-flex; display: flex; -webkit-flex-wrap: wrap; flex-wrap: wrap; padding: 0 0; margin-bottom: 1rem; list-style: none;}.breadcrumb-item + .breadcrumb-item{padding-left: 0.5rem;}.breadcrumb-item + .breadcrumb-item::before{float: left; padding-right: 0.5rem; color: #6C757D; content: var(--bs-breadcrumb-divider, "/") ;}.breadcrumb-item.active{color: #6C757D;}.pagination{display: -webkit-box; display: -webkit-flex; display: flex; padding-left: 0; list-style: none;}.page-link{position: relative; display: block; color: #714B67; background-color: #FFFFFF; border: 1px solid #DEE2E6; transition: color 0.15s ease-in-out, background-color 0.15s ease-in-out, border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;}@media (prefers-reduced-motion: reduce){.page-link{transition: none;}}.page-link:hover{z-index: 2; color: #5a3c52; background-color: #E9ECEF; border-color: #DEE2E6;}.page-link:focus{z-index: 3; color: #5a3c52; background-color: #E9ECEF; outline: 0; box-shadow: 0 0 0 0.25rem rgba(113, 75, 103, 0.25);}.page-item:not(:first-child) .page-link{margin-left: -1px;}.page-item.active .page-link{z-index: 3; color: #FFFFFF; background-color: #714B67; border-color: #714B67;}.page-item.disabled .page-link{color: #6C757D; pointer-events: none; background-color: #FFFFFF; border-color: #DEE2E6;}.page-link{padding: 0.375rem 0.75rem;}.page-item:first-child .page-link{border-top-left-radius: 0.25rem; border-bottom-left-radius: 0.25rem;}.page-item:last-child .page-link{border-top-right-radius: 0.25rem; border-bottom-right-radius: 0.25rem;}.pagination-lg .page-link{padding: 0.75rem 1.5rem; font-size: 1.09375rem;}.pagination-lg .page-item:first-child .page-link{border-top-left-radius: 0.3rem; border-bottom-left-radius: 0.3rem;}.pagination-lg .page-item:last-child .page-link{border-top-right-radius: 0.3rem; border-bottom-right-radius: 0.3rem;}.pagination-sm .page-link{padding: 0.25rem 0.5rem; font-size: 0.765625rem;}.pagination-sm .page-item:first-child .page-link{border-top-left-radius: 0.2rem; border-bottom-left-radius: 0.2rem;}.pagination-sm .page-item:last-child .page-link{border-top-right-radius: 0.2rem; border-bottom-right-radius: 0.2rem;}.badge{display: inline-block; padding: 0.35em 0.65em; font-size: 0.75em; font-weight: 700; line-height: 1; color: #FFFFFF; text-align: center; white-space: nowrap; vertical-align: baseline; border-radius: 0.25rem;}.badge:empty{display: none;}.btn .badge{position: relative; top: -1px;}.alert{position: relative; padding: 1rem 1rem; margin-bottom: 1rem; border: 1px solid transparent; border-radius: 0.25rem;}.alert-heading{color: inherit;}.alert-link{font-weight: 700;}.alert-dismissible{padding-right: 3rem;}.alert-dismissible .btn-close{position: absolute; top: 0; right: 0; z-index: 2; padding: 1.25rem 1rem;}.alert-primary{color: #442d3e; background-color: #e3dbe1; border-color: #d4c9d1;}.alert-primary .alert-link{color: #362432;}.alert-secondary{color: #505961; background-color: #e7eaec; border-color: #dadfe3;}.alert-secondary .alert-link{color: #40474e;}.alert-success{color: #0f5132; background-color: #d1e7dd; border-color: #badbcc;}.alert-success .alert-link{color: #0c4128;}.alert-info{color: #087990; background-color: #cff4fc; border-color: #b6effb;}.alert-info .alert-link{color: #066173;}.alert-warning{color: #997404; background-color: #fff3cd; border-color: #ffecb5;}.alert-warning .alert-link{color: #7a5d03;}.alert-danger{color: #842029; background-color: #f8d7da; border-color: #f5c2c7;}.alert-danger .alert-link{color: #6a1a21;}.alert-light{color: #959596; background-color: #fefefe; border-color: #fdfdfe;}.alert-light .alert-link{color: #777778;}.alert-dark{color: #141619; background-color: #d3d3d4; border-color: #bcbebf;}.alert-dark .alert-link{color: #101214;}@keyframes progress-bar-stripes{0%{background-position-x: 1rem;}}.progress{display: -webkit-box; display: -webkit-flex; display: flex; height: 1rem; overflow: hidden; font-size: 0.65625rem; background-color: #E9ECEF; border-radius: 0.25rem;}.progress-bar{display: -webkit-box; display: -webkit-flex; display: flex; -webkit-box-orient: vertical; -webkit-box-direction: normal; -webkit-flex-direction: column; flex-direction: column; justify-content: center; overflow: hidden; color: #FFFFFF; text-align: center; white-space: nowrap; background-color: #714B67; transition: width 0.6s ease;}@media (prefers-reduced-motion: reduce){.progress-bar{transition: none;}}.progress-bar-striped{background-image: linear-gradient(45deg, rgba(255, 255, 255, 0.15) 25%, transparent 25%, transparent 50%, rgba(255, 255, 255, 0.15) 50%, rgba(255, 255, 255, 0.15) 75%, transparent 75%, transparent); background-size: 1rem 1rem;}.progress-bar-animated{animation: 1s linear infinite progress-bar-stripes;}@media (prefers-reduced-motion: reduce){.progress-bar-animated{animation: none;}}.list-group{display: -webkit-box; display: -webkit-flex; display: flex; -webkit-box-orient: vertical; -webkit-box-direction: normal; -webkit-flex-direction: column; flex-direction: column; padding-left: 0; margin-bottom: 0; border-radius: 0.25rem;}.list-group-numbered{list-style-type: none; counter-reset: section;}.list-group-numbered > li::before{content: counters(section, ".") ". "; counter-increment: section;}.list-group-item-action{width: 100%; color: #495057; text-align: inherit;}.list-group-item-action:hover, .list-group-item-action:focus{z-index: 1; color: #495057; text-decoration: none; background-color: #F8F9FA;}.list-group-item-action:active{color: #212529; background-color: #E9ECEF;}.list-group-item{position: relative; display: block; padding: 0.5rem 1rem; color: #212529; background-color: #FFFFFF; border: 1px solid rgba(0, 0, 0, 0.125);}.list-group-item:first-child{border-top-left-radius: inherit; border-top-right-radius: inherit;}.list-group-item:last-child{border-bottom-right-radius: inherit; border-bottom-left-radius: inherit;}.list-group-item.disabled, .list-group-item:disabled, .list-group-item.o_wysiwyg_loader{color: #6C757D; pointer-events: none; background-color: #FFFFFF;}.list-group-item.active{z-index: 2; color: #FFFFFF; background-color: #714B67; border-color: #714B67;}.list-group-item + .list-group-item{border-top-width: 0;}.list-group-item + .list-group-item.active{margin-top: -1px; border-top-width: 1px;}.list-group-horizontal{flex-direction: row;}.list-group-horizontal > .list-group-item:first-child{border-bottom-left-radius: 0.25rem; border-top-right-radius: 0;}.list-group-horizontal > .list-group-item:last-child{border-top-right-radius: 0.25rem; border-bottom-left-radius: 0;}.list-group-horizontal > .list-group-item.active{margin-top: 0;}.list-group-horizontal > .list-group-item + .list-group-item{border-top-width: 1px; border-left-width: 0;}.list-group-horizontal > .list-group-item + .list-group-item.active{margin-left: -1px; border-left-width: 1px;}@media (min-width: 576px){.list-group-horizontal-sm{flex-direction: row;}.list-group-horizontal-sm > .list-group-item:first-child{border-bottom-left-radius: 0.25rem; border-top-right-radius: 0;}.list-group-horizontal-sm > .list-group-item:last-child{border-top-right-radius: 0.25rem; border-bottom-left-radius: 0;}.list-group-horizontal-sm > .list-group-item.active{margin-top: 0;}.list-group-horizontal-sm > .list-group-item + .list-group-item{border-top-width: 1px; border-left-width: 0;}.list-group-horizontal-sm > .list-group-item + .list-group-item.active{margin-left: -1px; border-left-width: 1px;}}@media (min-width: 768px){.list-group-horizontal-md{flex-direction: row;}.list-group-horizontal-md > .list-group-item:first-child{border-bottom-left-radius: 0.25rem; border-top-right-radius: 0;}.list-group-horizontal-md > .list-group-item:last-child{border-top-right-radius: 0.25rem; border-bottom-left-radius: 0;}.list-group-horizontal-md > .list-group-item.active{margin-top: 0;}.list-group-horizontal-md > .list-group-item + .list-group-item{border-top-width: 1px; border-left-width: 0;}.list-group-horizontal-md > .list-group-item + .list-group-item.active{margin-left: -1px; border-left-width: 1px;}}@media (min-width: 992px){.list-group-horizontal-lg{flex-direction: row;}.list-group-horizontal-lg > .list-group-item:first-child{border-bottom-left-radius: 0.25rem; border-top-right-radius: 0;}.list-group-horizontal-lg > .list-group-item:last-child{border-top-right-radius: 0.25rem; border-bottom-left-radius: 0;}.list-group-horizontal-lg > .list-group-item.active{margin-top: 0;}.list-group-horizontal-lg > .list-group-item + .list-group-item{border-top-width: 1px; border-left-width: 0;}.list-group-horizontal-lg > .list-group-item + .list-group-item.active{margin-left: -1px; border-left-width: 1px;}}@media (min-width: 1200px){.list-group-horizontal-xl{flex-direction: row;}.list-group-horizontal-xl > .list-group-item:first-child{border-bottom-left-radius: 0.25rem; border-top-right-radius: 0;}.list-group-horizontal-xl > .list-group-item:last-child{border-top-right-radius: 0.25rem; border-bottom-left-radius: 0;}.list-group-horizontal-xl > .list-group-item.active{margin-top: 0;}.list-group-horizontal-xl > .list-group-item + .list-group-item{border-top-width: 1px; border-left-width: 0;}.list-group-horizontal-xl > .list-group-item + .list-group-item.active{margin-left: -1px; border-left-width: 1px;}}@media (min-width: 1400px){.list-group-horizontal-xxl{flex-direction: row;}.list-group-horizontal-xxl > .list-group-item:first-child{border-bottom-left-radius: 0.25rem; border-top-right-radius: 0;}.list-group-horizontal-xxl > .list-group-item:last-child{border-top-right-radius: 0.25rem; border-bottom-left-radius: 0;}.list-group-horizontal-xxl > .list-group-item.active{margin-top: 0;}.list-group-horizontal-xxl > .list-group-item + .list-group-item{border-top-width: 1px; border-left-width: 0;}.list-group-horizontal-xxl > .list-group-item + .list-group-item.active{margin-left: -1px; border-left-width: 1px;}}.list-group-flush{border-radius: 0;}.list-group-flush > .list-group-item{border-width: 0 0 1px;}.list-group-flush > .list-group-item:last-child{border-bottom-width: 0;}.list-group-item-primary{color: #442d3e; background-color: #e3dbe1;}.list-group-item-primary.list-group-item-action:hover, .list-group-item-primary.list-group-item-action:focus{color: #442d3e; background-color: #ccc5cb;}.list-group-item-primary.list-group-item-action.active{color: #FFFFFF; background-color: #442d3e; border-color: #442d3e;}.list-group-item-secondary{color: #505961; background-color: #e7eaec;}.list-group-item-secondary.list-group-item-action:hover, .list-group-item-secondary.list-group-item-action:focus{color: #505961; background-color: #d0d3d4;}.list-group-item-secondary.list-group-item-action.active{color: #FFFFFF; background-color: #505961; border-color: #505961;}.list-group-item-success{color: #0f5132; background-color: #d1e7dd;}.list-group-item-success.list-group-item-action:hover, .list-group-item-success.list-group-item-action:focus{color: #0f5132; background-color: #bcd0c7;}.list-group-item-success.list-group-item-action.active{color: #FFFFFF; background-color: #0f5132; border-color: #0f5132;}.list-group-item-info{color: #087990; background-color: #cff4fc;}.list-group-item-info.list-group-item-action:hover, .list-group-item-info.list-group-item-action:focus{color: #087990; background-color: #badce3;}.list-group-item-info.list-group-item-action.active{color: #FFFFFF; background-color: #087990; border-color: #087990;}.list-group-item-warning{color: #997404; background-color: #fff3cd;}.list-group-item-warning.list-group-item-action:hover, .list-group-item-warning.list-group-item-action:focus{color: #997404; background-color: #e6dbb9;}.list-group-item-warning.list-group-item-action.active{color: #FFFFFF; background-color: #997404; border-color: #997404;}.list-group-item-danger{color: #842029; background-color: #f8d7da;}.list-group-item-danger.list-group-item-action:hover, .list-group-item-danger.list-group-item-action:focus{color: #842029; background-color: #dfc2c4;}.list-group-item-danger.list-group-item-action.active{color: #FFFFFF; background-color: #842029; border-color: #842029;}.list-group-item-light{color: #959596; background-color: #fefefe;}.list-group-item-light.list-group-item-action:hover, .list-group-item-light.list-group-item-action:focus{color: #959596; background-color: #e5e5e5;}.list-group-item-light.list-group-item-action.active{color: #FFFFFF; background-color: #959596; border-color: #959596;}.list-group-item-dark{color: #141619; background-color: #d3d3d4;}.list-group-item-dark.list-group-item-action:hover, .list-group-item-dark.list-group-item-action:focus{color: #141619; background-color: #bebebf;}.list-group-item-dark.list-group-item-action.active{color: #FFFFFF; background-color: #141619; border-color: #141619;}.btn-close{box-sizing: content-box; width: 1em; height: 1em; padding: 0.25em 0.25em; color: #000000; background: transparent url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16' fill='%23000000'%3e%3cpath d='M.293.293a1 1 0 011.414 0L8 6.586 14.293.293a1 1 0 111.414 1.414L9.414 8l6.293 6.293a1 1 0 01-1.414 1.414L8 9.414l-6.293 6.293a1 1 0 01-1.414-1.414L6.586 8 .293 1.707a1 1 0 010-1.414z'/%3e%3c/svg%3e") center/1em auto no-repeat; border: 0; border-radius: 0.25rem; opacity: 0.5;}.btn-close:hover{color: #000000; text-decoration: none; opacity: 0.75;}.btn-close:focus{outline: 0; box-shadow: 0 0 0 0.25rem rgba(113, 75, 103, 0.25); opacity: 1;}.btn-close:disabled, .btn-close.o_wysiwyg_loader, .btn-close.disabled{pointer-events: none; user-select: none; opacity: 0.25;}.btn-close-white{filter: invert(1) grayscale(100%) brightness(200%);}.toast{width: 350px; max-width: 100%; font-size: 0.875rem; pointer-events: auto; background-color: rgba(255, 255, 255, 0.85); background-clip: padding-box; border: 1px solid rgba(0, 0, 0, 0.1); box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15); border-radius: 0.25rem;}.toast.showing{opacity: 0;}.toast:not(.show){display: none;}.toast-container{width: max-content; max-width: 100%; pointer-events: none;}.toast-container > :not(:last-child){margin-bottom: 0.75rem;}.toast-header{display: -webkit-box; display: -webkit-flex; display: flex; align-items: center; padding: 0.5rem 0.75rem; color: #6C757D; background-color: rgba(255, 255, 255, 0.85); background-clip: padding-box; border-bottom: 1px solid rgba(0, 0, 0, 0.05); border-top-left-radius: calc(0.25rem - 1px); border-top-right-radius: calc(0.25rem - 1px);}.toast-header .btn-close{margin-right: -0.375rem; margin-left: 0.75rem;}.toast-body{padding: 0.75rem; word-wrap: break-word;}.modal{position: fixed; top: 0; left: 0; z-index: 1055; display: none; width: 100%; height: 100%; overflow-x: hidden; overflow-y: auto; outline: 0;}.modal-dialog{position: relative; width: auto; margin: 0.5rem; pointer-events: none;}.modal.fade .modal-dialog{transition: transform 0.3s ease-out; transform: translate(0, -50px);}@media (prefers-reduced-motion: reduce){.modal.fade .modal-dialog{transition: none;}}.modal.show .modal-dialog{transform: none;}.modal.modal-static .modal-dialog{transform: scale(1.02);}.modal-dialog-scrollable{height: calc(100% - 1rem);}.modal-dialog-scrollable .modal-content{max-height: 100%; overflow: hidden;}.modal-dialog-scrollable .modal-body{overflow-y: auto;}.modal-dialog-centered{display: -webkit-box; display: -webkit-flex; display: flex; align-items: center; min-height: calc(100% - 1rem);}.modal-content{position: relative; display: -webkit-box; display: -webkit-flex; display: flex; -webkit-box-orient: vertical; -webkit-box-direction: normal; -webkit-flex-direction: column; flex-direction: column; width: 100%; pointer-events: auto; background-color: #FFFFFF; background-clip: padding-box; border: 1px solid rgba(0, 0, 0, 0.2); border-radius: 0.3rem; outline: 0;}.modal-backdrop{position: fixed; top: 0; left: 0; z-index: 1050; width: 100vw; height: 100vh; background-color: #000000;}.modal-backdrop.fade{opacity: 0;}.modal-backdrop.show{opacity: 0.5;}.modal-header{display: -webkit-box; display: -webkit-flex; display: flex; flex-shrink: 0; align-items: center; justify-content: space-between; padding: 1rem 1rem; border-bottom: 1px solid #DEE2E6; border-top-left-radius: calc(0.3rem - 1px); border-top-right-radius: calc(0.3rem - 1px);}.modal-header .btn-close{padding: 0.5rem 0.5rem; margin: -0.5rem -0.5rem -0.5rem auto;}.modal-title{margin-bottom: 0; line-height: 1.5;}.modal-body{position: relative; -webkit-box-flex: 1; -webkit-flex: 1 1 auto; flex: 1 1 auto; padding: 1rem;}.modal-footer{display: -webkit-box; display: -webkit-flex; display: flex; -webkit-flex-wrap: wrap; flex-wrap: wrap; flex-shrink: 0; align-items: center; -webkit-box-pack: end; justify-content: flex-end; padding: 0.75rem; border-top: 1px solid #DEE2E6; border-bottom-right-radius: calc(0.3rem - 1px); border-bottom-left-radius: calc(0.3rem - 1px);}.modal-footer > *{margin: 0.25rem;}@media (min-width: 576px){.modal-dialog{max-width: 500px; margin: 1.75rem auto;}.modal-dialog-scrollable{height: calc(100% - 3.5rem);}.modal-dialog-centered{min-height: calc(100% - 3.5rem);}.modal-sm{max-width: 300px;}}@media (min-width: 992px){.modal-lg, .modal-xl{max-width: 800px;}}@media (min-width: 1200px){.modal-xl{max-width: 1140px;}}.modal-fullscreen{width: 100vw; max-width: none; height: 100%; margin: 0;}.modal-fullscreen .modal-content{height: 100%; border: 0; border-radius: 0;}.modal-fullscreen .modal-header{border-radius: 0;}.modal-fullscreen .modal-body{overflow-y: auto;}.modal-fullscreen .modal-footer{border-radius: 0;}@media (max-width: 575.98px){.modal-fullscreen-sm-down{width: 100vw; max-width: none; height: 100%; margin: 0;}.modal-fullscreen-sm-down .modal-content{height: 100%; border: 0; border-radius: 0;}.modal-fullscreen-sm-down .modal-header{border-radius: 0;}.modal-fullscreen-sm-down .modal-body{overflow-y: auto;}.modal-fullscreen-sm-down .modal-footer{border-radius: 0;}}@media (max-width: 767.98px){.modal-fullscreen-md-down{width: 100vw; max-width: none; height: 100%; margin: 0;}.modal-fullscreen-md-down .modal-content{height: 100%; border: 0; border-radius: 0;}.modal-fullscreen-md-down .modal-header{border-radius: 0;}.modal-fullscreen-md-down .modal-body{overflow-y: auto;}.modal-fullscreen-md-down .modal-footer{border-radius: 0;}}@media (max-width: 991.98px){.modal-fullscreen-lg-down{width: 100vw; max-width: none; height: 100%; margin: 0;}.modal-fullscreen-lg-down .modal-content{height: 100%; border: 0; border-radius: 0;}.modal-fullscreen-lg-down .modal-header{border-radius: 0;}.modal-fullscreen-lg-down .modal-body{overflow-y: auto;}.modal-fullscreen-lg-down .modal-footer{border-radius: 0;}}@media (max-width: 1199.98px){.modal-fullscreen-xl-down{width: 100vw; max-width: none; height: 100%; margin: 0;}.modal-fullscreen-xl-down .modal-content{height: 100%; border: 0; border-radius: 0;}.modal-fullscreen-xl-down .modal-header{border-radius: 0;}.modal-fullscreen-xl-down .modal-body{overflow-y: auto;}.modal-fullscreen-xl-down .modal-footer{border-radius: 0;}}@media (max-width: 1399.98px){.modal-fullscreen-xxl-down{width: 100vw; max-width: none; height: 100%; margin: 0;}.modal-fullscreen-xxl-down .modal-content{height: 100%; border: 0; border-radius: 0;}.modal-fullscreen-xxl-down .modal-header{border-radius: 0;}.modal-fullscreen-xxl-down .modal-body{overflow-y: auto;}.modal-fullscreen-xxl-down .modal-footer{border-radius: 0;}}.tooltip{position: absolute; z-index: 1080; display: block; margin: 0; font-family: var(--bs-font-sans-serif); font-style: normal; font-weight: 400; line-height: 1.5; text-align: left; text-align: start; text-decoration: none; text-shadow: none; text-transform: none; letter-spacing: normal; word-break: normal; word-spacing: normal; white-space: normal; line-break: auto; font-size: 0.765625rem; word-wrap: break-word; opacity: 0;}.tooltip.show{opacity: 0.9;}.tooltip .tooltip-arrow{position: absolute; display: block; width: 0.8rem; height: 0.4rem;}.tooltip .tooltip-arrow::before{position: absolute; content: ""; border-color: transparent; border-style: solid;}.bs-tooltip-top, .bs-tooltip-auto[data-popper-placement^="top"]{padding: 0.4rem 0;}.bs-tooltip-top .tooltip-arrow, .bs-tooltip-auto[data-popper-placement^="top"] .tooltip-arrow{bottom: 0;}.bs-tooltip-top .tooltip-arrow::before, .bs-tooltip-auto[data-popper-placement^="top"] .tooltip-arrow::before{top: -1px; border-width: 0.4rem 0.4rem 0; border-top-color: #000000;}.bs-tooltip-end, .bs-tooltip-auto[data-popper-placement^="right"]{padding: 0 0.4rem;}.bs-tooltip-end .tooltip-arrow, .bs-tooltip-auto[data-popper-placement^="right"] .tooltip-arrow{left: 0; width: 0.4rem; height: 0.8rem;}.bs-tooltip-end .tooltip-arrow::before, .bs-tooltip-auto[data-popper-placement^="right"] .tooltip-arrow::before{right: -1px; border-width: 0.4rem 0.4rem 0.4rem 0; border-right-color: #000000;}.bs-tooltip-bottom, .bs-tooltip-auto[data-popper-placement^="bottom"]{padding: 0.4rem 0;}.bs-tooltip-bottom .tooltip-arrow, .bs-tooltip-auto[data-popper-placement^="bottom"] .tooltip-arrow{top: 0;}.bs-tooltip-bottom .tooltip-arrow::before, .bs-tooltip-auto[data-popper-placement^="bottom"] .tooltip-arrow::before{bottom: -1px; border-width: 0 0.4rem 0.4rem; border-bottom-color: #000000;}.bs-tooltip-start, .bs-tooltip-auto[data-popper-placement^="left"]{padding: 0 0.4rem;}.bs-tooltip-start .tooltip-arrow, .bs-tooltip-auto[data-popper-placement^="left"] .tooltip-arrow{right: 0; width: 0.4rem; height: 0.8rem;}.bs-tooltip-start .tooltip-arrow::before, .bs-tooltip-auto[data-popper-placement^="left"] .tooltip-arrow::before{left: -1px; border-width: 0.4rem 0 0.4rem 0.4rem; border-left-color: #000000;}.tooltip-inner{max-width: 200px; padding: 0.25rem 0.5rem; color: #FFFFFF; text-align: center; background-color: #000000; border-radius: 0.25rem;}.popover{position: absolute; top: 0; left: 0 ; z-index: 1070; display: block; max-width: 276px; font-family: var(--bs-font-sans-serif); font-style: normal; font-weight: 400; line-height: 1.5; text-align: left; text-align: start; text-decoration: none; text-shadow: none; text-transform: none; letter-spacing: normal; word-break: normal; word-spacing: normal; white-space: normal; line-break: auto; font-size: 0.765625rem; word-wrap: break-word; background-color: #FFFFFF; background-clip: padding-box; border: 1px solid rgba(0, 0, 0, 0.2); border-radius: 0.3rem;}.popover .popover-arrow{position: absolute; display: block; width: 1rem; height: 0.5rem;}.popover .popover-arrow::before, .popover .popover-arrow::after{position: absolute; display: block; content: ""; border-color: transparent; border-style: solid;}.bs-popover-top > .popover-arrow, .bs-popover-auto[data-popper-placement^="top"] > .popover-arrow{bottom: calc(-0.5rem - 1px);}.bs-popover-top > .popover-arrow::before, .bs-popover-auto[data-popper-placement^="top"] > .popover-arrow::before{bottom: 0; border-width: 0.5rem 0.5rem 0; border-top-color: rgba(0, 0, 0, 0.25);}.bs-popover-top > .popover-arrow::after, .bs-popover-auto[data-popper-placement^="top"] > .popover-arrow::after{bottom: 1px; border-width: 0.5rem 0.5rem 0; border-top-color: #FFFFFF;}.bs-popover-end > .popover-arrow, .bs-popover-auto[data-popper-placement^="right"] > .popover-arrow{left: calc(-0.5rem - 1px); width: 0.5rem; height: 1rem;}.bs-popover-end > .popover-arrow::before, .bs-popover-auto[data-popper-placement^="right"] > .popover-arrow::before{left: 0; border-width: 0.5rem 0.5rem 0.5rem 0; border-right-color: rgba(0, 0, 0, 0.25);}.bs-popover-end > .popover-arrow::after, .bs-popover-auto[data-popper-placement^="right"] > .popover-arrow::after{left: 1px; border-width: 0.5rem 0.5rem 0.5rem 0; border-right-color: #FFFFFF;}.bs-popover-bottom > .popover-arrow, .bs-popover-auto[data-popper-placement^="bottom"] > .popover-arrow{top: calc(-0.5rem - 1px);}.bs-popover-bottom > .popover-arrow::before, .bs-popover-auto[data-popper-placement^="bottom"] > .popover-arrow::before{top: 0; border-width: 0 0.5rem 0.5rem 0.5rem; border-bottom-color: rgba(0, 0, 0, 0.25);}.bs-popover-bottom > .popover-arrow::after, .bs-popover-auto[data-popper-placement^="bottom"] > .popover-arrow::after{top: 1px; border-width: 0 0.5rem 0.5rem 0.5rem; border-bottom-color: #FFFFFF;}.bs-popover-bottom .popover-header::before, .bs-popover-auto[data-popper-placement^="bottom"] .popover-header::before{position: absolute; top: 0; left: 50%; display: block; width: 1rem; margin-left: -0.5rem; content: ""; border-bottom: 1px solid #f0f0f0;}.bs-popover-start > .popover-arrow, .bs-popover-auto[data-popper-placement^="left"] > .popover-arrow{right: calc(-0.5rem - 1px); width: 0.5rem; height: 1rem;}.bs-popover-start > .popover-arrow::before, .bs-popover-auto[data-popper-placement^="left"] > .popover-arrow::before{right: 0; border-width: 0.5rem 0 0.5rem 0.5rem; border-left-color: rgba(0, 0, 0, 0.25);}.bs-popover-start > .popover-arrow::after, .bs-popover-auto[data-popper-placement^="left"] > .popover-arrow::after{right: 1px; border-width: 0.5rem 0 0.5rem 0.5rem; border-left-color: #FFFFFF;}.popover-header{padding: 0.5rem 1rem; margin-bottom: 0; font-size: 0.875rem; background-color: #f0f0f0; border-bottom: 1px solid rgba(0, 0, 0, 0.2); border-top-left-radius: calc(0.3rem - 1px); border-top-right-radius: calc(0.3rem - 1px);}.popover-header:empty{display: none;}.popover-body{padding: 1rem 1rem; color: #212529;}.carousel{position: relative;}.carousel.pointer-event{touch-action: pan-y;}.carousel-inner{position: relative; width: 100%; overflow: hidden;}.carousel-inner::after{display: block; clear: both; content: "";}.carousel-item{position: relative; display: none; float: left; width: 100%; margin-right: -100%; backface-visibility: hidden; transition: transform 0.6s ease-in-out;}@media (prefers-reduced-motion: reduce){.carousel-item{transition: none;}}.carousel-item.active, .carousel-item-next, .carousel-item-prev{display: block;}.carousel-item-next:not(.carousel-item-start), .active.carousel-item-end{transform: translateX(100%);}.carousel-item-prev:not(.carousel-item-end), .active.carousel-item-start{transform: translateX(-100%);}.carousel-fade .carousel-item{opacity: 0; transition-property: opacity; transform: none;}.carousel-fade .carousel-item.active, .carousel-fade .carousel-item-next.carousel-item-start, .carousel-fade .carousel-item-prev.carousel-item-end{z-index: 1; opacity: 1;}.carousel-fade .active.carousel-item-start, .carousel-fade .active.carousel-item-end{z-index: 0; opacity: 0; transition: opacity 0s 0.6s;}@media (prefers-reduced-motion: reduce){.carousel-fade .active.carousel-item-start, .carousel-fade .active.carousel-item-end{transition: none;}}.carousel-control-prev, .carousel-control-next{position: absolute; top: 0; bottom: 0; z-index: 1; display: -webkit-box; display: -webkit-flex; display: flex; align-items: center; justify-content: center; width: 15%; padding: 0; color: #FFFFFF; text-align: center; background: none; border: 0; opacity: 0.5; transition: opacity 0.15s ease;}@media (prefers-reduced-motion: reduce){.carousel-control-prev, .carousel-control-next{transition: none;}}.carousel-control-prev:hover, .carousel-control-prev:focus, .carousel-control-next:hover, .carousel-control-next:focus{color: #FFFFFF; text-decoration: none; outline: 0; opacity: 0.9;}.carousel-control-prev{left: 0;}.carousel-control-next{right: 0;}.carousel-control-prev-icon, .carousel-control-next-icon{display: inline-block; width: 2rem; height: 2rem; background-repeat: no-repeat; background-position: 50%; background-size: 100% 100%;}.carousel-control-prev-icon{background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16' fill='%23FFFFFF'%3e%3cpath d='M11.354 1.646a.5.5 0 0 1 0 .708L5.707 8l5.647 5.646a.5.5 0 0 1-.708.708l-6-6a.5.5 0 0 1 0-.708l6-6a.5.5 0 0 1 .708 0z'/%3e%3c/svg%3e");}.carousel-control-next-icon{background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16' fill='%23FFFFFF'%3e%3cpath d='M4.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L10.293 8 4.646 2.354a.5.5 0 0 1 0-.708z'/%3e%3c/svg%3e");}.carousel-indicators{position: absolute; right: 0; bottom: 0; left: 0; z-index: 2; display: -webkit-box; display: -webkit-flex; display: flex; justify-content: center; padding: 0; margin-right: 15%; margin-bottom: 1rem; margin-left: 15%; list-style: none;}.carousel-indicators [data-bs-target]{box-sizing: content-box; -webkit-box-flex: 0; -webkit-flex: 0 1 auto; flex: 0 1 auto; width: 30px; height: 3px; padding: 0; margin-right: 3px; margin-left: 3px; text-indent: -999px; cursor: pointer; background-color: #FFFFFF; background-clip: padding-box; border: 0; border-top: 10px solid transparent; border-bottom: 10px solid transparent; opacity: 0.5; transition: opacity 0.6s ease;}@media (prefers-reduced-motion: reduce){.carousel-indicators [data-bs-target]{transition: none;}}.carousel-indicators .active{opacity: 1;}.carousel-caption{position: absolute; right: 15%; bottom: 1.25rem; left: 15%; padding-top: 1.25rem; padding-bottom: 1.25rem; color: #FFFFFF; text-align: center;}.carousel-dark .carousel-control-prev-icon, .carousel-dark .carousel-control-next-icon{filter: invert(1) grayscale(100);}.carousel-dark .carousel-indicators [data-bs-target]{background-color: #000000;}.carousel-dark .carousel-caption{color: #000000;}@keyframes spinner-border{to{transform: rotate(360deg) ;}}.spinner-border{display: inline-block; width: 2rem; height: 2rem; vertical-align: -0.125em; border: 0.25em solid currentColor; border-right-color: transparent; border-radius: 50%; animation: 0.75s linear infinite spinner-border;}.spinner-border-sm{width: 1rem; height: 1rem; border-width: 0.2em;}@keyframes spinner-grow{0%{transform: scale(0);}50%{opacity: 1; transform: none;}}.spinner-grow{display: inline-block; width: 2rem; height: 2rem; vertical-align: -0.125em; background-color: currentColor; border-radius: 50%; opacity: 0; animation: 0.75s linear infinite spinner-grow;}.spinner-grow-sm{width: 1rem; height: 1rem;}@media (prefers-reduced-motion: reduce){.spinner-border, .spinner-grow{animation-duration: 1.5s;}}.offcanvas{position: fixed; bottom: 0; z-index: 1045; display: -webkit-box; display: -webkit-flex; display: flex; -webkit-box-orient: vertical; -webkit-box-direction: normal; -webkit-flex-direction: column; flex-direction: column; max-width: 100%; visibility: hidden; background-color: #FFFFFF; background-clip: padding-box; outline: 0; transition: transform 0.3s ease-in-out;}@media (prefers-reduced-motion: reduce){.offcanvas{transition: none;}}.offcanvas-backdrop{position: fixed; top: 0; left: 0; z-index: 1040; width: 100vw; height: 100vh; background-color: #000000;}.offcanvas-backdrop.fade{opacity: 0;}.offcanvas-backdrop.show{opacity: 0.3;}.offcanvas-header{display: -webkit-box; display: -webkit-flex; display: flex; align-items: center; justify-content: space-between; padding: 1rem 1rem;}.offcanvas-header .btn-close{padding: 0.5rem 0.5rem; margin-top: -0.5rem; margin-right: -0.5rem; margin-bottom: -0.5rem;}.offcanvas-title{margin-bottom: 0; line-height: 1.5;}.offcanvas-body{flex-grow: 1; padding: 1rem 1rem; overflow-y: auto;}.offcanvas-start{top: 0; left: 0; width: 400px; border-right: 0 solid rgba(0, 0, 0, 0.2); transform: translateX(-100%);}.offcanvas-end{top: 0; right: 0; width: 400px; border-left: 0 solid rgba(0, 0, 0, 0.2); transform: translateX(100%);}.offcanvas-top{top: 0; right: 0; left: 0; height: 30vh; max-height: 100%; border-bottom: 0 solid rgba(0, 0, 0, 0.2); transform: translateY(-100%);}.offcanvas-bottom{right: 0; left: 0; height: 30vh; max-height: 100%; border-top: 0 solid rgba(0, 0, 0, 0.2); transform: translateY(100%);}.offcanvas.show{transform: none;}.placeholder{display: inline-block; min-height: 1em; vertical-align: middle; cursor: wait; background-color: currentColor; opacity: 0.5;}.placeholder.btn::before{display: inline-block; content: "";}.placeholder-xs{min-height: .6em;}.placeholder-sm{min-height: .8em;}.placeholder-lg{min-height: 1.2em;}.placeholder-glow .placeholder{animation: placeholder-glow 2s ease-in-out infinite;}@keyframes placeholder-glow{50%{opacity: 0.2;}}.placeholder-wave{mask-image: linear-gradient(130deg, #000000 55%, rgba(0, 0, 0, 0.8) 75%, #000000 95%); mask-size: 200% 100%; animation: placeholder-wave 2s linear infinite;}@keyframes placeholder-wave{100%{mask-position: -200% 0%;}}.clearfix::after{display: block; clear: both; content: "";}.link-primary{color: #714B67;}.link-primary:hover, .link-primary:focus{color: #5a3c52;}.link-secondary{color: #8595A2;}.link-secondary:hover, .link-secondary:focus{color: #6a7782;}.link-success{color: #198754;}.link-success:hover, .link-success:focus{color: #146c43;}.link-info{color: #0dcaf0;}.link-info:hover, .link-info:focus{color: #3dd5f3;}.link-warning{color: #ffc107;}.link-warning:hover, .link-warning:focus{color: #ffcd39;}.link-danger{color: #dc3545;}.link-danger:hover, .link-danger:focus{color: #b02a37;}.link-light{color: #F8F9FA;}.link-light:hover, .link-light:focus{color: #f9fafb;}.link-dark{color: #212529;}.link-dark:hover, .link-dark:focus{color: #1a1e21;}.ratio{position: relative; width: 100%;}.ratio::before{display: block; padding-top: var(--bs-aspect-ratio); content: "";}.ratio > *{position: absolute; top: 0; left: 0; width: 100%; height: 100%;}.ratio-1x1{--bs-aspect-ratio: 100%;}.ratio-4x3{--bs-aspect-ratio: calc(3 / 4 * 100%);}.ratio-16x9{--bs-aspect-ratio: calc(9 / 16 * 100%);}.ratio-21x9{--bs-aspect-ratio: calc(9 / 21 * 100%);}.fixed-top{position: fixed; top: 0; right: 0; left: 0; z-index: 1030;}.fixed-bottom{position: fixed; right: 0; bottom: 0; left: 0; z-index: 1030;}.sticky-top{position: sticky; top: 0; z-index: 1020;}@media (min-width: 576px){.sticky-sm-top{position: sticky; top: 0; z-index: 1020;}}@media (min-width: 768px){.sticky-md-top{position: sticky; top: 0; z-index: 1020;}}@media (min-width: 992px){.sticky-lg-top{position: sticky; top: 0; z-index: 1020;}}@media (min-width: 1200px){.sticky-xl-top{position: sticky; top: 0; z-index: 1020;}}@media (min-width: 1400px){.sticky-xxl-top{position: sticky; top: 0; z-index: 1020;}}.hstack{display: -webkit-box; display: -webkit-flex; display: flex; flex-direction: row; align-items: center; align-self: stretch;}.vstack{display: -webkit-box; display: -webkit-flex; display: flex; -webkit-box-flex: 1; -webkit-flex: 1 1 auto; flex: 1 1 auto; -webkit-box-orient: vertical; -webkit-box-direction: normal; -webkit-flex-direction: column; flex-direction: column; align-self: stretch;}.visually-hidden, .visually-hidden-focusable:not(:focus):not(:focus-within){position: absolute !important; width: 1px !important; height: 1px !important; padding: 0 !important; margin: -1px !important; overflow: hidden !important; clip: rect(0, 0, 0, 0) !important; white-space: nowrap !important; border: 0 !important;}.stretched-link::after{position: absolute; top: 0; right: 0; bottom: 0; left: 0; z-index: 1; content: "";}.text-truncate{overflow: hidden; text-overflow: ellipsis; white-space: nowrap;}.vr{display: inline-block; align-self: stretch; width: 1px; min-height: 1em; background-color: currentColor; opacity: 0.25;}\n/* /web/static/src/scss/helpers_backport.scss */\n .text-bg-primary{color: #FFFFFF !important; background-color: RGBA(113, 75, 103, var(--bg-opacity, 1)) !important;}.text-bg-secondary{color: #FFFFFF !important; background-color: RGBA(133, 149, 162, var(--bg-opacity, 1)) !important;}.text-bg-success{color: #FFFFFF !important; background-color: RGBA(25, 135, 84, var(--bg-opacity, 1)) !important;}.text-bg-info{color: #000000 !important; background-color: RGBA(13, 202, 240, var(--bg-opacity, 1)) !important;}.text-bg-warning{color: #000000 !important; background-color: RGBA(255, 193, 7, var(--bg-opacity, 1)) !important;}.text-bg-danger{color: #FFFFFF !important; background-color: RGBA(220, 53, 69, var(--bg-opacity, 1)) !important;}.text-bg-light{color: #000000 !important; background-color: RGBA(248, 249, 250, var(--bg-opacity, 1)) !important;}.text-bg-dark{color: #FFFFFF !important; background-color: RGBA(33, 37, 41, var(--bg-opacity, 1)) !important;}\n/* /web/static/src/scss/utilities_custom.scss */\n .opacity-0-hover:hover, .opacity-trigger-hover:hover .opacity-0-hover{opacity: 0 !important;}.opacity-25-hover:hover, .opacity-trigger-hover:hover .opacity-25-hover{opacity: 0.25 !important;}.opacity-50-hover:hover, .opacity-trigger-hover:hover .opacity-50-hover{opacity: 0.5 !important;}.opacity-75-hover:hover, .opacity-trigger-hover:hover .opacity-75-hover{opacity: 0.75 !important;}.opacity-100-hover:hover, .opacity-trigger-hover:hover .opacity-100-hover{opacity: 1 !important;}.opacity-disabled-hover:hover, .opacity-trigger-hover:hover .opacity-disabled-hover{opacity: 0.5 !important;}.opacity-muted-hover:hover, .opacity-trigger-hover:hover .opacity-muted-hover{opacity: 0.76 !important;}.d-empty-none:empty{display: none !important;}.smaller{font-size: 0.75rem;}\n/* /web/static/lib/bootstrap/scss/utilities/_api.scss */\n .align-baseline{vertical-align: baseline !important;}.align-top{vertical-align: top !important;}.align-middle{vertical-align: middle !important;}.align-bottom{vertical-align: bottom !important;}.align-text-bottom{vertical-align: text-bottom !important;}.align-text-top{vertical-align: text-top !important;}.float-start{float: left !important;}.float-end{float: right !important;}.float-none{float: none !important;}.opacity-0{opacity: 0 !important;}.opacity-25{opacity: 0.25 !important;}.opacity-50{opacity: 0.5 !important;}.opacity-75{opacity: 0.75 !important;}.opacity-100{opacity: 1 !important;}.opacity-disabled{opacity: 0.5 !important;}.opacity-muted{opacity: 0.76 !important;}.overflow-auto{overflow: auto !important;}.overflow-hidden{overflow: hidden !important;}.overflow-visible{overflow: visible !important;}.overflow-scroll{overflow: scroll !important;}.d-inline{display: inline !important;}.d-inline-block{display: inline-block !important;}.d-block{display: block !important;}.d-grid{display: grid !important;}.d-table{display: table !important;}.d-table-row{display: table-row !important;}.d-table-cell{display: table-cell !important;}.d-flex{display: -webkit-box !important; display: -webkit-flex !important; display: flex !important;}.d-inline-flex{display: -webkit-inline-box !important; display: -webkit-inline-flex !important; display: inline-flex !important;}.d-none{display: none !important;}.d-contents{display: contents !important;}.shadow{box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15) !important;}.shadow-sm{box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075) !important;}.shadow-lg{box-shadow: 0 1rem 3rem rgba(0, 0, 0, 0.175) !important;}.shadow-none{box-shadow: none !important;}.position-static{position: static !important;}.position-relative{position: relative !important;}.position-absolute{position: absolute !important;}.position-fixed{position: fixed !important;}.position-sticky{position: sticky !important;}.top-0{top: 0 !important;}.top-50{top: 50% !important;}.top-100{top: 100% !important;}.bottom-0{bottom: 0 !important;}.bottom-50{bottom: 50% !important;}.bottom-100{bottom: 100% !important;}.start-0{left: 0 !important;}.start-50{left: 50% !important;}.start-100{left: 100% !important;}.end-0{right: 0 !important;}.end-50{right: 50% !important;}.end-100{right: 100% !important;}.translate-middle{transform: translate(-50%, -50%) !important;}.translate-middle-x{transform: translateX(-50%) !important;}.translate-middle-y{transform: translateY(-50%) !important;}.border{border: 1px solid #DEE2E6 !important;}.border-0{border: 0 !important;}.border-top{border-top: 1px solid #DEE2E6 !important;}.border-top-0{border-top: 0 !important;}.border-end{border-right: 1px solid #DEE2E6 !important;}.border-end-0{border-right: 0 !important;}.border-bottom{border-bottom: 1px solid #DEE2E6 !important;}.border-bottom-0{border-bottom: 0 !important;}.border-start{border-left: 1px solid #DEE2E6 !important;}.border-start-0{border-left: 0 !important;}.border-primary{border-color: #714B67 !important;}.border-secondary{border-color: #8595A2 !important;}.border-success{border-color: #198754 !important;}.border-info{border-color: #0dcaf0 !important;}.border-warning{border-color: #ffc107 !important;}.border-danger{border-color: #dc3545 !important;}.border-light{border-color: #F8F9FA !important;}.border-dark{border-color: #212529 !important;}.border-white{border-color: #FFFFFF !important;}.border-transparent{border-color: transparent !important;}.border-1{border-width: 1px !important;}.border-2{border-width: 2px !important;}.border-3{border-width: 3px !important;}.border-4{border-width: 4px !important;}.border-5{border-width: 5px !important;}.w-0{width: 0 !important;}.w-25{width: 25% !important;}.w-50{width: 50% !important;}.w-75{width: 75% !important;}.w-100{width: 100% !important;}.w-auto{width: auto !important;}.mw-0{max-width: 0 !important;}.mw-25{max-width: 25% !important;}.mw-50{max-width: 50% !important;}.mw-75{max-width: 75% !important;}.mw-100{max-width: 100% !important;}.mw-auto{max-width: auto !important;}.vw-100{width: 100vw !important;}.min-vw-100{min-width: 100vw !important;}.h-0{height: 0 !important;}.h-25{height: 25% !important;}.h-50{height: 50% !important;}.h-75{height: 75% !important;}.h-100{height: 100% !important;}.h-auto{height: auto !important;}.mh-0{max-height: 0 !important;}.mh-25{max-height: 25% !important;}.mh-50{max-height: 50% !important;}.mh-75{max-height: 75% !important;}.mh-100{max-height: 100% !important;}.mh-auto{max-height: auto !important;}.vh-100{height: 100vh !important;}.min-vh-100{min-height: 100vh !important;}.flex-fill{flex: 1 1 auto !important;}.flex-row{flex-direction: row !important;}.flex-column{flex-direction: column !important;}.flex-row-reverse{flex-direction: row-reverse !important;}.flex-column-reverse{flex-direction: column-reverse !important;}.flex-grow-0{flex-grow: 0 !important;}.flex-grow-1{flex-grow: 1 !important;}.flex-shrink-0{flex-shrink: 0 !important;}.flex-shrink-1{flex-shrink: 1 !important;}.flex-wrap{flex-wrap: wrap !important;}.flex-nowrap{flex-wrap: nowrap !important;}.flex-wrap-reverse{flex-wrap: wrap-reverse !important;}.gap-0{gap: 0 !important;}.gap-1{gap: 0.25rem !important;}.gap-2{gap: 0.5rem !important;}.gap-3{gap: 1rem !important;}.gap-4{gap: 1.5rem !important;}.gap-5{gap: 3rem !important;}.justify-content-start{-webkit-box-pack: start !important; justify-content: flex-start !important;}.justify-content-end{-webkit-box-pack: end !important; justify-content: flex-end !important;}.justify-content-center{justify-content: center !important;}.justify-content-between{justify-content: space-between !important;}.justify-content-around{justify-content: space-around !important;}.justify-content-evenly{justify-content: space-evenly !important;}.align-items-start{align-items: flex-start !important;}.align-items-end{align-items: flex-end !important;}.align-items-center{align-items: center !important;}.align-items-baseline{align-items: baseline !important;}.align-items-stretch{align-items: stretch !important;}.align-content-start{align-content: flex-start !important;}.align-content-end{align-content: flex-end !important;}.align-content-center{align-content: center !important;}.align-content-between{align-content: space-between !important;}.align-content-around{align-content: space-around !important;}.align-content-stretch{align-content: stretch !important;}.align-self-auto{align-self: auto !important;}.align-self-start{align-self: flex-start !important;}.align-self-end{align-self: flex-end !important;}.align-self-center{align-self: center !important;}.align-self-baseline{align-self: baseline !important;}.align-self-stretch{align-self: stretch !important;}.order-first{order: -1 !important;}.order-last{order: 13 !important;}.order-0{order: 0 !important;}.order-1{order: 1 !important;}.order-2{order: 2 !important;}.order-3{order: 3 !important;}.order-4{order: 4 !important;}.order-5{order: 5 !important;}.order-6{order: 6 !important;}.order-7{order: 7 !important;}.order-8{order: 8 !important;}.order-9{order: 9 !important;}.order-10{order: 10 !important;}.order-11{order: 11 !important;}.order-12{order: 12 !important;}.m-0{margin: 0 !important;}.m-1{margin: 0.25rem !important;}.m-2{margin: 0.5rem !important;}.m-3{margin: 1rem !important;}.m-4{margin: 1.5rem !important;}.m-5{margin: 3rem !important;}.m-auto{margin: auto !important;}.mx-0{margin-right: 0 !important; margin-left: 0 !important;}.mx-1{margin-right: 0.25rem !important; margin-left: 0.25rem !important;}.mx-2{margin-right: 0.5rem !important; margin-left: 0.5rem !important;}.mx-3{margin-right: 1rem !important; margin-left: 1rem !important;}.mx-4{margin-right: 1.5rem !important; margin-left: 1.5rem !important;}.mx-5{margin-right: 3rem !important; margin-left: 3rem !important;}.mx-auto{margin-right: auto !important; margin-left: auto !important;}.my-0{margin-top: 0 !important; margin-bottom: 0 !important;}.my-1{margin-top: 0.25rem !important; margin-bottom: 0.25rem !important;}.my-2{margin-top: 0.5rem !important; margin-bottom: 0.5rem !important;}.my-3{margin-top: 1rem !important; margin-bottom: 1rem !important;}.my-4{margin-top: 1.5rem !important; margin-bottom: 1.5rem !important;}.my-5{margin-top: 3rem !important; margin-bottom: 3rem !important;}.my-auto{margin-top: auto !important; margin-bottom: auto !important;}.mt-0{margin-top: 0 !important;}.mt-1{margin-top: 0.25rem !important;}.mt-2{margin-top: 0.5rem !important;}.mt-3{margin-top: 1rem !important;}.mt-4{margin-top: 1.5rem !important;}.mt-5{margin-top: 3rem !important;}.mt-auto{margin-top: auto !important;}.me-0{margin-right: 0 !important;}.me-1{margin-right: 0.25rem !important;}.me-2{margin-right: 0.5rem !important;}.me-3{margin-right: 1rem !important;}.me-4{margin-right: 1.5rem !important;}.me-5{margin-right: 3rem !important;}.me-auto{margin-right: auto !important;}.mb-0{margin-bottom: 0 !important;}.mb-1{margin-bottom: 0.25rem !important;}.mb-2{margin-bottom: 0.5rem !important;}.mb-3{margin-bottom: 1rem !important;}.mb-4{margin-bottom: 1.5rem !important;}.mb-5{margin-bottom: 3rem !important;}.mb-auto{margin-bottom: auto !important;}.ms-0{margin-left: 0 !important;}.ms-1{margin-left: 0.25rem !important;}.ms-2{margin-left: 0.5rem !important;}.ms-3{margin-left: 1rem !important;}.ms-4{margin-left: 1.5rem !important;}.ms-5{margin-left: 3rem !important;}.ms-auto{margin-left: auto !important;}.p-0{padding: 0 !important;}.p-1{padding: 0.25rem !important;}.p-2{padding: 0.5rem !important;}.p-3{padding: 1rem !important;}.p-4{padding: 1.5rem !important;}.p-5{padding: 3rem !important;}.px-0{padding-right: 0 !important; padding-left: 0 !important;}.px-1{padding-right: 0.25rem !important; padding-left: 0.25rem !important;}.px-2{padding-right: 0.5rem !important; padding-left: 0.5rem !important;}.px-3{padding-right: 1rem !important; padding-left: 1rem !important;}.px-4{padding-right: 1.5rem !important; padding-left: 1.5rem !important;}.px-5{padding-right: 3rem !important; padding-left: 3rem !important;}.py-0{padding-top: 0 !important; padding-bottom: 0 !important;}.py-1{padding-top: 0.25rem !important; padding-bottom: 0.25rem !important;}.py-2{padding-top: 0.5rem !important; padding-bottom: 0.5rem !important;}.py-3{padding-top: 1rem !important; padding-bottom: 1rem !important;}.py-4{padding-top: 1.5rem !important; padding-bottom: 1.5rem !important;}.py-5{padding-top: 3rem !important; padding-bottom: 3rem !important;}.pt-0{padding-top: 0 !important;}.pt-1{padding-top: 0.25rem !important;}.pt-2{padding-top: 0.5rem !important;}.pt-3{padding-top: 1rem !important;}.pt-4{padding-top: 1.5rem !important;}.pt-5{padding-top: 3rem !important;}.pe-0{padding-right: 0 !important;}.pe-1{padding-right: 0.25rem !important;}.pe-2{padding-right: 0.5rem !important;}.pe-3{padding-right: 1rem !important;}.pe-4{padding-right: 1.5rem !important;}.pe-5{padding-right: 3rem !important;}.pb-0{padding-bottom: 0 !important;}.pb-1{padding-bottom: 0.25rem !important;}.pb-2{padding-bottom: 0.5rem !important;}.pb-3{padding-bottom: 1rem !important;}.pb-4{padding-bottom: 1.5rem !important;}.pb-5{padding-bottom: 3rem !important;}.ps-0{padding-left: 0 !important;}.ps-1{padding-left: 0.25rem !important;}.ps-2{padding-left: 0.5rem !important;}.ps-3{padding-left: 1rem !important;}.ps-4{padding-left: 1.5rem !important;}.ps-5{padding-left: 3rem !important;}.font-monospace{font-family: var(--bs-font-monospace) !important;}.font-sans-serif{font-family: var(--bs-font-sans-serif) !important;}.fs-1{font-size: calc(1.34375rem + 1.125vw) !important;}.fs-2{font-size: calc(1.3rem + 0.6vw) !important;}.fs-3{font-size: calc(1.278125rem + 0.3375vw) !important;}.fs-4{font-size: calc(1.25625rem + 0.075vw) !important;}.fs-5{font-size: 1.09375rem !important;}.fs-6{font-size: 0.875rem !important;}.fst-italic{font-style: italic !important;}.fst-normal{font-style: normal !important;}.fw-light{font-weight: 300 !important;}.fw-lighter{font-weight: lighter !important;}.fw-normal{font-weight: 400 !important;}.fw-bold{font-weight: 700 !important;}.fw-bolder{font-weight: bolder !important;}.lh-1{line-height: 1 !important;}.lh-sm{line-height: 1.25 !important;}.lh-base{line-height: 1.5 !important;}.lh-lg{line-height: 2 !important;}.text-start{text-align: left !important;}.text-end{text-align: right !important;}.text-center{text-align: center !important;}.text-decoration-none{text-decoration: none !important;}.text-decoration-underline{text-decoration: underline !important;}.text-decoration-line-through{text-decoration: line-through !important;}.text-lowercase{text-transform: lowercase !important;}.text-uppercase{text-transform: uppercase !important;}.text-capitalize{text-transform: capitalize !important;}.text-wrap{white-space: normal !important;}.text-nowrap{white-space: nowrap !important;}.text-prewrap{white-space: pre-wrap !important;}.text-break{word-wrap: break-word !important; word-break: break-word !important;}.text-primary{--bs-text-opacity: 1; color: rgba(var(--bs-primary-rgb), var(--bs-text-opacity)) !important;}.text-secondary{--bs-text-opacity: 1; color: rgba(var(--bs-secondary-rgb), var(--bs-text-opacity)) !important;}.text-success{--bs-text-opacity: 1; color: rgba(var(--bs-success-rgb), var(--bs-text-opacity)) !important;}.text-info{--bs-text-opacity: 1; color: rgba(var(--bs-info-rgb), var(--bs-text-opacity)) !important;}.text-warning{--bs-text-opacity: 1; color: rgba(var(--bs-warning-rgb), var(--bs-text-opacity)) !important;}.text-danger{--bs-text-opacity: 1; color: rgba(var(--bs-danger-rgb), var(--bs-text-opacity)) !important;}.text-light{--bs-text-opacity: 1; color: rgba(var(--bs-light-rgb), var(--bs-text-opacity)) !important;}.text-dark{--bs-text-opacity: 1; color: rgba(var(--bs-dark-rgb), var(--bs-text-opacity)) !important;}.text-black{--bs-text-opacity: 1; color: rgba(var(--bs-black-rgb), var(--bs-text-opacity)) !important;}.text-white{--bs-text-opacity: 1; color: rgba(var(--bs-white-rgb), var(--bs-text-opacity)) !important;}.text-body{--bs-text-opacity: 1; color: rgba(var(--bs-body-color-rgb), var(--bs-text-opacity)) !important;}.text-muted{--bs-text-opacity: 1; color: #6C757D !important;}.text-black-50{--bs-text-opacity: 1; color: rgba(0, 0, 0, 0.5) !important;}.text-white-50{--bs-text-opacity: 1; color: rgba(255, 255, 255, 0.5) !important;}.text-reset{--bs-text-opacity: 1; color: inherit !important;}.text-opacity-25{--bs-text-opacity: 0.25;}.text-opacity-50{--bs-text-opacity: 0.5;}.text-opacity-75{--bs-text-opacity: 0.75;}.text-opacity-100{--bs-text-opacity: 1;}.bg-primary{--bs-bg-opacity: 1; background-color: rgba(var(--bs-primary-rgb), var(--bs-bg-opacity)) !important;}.bg-secondary{--bs-bg-opacity: 1; background-color: rgba(var(--bs-secondary-rgb), var(--bs-bg-opacity)) !important;}.bg-success{--bs-bg-opacity: 1; background-color: rgba(var(--bs-success-rgb), var(--bs-bg-opacity)) !important;}.bg-info{--bs-bg-opacity: 1; background-color: rgba(var(--bs-info-rgb), var(--bs-bg-opacity)) !important;}.bg-warning{--bs-bg-opacity: 1; background-color: rgba(var(--bs-warning-rgb), var(--bs-bg-opacity)) !important;}.bg-danger{--bs-bg-opacity: 1; background-color: rgba(var(--bs-danger-rgb), var(--bs-bg-opacity)) !important;}.bg-light{--bs-bg-opacity: 1; background-color: rgba(var(--bs-light-rgb), var(--bs-bg-opacity)) !important;}.bg-dark{--bs-bg-opacity: 1; background-color: rgba(var(--bs-dark-rgb), var(--bs-bg-opacity)) !important;}.bg-black{--bs-bg-opacity: 1; background-color: rgba(var(--bs-black-rgb), var(--bs-bg-opacity)) !important;}.bg-white{--bs-bg-opacity: 1; background-color: rgba(var(--bs-white-rgb), var(--bs-bg-opacity)) !important;}.bg-body{--bs-bg-opacity: 1; background-color: rgba(var(--bs-body-bg-rgb), var(--bs-bg-opacity)) !important;}.bg-transparent{--bs-bg-opacity: 1; background-color: transparent !important;}.bg-opacity-0{--bs-bg-opacity: 0;}.bg-opacity-25{--bs-bg-opacity: 0.25;}.bg-opacity-50{--bs-bg-opacity: 0.5;}.bg-opacity-75{--bs-bg-opacity: 0.75;}.bg-opacity-100{--bs-bg-opacity: 1;}.bg-opacity-disabled{--bs-bg-opacity: 0.5;}.bg-opacity-muted{--bs-bg-opacity: 0.76;}.bg-gradient{background-image: var(--bs-gradient) !important;}.user-select-all{user-select: all !important;}.user-select-auto{user-select: auto !important;}.user-select-none{user-select: none !important;}.pe-none{pointer-events: none !important;}.pe-auto{pointer-events: auto !important;}.rounded{border-radius: 0.25rem !important;}.rounded-0{border-radius: 0 !important;}.rounded-1{border-radius: 0.2rem !important;}.rounded-2{border-radius: 0.25rem !important;}.rounded-3{border-radius: 0.3rem !important;}.rounded-circle{border-radius: 50% !important;}.rounded-pill{border-radius: 50rem !important;}.rounded-top{border-top-left-radius: 0.25rem !important; border-top-right-radius: 0.25rem !important;}.rounded-top-0{border-top-left-radius: 0 !important; border-top-right-radius: 0 !important;}.rounded-top-1{border-top-left-radius: 0.2rem !important; border-top-right-radius: 0.2rem !important;}.rounded-top-2{border-top-left-radius: 0.25rem !important; border-top-right-radius: 0.25rem !important;}.rounded-top-3{border-top-left-radius: 0.3rem !important; border-top-right-radius: 0.3rem !important;}.rounded-top-circle{border-top-left-radius: 50% !important; border-top-right-radius: 50% !important;}.rounded-top-pill{border-top-left-radius: 50rem !important; border-top-right-radius: 50rem !important;}.rounded-end{border-top-right-radius: 0.25rem !important; border-bottom-right-radius: 0.25rem !important;}.rounded-end-0{border-top-right-radius: 0 !important; border-bottom-right-radius: 0 !important;}.rounded-end-1{border-top-right-radius: 0.2rem !important; border-bottom-right-radius: 0.2rem !important;}.rounded-end-2{border-top-right-radius: 0.25rem !important; border-bottom-right-radius: 0.25rem !important;}.rounded-end-3{border-top-right-radius: 0.3rem !important; border-bottom-right-radius: 0.3rem !important;}.rounded-end-circle{border-top-right-radius: 50% !important; border-bottom-right-radius: 50% !important;}.rounded-end-pill{border-top-right-radius: 50rem !important; border-bottom-right-radius: 50rem !important;}.rounded-bottom{border-bottom-right-radius: 0.25rem !important; border-bottom-left-radius: 0.25rem !important;}.rounded-bottom-0{border-bottom-right-radius: 0 !important; border-bottom-left-radius: 0 !important;}.rounded-bottom-1{border-bottom-right-radius: 0.2rem !important; border-bottom-left-radius: 0.2rem !important;}.rounded-bottom-2{border-bottom-right-radius: 0.25rem !important; border-bottom-left-radius: 0.25rem !important;}.rounded-bottom-3{border-bottom-right-radius: 0.3rem !important; border-bottom-left-radius: 0.3rem !important;}.rounded-bottom-circle{border-bottom-right-radius: 50% !important; border-bottom-left-radius: 50% !important;}.rounded-bottom-pill{border-bottom-right-radius: 50rem !important; border-bottom-left-radius: 50rem !important;}.rounded-start{border-bottom-left-radius: 0.25rem !important; border-top-left-radius: 0.25rem !important;}.rounded-start-0{border-bottom-left-radius: 0 !important; border-top-left-radius: 0 !important;}.rounded-start-1{border-bottom-left-radius: 0.2rem !important; border-top-left-radius: 0.2rem !important;}.rounded-start-2{border-bottom-left-radius: 0.25rem !important; border-top-left-radius: 0.25rem !important;}.rounded-start-3{border-bottom-left-radius: 0.3rem !important; border-top-left-radius: 0.3rem !important;}.rounded-start-circle{border-bottom-left-radius: 50% !important; border-top-left-radius: 50% !important;}.rounded-start-pill{border-bottom-left-radius: 50rem !important; border-top-left-radius: 50rem !important;}.visible{visibility: visible !important;}.invisible{visibility: hidden !important;}.cursor-default{cursor: default !important;}.cursor-pointer{cursor: pointer !important;}.flex-basis-0{flex-basis: 0 !important;}.flex-basis-25{flex-basis: 25% !important;}.flex-basis-50{flex-basis: 50% !important;}.flex-basis-75{flex-basis: 75% !important;}.flex-basis-100{flex-basis: 100% !important;}.flex-basis-auto{flex-basis: auto !important;}.z-index-0{z-index: 0 !important;}.z-index-1{z-index: 1 !important;}.overflow-x-auto{overflow-x: auto !important;}.overflow-x-hidden{overflow-x: hidden !important;}.overflow-x-visible{overflow-x: visible !important;}.overflow-x-scroll{overflow-x: scroll !important;}.overflow-y-auto{overflow-y: auto !important;}.overflow-y-hidden{overflow-y: hidden !important;}.overflow-y-visible{overflow-y: visible !important;}.overflow-y-scroll{overflow-y: scroll !important;}.transition-none{transition: none !important;}.transition-base{transition: all 0.2s ease-in-out !important;}.transition-fade{transition: opacity 0.15s linear !important;}.min-w-0{min-width: 0 !important;}@media (min-width: 576px){.float-sm-start{float: left !important;}.float-sm-end{float: right !important;}.float-sm-none{float: none !important;}.d-sm-inline{display: inline !important;}.d-sm-inline-block{display: inline-block !important;}.d-sm-block{display: block !important;}.d-sm-grid{display: grid !important;}.d-sm-table{display: table !important;}.d-sm-table-row{display: table-row !important;}.d-sm-table-cell{display: table-cell !important;}.d-sm-flex{display: -webkit-box !important; display: -webkit-flex !important; display: flex !important;}.d-sm-inline-flex{display: -webkit-inline-box !important; display: -webkit-inline-flex !important; display: inline-flex !important;}.d-sm-none{display: none !important;}.d-sm-contents{display: contents !important;}.position-sm-static{position: static !important;}.position-sm-relative{position: relative !important;}.position-sm-absolute{position: absolute !important;}.position-sm-fixed{position: fixed !important;}.position-sm-sticky{position: sticky !important;}.w-sm-0{width: 0 !important;}.w-sm-25{width: 25% !important;}.w-sm-50{width: 50% !important;}.w-sm-75{width: 75% !important;}.w-sm-100{width: 100% !important;}.w-sm-auto{width: auto !important;}.mw-sm-0{max-width: 0 !important;}.mw-sm-25{max-width: 25% !important;}.mw-sm-50{max-width: 50% !important;}.mw-sm-75{max-width: 75% !important;}.mw-sm-100{max-width: 100% !important;}.mw-sm-auto{max-width: auto !important;}.h-sm-0{height: 0 !important;}.h-sm-25{height: 25% !important;}.h-sm-50{height: 50% !important;}.h-sm-75{height: 75% !important;}.h-sm-100{height: 100% !important;}.h-sm-auto{height: auto !important;}.mh-sm-0{max-height: 0 !important;}.mh-sm-25{max-height: 25% !important;}.mh-sm-50{max-height: 50% !important;}.mh-sm-75{max-height: 75% !important;}.mh-sm-100{max-height: 100% !important;}.mh-sm-auto{max-height: auto !important;}.flex-sm-fill{flex: 1 1 auto !important;}.flex-sm-row{flex-direction: row !important;}.flex-sm-column{flex-direction: column !important;}.flex-sm-row-reverse{flex-direction: row-reverse !important;}.flex-sm-column-reverse{flex-direction: column-reverse !important;}.flex-sm-grow-0{flex-grow: 0 !important;}.flex-sm-grow-1{flex-grow: 1 !important;}.flex-sm-shrink-0{flex-shrink: 0 !important;}.flex-sm-shrink-1{flex-shrink: 1 !important;}.flex-sm-wrap{flex-wrap: wrap !important;}.flex-sm-nowrap{flex-wrap: nowrap !important;}.flex-sm-wrap-reverse{flex-wrap: wrap-reverse !important;}.gap-sm-0{gap: 0 !important;}.gap-sm-1{gap: 0.25rem !important;}.gap-sm-2{gap: 0.5rem !important;}.gap-sm-3{gap: 1rem !important;}.gap-sm-4{gap: 1.5rem !important;}.gap-sm-5{gap: 3rem !important;}.justify-content-sm-start{-webkit-box-pack: start !important; justify-content: flex-start !important;}.justify-content-sm-end{-webkit-box-pack: end !important; justify-content: flex-end !important;}.justify-content-sm-center{justify-content: center !important;}.justify-content-sm-between{justify-content: space-between !important;}.justify-content-sm-around{justify-content: space-around !important;}.justify-content-sm-evenly{justify-content: space-evenly !important;}.align-items-sm-start{align-items: flex-start !important;}.align-items-sm-end{align-items: flex-end !important;}.align-items-sm-center{align-items: center !important;}.align-items-sm-baseline{align-items: baseline !important;}.align-items-sm-stretch{align-items: stretch !important;}.align-content-sm-start{align-content: flex-start !important;}.align-content-sm-end{align-content: flex-end !important;}.align-content-sm-center{align-content: center !important;}.align-content-sm-between{align-content: space-between !important;}.align-content-sm-around{align-content: space-around !important;}.align-content-sm-stretch{align-content: stretch !important;}.align-self-sm-auto{align-self: auto !important;}.align-self-sm-start{align-self: flex-start !important;}.align-self-sm-end{align-self: flex-end !important;}.align-self-sm-center{align-self: center !important;}.align-self-sm-baseline{align-self: baseline !important;}.align-self-sm-stretch{align-self: stretch !important;}.order-sm-first{order: -1 !important;}.order-sm-last{order: 13 !important;}.order-sm-0{order: 0 !important;}.order-sm-1{order: 1 !important;}.order-sm-2{order: 2 !important;}.order-sm-3{order: 3 !important;}.order-sm-4{order: 4 !important;}.order-sm-5{order: 5 !important;}.order-sm-6{order: 6 !important;}.order-sm-7{order: 7 !important;}.order-sm-8{order: 8 !important;}.order-sm-9{order: 9 !important;}.order-sm-10{order: 10 !important;}.order-sm-11{order: 11 !important;}.order-sm-12{order: 12 !important;}.m-sm-0{margin: 0 !important;}.m-sm-1{margin: 0.25rem !important;}.m-sm-2{margin: 0.5rem !important;}.m-sm-3{margin: 1rem !important;}.m-sm-4{margin: 1.5rem !important;}.m-sm-5{margin: 3rem !important;}.m-sm-auto{margin: auto !important;}.mx-sm-0{margin-right: 0 !important; margin-left: 0 !important;}.mx-sm-1{margin-right: 0.25rem !important; margin-left: 0.25rem !important;}.mx-sm-2{margin-right: 0.5rem !important; margin-left: 0.5rem !important;}.mx-sm-3{margin-right: 1rem !important; margin-left: 1rem !important;}.mx-sm-4{margin-right: 1.5rem !important; margin-left: 1.5rem !important;}.mx-sm-5{margin-right: 3rem !important; margin-left: 3rem !important;}.mx-sm-auto{margin-right: auto !important; margin-left: auto !important;}.my-sm-0{margin-top: 0 !important; margin-bottom: 0 !important;}.my-sm-1{margin-top: 0.25rem !important; margin-bottom: 0.25rem !important;}.my-sm-2{margin-top: 0.5rem !important; margin-bottom: 0.5rem !important;}.my-sm-3{margin-top: 1rem !important; margin-bottom: 1rem !important;}.my-sm-4{margin-top: 1.5rem !important; margin-bottom: 1.5rem !important;}.my-sm-5{margin-top: 3rem !important; margin-bottom: 3rem !important;}.my-sm-auto{margin-top: auto !important; margin-bottom: auto !important;}.mt-sm-0{margin-top: 0 !important;}.mt-sm-1{margin-top: 0.25rem !important;}.mt-sm-2{margin-top: 0.5rem !important;}.mt-sm-3{margin-top: 1rem !important;}.mt-sm-4{margin-top: 1.5rem !important;}.mt-sm-5{margin-top: 3rem !important;}.mt-sm-auto{margin-top: auto !important;}.me-sm-0{margin-right: 0 !important;}.me-sm-1{margin-right: 0.25rem !important;}.me-sm-2{margin-right: 0.5rem !important;}.me-sm-3{margin-right: 1rem !important;}.me-sm-4{margin-right: 1.5rem !important;}.me-sm-5{margin-right: 3rem !important;}.me-sm-auto{margin-right: auto !important;}.mb-sm-0{margin-bottom: 0 !important;}.mb-sm-1{margin-bottom: 0.25rem !important;}.mb-sm-2{margin-bottom: 0.5rem !important;}.mb-sm-3{margin-bottom: 1rem !important;}.mb-sm-4{margin-bottom: 1.5rem !important;}.mb-sm-5{margin-bottom: 3rem !important;}.mb-sm-auto{margin-bottom: auto !important;}.ms-sm-0{margin-left: 0 !important;}.ms-sm-1{margin-left: 0.25rem !important;}.ms-sm-2{margin-left: 0.5rem !important;}.ms-sm-3{margin-left: 1rem !important;}.ms-sm-4{margin-left: 1.5rem !important;}.ms-sm-5{margin-left: 3rem !important;}.ms-sm-auto{margin-left: auto !important;}.p-sm-0{padding: 0 !important;}.p-sm-1{padding: 0.25rem !important;}.p-sm-2{padding: 0.5rem !important;}.p-sm-3{padding: 1rem !important;}.p-sm-4{padding: 1.5rem !important;}.p-sm-5{padding: 3rem !important;}.px-sm-0{padding-right: 0 !important; padding-left: 0 !important;}.px-sm-1{padding-right: 0.25rem !important; padding-left: 0.25rem !important;}.px-sm-2{padding-right: 0.5rem !important; padding-left: 0.5rem !important;}.px-sm-3{padding-right: 1rem !important; padding-left: 1rem !important;}.px-sm-4{padding-right: 1.5rem !important; padding-left: 1.5rem !important;}.px-sm-5{padding-right: 3rem !important; padding-left: 3rem !important;}.py-sm-0{padding-top: 0 !important; padding-bottom: 0 !important;}.py-sm-1{padding-top: 0.25rem !important; padding-bottom: 0.25rem !important;}.py-sm-2{padding-top: 0.5rem !important; padding-bottom: 0.5rem !important;}.py-sm-3{padding-top: 1rem !important; padding-bottom: 1rem !important;}.py-sm-4{padding-top: 1.5rem !important; padding-bottom: 1.5rem !important;}.py-sm-5{padding-top: 3rem !important; padding-bottom: 3rem !important;}.pt-sm-0{padding-top: 0 !important;}.pt-sm-1{padding-top: 0.25rem !important;}.pt-sm-2{padding-top: 0.5rem !important;}.pt-sm-3{padding-top: 1rem !important;}.pt-sm-4{padding-top: 1.5rem !important;}.pt-sm-5{padding-top: 3rem !important;}.pe-sm-0{padding-right: 0 !important;}.pe-sm-1{padding-right: 0.25rem !important;}.pe-sm-2{padding-right: 0.5rem !important;}.pe-sm-3{padding-right: 1rem !important;}.pe-sm-4{padding-right: 1.5rem !important;}.pe-sm-5{padding-right: 3rem !important;}.pb-sm-0{padding-bottom: 0 !important;}.pb-sm-1{padding-bottom: 0.25rem !important;}.pb-sm-2{padding-bottom: 0.5rem !important;}.pb-sm-3{padding-bottom: 1rem !important;}.pb-sm-4{padding-bottom: 1.5rem !important;}.pb-sm-5{padding-bottom: 3rem !important;}.ps-sm-0{padding-left: 0 !important;}.ps-sm-1{padding-left: 0.25rem !important;}.ps-sm-2{padding-left: 0.5rem !important;}.ps-sm-3{padding-left: 1rem !important;}.ps-sm-4{padding-left: 1.5rem !important;}.ps-sm-5{padding-left: 3rem !important;}.text-sm-start{text-align: left !important;}.text-sm-end{text-align: right !important;}.text-sm-center{text-align: center !important;}.flex-basis-sm-0{flex-basis: 0 !important;}.flex-basis-sm-25{flex-basis: 25% !important;}.flex-basis-sm-50{flex-basis: 50% !important;}.flex-basis-sm-75{flex-basis: 75% !important;}.flex-basis-sm-100{flex-basis: 100% !important;}.flex-basis-sm-auto{flex-basis: auto !important;}}@media (min-width: 768px){.float-md-start{float: left !important;}.float-md-end{float: right !important;}.float-md-none{float: none !important;}.d-md-inline{display: inline !important;}.d-md-inline-block{display: inline-block !important;}.d-md-block{display: block !important;}.d-md-grid{display: grid !important;}.d-md-table{display: table !important;}.d-md-table-row{display: table-row !important;}.d-md-table-cell{display: table-cell !important;}.d-md-flex{display: -webkit-box !important; display: -webkit-flex !important; display: flex !important;}.d-md-inline-flex{display: -webkit-inline-box !important; display: -webkit-inline-flex !important; display: inline-flex !important;}.d-md-none{display: none !important;}.d-md-contents{display: contents !important;}.position-md-static{position: static !important;}.position-md-relative{position: relative !important;}.position-md-absolute{position: absolute !important;}.position-md-fixed{position: fixed !important;}.position-md-sticky{position: sticky !important;}.w-md-0{width: 0 !important;}.w-md-25{width: 25% !important;}.w-md-50{width: 50% !important;}.w-md-75{width: 75% !important;}.w-md-100{width: 100% !important;}.w-md-auto{width: auto !important;}.mw-md-0{max-width: 0 !important;}.mw-md-25{max-width: 25% !important;}.mw-md-50{max-width: 50% !important;}.mw-md-75{max-width: 75% !important;}.mw-md-100{max-width: 100% !important;}.mw-md-auto{max-width: auto !important;}.h-md-0{height: 0 !important;}.h-md-25{height: 25% !important;}.h-md-50{height: 50% !important;}.h-md-75{height: 75% !important;}.h-md-100{height: 100% !important;}.h-md-auto{height: auto !important;}.mh-md-0{max-height: 0 !important;}.mh-md-25{max-height: 25% !important;}.mh-md-50{max-height: 50% !important;}.mh-md-75{max-height: 75% !important;}.mh-md-100{max-height: 100% !important;}.mh-md-auto{max-height: auto !important;}.flex-md-fill{flex: 1 1 auto !important;}.flex-md-row{flex-direction: row !important;}.flex-md-column{flex-direction: column !important;}.flex-md-row-reverse{flex-direction: row-reverse !important;}.flex-md-column-reverse{flex-direction: column-reverse !important;}.flex-md-grow-0{flex-grow: 0 !important;}.flex-md-grow-1{flex-grow: 1 !important;}.flex-md-shrink-0{flex-shrink: 0 !important;}.flex-md-shrink-1{flex-shrink: 1 !important;}.flex-md-wrap{flex-wrap: wrap !important;}.flex-md-nowrap{flex-wrap: nowrap !important;}.flex-md-wrap-reverse{flex-wrap: wrap-reverse !important;}.gap-md-0{gap: 0 !important;}.gap-md-1{gap: 0.25rem !important;}.gap-md-2{gap: 0.5rem !important;}.gap-md-3{gap: 1rem !important;}.gap-md-4{gap: 1.5rem !important;}.gap-md-5{gap: 3rem !important;}.justify-content-md-start{-webkit-box-pack: start !important; justify-content: flex-start !important;}.justify-content-md-end{-webkit-box-pack: end !important; justify-content: flex-end !important;}.justify-content-md-center{justify-content: center !important;}.justify-content-md-between{justify-content: space-between !important;}.justify-content-md-around{justify-content: space-around !important;}.justify-content-md-evenly{justify-content: space-evenly !important;}.align-items-md-start{align-items: flex-start !important;}.align-items-md-end{align-items: flex-end !important;}.align-items-md-center{align-items: center !important;}.align-items-md-baseline{align-items: baseline !important;}.align-items-md-stretch{align-items: stretch !important;}.align-content-md-start{align-content: flex-start !important;}.align-content-md-end{align-content: flex-end !important;}.align-content-md-center{align-content: center !important;}.align-content-md-between{align-content: space-between !important;}.align-content-md-around{align-content: space-around !important;}.align-content-md-stretch{align-content: stretch !important;}.align-self-md-auto{align-self: auto !important;}.align-self-md-start{align-self: flex-start !important;}.align-self-md-end{align-self: flex-end !important;}.align-self-md-center{align-self: center !important;}.align-self-md-baseline{align-self: baseline !important;}.align-self-md-stretch{align-self: stretch !important;}.order-md-first{order: -1 !important;}.order-md-last{order: 13 !important;}.order-md-0{order: 0 !important;}.order-md-1{order: 1 !important;}.order-md-2{order: 2 !important;}.order-md-3{order: 3 !important;}.order-md-4{order: 4 !important;}.order-md-5{order: 5 !important;}.order-md-6{order: 6 !important;}.order-md-7{order: 7 !important;}.order-md-8{order: 8 !important;}.order-md-9{order: 9 !important;}.order-md-10{order: 10 !important;}.order-md-11{order: 11 !important;}.order-md-12{order: 12 !important;}.m-md-0{margin: 0 !important;}.m-md-1{margin: 0.25rem !important;}.m-md-2{margin: 0.5rem !important;}.m-md-3{margin: 1rem !important;}.m-md-4{margin: 1.5rem !important;}.m-md-5{margin: 3rem !important;}.m-md-auto{margin: auto !important;}.mx-md-0{margin-right: 0 !important; margin-left: 0 !important;}.mx-md-1{margin-right: 0.25rem !important; margin-left: 0.25rem !important;}.mx-md-2{margin-right: 0.5rem !important; margin-left: 0.5rem !important;}.mx-md-3{margin-right: 1rem !important; margin-left: 1rem !important;}.mx-md-4{margin-right: 1.5rem !important; margin-left: 1.5rem !important;}.mx-md-5{margin-right: 3rem !important; margin-left: 3rem !important;}.mx-md-auto{margin-right: auto !important; margin-left: auto !important;}.my-md-0{margin-top: 0 !important; margin-bottom: 0 !important;}.my-md-1{margin-top: 0.25rem !important; margin-bottom: 0.25rem !important;}.my-md-2{margin-top: 0.5rem !important; margin-bottom: 0.5rem !important;}.my-md-3{margin-top: 1rem !important; margin-bottom: 1rem !important;}.my-md-4{margin-top: 1.5rem !important; margin-bottom: 1.5rem !important;}.my-md-5{margin-top: 3rem !important; margin-bottom: 3rem !important;}.my-md-auto{margin-top: auto !important; margin-bottom: auto !important;}.mt-md-0{margin-top: 0 !important;}.mt-md-1{margin-top: 0.25rem !important;}.mt-md-2{margin-top: 0.5rem !important;}.mt-md-3{margin-top: 1rem !important;}.mt-md-4{margin-top: 1.5rem !important;}.mt-md-5{margin-top: 3rem !important;}.mt-md-auto{margin-top: auto !important;}.me-md-0{margin-right: 0 !important;}.me-md-1{margin-right: 0.25rem !important;}.me-md-2{margin-right: 0.5rem !important;}.me-md-3{margin-right: 1rem !important;}.me-md-4{margin-right: 1.5rem !important;}.me-md-5{margin-right: 3rem !important;}.me-md-auto{margin-right: auto !important;}.mb-md-0{margin-bottom: 0 !important;}.mb-md-1{margin-bottom: 0.25rem !important;}.mb-md-2{margin-bottom: 0.5rem !important;}.mb-md-3{margin-bottom: 1rem !important;}.mb-md-4{margin-bottom: 1.5rem !important;}.mb-md-5{margin-bottom: 3rem !important;}.mb-md-auto{margin-bottom: auto !important;}.ms-md-0{margin-left: 0 !important;}.ms-md-1{margin-left: 0.25rem !important;}.ms-md-2{margin-left: 0.5rem !important;}.ms-md-3{margin-left: 1rem !important;}.ms-md-4{margin-left: 1.5rem !important;}.ms-md-5{margin-left: 3rem !important;}.ms-md-auto{margin-left: auto !important;}.p-md-0{padding: 0 !important;}.p-md-1{padding: 0.25rem !important;}.p-md-2{padding: 0.5rem !important;}.p-md-3{padding: 1rem !important;}.p-md-4{padding: 1.5rem !important;}.p-md-5{padding: 3rem !important;}.px-md-0{padding-right: 0 !important; padding-left: 0 !important;}.px-md-1{padding-right: 0.25rem !important; padding-left: 0.25rem !important;}.px-md-2{padding-right: 0.5rem !important; padding-left: 0.5rem !important;}.px-md-3{padding-right: 1rem !important; padding-left: 1rem !important;}.px-md-4{padding-right: 1.5rem !important; padding-left: 1.5rem !important;}.px-md-5{padding-right: 3rem !important; padding-left: 3rem !important;}.py-md-0{padding-top: 0 !important; padding-bottom: 0 !important;}.py-md-1{padding-top: 0.25rem !important; padding-bottom: 0.25rem !important;}.py-md-2{padding-top: 0.5rem !important; padding-bottom: 0.5rem !important;}.py-md-3{padding-top: 1rem !important; padding-bottom: 1rem !important;}.py-md-4{padding-top: 1.5rem !important; padding-bottom: 1.5rem !important;}.py-md-5{padding-top: 3rem !important; padding-bottom: 3rem !important;}.pt-md-0{padding-top: 0 !important;}.pt-md-1{padding-top: 0.25rem !important;}.pt-md-2{padding-top: 0.5rem !important;}.pt-md-3{padding-top: 1rem !important;}.pt-md-4{padding-top: 1.5rem !important;}.pt-md-5{padding-top: 3rem !important;}.pe-md-0{padding-right: 0 !important;}.pe-md-1{padding-right: 0.25rem !important;}.pe-md-2{padding-right: 0.5rem !important;}.pe-md-3{padding-right: 1rem !important;}.pe-md-4{padding-right: 1.5rem !important;}.pe-md-5{padding-right: 3rem !important;}.pb-md-0{padding-bottom: 0 !important;}.pb-md-1{padding-bottom: 0.25rem !important;}.pb-md-2{padding-bottom: 0.5rem !important;}.pb-md-3{padding-bottom: 1rem !important;}.pb-md-4{padding-bottom: 1.5rem !important;}.pb-md-5{padding-bottom: 3rem !important;}.ps-md-0{padding-left: 0 !important;}.ps-md-1{padding-left: 0.25rem !important;}.ps-md-2{padding-left: 0.5rem !important;}.ps-md-3{padding-left: 1rem !important;}.ps-md-4{padding-left: 1.5rem !important;}.ps-md-5{padding-left: 3rem !important;}.text-md-start{text-align: left !important;}.text-md-end{text-align: right !important;}.text-md-center{text-align: center !important;}.flex-basis-md-0{flex-basis: 0 !important;}.flex-basis-md-25{flex-basis: 25% !important;}.flex-basis-md-50{flex-basis: 50% !important;}.flex-basis-md-75{flex-basis: 75% !important;}.flex-basis-md-100{flex-basis: 100% !important;}.flex-basis-md-auto{flex-basis: auto !important;}}@media (min-width: 992px){.float-lg-start{float: left !important;}.float-lg-end{float: right !important;}.float-lg-none{float: none !important;}.d-lg-inline{display: inline !important;}.d-lg-inline-block{display: inline-block !important;}.d-lg-block{display: block !important;}.d-lg-grid{display: grid !important;}.d-lg-table{display: table !important;}.d-lg-table-row{display: table-row !important;}.d-lg-table-cell{display: table-cell !important;}.d-lg-flex{display: -webkit-box !important; display: -webkit-flex !important; display: flex !important;}.d-lg-inline-flex{display: -webkit-inline-box !important; display: -webkit-inline-flex !important; display: inline-flex !important;}.d-lg-none{display: none !important;}.d-lg-contents{display: contents !important;}.position-lg-static{position: static !important;}.position-lg-relative{position: relative !important;}.position-lg-absolute{position: absolute !important;}.position-lg-fixed{position: fixed !important;}.position-lg-sticky{position: sticky !important;}.w-lg-0{width: 0 !important;}.w-lg-25{width: 25% !important;}.w-lg-50{width: 50% !important;}.w-lg-75{width: 75% !important;}.w-lg-100{width: 100% !important;}.w-lg-auto{width: auto !important;}.mw-lg-0{max-width: 0 !important;}.mw-lg-25{max-width: 25% !important;}.mw-lg-50{max-width: 50% !important;}.mw-lg-75{max-width: 75% !important;}.mw-lg-100{max-width: 100% !important;}.mw-lg-auto{max-width: auto !important;}.h-lg-0{height: 0 !important;}.h-lg-25{height: 25% !important;}.h-lg-50{height: 50% !important;}.h-lg-75{height: 75% !important;}.h-lg-100{height: 100% !important;}.h-lg-auto{height: auto !important;}.mh-lg-0{max-height: 0 !important;}.mh-lg-25{max-height: 25% !important;}.mh-lg-50{max-height: 50% !important;}.mh-lg-75{max-height: 75% !important;}.mh-lg-100{max-height: 100% !important;}.mh-lg-auto{max-height: auto !important;}.flex-lg-fill{flex: 1 1 auto !important;}.flex-lg-row{flex-direction: row !important;}.flex-lg-column{flex-direction: column !important;}.flex-lg-row-reverse{flex-direction: row-reverse !important;}.flex-lg-column-reverse{flex-direction: column-reverse !important;}.flex-lg-grow-0{flex-grow: 0 !important;}.flex-lg-grow-1{flex-grow: 1 !important;}.flex-lg-shrink-0{flex-shrink: 0 !important;}.flex-lg-shrink-1{flex-shrink: 1 !important;}.flex-lg-wrap{flex-wrap: wrap !important;}.flex-lg-nowrap{flex-wrap: nowrap !important;}.flex-lg-wrap-reverse{flex-wrap: wrap-reverse !important;}.gap-lg-0{gap: 0 !important;}.gap-lg-1{gap: 0.25rem !important;}.gap-lg-2{gap: 0.5rem !important;}.gap-lg-3{gap: 1rem !important;}.gap-lg-4{gap: 1.5rem !important;}.gap-lg-5{gap: 3rem !important;}.justify-content-lg-start{-webkit-box-pack: start !important; justify-content: flex-start !important;}.justify-content-lg-end{-webkit-box-pack: end !important; justify-content: flex-end !important;}.justify-content-lg-center{justify-content: center !important;}.justify-content-lg-between{justify-content: space-between !important;}.justify-content-lg-around{justify-content: space-around !important;}.justify-content-lg-evenly{justify-content: space-evenly !important;}.align-items-lg-start{align-items: flex-start !important;}.align-items-lg-end{align-items: flex-end !important;}.align-items-lg-center{align-items: center !important;}.align-items-lg-baseline{align-items: baseline !important;}.align-items-lg-stretch{align-items: stretch !important;}.align-content-lg-start{align-content: flex-start !important;}.align-content-lg-end{align-content: flex-end !important;}.align-content-lg-center{align-content: center !important;}.align-content-lg-between{align-content: space-between !important;}.align-content-lg-around{align-content: space-around !important;}.align-content-lg-stretch{align-content: stretch !important;}.align-self-lg-auto{align-self: auto !important;}.align-self-lg-start{align-self: flex-start !important;}.align-self-lg-end{align-self: flex-end !important;}.align-self-lg-center{align-self: center !important;}.align-self-lg-baseline{align-self: baseline !important;}.align-self-lg-stretch{align-self: stretch !important;}.order-lg-first{order: -1 !important;}.order-lg-last{order: 13 !important;}.order-lg-0{order: 0 !important;}.order-lg-1{order: 1 !important;}.order-lg-2{order: 2 !important;}.order-lg-3{order: 3 !important;}.order-lg-4{order: 4 !important;}.order-lg-5{order: 5 !important;}.order-lg-6{order: 6 !important;}.order-lg-7{order: 7 !important;}.order-lg-8{order: 8 !important;}.order-lg-9{order: 9 !important;}.order-lg-10{order: 10 !important;}.order-lg-11{order: 11 !important;}.order-lg-12{order: 12 !important;}.m-lg-0{margin: 0 !important;}.m-lg-1{margin: 0.25rem !important;}.m-lg-2{margin: 0.5rem !important;}.m-lg-3{margin: 1rem !important;}.m-lg-4{margin: 1.5rem !important;}.m-lg-5{margin: 3rem !important;}.m-lg-auto{margin: auto !important;}.mx-lg-0{margin-right: 0 !important; margin-left: 0 !important;}.mx-lg-1{margin-right: 0.25rem !important; margin-left: 0.25rem !important;}.mx-lg-2{margin-right: 0.5rem !important; margin-left: 0.5rem !important;}.mx-lg-3{margin-right: 1rem !important; margin-left: 1rem !important;}.mx-lg-4{margin-right: 1.5rem !important; margin-left: 1.5rem !important;}.mx-lg-5{margin-right: 3rem !important; margin-left: 3rem !important;}.mx-lg-auto{margin-right: auto !important; margin-left: auto !important;}.my-lg-0{margin-top: 0 !important; margin-bottom: 0 !important;}.my-lg-1{margin-top: 0.25rem !important; margin-bottom: 0.25rem !important;}.my-lg-2{margin-top: 0.5rem !important; margin-bottom: 0.5rem !important;}.my-lg-3{margin-top: 1rem !important; margin-bottom: 1rem !important;}.my-lg-4{margin-top: 1.5rem !important; margin-bottom: 1.5rem !important;}.my-lg-5{margin-top: 3rem !important; margin-bottom: 3rem !important;}.my-lg-auto{margin-top: auto !important; margin-bottom: auto !important;}.mt-lg-0{margin-top: 0 !important;}.mt-lg-1{margin-top: 0.25rem !important;}.mt-lg-2{margin-top: 0.5rem !important;}.mt-lg-3{margin-top: 1rem !important;}.mt-lg-4{margin-top: 1.5rem !important;}.mt-lg-5{margin-top: 3rem !important;}.mt-lg-auto{margin-top: auto !important;}.me-lg-0{margin-right: 0 !important;}.me-lg-1{margin-right: 0.25rem !important;}.me-lg-2{margin-right: 0.5rem !important;}.me-lg-3{margin-right: 1rem !important;}.me-lg-4{margin-right: 1.5rem !important;}.me-lg-5{margin-right: 3rem !important;}.me-lg-auto{margin-right: auto !important;}.mb-lg-0{margin-bottom: 0 !important;}.mb-lg-1{margin-bottom: 0.25rem !important;}.mb-lg-2{margin-bottom: 0.5rem !important;}.mb-lg-3{margin-bottom: 1rem !important;}.mb-lg-4{margin-bottom: 1.5rem !important;}.mb-lg-5{margin-bottom: 3rem !important;}.mb-lg-auto{margin-bottom: auto !important;}.ms-lg-0{margin-left: 0 !important;}.ms-lg-1{margin-left: 0.25rem !important;}.ms-lg-2{margin-left: 0.5rem !important;}.ms-lg-3{margin-left: 1rem !important;}.ms-lg-4{margin-left: 1.5rem !important;}.ms-lg-5{margin-left: 3rem !important;}.ms-lg-auto{margin-left: auto !important;}.p-lg-0{padding: 0 !important;}.p-lg-1{padding: 0.25rem !important;}.p-lg-2{padding: 0.5rem !important;}.p-lg-3{padding: 1rem !important;}.p-lg-4{padding: 1.5rem !important;}.p-lg-5{padding: 3rem !important;}.px-lg-0{padding-right: 0 !important; padding-left: 0 !important;}.px-lg-1{padding-right: 0.25rem !important; padding-left: 0.25rem !important;}.px-lg-2{padding-right: 0.5rem !important; padding-left: 0.5rem !important;}.px-lg-3{padding-right: 1rem !important; padding-left: 1rem !important;}.px-lg-4{padding-right: 1.5rem !important; padding-left: 1.5rem !important;}.px-lg-5{padding-right: 3rem !important; padding-left: 3rem !important;}.py-lg-0{padding-top: 0 !important; padding-bottom: 0 !important;}.py-lg-1{padding-top: 0.25rem !important; padding-bottom: 0.25rem !important;}.py-lg-2{padding-top: 0.5rem !important; padding-bottom: 0.5rem !important;}.py-lg-3{padding-top: 1rem !important; padding-bottom: 1rem !important;}.py-lg-4{padding-top: 1.5rem !important; padding-bottom: 1.5rem !important;}.py-lg-5{padding-top: 3rem !important; padding-bottom: 3rem !important;}.pt-lg-0{padding-top: 0 !important;}.pt-lg-1{padding-top: 0.25rem !important;}.pt-lg-2{padding-top: 0.5rem !important;}.pt-lg-3{padding-top: 1rem !important;}.pt-lg-4{padding-top: 1.5rem !important;}.pt-lg-5{padding-top: 3rem !important;}.pe-lg-0{padding-right: 0 !important;}.pe-lg-1{padding-right: 0.25rem !important;}.pe-lg-2{padding-right: 0.5rem !important;}.pe-lg-3{padding-right: 1rem !important;}.pe-lg-4{padding-right: 1.5rem !important;}.pe-lg-5{padding-right: 3rem !important;}.pb-lg-0{padding-bottom: 0 !important;}.pb-lg-1{padding-bottom: 0.25rem !important;}.pb-lg-2{padding-bottom: 0.5rem !important;}.pb-lg-3{padding-bottom: 1rem !important;}.pb-lg-4{padding-bottom: 1.5rem !important;}.pb-lg-5{padding-bottom: 3rem !important;}.ps-lg-0{padding-left: 0 !important;}.ps-lg-1{padding-left: 0.25rem !important;}.ps-lg-2{padding-left: 0.5rem !important;}.ps-lg-3{padding-left: 1rem !important;}.ps-lg-4{padding-left: 1.5rem !important;}.ps-lg-5{padding-left: 3rem !important;}.text-lg-start{text-align: left !important;}.text-lg-end{text-align: right !important;}.text-lg-center{text-align: center !important;}.flex-basis-lg-0{flex-basis: 0 !important;}.flex-basis-lg-25{flex-basis: 25% !important;}.flex-basis-lg-50{flex-basis: 50% !important;}.flex-basis-lg-75{flex-basis: 75% !important;}.flex-basis-lg-100{flex-basis: 100% !important;}.flex-basis-lg-auto{flex-basis: auto !important;}}@media (min-width: 1200px){.float-xl-start{float: left !important;}.float-xl-end{float: right !important;}.float-xl-none{float: none !important;}.d-xl-inline{display: inline !important;}.d-xl-inline-block{display: inline-block !important;}.d-xl-block{display: block !important;}.d-xl-grid{display: grid !important;}.d-xl-table{display: table !important;}.d-xl-table-row{display: table-row !important;}.d-xl-table-cell{display: table-cell !important;}.d-xl-flex{display: -webkit-box !important; display: -webkit-flex !important; display: flex !important;}.d-xl-inline-flex{display: -webkit-inline-box !important; display: -webkit-inline-flex !important; display: inline-flex !important;}.d-xl-none{display: none !important;}.d-xl-contents{display: contents !important;}.position-xl-static{position: static !important;}.position-xl-relative{position: relative !important;}.position-xl-absolute{position: absolute !important;}.position-xl-fixed{position: fixed !important;}.position-xl-sticky{position: sticky !important;}.w-xl-0{width: 0 !important;}.w-xl-25{width: 25% !important;}.w-xl-50{width: 50% !important;}.w-xl-75{width: 75% !important;}.w-xl-100{width: 100% !important;}.w-xl-auto{width: auto !important;}.mw-xl-0{max-width: 0 !important;}.mw-xl-25{max-width: 25% !important;}.mw-xl-50{max-width: 50% !important;}.mw-xl-75{max-width: 75% !important;}.mw-xl-100{max-width: 100% !important;}.mw-xl-auto{max-width: auto !important;}.h-xl-0{height: 0 !important;}.h-xl-25{height: 25% !important;}.h-xl-50{height: 50% !important;}.h-xl-75{height: 75% !important;}.h-xl-100{height: 100% !important;}.h-xl-auto{height: auto !important;}.mh-xl-0{max-height: 0 !important;}.mh-xl-25{max-height: 25% !important;}.mh-xl-50{max-height: 50% !important;}.mh-xl-75{max-height: 75% !important;}.mh-xl-100{max-height: 100% !important;}.mh-xl-auto{max-height: auto !important;}.flex-xl-fill{flex: 1 1 auto !important;}.flex-xl-row{flex-direction: row !important;}.flex-xl-column{flex-direction: column !important;}.flex-xl-row-reverse{flex-direction: row-reverse !important;}.flex-xl-column-reverse{flex-direction: column-reverse !important;}.flex-xl-grow-0{flex-grow: 0 !important;}.flex-xl-grow-1{flex-grow: 1 !important;}.flex-xl-shrink-0{flex-shrink: 0 !important;}.flex-xl-shrink-1{flex-shrink: 1 !important;}.flex-xl-wrap{flex-wrap: wrap !important;}.flex-xl-nowrap{flex-wrap: nowrap !important;}.flex-xl-wrap-reverse{flex-wrap: wrap-reverse !important;}.gap-xl-0{gap: 0 !important;}.gap-xl-1{gap: 0.25rem !important;}.gap-xl-2{gap: 0.5rem !important;}.gap-xl-3{gap: 1rem !important;}.gap-xl-4{gap: 1.5rem !important;}.gap-xl-5{gap: 3rem !important;}.justify-content-xl-start{-webkit-box-pack: start !important; justify-content: flex-start !important;}.justify-content-xl-end{-webkit-box-pack: end !important; justify-content: flex-end !important;}.justify-content-xl-center{justify-content: center !important;}.justify-content-xl-between{justify-content: space-between !important;}.justify-content-xl-around{justify-content: space-around !important;}.justify-content-xl-evenly{justify-content: space-evenly !important;}.align-items-xl-start{align-items: flex-start !important;}.align-items-xl-end{align-items: flex-end !important;}.align-items-xl-center{align-items: center !important;}.align-items-xl-baseline{align-items: baseline !important;}.align-items-xl-stretch{align-items: stretch !important;}.align-content-xl-start{align-content: flex-start !important;}.align-content-xl-end{align-content: flex-end !important;}.align-content-xl-center{align-content: center !important;}.align-content-xl-between{align-content: space-between !important;}.align-content-xl-around{align-content: space-around !important;}.align-content-xl-stretch{align-content: stretch !important;}.align-self-xl-auto{align-self: auto !important;}.align-self-xl-start{align-self: flex-start !important;}.align-self-xl-end{align-self: flex-end !important;}.align-self-xl-center{align-self: center !important;}.align-self-xl-baseline{align-self: baseline !important;}.align-self-xl-stretch{align-self: stretch !important;}.order-xl-first{order: -1 !important;}.order-xl-last{order: 13 !important;}.order-xl-0{order: 0 !important;}.order-xl-1{order: 1 !important;}.order-xl-2{order: 2 !important;}.order-xl-3{order: 3 !important;}.order-xl-4{order: 4 !important;}.order-xl-5{order: 5 !important;}.order-xl-6{order: 6 !important;}.order-xl-7{order: 7 !important;}.order-xl-8{order: 8 !important;}.order-xl-9{order: 9 !important;}.order-xl-10{order: 10 !important;}.order-xl-11{order: 11 !important;}.order-xl-12{order: 12 !important;}.m-xl-0{margin: 0 !important;}.m-xl-1{margin: 0.25rem !important;}.m-xl-2{margin: 0.5rem !important;}.m-xl-3{margin: 1rem !important;}.m-xl-4{margin: 1.5rem !important;}.m-xl-5{margin: 3rem !important;}.m-xl-auto{margin: auto !important;}.mx-xl-0{margin-right: 0 !important; margin-left: 0 !important;}.mx-xl-1{margin-right: 0.25rem !important; margin-left: 0.25rem !important;}.mx-xl-2{margin-right: 0.5rem !important; margin-left: 0.5rem !important;}.mx-xl-3{margin-right: 1rem !important; margin-left: 1rem !important;}.mx-xl-4{margin-right: 1.5rem !important; margin-left: 1.5rem !important;}.mx-xl-5{margin-right: 3rem !important; margin-left: 3rem !important;}.mx-xl-auto{margin-right: auto !important; margin-left: auto !important;}.my-xl-0{margin-top: 0 !important; margin-bottom: 0 !important;}.my-xl-1{margin-top: 0.25rem !important; margin-bottom: 0.25rem !important;}.my-xl-2{margin-top: 0.5rem !important; margin-bottom: 0.5rem !important;}.my-xl-3{margin-top: 1rem !important; margin-bottom: 1rem !important;}.my-xl-4{margin-top: 1.5rem !important; margin-bottom: 1.5rem !important;}.my-xl-5{margin-top: 3rem !important; margin-bottom: 3rem !important;}.my-xl-auto{margin-top: auto !important; margin-bottom: auto !important;}.mt-xl-0{margin-top: 0 !important;}.mt-xl-1{margin-top: 0.25rem !important;}.mt-xl-2{margin-top: 0.5rem !important;}.mt-xl-3{margin-top: 1rem !important;}.mt-xl-4{margin-top: 1.5rem !important;}.mt-xl-5{margin-top: 3rem !important;}.mt-xl-auto{margin-top: auto !important;}.me-xl-0{margin-right: 0 !important;}.me-xl-1{margin-right: 0.25rem !important;}.me-xl-2{margin-right: 0.5rem !important;}.me-xl-3{margin-right: 1rem !important;}.me-xl-4{margin-right: 1.5rem !important;}.me-xl-5{margin-right: 3rem !important;}.me-xl-auto{margin-right: auto !important;}.mb-xl-0{margin-bottom: 0 !important;}.mb-xl-1{margin-bottom: 0.25rem !important;}.mb-xl-2{margin-bottom: 0.5rem !important;}.mb-xl-3{margin-bottom: 1rem !important;}.mb-xl-4{margin-bottom: 1.5rem !important;}.mb-xl-5{margin-bottom: 3rem !important;}.mb-xl-auto{margin-bottom: auto !important;}.ms-xl-0{margin-left: 0 !important;}.ms-xl-1{margin-left: 0.25rem !important;}.ms-xl-2{margin-left: 0.5rem !important;}.ms-xl-3{margin-left: 1rem !important;}.ms-xl-4{margin-left: 1.5rem !important;}.ms-xl-5{margin-left: 3rem !important;}.ms-xl-auto{margin-left: auto !important;}.p-xl-0{padding: 0 !important;}.p-xl-1{padding: 0.25rem !important;}.p-xl-2{padding: 0.5rem !important;}.p-xl-3{padding: 1rem !important;}.p-xl-4{padding: 1.5rem !important;}.p-xl-5{padding: 3rem !important;}.px-xl-0{padding-right: 0 !important; padding-left: 0 !important;}.px-xl-1{padding-right: 0.25rem !important; padding-left: 0.25rem !important;}.px-xl-2{padding-right: 0.5rem !important; padding-left: 0.5rem !important;}.px-xl-3{padding-right: 1rem !important; padding-left: 1rem !important;}.px-xl-4{padding-right: 1.5rem !important; padding-left: 1.5rem !important;}.px-xl-5{padding-right: 3rem !important; padding-left: 3rem !important;}.py-xl-0{padding-top: 0 !important; padding-bottom: 0 !important;}.py-xl-1{padding-top: 0.25rem !important; padding-bottom: 0.25rem !important;}.py-xl-2{padding-top: 0.5rem !important; padding-bottom: 0.5rem !important;}.py-xl-3{padding-top: 1rem !important; padding-bottom: 1rem !important;}.py-xl-4{padding-top: 1.5rem !important; padding-bottom: 1.5rem !important;}.py-xl-5{padding-top: 3rem !important; padding-bottom: 3rem !important;}.pt-xl-0{padding-top: 0 !important;}.pt-xl-1{padding-top: 0.25rem !important;}.pt-xl-2{padding-top: 0.5rem !important;}.pt-xl-3{padding-top: 1rem !important;}.pt-xl-4{padding-top: 1.5rem !important;}.pt-xl-5{padding-top: 3rem !important;}.pe-xl-0{padding-right: 0 !important;}.pe-xl-1{padding-right: 0.25rem !important;}.pe-xl-2{padding-right: 0.5rem !important;}.pe-xl-3{padding-right: 1rem !important;}.pe-xl-4{padding-right: 1.5rem !important;}.pe-xl-5{padding-right: 3rem !important;}.pb-xl-0{padding-bottom: 0 !important;}.pb-xl-1{padding-bottom: 0.25rem !important;}.pb-xl-2{padding-bottom: 0.5rem !important;}.pb-xl-3{padding-bottom: 1rem !important;}.pb-xl-4{padding-bottom: 1.5rem !important;}.pb-xl-5{padding-bottom: 3rem !important;}.ps-xl-0{padding-left: 0 !important;}.ps-xl-1{padding-left: 0.25rem !important;}.ps-xl-2{padding-left: 0.5rem !important;}.ps-xl-3{padding-left: 1rem !important;}.ps-xl-4{padding-left: 1.5rem !important;}.ps-xl-5{padding-left: 3rem !important;}.text-xl-start{text-align: left !important;}.text-xl-end{text-align: right !important;}.text-xl-center{text-align: center !important;}.flex-basis-xl-0{flex-basis: 0 !important;}.flex-basis-xl-25{flex-basis: 25% !important;}.flex-basis-xl-50{flex-basis: 50% !important;}.flex-basis-xl-75{flex-basis: 75% !important;}.flex-basis-xl-100{flex-basis: 100% !important;}.flex-basis-xl-auto{flex-basis: auto !important;}}@media (min-width: 1400px){.float-xxl-start{float: left !important;}.float-xxl-end{float: right !important;}.float-xxl-none{float: none !important;}.d-xxl-inline{display: inline !important;}.d-xxl-inline-block{display: inline-block !important;}.d-xxl-block{display: block !important;}.d-xxl-grid{display: grid !important;}.d-xxl-table{display: table !important;}.d-xxl-table-row{display: table-row !important;}.d-xxl-table-cell{display: table-cell !important;}.d-xxl-flex{display: -webkit-box !important; display: -webkit-flex !important; display: flex !important;}.d-xxl-inline-flex{display: -webkit-inline-box !important; display: -webkit-inline-flex !important; display: inline-flex !important;}.d-xxl-none{display: none !important;}.d-xxl-contents{display: contents !important;}.position-xxl-static{position: static !important;}.position-xxl-relative{position: relative !important;}.position-xxl-absolute{position: absolute !important;}.position-xxl-fixed{position: fixed !important;}.position-xxl-sticky{position: sticky !important;}.w-xxl-0{width: 0 !important;}.w-xxl-25{width: 25% !important;}.w-xxl-50{width: 50% !important;}.w-xxl-75{width: 75% !important;}.w-xxl-100{width: 100% !important;}.w-xxl-auto{width: auto !important;}.mw-xxl-0{max-width: 0 !important;}.mw-xxl-25{max-width: 25% !important;}.mw-xxl-50{max-width: 50% !important;}.mw-xxl-75{max-width: 75% !important;}.mw-xxl-100{max-width: 100% !important;}.mw-xxl-auto{max-width: auto !important;}.h-xxl-0{height: 0 !important;}.h-xxl-25{height: 25% !important;}.h-xxl-50{height: 50% !important;}.h-xxl-75{height: 75% !important;}.h-xxl-100{height: 100% !important;}.h-xxl-auto{height: auto !important;}.mh-xxl-0{max-height: 0 !important;}.mh-xxl-25{max-height: 25% !important;}.mh-xxl-50{max-height: 50% !important;}.mh-xxl-75{max-height: 75% !important;}.mh-xxl-100{max-height: 100% !important;}.mh-xxl-auto{max-height: auto !important;}.flex-xxl-fill{flex: 1 1 auto !important;}.flex-xxl-row{flex-direction: row !important;}.flex-xxl-column{flex-direction: column !important;}.flex-xxl-row-reverse{flex-direction: row-reverse !important;}.flex-xxl-column-reverse{flex-direction: column-reverse !important;}.flex-xxl-grow-0{flex-grow: 0 !important;}.flex-xxl-grow-1{flex-grow: 1 !important;}.flex-xxl-shrink-0{flex-shrink: 0 !important;}.flex-xxl-shrink-1{flex-shrink: 1 !important;}.flex-xxl-wrap{flex-wrap: wrap !important;}.flex-xxl-nowrap{flex-wrap: nowrap !important;}.flex-xxl-wrap-reverse{flex-wrap: wrap-reverse !important;}.gap-xxl-0{gap: 0 !important;}.gap-xxl-1{gap: 0.25rem !important;}.gap-xxl-2{gap: 0.5rem !important;}.gap-xxl-3{gap: 1rem !important;}.gap-xxl-4{gap: 1.5rem !important;}.gap-xxl-5{gap: 3rem !important;}.justify-content-xxl-start{-webkit-box-pack: start !important; justify-content: flex-start !important;}.justify-content-xxl-end{-webkit-box-pack: end !important; justify-content: flex-end !important;}.justify-content-xxl-center{justify-content: center !important;}.justify-content-xxl-between{justify-content: space-between !important;}.justify-content-xxl-around{justify-content: space-around !important;}.justify-content-xxl-evenly{justify-content: space-evenly !important;}.align-items-xxl-start{align-items: flex-start !important;}.align-items-xxl-end{align-items: flex-end !important;}.align-items-xxl-center{align-items: center !important;}.align-items-xxl-baseline{align-items: baseline !important;}.align-items-xxl-stretch{align-items: stretch !important;}.align-content-xxl-start{align-content: flex-start !important;}.align-content-xxl-end{align-content: flex-end !important;}.align-content-xxl-center{align-content: center !important;}.align-content-xxl-between{align-content: space-between !important;}.align-content-xxl-around{align-content: space-around !important;}.align-content-xxl-stretch{align-content: stretch !important;}.align-self-xxl-auto{align-self: auto !important;}.align-self-xxl-start{align-self: flex-start !important;}.align-self-xxl-end{align-self: flex-end !important;}.align-self-xxl-center{align-self: center !important;}.align-self-xxl-baseline{align-self: baseline !important;}.align-self-xxl-stretch{align-self: stretch !important;}.order-xxl-first{order: -1 !important;}.order-xxl-last{order: 13 !important;}.order-xxl-0{order: 0 !important;}.order-xxl-1{order: 1 !important;}.order-xxl-2{order: 2 !important;}.order-xxl-3{order: 3 !important;}.order-xxl-4{order: 4 !important;}.order-xxl-5{order: 5 !important;}.order-xxl-6{order: 6 !important;}.order-xxl-7{order: 7 !important;}.order-xxl-8{order: 8 !important;}.order-xxl-9{order: 9 !important;}.order-xxl-10{order: 10 !important;}.order-xxl-11{order: 11 !important;}.order-xxl-12{order: 12 !important;}.m-xxl-0{margin: 0 !important;}.m-xxl-1{margin: 0.25rem !important;}.m-xxl-2{margin: 0.5rem !important;}.m-xxl-3{margin: 1rem !important;}.m-xxl-4{margin: 1.5rem !important;}.m-xxl-5{margin: 3rem !important;}.m-xxl-auto{margin: auto !important;}.mx-xxl-0{margin-right: 0 !important; margin-left: 0 !important;}.mx-xxl-1{margin-right: 0.25rem !important; margin-left: 0.25rem !important;}.mx-xxl-2{margin-right: 0.5rem !important; margin-left: 0.5rem !important;}.mx-xxl-3{margin-right: 1rem !important; margin-left: 1rem !important;}.mx-xxl-4{margin-right: 1.5rem !important; margin-left: 1.5rem !important;}.mx-xxl-5{margin-right: 3rem !important; margin-left: 3rem !important;}.mx-xxl-auto{margin-right: auto !important; margin-left: auto !important;}.my-xxl-0{margin-top: 0 !important; margin-bottom: 0 !important;}.my-xxl-1{margin-top: 0.25rem !important; margin-bottom: 0.25rem !important;}.my-xxl-2{margin-top: 0.5rem !important; margin-bottom: 0.5rem !important;}.my-xxl-3{margin-top: 1rem !important; margin-bottom: 1rem !important;}.my-xxl-4{margin-top: 1.5rem !important; margin-bottom: 1.5rem !important;}.my-xxl-5{margin-top: 3rem !important; margin-bottom: 3rem !important;}.my-xxl-auto{margin-top: auto !important; margin-bottom: auto !important;}.mt-xxl-0{margin-top: 0 !important;}.mt-xxl-1{margin-top: 0.25rem !important;}.mt-xxl-2{margin-top: 0.5rem !important;}.mt-xxl-3{margin-top: 1rem !important;}.mt-xxl-4{margin-top: 1.5rem !important;}.mt-xxl-5{margin-top: 3rem !important;}.mt-xxl-auto{margin-top: auto !important;}.me-xxl-0{margin-right: 0 !important;}.me-xxl-1{margin-right: 0.25rem !important;}.me-xxl-2{margin-right: 0.5rem !important;}.me-xxl-3{margin-right: 1rem !important;}.me-xxl-4{margin-right: 1.5rem !important;}.me-xxl-5{margin-right: 3rem !important;}.me-xxl-auto{margin-right: auto !important;}.mb-xxl-0{margin-bottom: 0 !important;}.mb-xxl-1{margin-bottom: 0.25rem !important;}.mb-xxl-2{margin-bottom: 0.5rem !important;}.mb-xxl-3{margin-bottom: 1rem !important;}.mb-xxl-4{margin-bottom: 1.5rem !important;}.mb-xxl-5{margin-bottom: 3rem !important;}.mb-xxl-auto{margin-bottom: auto !important;}.ms-xxl-0{margin-left: 0 !important;}.ms-xxl-1{margin-left: 0.25rem !important;}.ms-xxl-2{margin-left: 0.5rem !important;}.ms-xxl-3{margin-left: 1rem !important;}.ms-xxl-4{margin-left: 1.5rem !important;}.ms-xxl-5{margin-left: 3rem !important;}.ms-xxl-auto{margin-left: auto !important;}.p-xxl-0{padding: 0 !important;}.p-xxl-1{padding: 0.25rem !important;}.p-xxl-2{padding: 0.5rem !important;}.p-xxl-3{padding: 1rem !important;}.p-xxl-4{padding: 1.5rem !important;}.p-xxl-5{padding: 3rem !important;}.px-xxl-0{padding-right: 0 !important; padding-left: 0 !important;}.px-xxl-1{padding-right: 0.25rem !important; padding-left: 0.25rem !important;}.px-xxl-2{padding-right: 0.5rem !important; padding-left: 0.5rem !important;}.px-xxl-3{padding-right: 1rem !important; padding-left: 1rem !important;}.px-xxl-4{padding-right: 1.5rem !important; padding-left: 1.5rem !important;}.px-xxl-5{padding-right: 3rem !important; padding-left: 3rem !important;}.py-xxl-0{padding-top: 0 !important; padding-bottom: 0 !important;}.py-xxl-1{padding-top: 0.25rem !important; padding-bottom: 0.25rem !important;}.py-xxl-2{padding-top: 0.5rem !important; padding-bottom: 0.5rem !important;}.py-xxl-3{padding-top: 1rem !important; padding-bottom: 1rem !important;}.py-xxl-4{padding-top: 1.5rem !important; padding-bottom: 1.5rem !important;}.py-xxl-5{padding-top: 3rem !important; padding-bottom: 3rem !important;}.pt-xxl-0{padding-top: 0 !important;}.pt-xxl-1{padding-top: 0.25rem !important;}.pt-xxl-2{padding-top: 0.5rem !important;}.pt-xxl-3{padding-top: 1rem !important;}.pt-xxl-4{padding-top: 1.5rem !important;}.pt-xxl-5{padding-top: 3rem !important;}.pe-xxl-0{padding-right: 0 !important;}.pe-xxl-1{padding-right: 0.25rem !important;}.pe-xxl-2{padding-right: 0.5rem !important;}.pe-xxl-3{padding-right: 1rem !important;}.pe-xxl-4{padding-right: 1.5rem !important;}.pe-xxl-5{padding-right: 3rem !important;}.pb-xxl-0{padding-bottom: 0 !important;}.pb-xxl-1{padding-bottom: 0.25rem !important;}.pb-xxl-2{padding-bottom: 0.5rem !important;}.pb-xxl-3{padding-bottom: 1rem !important;}.pb-xxl-4{padding-bottom: 1.5rem !important;}.pb-xxl-5{padding-bottom: 3rem !important;}.ps-xxl-0{padding-left: 0 !important;}.ps-xxl-1{padding-left: 0.25rem !important;}.ps-xxl-2{padding-left: 0.5rem !important;}.ps-xxl-3{padding-left: 1rem !important;}.ps-xxl-4{padding-left: 1.5rem !important;}.ps-xxl-5{padding-left: 3rem !important;}.text-xxl-start{text-align: left !important;}.text-xxl-end{text-align: right !important;}.text-xxl-center{text-align: center !important;}.flex-basis-xxl-0{flex-basis: 0 !important;}.flex-basis-xxl-25{flex-basis: 25% !important;}.flex-basis-xxl-50{flex-basis: 50% !important;}.flex-basis-xxl-75{flex-basis: 75% !important;}.flex-basis-xxl-100{flex-basis: 100% !important;}.flex-basis-xxl-auto{flex-basis: auto !important;}}@media (min-width: 1200px){.fs-1{font-size: 2.1875rem !important;}.fs-2{font-size: 1.75rem !important;}.fs-3{font-size: 1.53125rem !important;}.fs-4{font-size: 1.3125rem !important;}}@media print{.d-print-inline{display: inline !important;}.d-print-inline-block{display: inline-block !important;}.d-print-block{display: block !important;}.d-print-grid{display: grid !important;}.d-print-table{display: table !important;}.d-print-table-row{display: table-row !important;}.d-print-table-cell{display: table-cell !important;}.d-print-flex{display: -webkit-box !important; display: -webkit-flex !important; display: flex !important;}.d-print-inline-flex{display: -webkit-inline-box !important; display: -webkit-inline-flex !important; display: inline-flex !important;}.d-print-none{display: none !important;}.d-print-contents{display: contents !important;}}\n/* /web/static/src/scss/bootstrap_review.scss */\n .alert{clear: both;}.card-body{background-color: rgba(255, 255, 255, 0.9) !important; color: #000000;}.card-body .text-muted{color: rgba(0, 0, 0, 0.7) !important;}.card-body:first-child{border-top-left-radius: calc(0.25rem - 1px); border-top-right-radius: calc(0.25rem - 1px);}.card-body:last-child{border-bottom-right-radius: calc(0.25rem - 1px); border-bottom-left-radius: calc(0.25rem - 1px);}.row.card-body{background-color: transparent !important;}.accordion .collapsing > .card-body:first-child, .accordion .collapse.show > .card-body:first-child{margin-top: 1px;}.toast-header{background-clip: border-box;}.toast-body{background-color: rgba(255, 255, 255, 0.93) !important; color: #000000;}.toast-body .text-muted, .o_colored_level .toast-body .text-muted{color: rgba(0, 0, 0, 0.7) !important;}@media (min-width: 576px){:not(.s_popup) > .modal .modal-dialog{height: 100%; padding: 1.75rem 0; margin: 0 auto;}:not(.s_popup) > .modal .modal-content{max-height: 100%;}:not(.s_popup) > .modal .modal-header, :not(.s_popup) > .modal .modal-footer{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto;}:not(.s_popup) > .modal .modal-body{overflow: auto; min-height: 0;}}.modal-backdrop{display: none;}.modal:not([data-bs-backdrop="false"]){background-color: rgba(0, 0, 0, 0.5);}.form-check .form-check-input:not(:disabled):not(.o_wysiwyg_loader), .form-check .form-check-input:not(:disabled):not(.o_wysiwyg_loader) + label, .form-select .form-check-input:not(:disabled):not(.o_wysiwyg_loader), .form-select .form-check-input:not(:disabled):not(.o_wysiwyg_loader) + label{cursor: pointer;}.form-check:hover, .form-check:hover .form-check-input:not(:disabled):not(.o_wysiwyg_loader), .form-select:hover, .form-select:hover .form-check-input:not(:disabled):not(.o_wysiwyg_loader){border-color: #714B67;}.dropdown-menu[x-placement^="top"], .dropdown-menu[x-placement^="right"], .dropdown-menu[x-placement^="bottom"], .dropdown-menu[x-placement^="left"]{right: auto;}.popover{right: auto;}\n/* /web/static/src/scss/bootstrap_review_frontend.scss */\n .bg-100{background-color: #F8F9FA !important; color: #000000;}.bg-100 .text-muted, .o_colored_level .bg-100 .text-muted{color: rgba(0, 0, 0, 0.7) !important;}a.bg-100:hover, a.bg-100:focus, button.bg-100:hover, button.bg-100:focus{background-color: #dae0e5 !important; color: #000000;}.text-100{color: #F8F9FA !important;}a.text-100:hover, a.text-100:focus{color: #bdc6d0 !important;}.bg-200{background-color: #E9ECEF !important; color: #000000;}.bg-200 .text-muted, .o_colored_level .bg-200 .text-muted{color: rgba(0, 0, 0, 0.7) !important;}a.bg-200:hover, a.bg-200:focus, button.bg-200:hover, button.bg-200:focus{background-color: #cbd3da !important; color: #000000;}.text-200{color: #E9ECEF !important;}a.text-200:hover, a.text-200:focus{color: #aeb9c4 !important;}.bg-300{background-color: #DEE2E6 !important; color: #000000;}.bg-300 .text-muted, .o_colored_level .bg-300 .text-muted{color: rgba(0, 0, 0, 0.7) !important;}a.bg-300:hover, a.bg-300:focus, button.bg-300:hover, button.bg-300:focus{background-color: #c1c9d0 !important; color: #000000;}.text-300{color: #DEE2E6 !important;}a.text-300:hover, a.text-300:focus{color: #a4afba !important;}.bg-400{background-color: #CED4DA !important; color: #000000;}.bg-400 .text-muted, .o_colored_level .bg-400 .text-muted{color: rgba(0, 0, 0, 0.7) !important;}a.bg-400:hover, a.bg-400:focus, button.bg-400:hover, button.bg-400:focus{background-color: #b1bbc4 !important; color: #000000;}.text-400{color: #CED4DA !important;}a.text-400:hover, a.text-400:focus{color: #94a1ae !important;}.bg-500{background-color: #ADB5BD !important; color: #000000;}.bg-500 .text-muted, .o_colored_level .bg-500 .text-muted{color: rgba(0, 0, 0, 0.7) !important;}a.bg-500:hover, a.bg-500:focus, button.bg-500:hover, button.bg-500:focus{background-color: #919ca6 !important; color: #000000;}.text-500{color: #ADB5BD !important;}a.text-500:hover, a.text-500:focus{color: #748290 !important;}.bg-600{background-color: #6C757D !important; color: #FFFFFF;}.bg-600 .text-muted, .o_colored_level .bg-600 .text-muted{color: rgba(255, 255, 255, 0.7) !important;}a.bg-600:hover, a.bg-600:focus, button.bg-600:hover, button.bg-600:focus{background-color: #545b62 !important; color: #FFFFFF;}.text-600{color: #6C757D !important;}a.text-600:hover, a.text-600:focus{color: #3d4246 !important;}.bg-700{background-color: #495057 !important; color: #FFFFFF;}.bg-700 .text-muted, .o_colored_level .bg-700 .text-muted{color: rgba(255, 255, 255, 0.7) !important;}a.bg-700:hover, a.bg-700:focus, button.bg-700:hover, button.bg-700:focus{background-color: #32373b !important; color: #FFFFFF;}.text-700{color: #495057 !important;}a.text-700:hover, a.text-700:focus{color: #1a1d20 !important;}.bg-800{background-color: #343A40 !important; color: #FFFFFF;}.bg-800 .text-muted, .o_colored_level .bg-800 .text-muted{color: rgba(255, 255, 255, 0.7) !important;}a.bg-800:hover, a.bg-800:focus, button.bg-800:hover, button.bg-800:focus{background-color: #1d2124 !important; color: #FFFFFF;}.text-800{color: #343A40 !important;}a.text-800:hover, a.text-800:focus{color: #060708 !important;}.bg-900{background-color: #212529 !important; color: #FFFFFF;}.bg-900 .text-muted, .o_colored_level .bg-900 .text-muted{color: rgba(255, 255, 255, 0.7) !important;}a.bg-900:hover, a.bg-900:focus, button.bg-900:hover, button.bg-900:focus{background-color: #0a0c0d !important; color: #FFFFFF;}.text-900{color: #212529 !important;}a.text-900:hover, a.text-900:focus{color: black !important;}.bg-white-85{background-color: rgba(255, 255, 255, 0.85) !important; color: #000000;}.bg-white-85 .text-muted, .o_colored_level .bg-white-85 .text-muted{color: rgba(0, 0, 0, 0.7) !important;}a.bg-white-85:hover, a.bg-white-85:focus, button.bg-white-85:hover, button.bg-white-85:focus{background-color: rgba(230, 230, 230, 0.85) !important; color: #000000;}.text-white-85{color: rgba(255, 255, 255, 0.85) !important;}a.text-white-85:hover, a.text-white-85:focus{color: rgba(204, 204, 204, 0.85) !important;}.bg-white-75{background-color: rgba(255, 255, 255, 0.75) !important; color: #000000;}.bg-white-75 .text-muted, .o_colored_level .bg-white-75 .text-muted{color: rgba(0, 0, 0, 0.7) !important;}a.bg-white-75:hover, a.bg-white-75:focus, button.bg-white-75:hover, button.bg-white-75:focus{background-color: rgba(230, 230, 230, 0.75) !important; color: #000000;}.text-white-75{color: rgba(255, 255, 255, 0.75) !important;}a.text-white-75:hover, a.text-white-75:focus{color: rgba(204, 204, 204, 0.75) !important;}.bg-white-50{background-color: rgba(255, 255, 255, 0.5) !important; color: #000000;}.bg-white-50 .text-muted, .o_colored_level .bg-white-50 .text-muted{color: rgba(0, 0, 0, 0.7) !important;}a.bg-white-50:hover, a.bg-white-50:focus, button.bg-white-50:hover, button.bg-white-50:focus{background-color: rgba(230, 230, 230, 0.5) !important; color: #000000;}.text-white-50{color: rgba(255, 255, 255, 0.5) !important;}a.text-white-50:hover, a.text-white-50:focus{color: rgba(204, 204, 204, 0.5) !important;}.bg-white-25{background-color: rgba(255, 255, 255, 0.25) !important;}a.bg-white-25:hover, a.bg-white-25:focus, button.bg-white-25:hover, button.bg-white-25:focus{background-color: rgba(230, 230, 230, 0.25) !important;}.text-white-25{color: rgba(255, 255, 255, 0.25) !important;}a.text-white-25:hover, a.text-white-25:focus{color: rgba(204, 204, 204, 0.25) !important;}.bg-black-75{background-color: rgba(0, 0, 0, 0.75) !important; color: #FFFFFF;}.bg-black-75 .text-muted, .o_colored_level .bg-black-75 .text-muted{color: rgba(255, 255, 255, 0.7) !important;}a.bg-black-75:hover, a.bg-black-75:focus, button.bg-black-75:hover, button.bg-black-75:focus{background-color: rgba(0, 0, 0, 0.75) !important; color: #FFFFFF;}.text-black-75{color: rgba(0, 0, 0, 0.75) !important;}a.text-black-75:hover, a.text-black-75:focus{color: rgba(0, 0, 0, 0.75) !important;}.bg-black-50{background-color: rgba(0, 0, 0, 0.5) !important; color: #FFFFFF;}.bg-black-50 .text-muted, .o_colored_level .bg-black-50 .text-muted{color: rgba(255, 255, 255, 0.7) !important;}a.bg-black-50:hover, a.bg-black-50:focus, button.bg-black-50:hover, button.bg-black-50:focus{background-color: rgba(0, 0, 0, 0.5) !important; color: #FFFFFF;}.text-black-50{color: rgba(0, 0, 0, 0.5) !important;}a.text-black-50:hover, a.text-black-50:focus{color: rgba(0, 0, 0, 0.5) !important;}.bg-black-25{background-color: rgba(0, 0, 0, 0.25) !important;}a.bg-black-25:hover, a.bg-black-25:focus, button.bg-black-25:hover, button.bg-black-25:focus{background-color: rgba(0, 0, 0, 0.25) !important;}.text-black-25{color: rgba(0, 0, 0, 0.25) !important;}a.text-black-25:hover, a.text-black-25:focus{color: rgba(0, 0, 0, 0.25) !important;}.bg-black-15{background-color: rgba(0, 0, 0, 0.15) !important;}a.bg-black-15:hover, a.bg-black-15:focus, button.bg-black-15:hover, button.bg-black-15:focus{background-color: rgba(0, 0, 0, 0.15) !important;}.text-black-15{color: rgba(0, 0, 0, 0.15) !important;}a.text-black-15:hover, a.text-black-15:focus{color: rgba(0, 0, 0, 0.15) !important;}.bg-black{background-color: #000000 !important; color: #FFFFFF;}.bg-black .text-muted, .o_colored_level .bg-black .text-muted{color: rgba(255, 255, 255, 0.7) !important;}a.bg-black:hover, a.bg-black:focus, button.bg-black:hover, button.bg-black:focus{background-color: black !important; color: #FFFFFF;}.text-black{color: #000000 !important;}a.text-black:hover, a.text-black:focus{color: black !important;}.bg-white{background-color: #FFFFFF !important; color: #000000;}.bg-white .text-muted, .o_colored_level .bg-white .text-muted{color: rgba(0, 0, 0, 0.7) !important;}a.bg-white:hover, a.bg-white:focus, button.bg-white:hover, button.bg-white:focus{background-color: #e6e6e6 !important; color: #000000;}.text-white{color: #FFFFFF !important;}a.text-white:hover, a.text-white:focus{color: #cccccc !important;}.text-primary{color: #714B67 !important;}a.text-primary:hover, a.text-primary:focus{color: #34222f !important;}.text-secondary{color: #8595A2 !important;}a.text-secondary:hover, a.text-secondary:focus{color: #53626e !important;}.text-success{color: #198754 !important;}a.text-success:hover, a.text-success:focus{color: #09311e !important;}.text-info{color: #0dcaf0 !important;}a.text-info:hover, a.text-info:focus{color: #08798f !important;}.text-warning{color: #ffc107 !important;}a.text-warning:hover, a.text-warning:focus{color: #a07800 !important;}.text-danger{color: #dc3545 !important;}a.text-danger:hover, a.text-danger:focus{color: #921925 !important;}.text-light{color: #F8F9FA !important;}a.text-light:hover, a.text-light:focus{color: #bdc6d0 !important;}.text-dark{color: #212529 !important;}a.text-dark:hover, a.text-dark:focus{color: black !important;}.btn-fill-primary, .btn-primary{color: #FFFFFF; background-color: #714B67; border-color: #714B67;}.btn-fill-primary:hover, .btn-primary:hover{color: #FFFFFF; background-color: #604058; border-color: #5a3c52;}.btn-check:focus + .btn-fill-primary, .btn-check:focus + .btn-primary, .btn-fill-primary:focus, .btn-primary:focus{color: #FFFFFF; background-color: #604058; border-color: #5a3c52; box-shadow: 0 0 0 0.25rem rgba(134, 102, 126, 0.5);}.btn-check:checked + .btn-fill-primary, .btn-check:checked + .btn-primary, .btn-check:active + .btn-fill-primary, .btn-check:active + .btn-primary, .btn-fill-primary:active, .btn-primary:active, .btn-fill-primary.active, .active.btn-primary, .show > .btn-fill-primary.dropdown-toggle, .show > .dropdown-toggle.btn-primary{color: #FFFFFF; background-color: #5a3c52; border-color: #55384d;}.btn-check:checked + .btn-fill-primary:focus, .btn-check:checked + .btn-primary:focus, .btn-check:active + .btn-fill-primary:focus, .btn-check:active + .btn-primary:focus, .btn-fill-primary:active:focus, .btn-primary:active:focus, .btn-fill-primary.active:focus, .active.btn-primary:focus, .show > .btn-fill-primary.dropdown-toggle:focus, .show > .dropdown-toggle.btn-primary:focus{box-shadow: 0 0 0 0.25rem rgba(134, 102, 126, 0.5);}.btn-fill-primary:disabled, .btn-fill-primary.o_wysiwyg_loader, .btn-primary:disabled, .btn-primary.o_wysiwyg_loader, .btn-fill-primary.disabled, .disabled.btn-primary{color: #FFFFFF; background-color: #714B67; border-color: #714B67;}.btn-fill-secondary, .btn-secondary{color: #FFFFFF; background-color: #8595A2; border-color: #8595A2;}.btn-fill-secondary:hover, .btn-secondary:hover{color: #FFFFFF; background-color: #717f8a; border-color: #6a7782;}.btn-check:focus + .btn-fill-secondary, .btn-check:focus + .btn-secondary, .btn-fill-secondary:focus, .btn-secondary:focus{color: #FFFFFF; background-color: #717f8a; border-color: #6a7782; box-shadow: 0 0 0 0.25rem rgba(151, 165, 176, 0.5);}.btn-check:checked + .btn-fill-secondary, .btn-check:checked + .btn-secondary, .btn-check:active + .btn-fill-secondary, .btn-check:active + .btn-secondary, .btn-fill-secondary:active, .btn-secondary:active, .btn-fill-secondary.active, .active.btn-secondary, .show > .btn-fill-secondary.dropdown-toggle, .show > .dropdown-toggle.btn-secondary{color: #FFFFFF; background-color: #6a7782; border-color: #64707a;}.btn-check:checked + .btn-fill-secondary:focus, .btn-check:checked + .btn-secondary:focus, .btn-check:active + .btn-fill-secondary:focus, .btn-check:active + .btn-secondary:focus, .btn-fill-secondary:active:focus, .btn-secondary:active:focus, .btn-fill-secondary.active:focus, .active.btn-secondary:focus, .show > .btn-fill-secondary.dropdown-toggle:focus, .show > .dropdown-toggle.btn-secondary:focus{box-shadow: 0 0 0 0.25rem rgba(151, 165, 176, 0.5);}.btn-fill-secondary:disabled, .btn-fill-secondary.o_wysiwyg_loader, .btn-secondary:disabled, .btn-secondary.o_wysiwyg_loader, .btn-fill-secondary.disabled, .disabled.btn-secondary{color: #FFFFFF; background-color: #8595A2; border-color: #8595A2;}.btn-fill-success, .btn-success{color: #FFFFFF; background-color: #198754; border-color: #198754;}.btn-fill-success:hover, .btn-success:hover{color: #FFFFFF; background-color: #157347; border-color: #146c43;}.btn-check:focus + .btn-fill-success, .btn-check:focus + .btn-success, .btn-fill-success:focus, .btn-success:focus{color: #FFFFFF; background-color: #157347; border-color: #146c43; box-shadow: 0 0 0 0.25rem rgba(60, 153, 110, 0.5);}.btn-check:checked + .btn-fill-success, .btn-check:checked + .btn-success, .btn-check:active + .btn-fill-success, .btn-check:active + .btn-success, .btn-fill-success:active, .btn-success:active, .btn-fill-success.active, .active.btn-success, .show > .btn-fill-success.dropdown-toggle, .show > .dropdown-toggle.btn-success{color: #FFFFFF; background-color: #146c43; border-color: #13653f;}.btn-check:checked + .btn-fill-success:focus, .btn-check:checked + .btn-success:focus, .btn-check:active + .btn-fill-success:focus, .btn-check:active + .btn-success:focus, .btn-fill-success:active:focus, .btn-success:active:focus, .btn-fill-success.active:focus, .active.btn-success:focus, .show > .btn-fill-success.dropdown-toggle:focus, .show > .dropdown-toggle.btn-success:focus{box-shadow: 0 0 0 0.25rem rgba(60, 153, 110, 0.5);}.btn-fill-success:disabled, .btn-fill-success.o_wysiwyg_loader, .btn-success:disabled, .btn-success.o_wysiwyg_loader, .btn-fill-success.disabled, .disabled.btn-success{color: #FFFFFF; background-color: #198754; border-color: #198754;}.btn-fill-info, .btn-info{color: #000000; background-color: #0dcaf0; border-color: #0dcaf0;}.btn-fill-info:hover, .btn-info:hover{color: #000000; background-color: #31d2f2; border-color: #25cff2;}.btn-check:focus + .btn-fill-info, .btn-check:focus + .btn-info, .btn-fill-info:focus, .btn-info:focus{color: #000000; background-color: #31d2f2; border-color: #25cff2; box-shadow: 0 0 0 0.25rem rgba(11, 172, 204, 0.5);}.btn-check:checked + .btn-fill-info, .btn-check:checked + .btn-info, .btn-check:active + .btn-fill-info, .btn-check:active + .btn-info, .btn-fill-info:active, .btn-info:active, .btn-fill-info.active, .active.btn-info, .show > .btn-fill-info.dropdown-toggle, .show > .dropdown-toggle.btn-info{color: #000000; background-color: #3dd5f3; border-color: #25cff2;}.btn-check:checked + .btn-fill-info:focus, .btn-check:checked + .btn-info:focus, .btn-check:active + .btn-fill-info:focus, .btn-check:active + .btn-info:focus, .btn-fill-info:active:focus, .btn-info:active:focus, .btn-fill-info.active:focus, .active.btn-info:focus, .show > .btn-fill-info.dropdown-toggle:focus, .show > .dropdown-toggle.btn-info:focus{box-shadow: 0 0 0 0.25rem rgba(11, 172, 204, 0.5);}.btn-fill-info:disabled, .btn-fill-info.o_wysiwyg_loader, .btn-info:disabled, .btn-info.o_wysiwyg_loader, .btn-fill-info.disabled, .disabled.btn-info{color: #000000; background-color: #0dcaf0; border-color: #0dcaf0;}.btn-fill-warning, .btn-warning{color: #000000; background-color: #ffc107; border-color: #ffc107;}.btn-fill-warning:hover, .btn-warning:hover{color: #000000; background-color: #ffca2c; border-color: #ffc720;}.btn-check:focus + .btn-fill-warning, .btn-check:focus + .btn-warning, .btn-fill-warning:focus, .btn-warning:focus{color: #000000; background-color: #ffca2c; border-color: #ffc720; box-shadow: 0 0 0 0.25rem rgba(217, 164, 6, 0.5);}.btn-check:checked + .btn-fill-warning, .btn-check:checked + .btn-warning, .btn-check:active + .btn-fill-warning, .btn-check:active + .btn-warning, .btn-fill-warning:active, .btn-warning:active, .btn-fill-warning.active, .active.btn-warning, .show > .btn-fill-warning.dropdown-toggle, .show > .dropdown-toggle.btn-warning{color: #000000; background-color: #ffcd39; border-color: #ffc720;}.btn-check:checked + .btn-fill-warning:focus, .btn-check:checked + .btn-warning:focus, .btn-check:active + .btn-fill-warning:focus, .btn-check:active + .btn-warning:focus, .btn-fill-warning:active:focus, .btn-warning:active:focus, .btn-fill-warning.active:focus, .active.btn-warning:focus, .show > .btn-fill-warning.dropdown-toggle:focus, .show > .dropdown-toggle.btn-warning:focus{box-shadow: 0 0 0 0.25rem rgba(217, 164, 6, 0.5);}.btn-fill-warning:disabled, .btn-fill-warning.o_wysiwyg_loader, .btn-warning:disabled, .btn-warning.o_wysiwyg_loader, .btn-fill-warning.disabled, .disabled.btn-warning{color: #000000; background-color: #ffc107; border-color: #ffc107;}.btn-fill-danger, .btn-danger{color: #FFFFFF; background-color: #dc3545; border-color: #dc3545;}.btn-fill-danger:hover, .btn-danger:hover{color: #FFFFFF; background-color: #bb2d3b; border-color: #b02a37;}.btn-check:focus + .btn-fill-danger, .btn-check:focus + .btn-danger, .btn-fill-danger:focus, .btn-danger:focus{color: #FFFFFF; background-color: #bb2d3b; border-color: #b02a37; box-shadow: 0 0 0 0.25rem rgba(225, 83, 97, 0.5);}.btn-check:checked + .btn-fill-danger, .btn-check:checked + .btn-danger, .btn-check:active + .btn-fill-danger, .btn-check:active + .btn-danger, .btn-fill-danger:active, .btn-danger:active, .btn-fill-danger.active, .active.btn-danger, .show > .btn-fill-danger.dropdown-toggle, .show > .dropdown-toggle.btn-danger{color: #FFFFFF; background-color: #b02a37; border-color: #a52834;}.btn-check:checked + .btn-fill-danger:focus, .btn-check:checked + .btn-danger:focus, .btn-check:active + .btn-fill-danger:focus, .btn-check:active + .btn-danger:focus, .btn-fill-danger:active:focus, .btn-danger:active:focus, .btn-fill-danger.active:focus, .active.btn-danger:focus, .show > .btn-fill-danger.dropdown-toggle:focus, .show > .dropdown-toggle.btn-danger:focus{box-shadow: 0 0 0 0.25rem rgba(225, 83, 97, 0.5);}.btn-fill-danger:disabled, .btn-fill-danger.o_wysiwyg_loader, .btn-danger:disabled, .btn-danger.o_wysiwyg_loader, .btn-fill-danger.disabled, .disabled.btn-danger{color: #FFFFFF; background-color: #dc3545; border-color: #dc3545;}.btn-fill-light, .btn-light{color: #000000; background-color: #F8F9FA; border-color: #F8F9FA;}.btn-fill-light:hover, .btn-light:hover{color: #000000; background-color: #f9fafb; border-color: #f9fafb;}.btn-check:focus + .btn-fill-light, .btn-check:focus + .btn-light, .btn-fill-light:focus, .btn-light:focus{color: #000000; background-color: #f9fafb; border-color: #f9fafb; box-shadow: 0 0 0 0.25rem rgba(211, 212, 213, 0.5);}.btn-check:checked + .btn-fill-light, .btn-check:checked + .btn-light, .btn-check:active + .btn-fill-light, .btn-check:active + .btn-light, .btn-fill-light:active, .btn-light:active, .btn-fill-light.active, .active.btn-light, .show > .btn-fill-light.dropdown-toggle, .show > .dropdown-toggle.btn-light{color: #000000; background-color: #f9fafb; border-color: #f9fafb;}.btn-check:checked + .btn-fill-light:focus, .btn-check:checked + .btn-light:focus, .btn-check:active + .btn-fill-light:focus, .btn-check:active + .btn-light:focus, .btn-fill-light:active:focus, .btn-light:active:focus, .btn-fill-light.active:focus, .active.btn-light:focus, .show > .btn-fill-light.dropdown-toggle:focus, .show > .dropdown-toggle.btn-light:focus{box-shadow: 0 0 0 0.25rem rgba(211, 212, 213, 0.5);}.btn-fill-light:disabled, .btn-fill-light.o_wysiwyg_loader, .btn-light:disabled, .btn-light.o_wysiwyg_loader, .btn-fill-light.disabled, .disabled.btn-light{color: #000000; background-color: #F8F9FA; border-color: #F8F9FA;}.btn-fill-dark, .btn-dark{color: #FFFFFF; background-color: #212529; border-color: #212529;}.btn-fill-dark:hover, .btn-dark:hover{color: #FFFFFF; background-color: #1c1f23; border-color: #1a1e21;}.btn-check:focus + .btn-fill-dark, .btn-check:focus + .btn-dark, .btn-fill-dark:focus, .btn-dark:focus{color: #FFFFFF; background-color: #1c1f23; border-color: #1a1e21; box-shadow: 0 0 0 0.25rem rgba(66, 70, 73, 0.5);}.btn-check:checked + .btn-fill-dark, .btn-check:checked + .btn-dark, .btn-check:active + .btn-fill-dark, .btn-check:active + .btn-dark, .btn-fill-dark:active, .btn-dark:active, .btn-fill-dark.active, .active.btn-dark, .show > .btn-fill-dark.dropdown-toggle, .show > .dropdown-toggle.btn-dark{color: #FFFFFF; background-color: #1a1e21; border-color: #191c1f;}.btn-check:checked + .btn-fill-dark:focus, .btn-check:checked + .btn-dark:focus, .btn-check:active + .btn-fill-dark:focus, .btn-check:active + .btn-dark:focus, .btn-fill-dark:active:focus, .btn-dark:active:focus, .btn-fill-dark.active:focus, .active.btn-dark:focus, .show > .btn-fill-dark.dropdown-toggle:focus, .show > .dropdown-toggle.btn-dark:focus{box-shadow: 0 0 0 0.25rem rgba(66, 70, 73, 0.5);}.btn-fill-dark:disabled, .btn-fill-dark.o_wysiwyg_loader, .btn-dark:disabled, .btn-dark.o_wysiwyg_loader, .btn-fill-dark.disabled, .disabled.btn-dark{color: #FFFFFF; background-color: #212529; border-color: #212529;}.btn-outline-primary{color: #714B67; border-color: #714B67;}.btn-outline-primary:hover{color: #FFFFFF; background-color: #714B67; border-color: #714B67;}.btn-check:focus + .btn-outline-primary, .btn-outline-primary:focus{box-shadow: 0 0 0 0.25rem rgba(113, 75, 103, 0.5);}.btn-check:checked + .btn-outline-primary, .btn-check:active + .btn-outline-primary, .btn-outline-primary:active, .btn-outline-primary.active, .btn-outline-primary.dropdown-toggle.show{color: #FFFFFF; background-color: #714B67; border-color: #714B67;}.btn-check:checked + .btn-outline-primary:focus, .btn-check:active + .btn-outline-primary:focus, .btn-outline-primary:active:focus, .btn-outline-primary.active:focus, .btn-outline-primary.dropdown-toggle.show:focus{box-shadow: 0 0 0 0.25rem rgba(113, 75, 103, 0.5);}.btn-outline-primary:disabled, .btn-outline-primary.o_wysiwyg_loader, .btn-outline-primary.disabled{color: #714B67; background-color: transparent;}.btn-outline-secondary{color: #8595A2; border-color: #8595A2;}.btn-outline-secondary:hover{color: #FFFFFF; background-color: #8595A2; border-color: #8595A2;}.btn-check:focus + .btn-outline-secondary, .btn-outline-secondary:focus{box-shadow: 0 0 0 0.25rem rgba(133, 149, 162, 0.5);}.btn-check:checked + .btn-outline-secondary, .btn-check:active + .btn-outline-secondary, .btn-outline-secondary:active, .btn-outline-secondary.active, .btn-outline-secondary.dropdown-toggle.show{color: #FFFFFF; background-color: #8595A2; border-color: #8595A2;}.btn-check:checked + .btn-outline-secondary:focus, .btn-check:active + .btn-outline-secondary:focus, .btn-outline-secondary:active:focus, .btn-outline-secondary.active:focus, .btn-outline-secondary.dropdown-toggle.show:focus{box-shadow: 0 0 0 0.25rem rgba(133, 149, 162, 0.5);}.btn-outline-secondary:disabled, .btn-outline-secondary.o_wysiwyg_loader, .btn-outline-secondary.disabled{color: #8595A2; background-color: transparent;}.btn-outline-success{color: #198754; border-color: #198754;}.btn-outline-success:hover{color: #FFFFFF; background-color: #198754; border-color: #198754;}.btn-check:focus + .btn-outline-success, .btn-outline-success:focus{box-shadow: 0 0 0 0.25rem rgba(25, 135, 84, 0.5);}.btn-check:checked + .btn-outline-success, .btn-check:active + .btn-outline-success, .btn-outline-success:active, .btn-outline-success.active, .btn-outline-success.dropdown-toggle.show{color: #FFFFFF; background-color: #198754; border-color: #198754;}.btn-check:checked + .btn-outline-success:focus, .btn-check:active + .btn-outline-success:focus, .btn-outline-success:active:focus, .btn-outline-success.active:focus, .btn-outline-success.dropdown-toggle.show:focus{box-shadow: 0 0 0 0.25rem rgba(25, 135, 84, 0.5);}.btn-outline-success:disabled, .btn-outline-success.o_wysiwyg_loader, .btn-outline-success.disabled{color: #198754; background-color: transparent;}.btn-outline-info{color: #0dcaf0; border-color: #0dcaf0;}.btn-outline-info:hover{color: #000000; background-color: #0dcaf0; border-color: #0dcaf0;}.btn-check:focus + .btn-outline-info, .btn-outline-info:focus{box-shadow: 0 0 0 0.25rem rgba(13, 202, 240, 0.5);}.btn-check:checked + .btn-outline-info, .btn-check:active + .btn-outline-info, .btn-outline-info:active, .btn-outline-info.active, .btn-outline-info.dropdown-toggle.show{color: #000000; background-color: #0dcaf0; border-color: #0dcaf0;}.btn-check:checked + .btn-outline-info:focus, .btn-check:active + .btn-outline-info:focus, .btn-outline-info:active:focus, .btn-outline-info.active:focus, .btn-outline-info.dropdown-toggle.show:focus{box-shadow: 0 0 0 0.25rem rgba(13, 202, 240, 0.5);}.btn-outline-info:disabled, .btn-outline-info.o_wysiwyg_loader, .btn-outline-info.disabled{color: #0dcaf0; background-color: transparent;}.btn-outline-warning{color: #ffc107; border-color: #ffc107;}.btn-outline-warning:hover{color: #000000; background-color: #ffc107; border-color: #ffc107;}.btn-check:focus + .btn-outline-warning, .btn-outline-warning:focus{box-shadow: 0 0 0 0.25rem rgba(255, 193, 7, 0.5);}.btn-check:checked + .btn-outline-warning, .btn-check:active + .btn-outline-warning, .btn-outline-warning:active, .btn-outline-warning.active, .btn-outline-warning.dropdown-toggle.show{color: #000000; background-color: #ffc107; border-color: #ffc107;}.btn-check:checked + .btn-outline-warning:focus, .btn-check:active + .btn-outline-warning:focus, .btn-outline-warning:active:focus, .btn-outline-warning.active:focus, .btn-outline-warning.dropdown-toggle.show:focus{box-shadow: 0 0 0 0.25rem rgba(255, 193, 7, 0.5);}.btn-outline-warning:disabled, .btn-outline-warning.o_wysiwyg_loader, .btn-outline-warning.disabled{color: #ffc107; background-color: transparent;}.btn-outline-danger{color: #dc3545; border-color: #dc3545;}.btn-outline-danger:hover{color: #FFFFFF; background-color: #dc3545; border-color: #dc3545;}.btn-check:focus + .btn-outline-danger, .btn-outline-danger:focus{box-shadow: 0 0 0 0.25rem rgba(220, 53, 69, 0.5);}.btn-check:checked + .btn-outline-danger, .btn-check:active + .btn-outline-danger, .btn-outline-danger:active, .btn-outline-danger.active, .btn-outline-danger.dropdown-toggle.show{color: #FFFFFF; background-color: #dc3545; border-color: #dc3545;}.btn-check:checked + .btn-outline-danger:focus, .btn-check:active + .btn-outline-danger:focus, .btn-outline-danger:active:focus, .btn-outline-danger.active:focus, .btn-outline-danger.dropdown-toggle.show:focus{box-shadow: 0 0 0 0.25rem rgba(220, 53, 69, 0.5);}.btn-outline-danger:disabled, .btn-outline-danger.o_wysiwyg_loader, .btn-outline-danger.disabled{color: #dc3545; background-color: transparent;}.btn-outline-light{color: #F8F9FA; border-color: #F8F9FA;}.btn-outline-light:hover{color: #000000; background-color: #F8F9FA; border-color: #F8F9FA;}.btn-check:focus + .btn-outline-light, .btn-outline-light:focus{box-shadow: 0 0 0 0.25rem rgba(248, 249, 250, 0.5);}.btn-check:checked + .btn-outline-light, .btn-check:active + .btn-outline-light, .btn-outline-light:active, .btn-outline-light.active, .btn-outline-light.dropdown-toggle.show{color: #000000; background-color: #F8F9FA; border-color: #F8F9FA;}.btn-check:checked + .btn-outline-light:focus, .btn-check:active + .btn-outline-light:focus, .btn-outline-light:active:focus, .btn-outline-light.active:focus, .btn-outline-light.dropdown-toggle.show:focus{box-shadow: 0 0 0 0.25rem rgba(248, 249, 250, 0.5);}.btn-outline-light:disabled, .btn-outline-light.o_wysiwyg_loader, .btn-outline-light.disabled{color: #F8F9FA; background-color: transparent;}.btn-outline-dark{color: #212529; border-color: #212529;}.btn-outline-dark:hover{color: #FFFFFF; background-color: #212529; border-color: #212529;}.btn-check:focus + .btn-outline-dark, .btn-outline-dark:focus{box-shadow: 0 0 0 0.25rem rgba(33, 37, 41, 0.5);}.btn-check:checked + .btn-outline-dark, .btn-check:active + .btn-outline-dark, .btn-outline-dark:active, .btn-outline-dark.active, .btn-outline-dark.dropdown-toggle.show{color: #FFFFFF; background-color: #212529; border-color: #212529;}.btn-check:checked + .btn-outline-dark:focus, .btn-check:active + .btn-outline-dark:focus, .btn-outline-dark:active:focus, .btn-outline-dark.active:focus, .btn-outline-dark.dropdown-toggle.show:focus{box-shadow: 0 0 0 0.25rem rgba(33, 37, 41, 0.5);}.btn-outline-dark:disabled, .btn-outline-dark.o_wysiwyg_loader, .btn-outline-dark.disabled{color: #212529; background-color: transparent;}.btn-group .btn-light.active{box-shadow: inset 0 0 0 1px #714B67; border-color: transparent; background-color: #ebe8eb;}.navbar-nav.nav-pills .nav-link{padding-right: 1rem; padding-left: 1rem;}.carousel-control-next .visually-hidden{left: 50%;}.pagination{font-variant-numeric: tabular-nums;}\n/* /web/static/src/libs/fontawesome/css/font-awesome.css */\n @font-face{font-family: 'FontAwesome'; src: url('/web/static/src/libs/fontawesome/css/../fonts/fontawesome-webfont.woff2?v=4.7.0') format('woff2'), url('/web/static/src/libs/fontawesome/css/../fonts/fontawesome-webfont.woff?v=4.7.0') format('woff'); font-weight: normal; font-style: normal; font-display: block;}.fa{display: inline-block; font: normal normal normal 14px/1 FontAwesome; font-size: inherit; text-rendering: auto; -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale;}.fa-lg{font-size: 1.315em; vertical-align: -6%;}.fa-2x{font-size: 2em;}.fa-3x{font-size: 3em;}.fa-4x{font-size: 4em;}.fa-5x{font-size: 5em;}.fa-fw{width: 1.28571429em; text-align: center;}.fa-ul{padding-left: 0; margin-left: 2.14285714em; list-style-type: none;}.fa-ul > li{position: relative;}.fa-li{position: absolute; left: -2.14285714em; width: 2.14285714em; top: 0.14285714em; text-align: center;}.fa-li.fa-lg{left: -1.85714286em;}.fa-border{padding: .2em .25em .15em; border: solid 0.08em #eeeeee; border-radius: .1em;}.fa-pull-left{float: left;}.fa-pull-right{float: right;}.fa.fa-pull-left{margin-right: .3em;}.fa.fa-pull-right{margin-left: .3em;}.fa-spin{animation: fa-spin 2s infinite linear;}.fa-pulse{animation: fa-spin 1s infinite steps(8);}@keyframes fa-spin{0%{transform: rotate(0deg);}100%{transform: rotate(359deg);}}.fa-rotate-90{transform: rotate(90deg);}.fa-rotate-180{transform: rotate(180deg);}.fa-rotate-270{transform: rotate(270deg);}.fa-flip-horizontal{transform: scale(-1, 1);}.fa-flip-vertical{transform: scale(1, -1);}:root .fa-rotate-90, :root .fa-rotate-180, :root .fa-rotate-270, :root .fa-flip-horizontal, :root .fa-flip-vertical{filter: none;}.fa-stack{position: relative; display: inline-block; width: 2em; height: 2em; line-height: 2em; vertical-align: middle;}.fa-stack-1x, .fa-stack-2x{position: absolute; left: 0; width: 100%; text-align: center;}.fa-stack-1x{line-height: inherit;}.fa-stack-2x{font-size: 2em;}.fa-inverse{color: #ffffff;}.fa-glass:before{content: "\\f000";}.fa-music:before{content: "\\f001";}.fa-search:before{content: "\\f002";}.fa-envelope-o:before{content: "\\f003";}.fa-heart:before{content: "\\f004";}.fa-star:before{content: "\\f005";}.fa-star-o:before{content: "\\f006";}.fa-user:before{content: "\\f007";}.fa-film:before{content: "\\f008";}.fa-th-large:before{content: "\\f009";}.fa-th:before{content: "\\f00a";}.fa-th-list:before{content: "\\f00b";}.fa-check:before{content: "\\f00c";}.fa-remove:before, .fa-close:before, .fa-times:before{content: "\\f00d";}.fa-search-plus:before{content: "\\f00e";}.fa-search-minus:before{content: "\\f010";}.fa-power-off:before{content: "\\f011";}.fa-signal:before{content: "\\f012";}.fa-gear:before, .fa-cog:before{content: "\\f013";}.fa-trash-o:before{content: "\\f014";}.fa-home:before{content: "\\f015";}.fa-file-o:before{content: "\\f016";}.fa-clock-o:before{content: "\\f017";}.fa-road:before{content: "\\f018";}.fa-download:before{content: "\\f019";}.fa-arrow-circle-o-down:before{content: "\\f01a";}.fa-arrow-circle-o-up:before{content: "\\f01b";}.fa-inbox:before{content: "\\f01c";}.fa-play-circle-o:before{content: "\\f01d";}.fa-rotate-right:before, .fa-repeat:before{content: "\\f01e";}.fa-refresh:before{content: "\\f021";}.fa-list-alt:before{content: "\\f022";}.fa-lock:before{content: "\\f023";}.fa-flag:before{content: "\\f024";}.fa-headphones:before{content: "\\f025";}.fa-volume-off:before{content: "\\f026";}.fa-volume-down:before{content: "\\f027";}.fa-volume-up:before{content: "\\f028";}.fa-qrcode:before{content: "\\f029";}.fa-barcode:before{content: "\\f02a";}.fa-tag:before{content: "\\f02b";}.fa-tags:before{content: "\\f02c";}.fa-book:before{content: "\\f02d";}.fa-bookmark:before{content: "\\f02e";}.fa-print:before{content: "\\f02f";}.fa-camera:before{content: "\\f030";}.fa-font:before{content: "\\f031";}.fa-bold:before{content: "\\f032";}.fa-italic:before{content: "\\f033";}.fa-text-height:before{content: "\\f034";}.fa-text-width:before{content: "\\f035";}.fa-align-left:before{content: "\\f036";}.fa-align-center:before{content: "\\f037";}.fa-align-right:before{content: "\\f038";}.fa-align-justify:before{content: "\\f039";}.fa-list:before{content: "\\f03a";}.fa-dedent:before, .fa-outdent:before{content: "\\f03b";}.fa-indent:before{content: "\\f03c";}.fa-video-camera:before{content: "\\f03d";}.fa-photo:before, .fa-image:before, .fa-picture-o:before{content: "\\f03e";}.fa-pencil:before{content: "\\f040";}.fa-map-marker:before{content: "\\f041";}.fa-adjust:before{content: "\\f042";}.fa-tint:before{content: "\\f043";}.fa-edit:before, .fa-pencil-square-o:before{content: "\\f044";}.fa-share-square-o:before{content: "\\f045";}.fa-check-square-o:before{content: "\\f046";}.fa-arrows:before{content: "\\f047";}.fa-step-backward:before{content: "\\f048";}.fa-fast-backward:before{content: "\\f049";}.fa-backward:before{content: "\\f04a";}.fa-play:before{content: "\\f04b";}.fa-pause:before{content: "\\f04c";}.fa-stop:before{content: "\\f04d";}.fa-forward:before{content: "\\f04e";}.fa-fast-forward:before{content: "\\f050";}.fa-step-forward:before{content: "\\f051";}.fa-eject:before{content: "\\f052";}.fa-chevron-left:before{content: "\\f053";}.fa-chevron-right:before{content: "\\f054";}.fa-plus-circle:before{content: "\\f055";}.fa-minus-circle:before{content: "\\f056";}.fa-times-circle:before{content: "\\f057";}.fa-check-circle:before{content: "\\f058";}.fa-question-circle:before{content: "\\f059";}.fa-info-circle:before{content: "\\f05a";}.fa-crosshairs:before{content: "\\f05b";}.fa-times-circle-o:before{content: "\\f05c";}.fa-check-circle-o:before{content: "\\f05d";}.fa-ban:before{content: "\\f05e";}.fa-arrow-left:before{content: "\\f060";}.fa-arrow-right:before{content: "\\f061";}.fa-arrow-up:before{content: "\\f062";}.fa-arrow-down:before{content: "\\f063";}.fa-mail-forward:before, .fa-share:before{content: "\\f064";}.fa-expand:before{content: "\\f065";}.fa-compress:before{content: "\\f066";}.fa-plus:before{content: "\\f067";}.fa-minus:before{content: "\\f068";}.fa-asterisk:before{content: "\\f069";}.fa-exclamation-circle:before{content: "\\f06a";}.fa-gift:before{content: "\\f06b";}.fa-leaf:before{content: "\\f06c";}.fa-fire:before{content: "\\f06d";}.fa-eye:before{content: "\\f06e";}.fa-eye-slash:before{content: "\\f070";}.fa-warning:before, .fa-exclamation-triangle:before{content: "\\f071";}.fa-plane:before{content: "\\f072";}.fa-calendar:before{content: "\\f073";}.fa-random:before{content: "\\f074";}.fa-comment:before{content: "\\f075";}.fa-magnet:before{content: "\\f076";}.fa-chevron-up:before{content: "\\f077";}.fa-chevron-down:before{content: "\\f078";}.fa-retweet:before{content: "\\f079";}.fa-shopping-cart:before{content: "\\f07a";}.fa-folder:before{content: "\\f07b";}.fa-folder-open:before{content: "\\f07c";}.fa-arrows-v:before{content: "\\f07d";}.fa-arrows-h:before{content: "\\f07e";}.fa-bar-chart-o:before, .fa-bar-chart:before{content: "\\f080";}.fa-twitter-square:before{content: "\\f081";}.fa-facebook-square:before{content: "\\f082";}.fa-camera-retro:before{content: "\\f083";}.fa-key:before{content: "\\f084";}.fa-gears:before, .fa-cogs:before{content: "\\f085";}.fa-comments:before{content: "\\f086";}.fa-thumbs-o-up:before{content: "\\f087";}.fa-thumbs-o-down:before{content: "\\f088";}.fa-star-half:before{content: "\\f089";}.fa-heart-o:before{content: "\\f08a";}.fa-sign-out:before{content: "\\f08b";}.fa-linkedin-square:before{content: "\\f08c";}.fa-thumb-tack:before{content: "\\f08d";}.fa-external-link:before{content: "\\f08e";}.fa-sign-in:before{content: "\\f090";}.fa-trophy:before{content: "\\f091";}.fa-github-square:before{content: "\\f092";}.fa-upload:before{content: "\\f093";}.fa-lemon-o:before{content: "\\f094";}.fa-phone:before{content: "\\f095";}.fa-square-o:before{content: "\\f096";}.fa-bookmark-o:before{content: "\\f097";}.fa-phone-square:before{content: "\\f098";}.fa-twitter:before{content: "\\f099";}.fa-facebook-f:before, .fa-facebook:before{content: "\\f09a";}.fa-github:before{content: "\\f09b";}.fa-unlock:before{content: "\\f09c";}.fa-credit-card:before{content: "\\f09d";}.fa-feed:before, .fa-rss:before{content: "\\f09e";}.fa-hdd-o:before{content: "\\f0a0";}.fa-bullhorn:before{content: "\\f0a1";}.fa-bell:before{content: "\\f0f3";}.fa-certificate:before{content: "\\f0a3";}.fa-hand-o-right:before{content: "\\f0a4";}.fa-hand-o-left:before{content: "\\f0a5";}.fa-hand-o-up:before{content: "\\f0a6";}.fa-hand-o-down:before{content: "\\f0a7";}.fa-arrow-circle-left:before{content: "\\f0a8";}.fa-arrow-circle-right:before{content: "\\f0a9";}.fa-arrow-circle-up:before{content: "\\f0aa";}.fa-arrow-circle-down:before{content: "\\f0ab";}.fa-globe:before{content: "\\f0ac";}.fa-wrench:before{content: "\\f0ad";}.fa-tasks:before{content: "\\f0ae";}.fa-filter:before{content: "\\f0b0";}.fa-briefcase:before{content: "\\f0b1";}.fa-arrows-alt:before{content: "\\f0b2";}.fa-group:before, .fa-users:before{content: "\\f0c0";}.fa-chain:before, .fa-link:before{content: "\\f0c1";}.fa-cloud:before{content: "\\f0c2";}.fa-flask:before{content: "\\f0c3";}.fa-cut:before, .fa-scissors:before{content: "\\f0c4";}.fa-copy:before, .fa-files-o:before{content: "\\f0c5";}.fa-paperclip:before{content: "\\f0c6";}.fa-save:before, .fa-floppy-o:before{content: "\\f0c7";}.fa-square:before{content: "\\f0c8";}.fa-navicon:before, .fa-reorder:before, .fa-bars:before{content: "\\f0c9";}.fa-list-ul:before{content: "\\f0ca";}.fa-list-ol:before{content: "\\f0cb";}.fa-strikethrough:before{content: "\\f0cc";}.fa-underline:before{content: "\\f0cd";}.fa-table:before{content: "\\f0ce";}.fa-magic:before{content: "\\f0d0";}.fa-truck:before{content: "\\f0d1";}.fa-pinterest:before{content: "\\f0d2";}.fa-pinterest-square:before{content: "\\f0d3";}.fa-google-plus-square:before{content: "\\f0d4";}.fa-google-plus:before{content: "\\f0d5";}.fa-money:before{content: "\\f0d6";}.fa-caret-down:before{content: "\\f0d7";}.fa-caret-up:before{content: "\\f0d8";}.fa-caret-left:before{content: "\\f0d9";}.fa-caret-right:before{content: "\\f0da";}.fa-columns:before{content: "\\f0db";}.fa-unsorted:before, .fa-sort:before{content: "\\f0dc";}.fa-sort-down:before, .fa-sort-desc:before{content: "\\f0dd";}.fa-sort-up:before, .fa-sort-asc:before{content: "\\f0de";}.fa-envelope:before{content: "\\f0e0";}.fa-linkedin:before{content: "\\f0e1";}.fa-rotate-left:before, .fa-undo:before{content: "\\f0e2";}.fa-legal:before, .fa-gavel:before{content: "\\f0e3";}.fa-dashboard:before, .fa-tachometer:before{content: "\\f0e4";}.fa-comment-o:before{content: "\\f0e5";}.fa-comments-o:before{content: "\\f0e6";}.fa-flash:before, .fa-bolt:before{content: "\\f0e7";}.fa-sitemap:before{content: "\\f0e8";}.fa-umbrella:before{content: "\\f0e9";}.fa-paste:before, .fa-clipboard:before{content: "\\f0ea";}.fa-lightbulb-o:before{content: "\\f0eb";}.fa-exchange:before{content: "\\f0ec";}.fa-cloud-download:before{content: "\\f0ed";}.fa-cloud-upload:before{content: "\\f0ee";}.fa-user-md:before{content: "\\f0f0";}.fa-stethoscope:before{content: "\\f0f1";}.fa-suitcase:before{content: "\\f0f2";}.fa-bell-o:before{content: "\\f0a2";}.fa-coffee:before{content: "\\f0f4";}.fa-cutlery:before{content: "\\f0f5";}.fa-file-text-o:before{content: "\\f0f6";}.fa-building-o:before{content: "\\f0f7";}.fa-hospital-o:before{content: "\\f0f8";}.fa-ambulance:before{content: "\\f0f9";}.fa-medkit:before{content: "\\f0fa";}.fa-fighter-jet:before{content: "\\f0fb";}.fa-beer:before{content: "\\f0fc";}.fa-h-square:before{content: "\\f0fd";}.fa-plus-square:before{content: "\\f0fe";}.fa-angle-double-left:before{content: "\\f100";}.fa-angle-double-right:before{content: "\\f101";}.fa-angle-double-up:before{content: "\\f102";}.fa-angle-double-down:before{content: "\\f103";}.fa-angle-left:before{content: "\\f104";}.fa-angle-right:before{content: "\\f105";}.fa-angle-up:before{content: "\\f106";}.fa-angle-down:before{content: "\\f107";}.fa-desktop:before{content: "\\f108";}.fa-laptop:before{content: "\\f109";}.fa-tablet:before{content: "\\f10a";}.fa-mobile-phone:before, .fa-mobile:before{content: "\\f10b";}.fa-circle-o:before{content: "\\f10c";}.fa-quote-left:before{content: "\\f10d";}.fa-quote-right:before{content: "\\f10e";}.fa-spinner:before{content: "\\f110";}.fa-circle:before{content: "\\f111";}.fa-mail-reply:before, .fa-reply:before{content: "\\f112";}.fa-github-alt:before{content: "\\f113";}.fa-folder-o:before{content: "\\f114";}.fa-folder-open-o:before{content: "\\f115";}.fa-smile-o:before{content: "\\f118";}.fa-frown-o:before{content: "\\f119";}.fa-meh-o:before{content: "\\f11a";}.fa-gamepad:before{content: "\\f11b";}.fa-keyboard-o:before{content: "\\f11c";}.fa-flag-o:before{content: "\\f11d";}.fa-flag-checkered:before{content: "\\f11e";}.fa-terminal:before{content: "\\f120";}.fa-code:before{content: "\\f121";}.fa-mail-reply-all:before, .fa-reply-all:before{content: "\\f122";}.fa-star-half-empty:before, .fa-star-half-full:before, .fa-star-half-o:before{content: "\\f123";}.fa-location-arrow:before{content: "\\f124";}.fa-crop:before{content: "\\f125";}.fa-code-fork:before{content: "\\f126";}.fa-unlink:before, .fa-chain-broken:before{content: "\\f127";}.fa-question:before{content: "\\f128";}.fa-info:before{content: "\\f129";}.fa-exclamation:before{content: "\\f12a";}.fa-superscript:before{content: "\\f12b";}.fa-subscript:before{content: "\\f12c";}.fa-eraser:before{content: "\\f12d";}.fa-puzzle-piece:before{content: "\\f12e";}.fa-microphone:before{content: "\\f130";}.fa-microphone-slash:before{content: "\\f131";}.fa-shield:before{content: "\\f132";}.fa-calendar-o:before{content: "\\f133";}.fa-fire-extinguisher:before{content: "\\f134";}.fa-rocket:before{content: "\\f135";}.fa-maxcdn:before{content: "\\f136";}.fa-chevron-circle-left:before{content: "\\f137";}.fa-chevron-circle-right:before{content: "\\f138";}.fa-chevron-circle-up:before{content: "\\f139";}.fa-chevron-circle-down:before{content: "\\f13a";}.fa-html5:before{content: "\\f13b";}.fa-css3:before{content: "\\f13c";}.fa-anchor:before{content: "\\f13d";}.fa-unlock-alt:before{content: "\\f13e";}.fa-bullseye:before{content: "\\f140";}.fa-ellipsis-h:before{content: "\\f141";}.fa-ellipsis-v:before{content: "\\f142";}.fa-rss-square:before{content: "\\f143";}.fa-play-circle:before{content: "\\f144";}.fa-ticket:before{content: "\\f145";}.fa-minus-square:before{content: "\\f146";}.fa-minus-square-o:before{content: "\\f147";}.fa-level-up:before{content: "\\f148";}.fa-level-down:before{content: "\\f149";}.fa-check-square:before{content: "\\f14a";}.fa-pencil-square:before{content: "\\f14b";}.fa-external-link-square:before{content: "\\f14c";}.fa-share-square:before{content: "\\f14d";}.fa-compass:before{content: "\\f14e";}.fa-toggle-down:before, .fa-caret-square-o-down:before{content: "\\f150";}.fa-toggle-up:before, .fa-caret-square-o-up:before{content: "\\f151";}.fa-toggle-right:before, .fa-caret-square-o-right:before{content: "\\f152";}.fa-euro:before, .fa-eur:before{content: "\\f153";}.fa-gbp:before{content: "\\f154";}.fa-dollar:before, .fa-usd:before{content: "\\f155";}.fa-rupee:before, .fa-inr:before{content: "\\f156";}.fa-cny:before, .fa-rmb:before, .fa-yen:before, .fa-jpy:before{content: "\\f157";}.fa-ruble:before, .fa-rouble:before, .fa-rub:before{content: "\\f158";}.fa-won:before, .fa-krw:before{content: "\\f159";}.fa-bitcoin:before, .fa-btc:before{content: "\\f15a";}.fa-file:before{content: "\\f15b";}.fa-file-text:before{content: "\\f15c";}.fa-sort-alpha-asc:before{content: "\\f15d";}.fa-sort-alpha-desc:before{content: "\\f15e";}.fa-sort-amount-asc:before{content: "\\f160";}.fa-sort-amount-desc:before{content: "\\f161";}.fa-sort-numeric-asc:before{content: "\\f162";}.fa-sort-numeric-desc:before{content: "\\f163";}.fa-thumbs-up:before{content: "\\f164";}.fa-thumbs-down:before{content: "\\f165";}.fa-youtube-square:before{content: "\\f166";}.fa-youtube:before{content: "\\f167";}.fa-xing:before{content: "\\f168";}.fa-xing-square:before{content: "\\f169";}.fa-youtube-play:before{content: "\\f16a";}.fa-dropbox:before{content: "\\f16b";}.fa-stack-overflow:before{content: "\\f16c";}.fa-instagram:before{content: "\\f16d";}.fa-flickr:before{content: "\\f16e";}.fa-adn:before{content: "\\f170";}.fa-bitbucket:before{content: "\\f171";}.fa-bitbucket-square:before{content: "\\f172";}.fa-tumblr:before{content: "\\f173";}.fa-tumblr-square:before{content: "\\f174";}.fa-long-arrow-down:before{content: "\\f175";}.fa-long-arrow-up:before{content: "\\f176";}.fa-long-arrow-left:before{content: "\\f177";}.fa-long-arrow-right:before{content: "\\f178";}.fa-apple:before{content: "\\f179";}.fa-windows:before{content: "\\f17a";}.fa-android:before{content: "\\f17b";}.fa-linux:before{content: "\\f17c";}.fa-dribbble:before{content: "\\f17d";}.fa-skype:before{content: "\\f17e";}.fa-foursquare:before{content: "\\f180";}.fa-trello:before{content: "\\f181";}.fa-female:before{content: "\\f182";}.fa-male:before{content: "\\f183";}.fa-gittip:before, .fa-gratipay:before{content: "\\f184";}.fa-sun-o:before{content: "\\f185";}.fa-moon-o:before{content: "\\f186";}.fa-archive:before{content: "\\f187";}.fa-bug:before{content: "\\f188";}.fa-vk:before{content: "\\f189";}.fa-weibo:before{content: "\\f18a";}.fa-renren:before{content: "\\f18b";}.fa-pagelines:before{content: "\\f18c";}.fa-stack-exchange:before{content: "\\f18d";}.fa-arrow-circle-o-right:before{content: "\\f18e";}.fa-arrow-circle-o-left:before{content: "\\f190";}.fa-toggle-left:before, .fa-caret-square-o-left:before{content: "\\f191";}.fa-dot-circle-o:before{content: "\\f192";}.fa-wheelchair:before{content: "\\f193";}.fa-vimeo-square:before{content: "\\f194";}.fa-turkish-lira:before, .fa-try:before{content: "\\f195";}.fa-plus-square-o:before{content: "\\f196";}.fa-space-shuttle:before{content: "\\f197";}.fa-slack:before{content: "\\f198";}.fa-envelope-square:before{content: "\\f199";}.fa-wordpress:before{content: "\\f19a";}.fa-openid:before{content: "\\f19b";}.fa-institution:before, .fa-bank:before, .fa-university:before{content: "\\f19c";}.fa-mortar-board:before, .fa-graduation-cap:before{content: "\\f19d";}.fa-yahoo:before{content: "\\f19e";}.fa-google:before{content: "\\f1a0";}.fa-reddit:before{content: "\\f1a1";}.fa-reddit-square:before{content: "\\f1a2";}.fa-stumbleupon-circle:before{content: "\\f1a3";}.fa-stumbleupon:before{content: "\\f1a4";}.fa-delicious:before{content: "\\f1a5";}.fa-digg:before{content: "\\f1a6";}.fa-pied-piper-pp:before{content: "\\f1a7";}.fa-pied-piper-alt:before{content: "\\f1a8";}.fa-drupal:before{content: "\\f1a9";}.fa-joomla:before{content: "\\f1aa";}.fa-language:before{content: "\\f1ab";}.fa-fax:before{content: "\\f1ac";}.fa-building:before{content: "\\f1ad";}.fa-child:before{content: "\\f1ae";}.fa-paw:before{content: "\\f1b0";}.fa-spoon:before{content: "\\f1b1";}.fa-cube:before{content: "\\f1b2";}.fa-cubes:before{content: "\\f1b3";}.fa-behance:before{content: "\\f1b4";}.fa-behance-square:before{content: "\\f1b5";}.fa-steam:before{content: "\\f1b6";}.fa-steam-square:before{content: "\\f1b7";}.fa-recycle:before{content: "\\f1b8";}.fa-automobile:before, .fa-car:before{content: "\\f1b9";}.fa-cab:before, .fa-taxi:before{content: "\\f1ba";}.fa-tree:before{content: "\\f1bb";}.fa-spotify:before{content: "\\f1bc";}.fa-deviantart:before{content: "\\f1bd";}.fa-soundcloud:before{content: "\\f1be";}.fa-database:before{content: "\\f1c0";}.fa-file-pdf-o:before{content: "\\f1c1";}.fa-file-word-o:before{content: "\\f1c2";}.fa-file-excel-o:before{content: "\\f1c3";}.fa-file-powerpoint-o:before{content: "\\f1c4";}.fa-file-photo-o:before, .fa-file-picture-o:before, .fa-file-image-o:before{content: "\\f1c5";}.fa-file-zip-o:before, .fa-file-archive-o:before{content: "\\f1c6";}.fa-file-sound-o:before, .fa-file-audio-o:before{content: "\\f1c7";}.fa-file-movie-o:before, .fa-file-video-o:before{content: "\\f1c8";}.fa-file-code-o:before{content: "\\f1c9";}.fa-vine:before{content: "\\f1ca";}.fa-codepen:before{content: "\\f1cb";}.fa-jsfiddle:before{content: "\\f1cc";}.fa-life-bouy:before, .fa-life-buoy:before, .fa-life-saver:before, .fa-support:before, .fa-life-ring:before{content: "\\f1cd";}.fa-circle-o-notch:before{content: "\\f1ce";}.fa-ra:before, .fa-resistance:before, .fa-rebel:before{content: "\\f1d0";}.fa-ge:before, .fa-empire:before{content: "\\f1d1";}.fa-git-square:before{content: "\\f1d2";}.fa-git:before{content: "\\f1d3";}.fa-y-combinator-square:before, .fa-yc-square:before, .fa-hacker-news:before{content: "\\f1d4";}.fa-tencent-weibo:before{content: "\\f1d5";}.fa-qq:before{content: "\\f1d6";}.fa-wechat:before, .fa-weixin:before{content: "\\f1d7";}.fa-send:before, .fa-paper-plane:before{content: "\\f1d8";}.fa-send-o:before, .fa-paper-plane-o:before{content: "\\f1d9";}.fa-history:before{content: "\\f1da";}.fa-circle-thin:before{content: "\\f1db";}.fa-header:before{content: "\\f1dc";}.fa-paragraph:before{content: "\\f1dd";}.fa-sliders:before{content: "\\f1de";}.fa-share-alt:before{content: "\\f1e0";}.fa-share-alt-square:before{content: "\\f1e1";}.fa-bomb:before{content: "\\f1e2";}.fa-soccer-ball-o:before, .fa-futbol-o:before{content: "\\f1e3";}.fa-tty:before{content: "\\f1e4";}.fa-binoculars:before{content: "\\f1e5";}.fa-plug:before{content: "\\f1e6";}.fa-slideshare:before{content: "\\f1e7";}.fa-twitch:before{content: "\\f1e8";}.fa-yelp:before{content: "\\f1e9";}.fa-newspaper-o:before{content: "\\f1ea";}.fa-wifi:before{content: "\\f1eb";}.fa-calculator:before{content: "\\f1ec";}.fa-paypal:before{content: "\\f1ed";}.fa-google-wallet:before{content: "\\f1ee";}.fa-cc-visa:before{content: "\\f1f0";}.fa-cc-mastercard:before{content: "\\f1f1";}.fa-cc-discover:before{content: "\\f1f2";}.fa-cc-amex:before{content: "\\f1f3";}.fa-cc-paypal:before{content: "\\f1f4";}.fa-cc-stripe:before{content: "\\f1f5";}.fa-bell-slash:before{content: "\\f1f6";}.fa-bell-slash-o:before{content: "\\f1f7";}.fa-trash:before{content: "\\f1f8";}.fa-copyright:before{content: "\\f1f9";}.fa-at:before{content: "\\f1fa";}.fa-eyedropper:before{content: "\\f1fb";}.fa-paint-brush:before{content: "\\f1fc";}.fa-birthday-cake:before{content: "\\f1fd";}.fa-area-chart:before{content: "\\f1fe";}.fa-pie-chart:before{content: "\\f200";}.fa-line-chart:before{content: "\\f201";}.fa-lastfm:before{content: "\\f202";}.fa-lastfm-square:before{content: "\\f203";}.fa-toggle-off:before{content: "\\f204";}.fa-toggle-on:before{content: "\\f205";}.fa-bicycle:before{content: "\\f206";}.fa-bus:before{content: "\\f207";}.fa-ioxhost:before{content: "\\f208";}.fa-angellist:before{content: "\\f209";}.fa-cc:before{content: "\\f20a";}.fa-shekel:before, .fa-sheqel:before, .fa-ils:before{content: "\\f20b";}.fa-meanpath:before{content: "\\f20c";}.fa-buysellads:before{content: "\\f20d";}.fa-connectdevelop:before{content: "\\f20e";}.fa-dashcube:before{content: "\\f210";}.fa-forumbee:before{content: "\\f211";}.fa-leanpub:before{content: "\\f212";}.fa-sellsy:before{content: "\\f213";}.fa-shirtsinbulk:before{content: "\\f214";}.fa-simplybuilt:before{content: "\\f215";}.fa-skyatlas:before{content: "\\f216";}.fa-cart-plus:before{content: "\\f217";}.fa-cart-arrow-down:before{content: "\\f218";}.fa-diamond:before{content: "\\f219";}.fa-ship:before{content: "\\f21a";}.fa-user-secret:before{content: "\\f21b";}.fa-motorcycle:before{content: "\\f21c";}.fa-street-view:before{content: "\\f21d";}.fa-heartbeat:before{content: "\\f21e";}.fa-venus:before{content: "\\f221";}.fa-mars:before{content: "\\f222";}.fa-mercury:before{content: "\\f223";}.fa-intersex:before, .fa-transgender:before{content: "\\f224";}.fa-transgender-alt:before{content: "\\f225";}.fa-venus-double:before{content: "\\f226";}.fa-mars-double:before{content: "\\f227";}.fa-venus-mars:before{content: "\\f228";}.fa-mars-stroke:before{content: "\\f229";}.fa-mars-stroke-v:before{content: "\\f22a";}.fa-mars-stroke-h:before{content: "\\f22b";}.fa-neuter:before{content: "\\f22c";}.fa-genderless:before{content: "\\f22d";}.fa-facebook-official:before{content: "\\f230";}.fa-pinterest-p:before{content: "\\f231";}.fa-whatsapp:before{content: "\\f232";}.fa-server:before{content: "\\f233";}.fa-user-plus:before{content: "\\f234";}.fa-user-times:before{content: "\\f235";}.fa-hotel:before, .fa-bed:before{content: "\\f236";}.fa-viacoin:before{content: "\\f237";}.fa-train:before{content: "\\f238";}.fa-subway:before{content: "\\f239";}.fa-medium:before{content: "\\f23a";}.fa-yc:before, .fa-y-combinator:before{content: "\\f23b";}.fa-optin-monster:before{content: "\\f23c";}.fa-opencart:before{content: "\\f23d";}.fa-expeditedssl:before{content: "\\f23e";}.fa-battery-4:before, .fa-battery:before, .fa-battery-full:before{content: "\\f240";}.fa-battery-3:before, .fa-battery-three-quarters:before{content: "\\f241";}.fa-battery-2:before, .fa-battery-half:before{content: "\\f242";}.fa-battery-1:before, .fa-battery-quarter:before{content: "\\f243";}.fa-battery-0:before, .fa-battery-empty:before{content: "\\f244";}.fa-mouse-pointer:before{content: "\\f245";}.fa-i-cursor:before{content: "\\f246";}.fa-object-group:before{content: "\\f247";}.fa-object-ungroup:before{content: "\\f248";}.fa-sticky-note:before{content: "\\f249";}.fa-sticky-note-o:before{content: "\\f24a";}.fa-cc-jcb:before{content: "\\f24b";}.fa-cc-diners-club:before{content: "\\f24c";}.fa-clone:before{content: "\\f24d";}.fa-balance-scale:before{content: "\\f24e";}.fa-hourglass-o:before{content: "\\f250";}.fa-hourglass-1:before, .fa-hourglass-start:before{content: "\\f251";}.fa-hourglass-2:before, .fa-hourglass-half:before{content: "\\f252";}.fa-hourglass-3:before, .fa-hourglass-end:before{content: "\\f253";}.fa-hourglass:before{content: "\\f254";}.fa-hand-grab-o:before, .fa-hand-rock-o:before{content: "\\f255";}.fa-hand-stop-o:before, .fa-hand-paper-o:before{content: "\\f256";}.fa-hand-scissors-o:before{content: "\\f257";}.fa-hand-lizard-o:before{content: "\\f258";}.fa-hand-spock-o:before{content: "\\f259";}.fa-hand-pointer-o:before{content: "\\f25a";}.fa-hand-peace-o:before{content: "\\f25b";}.fa-trademark:before{content: "\\f25c";}.fa-registered:before{content: "\\f25d";}.fa-creative-commons:before{content: "\\f25e";}.fa-gg:before{content: "\\f260";}.fa-gg-circle:before{content: "\\f261";}.fa-tripadvisor:before{content: "\\f262";}.fa-odnoklassniki:before{content: "\\f263";}.fa-odnoklassniki-square:before{content: "\\f264";}.fa-get-pocket:before{content: "\\f265";}.fa-wikipedia-w:before{content: "\\f266";}.fa-safari:before{content: "\\f267";}.fa-chrome:before{content: "\\f268";}.fa-firefox:before{content: "\\f269";}.fa-opera:before{content: "\\f26a";}.fa-internet-explorer:before{content: "\\f26b";}.fa-tv:before, .fa-television:before{content: "\\f26c";}.fa-contao:before{content: "\\f26d";}.fa-500px:before{content: "\\f26e";}.fa-amazon:before{content: "\\f270";}.fa-calendar-plus-o:before{content: "\\f271";}.fa-calendar-minus-o:before{content: "\\f272";}.fa-calendar-times-o:before{content: "\\f273";}.fa-calendar-check-o:before{content: "\\f274";}.fa-industry:before{content: "\\f275";}.fa-map-pin:before{content: "\\f276";}.fa-map-signs:before{content: "\\f277";}.fa-map-o:before{content: "\\f278";}.fa-map:before{content: "\\f279";}.fa-commenting:before{content: "\\f27a";}.fa-commenting-o:before{content: "\\f27b";}.fa-houzz:before{content: "\\f27c";}.fa-vimeo:before{content: "\\f27d";}.fa-black-tie:before{content: "\\f27e";}.fa-fonticons:before{content: "\\f280";}.fa-reddit-alien:before{content: "\\f281";}.fa-edge:before{content: "\\f282";}.fa-credit-card-alt:before{content: "\\f283";}.fa-codiepie:before{content: "\\f284";}.fa-modx:before{content: "\\f285";}.fa-fort-awesome:before{content: "\\f286";}.fa-usb:before{content: "\\f287";}.fa-product-hunt:before{content: "\\f288";}.fa-mixcloud:before{content: "\\f289";}.fa-scribd:before{content: "\\f28a";}.fa-pause-circle:before{content: "\\f28b";}.fa-pause-circle-o:before{content: "\\f28c";}.fa-stop-circle:before{content: "\\f28d";}.fa-stop-circle-o:before{content: "\\f28e";}.fa-shopping-bag:before{content: "\\f290";}.fa-shopping-basket:before{content: "\\f291";}.fa-hashtag:before{content: "\\f292";}.fa-bluetooth:before{content: "\\f293";}.fa-bluetooth-b:before{content: "\\f294";}.fa-percent:before{content: "\\f295";}.fa-gitlab:before{content: "\\f296";}.fa-wpbeginner:before{content: "\\f297";}.fa-wpforms:before{content: "\\f298";}.fa-envira:before{content: "\\f299";}.fa-universal-access:before{content: "\\f29a";}.fa-wheelchair-alt:before{content: "\\f29b";}.fa-question-circle-o:before{content: "\\f29c";}.fa-blind:before{content: "\\f29d";}.fa-audio-description:before{content: "\\f29e";}.fa-volume-control-phone:before{content: "\\f2a0";}.fa-braille:before{content: "\\f2a1";}.fa-assistive-listening-systems:before{content: "\\f2a2";}.fa-asl-interpreting:before, .fa-american-sign-language-interpreting:before{content: "\\f2a3";}.fa-deafness:before, .fa-hard-of-hearing:before, .fa-deaf:before{content: "\\f2a4";}.fa-glide:before{content: "\\f2a5";}.fa-glide-g:before{content: "\\f2a6";}.fa-signing:before, .fa-sign-language:before{content: "\\f2a7";}.fa-low-vision:before{content: "\\f2a8";}.fa-viadeo:before{content: "\\f2a9";}.fa-viadeo-square:before{content: "\\f2aa";}.fa-snapchat:before{content: "\\f2ab";}.fa-snapchat-ghost:before{content: "\\f2ac";}.fa-snapchat-square:before{content: "\\f2ad";}.fa-pied-piper:before{content: "\\f2ae";}.fa-first-order:before{content: "\\f2b0";}.fa-yoast:before{content: "\\f2b1";}.fa-themeisle:before{content: "\\f2b2";}.fa-google-plus-circle:before, .fa-google-plus-official:before{content: "\\f2b3";}.fa-fa:before, .fa-font-awesome:before{content: "\\f2b4";}.fa-handshake-o:before{content: "\\f2b5";}.fa-envelope-open:before{content: "\\f2b6";}.fa-envelope-open-o:before{content: "\\f2b7";}.fa-linode:before{content: "\\f2b8";}.fa-address-book:before{content: "\\f2b9";}.fa-address-book-o:before{content: "\\f2ba";}.fa-vcard:before, .fa-address-card:before{content: "\\f2bb";}.fa-vcard-o:before, .fa-address-card-o:before{content: "\\f2bc";}.fa-user-circle:before{content: "\\f2bd";}.fa-user-circle-o:before{content: "\\f2be";}.fa-user-o:before{content: "\\f2c0";}.fa-id-badge:before{content: "\\f2c1";}.fa-drivers-license:before, .fa-id-card:before{content: "\\f2c2";}.fa-drivers-license-o:before, .fa-id-card-o:before{content: "\\f2c3";}.fa-quora:before{content: "\\f2c4";}.fa-free-code-camp:before{content: "\\f2c5";}.fa-telegram:before{content: "\\f2c6";}.fa-thermometer-4:before, .fa-thermometer:before, .fa-thermometer-full:before{content: "\\f2c7";}.fa-thermometer-3:before, .fa-thermometer-three-quarters:before{content: "\\f2c8";}.fa-thermometer-2:before, .fa-thermometer-half:before{content: "\\f2c9";}.fa-thermometer-1:before, .fa-thermometer-quarter:before{content: "\\f2ca";}.fa-thermometer-0:before, .fa-thermometer-empty:before{content: "\\f2cb";}.fa-shower:before{content: "\\f2cc";}.fa-bathtub:before, .fa-s15:before, .fa-bath:before{content: "\\f2cd";}.fa-podcast:before{content: "\\f2ce";}.fa-window-maximize:before{content: "\\f2d0";}.fa-window-minimize:before{content: "\\f2d1";}.fa-window-restore:before{content: "\\f2d2";}.fa-times-rectangle:before, .fa-window-close:before{content: "\\f2d3";}.fa-times-rectangle-o:before, .fa-window-close-o:before{content: "\\f2d4";}.fa-bandcamp:before{content: "\\f2d5";}.fa-grav:before{content: "\\f2d6";}.fa-etsy:before{content: "\\f2d7";}.fa-imdb:before{content: "\\f2d8";}.fa-ravelry:before{content: "\\f2d9";}.fa-eercast:before{content: "\\f2da";}.fa-microchip:before{content: "\\f2db";}.fa-snowflake-o:before{content: "\\f2dc";}.fa-superpowers:before{content: "\\f2dd";}.fa-wpexplorer:before{content: "\\f2de";}.fa-meetup:before{content: "\\f2e0";}.visually-hidden{position: absolute; width: 1px; height: 1px; padding: 0; margin: -1px; overflow: hidden; clip: rect(0, 0, 0, 0); border: 0;}.visually-hidden-focusable:active, .visually-hidden-focusable:focus{position: static; width: auto; height: auto; margin: 0; overflow: visible; clip: auto;}\n/* /web/static/lib/odoo_ui_icons/style.css */\n@font-face{font-family: 'odoo_ui_icons'; src: url('/web/static/lib/odoo_ui_icons/fonts/odoo_ui_icons.woff2') format('woff2'), url('/web/static/lib/odoo_ui_icons/fonts/odoo_ui_icons.woff') format('woff'); font-weight: normal; font-style: normal; font-display: block;}.oi{display: inline-block; font-family: 'odoo_ui_icons'; speak: never; font-style: normal; font-weight: normal; font-variant: normal; text-transform: none; line-height: 1; -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale;}.oi-close:before{content: '\\00d7'; font-family: sans-serif; font-weight: bold;}.oi-view-pivot:before{content: '\\e800';}.oi-text-break:before{content: '\\e801';}.oi-text-inline:before{content: '\\e802';}.oi-voip:before{content: '\\e803';}.oi-odoo:before{content: '\\e806';}.oi-search:before{content: '\\e808';}.oi-group:before{content: '\\e80a';}.oi-settings-adjust:before{content: '\\e80c';}.oi-apps:before{content: '\\e80d';}.oi-panel-right:before{content: '\\e810';}.oi-launch:before{content: '\\e812';}.oi-studio:before{content: '\\e813';}.oi-view-kanban:before{content: '\\e814';}.oi-text-wrap:before{content: '\\e815';}.oi-view-cohort:before{content: '\\e816';}.oi-view-list:before{content: '\\e817';}.oi-gif-picker:before{content: '\\e82e';}.oi-chevron-down:before{content: '\\e839';}.oi-chevron-left:before{content: '\\e83a';}.oi-chevron-right:before{content: '\\e83b';}.oi-chevron-up:before{content: '\\e83c';}.oi-arrows-h:before{content: '\\e83d';}.oi-arrows-v:before{content: '\\e83e';}.oi-arrow-down-left:before{content: '\\e83f';}.oi-arrow-down-right:before{content: '\\e840';}.oi-arrow-down:before{content: '\\e841';}.oi-arrow-left:before{content: '\\e842';}.oi-arrow-right:before{content: '\\e843';}.oi-arrow-up-left:before{content: '\\e844';}.oi-arrow-up-right:before{content: '\\e845';}.oi-arrow-up:before{content: '\\e846';}.oi-draggable:before{content: '\\e847';}.oi-view:before{content: '\\e861';}.oi-archive:before{content: '\\e862';}.oi-unarchive:before{content: '\\e863';}.oi-text-effect:before{content: '\\e827';}.oi-smile-add:before{content: '\\e84e';}\n/* /web/static/lib/select2/select2.css */\n .select2-container{margin: 0; position: relative; display: inline-block; vertical-align: middle;}.select2-container, .select2-drop, .select2-search, .select2-search input{-webkit-box-sizing: border-box; -moz-box-sizing: border-box; box-sizing: border-box;}.select2-container .select2-choice{display: block; height: 26px; padding: 0 0 0 8px; overflow: hidden; position: relative; border: 1px solid #aaa; white-space: nowrap; line-height: 26px; color: #444; text-decoration: none; border-radius: 4px; background-clip: padding-box; -webkit-touch-callout: none; -webkit-user-select: none; -moz-user-select: none; -ms-user-select: none; user-select: none; background-color: #fff; background-image: -webkit-gradient(linear, left bottom, left top, color-stop(0, #eee), color-stop(0.5, #fff)); background-image: -webkit-linear-gradient(center bottom, #eee 0%, #fff 50%); background-image: -moz-linear-gradient(center bottom, #eee 0%, #fff 50%); filter: progid:DXImageTransform.Microsoft.gradient(startColorstr = '#ffffff', endColorstr = '#eeeeee', GradientType = 0); background-image: linear-gradient(to top, #eee 0%, #fff 50%);}html[dir="rtl"] .select2-container .select2-choice{padding: 0 8px 0 0;}.select2-container.select2-drop-above .select2-choice{border-bottom-color: #aaa; border-radius: 0 0 4px 4px; background-image: -webkit-gradient(linear, left bottom, left top, color-stop(0, #eee), color-stop(0.9, #fff)); background-image: -webkit-linear-gradient(center bottom, #eee 0%, #fff 90%); background-image: -moz-linear-gradient(center bottom, #eee 0%, #fff 90%); filter: progid:DXImageTransform.Microsoft.gradient(startColorstr='#ffffff', endColorstr='#eeeeee', GradientType=0); background-image: linear-gradient(to bottom, #eee 0%, #fff 90%);}.select2-container.select2-allowclear .select2-choice .select2-chosen{margin-right: 42px;}.select2-container .select2-choice > .select2-chosen{margin-right: 26px; display: block; overflow: hidden; white-space: nowrap; text-overflow: ellipsis; float: none; width: auto;}html[dir="rtl"] .select2-container .select2-choice > .select2-chosen{margin-left: 26px; margin-right: 0;}.select2-container .select2-choice abbr{display: none; width: 12px; height: 12px; position: absolute; right: 24px; top: 8px; font-size: 1px; text-decoration: none; border: 0; background: url('/web/static/lib/select2/select2.png') right top no-repeat; cursor: pointer; outline: 0;}.select2-container.select2-allowclear .select2-choice abbr{display: inline-block;}.select2-container .select2-choice abbr:hover{background-position: right -11px; cursor: pointer;}.select2-drop-mask{border: 0; margin: 0; padding: 0; position: fixed; left: 0; top: 0; min-height: 100%; min-width: 100%; height: auto; width: auto; opacity: 0; z-index: 9998; background-color: #fff; filter: alpha(opacity=0);}.select2-drop{width: 100%; margin-top: -1px; position: absolute; z-index: 9999; top: 100%; background: #fff; color: #000; border: 1px solid #aaa; border-top: 0; border-radius: 0 0 4px 4px; -webkit-box-shadow: 0 4px 5px rgba(0, 0, 0, .15); box-shadow: 0 4px 5px rgba(0, 0, 0, .15);}.select2-drop.select2-drop-above{margin-top: 1px; border-top: 1px solid #aaa; border-bottom: 0; border-radius: 4px 4px 0 0; -webkit-box-shadow: 0 -4px 5px rgba(0, 0, 0, .15); box-shadow: 0 -4px 5px rgba(0, 0, 0, .15);}.select2-drop-active{border: 1px solid #5897fb; border-top: none;}.select2-drop.select2-drop-above.select2-drop-active{border-top: 1px solid #5897fb;}.select2-drop-auto-width{border-top: 1px solid #aaa; width: auto;}.select2-container .select2-choice .select2-arrow{display: inline-block; width: 18px; height: 100%; position: absolute; right: 0; top: 0; border-left: 1px solid #aaa; border-radius: 0 4px 4px 0; background-clip: padding-box; background: #ccc; background-image: -webkit-gradient(linear, left bottom, left top, color-stop(0, #ccc), color-stop(0.6, #eee)); background-image: -webkit-linear-gradient(center bottom, #ccc 0%, #eee 60%); background-image: -moz-linear-gradient(center bottom, #ccc 0%, #eee 60%); filter: progid:DXImageTransform.Microsoft.gradient(startColorstr = '#eeeeee', endColorstr = '#cccccc', GradientType = 0); background-image: linear-gradient(to top, #ccc 0%, #eee 60%);}html[dir="rtl"] .select2-container .select2-choice .select2-arrow{left: 0; right: auto; border-left: none; border-right: 1px solid #aaa; border-radius: 4px 0 0 4px;}.select2-container .select2-choice .select2-arrow b{display: block; width: 100%; height: 100%; background: url('/web/static/lib/select2/select2.png') no-repeat 0 1px;}html[dir="rtl"] .select2-container .select2-choice .select2-arrow b{background-position: 2px 1px;}.select2-search{display: inline-block; width: 100%; min-height: 26px; margin: 0; padding: 4px 4px 0 4px; position: relative; z-index: 10000; white-space: nowrap;}.select2-search input{width: 100%; height: auto !important; min-height: 26px; padding: 4px 20px 4px 5px; margin: 0; outline: 0; font-family: sans-serif; font-size: 1em; border: 1px solid #aaa; border-radius: 0; -webkit-box-shadow: none; box-shadow: none; background: #fff url('/web/static/lib/select2/select2.png') no-repeat 100% -22px; background: url('/web/static/lib/select2/select2.png') no-repeat 100% -22px, -webkit-gradient(linear, left bottom, left top, color-stop(0.85, #fff), color-stop(0.99, #eee)); background: url('/web/static/lib/select2/select2.png') no-repeat 100% -22px, -webkit-linear-gradient(center bottom, #fff 85%, #eee 99%); background: url('/web/static/lib/select2/select2.png') no-repeat 100% -22px, -moz-linear-gradient(center bottom, #fff 85%, #eee 99%); background: url('/web/static/lib/select2/select2.png') no-repeat 100% -22px, linear-gradient(to bottom, #fff 85%, #eee 99%) 0 0;}html[dir="rtl"] .select2-search input{padding: 4px 5px 4px 20px; background: #fff url('/web/static/lib/select2/select2.png') no-repeat -37px -22px; background: url('/web/static/lib/select2/select2.png') no-repeat -37px -22px, -webkit-gradient(linear, left bottom, left top, color-stop(0.85, #fff), color-stop(0.99, #eee)); background: url('/web/static/lib/select2/select2.png') no-repeat -37px -22px, -webkit-linear-gradient(center bottom, #fff 85%, #eee 99%); background: url('/web/static/lib/select2/select2.png') no-repeat -37px -22px, -moz-linear-gradient(center bottom, #fff 85%, #eee 99%); background: url('/web/static/lib/select2/select2.png') no-repeat -37px -22px, linear-gradient(to bottom, #fff 85%, #eee 99%) 0 0;}.select2-search input.select2-active{background: #fff url('/web/static/lib/select2/select2-spinner.gif') no-repeat 100%; background: url('/web/static/lib/select2/select2-spinner.gif') no-repeat 100%, -webkit-gradient(linear, left bottom, left top, color-stop(0.85, #fff), color-stop(0.99, #eee)); background: url('/web/static/lib/select2/select2-spinner.gif') no-repeat 100%, -webkit-linear-gradient(center bottom, #fff 85%, #eee 99%); background: url('/web/static/lib/select2/select2-spinner.gif') no-repeat 100%, -moz-linear-gradient(center bottom, #fff 85%, #eee 99%); background: url('/web/static/lib/select2/select2-spinner.gif') no-repeat 100%, linear-gradient(to bottom, #fff 85%, #eee 99%) 0 0;}.select2-container-active .select2-choice, .select2-container-active .select2-choices{border: 1px solid #5897fb; outline: none; -webkit-box-shadow: 0 0 5px rgba(0, 0, 0, .3); box-shadow: 0 0 5px rgba(0, 0, 0, .3);}.select2-dropdown-open .select2-choice{border-bottom-color: transparent; -webkit-box-shadow: 0 1px 0 #fff inset; box-shadow: 0 1px 0 #fff inset; border-bottom-left-radius: 0; border-bottom-right-radius: 0; background-color: #eee; background-image: -webkit-gradient(linear, left bottom, left top, color-stop(0, #fff), color-stop(0.5, #eee)); background-image: -webkit-linear-gradient(center bottom, #fff 0%, #eee 50%); background-image: -moz-linear-gradient(center bottom, #fff 0%, #eee 50%); filter: progid:DXImageTransform.Microsoft.gradient(startColorstr='#eeeeee', endColorstr='#ffffff', GradientType=0); background-image: linear-gradient(to top, #fff 0%, #eee 50%);}.select2-dropdown-open.select2-drop-above .select2-choice, .select2-dropdown-open.select2-drop-above .select2-choices{border: 1px solid #5897fb; border-top-color: transparent; background-image: -webkit-gradient(linear, left top, left bottom, color-stop(0, #fff), color-stop(0.5, #eee)); background-image: -webkit-linear-gradient(center top, #fff 0%, #eee 50%); background-image: -moz-linear-gradient(center top, #fff 0%, #eee 50%); filter: progid:DXImageTransform.Microsoft.gradient(startColorstr='#eeeeee', endColorstr='#ffffff', GradientType=0); background-image: linear-gradient(to bottom, #fff 0%, #eee 50%);}.select2-dropdown-open .select2-choice .select2-arrow{background: transparent; border-left: none; filter: none;}html[dir="rtl"] .select2-dropdown-open .select2-choice .select2-arrow{border-right: none;}.select2-dropdown-open .select2-choice .select2-arrow b{background-position: -18px 1px;}html[dir="rtl"] .select2-dropdown-open .select2-choice .select2-arrow b{background-position: -16px 1px;}.select2-hidden-accessible{border: 0; clip: rect(0 0 0 0); height: 1px; margin: -1px; overflow: hidden; padding: 0; position: absolute; width: 1px;}.select2-results{max-height: 200px; padding: 0 0 0 4px; margin: 4px 4px 4px 0; position: relative; overflow-x: hidden; overflow-y: auto; -webkit-tap-highlight-color: rgba(0, 0, 0, 0);}html[dir="rtl"] .select2-results{padding: 0 4px 0 0; margin: 4px 0 4px 4px;}.select2-results ul.select2-result-sub{margin: 0; padding-left: 0;}.select2-results li{list-style: none; display: list-item; background-image: none;}.select2-results li.select2-result-with-children > .select2-result-label{font-weight: bold;}.select2-results .select2-result-label{padding: 3px 7px 4px; margin: 0; cursor: pointer; min-height: 1em; -webkit-touch-callout: none; -webkit-user-select: none; -moz-user-select: none; -ms-user-select: none; user-select: none;}.select2-results-dept-1 .select2-result-label{padding-left: 20px}.select2-results-dept-2 .select2-result-label{padding-left: 40px}.select2-results-dept-3 .select2-result-label{padding-left: 60px}.select2-results-dept-4 .select2-result-label{padding-left: 80px}.select2-results-dept-5 .select2-result-label{padding-left: 100px}.select2-results-dept-6 .select2-result-label{padding-left: 110px}.select2-results-dept-7 .select2-result-label{padding-left: 120px}.select2-results .select2-highlighted{background: #3875d7; color: #fff;}.select2-results li em{background: #feffde; font-style: normal;}.select2-results .select2-highlighted em{background: transparent;}.select2-results .select2-highlighted ul{background: #fff; color: #000;}.select2-results .select2-no-results, .select2-results .select2-searching, .select2-results .select2-ajax-error, .select2-results .select2-selection-limit{background: #f4f4f4; display: list-item; padding-left: 5px;}.select2-results .select2-disabled.select2-highlighted{color: #666; background: #f4f4f4; display: list-item; cursor: default;}.select2-results .select2-disabled{background: #f4f4f4; display: list-item; cursor: default;}.select2-results .select2-selected{display: none;}.select2-more-results.select2-active{background: #f4f4f4 url('/web/static/lib/select2/select2-spinner.gif') no-repeat 100%;}.select2-results .select2-ajax-error{background: rgba(255, 50, 50, .2);}.select2-more-results{background: #f4f4f4; display: list-item;}.select2-container.select2-container-disabled .select2-choice{background-color: #f4f4f4; background-image: none; border: 1px solid #ddd; cursor: default;}.select2-container.select2-container-disabled .select2-choice .select2-arrow{background-color: #f4f4f4; background-image: none; border-left: 0;}.select2-container.select2-container-disabled .select2-choice abbr{display: none;}.select2-container-multi .select2-choices{height: auto !important; height: 1%; margin: 0; padding: 0 5px 0 0; position: relative; border: 1px solid #aaa; cursor: text; overflow: hidden; background-color: #fff; background-image: -webkit-gradient(linear, 0% 0%, 0% 100%, color-stop(1%, #eee), color-stop(15%, #fff)); background-image: -webkit-linear-gradient(top, #eee 1%, #fff 15%); background-image: -moz-linear-gradient(top, #eee 1%, #fff 15%); background-image: linear-gradient(to bottom, #eee 1%, #fff 15%);}html[dir="rtl"] .select2-container-multi .select2-choices{padding: 0 0 0 5px;}.select2-locked{padding: 3px 5px 3px 5px !important;}.select2-container-multi .select2-choices{min-height: 26px;}.select2-container-multi.select2-container-active .select2-choices{border: 1px solid #5897fb; outline: none; -webkit-box-shadow: 0 0 5px rgba(0, 0, 0, .3); box-shadow: 0 0 5px rgba(0, 0, 0, .3);}.select2-container-multi .select2-choices li{float: left; list-style: none;}html[dir="rtl"] .select2-container-multi .select2-choices li{float: right;}.select2-container-multi .select2-choices .select2-search-field{margin: 0; padding: 0; white-space: nowrap;}.select2-container-multi .select2-choices .select2-search-field input{padding: 5px; margin: 1px 0; font-family: sans-serif; font-size: 100%; color: #666; outline: 0; border: 0; -webkit-box-shadow: none; box-shadow: none; background: transparent !important;}.select2-container-multi .select2-choices .select2-search-field input.select2-active{background: #fff url('/web/static/lib/select2/select2-spinner.gif') no-repeat 100% !important;}.select2-default{color: #999 !important;}.select2-container-multi .select2-choices .select2-search-choice{padding: 3px 5px 3px 18px; margin: 3px 0 3px 5px; position: relative; line-height: 13px; color: #333; cursor: default; border: 1px solid #aaaaaa; border-radius: 3px; -webkit-box-shadow: 0 0 2px #fff inset, 0 1px 0 rgba(0, 0, 0, 0.05); box-shadow: 0 0 2px #fff inset, 0 1px 0 rgba(0, 0, 0, 0.05); background-clip: padding-box; -webkit-touch-callout: none; -webkit-user-select: none; -moz-user-select: none; -ms-user-select: none; user-select: none; background-color: #e4e4e4; filter: progid:DXImageTransform.Microsoft.gradient(startColorstr='#eeeeee', endColorstr='#f4f4f4', GradientType=0); background-image: -webkit-gradient(linear, 0% 0%, 0% 100%, color-stop(20%, #f4f4f4), color-stop(50%, #f0f0f0), color-stop(52%, #e8e8e8), color-stop(100%, #eee)); background-image: -webkit-linear-gradient(top, #f4f4f4 20%, #f0f0f0 50%, #e8e8e8 52%, #eee 100%); background-image: -moz-linear-gradient(top, #f4f4f4 20%, #f0f0f0 50%, #e8e8e8 52%, #eee 100%); background-image: linear-gradient(to bottom, #f4f4f4 20%, #f0f0f0 50%, #e8e8e8 52%, #eee 100%);}html[dir="rtl"] .select2-container-multi .select2-choices .select2-search-choice{margin: 3px 5px 3px 0; padding: 3px 18px 3px 5px;}.select2-container-multi .select2-choices .select2-search-choice .select2-chosen{cursor: default;}.select2-container-multi .select2-choices .select2-search-choice-focus{background: #d4d4d4;}.select2-search-choice-close{display: block; width: 12px; height: 13px; position: absolute; right: 3px; top: 4px; font-size: 1px; outline: none; background: url('/web/static/lib/select2/select2.png') right top no-repeat;}html[dir="rtl"] .select2-search-choice-close{right: auto; left: 3px;}.select2-container-multi .select2-search-choice-close{left: 3px;}html[dir="rtl"] .select2-container-multi .select2-search-choice-close{left: auto; right: 2px;}.select2-container-multi .select2-choices .select2-search-choice .select2-search-choice-close:hover{background-position: right -11px;}.select2-container-multi .select2-choices .select2-search-choice-focus .select2-search-choice-close{background-position: right -11px;}.select2-container-multi.select2-container-disabled .select2-choices{background-color: #f4f4f4; background-image: none; border: 1px solid #ddd; cursor: default;}.select2-container-multi.select2-container-disabled .select2-choices .select2-search-choice{padding: 3px 5px 3px 5px; border: 1px solid #ddd; background-image: none; background-color: #f4f4f4;}.select2-container-multi.select2-container-disabled .select2-choices .select2-search-choice .select2-search-choice-close{display: none; background: none;}.select2-result-selectable .select2-match, .select2-result-unselectable .select2-match{text-decoration: underline;}.select2-offscreen, .select2-offscreen:focus{clip: rect(0 0 0 0) !important; width: 1px !important; height: 1px !important; border: 0 !important; margin: 0 !important; padding: 0 !important; overflow: hidden !important; position: absolute !important; outline: 0 !important; left: 0px !important; top: 0px !important;}.select2-display-none{display: none;}.select2-measure-scrollbar{position: absolute; top: -10000px; left: -10000px; width: 100px; height: 100px; overflow: scroll;}@media only screen and (-webkit-min-device-pixel-ratio: 1.5), only screen and (min-resolution: 2dppx){.select2-search input, .select2-search-choice-close, .select2-container .select2-choice abbr, .select2-container .select2-choice .select2-arrow b{background-image: url('/web/static/lib/select2/select2x2.png') !important; background-repeat: no-repeat !important; background-size: 60px 40px !important;}.select2-search input{background-position: 100% -21px !important;}}\n/* /web/static/lib/select2-bootstrap-css/select2-bootstrap.css */\n .form-control .select2-choice{border: 0; border-radius: 2px;}.form-control .select2-choice .select2-arrow{border-radius: 0 2px 2px 0;}.form-control.select2-container{height: auto !important; padding: 0;}.form-control.select2-container.select2-dropdown-open{border-color: #5897FB; border-radius: 3px 3px 0 0;}.form-control .select2-container.select2-dropdown-open .select2-choices{border-radius: 3px 3px 0 0;}.form-control.select2-container .select2-choices{border: 0 !important; border-radius: 3px;}.control-group.warning .select2-container .select2-choice, .control-group.warning .select2-container .select2-choices, .control-group.warning .select2-container-active .select2-choice, .control-group.warning .select2-container-active .select2-choices, .control-group.warning .select2-dropdown-open.select2-drop-above .select2-choice, .control-group.warning .select2-dropdown-open.select2-drop-above .select2-choices, .control-group.warning .select2-container-multi.select2-container-active .select2-choices{border: 1px solid #C09853 !important;}.control-group.warning .select2-container .select2-choice div{border-left: 1px solid #C09853 !important; background: #FCF8E3 !important;}.control-group.error .select2-container .select2-choice, .control-group.error .select2-container .select2-choices, .control-group.error .select2-container-active .select2-choice, .control-group.error .select2-container-active .select2-choices, .control-group.error .select2-dropdown-open.select2-drop-above .select2-choice, .control-group.error .select2-dropdown-open.select2-drop-above .select2-choices, .control-group.error .select2-container-multi.select2-container-active .select2-choices{border: 1px solid #B94A48 !important;}.control-group.error .select2-container .select2-choice div{border-left: 1px solid #B94A48 !important; background: #F2DEDE !important;}.control-group.info .select2-container .select2-choice, .control-group.info .select2-container .select2-choices, .control-group.info .select2-container-active .select2-choice, .control-group.info .select2-container-active .select2-choices, .control-group.info .select2-dropdown-open.select2-drop-above .select2-choice, .control-group.info .select2-dropdown-open.select2-drop-above .select2-choices, .control-group.info .select2-container-multi.select2-container-active .select2-choices{border: 1px solid #3A87AD !important;}.control-group.info .select2-container .select2-choice div{border-left: 1px solid #3A87AD !important; background: #D9EDF7 !important;}.control-group.success .select2-container .select2-choice, .control-group.success .select2-container .select2-choices, .control-group.success .select2-container-active .select2-choice, .control-group.success .select2-container-active .select2-choices, .control-group.success .select2-dropdown-open.select2-drop-above .select2-choice, .control-group.success .select2-dropdown-open.select2-drop-above .select2-choices, .control-group.success .select2-container-multi.select2-container-active .select2-choices{border: 1px solid #468847 !important;}.control-group.success .select2-container .select2-choice div{border-left: 1px solid #468847 !important; background: #DFF0D8 !important;}\n/* /web/static/src/webclient/navbar/navbar.scss */\n .o_main_navbar{--o-navbar-height: 46px; --Dropdown_menu-margin-y: 0; display: -webkit-box; display: -webkit-flex; display: flex; height: var(--o-navbar-height); min-width: min-content; padding-top: 0px; padding-bottom: 0px; border-bottom: 1px solid #5a4f7f; background: #71639e; font-size: 0.875rem;}.o_main_navbar > ul{padding: 0; margin: 0; list-style: none;}.o_main_navbar .o_nav_entry, .o_main_navbar .dropdown-toggle{border-color: transparent;}.o_main_navbar .o_menu_sections .o_nav_entry, .o_main_navbar .o_menu_sections .dropdown-toggle{background: var(--NavBar-entry-backgroundColor, #71639e); border: 1px solid transparent;}.o_main_navbar .o_menu_sections .o_nav_entry:hover, .o_main_navbar .o_menu_sections .dropdown-toggle:hover{background: var(--NavBar-entry-backgroundColor--hover, rgba(0, 0, 0, 0.08));}.o_main_navbar .o_menu_sections .o_nav_entry:focus, .o_main_navbar .o_menu_sections .dropdown-toggle:focus{background: var(--NavBar-entry-backgroundColor--focus, rgba(0, 0, 0, 0.08));}.o_main_navbar .o_menu_sections .o_nav_entry:active, .o_main_navbar .o_menu_sections .dropdown-toggle:active{background: var(--NavBar-entry-backgroundColor--active, rgba(0, 0, 0, 0.08));}.o_main_navbar .o_menu_sections .dropdown.show > .dropdown-toggle{border-color: var(--NavBar-entry-borderColor-active, transparent); background: var(--NavBar-entry-backgroundColor--active, rgba(0, 0, 0, 0.08)); color: var(--NavBar-entry-color--active, #FFFFFF);}.o_main_navbar .dropdown-menu{border-top: 0; border-radius: 0 0 0.25rem 0.25rem;}.o_main_navbar .dropdown-menu .disabled{cursor: default;}.o_main_navbar .dropdown-header.dropdown-menu_group{margin-top: 0;}.o_main_navbar .dropdown-item + .dropdown-header:not(.o_more_dropdown_section_group){margin-top: .3em;}.o_main_navbar .o_dropdown_menu_group_entry.dropdown-item{padding-left: 30px;}.o_main_navbar .o_dropdown_menu_group_entry.dropdown-item + .dropdown-item:not(.o_dropdown_menu_group_entry){margin-top: .8em;}.o_main_navbar .o_navbar_apps_menu .dropdown-toggle{--NavBar-entry-padding-left: 16px; font-size: 1.2em;}.o_main_navbar .o_menu_brand{padding-left: 0; font-size: 1.2em; color: var(--NavBar-brand-color, rgba(255, 255, 255, 0.9));}.o_main_navbar .o_menu_brand:hover{background: none;}.o_main_navbar .o_menu_sections .o_more_dropdown_section_group{margin-top: .8em;}.o_main_navbar .o_menu_sections .o_more_dropdown_section_group:first-child{margin-top: -0.5rem; padding-top: 0.75rem;}.o_main_navbar .o_menu_systray{--NavBar-entry-padding-left: 0.315em; --NavBar-entry-padding-right: 0.315em;}.o_main_navbar .o_menu_systray .badge{margin-right: -.5em; border: 0; padding: 2px 4px; background-color: var(--o-navbar-badge-bg, #28a745); font-size: 11px; color: var(--o-navbar-badge-color, inherit); text-shadow: var(--o-navbar-badge-text-shadow, 1px 1px 0 rgba(0, 0, 0, 0.3)); transform: translate(-0.6em, -30%);}body.o_is_superuser .o_menu_systray{border-image: repeating-linear-gradient(135deg, #d9b904, #d9b904 10px, #373435 10px, #373435 20px) 2; border-image-width: 2px;}\n/* /web/static/src/scss/animation.scss */\n @keyframes bounceIn{0%, 20%, 40%, 60%, 80%, 100%{transition-timing-function: cubic-bezier(0.215, 0.61, 0.355, 1);}0%{opacity: 0; transform: scale3d(0.3, 0.3, 0.3);}20%{transform: scale3d(1.1, 1.1, 1.1);}40%{transform: scale3d(0.9, 0.9, 0.9);}60%{opacity: 1; transform: scale3d(1.03, 1.03, 1.03);}80%{transform: scale3d(0.97, 0.97, 0.97);}100%{opacity: 1; transform: scale3d(1, 1, 1);}}@keyframes flash{from, 50%, to{opacity: 1;}25%, 75%{opacity: 0;}}\n/* /web/static/src/scss/base_frontend.scss */\n html, body, #wrapwrap{width: 100%; height: 100%; overflow: hidden;}#wrapwrap{z-index: 0; position: relative; display: -webkit-box; display: -webkit-flex; display: flex; -webkit-flex-flow: column nowrap; flex-flow: column nowrap; overflow: auto;}#wrapwrap > *{-webkit-box-flex: 0; -webkit-flex: 0 0 auto; flex: 0 0 auto;}#wrapwrap > main{-webkit-box-flex: 1; -webkit-flex: 1 0 auto; flex: 1 0 auto;}.modal-open #wrapwrap{overflow: hidden;}\n/* /web/static/src/scss/fontawesome_overridden.scss */\n @font-face{font-family: 'FontAwesome-tiktok-only'; src: url("/web/static/src/scss/../../fonts/tiktok_only.woff"); font-weight: normal; font-style: normal; font-display: block;}.fa.fa-tiktok{font-family: 'FontAwesome-tiktok-only' !important;}.fa.fa-tiktok:before{content: '\\e07b';}.o_rtl .fa.fa-align-right, .o_rtl .fa.fa-align-left, .o_rtl .fa.fa-chevron-right, .o_rtl .fa.fa-chevron-left, .o_rtl .fa.fa-arrow-right, .o_rtl .fa.fa-arrow-left, .o_rtl .fa.fa-hand-o-right, .o_rtl .fa.fa-hand-o-left, .o_rtl .fa.fa-arrow-circle-right, .o_rtl .fa.fa-arrow-circle-left, .o_rtl .fa.fa-caret-right, .o_rtl .fa.fa-caret-left, .o_rtl .fa.fa-rotate-right, .o_rtl .fa.fa-rotate-left, .o_rtl .fa.fa-angle-double-right, .o_rtl .fa.fa-angle-double-left, .o_rtl .fa.fa-angle-right, .o_rtl .fa.fa-angle-left, .o_rtl .fa.fa-quote-right, .o_rtl .fa.fa-quote-left, .o_rtl .fa.fa-chevron-circle-right, .o_rtl .fa.fa-chevron-circle-left, .o_rtl .fa.fa-long-arrow-right, .o_rtl .fa.fa-long-arrow-left, .o_rtl .fa.fa-toggle-right, .o_rtl .fa.fa-toggle-left, .o_rtl .fa.fa-caret-square-o-right, .o_rtl .fa.fa-arrow-circle-o-left, .o_rtl .fa.fa-arrow-circle-o-right, .o_rtl .fa.fa-caret-square-o-left{transform: rotate(180deg);}\n/* /web/static/src/scss/mimetypes.scss */\n .o_image{display: inline-block; width: 38px; height: 38px; background-image: url("/web/static/img/mimetypes/unknown.svg"); background-size: contain; background-repeat: no-repeat; background-position: center;}.o_image[data-mimetype^='image']{background-image: url("/web/static/img/mimetypes/image.svg");}.o_image[data-mimetype^='audio']{background-image: url("/web/static/img/mimetypes/audio.svg");}.o_image[data-mimetype^='text'], .o_image[data-mimetype$='rtf']{background-image: url("/web/static/img/mimetypes/text.svg");}.o_image[data-mimetype*='octet-stream'], .o_image[data-mimetype*='download'], .o_image[data-mimetype*='python']{background-image: url("/web/static/img/mimetypes/binary.svg");}.o_image[data-mimetype^='video'], .o_image[title$='.mp4'], .o_image[title$='.avi']{background-image: url("/web/static/img/mimetypes/video.svg");}.o_image[data-mimetype$='archive'], .o_image[data-mimetype$='compressed'], .o_image[data-mimetype*='zip'], .o_image[data-mimetype$='tar'], .o_image[data-mimetype*='package']{background-image: url("/web/static/img/mimetypes/archive.svg");}.o_image[data-mimetype='application/pdf']{background-image: url("/web/static/img/mimetypes/pdf.svg");}.o_image[data-mimetype^='text-master'], .o_image[data-mimetype*='document'], .o_image[data-mimetype*='msword'], .o_image[data-mimetype*='wordprocessing']{background-image: url("/web/static/img/mimetypes/document.svg");}.o_image[data-mimetype*='application/xml'], .o_image[data-mimetype$='html']{background-image: url("/web/static/img/mimetypes/web_code.svg");}.o_image[data-mimetype$='css'], .o_image[data-mimetype$='less'], .o_image[data-ext$='less']{background-image: url("/web/static/img/mimetypes/web_style.svg");}.o_image[data-mimetype*='-image'], .o_image[data-mimetype*='diskimage'], .o_image[data-ext$='dmg']{background-image: url("/web/static/img/mimetypes/disk.svg");}.o_image[data-mimetype$='csv'], .o_image[data-mimetype*='vc'], .o_image[data-mimetype*='excel'], .o_image[data-mimetype$='numbers'], .o_image[data-mimetype$='calc'], .o_image[data-mimetype*='mods'], .o_image[data-mimetype*='spreadsheet']{background-image: url("/web/static/img/mimetypes/spreadsheet.svg");}.o_image[data-mimetype^='key']{background-image: url("/web/static/img/mimetypes/certificate.svg");}.o_image[data-mimetype*='presentation'], .o_image[data-mimetype*='keynote'], .o_image[data-mimetype*='teacher'], .o_image[data-mimetype*='slideshow'], .o_image[data-mimetype*='powerpoint']{background-image: url("/web/static/img/mimetypes/presentation.svg");}.o_image[data-mimetype*='cert'], .o_image[data-mimetype*='rules'], .o_image[data-mimetype*='pkcs'], .o_image[data-mimetype$='stl'], .o_image[data-mimetype$='crl']{background-image: url("/web/static/img/mimetypes/certificate.svg");}.o_image[data-mimetype*='-font'], .o_image[data-mimetype*='font-'], .o_image[data-ext$='ttf']{background-image: url("/web/static/img/mimetypes/font.svg");}.o_image[data-mimetype*='-dvi']{background-image: url("/web/static/img/mimetypes/print.svg");}.o_image[data-mimetype*='script'], .o_image[data-mimetype*='x-sh'], .o_image[data-ext*='bat'], .o_image[data-mimetype$='bat'], .o_image[data-mimetype$='cgi'], .o_image[data-mimetype$='-c'], .o_image[data-mimetype*='java'], .o_image[data-mimetype*='ruby']{background-image: url("/web/static/img/mimetypes/script.svg");}.o_image[data-mimetype*='javascript']{background-image: url("/web/static/img/mimetypes/javascript.svg");}.o_image[data-mimetype*='calendar'], .o_image[data-mimetype$='ldif']{background-image: url("/web/static/img/mimetypes/calendar.svg");}.o_image[data-mimetype$='postscript'], .o_image[data-mimetype$='cdr'], .o_image[data-mimetype$='xara'], .o_image[data-mimetype$='cgm'], .o_image[data-mimetype$='graphics'], .o_image[data-mimetype$='draw'], .o_image[data-mimetype*='svg']{background-image: url("/web/static/img/mimetypes/vector.svg");}\n/* /web/static/src/scss/ui.scss */\n :root .o_hidden{display: none !important;}.o_disabled{pointer-events: none; opacity: 0.5;}.o_text_overflow{display: inline-block; max-width: 100%; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; vertical-align: top;}.dropdown-menu{max-height: 70vh; overflow: auto; background-clip: border-box;}.dropdown-toggle{white-space: nowrap;}.dropdown-toggle.o-no-caret::before, .dropdown-toggle.o-no-caret::after{content: normal;}.o_catch_attention{position: relative; z-index: 1; animation: catchAttention 200ms ease 0s infinite normal;}.o_treeEntry{padding-left: var(--treeEntry-padding-h, 1.5rem); position: relative;}.o_treeEntry:before, .o_treeEntry:after{position: absolute; left: var(--treeEntry--beforeAfter-left, calc(var(--treeEntry-padding-h, 1.5rem) * .5)); background: var(--treeEntry--beforeAfter-color, #DEE2E6); content: '';}.o_treeEntry:before{top: var(--treeEntry--before-top, 0); width: 1px; height: 100%;}.o_treeEntry:after{display: var(--treeEntry--after-display, initial); top: calc(.5em + var(--treeEntry-padding-v, 0.5rem)); width: calc(var(--treeEntry-padding-h, 1.5rem) * .5); height: 1px;}.o_treeEntry:last-of-type:before{height: calc(.5em + var(--treeEntry-padding-v, 0.5rem));}@keyframes catchAttention{0%, 20%, 40%, 60%, 80%, 100%{transition-timing-function: cubic-bezier(0.215, 0.61, 0.355, 1);}0%{transform: translateY(-30%);}20%{transform: translateY(-25%);}40%{transform: translateY(-20%);}60%{transform: translateY(-15%);}80%{transform: translateY(-10%);}100%{transform: translateY(-5%);}}span.o_force_ltr{display: inline;}.o_force_ltr{unicode-bidi: embed; direction: ltr;}.o_object_fit_cover{object-fit: cover;}.o_object_fit_contain{object-fit: contain;}.o_image_24_cover{width: 24px; height: 24px; object-fit: cover;}.o_image_40_cover{width: 40px; height: 40px; object-fit: cover;}.o_image_64_cover{width: 64px; height: 64px; object-fit: cover;}.o_image_64_contain{width: 64px; height: 64px; object-fit: contain;}.o_image_64_max{max-width: 64px; max-height: 64px;}\n/* /web/static/src/views/fields/translation_dialog.scss */\n .o_translation_dialog .o_language_current{font-weight: bold;}.o_translation_dialog .row{margin-bottom: 9px;}\n/* /web/static/src/views/fields/signature/signature_field.scss */\n .o_field_widget .o_signature{outline: 1px solid rgba(133, 149, 162, 0.3); position: relative;}.o_field_widget .o_signature.o_signature_empty{display: -webkit-box; display: -webkit-flex; display: flex;}.o_field_widget .o_signature > p{position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%);}.o_field_invalid .o_signature{outline: 3px solid #dc3545; cursor: pointer;}.o_form_editable .o_signature:hover{outline: 3px solid #017e84; cursor: pointer;}\n/* /web/static/src/legacy/scss/ui.scss */\n .ui-autocomplete{z-index: 1056; max-width: 600px;}.ui-autocomplete .ui-menu-item > a{display: block;}.o_rtl .ui-autocomplete{direction: ltr; right: 0; left: auto;}\n/* /web/static/src/legacy/scss/modal.scss */\n .modal.o_technical_modal .modal-content .modal-header .o_subtitle{margin-left: 10px;}@media (max-width: 575.98px){.modal.o_technical_modal.o_modal_full .modal-dialog .modal-content .modal-header .o_subtitle{color: rgba(255, 255, 255, 0.9);}}\n/* /web/static/src/legacy/scss/lazyloader.scss */\n a[href].o_wait_lazy_js, .o_wait_lazy_js a[href], button.o_wait_lazy_js, .o_wait_lazy_js button, input[type="submit"].o_wait_lazy_js, .o_wait_lazy_js input[type="submit"], input[type="button"].o_wait_lazy_js, .o_wait_lazy_js input[type="button"], .btn.o_wait_lazy_js, .o_wait_lazy_js .btn{pointer-events: none;}\n/* /web/static/src/core/utils/transitions.scss */\n/* /web/static/src/core/action_swiper/action_swiper.scss */\n .o_actionswiper{position: relative; touch-action: pan-y;}.o_actionswiper_target_container{transition: transform 0.4s;}.o_actionswiper_swiping{transition: none;}.o_actionswiper_right_swipe_area{transform: translateX(-100%); inset: 0 auto auto 0;}.o_actionswiper_left_swipe_area{transform: translateX(100%); inset: 0 0 auto auto;}\n/* /web/static/src/core/autocomplete/autocomplete.scss */\n .o-autocomplete .o-autocomplete--input{width: 100%;}\n/* /web/static/src/core/avatar/avatar.scss */\n .o_avatar img, .o_avatar .o_avatar_empty, img.o_avatar{height: var(--Avatar-size, 1.7145em); aspect-ratio: 1; object-fit: cover;}.o_avatar_empty{background: #000000; opacity: .1;}\n/* /web/static/src/core/checkbox/checkbox.scss */\n .o-checkbox{width: fit-content;}\n/* /web/static/src/core/colorlist/colorlist.scss */\n .o_colorlist button{border: 1px solid #FFFFFF; box-shadow: 0 0 0 1px #ADB5BD; width: 22px; height: 17px;}.o_colorlist .o_colorlist_selected{box-shadow: 0 0 0 2px #71639e !important;}.o_colorlist_item_color_1{--background-color: RGBA(255, 155.5, 155.5, var(--bg-opacity, 1)); background-color: var(--background-color) !important;}.o_colorlist_item_color_2{--background-color: RGBA(247.0375, 198.06116071, 152.4625, var(--bg-opacity, 1)); background-color: var(--background-color) !important;}.o_colorlist_item_color_3{--background-color: RGBA(252.88960843, 226.89175248, 135.61039157, var(--bg-opacity, 1)); background-color: var(--background-color) !important;}.o_colorlist_item_color_4{--background-color: RGBA(187.45210396, 215.03675558, 248.04789604, var(--bg-opacity, 1)); background-color: var(--background-color) !important;}.o_colorlist_item_color_5{--background-color: RGBA(216.79194664, 167.70805336, 203.91748283, var(--bg-opacity, 1)); background-color: var(--background-color) !important;}.o_colorlist_item_color_6{--background-color: RGBA(247.84539474, 213.9484835, 199.65460526, var(--bg-opacity, 1)); background-color: var(--background-color) !important;}.o_colorlist_item_color_7{--background-color: RGBA(136.6125, 224.8875, 218.94591346, var(--bg-opacity, 1)); background-color: var(--background-color) !important;}.o_colorlist_item_color_8{--background-color: RGBA(150.60535714, 165.68382711, 248.89464286, var(--bg-opacity, 1)); background-color: var(--background-color) !important;}.o_colorlist_item_color_9{--background-color: RGBA(254.94583333, 157.55416667, 203.95543194, var(--bg-opacity, 1)); background-color: var(--background-color) !important;}.o_colorlist_item_color_10{--background-color: RGBA(182.62075688, 236.87924312, 189.81831118, var(--bg-opacity, 1)); background-color: var(--background-color) !important;}.o_colorlist_item_color_11{--background-color: RGBA(230.11575613, 219.41069277, 252.08930723, var(--bg-opacity, 1)); background-color: var(--background-color) !important;}.o_colorlist_item_color_0{background: linear-gradient(45deg, rgba(255, 255, 255, 0) 0%, rgba(255, 255, 255, 0) 48%, #dc3545 48%, #dc3545 52%, rgba(255, 255, 255, 0) 52%, rgba(255, 255, 255, 0) 100%);}\n/* /web/static/src/core/colorpicker/colorpicker.scss */\n .o_colorpicker_widget .o_color_pick_area{height: 125px; background-image: linear-gradient(to bottom, white 0%, rgba(255, 255, 255, 0) 50%, rgba(0, 0, 0, 0) 50%, black 100%), linear-gradient(to right, gray 0%, rgba(128, 128, 128, 0) 100%); cursor: crosshair;}.o_colorpicker_widget .o_color_slider{background: linear-gradient(#F00 0%, #FF0 16.66%, #0F0 33.33%, #0FF 50%, #00F 66.66%, #F0F 83.33%, #F00 100%);}.o_colorpicker_widget .o_color_slider, .o_colorpicker_widget .o_opacity_slider{width: 4%; margin-right: 2%; cursor: pointer;}.o_colorpicker_widget .o_slider_pointer, .o_colorpicker_widget .o_opacity_pointer{position: absolute; top: auto; left: -50%; bottom: auto; right: auto; width: 200%; height: 8px; margin-top: -2px;}.o_colorpicker_widget .o_slider_pointer, .o_colorpicker_widget .o_opacity_pointer, .o_colorpicker_widget .o_picker_pointer, .o_colorpicker_widget .o_color_preview{box-shadow: inset 0 0 0 1px rgba(255, 255, 255, 0.9); border: 1px solid black;}.o_colorpicker_widget .o_color_picker_inputs{font-size: 10px;}.o_colorpicker_widget .o_color_picker_inputs input{font-family: monospace !important; height: 18px; font-size: 11px;}.o_colorpicker_widget .o_color_picker_inputs .o_hex_div input{width: 7ch;}.o_colorpicker_widget .o_color_picker_inputs .o_rgba_div input{margin-right: 3px; width: 3ch;}\n/* /web/static/src/core/datetime/datetime_picker.scss */\n .o_datetime_picker{--DateTimePicker__Cell-size-md: 3rem; --DateTimePicker__Cell-size-lg: 5rem; --DateTimePicker__Template-rows: 3; --DateTimePicker__Template-columns: 4; --DateTimePicker__Day-template-rows: 6;}.o_datetime_picker .o_datetime_picker_header .o_header_part{text-transform: none;}.o_datetime_picker .o_date_item_cell{position: relative; border-radius: 0;}.o_datetime_picker .o_current, .o_datetime_picker .o_selected{color: #212529;}.o_datetime_picker .o_selected:not(.o_select_start):not(.o_select_end){background: #dddbe8;}.o_datetime_picker .o_current:before, .o_datetime_picker .o_highlight_start:not(.o_selected):before, .o_datetime_picker .o_highlight_end:not(.o_selected):before, .o_datetime_picker .o_select_start:before, .o_datetime_picker .o_select_end:before{content: ""; position: absolute; box-shadow: inset 0 0 0 1px #71639e; width: 100%; aspect-ratio: 1; border-radius: 100%; z-index: 1;}.o_datetime_picker .o_select_start:before, .o_datetime_picker .o_select_end:before{background: #d1cee0;}.o_datetime_picker .o_select_start:after, .o_datetime_picker .o_select_end:after{content: ""; position: absolute; background: transparent; width: 50%; aspect-ratio: 1/2;}.o_datetime_picker .o_select_start:not(.o_select_end):after, .o_datetime_picker .o_select_end:not(.o_select_end):after{right: 0; background: #dddbe8;}.o_datetime_picker .o_select_start:not(.o_select_start):after, .o_datetime_picker .o_select_end:not(.o_select_start):after{right: 50%; background: #dddbe8;}.o_datetime_picker .o_today:not(.o_out_of_range) span{position: relative;}.o_datetime_picker .o_today:not(.o_out_of_range) span::after{content: ""; position: absolute; left: 50%; bottom: -0.25rem; transform: translateX(-50%); width: 0.95em; height: 0.2em; border-radius: 50rem; background: #dc3545;}.o_datetime_picker .o_out_of_range{color: var(--gray-400);}.o_datetime_picker .o_time_picker_select{background: none;}.o_datetime_picker .o_time_picker_select:focus, .o_datetime_picker .o_time_picker_select:hover{border-color: var(--primary);}.o_datetime_picker .o_date_picker{grid-template-rows: repeat(var(--DateTimePicker__Day-template-rows), 1fr); grid-template-columns: repeat(var(--DateTimePicker__Day-template-columns), 1fr);}.o_datetime_picker .o_date_item_picker{grid-template-rows: repeat(var(--DateTimePicker__Template-rows), 1fr); grid-template-columns: repeat(var(--DateTimePicker__Template-columns), 1fr);}.o_datetime_picker .o_date_item_picker .o_datetime_button.o_selected:not(.o_select_start):not(.o_select_end), .o_datetime_picker .o_date_item_picker .o_datetime_button:hover:not(.o_select_start):not(.o_select_end), .o_datetime_picker .o_date_item_picker .o_datetime_button.o_today:not(.o_selected):hover:not(.o_select_start):not(.o_select_end){background: #dddbe8; color: #212529;}.o_datetime_picker .o_center{display: grid; place-items: center;}.o_datetime_picker .o_zoom_out{gap: 3.359375rem;}.o_datetime_picker .o_cell_md{padding: 0.4rem; width: var(--DateTimePicker__Cell-size-md); height: var(--DateTimePicker__Cell-size-md);}.o_datetime_picker .o_cell_lg{width: var(--DateTimePicker__Cell-size-lg); height: var(--DateTimePicker__Cell-size-lg);}.o_datetime_picker .o_text_sm{font-size: 0.875rem;}.o_datetime_picker .o_time_picker{direction: ltr;}\n/* /web/static/src/core/debug/debug_menu.scss */\n .o_dialog .o_debug_manager .dropdown-toggle{padding: 0 4px; margin: 2px 10px 2px 0;}\n/* /web/static/src/core/debug/profiling/profiling_item.scss */\n .o_debug_manager .dropdown-menu .o_debug_profiling_item_wrapper.dropdown-item.focus{background: inherit;}.o_debug_manager .o_debug_profiling_item{cursor: auto;}.o_debug_manager .form-switch{cursor: pointer;}.o_debug_recording{animation: 2s flash infinite;}\n/* /web/static/src/core/debug/profiling/profiling_qweb.scss */\n .o_form_view .o_ace_view_editor{background: transparent;}.o_profiling_qweb_view{user-select: none;}.o_profiling_qweb_view .o_select_view_profiling{margin-bottom: 10px;}.o_profiling_qweb_view .o_select_view_profiling .dropdown-menu{overflow: auto; max-height: 240px;}.o_profiling_qweb_view .o_select_view_profiling a{margin: 3px 0; display: block;}.o_profiling_qweb_view .o_select_view_profiling a .o_delay, .o_profiling_qweb_view .o_select_view_profiling a .o_query{font-size: 0.8em; display: inline-block; color: #212529; text-align: right; width: 50px; margin-right: 10px; white-space: nowrap;}.o_profiling_qweb_view .o_select_view_profiling a .o_key{display: inline-block; margin-left: 10px; font-size: 0.8em;}.o_profiling_qweb_view .ace_editor{overflow: visible;}.o_profiling_qweb_view .ace_editor .ace_qweb, .o_profiling_qweb_view .ace_editor .ace_tag-name{cursor: default; pointer-events: all; position: relative;}.o_profiling_qweb_view .ace_editor .ace_qweb .o_info, .o_profiling_qweb_view .ace_editor .ace_tag-name .o_info{display: none; left: 8px; top: 14px; width: 100px;}.o_profiling_qweb_view .ace_editor .ace_qweb .o_info .o_delay span, .o_profiling_qweb_view .ace_editor .ace_qweb .o_info .o_query span, .o_profiling_qweb_view .ace_editor .ace_tag-name .o_info .o_delay span, .o_profiling_qweb_view .ace_editor .ace_tag-name .o_info .o_query span{text-align: left; display: inline-block; width: 40px;}.o_profiling_qweb_view .ace_editor .ace_qweb:hover .o_info, .o_profiling_qweb_view .ace_editor .ace_tag-name:hover .o_info{display: block;}.o_profiling_qweb_view .ace_editor .ace_qweb:hover .o_info:hover, .o_profiling_qweb_view .ace_editor .ace_tag-name:hover .o_info:hover{display: none;}.o_profiling_qweb_view .ace_editor .ace_gutter{overflow: visible;}.o_profiling_qweb_view .ace_editor .ace_gutter-layer{width: 134px !important; overflow: visible;}.o_profiling_qweb_view .ace_editor .ace_gutter-cell .o_info{display: block; float: left; font-size: 0.8em; white-space: nowrap;}.o_profiling_qweb_view .ace_editor .ace_gutter-cell .o_info .o_more{float: left; position: relative;}.o_profiling_qweb_view .ace_editor .ace_gutter-cell .o_info .o_more span{color: orange !important; cursor: default; margin-left: -12px;}.o_profiling_qweb_view .ace_editor .ace_gutter-cell .o_info .o_more .o_detail{left: 30px; top: -30px; min-width: 120px; display: none;}.o_profiling_qweb_view .ace_editor .ace_gutter-cell .o_info .o_more .o_detail th{text-align: center;}.o_profiling_qweb_view .ace_editor .ace_gutter-cell .o_info .o_more .o_detail td{min-width: 60px; vertical-align: top; text-align: left;}.o_profiling_qweb_view .ace_editor .ace_gutter-cell .o_info .o_more .o_detail tr td:first-child{padding-right: 10px; white-space: nowrap;}.o_profiling_qweb_view .ace_editor .ace_gutter-cell .o_info .o_more .o_detail tr th:last-child, .o_profiling_qweb_view .ace_editor .ace_gutter-cell .o_info .o_more .o_detail tr td:last-child{padding-left: 10px;}.o_profiling_qweb_view .ace_editor .ace_gutter-cell .o_info .o_more:hover > .o_detail{display: block;}.o_profiling_qweb_view .ace_editor .ace_gutter-cell .o_info .o_more:hover > .o_detail:hover{display: none;}.o_profiling_qweb_view .ace_editor .ace_gutter-cell .o_info .o_delay, .o_profiling_qweb_view .ace_editor .ace_gutter-cell .o_info .o_query{display: block; float: left; margin-right: 10px; width: 30px;}.o_profiling_qweb_view .ace_editor .ace_line{border-bottom: 1px #dddddd dotted;}.o_profiling_qweb_view .ace_editor .ace_scrollbar-h{z-index: 3;}.o_profiling_qweb_view .ace_editor .o_detail{position: absolute; z-index: 1; background: #ffedcb; color: orange !important; border: 1px orange solid; padding: 6px; white-space: normal; text-align: right;}\n/* /web/static/src/core/dialog/dialog.scss */\n .modal.o_technical_modal .modal-content .modal-header .modal-title{overflow: hidden; white-space: nowrap; text-overflow: ellipsis;}.modal.o_technical_modal .modal-footer{text-align: left;}.modal.o_technical_modal .modal-footer footer, .modal.o_technical_modal .modal-footer .o_form_buttons_edit, .modal.o_technical_modal .modal-footer .o_form_buttons_view{display: -webkit-box; display: -webkit-flex; display: flex; -webkit-flex-wrap: wrap; flex-wrap: wrap; -webkit-box-flex: 1; -webkit-flex: 1 1 auto; flex: 1 1 auto; -webkit-box-pack: start; justify-content: flex-start; gap: 0.25rem;}@media (max-width: 767.98px){.modal.o_technical_modal .modal-footer footer, .modal.o_technical_modal .modal-footer .o_form_buttons_edit, .modal.o_technical_modal .modal-footer .o_form_buttons_view{justify-content: space-around;}}.modal.o_technical_modal .modal-footer button{margin: 0;}@media (max-width: 767.98px){.modal.o_technical_modal .modal-footer .btn{width: 45%; text-overflow: ellipsis; white-space: inherit;}}@media (max-width: 575.98px){.modal.o_technical_modal.o_modal_full .modal-dialog{margin: 0px; height: 100%;}.modal.o_technical_modal.o_modal_full .modal-dialog .modal-content{height: 100%; border: none;}.modal.o_technical_modal.o_modal_full .modal-dialog .modal-content .modal-header{background: #71639e;}.modal.o_technical_modal.o_modal_full .modal-dialog .modal-content .modal-header .modal-title, .modal.o_technical_modal.o_modal_full .modal-dialog .modal-content .modal-header .btn{color: rgba(255, 255, 255, 0.9);}.modal.o_technical_modal.o_modal_full .modal-dialog .modal-content .modal-body{height: 100%; overflow-y: auto;}}.modal.o_inactive_modal{z-index: 1049;}.o_dialog > .modal{display: block;}@media (min-width: 576px){.modal-fs{width: calc(100% - 3.5rem); max-width: none;}}@media (max-width: 767.98px){.modal.o_modal_full .modal-content .modal-header{align-items: center; height: 46px; padding: 0 1rem;}.modal.o_modal_full .modal-content .modal-footer{padding-top: 1rem; padding-right: 16px; padding-bottom: 0.5rem; padding-left: 16px; box-shadow: 0 1rem 2rem black; z-index: 0;}}\n/* /web/static/src/core/dropdown/accordion_item.scss */\n .o_accordion_toggle::after{display: inline-block; margin-left: 0.255em; vertical-align: 0.255em; content: ""; border-top: 0.3em solid; border-right: 0.3em solid transparent; border-bottom: 0; border-left: 0.3em solid transparent;}.o_accordion_toggle:empty::after{margin-left: 0;}.o_accordion_toggle.open::after{display: inline-block; margin-left: 0.255em; vertical-align: 0.255em; content: ""; border-top: 0; border-right: 0.3em solid transparent; border-bottom: 0.3em solid; border-left: 0.3em solid transparent;}.o_accordion_toggle.open:empty::after{margin-left: 0;}.o_accordion_toggle::after{position: absolute; top: 0; left: auto; bottom: auto; right: 0; transform: translate(-0.6em, 0.8em);}\n/* /web/static/src/core/dropdown/dropdown.scss */\n .o-dropdown{}.o-dropdown--menu{position: fixed; margin-top: var(--Dropdown_menu-margin-y, 0.25rem); margin-bottom: var(--Dropdown_menu-margin-y, 0.25rem);}.o-dropdown--menu.o-dropdown--menu-submenu{--Dropdown_menu-margin-y: 0;}.o-dropdown--menu .dropdown-toggle:focus, .o-dropdown--menu .dropdown-item:focus{background-color: transparent; outline: none;}.o-dropdown--menu .dropdown-toggle.focus, .o-dropdown--menu .dropdown-item.focus{background-color: #E9ECEF;}.o-dropdown--menu .dropdown-item:not(.disabled):not(:disabled):not(.o_wysiwyg_loader), .o-dropdown--menu .dropdown-item:not(.disabled):not(:disabled):not(.o_wysiwyg_loader) label{cursor: pointer;}.o-dropdown--menu .o-dropdown > .o-dropdown--menu{--o-dropdown--submenu-margin: calc(-.5rem - 1px); margin-top: var(--o-dropdown--submenu-margin); margin-bottom: var(--o-dropdown--submenu-margin);}.o-dropdown.dropup > .o-dropdown--menu, .o-dropdown.dropdown > .o-dropdown--menu, .o-dropdown.dropstart > .o-dropdown--menu, .o-dropdown.dropend > .o-dropdown--menu{left: auto; right: auto; margin-left: 0; margin-right: 0;}.o-dropdown--no-caret > .dropdown-toggle::before, .o-dropdown--no-caret > .dropdown-toggle::after{content: normal;}.o-dropdown button.dropdown-toggle.active, .o-dropdown button.dropdown-toggle:hover, .o-dropdown button.dropdown-toggle:focus, .o-dropdown button.dropdown-toggle:active{outline: none; box-shadow: none !important;}.o-dropdown button.dropdown-toggle.dropdown-item:not(.o_menu_item)::after, .o-dropdown button.dropdown-toggle.dropdown-item:not(.o_menu_item)::before{position: absolute; top: 0; left: auto; bottom: auto; right: 0; transform: translate(-0.6em, 0.6em) ;}\n/* /web/static/src/core/effects/rainbow_man.scss */\n .o_reward{will-change: transform; z-index: 1055; animation: reward-fading 0.7s ease-in-out forwards;}.o_reward .o_reward_box{transform-box: fill-box;}.o_reward.o_reward_fading{animation: reward-fading-reverse 0.56s ease-in-out forwards;}.o_reward.o_reward_fading .o_reward_face_group{animation: reward-jump-reverse 0.56s ease-in-out forwards;}.o_reward.o_reward_fading .o_reward_rainbow_line{animation: reward-rainbow-reverse 0.7s ease-out forwards;}.o_reward .o_reward_rainbow_man{max-width: 400px;}.o_reward .o_reward_rainbow_line{animation: reward-rainbow 1.12s ease-out 1 forwards;}.o_reward .o_reward_face_group{animation: reward-jump 1.12s ease-in-out 1;}.o_reward .o_reward_face_wrap{animation: reward-rotate 1.12s cubic-bezier(0.51, 0.92, 0.24, 1.15) 1;}.o_reward .o_reward_face{animation: reward-float 1.4s ease-in-out 1.4s infinite alternate;}.o_reward .o_reward_star_01, .o_reward .o_reward_star_03{animation: reward-stars 1.4s ease-in-out infinite alternate-reverse;}.o_reward .o_reward_star_02, .o_reward .o_reward_star_04{animation: reward-stars 1.68s ease-in-out infinite alternate;}.o_reward .o_reward_thumbup{animation: reward-scale 0.7s ease-in-out 0s infinite alternate;}.o_reward .o_reward_shadow_container{animation: reward-float 1.4s ease-in-out infinite alternate;}.o_reward .o_reward_shadow{animation: reward-scale 1.4s ease-in-out infinite alternate;}.o_reward .o_reward_msg_container{aspect-ratio: 1 / 1; animation: reward-float-reverse 1.4s ease-in-out infinite alternate-reverse;}@keyframes reward-fading{0%{opacity: 0;}}@keyframes reward-fading-reverse{100%{opacity: 0;}}@keyframes reward-jump{0%{transform: scale(0.5);}50%{transform: scale(1.05);}}@keyframes reward-jump-reverse{50%{transform: scale(1.05);}to{transform: scale(0.5);}}@keyframes reward-rainbow{to{stroke-dashoffset: 0;}}@keyframes reward-rainbow-reverse{from{stroke-dashoffset: 0;}}@keyframes reward-float{to{transform: translateY(5px);}}@keyframes reward-float-reverse{from{transform: translateY(5px);}}@keyframes reward-stars{from{transform: scale(0.3) rotate(0deg);}50%{transform: scale(1) rotate(20deg);}to{transform: scale(0.3) rotate(80deg);}}@keyframes reward-scale{from{transform: scale(0.8);}}@keyframes reward-rotate{from{transform: scale(0.5) rotate(-30deg);}}\n/* /web/static/src/core/emoji_picker/emoji_picker.dark.scss */\n .o-EmojiPicker{--o-emoji-picker-active: #FFFFFF;}\n/* /web/static/src/core/emoji_picker/emoji_picker.scss */\n .popover .o-EmojiPicker{width: 285px; height: 350px;}.o-EmojiPicker{--o-emoji-picker-active: #E9ECEF;}.o-EmojiPicker .o-active{background-color: var(--o-emoji-picker-active) !important;}.o-EmojiPicker .o-Emoji{width: 30px; font-size: 0.8rem;}.o-EmojiPicker .o-Emoji:hover{background-color: var(--o-emoji-picker-active) !important;}.o-EmojiPicker .o-EmojiPicker-navbar .o-Emoji{filter: grayscale(1);}.o-EmojiPicker .o-EmojiPicker-sectionIcon{filter: grayscale(1);}.o-EmojiPicker .o-EmojiPicker-empty{font-size: 5rem !important; filter: grayscale(0.25);}.o-EmojiPicker-category:before{content: "\\200b";}.o-EmojiPicker-search input:not(:focus) + .oi-search{color: #6C757D;}\n/* /web/static/src/core/errors/error_dialog.scss */\n @media (min-width: 768px){.o_error_dialog{padding: 1rem;}.o_error_dialog .o_error_detail{overflow: auto;}.o_error_dialog .o_error_detail pre{overflow: initial; max-height: 30vh;}}.o_error_dialog .modal-header{border: none; padding-bottom: 0; margin-bottom: -1rem;}.o_error_dialog .modal-header .modal-title{font-size: 1.625rem;}.o_error_dialog .modal-footer{border: none; padding-top: 0;}\n/* /web/static/src/core/file_upload/file_upload_progress_bar.scss */\n .o-file-upload-progress-bar-value{transition: width 0.1s; border-right: 1px solid #605487; background-color: #71639e; opacity: 0.5;}.o-file-upload-progress-bar-abort{padding: 4px; color: #963535; font-size: 16px;}.o-file-upload-progress-bar-abort:active{opacity: 0.7;}div:not(:hover) .o-file-upload-progress-bar-abort{display: none;}\n/* /web/static/src/core/file_upload/file_upload_progress_record.scss */\n .o_kanban_record .o_kanban_progress_card{min-height: 80px;}.o_kanban_record .o_kanban_progress_card .o_kanban_record_bottom{color: #212529;}.o_kanban_record .o_kanban_progress_card .o_kanban_image_wrapper{opacity: 0.7;}.o_data_row.o_list_progress_card{height: 25px; border: 1px solid #dfdfdf;}.o_data_row.o_list_progress_card .o_file_upload_upload_title{font-size: 13px; font-weight: 500;}\n/* /web/static/src/core/file_viewer/file_viewer.scss */\n .o-FileViewer{z-index: -1; outline: none;}.o-FileViewer-navigation{width: 40px; height: 40px;}.o-FileViewer-header{height: 46px;}.o-FileViewer-main{z-index: -1; padding: 51.75px 0;}.o-FileViewer-zoomer{padding: 51.75px 0;}.o-FileViewer-headerButton:hover{background-color: rgba(255, 255, 255, 0.1); color: #fafafb;}.o-FileViewer-toolbarButton{background-color: var(--file-viewer-toolbarButton-background-color, #343a40); color: #fff;}.o-FileViewer-toolbarButton:hover{filter: brightness(1.3);}.o-FileViewer-view{background-color: #000000; box-shadow: 0 0 40px #000000; outline: none;}.o-FileViewer-view.o-isText{background: #FFFFFF;}\n/* /web/static/src/core/install_prompt/install_prompt.scss */\n .o_install_prompt{border-radius: 20px; height: unset !important; -webkit-backdrop-filter: blur(5px); backdrop-filter: blur(5px); background: rgba(255, 255, 255, 0.7); inset: 0 auto auto 0 !important; width: fit-content !important;}.o_install_prompt.o_touch_bounce{animation: none;}@media screen and (max-width: 768px){.o_install_prompt{inset: auto auto 0 0 !important; width: 90% !important; margin: 5% !important;}.o_install_prompt .modal-header{background: none !important; border: none !important;}.o_install_prompt .modal-header button{color: #000000 !important;}}\n/* /web/static/src/core/model_field_selector/model_field_selector.scss */\n .o_model_field_selector{position: relative;}.o_model_field_selector.o_edit_mode{cursor: pointer;}.o_model_field_selector > .o_model_field_selector_value{min-height: 20px; max-width: 100%; word-wrap: break-word;}.o_model_field_selector > .o_model_field_selector_value:active, .o_model_field_selector > .o_model_field_selector_value:focus, .o_model_field_selector > .o_model_field_selector_value:active:focus{outline: none;}.o_model_field_selector > .o_model_field_selector_value > .o_model_field_selector_chain_part{cursor: inherit; border: 1px solid #dae0e5; background: #f8f9fa;}.o_model_field_selector > .o_model_field_selector_value > i{font-size: 10px;}\n/* /web/static/src/core/model_field_selector/model_field_selector_popover.scss */\n .o_popover_field_selector.o-popover-top > .popover-arrow::after{border-top-color: #dee2e6;}.o_popover_field_selector.o-popover-bottom > .popover-arrow::after{border-bottom-color: #dee2e6;}.o_model_field_selector_popover{width: 265px; background-color: #FFFFFF; --o-input-background-color: #FFFFFF;}.o_model_field_selector_popover:focus{outline: none;}.o_model_field_selector_popover .o_model_field_selector_popover_header, .o_model_field_selector_popover .o_model_field_selector_popover_footer{color: #FFFFFF; background: #dee2e6; font-weight: bold; padding: 5px 0.4em;}.o_model_field_selector_popover .o_model_field_selector_popover_header .o_model_field_selector_popover_title, .o_model_field_selector_popover .o_model_field_selector_popover_footer .o_model_field_selector_popover_title{width: 100%; display: inline-block; max-width: 100%; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; vertical-align: top; padding: 0px 35px; text-align: center;}.o_model_field_selector_popover .o_model_field_selector_popover_header .o_model_field_selector_popover_option, .o_model_field_selector_popover .o_model_field_selector_popover_footer .o_model_field_selector_popover_option{position: absolute; top: 0; left: auto; bottom: auto; right: auto; padding: 8px;}.o_model_field_selector_popover .o_model_field_selector_popover_header .o_model_field_selector_popover_option.o_model_field_selector_popover_prev_page, .o_model_field_selector_popover .o_model_field_selector_popover_footer .o_model_field_selector_popover_option.o_model_field_selector_popover_prev_page{left: 0;}.o_model_field_selector_popover .o_model_field_selector_popover_header .o_model_field_selector_popover_option.o_model_field_selector_popover_close, .o_model_field_selector_popover .o_model_field_selector_popover_footer .o_model_field_selector_popover_option.o_model_field_selector_popover_close{right: 0;}.o_model_field_selector_popover .o_model_field_selector_popover_header .o_model_field_selector_popover_option:hover, .o_model_field_selector_popover .o_model_field_selector_popover_footer .o_model_field_selector_popover_option:hover{background: #52374b;}.o_model_field_selector_popover .o_model_field_selector_popover_body .o_model_field_selector_popover_page{position: relative; height: 320px; overflow: auto; margin: 0; padding: 0;}.o_model_field_selector_popover .o_model_field_selector_popover_body .o_model_field_selector_popover_page > .o_model_field_selector_popover_item{list-style: none; cursor: pointer; font-family: Arial; font-size: 13px; border-bottom: 1px solid #d6d9dc;}.o_model_field_selector_popover .o_model_field_selector_popover_body .o_model_field_selector_popover_page > .o_model_field_selector_popover_item.active{background: #E9ECEF;}.o_model_field_selector_popover .o_model_field_selector_popover_body .o_model_field_selector_popover_page > .o_model_field_selector_popover_item .o_model_field_selector_popover_item_title{font-size: 12px;}.o_model_field_selector_popover .o_model_field_selector_popover_body .o_model_field_selector_popover_page > .o_model_field_selector_popover_item .o_model_field_selector_popover_item_relation{border-radius: 0px; border-left: 1px solid #d6d9dc;}\n/* /web/static/src/core/model_selector/model_selector.scss */\n .o_model_selector .o-autocomplete--dropdown-menu{width: 25ch; max-height: 350px !important;}.o_model_selector .o-autocomplete--dropdown-menu .o-autocomplete--dropdown-item a{text-overflow: ellipsis; width: inherit;}\n/* /web/static/src/core/notebook/notebook.scss */\n .o_notebook{--notebook-margin-x: 0; --notebook-padding-x: 0; --notebook-link-border-color: transparent; --notebook-link-border-color-active: #DEE2E6; --notebook-link-border-color-hover: #E9ECEF; --notebook-link-border-color-active-accent: #DEE2E6;}.o_notebook .o_notebook_headers{margin: 0 var(--notebook-margin-x, 0); overflow-x: auto;}@media (max-width: 767.98px){.o_notebook .o_notebook_headers::-webkit-scrollbar{display: none;}}.o_notebook .nav{padding: 0 var(--notebook-padding-x, 0); background-color: white;}.o_notebook .nav-item{white-space: nowrap; margin: 0 -1px 0 0;}.o_notebook .nav-item.disabled .nav-link{cursor: not-allowed; opacity: .3;}.o_notebook .nav-link{border-color: var(--notebook-link-border-color, transparent);}.o_notebook .nav-link.active, .o_notebook .nav-link.active:hover, .o_notebook .nav-link.active:focus, .o_notebook .nav-link.active:active{border-color: var(--notebook-link-border-color-active); border-top-color: var(--notebook-link-border-color-active-accent, var(--notebook-link-border-color-active)); border-bottom-color: white;}.o_notebook .nav-link:hover, .o_notebook .nav-link:focus, .o_notebook .nav-link:active{outline: none;}.o_notebook .nav-link:hover{border-color: var(--notebook-link-border-color-hover);}.o_notebook.vertical .o_notebook_headers{overflow-x: visible;}.o_notebook.vertical .nav{width: max-content; border-bottom-color: transparent;}.o_notebook.vertical .nav-item{margin: 0 0 -1px 0;}.o_notebook.vertical .nav-item:first-child .nav-link{border-top-width: 0;}.o_notebook.vertical .nav-link{margin-bottom: 0;}.o_notebook.vertical .nav-link.active, .o_notebook.vertical .nav-link.active:hover, .o_notebook.vertical .nav-link.active:focus, .o_notebook.vertical .nav-link.active:active{border-color: var(--notebook-link-border-color-active); border-left-color: var(--notebook-link-border-color-active-accent, var(--notebook-link-border-color-active)); border-right-color: white;}@media (max-width: 991.98px){.o_notebook .o_notebook_content .oe-toolbar{position: -webkit-sticky; position: sticky; top: 0px; left: auto; bottom: auto; right: auto; margin-left: var(--notebook-margin-x, 16px); margin-right: var(--notebook-margin-x, 16px); width: auto;}}\n/* /web/static/src/core/notifications/notification.scss */\n .o_notification_manager{position: absolute; top: 52.9px; left: calc(100vw - 320px); bottom: auto; right: 0.5rem; z-index: 1055;}.o_notification_manager .o_notification{border-left-width: 0.75rem !important; box-shadow: 0 0.25rem 0.75rem rgba(0, 0, 0, 0.1);}.o_notification_manager .o_notification_close{position: absolute; top: 0; left: auto; bottom: auto; right: 0;}.o_notification_fade{transition: all 0.5s;}.o_notification_fade-enter{opacity: 0;}\n/* /web/static/src/core/popover/popover.scss */\n .o_popover.o-popover-top, .o_popover.o-popover-auto[x-placement^="top"]{margin-bottom: 0.5rem;}.o_popover.o-popover-right, .o_popover.o-popover-auto[x-placement^="right"]{margin-left: 0.5rem;}.o_popover.o-popover-bottom, .o_popover.o-popover-auto[x-placement^="bottom"]{margin-top: 0.5rem;}.o_popover.o-popover-left, .o_popover.o-popover-auto[x-placement^="left"]{margin-right: 0.5rem;}.o_popover.o-popover--ts .popover-arrow, .o_popover.o-popover--bs .popover-arrow{left: 0.3rem;}.o_popover.o-popover--te .popover-arrow, .o_popover.o-popover--be .popover-arrow{right: 0.3rem;}.o_popover.o-popover--ls .popover-arrow, .o_popover.o-popover--rs .popover-arrow{top: 0.3rem;}.o_popover.o-popover--le .popover-arrow, .o_popover.o-popover--re .popover-arrow{bottom: 0.3rem;}\n/* /web/static/src/core/resizable_panel/resizable_panel.scss */\n .o_resizable_panel{max-width: 100vw; flex-grow: 0;}.o_resizable_panel_handle{cursor: col-resize; z-index: 10; width: 5px;}\n/* /web/static/src/core/select_menu/select_menu.scss */\n .o_select_menu .o_select_menu_toggler{display: grid; grid-template-columns: auto 25px;}.o_select_menu .o_select_menu_toggler.o_can_deselect{grid-template-columns: auto 25px 25px;}.o_select_menu .o_select_menu_toggler_slot{flex-grow: 2;}.o_select_menu .o_select_menu_toggler_caret{grid-column: 2;}.o_select_menu .o_can_deselect .o_select_menu_toggler_caret{grid-column: 3;}.o_select_menu .o_select_menu_toggler_clear{grid-column: 2;}.o_select_menu .o_select_menu_toggler_clear:hover i{color: red;}.o_select_menu .o_select_menu_menu{min-width: fit-content; max-height: 350px; border: 1px solid #71639e;}.o_select_menu .o_select_menu_menu .o_select_menu_sticky{background-color: #FFFFFF !important;}.o_select_menu .o_select_menu_menu .o_select_menu_sticky.o_select_menu_item:focus, .o_select_menu .o_select_menu_menu .o_select_menu_sticky.o_select_menu_item:hover{background: rgba(0, 0, 0, 0.15) !important;}.o_select_menu .o_select_menu_menu .o_select_menu_group{top: 40px;}.o_select_menu .o_select_menu_multi_select .o_select_active{background: #71639e; background: linear-gradient(to right, #dc3545 50%, #71639e 50%); background-size: 200% 100%; background-position: right bottom; transition: background 0.4s cubic-bezier(0.33, 1, 0.68, 1);}.o_select_menu .o_select_menu_multi_select .o_select_active:hover{background-position: left bottom;}.o_select_menu .o_tag{margin: 2px;}.dropup .o_select_menu_menu{box-shadow: 0 -7px 10px rgba(8, 8, 8, 0.319);}.dropdown .o_select_menu_menu{box-shadow: 0 7px 10px rgba(8, 8, 8, 0.319);}\n/* /web/static/src/core/signature/name_and_signature.scss */\n .o_web_sign_name_and_signature{position: relative;}.o_signature_stroke{position: absolute; border-top: #D1D0CE solid 2px; bottom: 16%; width: 72%; left: 14%;}\n/* /web/static/src/core/tags_list/tags_list.scss */\n .o_tag{font-size: var(--Tag-font-size, 0.765625rem); max-width: var(--Tag-max-width, 100%);}.o_tag.o_tag_color_0, .o_tag.o_tag_color_0::after{--background-color: RGBA(230.1375, 221.3625, 221.3625, var(--bg-opacity, 1)); background-color: var(--background-color) !important; --color: RGBA(60, 60, 60, var(--text-opacity, 1)); color: var(--color) !important;}.o_tag.o_tag_color_1, .o_tag.o_tag_color_1::after{--background-color: RGBA(255, 155.5, 155.5, var(--bg-opacity, 1)); background-color: var(--background-color) !important; --color: RGBA(67.15870044, 11.84129956, 11.84129956, var(--text-opacity, 1)); color: var(--color) !important;}.o_tag.o_tag_color_2, .o_tag.o_tag_color_2::after{--background-color: RGBA(247.0375, 198.06116071, 152.4625, var(--bg-opacity, 1)); background-color: var(--background-color) !important; --color: RGBA(52.9, 33.325, 15.1, var(--text-opacity, 1)); color: var(--color) !important;}.o_tag.o_tag_color_3, .o_tag.o_tag_color_3::after{--background-color: RGBA(252.88960843, 226.89175248, 135.61039157, var(--bg-opacity, 1)); background-color: var(--background-color) !important; --color: RGBA(47.45993976, 39.05405514, 9.54006024, var(--text-opacity, 1)); color: var(--color) !important;}.o_tag.o_tag_color_4, .o_tag.o_tag_color_4::after{--background-color: RGBA(187.45210396, 215.03675558, 248.04789604, var(--bg-opacity, 1)); background-color: var(--background-color) !important; --color: RGBA(25.3049505, 49.60939855, 78.6950495, var(--text-opacity, 1)); color: var(--color) !important;}.o_tag.o_tag_color_5, .o_tag.o_tag_color_5::after{--background-color: RGBA(216.79194664, 167.70805336, 203.91748283, var(--bg-opacity, 1)); background-color: var(--background-color) !important; --color: RGBA(28.91432806, 24.08567194, 27.64779531, var(--text-opacity, 1)); color: var(--color) !important;}.o_tag.o_tag_color_6, .o_tag.o_tag_color_6::after{--background-color: RGBA(247.84539474, 213.9484835, 199.65460526, var(--bg-opacity, 1)); background-color: var(--background-color) !important; --color: RGBA(85.32105263, 46.88635147, 30.67894737, var(--text-opacity, 1)); color: var(--color) !important;}.o_tag.o_tag_color_7, .o_tag.o_tag_color_7::after{--background-color: RGBA(136.6125, 224.8875, 218.94591346, var(--bg-opacity, 1)); background-color: var(--background-color) !important; --color: RGBA(10.58333333, 19.41666667, 18.82211538, var(--text-opacity, 1)); color: var(--color) !important;}.o_tag.o_tag_color_8, .o_tag.o_tag_color_8::after{--background-color: RGBA(150.60535714, 165.68382711, 248.89464286, var(--bg-opacity, 1)); background-color: var(--background-color) !important; --color: RGBA(13.95714286, 20.10665584, 54.04285714, var(--text-opacity, 1)); color: var(--color) !important;}.o_tag.o_tag_color_9, .o_tag.o_tag_color_9::after{--background-color: RGBA(254.94583333, 157.55416667, 203.95543194, var(--bg-opacity, 1)); background-color: var(--background-color) !important; --color: RGBA(68.805, 12.195, 39.16625654, var(--text-opacity, 1)); color: var(--color) !important;}.o_tag.o_tag_color_10, .o_tag.o_tag_color_10::after{--background-color: RGBA(182.62075688, 236.87924312, 189.81831118, var(--bg-opacity, 1)); background-color: var(--background-color) !important; --color: RGBA(30.82018349, 57.17981651, 34.3168695, var(--text-opacity, 1)); color: var(--color) !important;}.o_tag.o_tag_color_11, .o_tag.o_tag_color_11::after{--background-color: RGBA(230.11575613, 219.41069277, 252.08930723, var(--bg-opacity, 1)); background-color: var(--background-color) !important; --color: RGBA(56.75321978, 31.58433735, 108.41566265, var(--text-opacity, 1)); color: var(--color) !important;}\n/* /web/static/src/core/tooltip/tooltip.scss */\n .o-tooltip{font-family: var(--bs-font-sans-serif); font-style: normal; font-weight: 400; line-height: 1.5; text-align: left; text-align: start; text-decoration: none; text-shadow: none; text-transform: none; letter-spacing: normal; word-break: normal; word-spacing: normal; white-space: normal; line-break: auto; font-size: 0.765625rem;}.o-tooltip:has(.o-tooltip--technical){max-width: 400px;}.o-tooltip:has(.o-tooltip--technical) .o-tooltip--help{background-color: #0dcaf0; color: #000000;}.o-tooltip:has(.o-tooltip--technical) .o-tooltip--string, .o-tooltip:has(.o-tooltip--technical) .o-tooltip--help{max-width: MIN(200px, 100%);}.o-tooltip .o-tooltip--string, .o-tooltip .o-tooltip--technical--title{padding: 0.25rem 0; color: #FFFFFF; font-weight: 700;}.o-tooltip .o-tooltip--help, .o-tooltip .o-tooltip--technical{margin: 0.25rem 0.5rem 0.5rem;}.o-tooltip .o-tooltip--help{white-space: pre-line; padding: 0 0.5rem;}.o-tooltip .o-tooltip--technical{padding-left: 1.3em; font-family: SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace; font-size: 0.75rem; list-style-type: disc;}.o-tooltip .o-tooltip--technical .o-tooltip--technical--title{margin-right: 0.25rem;}.o-tooltip + .popover-arrow{--popover-arrow-color: #000000;}\n/* /web/static/src/core/tree_editor/tree_editor.scss */\n .o_tree_editor .o_tree_editor_node .o_tree_editor_node_control_panel > button{opacity: .2;}.o_tree_editor .o_tree_editor_node.o_hovered_button .o_tree_editor_node_control_panel > button{opacity: .5;}.o_tree_editor .o_tree_editor_node.o_hovered_button .o_tree_editor_node_control_panel > button:hover{opacity: 1;}\n/* /web/static/src/core/ui/block_ui.scss */\n .o_blockUI{cursor: wait; -webkit-backdrop-filter: blur(2px); backdrop-filter: blur(2px); background: rgba(0, 0, 0, 0.5); color: #fff; z-index: 1070 !important;}\n/* /web/static/src/core/utils/draggable_hook_builder.scss */\n @keyframes bounce{0%{transform: scale(1);}60%{transform: scale(0.95);}100%{transform: scale(1);}}.o_draggable{-webkit-touch-callout: none;}.o_dragged{z-index: 1000; pointer-events: none;}.o_touch_bounce{animation: bounce .4s forwards; user-select: none;}\n/* /web/static/src/core/utils/nested_sortable.scss */\n .o_nested_sortable_placeholder{background-clip: content-box; background-color: deepskyblue; height: 5px;}.o_nested_sortable_placeholder_realsize{outline: 1px dashed #6c757d; background-color: #f8f9fa;}\n/* /web_editor/static/src/components/history_dialog/history_dialog.scss */\n .html-history-dialog .history-container{margin-left: 240px;}.html-history-dialog .history-container > div{padding: 10px 12px; border: 1px solid #ddd; border-top: 0;}.html-history-dialog .history-container .nav{padding-left: 24px;}.html-history-dialog .history-container removed{display: inline; background-color: #f1afaf; text-decoration: line-through; opacity: 0.5;}.html-history-dialog .history-container added{display: inline; background-color: #c8f1af;}.html-history-dialog .history-container p{margin-bottom: 0.6rem;}.html-history-dialog .revision-list{margin: 38px 0 0 8px; overflow: auto; max-height: 100%; width: 220px; float: left;}.html-history-dialog .revision-list .btn{border-radius: 0; display: block; text-align: left; width: 220px; margin-bottom: 8px; position: relative;}.html-history-dialog .revision-list .btn:before{content: '\\f105'; font-family: 'FontAwesome'; position: absolute; right: 8px; top: 0; font-size: 34px;}\n/* /web_editor/static/src/components/media_dialog/media_dialog.scss */\n .modal:not(.o_legacy_dialog) .o_select_media_dialog .o_we_file_selector_container{padding-bottom: 52px;}.modal:not(.o_legacy_dialog) .o_select_media_dialog .o_we_file_selector_control_panel{top: -1rem; background-color: #FFFFFF;}.modal:not(.o_legacy_dialog) .o_select_media_dialog .o_we_existing_attachments{min-height: 128px;}.modal:not(.o_legacy_dialog) .o_select_media_dialog .o_we_existing_attachments .o_we_attachment_placeholder{flex-grow: 128; flex-basis: 128px;}.modal:not(.o_legacy_dialog) .o_select_media_dialog .o_we_existing_attachments .o_existing_attachment_cell.o_we_image{transition: opacity 0.5s ease 0.5s;}.modal:not(.o_legacy_dialog) .o_select_media_dialog .o_we_existing_attachments .o_existing_attachment_remove{border-radius: 0 0 0 4px;}.modal:not(.o_legacy_dialog) .o_select_media_dialog .o_we_existing_attachments .o_existing_attachment_remove:hover{color: #e6586c;}.modal:not(.o_legacy_dialog) .o_select_media_dialog .o_we_attachment_selected{box-shadow: 0 0 0 3px #71639e;}.modal:not(.o_legacy_dialog) .o_select_media_dialog .o_we_attachment_selected:not(.fa){border: 3px solid #71639e; box-shadow: none;}.modal:not(.o_legacy_dialog) .o_select_media_dialog .o_we_attachment_selected:not(.fa):before{content: "\n"; position: absolute; top: 5px; left: 5px; bottom: auto; right: auto; width: 19px; height: 19px; background-color: #71639e; font-family: 'FontAwesome'; color: white; border-radius: 50%; text-align: center; z-index: 1; box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);}.modal:not(.o_legacy_dialog) .o_select_media_dialog .o_we_load_more{top: calc(var(--footer-top) - 52px - 1rem); width: calc(var(--footer-width) - 2 * 1rem); height: 52px; scroll-margin: 1rem;}.modal:not(.o_legacy_dialog) .o_select_media_dialog .o_we_load_more.o_can_scroll{z-index: 2; pointer-events: none;}.modal:not(.o_legacy_dialog) .o_select_media_dialog .o_we_load_more.o_can_scroll > .o_scroll_attachments{width: 36px; height: 36px; pointer-events: all;}.modal:not(.o_legacy_dialog) .o_select_media_dialog .font-icons-icons > span{width: 50px;}.modal:not(.o_legacy_dialog) .o_select_media_dialog .o_video_dialog_form textarea{min-height: 95px;}.modal:not(.o_legacy_dialog) .o_select_media_dialog .o_video_preview{border-top: 1px solid black; border-bottom: 1px solid white; background-image: linear-gradient(-150deg, #2b2b33, #191922); color: white;}.modal:not(.o_legacy_dialog) .o_select_media_dialog .o_video_preview .media_iframe_video{width: 100%;}\n/* /web_editor/static/src/components/upload_progress_toast/upload_progress_toast.scss */\n .o_upload_progress_toast{font-size: 16px;}.o_upload_progress_toast .o_we_progressbar:last-child hr{display: none;}\n/* /web_editor/static/src/js/editor/odoo-editor/src/base_style.scss */\n li.oe-nested{display: block;}.o_table tr{border-color: #dee2e6;}.o_table tr td{padding: 0.5rem;}.o_text_columns{max-width: 100% !important; padding: 0 !important;}.o_text_columns > .row{margin: 0 !important;}.o_text_columns > .row > .col-xs-1:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xs-1:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xs-2:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xs-2:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xs-3:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xs-3:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xs-4:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xs-4:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xs-5:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xs-5:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xs-6:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xs-6:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xs-7:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xs-7:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xs-8:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xs-8:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xs-9:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xs-9:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xs-10:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xs-10:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xs-11:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xs-11:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xs-12:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xs-12:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-sm-1:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-sm-1:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-sm-2:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-sm-2:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-sm-3:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-sm-3:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-sm-4:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-sm-4:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-sm-5:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-sm-5:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-sm-6:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-sm-6:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-sm-7:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-sm-7:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-sm-8:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-sm-8:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-sm-9:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-sm-9:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-sm-10:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-sm-10:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-sm-11:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-sm-11:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-sm-12:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-sm-12:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-md-1:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-md-1:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-md-2:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-md-2:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-md-3:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-md-3:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-md-4:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-md-4:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-md-5:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-md-5:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-md-6:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-md-6:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-md-7:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-md-7:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-md-8:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-md-8:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-md-9:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-md-9:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-md-10:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-md-10:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-md-11:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-md-11:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-md-12:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-md-12:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-lg-1:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-lg-1:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-lg-2:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-lg-2:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-lg-3:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-lg-3:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-lg-4:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-lg-4:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-lg-5:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-lg-5:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-lg-6:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-lg-6:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-lg-7:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-lg-7:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-lg-8:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-lg-8:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-lg-9:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-lg-9:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-lg-10:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-lg-10:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-lg-11:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-lg-11:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-lg-12:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-lg-12:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xl-1:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xl-1:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xl-2:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xl-2:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xl-3:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xl-3:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xl-4:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xl-4:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xl-5:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xl-5:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xl-6:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xl-6:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xl-7:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xl-7:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xl-8:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xl-8:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xl-9:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xl-9:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xl-10:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xl-10:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xl-11:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xl-11:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xl-12:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xl-12:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xxl-1:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xxl-1:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xxl-2:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xxl-2:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xxl-3:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xxl-3:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xxl-4:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xxl-4:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xxl-5:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xxl-5:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xxl-6:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xxl-6:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xxl-7:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xxl-7:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xxl-8:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xxl-8:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xxl-9:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xxl-9:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xxl-10:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xxl-10:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xxl-11:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xxl-11:last-of-type{padding-right: 0;}.o_text_columns > .row > .col-xxl-12:first-of-type{padding-left: 0;}.o_text_columns > .row > .col-xxl-12:last-of-type{padding-right: 0;}.oe-tabs{display: inline-block; white-space: pre-wrap; max-width: 40px; width: 40px;}ol{list-style-type: decimal;}ul{list-style-type: disc;}ol ol{list-style-type: lower-alpha;}ul ul{list-style-type: circle;}ol ol ol{list-style-type: lower-roman;}ul ul ul{list-style-type: square;}ol ol ol ol{list-style-type: decimal;}ul ul ul ul{list-style-type: disc;}ol ol ol ol ol{list-style-type: lower-alpha;}ul ul ul ul ul{list-style-type: circle;}ol ol ol ol ol ol{list-style-type: lower-roman;}ul ul ul ul ul ul{list-style-type: square;}ol ol ol ol ol ol ol{list-style-type: decimal;}ul ul ul ul ul ul ul{list-style-type: disc;}ol ol ol ol ol ol ol ol{list-style-type: lower-alpha;}ul ul ul ul ul ul ul ul{list-style-type: circle;}ol ol ol ol ol ol ol ol ol{list-style-type: lower-roman;}ul ul ul ul ul ul ul ul ul{list-style-type: square;}ol ol ol ol ol ol ol ol ol ol{list-style-type: decimal;}ul ul ul ul ul ul ul ul ul ul{list-style-type: disc;}ol ol ol ol ol ol ol ol ol ol ol{list-style-type: lower-alpha;}ul ul ul ul ul ul ul ul ul ul ul{list-style-type: circle;}ol ol ol ol ol ol ol ol ol ol ol ol{list-style-type: lower-roman;}ul ul ul ul ul ul ul ul ul ul ul ul{list-style-type: square;}ol ol ol ol ol ol ol ol ol ol ol ol ol{list-style-type: decimal;}ul ul ul ul ul ul ul ul ul ul ul ul ul{list-style-type: disc;}ol ol ol ol ol ol ol ol ol ol ol ol ol ol{list-style-type: lower-alpha;}ul ul ul ul ul ul ul ul ul ul ul ul ul ul{list-style-type: circle;}ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol{list-style-type: lower-roman;}ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul{list-style-type: square;}ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol{list-style-type: decimal;}ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul{list-style-type: disc;}ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol{list-style-type: lower-alpha;}ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul{list-style-type: circle;}ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol{list-style-type: lower-roman;}ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul{list-style-type: square;}ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol{list-style-type: decimal;}ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul{list-style-type: disc;}ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol{list-style-type: lower-alpha;}ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul{list-style-type: circle;}ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol{list-style-type: lower-roman;}ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul{list-style-type: square;}ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol{list-style-type: decimal;}ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul{list-style-type: disc;}ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol{list-style-type: lower-alpha;}ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul{list-style-type: circle;}ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol{list-style-type: lower-roman;}ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul{list-style-type: square;}ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol{list-style-type: decimal;}ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul{list-style-type: disc;}ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol ol{list-style-type: lower-alpha;}ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul ul{list-style-type: circle;}\n/* /web_editor/static/src/scss/web_editor.common.scss */\n :root{--100: #F8F9FA; --200: #E9ECEF; --300: #DEE2E6; --400: #CED4DA; --500: #ADB5BD; --600: #6C757D; --700: #495057; --800: #343A40; --900: #212529; --white-85: rgba(255, 255, 255, 0.85); --white-75: rgba(255, 255, 255, 0.75); --white-50: rgba(255, 255, 255, 0.5); --white-25: rgba(255, 255, 255, 0.25); --black-75: rgba(0, 0, 0, 0.75); --black-50: rgba(0, 0, 0, 0.5); --black-25: rgba(0, 0, 0, 0.25); --black-15: rgba(0, 0, 0, 0.15); --black: #000000; --white: #FFFFFF; --o-cc1-text: #000000; --o-cc1-headings: #000000; --o-cc1-h2: #000000; --o-cc1-h3: #000000; --o-cc1-h4: #000000; --o-cc1-h5: #000000; --o-cc1-h6: #000000; --o-cc1-link: #65435c; --o-cc1-btn-primary: #714B67; --o-cc1-btn-primary-text: #FFFFFF; --o-cc1-btn-primary-border: #714B67; --o-cc1-btn-secondary: #8595A2; --o-cc1-btn-secondary-text: #FFFFFF; --o-cc1-btn-secondary-border: #8595A2; --o-cc2-text: #000000; --o-cc2-h2: #111827; --o-cc2-h3: #111827; --o-cc2-h4: #111827; --o-cc2-h5: #111827; --o-cc2-h6: #111827; --o-cc2-link: #55394e; --o-cc2-btn-primary: #714B67; --o-cc2-btn-primary-text: #FFFFFF; --o-cc2-btn-primary-border: #714B67; --o-cc2-btn-secondary: #8595A2; --o-cc2-btn-secondary-text: #FFFFFF; --o-cc2-btn-secondary-border: #8595A2; --o-cc3-text: #FFFFFF; --o-cc3-headings: #FFFFFF; --o-cc3-h2: #FFFFFF; --o-cc3-h3: #FFFFFF; --o-cc3-h4: #FFFFFF; --o-cc3-h5: #FFFFFF; --o-cc3-h6: #FFFFFF; --o-cc3-link: #241821; --o-cc3-btn-primary: #714B67; --o-cc3-btn-primary-text: #FFFFFF; --o-cc3-btn-primary-border: #714B67; --o-cc3-btn-secondary-text: #000000; --o-cc3-btn-secondary-border: #F3F2F2; --o-cc4-text: #FFFFFF; --o-cc4-headings: #FFFFFF; --o-cc4-h2: #FFFFFF; --o-cc4-h3: #FFFFFF; --o-cc4-h4: #FFFFFF; --o-cc4-h5: #FFFFFF; --o-cc4-h6: #FFFFFF; --o-cc4-link: black; --o-cc4-btn-primary-text: #FFFFFF; --o-cc4-btn-primary-border: #111827; --o-cc4-btn-secondary-text: #000000; --o-cc4-btn-secondary-border: #F3F2F2; --o-cc5-text: #FFFFFF; --o-cc5-h2: #FFFFFF; --o-cc5-h3: #FFFFFF; --o-cc5-h4: #FFFFFF; --o-cc5-h5: #FFFFFF; --o-cc5-h6: #FFFFFF; --o-cc5-link: #b18aa7; --o-cc5-btn-primary: #714B67; --o-cc5-btn-primary-text: #FFFFFF; --o-cc5-btn-primary-border: #714B67; --o-cc5-btn-secondary-text: #000000; --o-cc5-btn-secondary-border: #F3F2F2; --o-grid-gutter-width: 1.5rem; --o-md-container-max-width: 720px; --o-we-content-to-translate-color: rgba(255, 255, 90, 0.5); --o-we-translated-content-color: rgba(120, 215, 110, 0.5); --o-system-fonts: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Ubuntu, "Noto Sans", Arial, sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol", "Noto Color Emoji"; --display-1-font-size: 5rem; --display-2-font-size: 4.5rem; --display-3-font-size: 4rem; --display-4-font-size: 3.5rem; --h1-font-size: 2.1875rem; --h2-font-size: 1.75rem; --h3-font-size: 1.53125rem; --h4-font-size: 1.3125rem; --h5-font-size: 1.09375rem; --h6-font-size: 0.875rem; --font-size-base: 0.875rem; --small-font-size: 0.875em;}html, body{position: relative; width: 100%; height: 100%;}*[contenteditable=true]{outline: none;}[contenteditable]{overflow-wrap: unset !important;}.css_non_editable_mode_hidden{display: none !important;}.editor_enable .css_editable_mode_hidden{display: none !important;}.note-toolbar{margin-left: 0 !important;}.note-popover .popover > .arrow{display: none;}.note-popover .popover .dropdown-menu .dropdown-item > i, .note-editor .dropdown-menu .dropdown-item > i{visibility: hidden;}.note-popover .popover .dropdown-menu .dropdown-item.checked > i, .note-editor .dropdown-menu .dropdown-item.checked > i{visibility: visible;}#wrapwrap table.table.table-bordered, .o_editable table.table.table-bordered{table-layout: fixed;}#wrapwrap table.table.table-bordered td, .o_editable table.table.table-bordered td{min-width: 20px;}@media (max-width: 767.98px){#wrapwrap .table-responsive > table.table, .o_editable .table-responsive > table.table{table-layout: auto;}}ul.o_checklist{list-style: none;}ul.o_checklist > li{list-style: none; position: relative; margin-left: 20px; margin-right: 20px;}ul.o_checklist > li:not(.oe-nested)::before{content: ''; position: absolute; left: -20px; display: block; height: 13px; width: 13px; top: 4px; border: 1px solid; text-align: center; cursor: pointer;}ul.o_checklist > li.o_checked{text-decoration: line-through;}ul.o_checklist > li.o_checked::before{content: "\n"; display: -webkit-box; display: -webkit-flex; display: flex; align-items: center; justify-content: center; padding-left: 1px ; padding-top: 1px;}ul.o_checklist[dir="rtl"] > li:not(.oe-nested)::before{left: auto; right: -20px; text-align: right;}ol > li.o_indent, ul > li.o_indent{margin-left: 0; list-style: none;}ol > li.o_indent::before, ul > li.o_indent::before{content: none;}.o_stars .fa.fa-star{color: gold;}img.o_we_custom_image{display: inline-block;}img.shadow{box-shadow: 0px 3px 8px rgba(0, 0, 0, 0.2);}img.padding-small, .img.padding-small, span.fa.padding-small, iframe.padding-small{padding: 4px;}img.padding-medium, .img.padding-medium, span.fa.padding-medium, iframe.padding-medium{padding: 8px;}img.padding-large, .img.padding-large, span.fa.padding-large, iframe.padding-large{padding: 16px;}img.padding-xl, .img.padding-xl, span.fa.padding-xl, iframe.padding-xl{padding: 32px;}img.ms-auto, img.mx-auto{display: block;}.fa-6x{font-size: 6em;}.fa-7x{font-size: 7em;}.fa-8x{font-size: 8em;}.fa-9x{font-size: 9em;}.fa-10x{font-size: 10em;}.fa.mx-auto{display: block; text-align: center;}.fa.card-img, .fa.card-img-top, .fa.card-img-bottom{width: auto;}.display-1-fs{font-size: 5rem;}.display-2-fs{font-size: 4.5rem;}.display-3-fs{font-size: 4rem;}.display-4-fs{font-size: 3.5rem;}.h1-fs{font-size: 2.1875rem;}.h2-fs{font-size: 1.75rem;}.h3-fs{font-size: 1.53125rem;}.h4-fs{font-size: 1.3125rem;}.h5-fs{font-size: 1.09375rem;}.h6-fs{font-size: 0.875rem;}.base-fs{font-size: 0.875rem;}div.media_iframe_video{margin: 0 auto; text-align: center; position: relative; overflow: hidden; min-width: 100px;}div.media_iframe_video iframe{width: 100%; height: 100%; position: absolute; top: 0; left: auto; bottom: auto; right: auto; margin: 0 auto; margin-left: -50%;}div.media_iframe_video.padding-small iframe{padding: 4px;}div.media_iframe_video.padding-medium iframe{padding: 8px;}div.media_iframe_video.padding-large iframe{padding: 16px;}div.media_iframe_video.padding-xl iframe{padding: 32px;}div.media_iframe_video .media_iframe_video_size{padding-bottom: 66.5%; position: relative; width: 100%; height: 0;}div.media_iframe_video .css_editable_mode_display{position: absolute; top: 0; left: 0; bottom: 0; right: 0; width: 100%; height: 100%; display: none; z-index: 2;}address .fa.fa-mobile-phone{margin: 0 3px 0 2px;}address .fa.fa-file-text-o{margin-right: 1px;}span[data-oe-type="monetary"]{white-space: nowrap;}ul.oe_menu_editor .oe_menu_placeholder{outline: 1px dashed #4183C4;}ul.oe_menu_editor ul{list-style: none;}ul.oe_menu_editor li div{cursor: url(/web/static/img/openhand.cur), grab;}ul.oe_menu_editor li div :active{cursor: grabbing;}.mt0{margin-top: 0px !important;}.mb0{margin-bottom: 0px !important;}.pt0{padding-top: 0px !important;}.pb0{padding-bottom: 0px !important;}.mt8{margin-top: 8px !important;}.mb8{margin-bottom: 8px !important;}.pt8{padding-top: 8px !important;}.pb8{padding-bottom: 8px !important;}.mt16{margin-top: 16px !important;}.mb16{margin-bottom: 16px !important;}.pt16{padding-top: 16px !important;}.pb16{padding-bottom: 16px !important;}.mt24{margin-top: 24px !important;}.mb24{margin-bottom: 24px !important;}.pt24{padding-top: 24px !important;}.pb24{padding-bottom: 24px !important;}.mt32{margin-top: 32px !important;}.mb32{margin-bottom: 32px !important;}.pt32{padding-top: 32px !important;}.pb32{padding-bottom: 32px !important;}.mt40{margin-top: 40px !important;}.mb40{margin-bottom: 40px !important;}.pt40{padding-top: 40px !important;}.pb40{padding-bottom: 40px !important;}.mt48{margin-top: 48px !important;}.mb48{margin-bottom: 48px !important;}.pt48{padding-top: 48px !important;}.pb48{padding-bottom: 48px !important;}.mt56{margin-top: 56px !important;}.mb56{margin-bottom: 56px !important;}.pt56{padding-top: 56px !important;}.pb56{padding-bottom: 56px !important;}.mt64{margin-top: 64px !important;}.mb64{margin-bottom: 64px !important;}.pt64{padding-top: 64px !important;}.pb64{padding-bottom: 64px !important;}.mt72{margin-top: 72px !important;}.mb72{margin-bottom: 72px !important;}.pt72{padding-top: 72px !important;}.pb72{padding-bottom: 72px !important;}.mt80{margin-top: 80px !important;}.mb80{margin-bottom: 80px !important;}.pt80{padding-top: 80px !important;}.pb80{padding-bottom: 80px !important;}.mt88{margin-top: 88px !important;}.mb88{margin-bottom: 88px !important;}.pt88{padding-top: 88px !important;}.pb88{padding-bottom: 88px !important;}.mt96{margin-top: 96px !important;}.mb96{margin-bottom: 96px !important;}.pt96{padding-top: 96px !important;}.pb96{padding-bottom: 96px !important;}.mt104{margin-top: 104px !important;}.mb104{margin-bottom: 104px !important;}.pt104{padding-top: 104px !important;}.pb104{padding-bottom: 104px !important;}.mt112{margin-top: 112px !important;}.mb112{margin-bottom: 112px !important;}.pt112{padding-top: 112px !important;}.pb112{padding-bottom: 112px !important;}.mt120{margin-top: 120px !important;}.mb120{margin-bottom: 120px !important;}.pt120{padding-top: 120px !important;}.pb120{padding-bottom: 120px !important;}.mt128{margin-top: 128px !important;}.mb128{margin-bottom: 128px !important;}.pt128{padding-top: 128px !important;}.pb128{padding-bottom: 128px !important;}.mt136{margin-top: 136px !important;}.mb136{margin-bottom: 136px !important;}.pt136{padding-top: 136px !important;}.pb136{padding-bottom: 136px !important;}.mt144{margin-top: 144px !important;}.mb144{margin-bottom: 144px !important;}.pt144{padding-top: 144px !important;}.pb144{padding-bottom: 144px !important;}.mt152{margin-top: 152px !important;}.mb152{margin-bottom: 152px !important;}.pt152{padding-top: 152px !important;}.pb152{padding-bottom: 152px !important;}.mt160{margin-top: 160px !important;}.mb160{margin-bottom: 160px !important;}.pt160{padding-top: 160px !important;}.pb160{padding-bottom: 160px !important;}.mt168{margin-top: 168px !important;}.mb168{margin-bottom: 168px !important;}.pt168{padding-top: 168px !important;}.pb168{padding-bottom: 168px !important;}.mt176{margin-top: 176px !important;}.mb176{margin-bottom: 176px !important;}.pt176{padding-top: 176px !important;}.pb176{padding-bottom: 176px !important;}.mt184{margin-top: 184px !important;}.mb184{margin-bottom: 184px !important;}.pt184{padding-top: 184px !important;}.pb184{padding-bottom: 184px !important;}.mt192{margin-top: 192px !important;}.mb192{margin-bottom: 192px !important;}.pt192{padding-top: 192px !important;}.pb192{padding-bottom: 192px !important;}.mt200{margin-top: 200px !important;}.mb200{margin-bottom: 200px !important;}.pt200{padding-top: 200px !important;}.pb200{padding-bottom: 200px !important;}.mt208{margin-top: 208px !important;}.mb208{margin-bottom: 208px !important;}.pt208{padding-top: 208px !important;}.pb208{padding-bottom: 208px !important;}.mt216{margin-top: 216px !important;}.mb216{margin-bottom: 216px !important;}.pt216{padding-top: 216px !important;}.pb216{padding-bottom: 216px !important;}.mt224{margin-top: 224px !important;}.mb224{margin-bottom: 224px !important;}.pt224{padding-top: 224px !important;}.pb224{padding-bottom: 224px !important;}.mt232{margin-top: 232px !important;}.mb232{margin-bottom: 232px !important;}.pt232{padding-top: 232px !important;}.pb232{padding-bottom: 232px !important;}.mt240{margin-top: 240px !important;}.mb240{margin-bottom: 240px !important;}.pt240{padding-top: 240px !important;}.pb240{padding-bottom: 240px !important;}.mt248{margin-top: 248px !important;}.mb248{margin-bottom: 248px !important;}.pt248{padding-top: 248px !important;}.pb248{padding-bottom: 248px !important;}.mt256{margin-top: 256px !important;}.mb256{margin-bottom: 256px !important;}.pt256{padding-top: 256px !important;}.pb256{padding-bottom: 256px !important;}.mt4{margin-top: 4px !important;}.mb4{margin-bottom: 4px !important;}.pt4{padding-top: 4px !important;}.pb4{padding-bottom: 4px !important;}.mt92{margin-top: 92px !important;}.mb92{margin-bottom: 92px !important;}.ml0{margin-left: 0px !important;}.mr0{margin-right: 0px !important;}.ml4{margin-left: 4px !important;}.mr4{margin-right: 4px !important;}.ml8{margin-left: 8px !important;}.mr8{margin-right: 8px !important;}.ml16{margin-left: 16px !important;}.mr16{margin-right: 16px !important;}.ml32{margin-left: 32px !important;}.mr32{margin-right: 32px !important;}.ml64{margin-left: 64px !important;}.mr64{margin-right: 64px !important;}a.o_underline{text-decoration: underline;}a.o_underline:hover{text-decoration: underline;}.o_nocontent_help{pointer-events: auto; max-width: 650px; margin: auto; padding: 15px; z-index: 1000; text-align: center; color: #212529; font-size: 115%;}.o_nocontent_help > p:first-of-type{margin-top: 0; font-weight: bold; font-size: 125%;}.o_nocontent_help a{cursor: pointer;}.o_we_search_prompt{position: relative; min-height: 250px; width: 100%; display: -webkit-box; display: -webkit-flex; display: flex; align-items: center; -webkit-box-pack: start; justify-content: flex-start;}.o_we_search_prompt > h2, .o_we_search_prompt > .h2{max-width: 500px; text-align: center; margin-left: 150px;}.o_we_search_prompt::before{transform: scale(-1, 1); content: ""; position: absolute; top: 0; left: 50px; bottom: auto; right: auto; width: 100px; height: 150px; opacity: .5; filter: var(--WebEditor__SearchPromptArrow-filter, invert(0)); background-image: url("/web_editor/static/src/img/curved_arrow.svg"); background-size: 100%; background-repeat: no-repeat;}@media (max-width: 767.98px){odoo-wysiwyg-container .panel-heading.note-toolbar{overflow-x: auto;}odoo-wysiwyg-container .btn-group{position: static;}.o_technical_modal.o_web_editor_dialog{z-index: 2001;}.o_technical_modal.o_web_editor_dialog > .o_select_media_dialog{max-width: inherit !important; z-index: 2001;}.o_technical_modal.o_web_editor_dialog > .o_select_media_dialog .modal-dialog, .o_technical_modal.o_web_editor_dialog > .o_select_media_dialog .model-content{height: 100%;}.o_technical_modal.o_web_editor_dialog > .o_select_media_dialog .modal-body .nav .nav-item.search{width: 100%;}.o_technical_modal.o_web_editor_dialog > .o_select_media_dialog .modal-body .nav .nav-item.search .btn-group{display: -webkit-box; display: -webkit-flex; display: flex; justify-content: space-around; padding: 5px;}.o_technical_modal.o_web_editor_dialog > .o_select_media_dialog .modal-body .font-icons-icons{text-align: center;}.o_technical_modal.o_web_editor_dialog > .o_select_media_dialog .modal-body .form-control.o_we_search{height: inherit;}.o_technical_modal.o_web_editor_dialog > .o_select_media_dialog .modal-body .o_we_existing_attachments > .row{-webkit-box-orient: vertical; -webkit-box-direction: normal; -webkit-flex-direction: column; flex-direction: column;}.o_technical_modal.o_web_editor_dialog > .o_select_media_dialog .modal-body .o_we_existing_attachments > .row > .o_existing_attachment_cell{flex: initial; max-width: 100%;}.o_technical_modal.o_web_editor_dialog > .o_select_media_dialog .modal-body .o_we_existing_attachments > .row > .o_existing_attachment_cell > .o_existing_attachment_remove{opacity: inherit; top: 10px;}}blockquote{padding: 0.5rem 1rem; border-left: 5px solid; border-color: #DEE2E6; font-style: italic;}.bg-o-color-1{background-color: #714B67 !important; color: #FFFFFF;}.bg-o-color-1 .text-muted, .o_colored_level .bg-o-color-1 .text-muted{color: rgba(255, 255, 255, 0.7) !important;}a.bg-o-color-1:hover, a.bg-o-color-1:focus, button.bg-o-color-1:hover, button.bg-o-color-1:focus{background-color: #52374b !important; color: #FFFFFF;}.text-o-color-1{color: #714B67 !important;}a.text-o-color-1:hover, a.text-o-color-1:focus{color: #34222f !important;}.bg-o-color-2{background-color: #8595A2 !important; color: #FFFFFF;}.bg-o-color-2 .text-muted, .o_colored_level .bg-o-color-2 .text-muted{color: rgba(255, 255, 255, 0.7) !important;}a.bg-o-color-2:hover, a.bg-o-color-2:focus, button.bg-o-color-2:hover, button.bg-o-color-2:focus{background-color: #6a7c8a !important; color: #FFFFFF;}.text-o-color-2{color: #8595A2 !important;}a.text-o-color-2:hover, a.text-o-color-2:focus{color: #53626e !important;}.bg-o-color-3{background-color: #F3F2F2 !important; color: #000000;}.bg-o-color-3 .text-muted, .o_colored_level .bg-o-color-3 .text-muted{color: rgba(0, 0, 0, 0.7) !important;}a.bg-o-color-3:hover, a.bg-o-color-3:focus, button.bg-o-color-3:hover, button.bg-o-color-3:focus{background-color: #dbd7d7 !important; color: #000000;}.text-o-color-3{color: #F3F2F2 !important;}a.text-o-color-3:hover, a.text-o-color-3:focus{color: #c2bdbd !important;}.bg-o-color-4{background-color: #FFFFFF !important; color: #000000;}.bg-o-color-4 .text-muted, .o_colored_level .bg-o-color-4 .text-muted{color: rgba(0, 0, 0, 0.7) !important;}a.bg-o-color-4:hover, a.bg-o-color-4:focus, button.bg-o-color-4:hover, button.bg-o-color-4:focus{background-color: #e6e6e6 !important; color: #000000;}.text-o-color-4{color: #FFFFFF !important;}a.text-o-color-4:hover, a.text-o-color-4:focus{color: #cccccc !important;}.bg-o-color-5{background-color: #111827 !important; color: #FFFFFF;}.bg-o-color-5 .text-muted, .o_colored_level .bg-o-color-5 .text-muted{color: rgba(255, 255, 255, 0.7) !important;}a.bg-o-color-5:hover, a.bg-o-color-5:focus, button.bg-o-color-5:hover, button.bg-o-color-5:focus{background-color: #020203 !important; color: #FFFFFF;}.text-o-color-5{color: #111827 !important;}a.text-o-color-5:hover, a.text-o-color-5:focus{color: black !important;}.o_cc .dropdown-menu .dropdown-item, .o_cc .dropdown-menu .dropdown-item h6, .o_cc .dropdown-menu .dropdown-item .h6, .o_colored_level .o_cc .dropdown-menu .dropdown-item, .o_colored_level .o_cc .dropdown-menu .dropdown-item h6{color: #212529 !important;}.o_cc .dropdown-menu .dropdown-item:hover, .o_cc .dropdown-menu .dropdown-item:focus, .o_cc .dropdown-menu .dropdown-item h6:hover, .o_cc .dropdown-menu .dropdown-item .h6:hover, .o_cc .dropdown-menu .dropdown-item h6:focus, .o_cc .dropdown-menu .dropdown-item .h6:focus, .o_colored_level .o_cc .dropdown-menu .dropdown-item:hover, .o_colored_level .o_cc .dropdown-menu .dropdown-item:focus, .o_colored_level .o_cc .dropdown-menu .dropdown-item h6:hover, .o_colored_level .o_cc .dropdown-menu .dropdown-item h6:focus{color: #1e2125 !important;}.o_cc .dropdown-menu .dropdown-item.disabled, .o_cc .dropdown-menu .dropdown-item.disabled h6, .o_cc .dropdown-menu .dropdown-item.disabled .h6, .o_cc .dropdown-menu .dropdown-item:disabled, .o_cc .dropdown-menu .dropdown-item.o_wysiwyg_loader, .o_cc .dropdown-menu .dropdown-item:disabled h6, .o_cc .dropdown-menu .dropdown-item.o_wysiwyg_loader h6, .o_cc .dropdown-menu .dropdown-item:disabled .h6, .o_cc .dropdown-menu .dropdown-item.o_wysiwyg_loader .h6, .o_colored_level .o_cc .dropdown-menu .dropdown-item.disabled, .o_colored_level .o_cc .dropdown-menu .dropdown-item.disabled h6, .o_colored_level .o_cc .dropdown-menu .dropdown-item:disabled, .o_colored_level .o_cc .dropdown-menu .dropdown-item:disabled h6{color: #ADB5BD !important;}.o_cc .dropdown-menu .dropdown-item .btn-link, .o_colored_level .o_cc .dropdown-menu .dropdown-item .btn-link{color: #714B67;}.o_cc .dropdown-menu .dropdown-item .btn-link:hover, .o_colored_level .o_cc .dropdown-menu .dropdown-item .btn-link:hover{color: #5a3c52;}.o_cc .dropdown-menu .dropdown-item .btn-link:disabled, .o_cc .dropdown-menu .dropdown-item .btn-link.o_wysiwyg_loader, .o_colored_level .o_cc .dropdown-menu .dropdown-item .btn-link:disabled{color: #6C757D;}.o_cc .dropdown-menu .dropdown-item-text .text-muted, .o_colored_level .o_cc .dropdown-menu .dropdown-item-text .text-muted{color: #6C757D !important;}.o_cc .dropdown-menu .dropdown-item-text .text-muted a, .o_colored_level .o_cc .dropdown-menu .dropdown-item-text .text-muted a{color: #714B67;}.o_cc .dropdown-menu .dropdown-item-text .text-muted a:hover, .o_colored_level .o_cc .dropdown-menu .dropdown-item-text .text-muted a:hover{color: #5a3c52;}.o_cc1{background-color: #FFFFFF; color: #000000; --o-cc-bg: #FFFFFF;}.o_cc1 .text-muted, .o_colored_level .o_cc1 .text-muted{color: rgba(0, 0, 0, 0.7) !important;}.o_cc1 a:not(.btn), .o_cc1 .btn-link, .o_colored_level .o_cc1 a:not(.btn), .o_colored_level .o_cc1 .btn-link{color: #65435c;}.o_cc1 a:not(.btn):hover, .o_cc1 .btn-link:hover, .o_colored_level .o_cc1 a:not(.btn):hover, .o_colored_level .o_cc1 .btn-link:hover{color: #432c3d;}.o_cc1 .btn-fill-primary, .o_cc1 .btn-primary, .o_colored_level .o_cc1 .btn-fill-primary{color: #FFFFFF; background-color: #714B67; border-color: #714B67;}.o_cc1 .btn-fill-primary:hover, .o_cc1 .btn-primary:hover, .o_colored_level .o_cc1 .btn-fill-primary:hover{color: #FFFFFF; background-color: #604058; border-color: #5a3c52;}.btn-check:focus + .o_cc1 .btn-fill-primary, .btn-check:focus + .o_cc1 .btn-primary, .o_cc1 .btn-fill-primary:focus, .o_cc1 .btn-primary:focus, .btn-check:focus + .o_colored_level .o_cc1 .btn-fill-primary, .o_colored_level .o_cc1 .btn-fill-primary:focus{color: #FFFFFF; background-color: #604058; border-color: #5a3c52; box-shadow: 0 0 0 0.25rem rgba(134, 102, 126, 0.5);}.btn-check:checked + .o_cc1 .btn-fill-primary, .btn-check:checked + .o_cc1 .btn-primary, .btn-check:active + .o_cc1 .btn-fill-primary, .btn-check:active + .o_cc1 .btn-primary, .o_cc1 .btn-fill-primary:active, .o_cc1 .btn-primary:active, .o_cc1 .btn-fill-primary.active, .o_cc1 .active.btn-primary, .show > .o_cc1 .btn-fill-primary.dropdown-toggle, .show > .o_cc1 .dropdown-toggle.btn-primary, .btn-check:checked + .o_colored_level .o_cc1 .btn-fill-primary, .btn-check:active + .o_colored_level .o_cc1 .btn-fill-primary, .o_colored_level .o_cc1 .btn-fill-primary:active, .o_colored_level .o_cc1 .btn-fill-primary.active, .show > .o_colored_level .o_cc1 .btn-fill-primary.dropdown-toggle{color: #FFFFFF; background-color: #5a3c52; border-color: #55384d;}.btn-check:checked + .o_cc1 .btn-fill-primary:focus, .btn-check:checked + .o_cc1 .btn-primary:focus, .btn-check:active + .o_cc1 .btn-fill-primary:focus, .btn-check:active + .o_cc1 .btn-primary:focus, .o_cc1 .btn-fill-primary:active:focus, .o_cc1 .btn-primary:active:focus, .o_cc1 .btn-fill-primary.active:focus, .o_cc1 .active.btn-primary:focus, .show > .o_cc1 .btn-fill-primary.dropdown-toggle:focus, .show > .o_cc1 .dropdown-toggle.btn-primary:focus, .btn-check:checked + .o_colored_level .o_cc1 .btn-fill-primary:focus, .btn-check:active + .o_colored_level .o_cc1 .btn-fill-primary:focus, .o_colored_level .o_cc1 .btn-fill-primary:active:focus, .o_colored_level .o_cc1 .btn-fill-primary.active:focus, .show > .o_colored_level .o_cc1 .btn-fill-primary.dropdown-toggle:focus{box-shadow: 0 0 0 0.25rem rgba(134, 102, 126, 0.5);}.o_cc1 .btn-fill-primary:disabled, .o_cc1 .btn-fill-primary.o_wysiwyg_loader, .o_cc1 .btn-primary:disabled, .o_cc1 .btn-primary.o_wysiwyg_loader, .o_cc1 .btn-fill-primary.disabled, .o_cc1 .disabled.btn-primary, .o_colored_level .o_cc1 .btn-fill-primary:disabled, .o_colored_level .o_cc1 .btn-fill-primary.disabled{color: #FFFFFF; background-color: #714B67; border-color: #714B67;}.o_cc1 .btn-outline-primary, .o_colored_level .o_cc1 .btn-outline-primary{color: #714B67; border-color: #714B67;}.o_cc1 .btn-outline-primary:hover, .o_colored_level .o_cc1 .btn-outline-primary:hover{color: #FFFFFF; background-color: #714B67; border-color: #714B67;}.btn-check:focus + .o_cc1 .btn-outline-primary, .o_cc1 .btn-outline-primary:focus, .btn-check:focus + .o_colored_level .o_cc1 .btn-outline-primary, .o_colored_level .o_cc1 .btn-outline-primary:focus{box-shadow: 0 0 0 0.25rem rgba(113, 75, 103, 0.5);}.btn-check:checked + .o_cc1 .btn-outline-primary, .btn-check:active + .o_cc1 .btn-outline-primary, .o_cc1 .btn-outline-primary:active, .o_cc1 .btn-outline-primary.active, .o_cc1 .btn-outline-primary.dropdown-toggle.show, .btn-check:checked + .o_colored_level .o_cc1 .btn-outline-primary, .btn-check:active + .o_colored_level .o_cc1 .btn-outline-primary, .o_colored_level .o_cc1 .btn-outline-primary:active, .o_colored_level .o_cc1 .btn-outline-primary.active, .o_colored_level .o_cc1 .btn-outline-primary.dropdown-toggle.show{color: #FFFFFF; background-color: #714B67; border-color: #714B67;}.btn-check:checked + .o_cc1 .btn-outline-primary:focus, .btn-check:active + .o_cc1 .btn-outline-primary:focus, .o_cc1 .btn-outline-primary:active:focus, .o_cc1 .btn-outline-primary.active:focus, .o_cc1 .btn-outline-primary.dropdown-toggle.show:focus, .btn-check:checked + .o_colored_level .o_cc1 .btn-outline-primary:focus, .btn-check:active + .o_colored_level .o_cc1 .btn-outline-primary:focus, .o_colored_level .o_cc1 .btn-outline-primary:active:focus, .o_colored_level .o_cc1 .btn-outline-primary.active:focus, .o_colored_level .o_cc1 .btn-outline-primary.dropdown-toggle.show:focus{box-shadow: 0 0 0 0.25rem rgba(113, 75, 103, 0.5);}.o_cc1 .btn-outline-primary:disabled, .o_cc1 .btn-outline-primary.o_wysiwyg_loader, .o_cc1 .btn-outline-primary.disabled, .o_colored_level .o_cc1 .btn-outline-primary:disabled, .o_colored_level .o_cc1 .btn-outline-primary.disabled{color: #714B67; background-color: transparent;}.o_cc1 .btn-fill-secondary, .o_cc1 .btn-secondary, .o_colored_level .o_cc1 .btn-fill-secondary{color: #FFFFFF; background-color: #8595A2; border-color: #8595A2;}.o_cc1 .btn-fill-secondary:hover, .o_cc1 .btn-secondary:hover, .o_colored_level .o_cc1 .btn-fill-secondary:hover{color: #FFFFFF; background-color: #717f8a; border-color: #6a7782;}.btn-check:focus + .o_cc1 .btn-fill-secondary, .btn-check:focus + .o_cc1 .btn-secondary, .o_cc1 .btn-fill-secondary:focus, .o_cc1 .btn-secondary:focus, .btn-check:focus + .o_colored_level .o_cc1 .btn-fill-secondary, .o_colored_level .o_cc1 .btn-fill-secondary:focus{color: #FFFFFF; background-color: #717f8a; border-color: #6a7782; box-shadow: 0 0 0 0.25rem rgba(151, 165, 176, 0.5);}.btn-check:checked + .o_cc1 .btn-fill-secondary, .btn-check:checked + .o_cc1 .btn-secondary, .btn-check:active + .o_cc1 .btn-fill-secondary, .btn-check:active + .o_cc1 .btn-secondary, .o_cc1 .btn-fill-secondary:active, .o_cc1 .btn-secondary:active, .o_cc1 .btn-fill-secondary.active, .o_cc1 .active.btn-secondary, .show > .o_cc1 .btn-fill-secondary.dropdown-toggle, .show > .o_cc1 .dropdown-toggle.btn-secondary, .btn-check:checked + .o_colored_level .o_cc1 .btn-fill-secondary, .btn-check:active + .o_colored_level .o_cc1 .btn-fill-secondary, .o_colored_level .o_cc1 .btn-fill-secondary:active, .o_colored_level .o_cc1 .btn-fill-secondary.active, .show > .o_colored_level .o_cc1 .btn-fill-secondary.dropdown-toggle{color: #FFFFFF; background-color: #6a7782; border-color: #64707a;}.btn-check:checked + .o_cc1 .btn-fill-secondary:focus, .btn-check:checked + .o_cc1 .btn-secondary:focus, .btn-check:active + .o_cc1 .btn-fill-secondary:focus, .btn-check:active + .o_cc1 .btn-secondary:focus, .o_cc1 .btn-fill-secondary:active:focus, .o_cc1 .btn-secondary:active:focus, .o_cc1 .btn-fill-secondary.active:focus, .o_cc1 .active.btn-secondary:focus, .show > .o_cc1 .btn-fill-secondary.dropdown-toggle:focus, .show > .o_cc1 .dropdown-toggle.btn-secondary:focus, .btn-check:checked + .o_colored_level .o_cc1 .btn-fill-secondary:focus, .btn-check:active + .o_colored_level .o_cc1 .btn-fill-secondary:focus, .o_colored_level .o_cc1 .btn-fill-secondary:active:focus, .o_colored_level .o_cc1 .btn-fill-secondary.active:focus, .show > .o_colored_level .o_cc1 .btn-fill-secondary.dropdown-toggle:focus{box-shadow: 0 0 0 0.25rem rgba(151, 165, 176, 0.5);}.o_cc1 .btn-fill-secondary:disabled, .o_cc1 .btn-fill-secondary.o_wysiwyg_loader, .o_cc1 .btn-secondary:disabled, .o_cc1 .btn-secondary.o_wysiwyg_loader, .o_cc1 .btn-fill-secondary.disabled, .o_cc1 .disabled.btn-secondary, .o_colored_level .o_cc1 .btn-fill-secondary:disabled, .o_colored_level .o_cc1 .btn-fill-secondary.disabled{color: #FFFFFF; background-color: #8595A2; border-color: #8595A2;}.o_cc1 .btn-outline-secondary, .o_colored_level .o_cc1 .btn-outline-secondary{color: #8595A2; border-color: #8595A2;}.o_cc1 .btn-outline-secondary:hover, .o_colored_level .o_cc1 .btn-outline-secondary:hover{color: #FFFFFF; background-color: #8595A2; border-color: #8595A2;}.btn-check:focus + .o_cc1 .btn-outline-secondary, .o_cc1 .btn-outline-secondary:focus, .btn-check:focus + .o_colored_level .o_cc1 .btn-outline-secondary, .o_colored_level .o_cc1 .btn-outline-secondary:focus{box-shadow: 0 0 0 0.25rem rgba(133, 149, 162, 0.5);}.btn-check:checked + .o_cc1 .btn-outline-secondary, .btn-check:active + .o_cc1 .btn-outline-secondary, .o_cc1 .btn-outline-secondary:active, .o_cc1 .btn-outline-secondary.active, .o_cc1 .btn-outline-secondary.dropdown-toggle.show, .btn-check:checked + .o_colored_level .o_cc1 .btn-outline-secondary, .btn-check:active + .o_colored_level .o_cc1 .btn-outline-secondary, .o_colored_level .o_cc1 .btn-outline-secondary:active, .o_colored_level .o_cc1 .btn-outline-secondary.active, .o_colored_level .o_cc1 .btn-outline-secondary.dropdown-toggle.show{color: #FFFFFF; background-color: #8595A2; border-color: #8595A2;}.btn-check:checked + .o_cc1 .btn-outline-secondary:focus, .btn-check:active + .o_cc1 .btn-outline-secondary:focus, .o_cc1 .btn-outline-secondary:active:focus, .o_cc1 .btn-outline-secondary.active:focus, .o_cc1 .btn-outline-secondary.dropdown-toggle.show:focus, .btn-check:checked + .o_colored_level .o_cc1 .btn-outline-secondary:focus, .btn-check:active + .o_colored_level .o_cc1 .btn-outline-secondary:focus, .o_colored_level .o_cc1 .btn-outline-secondary:active:focus, .o_colored_level .o_cc1 .btn-outline-secondary.active:focus, .o_colored_level .o_cc1 .btn-outline-secondary.dropdown-toggle.show:focus{box-shadow: 0 0 0 0.25rem rgba(133, 149, 162, 0.5);}.o_cc1 .btn-outline-secondary:disabled, .o_cc1 .btn-outline-secondary.o_wysiwyg_loader, .o_cc1 .btn-outline-secondary.disabled, .o_colored_level .o_cc1 .btn-outline-secondary:disabled, .o_colored_level .o_cc1 .btn-outline-secondary.disabled{color: #8595A2; background-color: transparent;}.o_cc1 .nav-pills .nav-link.active, .o_cc1 .nav-pills .show > .nav-link, .o_colored_level .o_cc1 .nav-pills .nav-link.active, .o_colored_level .o_cc1 .nav-pills .show > .nav-link{background-color: #714B67; color: #FFFFFF;}.o_cc1 .dropdown-menu .dropdown-item.active, .o_cc1 .dropdown-menu .dropdown-item.active h6, .o_cc1 .dropdown-menu .dropdown-item.active .h6, .o_cc1 .dropdown-menu .dropdown-item:active, .o_cc1 .dropdown-menu .dropdown-item:active h6, .o_cc1 .dropdown-menu .dropdown-item:active .h6, .o_colored_level .o_cc1 .dropdown-menu .dropdown-item.active, .o_colored_level .o_cc1 .dropdown-menu .dropdown-item.active h6, .o_colored_level .o_cc1 .dropdown-menu .dropdown-item:active, .o_colored_level .o_cc1 .dropdown-menu .dropdown-item:active h6{background-color: #714B67; color: #FFFFFF !important;}.o_cc1 .dropdown-menu .dropdown-item.active:hover, .o_cc1 .dropdown-menu .dropdown-item.active:focus, .o_cc1 .dropdown-menu .dropdown-item.active h6:hover, .o_cc1 .dropdown-menu .dropdown-item.active .h6:hover, .o_cc1 .dropdown-menu .dropdown-item.active h6:focus, .o_cc1 .dropdown-menu .dropdown-item.active .h6:focus, .o_cc1 .dropdown-menu .dropdown-item:active:hover, .o_cc1 .dropdown-menu .dropdown-item:active:focus, .o_cc1 .dropdown-menu .dropdown-item:active h6:hover, .o_cc1 .dropdown-menu .dropdown-item:active .h6:hover, .o_cc1 .dropdown-menu .dropdown-item:active h6:focus, .o_cc1 .dropdown-menu .dropdown-item:active .h6:focus, .o_colored_level .o_cc1 .dropdown-menu .dropdown-item.active:hover, .o_colored_level .o_cc1 .dropdown-menu .dropdown-item.active:focus, .o_colored_level .o_cc1 .dropdown-menu .dropdown-item.active h6:hover, .o_colored_level .o_cc1 .dropdown-menu .dropdown-item.active h6:focus, .o_colored_level .o_cc1 .dropdown-menu .dropdown-item:active:hover, .o_colored_level .o_cc1 .dropdown-menu .dropdown-item:active:focus, .o_colored_level .o_cc1 .dropdown-menu .dropdown-item:active h6:hover, .o_colored_level .o_cc1 .dropdown-menu .dropdown-item:active h6:focus{color: #FFFFFF !important;}.o_cc1 a.list-group-item, .o_colored_level .o_cc1 a.list-group-item{color: #714B67;}.o_cc1 a.list-group-item.active, .o_colored_level .o_cc1 a.list-group-item.active{background-color: #714B67; color: #FFFFFF; border-color: #714B67;}.o_cc2{background-color: #F3F2F2; color: #000000; --o-cc-bg: #F3F2F2;}.o_cc2 .text-muted, .o_colored_level .o_cc2 .text-muted{color: rgba(0, 0, 0, 0.7) !important;}.o_cc2 h1, .o_cc2 .h1, .o_cc2 h2, .o_cc2 .h2, .o_cc2 h3, .o_cc2 .h3, .o_cc2 h4, .o_cc2 .h4, .o_cc2 h5, .o_cc2 .h5, .o_cc2 h6, .o_cc2 .h6, .o_colored_level .o_cc2 h1, .o_colored_level .o_cc2 h2, .o_colored_level .o_cc2 h3, .o_colored_level .o_cc2 h4, .o_colored_level .o_cc2 h5, .o_colored_level .o_cc2 h6{color: #111827;}.o_cc2 a:not(.btn), .o_cc2 .btn-link, .o_colored_level .o_cc2 a:not(.btn), .o_colored_level .o_cc2 .btn-link{color: #55394e;}.o_cc2 a:not(.btn):hover, .o_cc2 .btn-link:hover, .o_colored_level .o_cc2 a:not(.btn):hover, .o_colored_level .o_cc2 .btn-link:hover{color: #432c3d;}.o_cc2 .btn-fill-primary, .o_cc2 .btn-primary, .o_colored_level .o_cc2 .btn-fill-primary{color: #FFFFFF; background-color: #714B67; border-color: #714B67;}.o_cc2 .btn-fill-primary:hover, .o_cc2 .btn-primary:hover, .o_colored_level .o_cc2 .btn-fill-primary:hover{color: #FFFFFF; background-color: #604058; border-color: #5a3c52;}.btn-check:focus + .o_cc2 .btn-fill-primary, .btn-check:focus + .o_cc2 .btn-primary, .o_cc2 .btn-fill-primary:focus, .o_cc2 .btn-primary:focus, .btn-check:focus + .o_colored_level .o_cc2 .btn-fill-primary, .o_colored_level .o_cc2 .btn-fill-primary:focus{color: #FFFFFF; background-color: #604058; border-color: #5a3c52; box-shadow: 0 0 0 0.25rem rgba(134, 102, 126, 0.5);}.btn-check:checked + .o_cc2 .btn-fill-primary, .btn-check:checked + .o_cc2 .btn-primary, .btn-check:active + .o_cc2 .btn-fill-primary, .btn-check:active + .o_cc2 .btn-primary, .o_cc2 .btn-fill-primary:active, .o_cc2 .btn-primary:active, .o_cc2 .btn-fill-primary.active, .o_cc2 .active.btn-primary, .show > .o_cc2 .btn-fill-primary.dropdown-toggle, .show > .o_cc2 .dropdown-toggle.btn-primary, .btn-check:checked + .o_colored_level .o_cc2 .btn-fill-primary, .btn-check:active + .o_colored_level .o_cc2 .btn-fill-primary, .o_colored_level .o_cc2 .btn-fill-primary:active, .o_colored_level .o_cc2 .btn-fill-primary.active, .show > .o_colored_level .o_cc2 .btn-fill-primary.dropdown-toggle{color: #FFFFFF; background-color: #5a3c52; border-color: #55384d;}.btn-check:checked + .o_cc2 .btn-fill-primary:focus, .btn-check:checked + .o_cc2 .btn-primary:focus, .btn-check:active + .o_cc2 .btn-fill-primary:focus, .btn-check:active + .o_cc2 .btn-primary:focus, .o_cc2 .btn-fill-primary:active:focus, .o_cc2 .btn-primary:active:focus, .o_cc2 .btn-fill-primary.active:focus, .o_cc2 .active.btn-primary:focus, .show > .o_cc2 .btn-fill-primary.dropdown-toggle:focus, .show > .o_cc2 .dropdown-toggle.btn-primary:focus, .btn-check:checked + .o_colored_level .o_cc2 .btn-fill-primary:focus, .btn-check:active + .o_colored_level .o_cc2 .btn-fill-primary:focus, .o_colored_level .o_cc2 .btn-fill-primary:active:focus, .o_colored_level .o_cc2 .btn-fill-primary.active:focus, .show > .o_colored_level .o_cc2 .btn-fill-primary.dropdown-toggle:focus{box-shadow: 0 0 0 0.25rem rgba(134, 102, 126, 0.5);}.o_cc2 .btn-fill-primary:disabled, .o_cc2 .btn-fill-primary.o_wysiwyg_loader, .o_cc2 .btn-primary:disabled, .o_cc2 .btn-primary.o_wysiwyg_loader, .o_cc2 .btn-fill-primary.disabled, .o_cc2 .disabled.btn-primary, .o_colored_level .o_cc2 .btn-fill-primary:disabled, .o_colored_level .o_cc2 .btn-fill-primary.disabled{color: #FFFFFF; background-color: #714B67; border-color: #714B67;}.o_cc2 .btn-outline-primary, .o_colored_level .o_cc2 .btn-outline-primary{color: #714B67; border-color: #714B67;}.o_cc2 .btn-outline-primary:hover, .o_colored_level .o_cc2 .btn-outline-primary:hover{color: #FFFFFF; background-color: #714B67; border-color: #714B67;}.btn-check:focus + .o_cc2 .btn-outline-primary, .o_cc2 .btn-outline-primary:focus, .btn-check:focus + .o_colored_level .o_cc2 .btn-outline-primary, .o_colored_level .o_cc2 .btn-outline-primary:focus{box-shadow: 0 0 0 0.25rem rgba(113, 75, 103, 0.5);}.btn-check:checked + .o_cc2 .btn-outline-primary, .btn-check:active + .o_cc2 .btn-outline-primary, .o_cc2 .btn-outline-primary:active, .o_cc2 .btn-outline-primary.active, .o_cc2 .btn-outline-primary.dropdown-toggle.show, .btn-check:checked + .o_colored_level .o_cc2 .btn-outline-primary, .btn-check:active + .o_colored_level .o_cc2 .btn-outline-primary, .o_colored_level .o_cc2 .btn-outline-primary:active, .o_colored_level .o_cc2 .btn-outline-primary.active, .o_colored_level .o_cc2 .btn-outline-primary.dropdown-toggle.show{color: #FFFFFF; background-color: #714B67; border-color: #714B67;}.btn-check:checked + .o_cc2 .btn-outline-primary:focus, .btn-check:active + .o_cc2 .btn-outline-primary:focus, .o_cc2 .btn-outline-primary:active:focus, .o_cc2 .btn-outline-primary.active:focus, .o_cc2 .btn-outline-primary.dropdown-toggle.show:focus, .btn-check:checked + .o_colored_level .o_cc2 .btn-outline-primary:focus, .btn-check:active + .o_colored_level .o_cc2 .btn-outline-primary:focus, .o_colored_level .o_cc2 .btn-outline-primary:active:focus, .o_colored_level .o_cc2 .btn-outline-primary.active:focus, .o_colored_level .o_cc2 .btn-outline-primary.dropdown-toggle.show:focus{box-shadow: 0 0 0 0.25rem rgba(113, 75, 103, 0.5);}.o_cc2 .btn-outline-primary:disabled, .o_cc2 .btn-outline-primary.o_wysiwyg_loader, .o_cc2 .btn-outline-primary.disabled, .o_colored_level .o_cc2 .btn-outline-primary:disabled, .o_colored_level .o_cc2 .btn-outline-primary.disabled{color: #714B67; background-color: transparent;}.o_cc2 .btn-fill-secondary, .o_cc2 .btn-secondary, .o_colored_level .o_cc2 .btn-fill-secondary{color: #FFFFFF; background-color: #8595A2; border-color: #8595A2;}.o_cc2 .btn-fill-secondary:hover, .o_cc2 .btn-secondary:hover, .o_colored_level .o_cc2 .btn-fill-secondary:hover{color: #FFFFFF; background-color: #717f8a; border-color: #6a7782;}.btn-check:focus + .o_cc2 .btn-fill-secondary, .btn-check:focus + .o_cc2 .btn-secondary, .o_cc2 .btn-fill-secondary:focus, .o_cc2 .btn-secondary:focus, .btn-check:focus + .o_colored_level .o_cc2 .btn-fill-secondary, .o_colored_level .o_cc2 .btn-fill-secondary:focus{color: #FFFFFF; background-color: #717f8a; border-color: #6a7782; box-shadow: 0 0 0 0.25rem rgba(151, 165, 176, 0.5);}.btn-check:checked + .o_cc2 .btn-fill-secondary, .btn-check:checked + .o_cc2 .btn-secondary, .btn-check:active + .o_cc2 .btn-fill-secondary, .btn-check:active + .o_cc2 .btn-secondary, .o_cc2 .btn-fill-secondary:active, .o_cc2 .btn-secondary:active, .o_cc2 .btn-fill-secondary.active, .o_cc2 .active.btn-secondary, .show > .o_cc2 .btn-fill-secondary.dropdown-toggle, .show > .o_cc2 .dropdown-toggle.btn-secondary, .btn-check:checked + .o_colored_level .o_cc2 .btn-fill-secondary, .btn-check:active + .o_colored_level .o_cc2 .btn-fill-secondary, .o_colored_level .o_cc2 .btn-fill-secondary:active, .o_colored_level .o_cc2 .btn-fill-secondary.active, .show > .o_colored_level .o_cc2 .btn-fill-secondary.dropdown-toggle{color: #FFFFFF; background-color: #6a7782; border-color: #64707a;}.btn-check:checked + .o_cc2 .btn-fill-secondary:focus, .btn-check:checked + .o_cc2 .btn-secondary:focus, .btn-check:active + .o_cc2 .btn-fill-secondary:focus, .btn-check:active + .o_cc2 .btn-secondary:focus, .o_cc2 .btn-fill-secondary:active:focus, .o_cc2 .btn-secondary:active:focus, .o_cc2 .btn-fill-secondary.active:focus, .o_cc2 .active.btn-secondary:focus, .show > .o_cc2 .btn-fill-secondary.dropdown-toggle:focus, .show > .o_cc2 .dropdown-toggle.btn-secondary:focus, .btn-check:checked + .o_colored_level .o_cc2 .btn-fill-secondary:focus, .btn-check:active + .o_colored_level .o_cc2 .btn-fill-secondary:focus, .o_colored_level .o_cc2 .btn-fill-secondary:active:focus, .o_colored_level .o_cc2 .btn-fill-secondary.active:focus, .show > .o_colored_level .o_cc2 .btn-fill-secondary.dropdown-toggle:focus{box-shadow: 0 0 0 0.25rem rgba(151, 165, 176, 0.5);}.o_cc2 .btn-fill-secondary:disabled, .o_cc2 .btn-fill-secondary.o_wysiwyg_loader, .o_cc2 .btn-secondary:disabled, .o_cc2 .btn-secondary.o_wysiwyg_loader, .o_cc2 .btn-fill-secondary.disabled, .o_cc2 .disabled.btn-secondary, .o_colored_level .o_cc2 .btn-fill-secondary:disabled, .o_colored_level .o_cc2 .btn-fill-secondary.disabled{color: #FFFFFF; background-color: #8595A2; border-color: #8595A2;}.o_cc2 .btn-outline-secondary, .o_colored_level .o_cc2 .btn-outline-secondary{color: #8595A2; border-color: #8595A2;}.o_cc2 .btn-outline-secondary:hover, .o_colored_level .o_cc2 .btn-outline-secondary:hover{color: #FFFFFF; background-color: #8595A2; border-color: #8595A2;}.btn-check:focus + .o_cc2 .btn-outline-secondary, .o_cc2 .btn-outline-secondary:focus, .btn-check:focus + .o_colored_level .o_cc2 .btn-outline-secondary, .o_colored_level .o_cc2 .btn-outline-secondary:focus{box-shadow: 0 0 0 0.25rem rgba(133, 149, 162, 0.5);}.btn-check:checked + .o_cc2 .btn-outline-secondary, .btn-check:active + .o_cc2 .btn-outline-secondary, .o_cc2 .btn-outline-secondary:active, .o_cc2 .btn-outline-secondary.active, .o_cc2 .btn-outline-secondary.dropdown-toggle.show, .btn-check:checked + .o_colored_level .o_cc2 .btn-outline-secondary, .btn-check:active + .o_colored_level .o_cc2 .btn-outline-secondary, .o_colored_level .o_cc2 .btn-outline-secondary:active, .o_colored_level .o_cc2 .btn-outline-secondary.active, .o_colored_level .o_cc2 .btn-outline-secondary.dropdown-toggle.show{color: #FFFFFF; background-color: #8595A2; border-color: #8595A2;}.btn-check:checked + .o_cc2 .btn-outline-secondary:focus, .btn-check:active + .o_cc2 .btn-outline-secondary:focus, .o_cc2 .btn-outline-secondary:active:focus, .o_cc2 .btn-outline-secondary.active:focus, .o_cc2 .btn-outline-secondary.dropdown-toggle.show:focus, .btn-check:checked + .o_colored_level .o_cc2 .btn-outline-secondary:focus, .btn-check:active + .o_colored_level .o_cc2 .btn-outline-secondary:focus, .o_colored_level .o_cc2 .btn-outline-secondary:active:focus, .o_colored_level .o_cc2 .btn-outline-secondary.active:focus, .o_colored_level .o_cc2 .btn-outline-secondary.dropdown-toggle.show:focus{box-shadow: 0 0 0 0.25rem rgba(133, 149, 162, 0.5);}.o_cc2 .btn-outline-secondary:disabled, .o_cc2 .btn-outline-secondary.o_wysiwyg_loader, .o_cc2 .btn-outline-secondary.disabled, .o_colored_level .o_cc2 .btn-outline-secondary:disabled, .o_colored_level .o_cc2 .btn-outline-secondary.disabled{color: #8595A2; background-color: transparent;}.o_cc2 .nav-pills .nav-link.active, .o_cc2 .nav-pills .show > .nav-link, .o_colored_level .o_cc2 .nav-pills .nav-link.active, .o_colored_level .o_cc2 .nav-pills .show > .nav-link{background-color: #714B67; color: #FFFFFF;}.o_cc2 .dropdown-menu .dropdown-item.active, .o_cc2 .dropdown-menu .dropdown-item.active h6, .o_cc2 .dropdown-menu .dropdown-item.active .h6, .o_cc2 .dropdown-menu .dropdown-item:active, .o_cc2 .dropdown-menu .dropdown-item:active h6, .o_cc2 .dropdown-menu .dropdown-item:active .h6, .o_colored_level .o_cc2 .dropdown-menu .dropdown-item.active, .o_colored_level .o_cc2 .dropdown-menu .dropdown-item.active h6, .o_colored_level .o_cc2 .dropdown-menu .dropdown-item:active, .o_colored_level .o_cc2 .dropdown-menu .dropdown-item:active h6{background-color: #714B67; color: #FFFFFF !important;}.o_cc2 .dropdown-menu .dropdown-item.active:hover, .o_cc2 .dropdown-menu .dropdown-item.active:focus, .o_cc2 .dropdown-menu .dropdown-item.active h6:hover, .o_cc2 .dropdown-menu .dropdown-item.active .h6:hover, .o_cc2 .dropdown-menu .dropdown-item.active h6:focus, .o_cc2 .dropdown-menu .dropdown-item.active .h6:focus, .o_cc2 .dropdown-menu .dropdown-item:active:hover, .o_cc2 .dropdown-menu .dropdown-item:active:focus, .o_cc2 .dropdown-menu .dropdown-item:active h6:hover, .o_cc2 .dropdown-menu .dropdown-item:active .h6:hover, .o_cc2 .dropdown-menu .dropdown-item:active h6:focus, .o_cc2 .dropdown-menu .dropdown-item:active .h6:focus, .o_colored_level .o_cc2 .dropdown-menu .dropdown-item.active:hover, .o_colored_level .o_cc2 .dropdown-menu .dropdown-item.active:focus, .o_colored_level .o_cc2 .dropdown-menu .dropdown-item.active h6:hover, .o_colored_level .o_cc2 .dropdown-menu .dropdown-item.active h6:focus, .o_colored_level .o_cc2 .dropdown-menu .dropdown-item:active:hover, .o_colored_level .o_cc2 .dropdown-menu .dropdown-item:active:focus, .o_colored_level .o_cc2 .dropdown-menu .dropdown-item:active h6:hover, .o_colored_level .o_cc2 .dropdown-menu .dropdown-item:active h6:focus{color: #FFFFFF !important;}.o_cc2 a.list-group-item, .o_colored_level .o_cc2 a.list-group-item{color: #714B67;}.o_cc2 a.list-group-item.active, .o_colored_level .o_cc2 a.list-group-item.active{background-color: #714B67; color: #FFFFFF; border-color: #714B67;}.o_cc3{background-color: #8595A2; color: #FFFFFF; --o-cc-bg: #8595A2;}.o_cc3 .text-muted, .o_colored_level .o_cc3 .text-muted{color: rgba(255, 255, 255, 0.7) !important;}.o_cc3 a:not(.btn), .o_cc3 .btn-link, .o_colored_level .o_cc3 a:not(.btn), .o_colored_level .o_cc3 .btn-link{color: #241821;}.o_cc3 a:not(.btn):hover, .o_cc3 .btn-link:hover, .o_colored_level .o_cc3 a:not(.btn):hover, .o_colored_level .o_cc3 .btn-link:hover{color: black;}.o_cc3 .btn-fill-primary, .o_cc3 .btn-primary, .o_colored_level .o_cc3 .btn-fill-primary{color: #FFFFFF; background-color: #714B67; border-color: #714B67;}.o_cc3 .btn-fill-primary:hover, .o_cc3 .btn-primary:hover, .o_colored_level .o_cc3 .btn-fill-primary:hover{color: #FFFFFF; background-color: #604058; border-color: #5a3c52;}.btn-check:focus + .o_cc3 .btn-fill-primary, .btn-check:focus + .o_cc3 .btn-primary, .o_cc3 .btn-fill-primary:focus, .o_cc3 .btn-primary:focus, .btn-check:focus + .o_colored_level .o_cc3 .btn-fill-primary, .o_colored_level .o_cc3 .btn-fill-primary:focus{color: #FFFFFF; background-color: #604058; border-color: #5a3c52; box-shadow: 0 0 0 0.25rem rgba(134, 102, 126, 0.5);}.btn-check:checked + .o_cc3 .btn-fill-primary, .btn-check:checked + .o_cc3 .btn-primary, .btn-check:active + .o_cc3 .btn-fill-primary, .btn-check:active + .o_cc3 .btn-primary, .o_cc3 .btn-fill-primary:active, .o_cc3 .btn-primary:active, .o_cc3 .btn-fill-primary.active, .o_cc3 .active.btn-primary, .show > .o_cc3 .btn-fill-primary.dropdown-toggle, .show > .o_cc3 .dropdown-toggle.btn-primary, .btn-check:checked + .o_colored_level .o_cc3 .btn-fill-primary, .btn-check:active + .o_colored_level .o_cc3 .btn-fill-primary, .o_colored_level .o_cc3 .btn-fill-primary:active, .o_colored_level .o_cc3 .btn-fill-primary.active, .show > .o_colored_level .o_cc3 .btn-fill-primary.dropdown-toggle{color: #FFFFFF; background-color: #5a3c52; border-color: #55384d;}.btn-check:checked + .o_cc3 .btn-fill-primary:focus, .btn-check:checked + .o_cc3 .btn-primary:focus, .btn-check:active + .o_cc3 .btn-fill-primary:focus, .btn-check:active + .o_cc3 .btn-primary:focus, .o_cc3 .btn-fill-primary:active:focus, .o_cc3 .btn-primary:active:focus, .o_cc3 .btn-fill-primary.active:focus, .o_cc3 .active.btn-primary:focus, .show > .o_cc3 .btn-fill-primary.dropdown-toggle:focus, .show > .o_cc3 .dropdown-toggle.btn-primary:focus, .btn-check:checked + .o_colored_level .o_cc3 .btn-fill-primary:focus, .btn-check:active + .o_colored_level .o_cc3 .btn-fill-primary:focus, .o_colored_level .o_cc3 .btn-fill-primary:active:focus, .o_colored_level .o_cc3 .btn-fill-primary.active:focus, .show > .o_colored_level .o_cc3 .btn-fill-primary.dropdown-toggle:focus{box-shadow: 0 0 0 0.25rem rgba(134, 102, 126, 0.5);}.o_cc3 .btn-fill-primary:disabled, .o_cc3 .btn-fill-primary.o_wysiwyg_loader, .o_cc3 .btn-primary:disabled, .o_cc3 .btn-primary.o_wysiwyg_loader, .o_cc3 .btn-fill-primary.disabled, .o_cc3 .disabled.btn-primary, .o_colored_level .o_cc3 .btn-fill-primary:disabled, .o_colored_level .o_cc3 .btn-fill-primary.disabled{color: #FFFFFF; background-color: #714B67; border-color: #714B67;}.o_cc3 .btn-outline-primary, .o_colored_level .o_cc3 .btn-outline-primary{color: #714B67; border-color: #714B67;}.o_cc3 .btn-outline-primary:hover, .o_colored_level .o_cc3 .btn-outline-primary:hover{color: #FFFFFF; background-color: #714B67; border-color: #714B67;}.btn-check:focus + .o_cc3 .btn-outline-primary, .o_cc3 .btn-outline-primary:focus, .btn-check:focus + .o_colored_level .o_cc3 .btn-outline-primary, .o_colored_level .o_cc3 .btn-outline-primary:focus{box-shadow: 0 0 0 0.25rem rgba(113, 75, 103, 0.5);}.btn-check:checked + .o_cc3 .btn-outline-primary, .btn-check:active + .o_cc3 .btn-outline-primary, .o_cc3 .btn-outline-primary:active, .o_cc3 .btn-outline-primary.active, .o_cc3 .btn-outline-primary.dropdown-toggle.show, .btn-check:checked + .o_colored_level .o_cc3 .btn-outline-primary, .btn-check:active + .o_colored_level .o_cc3 .btn-outline-primary, .o_colored_level .o_cc3 .btn-outline-primary:active, .o_colored_level .o_cc3 .btn-outline-primary.active, .o_colored_level .o_cc3 .btn-outline-primary.dropdown-toggle.show{color: #FFFFFF; background-color: #714B67; border-color: #714B67;}.btn-check:checked + .o_cc3 .btn-outline-primary:focus, .btn-check:active + .o_cc3 .btn-outline-primary:focus, .o_cc3 .btn-outline-primary:active:focus, .o_cc3 .btn-outline-primary.active:focus, .o_cc3 .btn-outline-primary.dropdown-toggle.show:focus, .btn-check:checked + .o_colored_level .o_cc3 .btn-outline-primary:focus, .btn-check:active + .o_colored_level .o_cc3 .btn-outline-primary:focus, .o_colored_level .o_cc3 .btn-outline-primary:active:focus, .o_colored_level .o_cc3 .btn-outline-primary.active:focus, .o_colored_level .o_cc3 .btn-outline-primary.dropdown-toggle.show:focus{box-shadow: 0 0 0 0.25rem rgba(113, 75, 103, 0.5);}.o_cc3 .btn-outline-primary:disabled, .o_cc3 .btn-outline-primary.o_wysiwyg_loader, .o_cc3 .btn-outline-primary.disabled, .o_colored_level .o_cc3 .btn-outline-primary:disabled, .o_colored_level .o_cc3 .btn-outline-primary.disabled{color: #714B67; background-color: transparent;}.o_cc3 .btn-fill-secondary, .o_cc3 .btn-secondary, .o_colored_level .o_cc3 .btn-fill-secondary{color: #000000; background-color: #F3F2F2; border-color: #F3F2F2;}.o_cc3 .btn-fill-secondary:hover, .o_cc3 .btn-secondary:hover, .o_colored_level .o_cc3 .btn-fill-secondary:hover{color: #000000; background-color: #f5f4f4; border-color: #f4f3f3;}.btn-check:focus + .o_cc3 .btn-fill-secondary, .btn-check:focus + .o_cc3 .btn-secondary, .o_cc3 .btn-fill-secondary:focus, .o_cc3 .btn-secondary:focus, .btn-check:focus + .o_colored_level .o_cc3 .btn-fill-secondary, .o_colored_level .o_cc3 .btn-fill-secondary:focus{color: #000000; background-color: #f5f4f4; border-color: #f4f3f3; box-shadow: 0 0 0 0.25rem rgba(207, 206, 206, 0.5);}.btn-check:checked + .o_cc3 .btn-fill-secondary, .btn-check:checked + .o_cc3 .btn-secondary, .btn-check:active + .o_cc3 .btn-fill-secondary, .btn-check:active + .o_cc3 .btn-secondary, .o_cc3 .btn-fill-secondary:active, .o_cc3 .btn-secondary:active, .o_cc3 .btn-fill-secondary.active, .o_cc3 .active.btn-secondary, .show > .o_cc3 .btn-fill-secondary.dropdown-toggle, .show > .o_cc3 .dropdown-toggle.btn-secondary, .btn-check:checked + .o_colored_level .o_cc3 .btn-fill-secondary, .btn-check:active + .o_colored_level .o_cc3 .btn-fill-secondary, .o_colored_level .o_cc3 .btn-fill-secondary:active, .o_colored_level .o_cc3 .btn-fill-secondary.active, .show > .o_colored_level .o_cc3 .btn-fill-secondary.dropdown-toggle{color: #000000; background-color: whitesmoke; border-color: #f4f3f3;}.btn-check:checked + .o_cc3 .btn-fill-secondary:focus, .btn-check:checked + .o_cc3 .btn-secondary:focus, .btn-check:active + .o_cc3 .btn-fill-secondary:focus, .btn-check:active + .o_cc3 .btn-secondary:focus, .o_cc3 .btn-fill-secondary:active:focus, .o_cc3 .btn-secondary:active:focus, .o_cc3 .btn-fill-secondary.active:focus, .o_cc3 .active.btn-secondary:focus, .show > .o_cc3 .btn-fill-secondary.dropdown-toggle:focus, .show > .o_cc3 .dropdown-toggle.btn-secondary:focus, .btn-check:checked + .o_colored_level .o_cc3 .btn-fill-secondary:focus, .btn-check:active + .o_colored_level .o_cc3 .btn-fill-secondary:focus, .o_colored_level .o_cc3 .btn-fill-secondary:active:focus, .o_colored_level .o_cc3 .btn-fill-secondary.active:focus, .show > .o_colored_level .o_cc3 .btn-fill-secondary.dropdown-toggle:focus{box-shadow: 0 0 0 0.25rem rgba(207, 206, 206, 0.5);}.o_cc3 .btn-fill-secondary:disabled, .o_cc3 .btn-fill-secondary.o_wysiwyg_loader, .o_cc3 .btn-secondary:disabled, .o_cc3 .btn-secondary.o_wysiwyg_loader, .o_cc3 .btn-fill-secondary.disabled, .o_cc3 .disabled.btn-secondary, .o_colored_level .o_cc3 .btn-fill-secondary:disabled, .o_colored_level .o_cc3 .btn-fill-secondary.disabled{color: #000000; background-color: #F3F2F2; border-color: #F3F2F2;}.o_cc3 .btn-outline-secondary, .o_colored_level .o_cc3 .btn-outline-secondary{color: #F3F2F2; border-color: #F3F2F2;}.o_cc3 .btn-outline-secondary:hover, .o_colored_level .o_cc3 .btn-outline-secondary:hover{color: #000000; background-color: #F3F2F2; border-color: #F3F2F2;}.btn-check:focus + .o_cc3 .btn-outline-secondary, .o_cc3 .btn-outline-secondary:focus, .btn-check:focus + .o_colored_level .o_cc3 .btn-outline-secondary, .o_colored_level .o_cc3 .btn-outline-secondary:focus{box-shadow: 0 0 0 0.25rem rgba(243, 242, 242, 0.5);}.btn-check:checked + .o_cc3 .btn-outline-secondary, .btn-check:active + .o_cc3 .btn-outline-secondary, .o_cc3 .btn-outline-secondary:active, .o_cc3 .btn-outline-secondary.active, .o_cc3 .btn-outline-secondary.dropdown-toggle.show, .btn-check:checked + .o_colored_level .o_cc3 .btn-outline-secondary, .btn-check:active + .o_colored_level .o_cc3 .btn-outline-secondary, .o_colored_level .o_cc3 .btn-outline-secondary:active, .o_colored_level .o_cc3 .btn-outline-secondary.active, .o_colored_level .o_cc3 .btn-outline-secondary.dropdown-toggle.show{color: #000000; background-color: #F3F2F2; border-color: #F3F2F2;}.btn-check:checked + .o_cc3 .btn-outline-secondary:focus, .btn-check:active + .o_cc3 .btn-outline-secondary:focus, .o_cc3 .btn-outline-secondary:active:focus, .o_cc3 .btn-outline-secondary.active:focus, .o_cc3 .btn-outline-secondary.dropdown-toggle.show:focus, .btn-check:checked + .o_colored_level .o_cc3 .btn-outline-secondary:focus, .btn-check:active + .o_colored_level .o_cc3 .btn-outline-secondary:focus, .o_colored_level .o_cc3 .btn-outline-secondary:active:focus, .o_colored_level .o_cc3 .btn-outline-secondary.active:focus, .o_colored_level .o_cc3 .btn-outline-secondary.dropdown-toggle.show:focus{box-shadow: 0 0 0 0.25rem rgba(243, 242, 242, 0.5);}.o_cc3 .btn-outline-secondary:disabled, .o_cc3 .btn-outline-secondary.o_wysiwyg_loader, .o_cc3 .btn-outline-secondary.disabled, .o_colored_level .o_cc3 .btn-outline-secondary:disabled, .o_colored_level .o_cc3 .btn-outline-secondary.disabled{color: #F3F2F2; background-color: transparent;}.o_cc3 .nav-pills .nav-link.active, .o_cc3 .nav-pills .show > .nav-link, .o_colored_level .o_cc3 .nav-pills .nav-link.active, .o_colored_level .o_cc3 .nav-pills .show > .nav-link{background-color: #714B67; color: #FFFFFF;}.o_cc3 .dropdown-menu .dropdown-item.active, .o_cc3 .dropdown-menu .dropdown-item.active h6, .o_cc3 .dropdown-menu .dropdown-item.active .h6, .o_cc3 .dropdown-menu .dropdown-item:active, .o_cc3 .dropdown-menu .dropdown-item:active h6, .o_cc3 .dropdown-menu .dropdown-item:active .h6, .o_colored_level .o_cc3 .dropdown-menu .dropdown-item.active, .o_colored_level .o_cc3 .dropdown-menu .dropdown-item.active h6, .o_colored_level .o_cc3 .dropdown-menu .dropdown-item:active, .o_colored_level .o_cc3 .dropdown-menu .dropdown-item:active h6{background-color: #714B67; color: #FFFFFF !important;}.o_cc3 .dropdown-menu .dropdown-item.active:hover, .o_cc3 .dropdown-menu .dropdown-item.active:focus, .o_cc3 .dropdown-menu .dropdown-item.active h6:hover, .o_cc3 .dropdown-menu .dropdown-item.active .h6:hover, .o_cc3 .dropdown-menu .dropdown-item.active h6:focus, .o_cc3 .dropdown-menu .dropdown-item.active .h6:focus, .o_cc3 .dropdown-menu .dropdown-item:active:hover, .o_cc3 .dropdown-menu .dropdown-item:active:focus, .o_cc3 .dropdown-menu .dropdown-item:active h6:hover, .o_cc3 .dropdown-menu .dropdown-item:active .h6:hover, .o_cc3 .dropdown-menu .dropdown-item:active h6:focus, .o_cc3 .dropdown-menu .dropdown-item:active .h6:focus, .o_colored_level .o_cc3 .dropdown-menu .dropdown-item.active:hover, .o_colored_level .o_cc3 .dropdown-menu .dropdown-item.active:focus, .o_colored_level .o_cc3 .dropdown-menu .dropdown-item.active h6:hover, .o_colored_level .o_cc3 .dropdown-menu .dropdown-item.active h6:focus, .o_colored_level .o_cc3 .dropdown-menu .dropdown-item:active:hover, .o_colored_level .o_cc3 .dropdown-menu .dropdown-item:active:focus, .o_colored_level .o_cc3 .dropdown-menu .dropdown-item:active h6:hover, .o_colored_level .o_cc3 .dropdown-menu .dropdown-item:active h6:focus{color: #FFFFFF !important;}.o_cc3 a.list-group-item, .o_colored_level .o_cc3 a.list-group-item{color: #714B67;}.o_cc3 a.list-group-item.active, .o_colored_level .o_cc3 a.list-group-item.active{background-color: #714B67; color: #FFFFFF; border-color: #714B67;}.o_cc4{background-color: #714B67; color: #FFFFFF; --o-cc-bg: #714B67;}.o_cc4 .text-muted, .o_colored_level .o_cc4 .text-muted{color: rgba(255, 255, 255, 0.7) !important;}.o_cc4 a:not(.btn), .o_cc4 .btn-link, .o_colored_level .o_cc4 a:not(.btn), .o_colored_level .o_cc4 .btn-link{color: black;}.o_cc4 a:not(.btn):hover, .o_cc4 .btn-link:hover, .o_colored_level .o_cc4 a:not(.btn):hover, .o_colored_level .o_cc4 .btn-link:hover{color: black;}.o_cc4 .btn-fill-primary, .o_cc4 .btn-primary, .o_colored_level .o_cc4 .btn-fill-primary{color: #FFFFFF; background-color: #111827; border-color: #111827;}.o_cc4 .btn-fill-primary:hover, .o_cc4 .btn-primary:hover, .o_colored_level .o_cc4 .btn-fill-primary:hover{color: #FFFFFF; background-color: #0e1421; border-color: #0e131f;}.btn-check:focus + .o_cc4 .btn-fill-primary, .btn-check:focus + .o_cc4 .btn-primary, .o_cc4 .btn-fill-primary:focus, .o_cc4 .btn-primary:focus, .btn-check:focus + .o_colored_level .o_cc4 .btn-fill-primary, .o_colored_level .o_cc4 .btn-fill-primary:focus{color: #FFFFFF; background-color: #0e1421; border-color: #0e131f; box-shadow: 0 0 0 0.25rem rgba(53, 59, 71, 0.5);}.btn-check:checked + .o_cc4 .btn-fill-primary, .btn-check:checked + .o_cc4 .btn-primary, .btn-check:active + .o_cc4 .btn-fill-primary, .btn-check:active + .o_cc4 .btn-primary, .o_cc4 .btn-fill-primary:active, .o_cc4 .btn-primary:active, .o_cc4 .btn-fill-primary.active, .o_cc4 .active.btn-primary, .show > .o_cc4 .btn-fill-primary.dropdown-toggle, .show > .o_cc4 .dropdown-toggle.btn-primary, .btn-check:checked + .o_colored_level .o_cc4 .btn-fill-primary, .btn-check:active + .o_colored_level .o_cc4 .btn-fill-primary, .o_colored_level .o_cc4 .btn-fill-primary:active, .o_colored_level .o_cc4 .btn-fill-primary.active, .show > .o_colored_level .o_cc4 .btn-fill-primary.dropdown-toggle{color: #FFFFFF; background-color: #0e131f; border-color: #0d121d;}.btn-check:checked + .o_cc4 .btn-fill-primary:focus, .btn-check:checked + .o_cc4 .btn-primary:focus, .btn-check:active + .o_cc4 .btn-fill-primary:focus, .btn-check:active + .o_cc4 .btn-primary:focus, .o_cc4 .btn-fill-primary:active:focus, .o_cc4 .btn-primary:active:focus, .o_cc4 .btn-fill-primary.active:focus, .o_cc4 .active.btn-primary:focus, .show > .o_cc4 .btn-fill-primary.dropdown-toggle:focus, .show > .o_cc4 .dropdown-toggle.btn-primary:focus, .btn-check:checked + .o_colored_level .o_cc4 .btn-fill-primary:focus, .btn-check:active + .o_colored_level .o_cc4 .btn-fill-primary:focus, .o_colored_level .o_cc4 .btn-fill-primary:active:focus, .o_colored_level .o_cc4 .btn-fill-primary.active:focus, .show > .o_colored_level .o_cc4 .btn-fill-primary.dropdown-toggle:focus{box-shadow: 0 0 0 0.25rem rgba(53, 59, 71, 0.5);}.o_cc4 .btn-fill-primary:disabled, .o_cc4 .btn-fill-primary.o_wysiwyg_loader, .o_cc4 .btn-primary:disabled, .o_cc4 .btn-primary.o_wysiwyg_loader, .o_cc4 .btn-fill-primary.disabled, .o_cc4 .disabled.btn-primary, .o_colored_level .o_cc4 .btn-fill-primary:disabled, .o_colored_level .o_cc4 .btn-fill-primary.disabled{color: #FFFFFF; background-color: #111827; border-color: #111827;}.o_cc4 .btn-outline-primary, .o_colored_level .o_cc4 .btn-outline-primary{color: #111827; border-color: #111827;}.o_cc4 .btn-outline-primary:hover, .o_colored_level .o_cc4 .btn-outline-primary:hover{color: #FFFFFF; background-color: #111827; border-color: #111827;}.btn-check:focus + .o_cc4 .btn-outline-primary, .o_cc4 .btn-outline-primary:focus, .btn-check:focus + .o_colored_level .o_cc4 .btn-outline-primary, .o_colored_level .o_cc4 .btn-outline-primary:focus{box-shadow: 0 0 0 0.25rem rgba(17, 24, 39, 0.5);}.btn-check:checked + .o_cc4 .btn-outline-primary, .btn-check:active + .o_cc4 .btn-outline-primary, .o_cc4 .btn-outline-primary:active, .o_cc4 .btn-outline-primary.active, .o_cc4 .btn-outline-primary.dropdown-toggle.show, .btn-check:checked + .o_colored_level .o_cc4 .btn-outline-primary, .btn-check:active + .o_colored_level .o_cc4 .btn-outline-primary, .o_colored_level .o_cc4 .btn-outline-primary:active, .o_colored_level .o_cc4 .btn-outline-primary.active, .o_colored_level .o_cc4 .btn-outline-primary.dropdown-toggle.show{color: #FFFFFF; background-color: #111827; border-color: #111827;}.btn-check:checked + .o_cc4 .btn-outline-primary:focus, .btn-check:active + .o_cc4 .btn-outline-primary:focus, .o_cc4 .btn-outline-primary:active:focus, .o_cc4 .btn-outline-primary.active:focus, .o_cc4 .btn-outline-primary.dropdown-toggle.show:focus, .btn-check:checked + .o_colored_level .o_cc4 .btn-outline-primary:focus, .btn-check:active + .o_colored_level .o_cc4 .btn-outline-primary:focus, .o_colored_level .o_cc4 .btn-outline-primary:active:focus, .o_colored_level .o_cc4 .btn-outline-primary.active:focus, .o_colored_level .o_cc4 .btn-outline-primary.dropdown-toggle.show:focus{box-shadow: 0 0 0 0.25rem rgba(17, 24, 39, 0.5);}.o_cc4 .btn-outline-primary:disabled, .o_cc4 .btn-outline-primary.o_wysiwyg_loader, .o_cc4 .btn-outline-primary.disabled, .o_colored_level .o_cc4 .btn-outline-primary:disabled, .o_colored_level .o_cc4 .btn-outline-primary.disabled{color: #111827; background-color: transparent;}.o_cc4 .btn-fill-secondary, .o_cc4 .btn-secondary, .o_colored_level .o_cc4 .btn-fill-secondary{color: #000000; background-color: #F3F2F2; border-color: #F3F2F2;}.o_cc4 .btn-fill-secondary:hover, .o_cc4 .btn-secondary:hover, .o_colored_level .o_cc4 .btn-fill-secondary:hover{color: #000000; background-color: #f5f4f4; border-color: #f4f3f3;}.btn-check:focus + .o_cc4 .btn-fill-secondary, .btn-check:focus + .o_cc4 .btn-secondary, .o_cc4 .btn-fill-secondary:focus, .o_cc4 .btn-secondary:focus, .btn-check:focus + .o_colored_level .o_cc4 .btn-fill-secondary, .o_colored_level .o_cc4 .btn-fill-secondary:focus{color: #000000; background-color: #f5f4f4; border-color: #f4f3f3; box-shadow: 0 0 0 0.25rem rgba(207, 206, 206, 0.5);}.btn-check:checked + .o_cc4 .btn-fill-secondary, .btn-check:checked + .o_cc4 .btn-secondary, .btn-check:active + .o_cc4 .btn-fill-secondary, .btn-check:active + .o_cc4 .btn-secondary, .o_cc4 .btn-fill-secondary:active, .o_cc4 .btn-secondary:active, .o_cc4 .btn-fill-secondary.active, .o_cc4 .active.btn-secondary, .show > .o_cc4 .btn-fill-secondary.dropdown-toggle, .show > .o_cc4 .dropdown-toggle.btn-secondary, .btn-check:checked + .o_colored_level .o_cc4 .btn-fill-secondary, .btn-check:active + .o_colored_level .o_cc4 .btn-fill-secondary, .o_colored_level .o_cc4 .btn-fill-secondary:active, .o_colored_level .o_cc4 .btn-fill-secondary.active, .show > .o_colored_level .o_cc4 .btn-fill-secondary.dropdown-toggle{color: #000000; background-color: whitesmoke; border-color: #f4f3f3;}.btn-check:checked + .o_cc4 .btn-fill-secondary:focus, .btn-check:checked + .o_cc4 .btn-secondary:focus, .btn-check:active + .o_cc4 .btn-fill-secondary:focus, .btn-check:active + .o_cc4 .btn-secondary:focus, .o_cc4 .btn-fill-secondary:active:focus, .o_cc4 .btn-secondary:active:focus, .o_cc4 .btn-fill-secondary.active:focus, .o_cc4 .active.btn-secondary:focus, .show > .o_cc4 .btn-fill-secondary.dropdown-toggle:focus, .show > .o_cc4 .dropdown-toggle.btn-secondary:focus, .btn-check:checked + .o_colored_level .o_cc4 .btn-fill-secondary:focus, .btn-check:active + .o_colored_level .o_cc4 .btn-fill-secondary:focus, .o_colored_level .o_cc4 .btn-fill-secondary:active:focus, .o_colored_level .o_cc4 .btn-fill-secondary.active:focus, .show > .o_colored_level .o_cc4 .btn-fill-secondary.dropdown-toggle:focus{box-shadow: 0 0 0 0.25rem rgba(207, 206, 206, 0.5);}.o_cc4 .btn-fill-secondary:disabled, .o_cc4 .btn-fill-secondary.o_wysiwyg_loader, .o_cc4 .btn-secondary:disabled, .o_cc4 .btn-secondary.o_wysiwyg_loader, .o_cc4 .btn-fill-secondary.disabled, .o_cc4 .disabled.btn-secondary, .o_colored_level .o_cc4 .btn-fill-secondary:disabled, .o_colored_level .o_cc4 .btn-fill-secondary.disabled{color: #000000; background-color: #F3F2F2; border-color: #F3F2F2;}.o_cc4 .btn-outline-secondary, .o_colored_level .o_cc4 .btn-outline-secondary{color: #F3F2F2; border-color: #F3F2F2;}.o_cc4 .btn-outline-secondary:hover, .o_colored_level .o_cc4 .btn-outline-secondary:hover{color: #000000; background-color: #F3F2F2; border-color: #F3F2F2;}.btn-check:focus + .o_cc4 .btn-outline-secondary, .o_cc4 .btn-outline-secondary:focus, .btn-check:focus + .o_colored_level .o_cc4 .btn-outline-secondary, .o_colored_level .o_cc4 .btn-outline-secondary:focus{box-shadow: 0 0 0 0.25rem rgba(243, 242, 242, 0.5);}.btn-check:checked + .o_cc4 .btn-outline-secondary, .btn-check:active + .o_cc4 .btn-outline-secondary, .o_cc4 .btn-outline-secondary:active, .o_cc4 .btn-outline-secondary.active, .o_cc4 .btn-outline-secondary.dropdown-toggle.show, .btn-check:checked + .o_colored_level .o_cc4 .btn-outline-secondary, .btn-check:active + .o_colored_level .o_cc4 .btn-outline-secondary, .o_colored_level .o_cc4 .btn-outline-secondary:active, .o_colored_level .o_cc4 .btn-outline-secondary.active, .o_colored_level .o_cc4 .btn-outline-secondary.dropdown-toggle.show{color: #000000; background-color: #F3F2F2; border-color: #F3F2F2;}.btn-check:checked + .o_cc4 .btn-outline-secondary:focus, .btn-check:active + .o_cc4 .btn-outline-secondary:focus, .o_cc4 .btn-outline-secondary:active:focus, .o_cc4 .btn-outline-secondary.active:focus, .o_cc4 .btn-outline-secondary.dropdown-toggle.show:focus, .btn-check:checked + .o_colored_level .o_cc4 .btn-outline-secondary:focus, .btn-check:active + .o_colored_level .o_cc4 .btn-outline-secondary:focus, .o_colored_level .o_cc4 .btn-outline-secondary:active:focus, .o_colored_level .o_cc4 .btn-outline-secondary.active:focus, .o_colored_level .o_cc4 .btn-outline-secondary.dropdown-toggle.show:focus{box-shadow: 0 0 0 0.25rem rgba(243, 242, 242, 0.5);}.o_cc4 .btn-outline-secondary:disabled, .o_cc4 .btn-outline-secondary.o_wysiwyg_loader, .o_cc4 .btn-outline-secondary.disabled, .o_colored_level .o_cc4 .btn-outline-secondary:disabled, .o_colored_level .o_cc4 .btn-outline-secondary.disabled{color: #F3F2F2; background-color: transparent;}.o_cc4 .nav-pills .nav-link.active, .o_cc4 .nav-pills .show > .nav-link, .o_colored_level .o_cc4 .nav-pills .nav-link.active, .o_colored_level .o_cc4 .nav-pills .show > .nav-link{background-color: #111827; color: #FFFFFF;}.o_cc4 .dropdown-menu .dropdown-item.active, .o_cc4 .dropdown-menu .dropdown-item.active h6, .o_cc4 .dropdown-menu .dropdown-item.active .h6, .o_cc4 .dropdown-menu .dropdown-item:active, .o_cc4 .dropdown-menu .dropdown-item:active h6, .o_cc4 .dropdown-menu .dropdown-item:active .h6, .o_colored_level .o_cc4 .dropdown-menu .dropdown-item.active, .o_colored_level .o_cc4 .dropdown-menu .dropdown-item.active h6, .o_colored_level .o_cc4 .dropdown-menu .dropdown-item:active, .o_colored_level .o_cc4 .dropdown-menu .dropdown-item:active h6{background-color: #111827; color: #FFFFFF !important;}.o_cc4 .dropdown-menu .dropdown-item.active:hover, .o_cc4 .dropdown-menu .dropdown-item.active:focus, .o_cc4 .dropdown-menu .dropdown-item.active h6:hover, .o_cc4 .dropdown-menu .dropdown-item.active .h6:hover, .o_cc4 .dropdown-menu .dropdown-item.active h6:focus, .o_cc4 .dropdown-menu .dropdown-item.active .h6:focus, .o_cc4 .dropdown-menu .dropdown-item:active:hover, .o_cc4 .dropdown-menu .dropdown-item:active:focus, .o_cc4 .dropdown-menu .dropdown-item:active h6:hover, .o_cc4 .dropdown-menu .dropdown-item:active .h6:hover, .o_cc4 .dropdown-menu .dropdown-item:active h6:focus, .o_cc4 .dropdown-menu .dropdown-item:active .h6:focus, .o_colored_level .o_cc4 .dropdown-menu .dropdown-item.active:hover, .o_colored_level .o_cc4 .dropdown-menu .dropdown-item.active:focus, .o_colored_level .o_cc4 .dropdown-menu .dropdown-item.active h6:hover, .o_colored_level .o_cc4 .dropdown-menu .dropdown-item.active h6:focus, .o_colored_level .o_cc4 .dropdown-menu .dropdown-item:active:hover, .o_colored_level .o_cc4 .dropdown-menu .dropdown-item:active:focus, .o_colored_level .o_cc4 .dropdown-menu .dropdown-item:active h6:hover, .o_colored_level .o_cc4 .dropdown-menu .dropdown-item:active h6:focus{color: #FFFFFF !important;}.o_cc4 a.list-group-item, .o_colored_level .o_cc4 a.list-group-item{color: #111827;}.o_cc4 a.list-group-item.active, .o_colored_level .o_cc4 a.list-group-item.active{background-color: #111827; color: #FFFFFF; border-color: #111827;}.o_cc5{background-color: #111827; color: #FFFFFF; --o-cc-bg: #111827;}.o_cc5 .text-muted, .o_colored_level .o_cc5 .text-muted{color: rgba(255, 255, 255, 0.7) !important;}.o_cc5 h1, .o_cc5 .h1, .o_cc5 h2, .o_cc5 .h2, .o_cc5 h3, .o_cc5 .h3, .o_cc5 h4, .o_cc5 .h4, .o_cc5 h5, .o_cc5 .h5, .o_cc5 h6, .o_cc5 .h6, .o_colored_level .o_cc5 h1, .o_colored_level .o_cc5 h2, .o_colored_level .o_cc5 h3, .o_colored_level .o_cc5 h4, .o_colored_level .o_cc5 h5, .o_colored_level .o_cc5 h6{color: #FFFFFF;}.o_cc5 a:not(.btn), .o_cc5 .btn-link, .o_colored_level .o_cc5 a:not(.btn), .o_colored_level .o_cc5 .btn-link{color: #b18aa7;}.o_cc5 a:not(.btn):hover, .o_cc5 .btn-link:hover, .o_colored_level .o_cc5 a:not(.btn):hover, .o_colored_level .o_cc5 .btn-link:hover{color: #905f83;}.o_cc5 .btn-fill-primary, .o_cc5 .btn-primary, .o_colored_level .o_cc5 .btn-fill-primary{color: #FFFFFF; background-color: #714B67; border-color: #714B67;}.o_cc5 .btn-fill-primary:hover, .o_cc5 .btn-primary:hover, .o_colored_level .o_cc5 .btn-fill-primary:hover{color: #FFFFFF; background-color: #604058; border-color: #5a3c52;}.btn-check:focus + .o_cc5 .btn-fill-primary, .btn-check:focus + .o_cc5 .btn-primary, .o_cc5 .btn-fill-primary:focus, .o_cc5 .btn-primary:focus, .btn-check:focus + .o_colored_level .o_cc5 .btn-fill-primary, .o_colored_level .o_cc5 .btn-fill-primary:focus{color: #FFFFFF; background-color: #604058; border-color: #5a3c52; box-shadow: 0 0 0 0.25rem rgba(134, 102, 126, 0.5);}.btn-check:checked + .o_cc5 .btn-fill-primary, .btn-check:checked + .o_cc5 .btn-primary, .btn-check:active + .o_cc5 .btn-fill-primary, .btn-check:active + .o_cc5 .btn-primary, .o_cc5 .btn-fill-primary:active, .o_cc5 .btn-primary:active, .o_cc5 .btn-fill-primary.active, .o_cc5 .active.btn-primary, .show > .o_cc5 .btn-fill-primary.dropdown-toggle, .show > .o_cc5 .dropdown-toggle.btn-primary, .btn-check:checked + .o_colored_level .o_cc5 .btn-fill-primary, .btn-check:active + .o_colored_level .o_cc5 .btn-fill-primary, .o_colored_level .o_cc5 .btn-fill-primary:active, .o_colored_level .o_cc5 .btn-fill-primary.active, .show > .o_colored_level .o_cc5 .btn-fill-primary.dropdown-toggle{color: #FFFFFF; background-color: #5a3c52; border-color: #55384d;}.btn-check:checked + .o_cc5 .btn-fill-primary:focus, .btn-check:checked + .o_cc5 .btn-primary:focus, .btn-check:active + .o_cc5 .btn-fill-primary:focus, .btn-check:active + .o_cc5 .btn-primary:focus, .o_cc5 .btn-fill-primary:active:focus, .o_cc5 .btn-primary:active:focus, .o_cc5 .btn-fill-primary.active:focus, .o_cc5 .active.btn-primary:focus, .show > .o_cc5 .btn-fill-primary.dropdown-toggle:focus, .show > .o_cc5 .dropdown-toggle.btn-primary:focus, .btn-check:checked + .o_colored_level .o_cc5 .btn-fill-primary:focus, .btn-check:active + .o_colored_level .o_cc5 .btn-fill-primary:focus, .o_colored_level .o_cc5 .btn-fill-primary:active:focus, .o_colored_level .o_cc5 .btn-fill-primary.active:focus, .show > .o_colored_level .o_cc5 .btn-fill-primary.dropdown-toggle:focus{box-shadow: 0 0 0 0.25rem rgba(134, 102, 126, 0.5);}.o_cc5 .btn-fill-primary:disabled, .o_cc5 .btn-fill-primary.o_wysiwyg_loader, .o_cc5 .btn-primary:disabled, .o_cc5 .btn-primary.o_wysiwyg_loader, .o_cc5 .btn-fill-primary.disabled, .o_cc5 .disabled.btn-primary, .o_colored_level .o_cc5 .btn-fill-primary:disabled, .o_colored_level .o_cc5 .btn-fill-primary.disabled{color: #FFFFFF; background-color: #714B67; border-color: #714B67;}.o_cc5 .btn-outline-primary, .o_colored_level .o_cc5 .btn-outline-primary{color: #714B67; border-color: #714B67;}.o_cc5 .btn-outline-primary:hover, .o_colored_level .o_cc5 .btn-outline-primary:hover{color: #FFFFFF; background-color: #714B67; border-color: #714B67;}.btn-check:focus + .o_cc5 .btn-outline-primary, .o_cc5 .btn-outline-primary:focus, .btn-check:focus + .o_colored_level .o_cc5 .btn-outline-primary, .o_colored_level .o_cc5 .btn-outline-primary:focus{box-shadow: 0 0 0 0.25rem rgba(113, 75, 103, 0.5);}.btn-check:checked + .o_cc5 .btn-outline-primary, .btn-check:active + .o_cc5 .btn-outline-primary, .o_cc5 .btn-outline-primary:active, .o_cc5 .btn-outline-primary.active, .o_cc5 .btn-outline-primary.dropdown-toggle.show, .btn-check:checked + .o_colored_level .o_cc5 .btn-outline-primary, .btn-check:active + .o_colored_level .o_cc5 .btn-outline-primary, .o_colored_level .o_cc5 .btn-outline-primary:active, .o_colored_level .o_cc5 .btn-outline-primary.active, .o_colored_level .o_cc5 .btn-outline-primary.dropdown-toggle.show{color: #FFFFFF; background-color: #714B67; border-color: #714B67;}.btn-check:checked + .o_cc5 .btn-outline-primary:focus, .btn-check:active + .o_cc5 .btn-outline-primary:focus, .o_cc5 .btn-outline-primary:active:focus, .o_cc5 .btn-outline-primary.active:focus, .o_cc5 .btn-outline-primary.dropdown-toggle.show:focus, .btn-check:checked + .o_colored_level .o_cc5 .btn-outline-primary:focus, .btn-check:active + .o_colored_level .o_cc5 .btn-outline-primary:focus, .o_colored_level .o_cc5 .btn-outline-primary:active:focus, .o_colored_level .o_cc5 .btn-outline-primary.active:focus, .o_colored_level .o_cc5 .btn-outline-primary.dropdown-toggle.show:focus{box-shadow: 0 0 0 0.25rem rgba(113, 75, 103, 0.5);}.o_cc5 .btn-outline-primary:disabled, .o_cc5 .btn-outline-primary.o_wysiwyg_loader, .o_cc5 .btn-outline-primary.disabled, .o_colored_level .o_cc5 .btn-outline-primary:disabled, .o_colored_level .o_cc5 .btn-outline-primary.disabled{color: #714B67; background-color: transparent;}.o_cc5 .btn-fill-secondary, .o_cc5 .btn-secondary, .o_colored_level .o_cc5 .btn-fill-secondary{color: #000000; background-color: #F3F2F2; border-color: #F3F2F2;}.o_cc5 .btn-fill-secondary:hover, .o_cc5 .btn-secondary:hover, .o_colored_level .o_cc5 .btn-fill-secondary:hover{color: #000000; background-color: #f5f4f4; border-color: #f4f3f3;}.btn-check:focus + .o_cc5 .btn-fill-secondary, .btn-check:focus + .o_cc5 .btn-secondary, .o_cc5 .btn-fill-secondary:focus, .o_cc5 .btn-secondary:focus, .btn-check:focus + .o_colored_level .o_cc5 .btn-fill-secondary, .o_colored_level .o_cc5 .btn-fill-secondary:focus{color: #000000; background-color: #f5f4f4; border-color: #f4f3f3; box-shadow: 0 0 0 0.25rem rgba(207, 206, 206, 0.5);}.btn-check:checked + .o_cc5 .btn-fill-secondary, .btn-check:checked + .o_cc5 .btn-secondary, .btn-check:active + .o_cc5 .btn-fill-secondary, .btn-check:active + .o_cc5 .btn-secondary, .o_cc5 .btn-fill-secondary:active, .o_cc5 .btn-secondary:active, .o_cc5 .btn-fill-secondary.active, .o_cc5 .active.btn-secondary, .show > .o_cc5 .btn-fill-secondary.dropdown-toggle, .show > .o_cc5 .dropdown-toggle.btn-secondary, .btn-check:checked + .o_colored_level .o_cc5 .btn-fill-secondary, .btn-check:active + .o_colored_level .o_cc5 .btn-fill-secondary, .o_colored_level .o_cc5 .btn-fill-secondary:active, .o_colored_level .o_cc5 .btn-fill-secondary.active, .show > .o_colored_level .o_cc5 .btn-fill-secondary.dropdown-toggle{color: #000000; background-color: whitesmoke; border-color: #f4f3f3;}.btn-check:checked + .o_cc5 .btn-fill-secondary:focus, .btn-check:checked + .o_cc5 .btn-secondary:focus, .btn-check:active + .o_cc5 .btn-fill-secondary:focus, .btn-check:active + .o_cc5 .btn-secondary:focus, .o_cc5 .btn-fill-secondary:active:focus, .o_cc5 .btn-secondary:active:focus, .o_cc5 .btn-fill-secondary.active:focus, .o_cc5 .active.btn-secondary:focus, .show > .o_cc5 .btn-fill-secondary.dropdown-toggle:focus, .show > .o_cc5 .dropdown-toggle.btn-secondary:focus, .btn-check:checked + .o_colored_level .o_cc5 .btn-fill-secondary:focus, .btn-check:active + .o_colored_level .o_cc5 .btn-fill-secondary:focus, .o_colored_level .o_cc5 .btn-fill-secondary:active:focus, .o_colored_level .o_cc5 .btn-fill-secondary.active:focus, .show > .o_colored_level .o_cc5 .btn-fill-secondary.dropdown-toggle:focus{box-shadow: 0 0 0 0.25rem rgba(207, 206, 206, 0.5);}.o_cc5 .btn-fill-secondary:disabled, .o_cc5 .btn-fill-secondary.o_wysiwyg_loader, .o_cc5 .btn-secondary:disabled, .o_cc5 .btn-secondary.o_wysiwyg_loader, .o_cc5 .btn-fill-secondary.disabled, .o_cc5 .disabled.btn-secondary, .o_colored_level .o_cc5 .btn-fill-secondary:disabled, .o_colored_level .o_cc5 .btn-fill-secondary.disabled{color: #000000; background-color: #F3F2F2; border-color: #F3F2F2;}.o_cc5 .btn-outline-secondary, .o_colored_level .o_cc5 .btn-outline-secondary{color: #F3F2F2; border-color: #F3F2F2;}.o_cc5 .btn-outline-secondary:hover, .o_colored_level .o_cc5 .btn-outline-secondary:hover{color: #000000; background-color: #F3F2F2; border-color: #F3F2F2;}.btn-check:focus + .o_cc5 .btn-outline-secondary, .o_cc5 .btn-outline-secondary:focus, .btn-check:focus + .o_colored_level .o_cc5 .btn-outline-secondary, .o_colored_level .o_cc5 .btn-outline-secondary:focus{box-shadow: 0 0 0 0.25rem rgba(243, 242, 242, 0.5);}.btn-check:checked + .o_cc5 .btn-outline-secondary, .btn-check:active + .o_cc5 .btn-outline-secondary, .o_cc5 .btn-outline-secondary:active, .o_cc5 .btn-outline-secondary.active, .o_cc5 .btn-outline-secondary.dropdown-toggle.show, .btn-check:checked + .o_colored_level .o_cc5 .btn-outline-secondary, .btn-check:active + .o_colored_level .o_cc5 .btn-outline-secondary, .o_colored_level .o_cc5 .btn-outline-secondary:active, .o_colored_level .o_cc5 .btn-outline-secondary.active, .o_colored_level .o_cc5 .btn-outline-secondary.dropdown-toggle.show{color: #000000; background-color: #F3F2F2; border-color: #F3F2F2;}.btn-check:checked + .o_cc5 .btn-outline-secondary:focus, .btn-check:active + .o_cc5 .btn-outline-secondary:focus, .o_cc5 .btn-outline-secondary:active:focus, .o_cc5 .btn-outline-secondary.active:focus, .o_cc5 .btn-outline-secondary.dropdown-toggle.show:focus, .btn-check:checked + .o_colored_level .o_cc5 .btn-outline-secondary:focus, .btn-check:active + .o_colored_level .o_cc5 .btn-outline-secondary:focus, .o_colored_level .o_cc5 .btn-outline-secondary:active:focus, .o_colored_level .o_cc5 .btn-outline-secondary.active:focus, .o_colored_level .o_cc5 .btn-outline-secondary.dropdown-toggle.show:focus{box-shadow: 0 0 0 0.25rem rgba(243, 242, 242, 0.5);}.o_cc5 .btn-outline-secondary:disabled, .o_cc5 .btn-outline-secondary.o_wysiwyg_loader, .o_cc5 .btn-outline-secondary.disabled, .o_colored_level .o_cc5 .btn-outline-secondary:disabled, .o_colored_level .o_cc5 .btn-outline-secondary.disabled{color: #F3F2F2; background-color: transparent;}.o_cc5 .nav-pills .nav-link.active, .o_cc5 .nav-pills .show > .nav-link, .o_colored_level .o_cc5 .nav-pills .nav-link.active, .o_colored_level .o_cc5 .nav-pills .show > .nav-link{background-color: #714B67; color: #FFFFFF;}.o_cc5 .dropdown-menu .dropdown-item.active, .o_cc5 .dropdown-menu .dropdown-item.active h6, .o_cc5 .dropdown-menu .dropdown-item.active .h6, .o_cc5 .dropdown-menu .dropdown-item:active, .o_cc5 .dropdown-menu .dropdown-item:active h6, .o_cc5 .dropdown-menu .dropdown-item:active .h6, .o_colored_level .o_cc5 .dropdown-menu .dropdown-item.active, .o_colored_level .o_cc5 .dropdown-menu .dropdown-item.active h6, .o_colored_level .o_cc5 .dropdown-menu .dropdown-item:active, .o_colored_level .o_cc5 .dropdown-menu .dropdown-item:active h6{background-color: #714B67; color: #FFFFFF !important;}.o_cc5 .dropdown-menu .dropdown-item.active:hover, .o_cc5 .dropdown-menu .dropdown-item.active:focus, .o_cc5 .dropdown-menu .dropdown-item.active h6:hover, .o_cc5 .dropdown-menu .dropdown-item.active .h6:hover, .o_cc5 .dropdown-menu .dropdown-item.active h6:focus, .o_cc5 .dropdown-menu .dropdown-item.active .h6:focus, .o_cc5 .dropdown-menu .dropdown-item:active:hover, .o_cc5 .dropdown-menu .dropdown-item:active:focus, .o_cc5 .dropdown-menu .dropdown-item:active h6:hover, .o_cc5 .dropdown-menu .dropdown-item:active .h6:hover, .o_cc5 .dropdown-menu .dropdown-item:active h6:focus, .o_cc5 .dropdown-menu .dropdown-item:active .h6:focus, .o_colored_level .o_cc5 .dropdown-menu .dropdown-item.active:hover, .o_colored_level .o_cc5 .dropdown-menu .dropdown-item.active:focus, .o_colored_level .o_cc5 .dropdown-menu .dropdown-item.active h6:hover, .o_colored_level .o_cc5 .dropdown-menu .dropdown-item.active h6:focus, .o_colored_level .o_cc5 .dropdown-menu .dropdown-item:active:hover, .o_colored_level .o_cc5 .dropdown-menu .dropdown-item:active:focus, .o_colored_level .o_cc5 .dropdown-menu .dropdown-item:active h6:hover, .o_colored_level .o_cc5 .dropdown-menu .dropdown-item:active h6:focus{color: #FFFFFF !important;}.o_cc5 a.list-group-item, .o_colored_level .o_cc5 a.list-group-item{color: #714B67;}.o_cc5 a.list-group-item.active, .o_colored_level .o_cc5 a.list-group-item.active{background-color: #714B67; color: #FFFFFF; border-color: #714B67;}.btn-custom:hover, .btn-fill-custom:hover{filter: invert(0.2);}.btn-outline-custom:not(:hover){background-color: transparent !important; background-image: none !important;}section, .oe_img_bg, [data-oe-shape-data], section > *, .oe_img_bg > *, [data-oe-shape-data] > *{position: relative;}.o_we_shape, .o_we_bg_filter{position: absolute; top: 0; left: 0; bottom: 0; right: 0; position: absolute !important; display: block; overflow: hidden; background-repeat: no-repeat; pointer-events: none;}.o_full_screen_height, .cover_full, .o_half_screen_height, .cover_mid{display: -webkit-box; display: -webkit-flex; display: flex; -webkit-box-orient: vertical; -webkit-box-direction: normal; -webkit-flex-direction: column; flex-direction: column; justify-content: space-around; min-height: 100vh !important;}.o_half_screen_height, .cover_mid{min-height: 55vh !important;}@media (min-width: 992px){.o_container_small{max-width: 720px;}}.oe_img_bg{background-size: cover; background-repeat: no-repeat;}.oe_img_bg.o_bg_img_opt_repeat{background-size: auto; background-repeat: repeat;}.oe_img_bg.o_bg_img_center{background-position: center;}.text-gradient{-webkit-background-clip: text; -webkit-text-fill-color: transparent;}.text-gradient .o_animated_text, .text-gradient .o_animated_text *, .text-gradient.o_animated_text *, .text-gradient .o_text_highlight, .text-gradient .o_text_highlight *, .text-gradient.o_text_highlight *{background-image: inherit; -webkit-background-clip: inherit; -webkit-text-fill-color: inherit;}.odoo-editor-editable.odoo-editor-qweb t, .odoo-editor-editable.odoo-editor-qweb [t-if], .odoo-editor-editable.odoo-editor-qweb [t-elif], .odoo-editor-editable.odoo-editor-qweb [t-else], .odoo-editor-editable.odoo-editor-qweb [t-foreach], .o_readonly t, .o_readonly [t-if], .o_readonly [t-elif], .o_readonly [t-else], .o_readonly [t-foreach]{background-color: rgba(0, 0, 102, 0.1) !important;}.odoo-editor-editable.odoo-editor-qweb t, .odoo-editor-editable.odoo-editor-qweb [t-esc], .odoo-editor-editable.odoo-editor-qweb [t-out], .odoo-editor-editable.odoo-editor-qweb [t-raw], .o_readonly t, .o_readonly [t-esc], .o_readonly [t-out], .o_readonly [t-raw]{border-radius: 2px;}.odoo-editor-editable.odoo-editor-qweb [t-esc], .odoo-editor-editable.odoo-editor-qweb [t-out], .odoo-editor-editable.odoo-editor-qweb [t-raw], .o_readonly [t-esc], .o_readonly [t-out], .o_readonly [t-raw]{background-color: rgba(36, 154, 255, 0.16) !important;}.odoo-editor-editable.odoo-editor-qweb [t-esc]:empty::before, .o_readonly [t-esc]:empty::before{content: attr(t-esc);}.odoo-editor-editable.odoo-editor-qweb [t-raw]:empty::before, .o_readonly [t-raw]:empty::before{content: attr(t-raw);}.odoo-editor-editable.odoo-editor-qweb [t-out]:empty::before, .o_readonly [t-out]:empty::before{content: attr(t-out);}.odoo-editor-editable.odoo-editor-qweb t[t-set], .o_readonly t[t-set]{display: none;}.odoo-editor-editable.odoo-editor-qweb t[data-oe-t-inline], .o_readonly t[data-oe-t-inline]{display: inline;}.odoo-editor-editable.odoo-editor-qweb t:not([data-oe-t-inline]), .o_readonly t:not([data-oe-t-inline]){display: block;}.odoo-editor-editable.odoo-editor-qweb t[data-oe-t-inline]:not([data-oe-t-group-active]), .o_readonly t[data-oe-t-inline]:not([data-oe-t-group-active]){display: unset;}.odoo-editor-editable.odoo-editor-qweb [data-oe-t-group]:not([data-oe-t-group-active]), .o_readonly [data-oe-t-group]:not([data-oe-t-group-active]){display: none !important;}.odoo-editor-editable.odoo-editor-qweb [data-oe-t-group][data-oe-t-selectable], .o_readonly [data-oe-t-group][data-oe-t-selectable]{outline: 1px dashed rgba(0, 0, 102, 0.4) !important;}.oe-qweb-select{position: absolute; z-index: 1056; background-color: white;}.o_we_shape.o_we_animated{will-change: transform;}.o_we_shape.o_web_editor_Airy_01{background-image: url("/web_editor/shape/web_editor/Airy/01.svg?c1=%23714B67"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Airy_02{background-image: url("/web_editor/shape/web_editor/Airy/02.svg?c1=%23714B67"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Airy_03{background-image: url("/web_editor/shape/web_editor/Airy/03.svg?c5=%23111827"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Airy_03_001{background-image: url("/web_editor/shape/web_editor/Airy/03_001.svg?c5=%23111827"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Airy_04{background-image: url("/web_editor/shape/web_editor/Airy/04.svg?c1=%23714B67"); background-position: center; background-size: 100% 100%; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Airy_04_001{background-image: url("/web_editor/shape/web_editor/Airy/04_001.svg?c1=%23714B67"); background-position: center; background-size: 100% 100%; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Airy_05{background-image: url("/web_editor/shape/web_editor/Airy/05.svg?c1=%23714B67"); background-position: center; background-size: 100% 100%; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Airy_05_001{background-image: url("/web_editor/shape/web_editor/Airy/05_001.svg?c1=%23714B67"); background-position: center; background-size: 100% 100%; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Airy_06{background-image: url("/web_editor/shape/web_editor/Airy/06.svg?c2=%238595A2"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Airy_07{background-image: url("/web_editor/shape/web_editor/Airy/07.svg?c2=%238595A2"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Airy_08{background-image: url("/web_editor/shape/web_editor/Airy/08.svg?c1=%23714B67"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Airy_09{background-image: url("/web_editor/shape/web_editor/Airy/09.svg?c1=%23714B67"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Airy_10{background-image: url("/web_editor/shape/web_editor/Airy/10.svg?c5=%23111827"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Airy_11{background-image: url("/web_editor/shape/web_editor/Airy/11.svg?c5=%23111827"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Airy_12{background-image: url("/web_editor/shape/web_editor/Airy/12.svg?c1=%23714B67&c3=%23F3F2F2"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Airy_12_001{background-image: url("/web_editor/shape/web_editor/Airy/12_001.svg?c1=%23714B67&c3=%23F3F2F2"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Airy_13{background-image: url("/web_editor/shape/web_editor/Airy/13.svg?c1=%23714B67&c4=%23FFFFFF"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Airy_13_001{background-image: url("/web_editor/shape/web_editor/Airy/13_001.svg?c1=%23714B67&c4=%23FFFFFF"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Airy_14{background-image: url("/web_editor/shape/web_editor/Airy/14.svg?c1=%23714B67&c4=%23FFFFFF"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Blobs_01{background-image: url("/web_editor/shape/web_editor/Blobs/01.svg?c2=%238595A2"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Blobs_01_001{background-image: url("/web_editor/shape/web_editor/Blobs/01_001.svg?c2=%238595A2"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Blobs_02{background-image: url("/web_editor/shape/web_editor/Blobs/02.svg?c1=%23714B67&c2=%238595A2"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Blobs_03{background-image: url("/web_editor/shape/web_editor/Blobs/03.svg?c2=%238595A2"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Blobs_04{background-image: url("/web_editor/shape/web_editor/Blobs/04.svg?c5=%23111827"); background-position: center; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Blobs_05{background-image: url("/web_editor/shape/web_editor/Blobs/05.svg?c1=%23714B67"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Blobs_06{background-image: url("/web_editor/shape/web_editor/Blobs/06.svg?c1=%23714B67"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Blobs_07{background-image: url("/web_editor/shape/web_editor/Blobs/07.svg?c5=%23111827"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Blobs_08{background-image: url("/web_editor/shape/web_editor/Blobs/08.svg?c1=%23714B67"); background-position: right; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Blobs_09{background-image: url("/web_editor/shape/web_editor/Blobs/09.svg?c3=%23F3F2F2"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Blobs_10{background-image: url("/web_editor/shape/web_editor/Blobs/10.svg?c1=%23714B67&c5=%23111827"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Blobs_10_001{background-image: url("/web_editor/shape/web_editor/Blobs/10_001.svg?c1=%23714B67"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Blobs_11{background-image: url("/web_editor/shape/web_editor/Blobs/11.svg?c1=%23714B67"); background-position: center; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Blobs_12{background-image: url("/web_editor/shape/web_editor/Blobs/12.svg?c1=%23714B67"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Blocks_01{background-image: url("/web_editor/shape/web_editor/Blocks/01.svg?c1=%23714B67&c3=%23F3F2F2&c5=%23111827"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Blocks_01_001{background-image: url("/web_editor/shape/web_editor/Blocks/01_001.svg?c1=%23714B67&c3=%23F3F2F2&c5=%23111827"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Blocks_02{background-image: url("/web_editor/shape/web_editor/Blocks/02.svg?c1=%23714B67&c3=%23F3F2F2&c5=%23111827"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Blocks_02_001{background-image: url("/web_editor/shape/web_editor/Blocks/02_001.svg?c1=%23714B67&c3=%23F3F2F2&c5=%23111827"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Blocks_03{background-image: url("/web_editor/shape/web_editor/Blocks/03.svg?c1=%23714B67&c4=%23FFFFFF"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Blocks_04{background-image: url("/web_editor/shape/web_editor/Blocks/04.svg?c1=%23714B67&c2=%238595A2&c3=%23F3F2F2&c5=%23111827"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Bold_01{background-image: url("/web_editor/shape/web_editor/Bold/01.svg?c2=%238595A2"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Bold_02{background-image: url("/web_editor/shape/web_editor/Bold/02.svg?c1=%23714B67&c2=%238595A2&c3=%23F3F2F2"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Bold_03{background-image: url("/web_editor/shape/web_editor/Bold/03.svg?c1=%23714B67&c3=%23F3F2F2&c5=%23111827"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Bold_04{background-image: url("/web_editor/shape/web_editor/Bold/04.svg?c2=%238595A2&c3=%23F3F2F2"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Bold_05{background-image: url("/web_editor/shape/web_editor/Bold/05.svg?c5=%23111827"); background-position: center; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Bold_05_001{background-image: url("/web_editor/shape/web_editor/Bold/05_001.svg?c3=%23F3F2F2"); background-position: center; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Bold_06{background-image: url("/web_editor/shape/web_editor/Bold/06.svg?c5=%23111827"); background-position: center; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Bold_06_001{background-image: url("/web_editor/shape/web_editor/Bold/06_001.svg?c3=%23F3F2F2"); background-position: center; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Bold_07{background-image: url("/web_editor/shape/web_editor/Bold/07.svg?c1=%23714B67&c2=%238595A2"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Bold_07_001{background-image: url("/web_editor/shape/web_editor/Bold/07_001.svg?c1=%23714B67&c2=%238595A2"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Bold_08{background-image: url("/web_editor/shape/web_editor/Bold/08.svg?c1=%23714B67"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Bold_09{background-image: url("/web_editor/shape/web_editor/Bold/09.svg?c2=%238595A2&c3=%23F3F2F2"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Bold_10{background-image: url("/web_editor/shape/web_editor/Bold/10.svg?c1=%23714B67&c3=%23F3F2F2&c4=%23FFFFFF&c5=%23111827"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Bold_10_001{background-image: url("/web_editor/shape/web_editor/Bold/10_001.svg?c1=%23714B67&c4=%23FFFFFF&c5=%23111827"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Bold_11{background-image: url("/web_editor/shape/web_editor/Bold/11.svg?c1=%23714B67&c2=%238595A2&c3=%23F3F2F2"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Bold_11_001{background-image: url("/web_editor/shape/web_editor/Bold/11_001.svg?c1=%23714B67&c2=%238595A2"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Bold_12{background-image: url("/web_editor/shape/web_editor/Bold/12.svg?c1=%23714B67&c2=%238595A2&c5=%23111827"); background-position: center; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Bold_12_001{background-image: url("/web_editor/shape/web_editor/Bold/12_001.svg?c1=%23714B67&c2=%238595A2&c5=%23111827"); background-position: center; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Floats_01{background-image: url("/web_editor/shape/web_editor/Floats/01.svg?c1=%23714B67&c2=%238595A2&c3=%23F3F2F2&c4=%23FFFFFF&c5=%23111827"); background-position: center right; background-size: auto 100%; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Floats_02{background-image: url("/web_editor/shape/web_editor/Floats/02.svg?c1=%23714B67&c2=%238595A2&c3=%23F3F2F2&c5=%23111827"); background-position: center; background-size: 100%; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Floats_03{background-image: url("/web_editor/shape/web_editor/Floats/03.svg?c1=%23714B67&c2=%238595A2&c3=%23F3F2F2&c5=%23111827"); background-position: center; background-size: 100%; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Floats_04{background-image: url("/web_editor/shape/web_editor/Floats/04.svg?c1=%23714B67&c2=%238595A2&c4=%23FFFFFF&c5=%23111827"); background-position: center; background-size: 100%; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Floats_05{background-image: url("/web_editor/shape/web_editor/Floats/05.svg?c1=%23714B67&c2=%238595A2&c3=%23F3F2F2&c5=%23111827"); background-position: center; background-size: 100%; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Floats_06{background-image: url("/web_editor/shape/web_editor/Floats/06.svg?c1=%23714B67&c2=%238595A2&c3=%23F3F2F2&c5=%23111827"); background-position: center; background-size: auto 100%; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Floats_07{background-image: url("/web_editor/shape/web_editor/Floats/07.svg?c1=%23714B67&c2=%238595A2&c3=%23F3F2F2&c5=%23111827"); background-position: right bottom; background-size: auto 100%; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Floats_08{background-image: url("/web_editor/shape/web_editor/Floats/08.svg?c1=%23714B67&c2=%238595A2&c3=%23F3F2F2&c5=%23111827"); background-position: top left; background-size: auto 100%; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Floats_09{background-image: url("/web_editor/shape/web_editor/Floats/09.svg?c1=%23714B67&c2=%238595A2&c3=%23F3F2F2"); background-position: center right; background-size: auto 100%; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Floats_10{background-image: url("/web_editor/shape/web_editor/Floats/10.svg?c1=%23714B67&c2=%238595A2&c3=%23F3F2F2&c5=%23111827"); background-position: center; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Floats_11{background-image: url("/web_editor/shape/web_editor/Floats/11.svg?c1=%23714B67&c3=%23F3F2F2"); background-position: center; background-size: 100% 100%; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Floats_12{background-image: url("/web_editor/shape/web_editor/Floats/12.svg?c1=%23714B67&c2=%238595A2&c3=%23F3F2F2&c5=%23111827"); background-position: top; background-size: 100% auto; background-repeat: no-repeat repeat;}.o_we_shape.o_web_editor_Floats_13{background-image: url("/web_editor/shape/web_editor/Floats/13.svg?c1=%23714B67&c2=%238595A2&c5=%23111827"); background-position: center; background-size: auto 100%; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Floats_14{background-image: url("/web_editor/shape/web_editor/Floats/14.svg?c1=%23714B67&c2=%238595A2&c3=%23F3F2F2&c5=%23111827"); background-position: center; background-size: 100%; background-repeat: no-repeat repeat;}.o_we_shape.o_web_editor_Origins_01{background-image: url("/web_editor/shape/web_editor/Origins/01.svg?c2=%238595A2&c5=%23111827"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Origins_02{background-image: url("/web_editor/shape/web_editor/Origins/02.svg?c3=%23F3F2F2"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Origins_02_001{background-image: url("/web_editor/shape/web_editor/Origins/02_001.svg?c4=%23FFFFFF&c5=%23111827"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Origins_03{background-image: url("/web_editor/shape/web_editor/Origins/03.svg?c3=%23F3F2F2"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Origins_04{background-image: url("/web_editor/shape/web_editor/Origins/04.svg?c3=%23F3F2F2"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Origins_04_001{background-image: url("/web_editor/shape/web_editor/Origins/04_001.svg?c3=%23F3F2F2"); background-position: top; background-size: 100% 100%; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Origins_05{background-image: url("/web_editor/shape/web_editor/Origins/05.svg?c3=%23F3F2F2"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Origins_06{background-image: url("/web_editor/shape/web_editor/Origins/06.svg?c3=%23F3F2F2"); background-position: center; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Origins_06_001{background-image: url("/web_editor/shape/web_editor/Origins/06_001.svg?c3=%23F3F2F2&c4=%23FFFFFF"); background-position: center; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Origins_07{background-image: url("/web_editor/shape/web_editor/Origins/07.svg?c3=%23F3F2F2"); background-position: center; background-size: 100% 100%; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Origins_07_001{background-image: url("/web_editor/shape/web_editor/Origins/07_001.svg?c3=%23F3F2F2&c5=%23111827"); background-position: center; background-size: 100% 100%; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Origins_07_002{background-image: url("/web_editor/shape/web_editor/Origins/07_002.svg?c3=%23F3F2F2&c4=%23FFFFFF&c5=%23111827"); background-position: center; background-size: 100% 100%; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Origins_08{background-image: url("/web_editor/shape/web_editor/Origins/08.svg?c3=%23F3F2F2"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Origins_09{background-image: url("/web_editor/shape/web_editor/Origins/09.svg?c1=%23714B67&c5=%23111827"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Origins_09_001{background-image: url("/web_editor/shape/web_editor/Origins/09_001.svg?c3=%23F3F2F2"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Origins_10{background-image: url("/web_editor/shape/web_editor/Origins/10.svg?c2=%238595A2&c5=%23111827"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Origins_11{background-image: url("/web_editor/shape/web_editor/Origins/11.svg?c3=%23F3F2F2&c5=%23111827"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Origins_11_001{background-image: url("/web_editor/shape/web_editor/Origins/11_001.svg?c3=%23F3F2F2&c4=%23FFFFFF"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Origins_12{background-image: url("/web_editor/shape/web_editor/Origins/12.svg?c3=%23F3F2F2&c5=%23111827"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Origins_13{background-image: url("/web_editor/shape/web_editor/Origins/13.svg?c3=%23F3F2F2&c5=%23111827"); background-position: center; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Origins_14{background-image: url("/web_editor/shape/web_editor/Origins/14.svg?c4=%23FFFFFF"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Origins_14_001{background-image: url("/web_editor/shape/web_editor/Origins/14_001.svg?c3=%23F3F2F2&c4=%23FFFFFF"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Origins_15{background-image: url("/web_editor/shape/web_editor/Origins/15.svg?c4=%23FFFFFF"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Origins_16{background-image: url("/web_editor/shape/web_editor/Origins/16.svg?c3=%23F3F2F2"); background-position: center; background-size: 100% 100%; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Origins_17{background-image: url("/web_editor/shape/web_editor/Origins/17.svg?c3=%23F3F2F2"); background-position: center; background-size: 100% 100%; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Origins_18{background-image: url("/web_editor/shape/web_editor/Origins/18.svg?c1=%23714B67"); background-position: center; background-size: 100% 100%; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Rainy_01{background-image: url("/web_editor/shape/web_editor/Rainy/01.svg?c1=%23714B67&c5=%23111827"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Rainy_01_001{background-image: url("/web_editor/shape/web_editor/Rainy/01_001.svg?c1=%23714B67&c5=%23111827"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Rainy_02{background-image: url("/web_editor/shape/web_editor/Rainy/02.svg?c1=%23714B67&c4=%23FFFFFF&c5=%23111827"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Rainy_02_001{background-image: url("/web_editor/shape/web_editor/Rainy/02_001.svg?c1=%23714B67&c4=%23FFFFFF&c5=%23111827"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Rainy_03{background-image: url("/web_editor/shape/web_editor/Rainy/03.svg?c2=%238595A2&c4=%23FFFFFF&c5=%23111827"); background-position: top; background-size: 100% auto; background-repeat: no-repeat repeat;}.o_we_shape.o_web_editor_Rainy_03_001{background-image: url("/web_editor/shape/web_editor/Rainy/03_001.svg?c2=%238595A2&c5=%23111827"); background-position: top; background-size: 100% auto; background-repeat: no-repeat repeat;}.o_we_shape.o_web_editor_Rainy_04{background-image: url("/web_editor/shape/web_editor/Rainy/04.svg?c1=%23714B67&c5=%23111827"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Rainy_05{background-image: url("/web_editor/shape/web_editor/Rainy/05.svg?c1=%23714B67&c5=%23111827"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Rainy_05_001{background-image: url("/web_editor/shape/web_editor/Rainy/05_001.svg?c1=%23714B67"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Rainy_06{background-image: url("/web_editor/shape/web_editor/Rainy/06.svg?c1=%23714B67&c2=%238595A2&c3=%23F3F2F2"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Rainy_07{background-image: url("/web_editor/shape/web_editor/Rainy/07.svg?c1=%23714B67&c2=%238595A2&c3=%23F3F2F2"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Rainy_08{background-image: url("/web_editor/shape/web_editor/Rainy/08.svg?c1=%23714B67&c4=%23FFFFFF"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Rainy_08_001{background-image: url("/web_editor/shape/web_editor/Rainy/08_001.svg?c1=%23714B67&c4=%23FFFFFF"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Rainy_09{background-image: url("/web_editor/shape/web_editor/Rainy/09.svg?c1=%23714B67"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Rainy_09_001{background-image: url("/web_editor/shape/web_editor/Rainy/09_001.svg?c1=%23714B67"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Rainy_10{background-image: url("/web_editor/shape/web_editor/Rainy/10.svg?c1=%23714B67&c3=%23F3F2F2"); background-position: center; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_01{background-image: url("/web_editor/shape/web_editor/Wavy/01.svg?c4=%23FFFFFF"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_01_001{background-image: url("/web_editor/shape/web_editor/Wavy/01_001.svg?c3=%23F3F2F2"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_02{background-image: url("/web_editor/shape/web_editor/Wavy/02.svg?c4=%23FFFFFF"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_02_001{background-image: url("/web_editor/shape/web_editor/Wavy/02_001.svg?c3=%23F3F2F2"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_03{background-image: url("/web_editor/shape/web_editor/Wavy/03.svg?c1=%23714B67&c2=%238595A2"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_04{background-image: url("/web_editor/shape/web_editor/Wavy/04.svg?c1=%23714B67&c5=%23111827"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_05{background-image: url("/web_editor/shape/web_editor/Wavy/05.svg?c1=%23714B67&c5=%23111827"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_06{background-image: url("/web_editor/shape/web_editor/Wavy/06.svg?c1=%23714B67&c3=%23F3F2F2&c4=%23FFFFFF&c5=%23111827"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_06_001{background-image: url("/web_editor/shape/web_editor/Wavy/06_001.svg?c1=%23714B67&c3=%23F3F2F2&c5=%23111827"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_07{background-image: url("/web_editor/shape/web_editor/Wavy/07.svg?c3=%23F3F2F2"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_08{background-image: url("/web_editor/shape/web_editor/Wavy/08.svg?c2=%238595A2"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_09{background-image: url("/web_editor/shape/web_editor/Wavy/09.svg?c1=%23714B67&c5=%23111827"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_10{background-image: url("/web_editor/shape/web_editor/Wavy/10.svg?c1=%23714B67&c2=%238595A2"); background-position: center; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_11{background-image: url("/web_editor/shape/web_editor/Wavy/11.svg?c1=%23714B67&c4=%23FFFFFF"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_12{background-image: url("/web_editor/shape/web_editor/Wavy/12.svg?c1=%23714B67"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_12_001{background-image: url("/web_editor/shape/web_editor/Wavy/12_001.svg?c1=%23714B67"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_13{background-image: url("/web_editor/shape/web_editor/Wavy/13.svg?c4=%23FFFFFF"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_13_001{background-image: url("/web_editor/shape/web_editor/Wavy/13_001.svg?c1=%23714B67"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_14{background-image: url("/web_editor/shape/web_editor/Wavy/14.svg?c1=%23714B67&c3=%23F3F2F2"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_15{background-image: url("/web_editor/shape/web_editor/Wavy/15.svg?c1=%23714B67"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_16{background-image: url("/web_editor/shape/web_editor/Wavy/16.svg?c1=%23714B67"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_17{background-image: url("/web_editor/shape/web_editor/Wavy/17.svg?c1=%23714B67"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_18{background-image: url("/web_editor/shape/web_editor/Wavy/18.svg?c5=%23111827"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_19{background-image: url("/web_editor/shape/web_editor/Wavy/19.svg?c5=%23111827"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_20{background-image: url("/web_editor/shape/web_editor/Wavy/20.svg?c2=%238595A2"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_21{background-image: url("/web_editor/shape/web_editor/Wavy/21.svg?c2=%238595A2"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_22{background-image: url("/web_editor/shape/web_editor/Wavy/22.svg?c3=%23F3F2F2"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_23{background-image: url("/web_editor/shape/web_editor/Wavy/23.svg?c3=%23F3F2F2"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_24{background-image: url("/web_editor/shape/web_editor/Wavy/24.svg?c1=%23714B67&c2=%238595A2"); background-position: center; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_25{background-image: url("/web_editor/shape/web_editor/Wavy/25.svg?c1=%23714B67&c2=%238595A2"); background-position: top; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_26{background-image: url("/web_editor/shape/web_editor/Wavy/26.svg?c1=%23714B67&c2=%238595A2"); background-position: bottom right; background-size: auto 100%; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_27{background-image: url("/web_editor/shape/web_editor/Wavy/27.svg?c1=%23714B67&c2=%238595A2"); background-position: center; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Wavy_28{background-image: url("/web_editor/shape/web_editor/Wavy/28.svg?c1=%23714B67&c3=%23F3F2F2"); background-position: center; background-size: 100% 100%; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Zigs_01{background-image: url("/web_editor/shape/web_editor/Zigs/01.svg?c2=%238595A2"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Zigs_01_001{background-image: url("/web_editor/shape/web_editor/Zigs/01_001.svg?c2=%238595A2"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Zigs_02{background-image: url("/web_editor/shape/web_editor/Zigs/02.svg?c2=%238595A2"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Zigs_02_001{background-image: url("/web_editor/shape/web_editor/Zigs/02_001.svg?c2=%238595A2"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Zigs_03{background-image: url("/web_editor/shape/web_editor/Zigs/03.svg?c1=%23714B67"); background-position: top; background-size: 100% auto; background-repeat: no-repeat repeat;}.o_we_shape.o_web_editor_Zigs_04{background-image: url("/web_editor/shape/web_editor/Zigs/04.svg?c1=%23714B67"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Zigs_05{background-image: url("/web_editor/shape/web_editor/Zigs/05.svg?c3=%23F3F2F2"); background-position: bottom; background-size: 100% auto; background-repeat: no-repeat no-repeat;}.o_we_shape.o_web_editor_Zigs_06{background-image: url("/web_editor/shape/web_editor/Zigs/06.svg?c4=%23FFFFFF&c5=%23111827"); background-position: bottom; background-size: 30px 100%; background-repeat: repeat no-repeat;}.ui-autocomplete{max-height: 45vh; overflow-y: auto; overflow-x: hidden;}.ui-autocomplete .ui-menu-item{padding: 0;}.ui-autocomplete .ui-menu-item > .ui-state-active{border: none; font-weight: normal; margin: 0;}.ui-autocomplete .fw-bold{font-weight: 700 !important;}.o_editor_banner p, .o_editor_banner h1, .o_editor_banner .h1, .o_editor_banner h2, .o_editor_banner .h2, .o_editor_banner h3, .o_editor_banner .h3{margin-bottom: 1rem;}\n/* /web_editor/static/src/scss/web_editor.frontend.scss */\n @media (max-width: 767.98px){img:not(.o_animate), .media_iframe_video:not(.o_animate), span.fa:not(.o_animate), i.fa:not(.o_animate){transform: none !important;}}.o_wysiwyg_loader{pointer-events: none; min-height: 100px; color: transparent;}.o_wysiwyg_loading{position: absolute; top: 50%; left: 50%; bottom: auto; right: auto; transform: translate(-50%, -50%);}@media (max-width: 767.98px){.o_we_shape:not(.o_shape_show_mobile){display: none;}}.o_we_flip_x{transform: scaleX(-1);}.o_we_flip_y{transform: scaleY(-1);}.o_we_flip_x.o_we_flip_y{transform: scale(-1);}.o_grid_mode{--grid-item-padding-y: 10px; --grid-item-padding-x: 10px;}@media (max-width: 991.98px){.o_grid_mode{row-gap: 0px !important; column-gap: 0px !important;}}.o_grid_mode > *{padding: var(--grid-item-padding-y) var(--grid-item-padding-x) !important;}@media (min-width: 992px){.o_grid_mode:not(.o_extra_menu_items .o_grid_mode){display: grid !important; grid-auto-rows: 50px; grid-template-columns: repeat(12, 1fr); row-gap: 0px; column-gap: 0px; --gutter-x: 0px;}.o_grid_mode:not(.o_extra_menu_items .o_grid_mode) > *{margin: 0 !important; width: 100%; min-width: 0;}.container-fluid > .o_grid_mode, .container-sm > .o_grid_mode, .container-md > .o_grid_mode, .container-lg > .o_grid_mode, .container-xl > .o_grid_mode, .container-xxl > .o_grid_mode{--gutter-x: 30px;}.o_grid_item_image > img, .o_grid_item_image > .media_iframe_video{width: 100% !important; height: 100% !important; object-fit: cover !important;}.o_grid_item_image.o_grid_item_image_contain > img, .o_grid_item_image > img[data-shape]{object-fit: contain !important;}}body.editor_enable:not(.o_basic_theme) .odoo-editor-editable img::selection{background-color: transparent !important;}\n/* /web_tour/static/src/tour_pointer/tour_pointer.scss */\n @keyframes o-tour-pointer-bounce-horizontal{from{transform: translateX(calc(var(--TourPointer__bounce-offset) * -1));}to{transform: translateX(var(--TourPointer__bounce-offset));}}@keyframes o-tour-pointer-bounce-vertical{from{transform: translateY(calc(var(--TourPointer__bounce-offset) * -1));}to{transform: translateY(var(--TourPointer__bounce-offset));}}@keyframes o-tour-pointer-fade-in{from{opacity: 0;}}@keyframes o-tour-pointer-info-expand{from{width: 0; height: 0;}}.o_tour_pointer{--TourPointer__anchor-space: 0; --TourPointer__bounce-offset: 3px; --TourPointer__offset: 8px; --TourPointer__scale: 1.12; --TourPointer__color: #714B67; --TourPointer__color-accent: #86597b; --TourPointer__border-width: 1px; --TourPointer__border-color-rgb: 255, 255, 255; --TourPointer__border-color: rgba(var(--TourPointer__border-color-rgb), 1); --TourPointer__arrow-size: 1rem; --TourPointer__animation-duration: 500ms; --TourPointer__expand-duration: 200ms; --TourPointer__text-color: black; --TourPointer__reveal-animation: o-tour-pointer-fade-in 400ms ease; --TourPointer__translate-x: 0; --TourPointer__translate-y: 0; z-index: 1080; max-width: 270px; border: var(--TourPointer__border-width) solid transparent; transform: translate(var(--TourPointer__translate-x), var(--TourPointer__translate-y)); transition: width var(--TourPointer__expand-duration), height var(--TourPointer__expand-duration);}.o_tour_pointer.o_bouncing.o_left, .o_tour_pointer.o_bouncing.o_right{animation: o-tour-pointer-bounce-horizontal var(--TourPointer__animation-duration) ease-in infinite alternate, var(--TourPointer__reveal-animation);}.o_tour_pointer.o_bouncing.o_top, .o_tour_pointer.o_bouncing.o_bottom{animation: o-tour-pointer-bounce-vertical var(--TourPointer__animation-duration) ease-in infinite alternate, var(--TourPointer__reveal-animation);}.o_tour_pointer .o_tour_pointer_tip{width: var(--TourPointer__width); height: var(--TourPointer__height); border: var(--TourPointer__border-width) solid white; border-radius: 0 50% 50% 50%; background-image: radial-gradient(var(--TourPointer__color-accent), var(--TourPointer__color)); box-shadow: 0 0 40px 2px rgba(var(--TourPointer__border-color-rgb), 0.5);}.o_tour_pointer .o_tour_pointer_content{background-color: #F8F9FA; color: transparent; transition: color 0s ease var(--TourPointer__expand-duration); line-height: 1.5; font-size: 0.875rem; font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Ubuntu, "Noto Sans", Arial, "Odoo Unicode Support Noto", sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol", "Noto Color Emoji"; font-weight: normal;}.o_tour_pointer .o_tour_pointer_content .o_skip_tour{display: inline-block; margin-top: 4px; color: gray; cursor: pointer;}.o_tour_pointer .o_tour_pointer_content .o_skip_tour:hover{color: #4d4d4d;}.o_tour_pointer .o_tour_pointer_content p:last-child{margin-bottom: 0;}.o_tour_pointer.o_left .o_tour_pointer_tip{transform: rotate(90deg) translateY(var(--TourPointer__offset)) scaleY(var(--TourPointer__scale)) rotate(45deg);}.o_tour_pointer.o_right .o_tour_pointer_tip{transform: rotate(270deg) translateY(var(--TourPointer__offset)) scaleY(var(--TourPointer__scale)) rotate(45deg);}.o_tour_pointer.o_top .o_tour_pointer_tip{transform: rotate(180deg) translateY(var(--TourPointer__offset)) scaleY(var(--TourPointer__scale)) rotate(45deg);}.o_tour_pointer.o_bottom .o_tour_pointer_tip{transform: rotate(0deg) translateY(var(--TourPointer__offset)) scaleY(var(--TourPointer__scale)) rotate(45deg);}.o_tour_pointer.o_open{border-color: #ced4da; background-color: #dee2e6; animation: var(--TourPointer__reveal-animation);}.o_tour_pointer.o_open .o_tour_pointer_tip{width: var(--TourPointer__arrow-size); height: var(--TourPointer__arrow-size); border-color: #ced4da; border-radius: 0; background: #F8F9FA; box-shadow: none;}.o_tour_pointer.o_open .o_tour_pointer_content{color: #000000;}.o_tour_pointer.o_open.o_left{--TourPointer__translate-x: calc(var(--TourPointer__arrow-size) / -2);}.o_tour_pointer.o_open.o_left .o_tour_pointer_tip{transform: translateX(-50%) rotate(45deg); right: calc(var(--TourPointer__arrow-size) * -1); top: calc(var(--TourPointer__arrow-size) / 2);}.o_tour_pointer.o_open.o_right{--TourPointer__translate-x: calc(var(--TourPointer__arrow-size) / 2);}.o_tour_pointer.o_open.o_right .o_tour_pointer_tip{transform: translateX(50%) rotate(45deg); left: calc(var(--TourPointer__arrow-size) * -1); top: calc(var(--TourPointer__arrow-size) / 2);}.o_tour_pointer.o_open.o_top{--TourPointer__translate-y: calc(var(--TourPointer__arrow-size) / -2);}.o_tour_pointer.o_open.o_top .o_tour_pointer_tip{transform: translateY(-50%) rotate(45deg); bottom: calc(var(--TourPointer__arrow-size) * -1); left: calc(var(--TourPointer__arrow-size) / 2);}.o_tour_pointer.o_open.o_bottom{--TourPointer__translate-y: calc(var(--TourPointer__arrow-size) / 2);}.o_tour_pointer.o_open.o_bottom .o_tour_pointer_tip{transform: translateY(50%) rotate(45deg); top: calc(var(--TourPointer__arrow-size) * -1); left: calc(var(--TourPointer__arrow-size) / 2);}.o_tour_pointer.o_open.o_expand_left.o_top, .o_tour_pointer.o_open.o_expand_left.o_bottom{--TourPointer__translate-x: calc( var(--TourPointer__width) + var(--TourPointer__border-width) - 100% );}.o_tour_pointer.o_open.o_expand_left.o_top .o_tour_pointer_tip, .o_tour_pointer.o_open.o_expand_left.o_bottom .o_tour_pointer_tip{left: initial; right: calc(var(--TourPointer__arrow-size) / 2);}@media print{.o_tour_pointer{display: none !important;}}	t	2024-01-07 05:21:53.35011	2024-01-07 05:21:53.35011	\N	\N
15	0	1	1514085	1	1	web.assets_frontend_lazy.min.js	ir.ui.view	\N	binary	/web/assets/50322d2/web.assets_frontend_lazy.min.js	\N	20/20b42d1c11b0093d845f04e7ba6d25bf6616d8b4	20b42d1c11b0093d845f04e7ba6d25bf6616d8b4	application/javascript	\N	application	t	2024-01-07 05:21:58.919867	2024-01-07 05:21:58.919867	\N	\N
\.


--
-- Data for Name: ir_config_parameter; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.ir_config_parameter (id, create_uid, write_uid, key, value, create_date, write_date) FROM stdin;
5	1	1	base.login_cooldown_after	10	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
6	1	1	base.login_cooldown_duration	60	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
7	1	1	base.template_portal_user_id	5	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
1	1	1	database.secret	fe23c5fd-2e6c-4cb6-8841-e5bdb85d3c8e	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
2	1	1	database.uuid	82547a86-ad1c-11ee-a6c8-72fdcfd122f5	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
3	1	1	database.create_date	2024-01-07 05:20:45	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
8	1	1	base_setup.show_effect	True	2024-01-07 05:21:27.729604	2024-01-07 05:21:27.729604
4	1	2	web.base.url	http://odoo-17-tpl.webdiscode.com	2024-01-07 05:18:12.878639	2024-01-07 05:21:50.78729
\.


--
-- Data for Name: ir_cron; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.ir_cron (id, ir_actions_server_id, user_id, interval_number, numbercall, priority, create_uid, write_uid, cron_name, interval_type, active, doall, nextcall, lastcall, create_date, write_date) FROM stdin;
1	34	1	1	-1	5	1	1	Base: Auto-vacuum internal data	days	t	\N	2024-01-07 05:20:41	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
2	35	1	1	-1	5	1	1	Base: Portal Users Deletion	days	t	\N	2024-01-07 05:20:41	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
\.


--
-- Data for Name: ir_cron_trigger; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.ir_cron_trigger (id, cron_id, create_uid, write_uid, call_at, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_default; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.ir_default (id, field_id, user_id, company_id, create_uid, write_uid, condition, json_value, create_date, write_date) FROM stdin;
1	877	\N	\N	1	1	\N	"en_US"	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
\.


--
-- Data for Name: ir_demo; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.ir_demo (id, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_demo_failure; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.ir_demo_failure (id, module_id, wizard_id, create_uid, write_uid, error, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_demo_failure_wizard; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.ir_demo_failure_wizard (id, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_exports; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.ir_exports (id, create_uid, write_uid, name, resource, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_exports_line; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.ir_exports_line (id, export_id, create_uid, write_uid, name, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_filters; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.ir_filters (id, user_id, action_id, create_uid, write_uid, name, model_id, domain, context, sort, is_default, active, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_logging; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.ir_logging (id, create_uid, write_uid, name, type, dbname, level, path, func, line, message, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_mail_server; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.ir_mail_server (id, smtp_port, sequence, create_uid, write_uid, name, from_filter, smtp_host, smtp_authentication, smtp_user, smtp_pass, smtp_encryption, smtp_debug, active, create_date, write_date, smtp_ssl_certificate, smtp_ssl_private_key) FROM stdin;
\.


--
-- Data for Name: ir_model; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.ir_model (id, create_uid, write_uid, model, "order", state, name, info, transient, create_date, write_date) FROM stdin;
1	\N	\N	base	id	base	{"en_US": "Base"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N
2	\N	\N	_unknown	id	base	{"en_US": "Unknown"}	\n    Abstract model used as a substitute for relational fields with an unknown\n    comodel.\n    	f	\N	\N
3	\N	\N	ir.model	model	base	{"en_US": "Models"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
4	\N	\N	ir.model.fields	name	base	{"en_US": "Fields"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
5	\N	\N	ir.model.inherit	id	base	{"en_US": "Model Inheritance Tree"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
6	\N	\N	ir.model.fields.selection	sequence, id	base	{"en_US": "Fields Selection"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
7	\N	\N	ir.model.constraint	id	base	{"en_US": "Model Constraint"}	\n    This model tracks PostgreSQL foreign keys and constraints used by Odoo\n    models.\n    	f	\N	\N
8	\N	\N	ir.model.relation	id	base	{"en_US": "Relation Model"}	\n    This model tracks PostgreSQL tables used to implement Odoo many2many\n    relations.\n    	f	\N	\N
9	\N	\N	ir.model.access	model_id,group_id,name,id	base	{"en_US": "Model Access"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
10	\N	\N	ir.model.data	module, model, name	base	{"en_US": "Model Data"}	Holds external identifier keys for records in the database.\n       This has two main uses:\n\n           * allows easy data integration with third-party systems,\n             making import/export/sync of data possible, as records\n             can be uniquely identified across multiple systems\n           * allows tracking the origin of data installed by Odoo\n             modules themselves, thus making it possible to later\n             update them seamlessly.\n    	f	\N	\N
11	\N	\N	wizard.ir.model.menu.create	id	base	{"en_US": "Create Menu Wizard"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
12	\N	\N	ir.sequence	name	base	{"en_US": "Sequence"}	 Sequence model.\n\n    The sequence model allows to define and use so-called sequence objects.\n    Such objects are used to generate unique identifiers in a transaction-safe\n    way.\n\n    	f	\N	\N
13	\N	\N	ir.sequence.date_range	id	base	{"en_US": "Sequence Date Range"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
14	\N	\N	ir.ui.menu	sequence,id	base	{"en_US": "Menu"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
15	\N	\N	ir.ui.view.custom	create_date desc	base	{"en_US": "Custom View"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
16	\N	\N	ir.ui.view	priority,name,id	base	{"en_US": "View"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
17	\N	\N	reset.view.arch.wizard	id	base	{"en_US": "Reset View Architecture Wizard"}	 A wizard to compare and reset views architecture. 	t	\N	\N
18	\N	\N	ir.asset	sequence, id	base	{"en_US": "Asset"}	This model contributes to two things:\n\n        1. It provides a function returning a list of all file paths declared\n        in a given list of addons (see _get_addon_paths);\n\n        2. It allows to create 'ir.asset' records to add additional directives\n        to certain bundles.\n    	f	\N	\N
19	\N	\N	ir.actions.actions	name	base	{"en_US": "Actions"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
20	\N	\N	ir.actions.act_window	name	base	{"en_US": "Action Window"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
21	\N	\N	ir.actions.act_window.view	sequence,id	base	{"en_US": "Action Window View"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
22	\N	\N	ir.actions.act_window_close	name	base	{"en_US": "Action Window Close"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
62	\N	\N	ir.http	id	base	{"en_US": "HTTP Routing"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N
100	\N	\N	change.password.user	id	base	{"en_US": "User, Change Password Wizard"}	 A model to configure users in the change password wizard. 	t	\N	\N
23	\N	\N	ir.actions.act_url	name	base	{"en_US": "Action URL"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
24	\N	\N	ir.actions.server	sequence,name	base	{"en_US": "Server Actions"}	 Server actions model. Server action work on a base model and offer various\n    type of actions that can be executed automatically, for example using base\n    action rules, of manually, by adding the action in the 'More' contextual\n    menu.\n\n    Since Odoo 8.0 a button 'Create Menu Action' button is available on the\n    action form view. It creates an entry in the More menu of the base model.\n    This allows to create server actions and run them in mass mode easily through\n    the interface.\n\n    The available actions are :\n\n    - 'Execute Python Code': a block of python code that will be executed\n    - 'Create a new Record': create a new record with new values\n    - 'Write on a Record': update the values of a record\n    - 'Execute several actions': define an action that triggers several other\n      server actions\n    	f	\N	\N
25	\N	\N	ir.actions.todo	sequence, id	base	{"en_US": "Configuration Wizards"}	\n    Configuration Wizards\n    	f	\N	\N
26	\N	\N	ir.actions.client	name	base	{"en_US": "Client Action"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
27	\N	\N	ir.actions.report	name	base	{"en_US": "Report Action"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
28	\N	\N	ir.attachment	id desc	base	{"en_US": "Attachment"}	Attachments are used to link binary files or url to any openerp document.\n\n    External attachment storage\n    ---------------------------\n\n    The computed field ``datas`` is implemented using ``_file_read``,\n    ``_file_write`` and ``_file_delete``, which can be overridden to implement\n    other storage engines. Such methods should check for other location pseudo\n    uri (example: hdfs://hadoopserver).\n\n    The default implementation is the file:dirname location that stores files\n    on the local filesystem using name based on their sha1 hash\n    	f	\N	\N
29	\N	\N	ir.binary	id	base	{"en_US": "File streaming helper model for controllers"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N
30	\N	\N	ir.cron	cron_name	base	{"en_US": "Scheduled Actions"}	 Model describing cron jobs (also called actions or tasks).\n    	f	\N	\N
31	\N	\N	ir.cron.trigger	id	base	{"en_US": "Triggered actions"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
32	\N	\N	ir.filters	model_id, name, id desc	base	{"en_US": "Filters"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
33	\N	\N	ir.default	id	base	{"en_US": "Default Values"}	 User-defined default values for fields. 	f	\N	\N
34	\N	\N	ir.exports	name	base	{"en_US": "Exports"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
35	\N	\N	ir.exports.line	id	base	{"en_US": "Exports Line"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
36	\N	\N	ir.rule	model_id DESC,id	base	{"en_US": "Record Rule"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
37	\N	\N	ir.config_parameter	key	base	{"en_US": "System Parameter"}	Per-database storage of configuration key-value pairs.	f	\N	\N
38	\N	\N	ir.autovacuum	id	base	{"en_US": "Automatic Vacuum"}	 Helper model to the ``@api.autovacuum`` method decorator. 	f	\N	\N
39	\N	\N	ir.mail_server	sequence, id	base	{"en_US": "Mail Server"}	Represents an SMTP server, able to send outgoing emails, with SSL and TLS capabilities.	f	\N	\N
40	\N	\N	ir.fields.converter	id	base	{"en_US": "Fields Converter"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N
42	\N	\N	ir.qweb.field	id	base	{"en_US": "Qweb Field"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
43	\N	\N	ir.qweb.field.integer	id	base	{"en_US": "Qweb Field Integer"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
44	\N	\N	ir.qweb.field.float	id	base	{"en_US": "Qweb Field Float"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
45	\N	\N	ir.qweb.field.date	id	base	{"en_US": "Qweb Field Date"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
46	\N	\N	ir.qweb.field.datetime	id	base	{"en_US": "Qweb Field Datetime"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
47	\N	\N	ir.qweb.field.text	id	base	{"en_US": "Qweb Field Text"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
48	\N	\N	ir.qweb.field.selection	id	base	{"en_US": "Qweb Field Selection"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
49	\N	\N	ir.qweb.field.many2one	id	base	{"en_US": "Qweb Field Many to One"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
50	\N	\N	ir.qweb.field.many2many	id	base	{"en_US": "Qweb field many2many"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
51	\N	\N	ir.qweb.field.html	id	base	{"en_US": "Qweb Field HTML"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
53	\N	\N	ir.qweb.field.image_url	id	base	{"en_US": "Qweb Field Image"}	 ``image_url`` widget rendering, inserts an image tag in the\n    document.\n    	f	\N	\N
54	\N	\N	ir.qweb.field.monetary	id	base	{"en_US": "Qweb Field Monetary"}	 ``monetary`` converter, has a mandatory option\n    ``display_currency`` only if field is not of type Monetary.\n    Otherwise, if we are in presence of a monetary field, the field definition must\n    have a currency_field attribute set.\n\n    The currency is used for formatting *and rounding* of the float value. It\n    is assumed that the linked res_currency has a non-empty rounding value and\n    res.currency's ``round`` method is used to perform rounding.\n\n    .. note:: the monetary converter internally adds the qweb context to its\n              options mapping, so that the context is available to callees.\n              It's set under the ``_values`` key.\n    	f	\N	\N
55	\N	\N	ir.qweb.field.float_time	id	base	{"en_US": "Qweb Field Float Time"}	 ``float_time`` converter, to display integral or fractional values as\n    human-readable time spans (e.g. 1.5 as "01:30").\n\n    Can be used on any numerical field.\n    	f	\N	\N
56	\N	\N	ir.qweb.field.time	id	base	{"en_US": "QWeb Field Time"}	 ``time`` converter, to display integer or fractional value as\n    human-readable time (e.g. 1.5 as "1:30 AM"). The unit of this value\n    is in hours.\n\n    Can be used on any numerical field between: 0 <= value < 24\n    	f	\N	\N
57	\N	\N	ir.qweb.field.duration	id	base	{"en_US": "Qweb Field Duration"}	 ``duration`` converter, to display integral or fractional values as\n    human-readable time spans (e.g. 1.5 as "1 hour 30 minutes").\n\n    Can be used on any numerical field.\n\n    Has an option ``unit`` which can be one of ``second``, ``minute``,\n    ``hour``, ``day``, ``week`` or ``year``, used to interpret the numerical\n    field value before converting it. By default use ``second``.\n\n    Has an option ``round``. By default use ``second``.\n\n    Has an option ``digital`` to display 01:00 instead of 1 hour\n\n    Sub-second values will be ignored.\n    	f	\N	\N
58	\N	\N	ir.qweb.field.relative	id	base	{"en_US": "Qweb Field Relative"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
59	\N	\N	ir.qweb.field.barcode	id	base	{"en_US": "Qweb Field Barcode"}	 ``barcode`` widget rendering, inserts a data:uri-using image tag in the\n    document. May be overridden by e.g. the website module to generate links\n    instead.\n    	f	\N	\N
60	\N	\N	ir.qweb.field.contact	id	base	{"en_US": "Qweb Field Contact"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
61	\N	\N	ir.qweb.field.qweb	id	base	{"en_US": "Qweb Field qweb"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
63	\N	\N	ir.logging	id DESC	base	{"en_US": "Logging"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
64	\N	\N	ir.property	id	base	{"en_US": "Company Property"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
65	\N	\N	ir.module.category	name	base	{"en_US": "Application"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
66	\N	\N	ir.module.module	application desc,sequence,name	base	{"en_US": "Module"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
67	\N	\N	ir.module.module.dependency	id	base	{"en_US": "Module dependency"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
68	\N	\N	ir.module.module.exclusion	id	base	{"en_US": "Module exclusion"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
69	\N	\N	ir.demo	id	base	{"en_US": "Demo"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
70	\N	\N	ir.demo_failure	id	base	{"en_US": "Demo failure"}	 Stores modules for which we could not install demo data\n    	t	\N	\N
71	\N	\N	ir.demo_failure.wizard	id	base	{"en_US": "Demo Failure wizard"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
72	\N	\N	report.layout	sequence	base	{"en_US": "Report Layout"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
73	\N	\N	report.paperformat	id	base	{"en_US": "Paper Format Config"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
74	\N	\N	ir.profile	session desc, id desc	base	{"en_US": "Profiling results"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
75	\N	\N	base.enable.profiling.wizard	id	base	{"en_US": "Enable profiling for some time"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
76	\N	\N	image.mixin	id	base	{"en_US": "Image Mixin"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N
77	\N	\N	avatar.mixin	id	base	{"en_US": "Avatar Mixin"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N
78	\N	\N	res.country	name	base	{"en_US": "Country"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
79	\N	\N	res.country.group	id	base	{"en_US": "Country Group"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
80	\N	\N	res.country.state	code	base	{"en_US": "Country state"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
81	\N	\N	res.lang	active desc,name	base	{"en_US": "Languages"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
82	\N	\N	format.address.mixin	id	base	{"en_US": "Address Format"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N
83	\N	\N	res.partner.category	name	base	{"en_US": "Partner Tags"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
84	\N	\N	res.partner.title	name	base	{"en_US": "Partner Title"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
99	\N	\N	change.password.wizard	id	base	{"en_US": "Change Password Wizard"}	 A wizard to manage the change of users' passwords. 	t	\N	\N
85	\N	\N	res.partner	complete_name ASC, id DESC	base	{"en_US": "Contact"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
86	\N	\N	res.partner.industry	name	base	{"en_US": "Industry"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
87	\N	\N	res.bank	name	base	{"en_US": "Bank"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
88	\N	\N	res.partner.bank	sequence, id	base	{"en_US": "Bank Accounts"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
89	\N	\N	res.config	id	base	{"en_US": "Config"}	 Base classes for new-style configuration items\n\n    Configuration items should inherit from this class, implement\n    the execute method (and optionally the cancel one) and have\n    their view inherit from the related res_config_view_base view.\n    	t	\N	\N
90	\N	\N	res.config.installer	id	base	{"en_US": "Config Installer"}	 New-style configuration base specialized for addons selection\n    and installation.\n\n    Basic usage\n    -----------\n\n    Subclasses can simply define a number of boolean fields. The field names\n    should be the names of the addons to install (when selected). Upon action\n    execution, selected boolean fields (and those only) will be interpreted as\n    addons to install, and batch-installed.\n\n    Additional addons\n    -----------------\n\n    It is also possible to require the installation of an additional\n    addon set when a specific preset of addons has been marked for\n    installation (in the basic usage only, additionals can't depend on\n    one another).\n\n    These additionals are defined through the ``_install_if``\n    property. This property is a mapping of a collection of addons (by\n    name) to a collection of addons (by name) [#]_, and if all the *key*\n    addons are selected for installation, then the *value* ones will\n    be selected as well. For example::\n\n        _install_if = {\n            ('sale','crm'): ['sale_crm'],\n        }\n\n    This will install the ``sale_crm`` addon if and only if both the\n    ``sale`` and ``crm`` addons are selected for installation.\n\n    You can define as many additionals as you wish, and additionals\n    can overlap in key and value. For instance::\n\n        _install_if = {\n            ('sale','crm'): ['sale_crm'],\n            ('sale','project'): ['sale_service'],\n        }\n\n    will install both ``sale_crm`` and ``sale_service`` if all of\n    ``sale``, ``crm`` and ``project`` are selected for installation.\n\n    Hook methods\n    ------------\n\n    Subclasses might also need to express dependencies more complex\n    than that provided by additionals. In this case, it's possible to\n    define methods of the form ``_if_%(name)s`` where ``name`` is the\n    name of a boolean field. If the field is selected, then the\n    corresponding module will be marked for installation *and* the\n    hook method will be executed.\n\n    Hook methods take the usual set of parameters (cr, uid, ids,\n    context) and can return a collection of additional addons to\n    install (if they return anything, otherwise they should not return\n    anything, though returning any "falsy" value such as None or an\n    empty collection will have the same effect).\n\n    Complete control\n    ----------------\n\n    The last hook is to simply overload the ``modules_to_install``\n    method, which implements all the mechanisms above. This method\n    takes the usual set of parameters (cr, uid, ids, context) and\n    returns a ``set`` of addons to install (addons selected by the\n    above methods minus addons from the *basic* set which are already\n    installed) [#]_ so an overloader can simply manipulate the ``set``\n    returned by ``ResConfigInstaller.modules_to_install`` to add or\n    remove addons.\n\n    Skipping the installer\n    ----------------------\n\n    Unless it is removed from the view, installers have a *skip*\n    button which invokes ``action_skip`` (and the ``cancel`` hook from\n    ``res.config``). Hooks and additionals *are not run* when skipping\n    installation, even for already installed addons.\n\n    Again, setup your hooks accordingly.\n\n    .. [#] note that since a mapping key needs to be hashable, it's\n           possible to use a tuple or a frozenset, but not a list or a\n           regular set\n\n    .. [#] because the already-installed modules are only pruned at\n           the very end of ``modules_to_install``, additionals and\n           hooks depending on them *are guaranteed to execute*. Setup\n           your hooks accordingly.\n    	t	\N	\N
91	\N	\N	res.config.settings	id	base	{"en_US": "Config Settings"}	 Base configuration wizard for application settings.  It provides support for setting\n        default values, assigning groups to employee users, and installing modules.\n        To make such a 'settings' wizard, define a model like::\n\n            class MyConfigWizard(models.TransientModel):\n                _name = 'my.settings'\n                _inherit = 'res.config.settings'\n\n                default_foo = fields.type(..., default_model='my.model'),\n                group_bar = fields.Boolean(..., group='base.group_user', implied_group='my.group'),\n                module_baz = fields.Boolean(...),\n                config_qux = fields.Char(..., config_parameter='my.parameter')\n                other_field = fields.type(...),\n\n        The method ``execute`` provides some support based on a naming convention:\n\n        *   For a field like 'default_XXX', ``execute`` sets the (global) default value of\n            the field 'XXX' in the model named by ``default_model`` to the field's value.\n\n        *   For a boolean field like 'group_XXX', ``execute`` adds/removes 'implied_group'\n            to/from the implied groups of 'group', depending on the field's value.\n            By default 'group' is the group Employee.  Groups are given by their xml id.\n            The attribute 'group' may contain several xml ids, separated by commas.\n\n        *   For a selection field like 'group_XXX' composed of 2 string values ('0' and '1'),\n            ``execute`` adds/removes 'implied_group' to/from the implied groups of 'group',\n            depending on the field's value.\n            By default 'group' is the group Employee.  Groups are given by their xml id.\n            The attribute 'group' may contain several xml ids, separated by commas.\n\n        *   For a boolean field like 'module_XXX', ``execute`` triggers the immediate\n            installation of the module named 'XXX' if the field has value ``True``.\n\n        *   For a selection field like 'module_XXX' composed of 2 string values ('0' and '1'),\n            ``execute`` triggers the immediate installation of the module named 'XXX'\n            if the field has the value ``'1'``.\n\n        *   For a field with no specific prefix BUT an attribute 'config_parameter',\n            ``execute``` will save its value in an ir.config.parameter (global setting for the\n            database).\n\n        *   For the other fields, the method ``execute`` invokes `set_values`.\n            Override it to implement the effect of those fields.\n\n        The method ``default_get`` retrieves values that reflect the current status of the\n        fields like 'default_XXX', 'group_XXX', 'module_XXX' and config_XXX.\n        It also invokes all methods with a name that starts with 'get_default_';\n        such methods can be defined to provide current values for other fields.\n    	t	\N	\N
92	\N	\N	res.currency	active desc, name	base	{"en_US": "Currency"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
93	\N	\N	res.currency.rate	name desc	base	{"en_US": "Currency Rate"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
94	\N	\N	res.company	sequence, name	base	{"en_US": "Companies"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
95	\N	\N	res.groups	name	base	{"en_US": "Access Groups"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
96	\N	\N	res.users.log	id desc	base	{"en_US": "Users Log"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
97	\N	\N	res.users	name, login	base	{"en_US": "User"}	 User class. A res.users record models an OpenERP user and is different\n        from an employee.\n\n        res.users class now inherits from res.partner. The partner model is\n        used to store the data related to the partner: lang, name, address,\n        avatar, ... The user model is now dedicated to technical data.\n    	f	\N	\N
98	\N	\N	res.users.identitycheck	id	base	{"en_US": "Password Check Wizard"}	 Wizard used to re-check the user's credentials (password) and eventually\n    revoke access to his account to every device he has an active session on.\n\n    Might be useful before the more security-sensitive operations, users might be\n    leaving their computer unlocked & unattended. Re-checking credentials mitigates\n    some of the risk of a third party using such an unattended device to manipulate\n    the account.\n    	t	\N	\N
101	\N	\N	change.password.own	id	base	{"en_US": "User, change own password wizard"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
102	\N	\N	res.users.apikeys	id	base	{"en_US": "Users API Keys"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
103	\N	\N	res.users.apikeys.description	id	base	{"en_US": "API Key Description"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
104	\N	\N	res.users.apikeys.show	id	base	{"en_US": "Show API Key"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N
105	\N	\N	res.users.settings	id	base	{"en_US": "User Settings"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
106	\N	\N	res.users.deletion	id	base	{"en_US": "Users Deletion Request"}	User deletion requests.\n\n    Those requests are logged in a different model to keep a trace of this action and the\n    deletion is done in a CRON. Indeed, removing a user can be a heavy operation on\n    large database (because of create_uid, write_uid on each model, which are not always\n    indexed). This model just remove the users added in the deletion queue, remaining code\n    must deal with other consideration (archiving, blacklist email...).\n    	f	\N	\N
107	\N	\N	decimal.precision	id	base	{"en_US": "Decimal Precision"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
108	\N	\N	report.base.report_irmodulereference	id	base	{"en_US": "Module Reference Report (base)"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N
109	\N	\N	base.module.update	id	base	{"en_US": "Update Module"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
110	\N	\N	base.language.install	id	base	{"en_US": "Install Language"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
111	\N	\N	base.language.import	id	base	{"en_US": "Language Import"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
112	\N	\N	base.module.upgrade	id	base	{"en_US": "Upgrade Module"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
113	\N	\N	base.module.uninstall	id	base	{"en_US": "Module Uninstall"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
114	\N	\N	base.language.export	id	base	{"en_US": "Language Export"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
115	\N	\N	base.partner.merge.line	min_id asc	base	{"en_US": "Merge Partner Line"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
116	\N	\N	base.partner.merge.automatic.wizard	id	base	{"en_US": "Merge Partner Wizard"}	\n        The idea behind this wizard is to create a list of potential partners to\n        merge. We use two objects, the first one is the wizard for the end-user.\n        And the second will contain the partner list to merge.\n    	t	\N	\N
52	\N	\N	ir.qweb.field.image	id	base	{"en_US": "Qweb Field Image"}	\n    Widget options:\n\n    ``class``\n        set as attribute on the generated <img> tag\n    	f	\N	\N
118	\N	\N	base.document.layout	id	base	{"en_US": "Company Document Layout"}	\n    Customise the company document layout and display a live preview\n    	t	\N	\N
119	\N	\N	auth_totp.device	id	base	{"en_US": "Authentication Device"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
120	\N	\N	auth_totp.wizard	id	base	{"en_US": "2-Factor Setup Wizard"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
121	\N	\N	base_import.mapping	id	base	{"en_US": "Base Import Mapping"}	 mapping of previous column:field selections\n\n    This is useful when repeatedly importing from a third-party\n    system: column names generated by the external system may\n    not match Odoo's field names or labels. This model is used\n    to save the mapping between column names and fields so that\n    next time a user imports from the same third-party systems\n    we can automatically match the columns to the correct field\n    without them having to re-enter the mapping every single\n    time.\n    	f	\N	\N
122	\N	\N	base_import.import	id	base	{"en_US": "Base Import"}	\n    This model is used to prepare the loading of data coming from a user file.\n\n    Here is the process that is followed:\n\n    #. The user selects a file to import.\n    #. File parsing and mapping suggestion (see "parse_preview" method)\n\n       #. Extract the current model's importable fields tree (see :meth:`get_fields_tree`).\n       #. Read the file (see :meth:`_read_file`) and extract header names and file\n          length (used for batch import).\n       #. Extract headers types from the data preview (10 first line of the file)\n          (see :meth:`_extract_headers_types`).\n       #. Try to find for each header a field to map with (see :meth:`_get_mapping_suggestions`)\n\n          - First check the previously saved mappings between the header name\n            and one of the model's fields.\n          - If no mapping found, try an exact match comparison using fields\n            technical names, labels and user language translated labels.\n          - If nothing found, try a fuzzy match using word distance between\n            header name and fields tachnical names, labels and user language\n            translated labels. Keep only the closest match.\n\n       #. Prepare examples for each columns using the first non null value from each column.\n       #. Send the info back to the UI where the user can modify the suggested mapping.\n    #. Execute the import: There are two import mode with uses the same process. (see :meth:`execute_import`)\n\n       #. Test import: Try to import but rollback the transaction. This allows\n          the check errors during the import process and allow the user to\n          choose import options for the different encountered errors.\n       #. Real import: Try to import the file using the configured mapping and\n          the eventual "error mapping options". If import encounters blocking\n          errors, the transaction is rollbacked and the user is allowed to\n          choose import options for the different errors.\n\n          - Get file data and fields to import into (see :meth:`_convert_import_data`).\n          - Parse date, float and binary data (see :meth:`_parse_import_data`).\n          - Handle multiple mapping -> concatenate char/text/many2many columns\n            mapped on the same field (see :meth:`_handle_multi_mapping`).\n          - Handle fallback values for boolean and selection fields, in case\n            input data does not match any allowed values (see :meth:`_handle_fallback_values`).\n          - Load data (see ir.model "load" method).\n          - Rollback transaction if test mode or if encountered error.\n          - Save mapping if any import is successful to ease later mapping suggestions.\n          - Return import result to the UI (success or errors if any).\n    	t	\N	\N
123	\N	\N	base.import.module	id	base	{"en_US": "Import Module"}	 Import Module 	t	\N	\N
124	\N	\N	bus.bus	id	base	{"en_US": "Communication Bus"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
125	\N	\N	bus.presence	id	base	{"en_US": "User Presence"}	 User Presence\n        Its status is 'online', 'away' or 'offline'. This model should be a one2one, but is not\n        attached to res_users to avoid database concurrence errors. Since the 'update_presence' method is executed\n        at each poll, if the user have multiple opened tabs, concurrence errors can happend, but are 'muted-logged'.\n    	f	\N	\N
126	\N	\N	ir.websocket	id	base	{"en_US": "websocket message handling"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N
127	\N	\N	web_tour.tour	id	base	{"en_US": "Tours"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
128	\N	\N	iap.account	id	base	{"en_US": "IAP Account"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
129	\N	\N	iap.account.info	id	base	{"en_US": "IAP Account Info"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
130	\N	\N	iap.enrich.api	id	base	{"en_US": "IAP Lead Enrichment API"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N
41	\N	\N	ir.qweb	id	base	{"en_US": "Qweb"}	 IrQWeb object for rendering editor stuff\n    	f	\N	\N
132	\N	\N	html.field.history.mixin	id	base	{"en_US": "Field html History"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N
133	\N	\N	web_editor.assets	id	base	{"en_US": "Assets Utils"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N
134	\N	\N	web_editor.converter.test	id	base	{"en_US": "Web Editor Converter Test"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
135	\N	\N	web_editor.converter.test.sub	id	base	{"en_US": "Web Editor Converter Subtest"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
\.


--
-- Data for Name: ir_model_access; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.ir_model_access (id, model_id, group_id, create_uid, write_uid, name, active, perm_read, perm_write, perm_create, perm_unlink, create_date, write_date) FROM stdin;
1	107	4	1	1	decimal.precision configuration	t	t	t	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
2	28	1	1	1	ir_attachment group_user	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
3	28	\N	1	1	ir_attachment group_portal_public	t	f	f	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
4	30	4	1	1	ir_cron group_cron	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
5	31	4	1	1	ir_cron_trigger group_cron	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
6	34	8	1	1	ir_exports group_system	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
7	35	1	1	1	ir_exports_line group_system	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
8	3	2	1	1	ir_model group_erp_manager	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
9	7	2	1	1	ir_model_constraint group_erp_manager	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
10	8	2	1	1	ir_model_relation group_erp_manager	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
11	5	\N	1	1	ir_model_inherit nobody	t	f	f	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
12	9	2	1	1	ir_model_access_group_erp_manager	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
13	10	2	1	1	ir_model_data group_erp_manager	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
14	4	2	1	1	ir_model_fields group_erp_manager	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
15	6	2	1	1	ir_model_fields_selection group_erp_manager	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
16	3	1	1	1	ir_model_all	t	f	f	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
17	10	1	1	1	ir_model_data user	t	f	f	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
18	4	1	1	1	ir_model_fields all	t	f	f	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
19	6	1	1	1	ir_model_fields_selection all	t	f	f	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
20	65	2	1	1	ir_module_category group_user	t	t	f	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
21	66	4	1	1	ir_module_module group_user	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
22	67	4	1	1	ir_module_module_dependency group_system	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
23	68	4	1	1	ir_module_module_exclusion group_system	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
24	64	\N	1	1	ir_property group_user	t	f	f	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
25	64	4	1	1	ir_property group_system	t	t	t	t	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
26	36	2	1	1	ir_rule group_erp_manager	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
27	12	1	1	1	ir_sequence group_user	t	t	f	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
28	12	4	1	1	ir_sequence group_system	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
29	13	1	1	1	ir_sequence_date_range group_user	t	t	f	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
30	13	4	1	1	ir_sequence_date_range group_system	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
31	14	1	1	1	ir_ui_menu group_user	t	t	f	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
32	14	4	1	1	ir_ui_menu group_system	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
33	16	\N	1	1	ir_ui_view group_user	t	f	f	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
34	16	4	1	1	ir_ui_view group_system	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
35	17	4	1	1	reset_view_arch_wizard group_system	t	t	t	t	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
36	15	4	1	1	ir_ui_view_custom_group_user	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
37	33	\N	1	1	ir_default all	t	f	f	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
38	33	1	1	1	ir_default group_user	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
39	33	4	1	1	ir_default group_system	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
40	94	2	1	1	res_company group_erp_manager	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
41	94	11	1	1	res_company group_user	t	t	f	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
42	94	10	1	1	res_company group_user	t	t	f	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
43	94	1	1	1	res_company group_user	t	t	f	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
44	78	11	1	1	res_country group_user_all	t	t	f	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
45	78	10	1	1	res_country group_user_all	t	t	f	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
46	78	1	1	1	res_country group_user_all	t	t	f	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
47	80	11	1	1	res_country_state group_user_all	t	t	f	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
48	80	10	1	1	res_country_state group_user_all	t	t	f	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
49	80	1	1	1	res_country_state group_user_all	t	t	f	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
50	79	11	1	1	res_country_group group_user_all	t	t	f	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
51	79	10	1	1	res_country_group group_user_all	t	t	f	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
52	79	1	1	1	res_country_group group_user_all	t	t	f	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
53	78	9	1	1	res_country group_user	t	t	f	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
54	78	4	1	1	res_country_group_system	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
55	80	9	1	1	res_country_state group_user	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
56	79	9	1	1	res_country_group group_user	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
57	92	11	1	1	res_currency group_all	t	t	f	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
58	92	10	1	1	res_currency group_all	t	t	f	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
59	92	1	1	1	res_currency group_all	t	t	f	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
60	93	11	1	1	res_currency_rate group_all	t	t	f	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
61	93	10	1	1	res_currency_rate group_all	t	t	f	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
62	93	1	1	1	res_currency_rate group_all	t	t	f	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
63	92	4	1	1	res_currency group_system	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
64	93	4	1	1	res_currency_rate group_system	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
65	95	2	1	1	res_groups group_erp_manager	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
66	95	1	1	1	res_groups group_user	t	t	f	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
67	81	11	1	1	res_lang group_all	t	t	f	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
68	81	10	1	1	res_lang group_all	t	t	f	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
69	81	1	1	1	res_lang group_all	t	t	f	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
70	81	4	1	1	res_lang group_user	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
71	85	11	1	1	res_partner group_public	t	t	f	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
72	85	10	1	1	res_partner group_portal	t	t	f	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
73	85	9	1	1	res_partner group_partner_manager	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
74	85	1	1	1	res_partner group_user	t	t	f	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
75	88	1	1	1	res_partner_bank group_user	t	t	f	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
76	88	9	1	1	res_partner_bank group_partner_manager	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
77	83	1	1	1	res_partner_category group_user	t	t	f	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
78	83	9	1	1	res_partner_category group_partner_manager	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
79	86	1	1	1	res_partner_industry group_user	t	t	f	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
80	86	4	1	1	res_partner_industry group_system	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
81	84	9	1	1	res_partner_title group_partner_manager	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
82	84	1	1	1	res_partner_title group_user	t	t	f	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
83	97	11	1	1	res_users all	t	t	f	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
84	97	10	1	1	res_users all	t	t	f	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
85	97	1	1	1	res_users all	t	t	f	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
86	97	2	1	1	res_users group_erp_manager	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
87	106	\N	1	1	res_users_deletion all	t	f	f	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
88	106	2	1	1	res_users_deletion group_erp_manager	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
89	96	4	1	1	res_users_log_all	t	t	f	t	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
90	98	1	1	1	id check employees	t	t	t	t	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
91	98	10	1	1	id check portal	t	t	t	t	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
92	102	1	1	1	API keys access employees	t	t	f	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
93	102	10	1	1	API keys access portal	t	t	f	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
94	103	1	1	1	API key wizard employees	t	t	f	t	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
95	103	10	1	1	API key wizard	t	t	f	t	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
96	104	1	1	1	API key result employees	t	t	f	t	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
97	105	\N	1	1	res.users.settings	t	f	f	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
98	105	1	1	1	res.users.settings	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
99	18	4	1	1	ir_asset_group_system	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
100	19	4	1	1	ir_actions_group_system	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
101	20	4	1	1	ir_actions_act_window_system	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
102	22	4	1	1	ir_actions_act_window_close_group_system	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
103	27	4	1	1	ir_actions_report_group_system	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
104	25	4	1	1	ir_actions_todo group system	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
105	21	4	1	1	ir_actions_act_window_view_group_system	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
106	23	4	1	1	ir_actions_act_url_group_system	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
107	24	4	1	1	ir_actions_server_group_system	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
108	26	4	1	1	ir_actions_client all	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
109	87	4	1	1	res_bank_group_system	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
110	87	9	1	1	res_bank_group_partner_manager	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
111	87	1	1	1	res_bank user	t	t	f	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
112	32	2	1	1	ir_filters all	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
113	32	1	1	1	ir_filters all	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
114	32	10	1	1	ir_filters all	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
115	32	11	1	1	ir_filters all	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
116	37	4	1	1	ir_config_parameter_system	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
117	39	4	1	1	ir_mail_server	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
118	63	2	1	1	ir_logging admin	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
119	73	1	1	1	ir_actions_report_paperformat group_portal	t	t	f	f	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
120	73	4	1	1	ir_actions_report_paperformat group_system	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
121	72	1	1	1	access_report_layout	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
122	11	4	1	1	access.wizard.ir.model.menu.create	t	t	t	t	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
123	17	2	1	1	access.reset.view.arch.wizard	t	t	t	t	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
124	69	4	1	1	access.ir.demo	t	t	t	t	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
125	70	4	1	1	access.ir.demo_failure	t	t	t	t	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
126	71	4	1	1	access.ir.demo_failure.wizard	t	t	t	t	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
127	89	4	1	1	access.res.config	t	t	t	t	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
128	90	4	1	1	access.res.config.installer	t	t	t	t	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
129	91	4	1	1	access.res.config.settings	t	t	t	t	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
130	99	2	1	1	access.change.password.wizard	t	t	t	t	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
131	100	2	1	1	access.change.password.user	t	t	t	t	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
132	101	1	1	1	access.change.password.own	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
133	109	4	1	1	access.base.module.update	t	t	t	t	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
134	110	4	1	1	access.base.language.install	t	t	t	t	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
135	111	4	1	1	access.base.language.import	t	t	t	t	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
136	112	4	1	1	access.base.module.upgrade	t	t	t	t	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
137	113	4	1	1	access.base.module.uninstall	t	t	t	t	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
138	114	1	1	1	access.base.language.export	t	t	t	t	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
139	115	9	1	1	access.base.partner.merge.line	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
140	116	9	1	1	access.base.partner.merge.automatic.wizard	t	t	t	t	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
141	74	4	1	1	ir_profile	t	t	t	t	t	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
142	75	4	1	1	access.base.enable.profiling.wizard	t	t	t	t	f	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
143	118	4	1	1	access.base.document.layout	t	t	t	t	f	2024-01-07 05:20:57.526545	2024-01-07 05:20:57.526545
144	120	1	1	1	auth_totp wizard access rules	t	t	t	t	t	2024-01-07 05:21:10.845793	2024-01-07 05:21:10.845793
145	119	1	1	1	TOTP Device access employees	t	t	f	f	f	2024-01-07 05:21:10.845793	2024-01-07 05:21:10.845793
146	119	10	1	1	TOTP Device access portal	t	t	f	f	f	2024-01-07 05:21:10.845793	2024-01-07 05:21:10.845793
147	121	1	1	1	base.import.mapping	t	t	t	t	t	2024-01-07 05:21:18.450563	2024-01-07 05:21:18.450563
148	122	1	1	1	access.base_import.import	t	t	t	t	f	2024-01-07 05:21:18.450563	2024-01-07 05:21:18.450563
149	123	4	1	1	access.base.import.module	t	t	t	t	f	2024-01-07 05:21:24.595842	2024-01-07 05:21:24.595842
150	124	\N	1	1	bus.bus public	t	f	f	f	f	2024-01-07 05:21:28.653743	2024-01-07 05:21:28.653743
151	125	1	1	1	bus.presence	t	t	t	t	t	2024-01-07 05:21:28.653743	2024-01-07 05:21:28.653743
152	125	10	1	1	bus.presence	t	t	t	t	t	2024-01-07 05:21:28.653743	2024-01-07 05:21:28.653743
153	127	4	1	1	access_web_tour_tour_admin	t	t	f	t	f	2024-01-07 05:21:31.348048	2024-01-07 05:21:31.348048
154	127	1	1	1	access_web_tour_tour	t	t	f	f	f	2024-01-07 05:21:31.348048	2024-01-07 05:21:31.348048
155	128	4	1	1	iap.account.manager	t	t	t	t	t	2024-01-07 05:21:33.025685	2024-01-07 05:21:33.025685
156	128	1	1	1	iap.account.user	t	t	f	t	f	2024-01-07 05:21:33.025685	2024-01-07 05:21:33.025685
157	129	1	1	1	access_iap_account_info	t	t	t	t	t	2024-01-07 05:21:33.025685	2024-01-07 05:21:33.025685
158	134	4	1	1	access_web_editor_converter_test	t	t	t	t	t	2024-01-07 05:21:36.556385	2024-01-07 05:21:36.556385
159	135	4	1	1	access_web_editor_converter_test_sub	t	t	t	t	t	2024-01-07 05:21:36.556385	2024-01-07 05:21:36.556385
\.


--
-- Data for Name: ir_model_constraint; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.ir_model_constraint (id, model, module, create_uid, write_uid, name, definition, type, message, write_date, create_date) FROM stdin;
1	3	273	1	1	ir_model_obj_name_uniq	unique(model)	u	{"en_US": "Each model must have a unique name."}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
2	4	273	1	1	ir_model_fields_name_unique	unique(model,name)	u	{"en_US": "Field names must be unique per model."}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
3	4	273	1	1	ir_model_fields_size_gt_zero	check(size>=0)	u	{"en_US": "Size of the field cannot be negative."}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
4	4	273	1	1	ir_model_fields_name_manual_field	check(state != 'manual' or name like 'x\\_%')	u	{"en_US": "Custom fields must have a name that starts with 'x_'!"}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
5	5	273	1	1	ir_model_inherit_uniq	unique(model_id,parent_id)	u	{"en_US": "Models inherits from another only once"}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
6	6	273	1	1	ir_model_fields_selection_selection_field_uniq	unique(field_id,value)	u	{"en_US": "Selections values must be unique per field"}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
7	7	273	1	1	ir_model_constraint_module_name_uniq	unique(name,module)	u	{"en_US": "Constraints with the same name are unique per module."}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
8	10	273	1	1	ir_model_data_name_nospaces	check(name not like '% %')	u	{"en_US": "External IDs cannot contain spaces"}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
9	16	273	1	1	ir_ui_view_inheritance_mode	check(mode != 'extension' or inherit_id is not null)	u	{"en_US": "Invalid inheritance mode: if the mode is 'extension', the view must extend an other view"}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
10	16	273	1	1	ir_ui_view_qweb_required_key	check(type != 'qweb' or key is not null)	u	{"en_US": "Invalid key: QWeb view should have a key"}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
11	32	273	1	1	ir_filters_name_model_uid_unique	unique(model_id,user_id,action_id,name)	u	{"en_US": "Filter names must be unique"}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
12	36	273	1	1	ir_rule_no_access_rights	check(perm_read!=false or perm_write!=false or perm_create!=false or perm_unlink!=false)	u	{"en_US": "Rule must have at least one checked access right!"}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
13	37	273	1	1	ir_config_parameter_key_uniq	unique(key)	u	{"en_US": "Key must be unique."}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
14	66	273	1	1	ir_module_module_name_uniq	unique(name)	u	{"en_US": "The name of the module must be unique!"}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
15	78	273	1	1	res_country_name_uniq	unique(name)	u	{"en_US": "The name of the country must be unique!"}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
16	78	273	1	1	res_country_code_uniq	unique(code)	u	{"en_US": "The code of the country must be unique!"}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
17	80	273	1	1	res_country_state_name_code_uniq	unique(country_id,code)	u	{"en_US": "The code of the state must be unique by country!"}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
18	81	273	1	1	res_lang_name_uniq	unique(name)	u	{"en_US": "The name of the language must be unique!"}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
19	81	273	1	1	res_lang_code_uniq	unique(code)	u	{"en_US": "The code of the language must be unique!"}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
20	81	273	1	1	res_lang_url_code_uniq	unique(url_code)	u	{"en_US": "The URL code of the language must be unique!"}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
21	85	273	1	1	res_partner_check_name	check((type='contact' and name is not null) or(type!='contact') )	u	{"en_US": "Contacts require a name"}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
22	88	273	1	1	res_partner_bank_unique_number	unique(sanitized_acc_number,partner_id)	u	{"en_US": "The combination Account Number/Partner must be unique."}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
23	92	273	1	1	res_currency_unique_name	unique(name)	u	{"en_US": "The currency code must be unique!"}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
24	92	273	1	1	res_currency_rounding_gt_zero	check(rounding>0)	u	{"en_US": "The rounding factor must be greater than 0!"}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
25	93	273	1	1	res_currency_rate_unique_name_per_day	unique(name,currency_id,company_id)	u	{"en_US": "Only one currency rate per day allowed!"}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
26	93	273	1	1	res_currency_rate_currency_rate_check	check(rate>0)	u	{"en_US": "The currency rate must be strictly positive."}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
27	94	273	1	1	res_company_name_uniq	unique(name)	u	{"en_US": "The company name must be unique!"}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
28	95	273	1	1	res_groups_name_uniq	unique(category_id,name)	u	{"en_US": "The name of the group must be unique within an application!"}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
29	97	273	1	1	res_users_login_key	unique(login)	u	{"en_US": "You can not have two users with the same login!"}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
30	105	273	1	1	res_users_settings_unique_user_id	unique(user_id)	u	{"en_US": "One user should only have one user settings."}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
31	107	273	1	1	decimal_precision_name_uniq	unique(name)	u	{"en_US": "Only one value can be defined for each given usage!"}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
32	3	273	1	1	ir_model_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
33	3	273	1	1	ir_model_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
34	4	273	1	1	ir_model_fields_group_rel_field_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
35	4	273	1	1	ir_model_fields_group_rel_group_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
36	4	273	1	1	ir_model_fields_relation_field_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
37	4	273	1	1	ir_model_fields_model_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
38	4	273	1	1	ir_model_fields_related_field_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
39	4	273	1	1	ir_model_fields_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
40	4	273	1	1	ir_model_fields_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
41	5	273	1	1	ir_model_inherit_model_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
42	5	273	1	1	ir_model_inherit_parent_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
43	5	273	1	1	ir_model_inherit_parent_field_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
44	6	273	1	1	ir_model_fields_selection_field_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
45	6	273	1	1	ir_model_fields_selection_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
46	6	273	1	1	ir_model_fields_selection_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
47	7	273	1	1	ir_model_constraint_model_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
48	7	273	1	1	ir_model_constraint_module_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
49	7	273	1	1	ir_model_constraint_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
50	7	273	1	1	ir_model_constraint_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
51	8	273	1	1	ir_model_relation_model_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
52	8	273	1	1	ir_model_relation_module_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
53	8	273	1	1	ir_model_relation_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
54	8	273	1	1	ir_model_relation_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
55	9	273	1	1	ir_model_access_model_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
56	9	273	1	1	ir_model_access_group_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
57	9	273	1	1	ir_model_access_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
58	9	273	1	1	ir_model_access_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
59	10	273	1	1	ir_model_data_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
60	10	273	1	1	ir_model_data_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
61	11	273	1	1	wizard_ir_model_menu_create_menu_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
62	11	273	1	1	wizard_ir_model_menu_create_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
63	11	273	1	1	wizard_ir_model_menu_create_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
64	12	273	1	1	ir_sequence_company_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
65	12	273	1	1	ir_sequence_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
66	12	273	1	1	ir_sequence_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
67	13	273	1	1	ir_sequence_date_range_sequence_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
68	13	273	1	1	ir_sequence_date_range_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
69	13	273	1	1	ir_sequence_date_range_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
70	95	273	1	1	ir_ui_menu_group_rel_menu_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
71	14	273	1	1	ir_ui_menu_group_rel_gid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
72	14	273	1	1	ir_ui_menu_parent_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
73	14	273	1	1	ir_ui_menu_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
74	14	273	1	1	ir_ui_menu_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
75	15	273	1	1	ir_ui_view_custom_ref_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
76	15	273	1	1	ir_ui_view_custom_user_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
77	15	273	1	1	ir_ui_view_custom_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
78	15	273	1	1	ir_ui_view_custom_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
79	95	273	1	1	ir_ui_view_group_rel_view_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
80	16	273	1	1	ir_ui_view_group_rel_group_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
81	16	273	1	1	ir_ui_view_inherit_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
82	16	273	1	1	ir_ui_view_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
83	16	273	1	1	ir_ui_view_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
84	17	273	1	1	reset_view_arch_wizard_view_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
85	17	273	1	1	reset_view_arch_wizard_compare_view_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
86	17	273	1	1	reset_view_arch_wizard_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
87	17	273	1	1	reset_view_arch_wizard_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
88	18	273	1	1	ir_asset_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
89	18	273	1	1	ir_asset_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
90	22	273	1	1	ir_actions_binding_model_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
91	22	273	1	1	ir_actions_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
92	22	273	1	1	ir_actions_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
93	20	273	1	1	ir_act_window_group_rel_act_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
94	20	273	1	1	ir_act_window_group_rel_gid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
95	20	273	1	1	ir_act_window_binding_model_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
96	20	273	1	1	ir_act_window_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
97	20	273	1	1	ir_act_window_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
98	20	273	1	1	ir_act_window_view_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
99	20	273	1	1	ir_act_window_search_view_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
100	21	273	1	1	ir_act_window_view_view_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
101	21	273	1	1	ir_act_window_view_act_window_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
102	21	273	1	1	ir_act_window_view_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
103	21	273	1	1	ir_act_window_view_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
104	23	273	1	1	ir_act_url_binding_model_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
105	23	273	1	1	ir_act_url_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
106	23	273	1	1	ir_act_url_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
107	24	273	1	1	rel_server_actions_server_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
108	24	273	1	1	rel_server_actions_action_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
109	24	273	1	1	ir_act_server_group_rel_act_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
110	24	273	1	1	ir_act_server_group_rel_gid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
111	24	273	1	1	ir_act_server_webhook_field_rel_server_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
112	24	273	1	1	ir_act_server_webhook_field_rel_field_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
113	24	273	1	1	ir_act_server_binding_model_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
114	24	273	1	1	ir_act_server_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
115	24	273	1	1	ir_act_server_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
116	24	273	1	1	ir_act_server_model_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
117	24	273	1	1	ir_act_server_crud_model_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
118	24	273	1	1	ir_act_server_link_field_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
119	24	273	1	1	ir_act_server_update_field_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
120	24	273	1	1	ir_act_server_update_related_model_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
121	24	273	1	1	ir_act_server_selection_value_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
122	25	273	1	1	ir_actions_todo_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
123	25	273	1	1	ir_actions_todo_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
124	26	273	1	1	ir_act_client_binding_model_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
125	26	273	1	1	ir_act_client_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
126	26	273	1	1	ir_act_client_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
127	27	273	1	1	res_groups_report_rel_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
128	27	273	1	1	res_groups_report_rel_gid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
129	27	273	1	1	ir_act_report_xml_binding_model_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
130	27	273	1	1	ir_act_report_xml_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
131	27	273	1	1	ir_act_report_xml_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
132	27	273	1	1	ir_act_report_xml_paperformat_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
133	28	273	1	1	ir_attachment_company_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
134	28	273	1	1	ir_attachment_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
135	28	273	1	1	ir_attachment_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
136	30	273	1	1	ir_cron_ir_actions_server_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
137	30	273	1	1	ir_cron_user_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
138	30	273	1	1	ir_cron_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
139	30	273	1	1	ir_cron_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
140	31	273	1	1	ir_cron_trigger_cron_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
141	31	273	1	1	ir_cron_trigger_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
142	31	273	1	1	ir_cron_trigger_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
143	32	273	1	1	ir_filters_user_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
144	32	273	1	1	ir_filters_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
145	32	273	1	1	ir_filters_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
146	33	273	1	1	ir_default_field_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
147	33	273	1	1	ir_default_user_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
148	33	273	1	1	ir_default_company_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
149	33	273	1	1	ir_default_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
150	33	273	1	1	ir_default_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
151	34	273	1	1	ir_exports_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
152	34	273	1	1	ir_exports_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
153	35	273	1	1	ir_exports_line_export_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
154	35	273	1	1	ir_exports_line_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
155	35	273	1	1	ir_exports_line_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
156	95	273	1	1	rule_group_rel_rule_group_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
157	36	273	1	1	rule_group_rel_group_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
158	36	273	1	1	ir_rule_model_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
159	36	273	1	1	ir_rule_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
160	36	273	1	1	ir_rule_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
161	37	273	1	1	ir_config_parameter_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
162	37	273	1	1	ir_config_parameter_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
163	39	273	1	1	ir_mail_server_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
164	39	273	1	1	ir_mail_server_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
165	64	273	1	1	ir_property_company_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
166	64	273	1	1	ir_property_fields_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
167	64	273	1	1	ir_property_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
168	64	273	1	1	ir_property_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
169	65	273	1	1	ir_module_category_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
170	65	273	1	1	ir_module_category_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
171	66	273	1	1	ir_module_module_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
172	66	273	1	1	ir_module_module_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
173	68	273	1	1	ir_module_module_exclusion_module_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
174	68	273	1	1	ir_module_module_exclusion_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
175	68	273	1	1	ir_module_module_exclusion_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
176	69	273	1	1	ir_demo_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
177	69	273	1	1	ir_demo_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
178	70	273	1	1	ir_demo_failure_module_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
179	70	273	1	1	ir_demo_failure_wizard_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
180	70	273	1	1	ir_demo_failure_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
181	70	273	1	1	ir_demo_failure_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
182	71	273	1	1	ir_demo_failure_wizard_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
183	71	273	1	1	ir_demo_failure_wizard_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
184	72	273	1	1	report_layout_view_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
185	72	273	1	1	report_layout_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
186	72	273	1	1	report_layout_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
187	73	273	1	1	report_paperformat_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
188	73	273	1	1	report_paperformat_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
189	75	273	1	1	base_enable_profiling_wizard_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
190	75	273	1	1	base_enable_profiling_wizard_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
191	79	273	1	1	res_country_res_country_group_rel_res_country_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
192	78	273	1	1	res_country_res_country_group_rel_res_country_group_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
193	78	273	1	1	res_country_address_view_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
194	78	273	1	1	res_country_currency_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
195	78	273	1	1	res_country_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
196	78	273	1	1	res_country_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
197	79	273	1	1	res_country_group_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
198	79	273	1	1	res_country_group_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
199	80	273	1	1	res_country_state_country_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
200	80	273	1	1	res_country_state_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
201	80	273	1	1	res_country_state_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
202	81	273	1	1	res_lang_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
203	81	273	1	1	res_lang_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
204	85	273	1	1	res_partner_res_partner_category_rel_category_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
205	83	273	1	1	res_partner_res_partner_category_rel_partner_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
206	83	273	1	1	res_partner_category_parent_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
207	83	273	1	1	res_partner_category_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
208	83	273	1	1	res_partner_category_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
209	84	273	1	1	res_partner_title_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
210	84	273	1	1	res_partner_title_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
211	85	273	1	1	res_partner_title_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
212	85	273	1	1	res_partner_parent_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
213	85	273	1	1	res_partner_user_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
214	85	273	1	1	res_partner_state_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
215	85	273	1	1	res_partner_country_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
216	85	273	1	1	res_partner_industry_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
217	85	273	1	1	res_partner_company_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
218	85	273	1	1	res_partner_commercial_partner_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
219	85	273	1	1	res_partner_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
220	85	273	1	1	res_partner_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
221	86	273	1	1	res_partner_industry_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
222	86	273	1	1	res_partner_industry_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
223	87	273	1	1	res_bank_state_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
224	87	273	1	1	res_bank_country_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
225	87	273	1	1	res_bank_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
226	87	273	1	1	res_bank_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
227	88	273	1	1	res_partner_bank_partner_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
228	88	273	1	1	res_partner_bank_bank_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
229	88	273	1	1	res_partner_bank_currency_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
230	88	273	1	1	res_partner_bank_company_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
231	88	273	1	1	res_partner_bank_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
232	88	273	1	1	res_partner_bank_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
233	89	273	1	1	res_config_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
234	89	273	1	1	res_config_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
235	90	273	1	1	res_config_installer_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
236	90	273	1	1	res_config_installer_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
237	91	273	1	1	res_config_settings_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
238	91	273	1	1	res_config_settings_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
239	92	273	1	1	res_currency_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
240	92	273	1	1	res_currency_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
241	93	273	1	1	res_currency_rate_currency_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
242	93	273	1	1	res_currency_rate_company_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
243	93	273	1	1	res_currency_rate_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
244	93	273	1	1	res_currency_rate_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
245	97	273	1	1	res_company_users_rel_cid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
246	94	273	1	1	res_company_users_rel_user_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
247	94	273	1	1	res_company_parent_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
248	94	273	1	1	res_company_partner_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
249	94	273	1	1	res_company_currency_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
250	94	273	1	1	res_company_paperformat_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
251	94	273	1	1	res_company_external_report_layout_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
252	94	273	1	1	res_company_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
253	94	273	1	1	res_company_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
254	97	273	1	1	res_groups_users_rel_gid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
255	95	273	1	1	res_groups_users_rel_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
256	95	273	1	1	res_groups_implied_rel_gid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
257	95	273	1	1	res_groups_implied_rel_hid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
258	95	273	1	1	res_groups_category_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
259	95	273	1	1	res_groups_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
260	95	273	1	1	res_groups_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
261	96	273	1	1	res_users_log_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
262	96	273	1	1	res_users_log_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
263	97	273	1	1	res_users_partner_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
264	97	273	1	1	res_users_company_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
265	97	273	1	1	res_users_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
266	97	273	1	1	res_users_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
267	98	273	1	1	res_users_identitycheck_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
268	98	273	1	1	res_users_identitycheck_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
269	99	273	1	1	change_password_wizard_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
270	99	273	1	1	change_password_wizard_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
271	100	273	1	1	change_password_user_wizard_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
272	100	273	1	1	change_password_user_user_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
273	100	273	1	1	change_password_user_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
274	100	273	1	1	change_password_user_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
275	101	273	1	1	change_password_own_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
276	101	273	1	1	change_password_own_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
277	103	273	1	1	res_users_apikeys_description_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
278	103	273	1	1	res_users_apikeys_description_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
279	105	273	1	1	res_users_settings_user_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
280	105	273	1	1	res_users_settings_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
281	105	273	1	1	res_users_settings_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
282	106	273	1	1	res_users_deletion_user_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
283	106	273	1	1	res_users_deletion_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
284	106	273	1	1	res_users_deletion_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
285	107	273	1	1	decimal_precision_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
286	107	273	1	1	decimal_precision_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
287	109	273	1	1	base_module_update_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
288	109	273	1	1	base_module_update_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
289	110	273	1	1	res_lang_install_rel_language_wizard_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
290	110	273	1	1	res_lang_install_rel_lang_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
291	110	273	1	1	base_language_install_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
292	110	273	1	1	base_language_install_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
293	111	273	1	1	base_language_import_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
294	111	273	1	1	base_language_import_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
295	112	273	1	1	base_module_upgrade_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
296	112	273	1	1	base_module_upgrade_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
297	113	273	1	1	base_module_uninstall_module_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
298	113	273	1	1	base_module_uninstall_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
299	113	273	1	1	base_module_uninstall_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
300	114	273	1	1	rel_modules_langexport_wiz_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
301	114	273	1	1	rel_modules_langexport_module_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
302	114	273	1	1	base_language_export_model_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
303	114	273	1	1	base_language_export_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
304	114	273	1	1	base_language_export_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
305	115	273	1	1	base_partner_merge_line_wizard_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
306	115	273	1	1	base_partner_merge_line_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
307	115	273	1	1	base_partner_merge_line_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
308	116	273	1	1	base_partner_merge_automatic__base_partner_merge_automatic_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
309	116	273	1	1	base_partner_merge_automatic_wizard_res_par_res_partner_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
310	116	273	1	1	base_partner_merge_automatic_wizard_current_line_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
311	116	273	1	1	base_partner_merge_automatic_wizard_dst_partner_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
312	116	273	1	1	base_partner_merge_automatic_wizard_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
313	116	273	1	1	base_partner_merge_automatic_wizard_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639
314	118	288	1	1	base_document_layout_company_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:20:57.526545	2024-01-07 05:20:57.526545
315	118	288	1	1	base_document_layout_report_layout_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:20:57.526545	2024-01-07 05:20:57.526545
316	118	288	1	1	base_document_layout_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:20:57.526545	2024-01-07 05:20:57.526545
317	118	288	1	1	base_document_layout_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:20:57.526545	2024-01-07 05:20:57.526545
318	120	41	1	1	auth_totp_wizard_user_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:21:10.845793	2024-01-07 05:21:10.845793
319	120	41	1	1	auth_totp_wizard_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:21:10.845793	2024-01-07 05:21:10.845793
320	120	41	1	1	auth_totp_wizard_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:21:10.845793	2024-01-07 05:21:10.845793
321	121	163	1	1	base_import_mapping_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:21:18.450563	2024-01-07 05:21:18.450563
322	121	163	1	1	base_import_mapping_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:21:18.450563	2024-01-07 05:21:18.450563
323	122	163	1	1	base_import_import_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:21:18.450563	2024-01-07 05:21:18.450563
324	122	163	1	1	base_import_import_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:21:18.450563	2024-01-07 05:21:18.450563
325	123	452	1	1	base_import_module_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:21:24.595842	2024-01-07 05:21:24.595842
326	123	452	1	1	base_import_module_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:21:24.595842	2024-01-07 05:21:24.595842
327	91	331	1	1	res_config_settings_company_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:21:27.729604	2024-01-07 05:21:27.729604
328	124	278	1	1	bus_bus_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:21:28.653743	2024-01-07 05:21:28.653743
329	124	278	1	1	bus_bus_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:21:28.653743	2024-01-07 05:21:28.653743
330	125	278	1	1	bus_presence_user_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:21:28.653743	2024-01-07 05:21:28.653743
331	127	96	1	1	web_tour_tour_user_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:21:31.348048	2024-01-07 05:21:31.348048
332	128	499	1	1	iap_account_res_company_rel_iap_account_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:21:33.025685	2024-01-07 05:21:33.025685
333	128	499	1	1	iap_account_res_company_rel_res_company_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:21:33.025685	2024-01-07 05:21:33.025685
334	128	499	1	1	iap_account_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:21:33.025685	2024-01-07 05:21:33.025685
335	128	499	1	1	iap_account_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:21:33.025685	2024-01-07 05:21:33.025685
336	129	499	1	1	iap_account_info_account_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:21:33.025685	2024-01-07 05:21:33.025685
337	129	499	1	1	iap_account_info_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:21:33.025685	2024-01-07 05:21:33.025685
338	129	499	1	1	iap_account_info_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:21:33.025685	2024-01-07 05:21:33.025685
339	28	399	1	1	ir_attachment_original_id_fkey	\N	f	{"en_US": null}	2024-01-07 05:21:36.556385	2024-01-07 05:21:36.556385
340	134	399	1	1	web_editor_converter_test_many2one_fkey	\N	f	{"en_US": null}	2024-01-07 05:21:36.556385	2024-01-07 05:21:36.556385
341	134	399	1	1	web_editor_converter_test_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:21:36.556385	2024-01-07 05:21:36.556385
342	134	399	1	1	web_editor_converter_test_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:21:36.556385	2024-01-07 05:21:36.556385
343	135	399	1	1	web_editor_converter_test_sub_create_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:21:36.556385	2024-01-07 05:21:36.556385
344	135	399	1	1	web_editor_converter_test_sub_write_uid_fkey	\N	f	{"en_US": null}	2024-01-07 05:21:36.556385	2024-01-07 05:21:36.556385
\.


--
-- Data for Name: ir_model_data; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.ir_model_data (id, create_uid, create_date, write_date, write_uid, res_id, noupdate, name, module, model) FROM stdin;
1	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	1	t	USD	base	res.currency
2	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	1	t	main_company	base	res.company
3	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	1	t	main_partner	base	res.partner
4	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	1	t	user_root	base	res.users
5	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	1	t	group_user	base	res.groups
6	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	1	t	module_category_inventory	base	ir.module.category
7	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	2	t	module_category_inventory_purchase	base	ir.module.category
8	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	1	t	module_purchase_mrp	base	ir.module.module
9	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	3	t	module_category_hidden	base	ir.module.category
10	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	2	t	module_payment	base	ir.module.module
11	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	4	t	module_category_marketing	base	ir.module.category
12	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	5	t	module_category_marketing_events	base	ir.module.category
13	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	3	t	module_event_booth_sale	base	ir.module.module
14	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	6	t	module_category_accounting	base	ir.module.category
15	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	7	t	module_category_accounting_localizations	base	ir.module.category
16	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	8	t	module_category_accounting_localizations_point_of_sale	base	ir.module.category
17	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	4	t	module_l10n_ar_pos	base	ir.module.module
18	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	9	t	module_category_productivity	base	ir.module.category
19	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	10	t	module_category_productivity_discuss	base	ir.module.category
20	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	5	t	module_im_livechat_mail_bot	base	ir.module.module
21	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	11	t	module_category_hidden_tools	base	ir.module.category
22	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	6	t	module_snailmail_account	base	ir.module.module
23	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	12	t	module_category_accounting_localizations_account_charts	base	ir.module.category
24	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	7	t	module_l10n_us	base	ir.module.module
25	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	8	t	module_microsoft_account	base	ir.module.module
26	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	13	t	module_category_accounting_payment_providers	base	ir.module.category
27	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	9	t	module_payment_payumoney	base	ir.module.module
28	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	10	t	module_website_event_track_live_quiz	base	ir.module.module
29	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	14	t	module_category_website	base	ir.module.category
30	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	15	t	module_category_website_website	base	ir.module.category
31	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	11	t	module_website_sale_loyalty	base	ir.module.module
32	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	12	t	module_sale_crm	base	ir.module.module
33	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	13	t	module_website_partner	base	ir.module.module
34	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	14	t	module_theme_common	base	ir.module.module
35	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	15	t	module_test_html_field_history	base	ir.module.module
36	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	16	t	module_auth_ldap	base	ir.module.module
37	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	16	t	module_category_sales	base	ir.module.category
38	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	17	t	module_category_sales_point_of_sale	base	ir.module.category
39	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	17	t	module_pos_six	base	ir.module.module
40	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	18	t	module_sale_stock	base	ir.module.module
41	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	19	t	module_hr_org_chart	base	ir.module.module
42	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	20	t	module_pos_epson_printer	base	ir.module.module
43	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	18	t	module_category_sales_sales	base	ir.module.category
44	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	21	t	module_sale_margin	base	ir.module.module
45	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	22	t	module_project_account	base	ir.module.module
46	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	23	t	module_board	base	ir.module.module
47	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	24	t	module_uom	base	ir.module.module
48	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	25	t	module_spreadsheet_dashboard_account	base	ir.module.module
49	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	26	t	module_project_sale_expense	base	ir.module.module
50	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	27	t	module_purchase_stock	base	ir.module.module
51	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	19	t	module_category_services	base	ir.module.category
52	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	20	t	module_category_services_project	base	ir.module.category
53	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	28	t	module_project_mrp	base	ir.module.module
54	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	21	t	module_category_accounting_localizations_purchase	base	ir.module.category
55	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	29	t	module_l10n_in_purchase	base	ir.module.module
56	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	30	t	module_l10n_nl	base	ir.module.module
57	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	31	t	module_payment_aps	base	ir.module.module
58	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	22	t	module_category_human_resources	base	ir.module.category
59	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	32	t	module_hr_fleet	base	ir.module.module
60	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	33	t	module_website_payment	base	ir.module.module
61	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	34	t	module_l10n_sk	base	ir.module.module
62	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	23	t	module_category_website_elearning	base	ir.module.category
63	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	35	t	module_website_slides_survey	base	ir.module.module
64	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	36	t	module_sale_project	base	ir.module.module
65	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	37	t	module_hr_maintenance	base	ir.module.module
66	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	24	t	module_category_hidden_tests	base	ir.module.category
67	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	38	t	module_test_action_bindings	base	ir.module.module
68	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	39	t	module_google_account	base	ir.module.module
69	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	40	t	module_test_mail_sms	base	ir.module.module
70	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	25	t	module_category_extra_tools	base	ir.module.category
71	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	41	t	module_auth_totp	base	ir.module.module
72	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	42	t	module_payment_adyen	base	ir.module.module
73	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	26	t	module_category_human_resources_remote_work	base	ir.module.category
74	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	43	t	module_hr_homeworking	base	ir.module.module
75	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	27	t	module_category_theme	base	ir.module.category
76	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	28	t	module_category_theme_corporate	base	ir.module.category
77	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	44	t	module_theme_enark	base	ir.module.module
78	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	45	t	module_mail_bot_hr	base	ir.module.module
79	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	46	t	module_mass_mailing_event	base	ir.module.module
80	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	47	t	module_l10n_din5008	base	ir.module.module
81	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	48	t	module_l10n_latam_check	base	ir.module.module
82	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	49	t	module_base_sparse_field	base	ir.module.module
83	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	50	t	module_product	base	ir.module.module
84	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	51	t	module_base_automation	base	ir.module.module
85	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	52	t	module_website_sale_comparison	base	ir.module.module
86	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	53	t	module_payment_razorpay	base	ir.module.module
87	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	54	t	module_project_purchase	base	ir.module.module
88	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	55	t	module_auth_signup	base	ir.module.module
89	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	56	t	module_l10n_za	base	ir.module.module
90	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	57	t	module_website_event_booth_exhibitor	base	ir.module.module
91	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	58	t	module_pos_adyen	base	ir.module.module
92	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	29	t	module_category_accounting_localizations_sale	base	ir.module.category
93	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	59	t	module_l10n_in_sale_stock	base	ir.module.module
94	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	30	t	module_category_theme_creative	base	ir.module.category
95	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	60	t	module_theme_artists	base	ir.module.module
96	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	61	t	module_l10n_bo	base	ir.module.module
97	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	62	t	module_spreadsheet_dashboard_hr_timesheet	base	ir.module.module
98	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	63	t	module_sale_purchase_stock	base	ir.module.module
99	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	64	t	module_website_crm_livechat	base	ir.module.module
100	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	65	t	module_l10n_din5008_purchase	base	ir.module.module
101	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	66	t	module_hr_timesheet_attendance	base	ir.module.module
102	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	67	t	module_website	base	ir.module.module
103	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	68	t	module_theme_avantgarde	base	ir.module.module
104	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	69	t	module_test_website_slides_full	base	ir.module.module
105	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	70	t	module_pos_hr_restaurant	base	ir.module.module
106	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	71	t	module_spreadsheet_dashboard_im_livechat	base	ir.module.module
107	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	31	t	module_category_theme_retail	base	ir.module.category
108	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	72	t	module_theme_notes	base	ir.module.module
109	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	32	t	module_category_accounting_localizations_edi	base	ir.module.category
110	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	73	t	module_l10n_ke_edi_tremol	base	ir.module.module
111	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	74	t	module_l10n_no	base	ir.module.module
112	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	75	t	module_l10n_es_pos	base	ir.module.module
113	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	76	t	module_website_links	base	ir.module.module
114	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	77	t	module_l10n_in	base	ir.module.module
115	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	78	t	module_test_http	base	ir.module.module
116	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	79	t	module_l10n_in_edi	base	ir.module.module
117	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	80	t	module_test_sale_product_configurators	base	ir.module.module
118	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	81	t	module_l10n_ma	base	ir.module.module
119	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	82	t	module_website_slides	base	ir.module.module
120	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	83	t	module_test_inherits	base	ir.module.module
121	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	33	t	module_category_accounting_payment	base	ir.module.category
122	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	84	t	module_account_qr_code_emv	base	ir.module.module
123	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	85	t	module_social_media	base	ir.module.module
124	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	86	t	module_l10n_co	base	ir.module.module
125	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	87	t	module_spreadsheet_dashboard_website_sale	base	ir.module.module
126	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	88	t	module_l10n_es	base	ir.module.module
127	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	89	t	module_l10n_ec	base	ir.module.module
128	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	34	t	module_category_accounting_accounting	base	ir.module.category
129	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	90	t	module_account_peppol	base	ir.module.module
130	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	91	t	module_sms	base	ir.module.module
131	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	35	t	module_category_theme_lifestyle	base	ir.module.category
132	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	92	t	module_theme_nano	base	ir.module.module
133	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	93	t	module_l10n_es_edi_facturae	base	ir.module.module
134	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	94	t	module_spreadsheet_dashboard_sale_timesheet	base	ir.module.module
135	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	95	t	module_website_form_project	base	ir.module.module
136	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	96	t	module_web_tour	base	ir.module.module
137	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	97	t	module_test_mail_full	base	ir.module.module
138	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	98	t	module_l10n_ua	base	ir.module.module
139	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	99	t	module_l10n_be	base	ir.module.module
140	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	36	t	module_category_human_resources_employees	base	ir.module.category
141	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	100	t	module_hr_work_entry	base	ir.module.module
142	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	101	t	module_test_website	base	ir.module.module
143	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	102	t	module_sales_team	base	ir.module.module
144	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	103	t	module_google_calendar	base	ir.module.module
145	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	104	t	module_pos_self_order_epson_printer	base	ir.module.module
146	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	105	t	module_website_sale	base	ir.module.module
147	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	106	t	module_transifex	base	ir.module.module
148	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	107	t	module_l10n_ro_edi	base	ir.module.module
149	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	108	t	module_test_uninstall	base	ir.module.module
150	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	37	t	module_category_human_resources_contracts	base	ir.module.category
151	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	109	t	module_hr_contract	base	ir.module.module
152	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	110	t	module_pos_self_order	base	ir.module.module
153	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	111	t	module_test_impex	base	ir.module.module
154	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	112	t	module_l10n_ph	base	ir.module.module
155	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	113	t	module_l10n_it_edi	base	ir.module.module
156	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	114	t	module_purchase_product_matrix	base	ir.module.module
157	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	115	t	module_account_qr_code_sepa	base	ir.module.module
158	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	116	t	module_website_blog	base	ir.module.module
159	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	117	t	module_test_testing_utilities	base	ir.module.module
160	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	118	t	module_l10n_din5008_stock	base	ir.module.module
161	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	119	t	module_l10n_it_stock_ddt	base	ir.module.module
162	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	120	t	module_test_spreadsheet	base	ir.module.module
163	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	121	t	module_l10n_nz	base	ir.module.module
164	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	122	t	module_theme_kiddo	base	ir.module.module
165	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	123	t	module_test_exceptions	base	ir.module.module
166	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	124	t	module_l10n_mx_hr	base	ir.module.module
167	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	125	t	module_l10n_rs	base	ir.module.module
168	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	126	t	module_mass_mailing_event_sms	base	ir.module.module
169	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	127	t	module_website_event_crm	base	ir.module.module
170	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	128	t	module_pos_loyalty	base	ir.module.module
171	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	129	t	module_website_event_jitsi	base	ir.module.module
172	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	130	t	module_l10n_at	base	ir.module.module
173	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	131	t	module_l10n_hr	base	ir.module.module
174	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	132	t	module_l10n_din5008_repair	base	ir.module.module
175	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	133	t	module_hr_gamification	base	ir.module.module
176	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	134	t	module_account	base	ir.module.module
177	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	135	t	module_test_limits	base	ir.module.module
178	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	136	t	module_l10n_ie	base	ir.module.module
179	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	137	t	module_theme_anelusia	base	ir.module.module
180	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	138	t	module_website_payment_authorize	base	ir.module.module
181	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	139	t	module_mail_bot	base	ir.module.module
182	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	140	t	module_project_sms	base	ir.module.module
183	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	141	t	module_mass_mailing_sale	base	ir.module.module
184	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	38	t	module_category_services_employee_hourly_cost	base	ir.module.category
185	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	142	t	module_hr_hourly_cost	base	ir.module.module
186	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	143	t	module_auth_totp_mail	base	ir.module.module
187	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	144	t	module_website_twitter	base	ir.module.module
188	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	145	t	module_l10n_hr_kuna	base	ir.module.module
189	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	146	t	module_website_sale_comparison_wishlist	base	ir.module.module
190	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	147	t	module_l10n_dk_oioubl	base	ir.module.module
191	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	148	t	module_sale_management	base	ir.module.module
192	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	149	t	module_web_unsplash	base	ir.module.module
193	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	150	t	module_hr_skills_slides	base	ir.module.module
194	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	151	t	module_hr_holidays_attendance	base	ir.module.module
195	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	152	t	module_auth_oauth	base	ir.module.module
196	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	153	t	module_l10n_de	base	ir.module.module
197	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	154	t	module_test_access_rights	base	ir.module.module
198	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	155	t	module_web_hierarchy	base	ir.module.module
199	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	156	t	module_onboarding	base	ir.module.module
200	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	39	t	module_category_inventory_delivery	base	ir.module.category
201	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	157	t	module_stock_delivery	base	ir.module.module
202	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	158	t	module_project_timesheet_holidays	base	ir.module.module
203	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	159	t	module_test_performance	base	ir.module.module
204	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	160	t	module_l10n_ee	base	ir.module.module
205	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	161	t	module_l10n_br	base	ir.module.module
206	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	162	t	module_calendar_sms	base	ir.module.module
207	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	163	t	module_base_import	base	ir.module.module
208	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	164	t	module_loyalty	base	ir.module.module
209	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	165	t	module_test_new_api	base	ir.module.module
210	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	166	t	module_microsoft_outlook	base	ir.module.module
211	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	40	t	module_category_inventory_inventory	base	ir.module.category
212	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	167	t	module_stock_dropshipping	base	ir.module.module
213	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	168	t	module_auth_password_policy	base	ir.module.module
214	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	169	t	module_website_jitsi	base	ir.module.module
215	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	170	t	module_utm	base	ir.module.module
216	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	171	t	module_sale_timesheet	base	ir.module.module
217	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	172	t	module_l10n_syscohada	base	ir.module.module
218	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	173	t	module_test_crm_full	base	ir.module.module
219	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	41	t	module_category_manufacturing	base	ir.module.category
220	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	42	t	module_category_manufacturing_manufacturing	base	ir.module.category
221	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	174	t	module_mrp_landed_costs	base	ir.module.module
222	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	175	t	module_hw_escpos	base	ir.module.module
223	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	176	t	module_pos_hr	base	ir.module.module
224	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	177	t	module_l10n_latam_base	base	ir.module.module
225	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	178	t	module_l10n_din5008_sale	base	ir.module.module
226	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	179	t	module_sale_expense	base	ir.module.module
227	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	180	t	module_spreadsheet_dashboard_event_sale	base	ir.module.module
228	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	43	t	module_category_technical	base	ir.module.category
229	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	181	t	module_product_images	base	ir.module.module
230	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	182	t	module_website_sale_autocomplete	base	ir.module.module
231	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	183	t	module_l10n_cl	base	ir.module.module
232	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	44	t	module_category_manufacturing_maintenance	base	ir.module.category
233	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	184	t	module_maintenance	base	ir.module.module
234	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	45	t	module_category_human_resources_recruitment	base	ir.module.category
235	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	185	t	module_hr_recruitment	base	ir.module.module
236	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	46	t	module_category_theme_hidden	base	ir.module.category
237	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	186	t	module_theme_test_custo	base	ir.module.module
238	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	187	t	module_test_data_module	base	ir.module.module
239	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	188	t	module_mrp_account	base	ir.module.module
240	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	189	t	module_l10n_in_sale	base	ir.module.module
241	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	190	t	module_event_sms	base	ir.module.module
242	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	191	t	module_purchase_requisition_sale	base	ir.module.module
243	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	192	t	module_l10n_mn	base	ir.module.module
244	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	193	t	module_spreadsheet_dashboard_website_sale_slides	base	ir.module.module
245	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	194	t	module_event_booth	base	ir.module.module
246	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	195	t	module_hr_recruitment_skills	base	ir.module.module
247	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	47	t	module_category_marketing_email_marketing	base	ir.module.category
248	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	196	t	module_mass_mailing_themes	base	ir.module.module
249	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	197	t	module_l10n_dk	base	ir.module.module
250	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	198	t	module_test_converter	base	ir.module.module
251	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	199	t	module_spreadsheet_dashboard_purchase	base	ir.module.module
252	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	200	t	module_pos_mercury	base	ir.module.module
253	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	201	t	module_l10n_lu	base	ir.module.module
254	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	202	t	module_spreadsheet_account	base	ir.module.module
255	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	203	t	module_product_margin	base	ir.module.module
256	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	48	t	module_category_manufacturing_repair	base	ir.module.category
257	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	204	t	module_mrp_subcontracting_repair	base	ir.module.module
258	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	205	t	module_l10n_my	base	ir.module.module
259	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	206	t	module_payment_ogone	base	ir.module.module
260	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	207	t	module_account_check_printing	base	ir.module.module
261	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	49	t	module_category_tools	base	ir.module.category
262	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	208	t	module_auth_password_policy_portal	base	ir.module.module
263	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	209	t	module_l10n_lt	base	ir.module.module
264	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	210	t	module_portal	base	ir.module.module
265	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	211	t	module_repair	base	ir.module.module
266	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	212	t	module_mass_mailing_crm_sms	base	ir.module.module
267	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	213	t	module_iap_crm	base	ir.module.module
268	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	214	t	module_account_edi_ubl_cii	base	ir.module.module
269	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	215	t	module_account_lock	base	ir.module.module
270	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	216	t	module_sale_mrp_margin	base	ir.module.module
271	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	50	t	module_category_theme_technology	base	ir.module.category
272	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	217	t	module_theme_kea	base	ir.module.module
273	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	51	t	module_category_productivity_data_cleaning	base	ir.module.category
274	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	218	t	module_data_recycle	base	ir.module.module
275	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	52	t	module_category_theme_personal	base	ir.module.category
276	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	219	t	module_theme_yes	base	ir.module.module
277	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	220	t	module_website_hr_recruitment	base	ir.module.module
278	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	221	t	module_l10n_ch	base	ir.module.module
279	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	222	t	module_l10n_gcc_invoice	base	ir.module.module
280	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	223	t	module_l10n_gcc_pos	base	ir.module.module
281	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	224	t	module_barcodes	base	ir.module.module
282	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	53	t	module_category_sales_delivery	base	ir.module.category
283	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	225	t	module_delivery	base	ir.module.module
284	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	226	t	module_test_convert	base	ir.module.module
285	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	227	t	module_base_address_extended	base	ir.module.module
286	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	228	t	module_test_resource	base	ir.module.module
287	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	54	t	module_category_theme_services	base	ir.module.category
288	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	229	t	module_theme_monglia	base	ir.module.module
289	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	230	t	module_delivery_mondialrelay	base	ir.module.module
290	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	231	t	module_product_matrix	base	ir.module.module
291	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	232	t	module_sale_expense_margin	base	ir.module.module
292	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	233	t	module_sale_pdf_quote_builder	base	ir.module.module
293	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	234	t	module_l10n_il	base	ir.module.module
294	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	235	t	module_auth_totp_portal	base	ir.module.module
295	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	236	t	module_purchase_requisition	base	ir.module.module
296	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	237	t	module_spreadsheet_dashboard_purchase_stock	base	ir.module.module
297	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	238	t	module_payment_flutterwave	base	ir.module.module
298	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	239	t	module_l10n_gt	base	ir.module.module
299	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	240	t	module_website_crm	base	ir.module.module
300	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	241	t	module_l10n_sa_pos	base	ir.module.module
301	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	242	t	module_l10n_au	base	ir.module.module
302	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	243	t	module_l10n_cr	base	ir.module.module
303	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	244	t	module_sale_loyalty	base	ir.module.module
304	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	245	t	module_l10n_ke	base	ir.module.module
305	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	246	t	module_account_fleet	base	ir.module.module
306	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	247	t	module_stock_sms	base	ir.module.module
307	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	55	t	module_category_theme_environment	base	ir.module.category
308	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	248	t	module_theme_treehouse	base	ir.module.module
309	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	249	t	module_spreadsheet	base	ir.module.module
310	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	250	t	module_sale_sms	base	ir.module.module
311	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	251	t	module_delivery_stock_picking_batch	base	ir.module.module
312	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	252	t	module_l10n_sa	base	ir.module.module
313	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	56	t	module_category_localization	base	ir.module.category
314	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	253	t	module_l10n_br_sales	base	ir.module.module
315	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	254	t	module_l10n_et	base	ir.module.module
316	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	255	t	module_payment_mollie	base	ir.module.module
317	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	256	t	module_theme_zap	base	ir.module.module
318	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	257	t	module_theme_odoo_experts	base	ir.module.module
319	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	258	t	module_website_event	base	ir.module.module
320	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	259	t	module_mrp_subcontracting	base	ir.module.module
321	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	260	t	module_l10n_hn	base	ir.module.module
322	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	57	t	module_category_human_resources_fleet	base	ir.module.category
323	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	261	t	module_fleet	base	ir.module.module
324	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	262	t	module_test_mimetypes	base	ir.module.module
325	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	263	t	module_website_crm_sms	base	ir.module.module
326	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	264	t	module_website_mass_mailing	base	ir.module.module
327	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	58	t	module_category_sales_crm	base	ir.module.category
328	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	265	t	module_mail_plugin	base	ir.module.module
329	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	266	t	module_payment_asiapay	base	ir.module.module
330	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	59	t	module_category_accounting_localizations_website	base	ir.module.category
331	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	267	t	module_l10n_ar_website_sale	base	ir.module.module
332	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	268	t	module_theme_cobalt	base	ir.module.module
333	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	269	t	module_l10n_pa	base	ir.module.module
334	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	270	t	module_l10n_tn	base	ir.module.module
335	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	271	t	module_website_google_map	base	ir.module.module
336	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	272	t	module_partner_autocomplete	base	ir.module.module
337	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	273	t	module_base	base	ir.module.module
338	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	274	t	module_pos_sale_product_configurator	base	ir.module.module
339	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	275	t	module_mass_mailing_sms	base	ir.module.module
340	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	276	t	module_pos_self_order_stripe	base	ir.module.module
341	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	277	t	module_account_payment	base	ir.module.module
342	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	278	t	module_bus	base	ir.module.module
343	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	279	t	module_event_sale	base	ir.module.module
344	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	280	t	module_l10n_dz	base	ir.module.module
345	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	60	t	module_category_point_of_sale	base	ir.module.category
346	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	281	t	module_pos_restaurant_adyen	base	ir.module.module
347	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	282	t	module_website_crm_partner_assign	base	ir.module.module
348	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	283	t	module_contacts	base	ir.module.module
349	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	284	t	module_purchase_requisition_stock	base	ir.module.module
350	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	61	t	module_category_productivity_calendar	base	ir.module.category
351	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	285	t	module_calendar	base	ir.module.module
352	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	286	t	module_hw_posbox_homepage	base	ir.module.module
353	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	287	t	module_privacy_lookup	base	ir.module.module
354	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	288	t	module_web	base	ir.module.module
355	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	289	t	module_test_mail	base	ir.module.module
356	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	290	t	module_l10n_ve	base	ir.module.module
357	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	62	t	module_category_human_resources_attendances	base	ir.module.category
358	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	291	t	module_hr_attendance	base	ir.module.module
359	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	292	t	module_l10n_pl	base	ir.module.module
360	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	63	t	module_category_manufacturing_purchase	base	ir.module.category
361	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	293	t	module_mrp_subcontracting_purchase	base	ir.module.module
362	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	64	t	module_category_services_timesheets	base	ir.module.category
363	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	294	t	module_hr_timesheet	base	ir.module.module
364	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	295	t	module_hw_drivers	base	ir.module.module
365	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	296	t	module_gamification_sale_crm	base	ir.module.module
366	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	297	t	module_website_event_track_live	base	ir.module.module
367	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	298	t	module_mass_mailing_crm	base	ir.module.module
368	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	299	t	module_pos_stripe	base	ir.module.module
369	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	300	t	module_microsoft_calendar	base	ir.module.module
370	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	301	t	module_website_slides_forum	base	ir.module.module
371	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	302	t	module_http_routing	base	ir.module.module
372	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	303	t	module_l10n_fr_pos_cert	base	ir.module.module
373	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	304	t	module_test_data_module_install	base	ir.module.module
374	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	305	t	module_l10n_uy	base	ir.module.module
375	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	306	t	module_l10n_in_stock	base	ir.module.module
376	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	307	t	module_l10n_it	base	ir.module.module
377	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	308	t	module_l10n_id	base	ir.module.module
378	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	309	t	module_l10n_it_edi_withholding	base	ir.module.module
379	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	65	t	module_category_human_resources_time_off	base	ir.module.category
380	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	310	t	module_hr_holidays	base	ir.module.module
381	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	311	t	module_account_tax_python	base	ir.module.module
382	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	312	t	module_l10n_gr	base	ir.module.module
383	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	313	t	module_mail	base	ir.module.module
384	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	314	t	module_l10n_fi_sale	base	ir.module.module
385	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	315	t	module_test_discuss_full	base	ir.module.module
386	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	316	t	module_portal_rating	base	ir.module.module
387	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	317	t	module_l10n_fr	base	ir.module.module
388	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	318	t	module_theme_clean	base	ir.module.module
389	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	319	t	module_website_customer	base	ir.module.module
390	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	320	t	module_product_expiry	base	ir.module.module
391	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	321	t	module_website_event_exhibitor	base	ir.module.module
392	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	322	t	module_payment_mercado_pago	base	ir.module.module
393	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	323	t	module_website_sale_stock	base	ir.module.module
394	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	324	t	module_base_iban	base	ir.module.module
395	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	325	t	module_payment_demo	base	ir.module.module
396	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	326	t	module_l10n_hk	base	ir.module.module
397	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	327	t	module_payment_authorize	base	ir.module.module
398	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	328	t	module_sale_project_stock	base	ir.module.module
399	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	329	t	module_pos_self_order_sale	base	ir.module.module
400	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	330	t	module_test_read_group	base	ir.module.module
401	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	331	t	module_base_setup	base	ir.module.module
402	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	332	t	module_pos_restaurant	base	ir.module.module
403	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	333	t	module_spreadsheet_dashboard_stock_account	base	ir.module.module
404	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	334	t	module_l10n_kz	base	ir.module.module
405	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	66	t	module_category_services_expenses	base	ir.module.category
406	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	335	t	module_project_hr_expense	base	ir.module.module
407	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	336	t	module_website_mail	base	ir.module.module
408	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	337	t	module_event_crm	base	ir.module.module
409	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	338	t	module_l10n_ar	base	ir.module.module
410	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	339	t	module_theme_aviato	base	ir.module.module
411	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	340	t	module_payment_sips	base	ir.module.module
412	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	341	t	module_test_base_automation	base	ir.module.module
413	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	342	t	module_theme_vehicle	base	ir.module.module
414	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	343	t	module_sale_purchase	base	ir.module.module
415	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	344	t	module_crm_mail_plugin	base	ir.module.module
416	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	345	t	module_pos_paytm	base	ir.module.module
417	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	346	t	module_theme_buzzy	base	ir.module.module
418	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	347	t	module_l10n_co_pos	base	ir.module.module
419	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	67	t	module_category_human_resources_payroll	base	ir.module.category
420	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	348	t	module_hr_work_entry_holidays	base	ir.module.module
421	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	349	t	module_link_tracker	base	ir.module.module
422	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	350	t	module_hr_skills	base	ir.module.module
423	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	351	t	module_test_themes	base	ir.module.module
424	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	352	t	module_spreadsheet_dashboard_sale	base	ir.module.module
425	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	353	t	module_mass_mailing_event_track	base	ir.module.module
426	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	354	t	module_iap_mail	base	ir.module.module
427	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	68	t	module_category_accounting_localizations_reporting	base	ir.module.category
428	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	355	t	module_l10n_fr_fec	base	ir.module.module
429	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	356	t	module_google_gmail	base	ir.module.module
430	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	357	t	module_project	base	ir.module.module
431	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	358	t	module_hr	base	ir.module.module
432	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	359	t	module_l10n_tw	base	ir.module.module
433	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	360	t	module_website_forum	base	ir.module.module
434	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	361	t	module_website_sale_slides	base	ir.module.module
435	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	362	t	module_l10n_pe	base	ir.module.module
436	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	363	t	module_account_test	base	ir.module.module
437	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	364	t	module_l10n_pk	base	ir.module.module
438	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	365	t	module_membership	base	ir.module.module
439	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	366	t	module_product_email_template	base	ir.module.module
440	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	367	t	module_payment_alipay	base	ir.module.module
441	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	368	t	module_resource	base	ir.module.module
442	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	369	t	module_theme_paptic	base	ir.module.module
443	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	370	t	module_l10n_latam_invoice_document	base	ir.module.module
444	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	371	t	module_pos_sale_margin	base	ir.module.module
445	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	372	t	module_event_crm_sale	base	ir.module.module
446	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	373	t	module_sale	base	ir.module.module
447	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	374	t	module_pos_restaurant_stripe	base	ir.module.module
448	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	375	t	module_test_apikeys	base	ir.module.module
449	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	376	t	module_test_base_import	base	ir.module.module
450	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	377	t	module_base_geolocalize	base	ir.module.module
451	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	378	t	module_l10n_pt	base	ir.module.module
452	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	379	t	module_account_edi_proxy_client	base	ir.module.module
453	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	380	t	module_l10n_jp	base	ir.module.module
454	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	381	t	module_l10n_bg	base	ir.module.module
455	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	382	t	module_l10n_se	base	ir.module.module
456	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	383	t	module_website_livechat	base	ir.module.module
457	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	384	t	module_website_event_meet	base	ir.module.module
458	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	385	t	module_l10n_mz	base	ir.module.module
459	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	386	t	module_l10n_es_edi_tbai	base	ir.module.module
460	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	387	t	module_test_auth_custom	base	ir.module.module
461	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	388	t	module_payment_stripe	base	ir.module.module
462	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	69	t	module_category_productivity_to-do	base	ir.module.category
463	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	389	t	module_project_todo	base	ir.module.module
464	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	390	t	module_digest	base	ir.module.module
465	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	391	t	module_test_inherit	base	ir.module.module
466	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	392	t	module_crm_iap_mine	base	ir.module.module
467	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	393	t	module_l10n_cn	base	ir.module.module
468	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	394	t	module_sale_product_matrix	base	ir.module.module
469	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	395	t	module_phone_validation	base	ir.module.module
470	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	396	t	module_l10n_uk	base	ir.module.module
471	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	397	t	module_sale_loyalty_delivery	base	ir.module.module
472	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	70	t	module_category_theme_education	base	ir.module.category
473	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	398	t	module_theme_bewise	base	ir.module.module
474	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	399	t	module_web_editor	base	ir.module.module
475	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	400	t	module_website_event_track_quiz	base	ir.module.module
476	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	401	t	module_hr_livechat	base	ir.module.module
477	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	402	t	module_base_install_request	base	ir.module.module
478	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	403	t	module_pos_sale	base	ir.module.module
479	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	404	t	module_mass_mailing_slides	base	ir.module.module
480	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	71	t	module_category_human_resources_lunch	base	ir.module.category
481	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	405	t	module_lunch	base	ir.module.module
482	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	406	t	module_website_cf_turnstile	base	ir.module.module
483	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	407	t	module_crm	base	ir.module.module
484	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	408	t	module_stock_account	base	ir.module.module
485	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	409	t	module_account_edi	base	ir.module.module
486	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	410	t	module_rating	base	ir.module.module
487	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	411	t	module_spreadsheet_dashboard_pos_hr	base	ir.module.module
488	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	412	t	module_l10n_id_efaktur	base	ir.module.module
489	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	413	t	module_l10n_eg	base	ir.module.module
490	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	414	t	module_theme_graphene	base	ir.module.module
491	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	415	t	module_pos_online_payment_self_order	base	ir.module.module
492	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	416	t	module_website_event_track	base	ir.module.module
493	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	417	t	module_pos_discount	base	ir.module.module
494	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	72	t	module_category_uncategorized	base	ir.module.category
495	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	418	t	module_l10n_fr_hr_work_entry_holidays	base	ir.module.module
496	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	419	t	module_stock	base	ir.module.module
497	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	420	t	module_crm_livechat	base	ir.module.module
498	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	421	t	module_test_translation_import	base	ir.module.module
499	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	422	t	module_test_mass_mailing	base	ir.module.module
500	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	423	t	module_theme_beauty	base	ir.module.module
501	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	424	t	module_theme_orchid	base	ir.module.module
502	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	425	t	module_theme_real_estate	base	ir.module.module
503	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	426	t	module_mrp_subonctracting_landed_costs	base	ir.module.module
504	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	427	t	module_test_search_panel	base	ir.module.module
505	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	428	t	module_base_vat	base	ir.module.module
506	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	73	t	module_category_website_live_chat	base	ir.module.category
507	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	429	t	module_im_livechat	base	ir.module.module
508	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	430	t	module_mass_mailing	base	ir.module.module
509	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	431	t	module_l10n_lv	base	ir.module.module
510	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	432	t	module_l10n_ae	base	ir.module.module
511	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	433	t	module_payment_payulatam	base	ir.module.module
512	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	434	t	module_mrp_product_expiry	base	ir.module.module
513	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	435	t	module_hr_presence	base	ir.module.module
514	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	436	t	module_l10n_eu_oss	base	ir.module.module
515	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	437	t	module_website_sale_stock_wishlist	base	ir.module.module
516	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	438	t	module_mrp_subcontracting_account	base	ir.module.module
517	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	439	t	module_hr_work_entry_contract	base	ir.module.module
518	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	440	t	module_mrp_repair	base	ir.module.module
519	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	441	t	module_test_inherit_depends	base	ir.module.module
520	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	442	t	module_hr_skills_survey	base	ir.module.module
521	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	443	t	module_barcodes_gs1_nomenclature	base	ir.module.module
522	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	444	t	module_theme_bookstore	base	ir.module.module
523	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	445	t	module_l10n_tr	base	ir.module.module
524	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	446	t	module_pos_self_order_adyen	base	ir.module.module
525	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	447	t	module_test_xlsx_export	base	ir.module.module
526	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	448	t	module_l10n_cn_city	base	ir.module.module
527	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	449	t	module_stock_picking_batch	base	ir.module.module
528	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	450	t	module_website_event_booth_sale_exhibitor	base	ir.module.module
529	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	451	t	module_test_lint	base	ir.module.module
530	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	452	t	module_base_import_module	base	ir.module.module
531	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	453	t	module_l10n_hu	base	ir.module.module
532	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	454	t	module_sale_timesheet_margin	base	ir.module.module
533	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	455	t	module_test_rpc	base	ir.module.module
534	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	456	t	module_test_event_full	base	ir.module.module
535	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	457	t	module_website_event_sale	base	ir.module.module
536	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	74	t	module_category_human_resources_expenses	base	ir.module.category
537	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	458	t	module_hr_expense	base	ir.module.module
538	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	459	t	module_auth_totp_mail_enforce	base	ir.module.module
539	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	460	t	module_l10n_fr_hr_holidays	base	ir.module.module
540	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	461	t	module_sale_stock_margin	base	ir.module.module
541	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	462	t	module_sale_mrp	base	ir.module.module
542	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	463	t	module_event	base	ir.module.module
543	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	464	t	module_l10n_fi	base	ir.module.module
544	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	465	t	module_mail_group	base	ir.module.module
545	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	466	t	module_mrp	base	ir.module.module
546	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	75	t	module_category_account	base	ir.module.category
547	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	467	t	module_l10n_eg_edi_eta	base	ir.module.module
548	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	468	t	module_website_membership	base	ir.module.module
549	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	469	t	module_l10n_sa_edi	base	ir.module.module
550	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	470	t	module_crm_sms	base	ir.module.module
551	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	471	t	module_test_inherits_depends	base	ir.module.module
552	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	472	t	module_mrp_subcontracting_dropshipping	base	ir.module.module
553	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	473	t	module_l10n_vn	base	ir.module.module
554	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	474	t	module_website_event_booth_sale	base	ir.module.module
555	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	475	t	module_website_crm_iap_reveal	base	ir.module.module
556	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	476	t	module_website_event_booth	base	ir.module.module
557	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	477	t	module_website_sale_wishlist	base	ir.module.module
558	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	478	t	module_l10n_gcc_invoice_stock_account	base	ir.module.module
559	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	479	t	module_project_mail_plugin	base	ir.module.module
560	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	480	t	module_l10n_fr_facturx_chorus_pro	base	ir.module.module
561	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	481	t	module_pos_online_payment	base	ir.module.module
562	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	482	t	module_theme_default	base	ir.module.module
563	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	483	t	module_theme_loftspace	base	ir.module.module
564	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	484	t	module_account_debit_note	base	ir.module.module
565	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	485	t	module_l10n_ca	base	ir.module.module
566	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	486	t	module_payment_custom	base	ir.module.module
567	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	487	t	module_l10n_th	base	ir.module.module
568	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	488	t	module_purchase	base	ir.module.module
569	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	489	t	module_auth_password_policy_signup	base	ir.module.module
570	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	490	t	module_l10n_ro	base	ir.module.module
571	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	491	t	module_pos_mrp	base	ir.module.module
572	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	76	t	module_category_marketing_surveys	base	ir.module.category
573	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	492	t	module_survey	base	ir.module.module
574	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	493	t	module_l10n_sg	base	ir.module.module
575	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	494	t	module_stock_landed_costs	base	ir.module.module
576	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	495	t	module_website_mail_group	base	ir.module.module
577	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	496	t	module_l10n_in_pos	base	ir.module.module
578	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	497	t	module_spreadsheet_dashboard_hr_expense	base	ir.module.module
579	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	498	t	module_sale_service	base	ir.module.module
580	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	499	t	module_iap	base	ir.module.module
581	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	500	t	module_l10n_in_edi_ewaybill	base	ir.module.module
582	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	501	t	module_crm_iap_enrich	base	ir.module.module
583	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	502	t	module_analytic	base	ir.module.module
584	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	503	t	module_attachment_indexation	base	ir.module.module
585	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	504	t	module_sale_product_configurator	base	ir.module.module
586	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	505	t	module_mass_mailing_sale_sms	base	ir.module.module
587	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	506	t	module_l10n_cz	base	ir.module.module
588	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	507	t	module_payment_paypal	base	ir.module.module
589	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	508	t	module_l10n_in_purchase_stock	base	ir.module.module
590	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	509	t	module_payment_buckaroo	base	ir.module.module
591	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	510	t	module_test_main_flows	base	ir.module.module
592	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	511	t	module_website_sale_product_configurator	base	ir.module.module
593	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	512	t	module_test_website_modules	base	ir.module.module
594	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	513	t	module_l10n_mx	base	ir.module.module
595	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	514	t	module_l10n_do	base	ir.module.module
596	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	515	t	module_pos_sale_loyalty	base	ir.module.module
597	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	77	t	module_category_tests	base	ir.module.category
598	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	516	t	module_test_populate	base	ir.module.module
599	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	517	t	module_website_sms	base	ir.module.module
600	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	518	t	module_website_sale_picking	base	ir.module.module
601	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	519	t	module_mass_mailing_event_track_sms	base	ir.module.module
602	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	520	t	module_l10n_es_edi_sii	base	ir.module.module
603	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	521	t	module_test_assetsbundle	base	ir.module.module
604	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	522	t	module_google_recaptcha	base	ir.module.module
605	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	523	t	module_spreadsheet_dashboard	base	ir.module.module
606	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	524	t	module_website_sale_mondialrelay	base	ir.module.module
607	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	525	t	module_website_profile	base	ir.module.module
608	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	526	t	module_l10n_si	base	ir.module.module
609	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	527	t	module_point_of_sale	base	ir.module.module
610	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	528	t	module_gamification	base	ir.module.module
611	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	529	t	module_l10n_account_edi_ubl_cii_tests	base	ir.module.module
612	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	530	t	module_website_event_meet_quiz	base	ir.module.module
613	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	531	t	module_hr_recruitment_survey	base	ir.module.module
614	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	532	t	module_website_mass_mailing_sms	base	ir.module.module
615	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	78	t	module_category_theme_food	base	ir.module.category
616	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	533	t	module_theme_bistro	base	ir.module.module
617	\N	2024-01-07 05:17:55.104441	2024-01-07 05:17:55.104441	\N	534	t	module_snailmail	base	ir.module.module
618	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	1	f	model_base	base	ir.model
619	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	2	f	model__unknown	base	ir.model
620	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	3	f	model_ir_model	base	ir.model
621	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	4	f	model_ir_model_fields	base	ir.model
622	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	5	f	model_ir_model_inherit	base	ir.model
623	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	6	f	model_ir_model_fields_selection	base	ir.model
624	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	7	f	model_ir_model_constraint	base	ir.model
625	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	8	f	model_ir_model_relation	base	ir.model
626	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	9	f	model_ir_model_access	base	ir.model
627	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	10	f	model_ir_model_data	base	ir.model
628	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	11	f	model_wizard_ir_model_menu_create	base	ir.model
629	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	12	f	model_ir_sequence	base	ir.model
630	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	13	f	model_ir_sequence_date_range	base	ir.model
631	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	14	f	model_ir_ui_menu	base	ir.model
632	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	15	f	model_ir_ui_view_custom	base	ir.model
633	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	16	f	model_ir_ui_view	base	ir.model
634	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	17	f	model_reset_view_arch_wizard	base	ir.model
635	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	18	f	model_ir_asset	base	ir.model
636	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	19	f	model_ir_actions_actions	base	ir.model
637	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	20	f	model_ir_actions_act_window	base	ir.model
638	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	21	f	model_ir_actions_act_window_view	base	ir.model
639	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	22	f	model_ir_actions_act_window_close	base	ir.model
640	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	23	f	model_ir_actions_act_url	base	ir.model
641	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	24	f	model_ir_actions_server	base	ir.model
642	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	25	f	model_ir_actions_todo	base	ir.model
643	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	26	f	model_ir_actions_client	base	ir.model
644	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	27	f	model_ir_actions_report	base	ir.model
645	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	28	f	model_ir_attachment	base	ir.model
646	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	29	f	model_ir_binary	base	ir.model
647	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	30	f	model_ir_cron	base	ir.model
648	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	31	f	model_ir_cron_trigger	base	ir.model
649	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	32	f	model_ir_filters	base	ir.model
650	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	33	f	model_ir_default	base	ir.model
651	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	34	f	model_ir_exports	base	ir.model
652	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	35	f	model_ir_exports_line	base	ir.model
653	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	36	f	model_ir_rule	base	ir.model
654	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	37	f	model_ir_config_parameter	base	ir.model
655	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	38	f	model_ir_autovacuum	base	ir.model
656	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	39	f	model_ir_mail_server	base	ir.model
657	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	40	f	model_ir_fields_converter	base	ir.model
658	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	41	f	model_ir_qweb	base	ir.model
659	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	42	f	model_ir_qweb_field	base	ir.model
660	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	43	f	model_ir_qweb_field_integer	base	ir.model
661	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	44	f	model_ir_qweb_field_float	base	ir.model
662	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	45	f	model_ir_qweb_field_date	base	ir.model
663	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	46	f	model_ir_qweb_field_datetime	base	ir.model
664	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	47	f	model_ir_qweb_field_text	base	ir.model
665	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	48	f	model_ir_qweb_field_selection	base	ir.model
666	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	49	f	model_ir_qweb_field_many2one	base	ir.model
667	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	50	f	model_ir_qweb_field_many2many	base	ir.model
668	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	51	f	model_ir_qweb_field_html	base	ir.model
669	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	52	f	model_ir_qweb_field_image	base	ir.model
670	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	53	f	model_ir_qweb_field_image_url	base	ir.model
671	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	54	f	model_ir_qweb_field_monetary	base	ir.model
672	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	55	f	model_ir_qweb_field_float_time	base	ir.model
673	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	56	f	model_ir_qweb_field_time	base	ir.model
674	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	57	f	model_ir_qweb_field_duration	base	ir.model
675	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	58	f	model_ir_qweb_field_relative	base	ir.model
676	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	59	f	model_ir_qweb_field_barcode	base	ir.model
677	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	60	f	model_ir_qweb_field_contact	base	ir.model
678	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	61	f	model_ir_qweb_field_qweb	base	ir.model
679	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	62	f	model_ir_http	base	ir.model
680	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	63	f	model_ir_logging	base	ir.model
681	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	64	f	model_ir_property	base	ir.model
682	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	65	f	model_ir_module_category	base	ir.model
683	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	66	f	model_ir_module_module	base	ir.model
684	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	67	f	model_ir_module_module_dependency	base	ir.model
685	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	68	f	model_ir_module_module_exclusion	base	ir.model
686	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	69	f	model_ir_demo	base	ir.model
687	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	70	f	model_ir_demo_failure	base	ir.model
688	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	71	f	model_ir_demo_failure_wizard	base	ir.model
689	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	72	f	model_report_layout	base	ir.model
690	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	73	f	model_report_paperformat	base	ir.model
691	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	74	f	model_ir_profile	base	ir.model
692	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	75	f	model_base_enable_profiling_wizard	base	ir.model
693	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	76	f	model_image_mixin	base	ir.model
694	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	77	f	model_avatar_mixin	base	ir.model
695	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	78	f	model_res_country	base	ir.model
696	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	79	f	model_res_country_group	base	ir.model
697	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	80	f	model_res_country_state	base	ir.model
698	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	81	f	model_res_lang	base	ir.model
699	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	82	f	model_format_address_mixin	base	ir.model
700	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	83	f	model_res_partner_category	base	ir.model
701	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	84	f	model_res_partner_title	base	ir.model
702	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	85	f	model_res_partner	base	ir.model
703	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	86	f	model_res_partner_industry	base	ir.model
704	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	87	f	model_res_bank	base	ir.model
705	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	88	f	model_res_partner_bank	base	ir.model
706	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	89	f	model_res_config	base	ir.model
707	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	90	f	model_res_config_installer	base	ir.model
708	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	91	f	model_res_config_settings	base	ir.model
709	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	92	f	model_res_currency	base	ir.model
710	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	93	f	model_res_currency_rate	base	ir.model
711	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	94	f	model_res_company	base	ir.model
712	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	95	f	model_res_groups	base	ir.model
713	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	96	f	model_res_users_log	base	ir.model
714	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	97	f	model_res_users	base	ir.model
715	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	98	f	model_res_users_identitycheck	base	ir.model
716	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	99	f	model_change_password_wizard	base	ir.model
717	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	100	f	model_change_password_user	base	ir.model
718	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	101	f	model_change_password_own	base	ir.model
719	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	102	f	model_res_users_apikeys	base	ir.model
720	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	103	f	model_res_users_apikeys_description	base	ir.model
721	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	104	f	model_res_users_apikeys_show	base	ir.model
722	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	105	f	model_res_users_settings	base	ir.model
723	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	106	f	model_res_users_deletion	base	ir.model
724	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	107	f	model_decimal_precision	base	ir.model
725	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	108	f	model_report_base_report_irmodulereference	base	ir.model
726	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	109	f	model_base_module_update	base	ir.model
727	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	110	f	model_base_language_install	base	ir.model
728	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	111	f	model_base_language_import	base	ir.model
729	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	112	f	model_base_module_upgrade	base	ir.model
730	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	113	f	model_base_module_uninstall	base	ir.model
731	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	114	f	model_base_language_export	base	ir.model
732	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	115	f	model_base_partner_merge_line	base	ir.model
733	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\N	116	f	model_base_partner_merge_automatic_wizard	base	ir.model
734	\N	2024-01-07 05:18:12.878639	2024-01-07 05:18:12.878639	\